<?php
/**
 * Order tracking
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/order/tracking.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 10.1.0
 */

defined( 'ABSPATH' ) || exit;

$notes = $order->get_customer_order_notes();

$order_id = $order->get_id();

do_action( 'dina_before_view_order', $order_id );
?>

<p class="order-info">
	<?php
	$order_time = $order->get_date_created()->date( 'H:i' );
	echo wp_kses_post(
		/**
		 * Filter to modify order tracking status text.
		 *
		 * @param string $order_status The order status text.
		 *
		 * @since 10.1.0
		 */
		apply_filters(
			'woocommerce_order_tracking_status',
			sprintf(
				/* translators: 1: order number 2: order date 3: order status */
				esc_html__( 'Order #%1$s was placed on %2$s at %3$s and is currently %4$s.', 'dina-kala' ),
				'<mark class="order-number">' . $order->get_order_number() . '</mark>',
				'<mark class="order-date">' . wc_format_datetime( $order->get_date_created() ) . '</mark>',
				'<mark class="order-time">' . esc_html( $order_time ) . '</mark>', // ساعت ثبت سفارش
				'<mark class="order-status">' . wc_get_order_status_name( $order->get_status() ) . '</mark>'
			),
			$order
		)
	);
	?>
</p>

<?php if ( $notes ) : ?>
	<h2><?php esc_html_e( 'Order updates', 'dina-kala' ); ?></h2>
	<ol class="commentlist notes">
		<?php foreach ( $notes as $note ) : ?>
		<li class="comment note">
			<div class="comment_container">
				<div class="comment-text">
					<p class="meta"><?php echo date_i18n( esc_html__( 'l jS \o\f F Y, h:ia', 'dina-kala' ), strtotime( $note->comment_date ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></p>
					<div class="description">
						<?php echo wpautop( wptexturize( $note->comment_content ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
					</div>
					<div class="clear"></div>
				</div>
				<div class="clear"></div>
			</div>
		</li>
		<?php endforeach; ?>
	</ol>
<?php endif; ?>

<?php do_action( 'woocommerce_view_order', $order->get_id() ); ?>
