<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
if ( ! defined( 'ABSPATH' ) ) exit;

// Exit early if sidebar is not active
if ( ! is_active_sidebar( 'shop-sidebar' ) ) {
    return;
}

// Sticky sidebar class
$side_sticky = dina_opt( 'side_sticky' ) ? ' sidesticky' : '';

// Flags
$should_show_sidebar = false;
$sidebar_id = 'shop-sidebar'; // Default sidebar

// Product single page
if ( is_singular( 'product' ) ) {
    $pside = get_post_meta( get_the_ID(), 'dina_pside', true );

    if ( in_array( $pside, ['rside', 'lside'] ) || ( $pside !== 'wside' && dina_opt( 'product_side' ) > 0 ) ) {
        $should_show_sidebar = true;
        $sidebar_id = dina_opt( 'product_page_side' ) ? 'product-sidebar' : 'shop-sidebar';
    }

// WooCommerce archive pages (product categories, tags, shop page)
} elseif ( is_archive() && class_exists( 'WooCommerce' ) && is_woocommerce() ) {
    $archive_sidebar = dina_get_archive_sidebar_setting();

    if ( in_array( $archive_sidebar, ['rside', 'lside'] ) || ( empty( $archive_sidebar ) && dina_opt( 'product_archive_side' ) != 0 ) ) {
        $should_show_sidebar = true;
        $sidebar_id = ( dina_opt( 'shop_page_side' ) && is_shop() ) ? 'shop-page-sidebar' : 'shop-sidebar';
    }
}

// Render the sidebar if needed
if ( $should_show_sidebar ) :
?>

<aside id="dinaSidebar" class="col-lg-3 sidebar<?php echo esc_attr( $side_sticky ); ?>">
    <div class="side-head">
        <a href="javascript:void(0)" class="mclosebtn" aria-label="<?php esc_attr_e( 'Close', 'dina-kala' ); ?>" data-title="<?php esc_attr_e( 'Close', 'dina-kala' ); ?>" rel="nofollow" onclick="closeSide()">
            <i class="fal fa-times" aria-hidden="true"></i>
        </a>
    </div>
    <?php dynamic_sidebar( $sidebar_id ); ?>
</aside>

<div id="dinaCanvasSide" class="overlay3" onclick="closeSide()"></div>

<?php endif; ?>