<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Demo Website: dinakala.i-design.ir
Author Website: i-design.ir
*/

//  Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

// Display name
function dina_display_name_shortcode() {
    $user = wp_get_current_user();
    $display_name = $user->display_name;
    return $display_name;
}
add_shortcode( 'dina_display_name', 'dina_display_name_shortcode' );

// First name
function dina_first_name_shortcode() {
    $user = wp_get_current_user();
    $first_name = $user->first_name;
    return $first_name;
}
add_shortcode( 'dina_first_name', 'dina_first_name_shortcode' );

// Last name
function dina_last_name_shortcode() {
    $user = wp_get_current_user();
    $last_name = $user->last_name;
    return $last_name;
}
add_shortcode( 'dina_last_name', 'dina_last_name_shortcode' );

// Shortlink
function dina_short_link_shortcode() {
    $short_link = wp_get_shortlink();
    return $short_link;
}
add_shortcode( 'dina_short_link', 'dina_short_link_shortcode' );

// Title
function dina_title_shortcode() {
    $title = get_the_title();
    return $title;
}
add_shortcode( 'dina_title', 'dina_title_shortcode' );

// Site title
function dina_site_title_shortcode() {
    $site_title = get_bloginfo( 'name' );
    return $site_title;
}
add_shortcode( 'dina_site_title', 'dina_site_title_shortcode' );

// Product price
function dina_price_shortcode() {
    $product = wc_get_product( get_the_ID() );
    if ( $product->is_in_stock() || dina_opt( 'show_price_out' ) || show_login_price() ) {
		$product_price = wp_strip_all_tags( $product->get_price_html() );
    } else {
        $product_price = dina_outofstock_text();
    }
    return $product_price;
}
add_shortcode( 'dina_price', 'dina_price_shortcode' );

// Dina order_tracking Shortcode
function dina_order_tracking_code( $atts ) {

    $order_id = $atts['order_id'];

    if ( empty ( $order_id ) )
        return;

    $order = wc_get_order( apply_filters( 'dina_shortcode_order_tracking_order_id', $order_id ) );

    if ( ! $order ) 
        return;

    $tracking_code = $order->get_meta( 'tracking_column' );
    
    return $tracking_code;
}
add_shortcode( 'dina_order_tracking_code', 'dina_order_tracking_code' );

// Dina aparat video shortcode
function dina_aparat_video( $atts ) {
    if ( empty ( $atts['id'] ) )
        return;
   
    return '<div class="h_iframe-aparat_embed_frame"><span style="display: block;padding-top: 57%"></span><iframe src="https://www.aparat.com/video/video/embed/videohash/'. $atts['id'] .'/vt/frame" title="'. get_the_title( get_the_ID() ) .'" allowFullScreen="true" webkitallowfullscreen="true" mozallowfullscreen="true"></iframe></div>';
}
add_shortcode( 'dina_aparat', 'dina_aparat_video' );

// Dina today date
function dina_date_shortcode( $atts ) {

    $format = isset ( $atts['format'] ) ? $atts['format'] : '';
    
    switch ( $format ) {
        case 1:
            $format = ! is_rtl() ? 'l, j F Y' : 'l، j F Y';
            break;
        case 2:
            $format = 'j F Y';
            break;
        case 3:
            $format = ! is_rtl() ? 'j/m/Y' : 'Y/m/j';
            break;
        default:
            $format = ! is_rtl() ? 'l, j F Y' : 'l، j F Y';
    }

    $output = dina_date( $format );

    if ( ! empty ( $atts['farsi'] ) )
        $output = '<span class="dina-farsi">'. $output .'</span>';

    return $output;
}
add_shortcode( 'dina_date', 'dina_date_shortcode' );

// dina_update_date_shortcode
function dina_update_date_shortcode( $atts ) {

    $format = isset ( $atts['format'] ) ? $atts['format'] : '';

    switch ( $format ) {
        case 1:
            $format = ! is_rtl() ? 'l, j F Y' : 'l، j F Y';
            break;
        case 2:
            $format = 'j F Y';
            break;
        case 3:
            $format = ! is_rtl() ? 'j/m/Y' : 'Y/m/j';
            break;
        default:
            $format = ! is_rtl() ? 'l, j F Y' : 'l، j F Y';
    }

    $lang   = get_bloginfo("language");
    $output = ( $lang == 'fa-IR' ? get_the_modified_time( $format ) : get_post_modified_time( $format ) );

    if ( ! empty ( $atts['farsi'] ) )
        $output = '<span class="dina-farsi">'. $output .'</span>';

    return $output;
}
add_shortcode( 'dina_update_date', 'dina_update_date_shortcode' );

// dina_date
function dina_date( $format, $timestamp = null ) {
    dina_set_wp_timezone();
    if( ! is_rtl() ) {
        $date = date( $format, $timestamp );
    } elseif ( function_exists( 'eng_number' ) ) {
		$date = parsidate( $format, $timestamp );
	} elseif ( function_exists( 'wp_date' ) ) {
		$date = wp_date( $format, $timestamp );
	} elseif ( function_exists( 'jdate' ) ) {
        $date = jdate( $format, $timestamp );
    } elseif ( function_exists( 'wpp_jdate' ) ) {
        $date = wpp_jdate( $format, $timestamp );
    } else {
		$date = date( $format, $timestamp );
	}

    return $date;
}

// Dina user btns shortcode
function dina_user_btns_shortcode( $atts ) {
    $atts = shortcode_atts(
        array(
            'text_style' => 'false',
        ),
        $atts,
        'dina_user_btns'
    );
    $user_btn_style = filter_var( $atts['text_style'], FILTER_VALIDATE_BOOLEAN );
    if ( ! is_user_logged_in() ) {
        ob_start(); ?>
        <div class="dina-user-btns-shortcode">
            <?php
            $button_link = dina_opt( 'ch_login_link' ) ? 'href="'. dina_opt( 'login_link' ) .'"' : 'href="javascript:void(0)" onclick="openLogin()"';
            $button_class = $user_btn_style ? 'register-link merge-btn' : 'btn btn-success dina-btn-register merge-btn';
            ?>
            <a title="<?php _e( 'Login Or Register', 'dina-kala' ); ?>" <?= $button_link; ?> class="<?= $button_class ?>">
                <i aria-hidden="true" class="fal fa-user"></i>
                <span><?php _e( 'Login | Register', 'dina-kala' ); ?></span>
            </a>
        </div>
    <?php
    }
    return ob_get_clean();
}
add_shortcode( 'dina_user_btns', 'dina_user_btns_shortcode' );

// Dina woocommerce product shortcode
function dina_woo_product_shortcode( $atts ) {
    $atts = shortcode_atts(
        array(
            'id'          => 0,
            'show_price'  => 'true',
            'show_attr'   => 'true',
            'attr_style'  => 1,
            'attr_count'  => 5,
            'show_buy'    => 'true',
        ),
        $atts,
        'dina_woo_product'
    );

    $product_id   = absint( $atts['id'] );
    $show_price   = filter_var( $atts['show_price'], FILTER_VALIDATE_BOOLEAN );
    $show_attr    = filter_var( $atts['show_attr'], FILTER_VALIDATE_BOOLEAN );
    $attr_style   = absint( $atts['attr_style'] );
    $attr_count   = absint( $atts['attr_count'] );
    $show_buy     = filter_var( $atts['show_buy'], FILTER_VALIDATE_BOOLEAN );

    if ( ! class_exists( 'WooCommerce' ) || ! $product_id ) {
        error_log( 'WooCommerce not active or invalid product ID: ' . $product_id );
        return '';
    }

    $product = wc_get_product( $product_id );
    if ( ! $product || ! is_a( $product, 'WC_Product' ) ) {
        error_log( 'Product not found for ID: ' . $product_id );
        return '';
    }

    global $post, $product;
    $original_post = $post;
    $post = get_post( $product_id );
    setup_postdata( $post );
    $product = wc_get_product( $product_id );

    if ( $show_price ) {
        wp_enqueue_style( 'woocommerce-frontend-styles' );
    }

    ob_start();
    ?>
    <div class="row dina-woo-product shadow-box<?= ! $show_attr ? ' dina-woo-product-no-attr' : '' ?>">
        <div class="<?= $show_attr ? 'col-md-6 col-12' : 'col-12' ?> dina-woo-product-image">
            <a href="<?= esc_url( get_permalink( $product->get_id() ) ); ?>" title="<?= esc_attr( $product->get_name() ); ?>" target="_blank">
                <?= wp_kses_post( $product->get_image( 'woocommerce_thumbnail' ) ); ?>
            </a>
        </div>
        
            <div class="<?= $show_attr ? 'col-md-6 col-12' : 'col-12' ?> dina-woo-product-attr">

                <div class="col-12 dina-woo-product-title">
                    <?php echo esc_html( $product->get_name() ); ?>
                </div>

                <?php
                if ( $show_attr ) :
                    if ( $attr_style === 1 && function_exists( 'dina_get_product_attributes' ) ) {
                        echo wp_kses_post( dina_get_product_attributes( $product->get_id(), $attr_count, false, false ) );
                    } elseif ( $attr_style === 2 && function_exists( 'dina_product_features' ) ) {
                        echo wp_kses_post( dina_product_features( $product->get_id(), $attr_count, false, false ) );
                    } elseif ( $attr_style === 3 ) {
                        $excerpt = $product->get_short_description();
                        if ( ! empty( $excerpt ) ) {
                            echo wp_kses_post( wpautop( $excerpt ) );
                        }
                    } else {
                        if ( function_exists( 'dina_get_product_attributes' ) ) {
                            echo wp_kses_post( dina_get_product_attributes( $product->get_id(), $attr_count, false, false ) );
                        }
                    }
                endif;
                ?>

                <?php if ( $show_price && function_exists( 'woocommerce_template_single_price' ) ) : ?>
                    <div class="dina-woo-product-price">
                        <?php woocommerce_template_single_price(); ?>
                    </div>
                <?php endif; ?>

                <?php if ( $show_buy ) : ?>
                    <div class="dina-woo-product-buy">
                        <a class="btn btn-success button" href="<?= esc_url( get_permalink( $product->get_id() ) ); ?>" target="_blank">
                            <i class="fal fa-cart-plus" aria-hidden="true"></i>
                            <?php esc_html_e( 'View And Buy', 'dina-kala' ); ?>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        
    </div>
    <?php
    $post = $original_post;
    setup_postdata( $post );

    return ob_get_clean();
}
add_shortcode( 'dina_woo_product', 'dina_woo_product_shortcode' );