<?php
//dina_back_top_btn
function dina_nav_back_top_btn( $mftitle, $center_class = false ) {
    
    if ( dina_check_sidebar() == 2 ) { ?>            
        <li class="open-side<?= $center_class ?>" onclick="openSide()">
            <span aria-hidden="true" class="fal fa-filter f-icon" title="<?php _e( 'Show filters', 'dina-kala' ); ?>"></span>
            <?php if ( ! $mftitle ) { ?>
                <span class="mf-title"><?php _e( 'Filters', 'dina-kala' ); ?></span>
            <?php } ?>
        </li>
        <?php } elseif ( dina_check_sidebar() == 1 ) { ?>
        <li class="open-side<?= $center_class ?>" onclick="openSide()">
            <span aria-hidden="true" class="fal fa-ellipsis-h f-icon" title="<?php _e( 'Show sidebar', 'dina-kala' ); ?>">
            </span>
            <?php if ( ! $mftitle ) { ?>
                <span class="mf-title"><?php _e( 'Sidebar', 'dina-kala' ); ?></span>
            <?php } ?>
        </li>
        <?php } else { ?>
            <?php if ( ! dina_opt( 'ch_back_top_btn' ) ) { ?>
                <li class="return-top<?= $center_class ?>">
                    <span aria-hidden="true" class="fal fa-chevron-up f-icon" title="<?php _e( 'Return Top', 'dina-kala' ); ?>">
                    </span>
                    <?php if ( ! $mftitle ) { ?>
                        <span class="mf-title"><?php _e( 'Return', 'dina-kala' ); ?></span>
                    <?php } ?>
                </li>
            <?php } else { ?>
                <li class="return-top-custom<?= $center_class ?>">
                    <a href="<?php echo dina_opt( 'back_top_btn_link' ); ?>" title="<?php echo dina_opt( 'back_top_btn_title' ); ?>">
                        <span aria-hidden="true" class="f-icon <?php echo dina_opt( 'back_top_btn_icon' ); ?>" title="<?php echo dina_opt( 'back_top_btn_title' ); ?>">
                        </span>
                        <?php if ( ! $mftitle ) { ?>
                            <span class="mf-title"><?php echo dina_opt( 'back_top_btn_title' ); ?></span>
                        <?php } ?>
                    </a>
                </li>
            <?php } 
        }
}

//dina_nav_wishlist_btn
function dina_nav_wishlist_btn( $mftitle, $center_class = false ) {
    
    if ( ! dina_opt( 'ch_whish_btn' ) ) { 
        
        if ( dina_opt( 'show_wish_list' ) ) { 
            if ( class_exists( 'WooCommerce' ) && class_exists( 'YITH_WCWL' ) ) {
                $wcwl_url = esc_url( YITH_WCWL()->get_wishlist_url() ); ?>
                <li class="dina-nav-wishlist<?= $center_class ?>">
                    <a href="<?php echo $wcwl_url; ?>" title="<?php _e( 'Wishlist', 'dina-kala' ); ?>" rel="nofollow">
                        <span aria-hidden="true" class="<?= dina_opt( 'head_wish_list_icon' ) ?> f-icon" title="<?php _e( 'Wishlist', 'dina-kala' ); ?>">
                            <span class="wish-amount">
                                <?php echo do_shortcode( '[yith_wcwl_items_count]' ); ?>
                            </span>
                        </span>
                        <?php if ( !$mftitle ) { ?>
                            <span class="mf-title"><?php _e( 'Wishlist ', 'dina-kala' ); ?></span>
                        <?php } ?>
                    </a>
                </li>
        <?php 
            } 
        } ?>
    <?php } else { ?>
        <li class="dina-nav-wishlist-custom<?= $center_class ?>">
            <a href="<?php echo dina_opt( 'whish_btn_link' ); ?>" title="<?php echo dina_opt( 'whish_btn_title' ); ?>">
                <span aria-hidden="true" class="f-icon <?php echo dina_opt( 'whish_btn_icon' ); ?>" title="<?php echo dina_opt( 'whish_btn_title' ); ?>">
                </span>
                <?php if ( !$mftitle ) { ?>
                    <span class="mf-title"><?php echo dina_opt( 'whish_btn_title' ); ?></span>
                <?php } ?>
            </a>
        </li>
    <?php }
}

//dina_nav_home_buy_btn
function dina_nav_home_buy_btn( $mftitle, $center_class = false ) {
    
    if ( is_singular( 'product' ) && ! dina_opt( 'mobile_sticky_add' ) ) { ?>
        <li class="go-to-add<?= $center_class ?>">
            <span aria-hidden="true" class="fal fa-cart-plus f-icon" title="<?php _e( 'Add to cart', 'dina-kala' ); ?>">
            </span>
            <?php if ( !$mftitle) { ?>
                <span class="mf-title"><?php _e( 'Buy', 'dina-kala' ); ?></span>
            <?php } ?>
        </li>
        <?php } else { ?>
        <li class="dina-go-to-home<?= $center_class ?>">
            <a href="<?php echo esc_url( home_url() ); ?>" title="<?php bloginfo( 'name' ); ?> | <?php bloginfo( 'description' ); ?>">
                <span aria-hidden="true" class="fal fa-home f-icon" title="<?php _e( 'Home', 'dina-kala' ); ?>">
                </span>
                <?php if ( !$mftitle) { ?>
                    <span class="mf-title"><?php _e( 'Home', 'dina-kala' ); ?></span>
                <?php } ?>
            </a>
        </li>
        <?php }
}

//dina_nav_compare_btn
function dina_nav_compare_btn( $mftitle, $center_class = false ) {
    
    if ( ! dina_opt( 'ch_compare_btn' ) ) { ?>
        <?php 
        if ( class_exists( 'WooCommerce' ) && class_exists( 'YITH_Woocompare' ) ) {
            global $yith_woocompare; ?>
        <li class="dina-yith-compare<?= $center_class ?>">
            <a href="<?php echo $yith_woocompare->obj->view_table_url() ?>" class="compare-link" rel="nofollow" title="<?php _e( 'Compare ', 'dina-kala' ); ?>">
                <span aria-hidden="true" class="<?= dina_opt( 'head_compare_btn_icon' ) ?> f-icon">
                </span>
                <?php if ( !$mftitle ) { ?>
                    <span class="mf-title"><?php _e( 'Compare ', 'dina-kala' ); ?></span>
                <?php } ?>
            </a>
        </li>
        <?php } elseif ( class_exists( 'WooCommerce' ) && defined( 'WCCM_VERISON' ) ) {
        $compare_url = wccm_get_compare_page_link( wccm_get_compare_list() );
        $compare_count = count(wccm_get_compare_list() ); ?>
        <li class="dina-wccm-compare<?= $center_class ?>">
            <a href="<?php echo $compare_url; ?>" class="compare-link" rel="nofollow" title="<?php _e( 'Compare ', 'dina-kala' ); ?>">
                <span aria-hidden="true" class="<?= dina_opt( 'head_compare_btn_icon' ) ?> f-icon">
                    <span class="compare-amount"><?php echo $compare_count; ?></span>
                </span>
                <?php if ( !$mftitle ) { ?>
                    <span class="mf-title"><?php _e( 'Compare ', 'dina-kala' ); ?></span>
                <?php } ?>
            </a>
        </li>
        <?php } ?>
    <?php } else { ?>
        <li class="dina-nav-compare-custom<?= $center_class ?>">
            <a href="<?php echo dina_opt( 'compare_btn_link' ); ?>" title="<?php echo dina_opt( 'compare_btn_title' ); ?>">
                <span aria-hidden="true" class="f-icon <?php echo dina_opt( 'compare_btn_icon' ); ?>"></span>
                <?php if ( !$mftitle ) { ?>
                    <span class="mf-title"><?php echo dina_opt( 'compare_btn_title' ); ?></span>
                <?php } ?>
            </a>
        </li>
    <?php }
}

//dina_nav_cart_btn
function dina_nav_cart_btn( $mftitle, $center_class = false ) {
    
    if ( ! class_exists( 'WooCommerce' ) || dina_opt( 'product_catalog_mode' ) ) 
        return;
    ?>
        <?php if ( ! dina_opt( 'direct_cart_link' ) ) { ?>
            <li class="dina-nav-cart<?= $center_class ?>" onclick="dinaOpenCart()">
                <span aria-hidden="true" class="<?= dina_opt( 'head_cart_btn_icon' ) ?> f-icon" title="<?php _e( 'Shopping Cart', 'dina-kala' ); ?>">
                    <span class="dina-cart-amount">
                        <?php echo dina_cart_amount() ?></span>
                    </span>
                <?php if ( ! $mftitle ) { ?>
                    <span class="mf-title"><?php _e( 'Cart', 'dina-kala' ); ?></span>
                <?php } ?>
            </li>
        <?php } else { ?>
            <li class="dina-nav-cart<?= $center_class ?>">
                <a href="<?php echo wc_get_cart_url() ?>" title="<?php _e( 'Shopping Cart', 'dina-kala' ); ?>">
                    <span aria-hidden="true" class="<?= dina_opt( 'head_cart_btn_icon' ) ?> f-icon">
                        <span class="dina-cart-amount">
                            <?php echo dina_cart_amount() ?></span>
                        </span>
                    <?php if ( ! $mftitle ) { ?>
                        <span class="mf-title"><?php _e( 'Cart', 'dina-kala' ); ?></span>
                    <?php } ?>
                </a>
            </li>
        <?php } ?>
    <?php
}

//dina_nav_menu_btn
function dina_nav_menu_btn( $mftitle, $center_class = false ) {
    ?>
        <li class="dina-nav-menu<?= $center_class ?>" onclick="openNav()">
            <span aria-hidden="true" class="fal fa-bars f-icon" title="<?php _e( 'Menu', 'dina-kala' ); ?>">
            </span>
            <?php if ( ! $mftitle ) { ?>
            <span class="mf-title"><?php _e( 'Menu', 'dina-kala' ); ?></span>
            <?php } ?>
        </li>
    <?php
}

//dina_nav_menu_btn
function dina_nav_dark_mode( $mftitle, $center_class = false ) {
    if ( dina_opt( 'dina_dark_mode' ) ) {
    ?>
        <li class="btn-di-toggle di-toggle-mobile<?= $center_class ?>" onclick="dinaToggleDarkMode()">
            <span aria-hidden="true" class="di-toggle-icon dina-toggle-dark <?= dina_opt( 'toggle_dark_icon' ) ?> f-icon" title="<?php _e( 'Dark mode', 'dina-kala' ); ?>"></span>
            <span aria-hidden="true" class="di-toggle-icon dina-toggle-light <?= dina_opt( 'toggle_light_icon' ) ?> f-icon" title="<?php _e( 'Light mode', 'dina-kala' ); ?>"></span>
            <?php if ( ! $mftitle ) { ?>
            <span class="mf-title"><?php _e( 'Dark mode', 'dina-kala' ); ?></span>
            <?php } ?>
        </li>
    <?php
    }
}

//dina_nav_my_account_btn
function dina_nav_my_account_btn( $mftitle, $center_class = false ) {
    if ( ! is_user_logged_in() ) {
        if (function_exists( 'digits_version' ) && dina_opt( 'digits_mode' ) ) {
            $digits_mode = ( dina_opt( 'digits_page' ) ? ' digitlink' : ' digitpopup' ); ?>
            <li class="digitsbtn<?php echo $digits_mode; ?><?= $center_class ?>">
                <span aria-hidden="true" class="fal fa-user f-icon" title="<?php _e( 'My Account', 'dina-kala' ); ?>"></span>
                <?php if ( ! $mftitle ) { ?>
                <span class="mf-title"><?php _e( 'My Account', 'dina-kala' ); ?></span>
                <?php } ?>
            </li>
        <?php } else { ?>
            <li class="dina-nav-user-btns<?= $center_class ?>">
                <a title="<?php _e( 'My Account', 'dina-kala' ); ?>" <?php if ( dina_opt( 'ch_login_link' ) ) { echo 'href="'. dina_opt( 'login_link' ) .'"'; } else { echo 'rel="nofollow" href="javascript:void(0)" onclick="openLogin()"'; } ?>>
                    <span aria-hidden="true" class="fal fa-user f-icon" title="<?php _e( 'My Account', 'dina-kala' ); ?>"></span>
                    <?php if ( ! $mftitle ) { ?>
                    <span class="mf-title"><?php _e( 'My Account', 'dina-kala' ); ?></span>
                    <?php } ?>
                </a>
            </li>
        <?php } ?>
    <?php } else { ?>
        <li class="dina-nav-user-menu<?= $center_class ?>" onclick="openUmenu()">
            <span aria-hidden="true" class="fal fa-user f-icon" title="<?php _e( 'User Menu', 'dina-kala' ); ?>"></span>
            <?php if ( ! $mftitle ) { ?>
            <span class="mf-title"><?php _e( 'User Menu', 'dina-kala' ); ?></span>
            <?php } ?>
        </li>
    <?php }
}

//dina_back_top_btn
function dina_nav_custom_btn_one( $mftitle, $center_class = false ) {
     ?>
    <li class="dina-nav-custom-btn-one<?= $center_class ?>">
        <a href="<?php echo dina_opt( 'mobile_nav_btn_one_link' ); ?>" title="<?php echo dina_opt( 'mobile_nav_btn_one_title' ); ?>">
            <span aria-hidden="true" class="f-icon <?php echo dina_opt( 'mobile_nav_btn_one_icon' ); ?>" title="<?php echo dina_opt( 'mobile_nav_btn_one_title' ); ?>">
            </span>
            <?php if ( ! $mftitle ) { ?>
                <span class="mf-title"><?php echo dina_opt( 'mobile_nav_btn_one_title' ); ?></span>
            <?php } ?>
        </a>
    </li>
    <?php
}

//dina_nav_custom_btn_two
function dina_nav_custom_btn_two( $mftitle, $center_class = false ) {
     ?>
    <li class="dina-nav-custom-btn-two<?= $center_class ?>">
        <a href="<?php echo dina_opt( 'mobile_nav_btn_two_link' ); ?>" title="<?php echo dina_opt( 'mobile_nav_btn_two_title' ); ?>">
            <span aria-hidden="true" class="f-icon <?php echo dina_opt( 'mobile_nav_btn_two_icon' ); ?>" title="<?php echo dina_opt( 'mobile_nav_btn_two_title' ); ?>">
            </span>
            <?php if ( ! $mftitle ) { ?>
                <span class="mf-title"><?php echo dina_opt( 'mobile_nav_btn_two_title' ); ?></span>
            <?php } ?>
        </a>
    </li>
    <?php
}