<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

// dina_menus_notice
function dina_menus_notice() {
    global $pagenow;
	$admin_pages = [ 'nav-menus.php' ];
    if ( in_array( $pagenow, $admin_pages ) ) {
        ?>
        <div class="notice notice-info is-dismissible">
            <ul style="list-style:disc;padding:0 10px">
                <?php
                _e( '<li>By clicking on any menu item, you can set settings such as icon, label, selection for megamenu image or disable megamenu mode.</li>', 'dina-kala' );
                _e( '<li>If your menu has many items and menu options such as icon, megamenu image, etc. are not saved, you need to increase the max_input_vars variable in the host settings (it is recommended to set it to 10000)</li>', 'dina-kala' );
                _e( '<li>Megamenu style and other menu settings can be done from Appearance > Theme Settings > General Settings > Header Settings > Menu Settings.</li>', 'dina-kala' );
                ?>
            </ul>
        </div>
        <?php
    }
}
add_action( 'admin_notices', 'dina_menus_notice' );

// dina_menu_load_fontawesome_icons
function dina_menu_load_fontawesome_icons() {
    $json_file = DI_DIR . '/includes/assets/json/menu-fa-icons.json';
    $json_data = file_get_contents( $json_file );
    $options   = json_decode( $json_data, true );
    return $options;
}

// dina_enqueue_menu_icon_picker_assets
function dina_enqueue_menu_icon_picker_assets($hook) {
    if ( $hook !== 'nav-menus.php' ) return;

    wp_enqueue_style('dina-menu-icon-picker', DI_URI . '/includes/assets/css/icon-picker.css');
    wp_enqueue_script('dina-menu-icon-picker', DI_URI . '/includes/assets/js/menu-icon-picker.js', ['jquery'], null, true);

    wp_localize_script('dina-menu-icon-picker', 'dinaIconPicker', [
        'ajaxurl' => admin_url('admin-ajax.php'),
        'i18n' => [
            'search'  => __('Search icons...', 'dina-kala'),
            'loading' => __('Loading icons...', 'dina-kala')
        ]
    ]);
}
add_action('admin_enqueue_scripts', 'dina_enqueue_menu_icon_picker_assets');

// dina_menu_load_fontawesome_icons_ajax
function dina_menu_load_fontawesome_icons_ajax() {
    $icons = dina_menu_load_fontawesome_icons();
    wp_send_json($icons);
}
add_action('wp_ajax_load_fontawesome_icons', 'dina_menu_load_fontawesome_icons_ajax');

// dina_menu_item_custom_fields
function dina_menu_item_custom_fields( $item_id, $item ) {

    if ( ! dina_opt( 'remove_menu_icon' ) ) {
	    $menu_item_icon = get_post_meta( $item_id, '_menu_item_icon', true );
    }

	$menu_item_icon_image = get_post_meta( $item_id, '_menu_item_icon_image', true );
    if ( dina_opt( 'mega_style' ) == 'first' ) {
        $menu_item_two_level  = get_post_meta( $item_id, '_menu_item_two_level', true );
    }
	$menu_item_cmega  = get_post_meta( $item_id, '_menu_item_cmega', true );
	$menu_item_cimage = get_post_meta( $item_id, '_menu_item_cimage', true );
	$menu_item_image  = get_post_meta( $item_id, '_menu_item_image', true );
	$menu_item_dlabel = get_post_meta( $item_id, '_menu_item_dlabel', true );

	?>

    <p class="field-custom menu-image description description-wide">
        <label for="edit-menu-item-dlabel-<?php echo $item_id; ?>">
        <?php _e( 'Menu label' , 'dina-kala' ); ?>
        <?php echo '<input type="text" id="edit-menu-item-dlabel-'.$item_id.'" name="menu-item-dlabel['.$item_id.']" class="widefat" value="'.esc_attr( $menu_item_dlabel ).'" />';
        ?>
        </label>
    </p>

    <?php if ( ! dina_opt( 'remove_menu_icon' ) ) { ?>
    <p class="field-custom description description-wide">
        <label>
            <?php _e( 'Menu icon', 'dina-kala' ); ?><br>

            <input
                type="hidden"
                id="edit-menu-item-icon-<?php echo esc_attr( $item_id ); ?>"
                name="menu-item-icon[<?php echo esc_attr( $item_id ); ?>]"
                value="<?php echo esc_attr( $menu_item_icon ); ?>"
                class="menu-item-icon-input"
            >

                <i class="dina-icon-preview <?php echo esc_attr( $menu_item_icon ); ?>"></i>

            <button
                type="button"
                class="button dina-menu-icon-picker-trigger"
                data-target="#edit-menu-item-icon-<?php echo esc_attr( $item_id ); ?>"
            >
                <?php _e( 'Choose Icon', 'dina-kala' ); ?>
            </button>
        </label>
    </p>
    <?php } ?>

    <p class="field-custom menu-icon-image description description-wide">
        <label for="edit-menu-item-icon-image-<?php echo $item_id; ?>">
        <?php
        if ( ! dina_opt( 'remove_menu_icon' ) ) {
            _e( 'Or Custom Icon (Suitable size: 22px by 22px)' , 'dina-kala' );
        } else {
            _e( 'Custom Icon (Suitable size: 22px by 22px)' , 'dina-kala' );
        } ?>
        <?php echo '<input type="text" id="edit-menu-item-icon-image-'.$item_id.'" name="menu-item-icon-image['.$item_id.']" class="widefat code custom_media_url" value="'.esc_attr( $menu_item_icon_image ).'" />';
        ?>
        <input type="button" class="button button-primary custom_media_button" id="custom_media_button" name="menu-item-icon-image-btn[<?php echo $item_id; ?>]" value="<?php _e( 'Select Custom Icon' , 'dina-kala' ); ?>" style="margin-top:5px;" />
        </label>
    </p>

    <?php if ( dina_opt( 'mega_style' ) == 'first' ) { ?>
    <p class="field-custom description description-wide">
         <label for="edit-menu-item-two-level-<?php echo $item_id; ?>">
         <input 
         type="checkbox"
         id="edit-menu-item-two-level-<?= $item_id ?>"
         name="menu-item-two-level[<?= $item_id ?>]"
         class="menu-item-two-level widefat"
         <?=  $menu_item_two_level ? ' checked' : '' ?>
         />
         <?php _e( 'Megamenu mode suitable for menus with two levels', 'dina-kala' ); ?>
         </label>
    </p>
    <?php } ?>

    <p class="field-custom description description-wide">
        <label style="margin-top:5px;float:right;" for="edit-menu-item-cmega-<?php echo $item_id; ?>">
        <?php echo '<input type="checkbox" id="edit-menu-item-cmega-'.$item_id.'" name="menu-item-cmega['.$item_id.']" class="menu-item-cmega widefat"';
        if ( $menu_item_cmega) {echo 'checked';}
        echo '/>';
            ?>
        <?php _e( 'Disable MegaMenu' , 'dina-kala' ); ?>
        </label>
    </p>

    <p class="field-custom description description-wide">
        <label style="margin-top:5px;float:right;" for="edit-menu-item-cimage-<?php echo $item_id; ?>">
        <?php echo '<input type="checkbox" id="edit-menu-item-cimage-'.$item_id.'" name="menu-item-cimage['.$item_id.']" class="menu-item-cimage widefat"';
        if ( $menu_item_cimage) {echo 'checked';}
        echo '/>';
            ?>
        <?php _e( 'Use as Menu Image' , 'dina-kala' ); ?>
        </label>
    </p>

    <p class="field-custom menu-image description description-wide">
        <label for="edit-menu-item-image-<?php echo $item_id; ?>">
        <?php _e( 'Menu Image' , 'dina-kala' ); ?>
        <?php echo '<input type="text" id="edit-menu-item-image-'.$item_id.'" name="menu-item-image['.$item_id.']" class="widefat code custom_media_url" value="'.esc_attr( $menu_item_image ).'" />';
        ?>
        <input type="button" class="button button-primary custom_media_button" id="custom_media_button" name="menu-item-image-btn[<?php echo $item_id; ?>]" value="<?php _e( 'Select Image' , 'dina-kala' ); ?>" style="margin-top:5px;" />
        </label>
    </p>

	<?php
}
add_action( 'wp_nav_menu_item_custom_fields', 'dina_menu_item_custom_fields', 10, 2 );

class rc_dina_custom_menu {

   	// Constructor
   	function __construct() {
        // add custom menu fields to menu
        add_filter( 'wp_setup_nav_menu_item', array( $this, 'dina_add_custom_nav_fields' ) );
        // save menu custom fields
        add_action( 'wp_update_nav_menu_item', array( $this, 'dina_update_custom_nav_fields' ), 10, 3 );
        // edit menu walker
        add_action( 'admin_enqueue_scripts', 'admin_menu_icon_styles' );
   	}
   
    // Add custom fileds
    function dina_add_custom_nav_fields( $menu_item ) {
            
        if ( ! dina_opt( 'remove_menu_icon' ) ) {
            $menu_item->icon = get_post_meta( $menu_item->ID, '_menu_item_icon', true );
        }
        
        $menu_item->icon_image = get_post_meta( $menu_item->ID, '_menu_item_icon_image', true );
        if ( dina_opt( 'mega_style' ) == 'first' ) {
            $menu_item->two_level  = get_post_meta( $menu_item->ID, '_menu_item_two_level', true );
        }
        $menu_item->image  = get_post_meta( $menu_item->ID, '_menu_item_image', true );
        $menu_item->cimage = get_post_meta( $menu_item->ID, '_menu_item_cimage', true );
        $menu_item->cmega  = get_post_meta( $menu_item->ID, '_menu_item_cmega', true );
        $menu_item->dlabel = get_post_meta( $menu_item->ID, '_menu_item_dlabel', true );

        return $menu_item;
    }

    // Save menu custom fields
    function dina_update_custom_nav_fields( $menu_id, $menu_item_db_id, $args ) {
   
        // Check if element is properly sent
        if ( ! dina_opt( 'remove_menu_icon' ) ) {
            if ( isset( $_REQUEST['menu-item-icon'] ) ) {
                $icon_value = $_REQUEST['menu-item-icon'][$menu_item_db_id];
                update_post_meta( $menu_item_db_id, '_menu_item_icon', $icon_value );
            } else {
                $icon_value = "";
                update_post_meta( $menu_item_db_id, '_menu_item_icon', $icon_value );
            }
        }

        if ( isset( $_REQUEST['menu-item-icon-image'] ) ) {
            $icon_image_value = $_REQUEST['menu-item-icon-image'][$menu_item_db_id];
            update_post_meta( $menu_item_db_id, '_menu_item_icon_image', $icon_image_value );
        } else {
             $icon_image_value = "";
            update_post_meta( $menu_item_db_id, '_menu_item_icon_image', $icon_image_value );
        }

        if ( isset( $_REQUEST['menu-item-two-level'][$menu_item_db_id]) ) {       
            $two_level_value = $_REQUEST['menu-item-two-level'][$menu_item_db_id];
            update_post_meta( $menu_item_db_id, '_menu_item_two_level', $two_level_value );
        } else {
            $two_level_value = "";
            update_post_meta( $menu_item_db_id, '_menu_item_two_level', $two_level_value );
        }

        if ( isset( $_REQUEST['menu-item-dlabel'][$menu_item_db_id] ) ) {
            $dlabel_value = $_REQUEST['menu-item-dlabel'][$menu_item_db_id];
            update_post_meta( $menu_item_db_id, '_menu_item_dlabel', $dlabel_value );
        } else {
            $dlabel_value = "";
            update_post_meta( $menu_item_db_id, '_menu_item_dlabel', $dlabel_value );
        }

        if ( isset( $_REQUEST['menu-item-image'][$menu_item_db_id] ) ) {
           $image_value = $_REQUEST['menu-item-image'][$menu_item_db_id];
           update_post_meta( $menu_item_db_id, '_menu_item_image', $image_value );
        } else {
           $image_value = "";
           update_post_meta( $menu_item_db_id, '_menu_item_image', $image_value );
        }

        if ( isset( $_REQUEST['menu-item-cimage'][$menu_item_db_id] ) ) {
           $cimage_value = $_REQUEST['menu-item-cimage'][$menu_item_db_id];
           update_post_meta( $menu_item_db_id, '_menu_item_cimage', $cimage_value );
        } else {
           $cimage_value = "";
           update_post_meta( $menu_item_db_id, '_menu_item_cimage', $cimage_value );
        }

        if ( isset( $_REQUEST['menu-item-cmega'][$menu_item_db_id] ) ) {           
           $cmega_value = $_REQUEST['menu-item-cmega'][$menu_item_db_id];
           update_post_meta( $menu_item_db_id, '_menu_item_cmega', $cmega_value );
        } else {
           $cmega_value = "";
           update_post_meta( $menu_item_db_id, '_menu_item_cmega', $cmega_value );
        }
   
    }

}

// instantiate plugin's class
$GLOBALS['dina_custom_menu'] = new rc_dina_custom_menu();
      