<?php
namespace Elementor;

class Dina_Category_Grid extends Widget_Base {
	
	public function get_name() {
		return 'dina-category-grid';
	}
	
	public function get_title() {
		return __( 'Category Grid (Dinakala)', 'dina-kala' );
	}
	
	public function get_icon() {
		return 'fal fa-th';
	}

	public function get_help_url() {
		return 'https://i-design.ir/docs/dinakala/?p=1034';
	}
	
	public function get_categories() {
		return [ 'dina-kala' ];
	}
	
	protected function register_controls() {

		//Start Title Section 
		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Title settings', 'dina-kala' ),
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => __( 'Title', 'dina-kala' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your title', 'dina-kala' ),
				'default'     => __( 'Categories', 'dina-kala' ),
			]
		);

		$this->add_control(
			'icon',
			[
				'label'   => __( 'Icon', 'dina-kala' ),
				'type'    => 'dina_iconpicker',
				'default' => 'sitemap'
			]
		);

		$this->add_control(
			'custom_icon',
			[
				'label' => __( 'Or custom icon (Suitable size: 32px by 32px)', 'dina-kala' ),
				'type'  => Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'middle_title',
			[
				'label'        => __( 'Show title in the middle', 'dina-kala' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'dina-kala' ),
				'label_off'    => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'   => __( 'Block title tag', 'dina-kala' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'h2',
				'options' => [
					'div' => __( 'div', 'dina-kala' ),
					'h1'  => __( 'h1', 'dina-kala' ),
					'h2'  => __( 'h2', 'dina-kala' ),
					'h3'  => __( 'h3', 'dina-kala' ),
					'h4'  => __( 'h4', 'dina-kala' ),
				],
			]
		);

		$this->add_control(
			'white_title',
			[
				'label'        => __( 'White title (Suitable for background mode)', 'dina-kala' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'dina-kala' ),
				'label_off'    => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default'      => '',
			]
		);

		if ( dina_opt( 'dina_dark_mode' ) ) {
			$this->add_control(
				'dark_title',
				[
					'label'        => __( 'Dark title (Suitable for dark mode and white background)', 'dina-kala' ),
					'type'         => Controls_Manager::SWITCHER,
					'label_on'     => __( 'On', 'dina-kala' ),
					'label_off'    => __( 'Off', 'dina-kala' ),
					'return_value' => 'yes',
					'default'      => '',
				]
			);
		}

		$this->add_control(
			'remove_underline',
			[
				'label'        => __( 'Remove the title underline', 'dina-kala' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'dina-kala' ),
				'label_off'    => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default'      => '',
			]
		);

		$this->add_control(
			'title_style',
			[
				'label'   => __( 'Block title style', 'dina-kala' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default'           => __( 'Default', 'dina-kala' ),
					'line'              => __( 'Line', 'dina-kala' ),
					'short-line'        => __( 'Short line', 'dina-kala' ),
					'dashed-line'       => __( 'Dashed line', 'dina-kala' ),
					'dotted-line'       => __( 'Dotted line', 'dina-kala' ),
					'double-line'       => __( 'Double lines', 'dina-kala' ),
					'double-short-line' => __( 'Double short lines', 'dina-kala' ),
				],
				'condition' => [
					'remove_underline' => '',
				],
			]
		);

		$this->add_control(
			'inherit_color',
			[
				'label'        => __( 'Inheriting title border color from template color', 'dina-kala' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'dina-kala' ),
				'label_off'    => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition' => [
					'remove_underline' => '',
				],
			]
		);

		$this->add_control(
			'title_border_color',
			[
				'label'     => __( 'Title border color', 'dina-kala' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#17A2B8',
				'selectors' => [
					'{{WRAPPER}} ' => '--dina-block-title-color: {{VALUE}}',
				],
				'condition' => [
					'inherit_color' => '',
				],
			]
		);

		$this->end_controls_section();
		//End Title Section

		//Start Categories Section 
		$this->start_controls_section(
			'section_categories',
			[
				'label' => __( 'Categories', 'dina-kala' ),
			]
		);

		$this->add_control(
			'product_cat',
			[
				'label'       => __( 'Categories', 'dina-kala' ),
				'type'        => 'dina_autocomplete',
				'search'      => 'dina_get_taxonomies_by_query',
				'render'      => 'dina_get_taxonomies_title_by_id',
				'taxonomy'    => 'product_cat',
				'multiple'    => true,
				'label_block' => true,
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'   => __( 'Order by', 'dina-kala' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					''           => '',
					'id'         => __( 'ID', 'dina-kala' ),
					'date'       => __( 'Date', 'dina-kala' ),
					'title'      => __( 'Title', 'dina-kala' ),
					'menu_order' => __( 'Menu order', 'dina-kala' ),
					'modified'   => __( 'Last modified date', 'dina-kala' ),
				),
			]
		);

		$this->add_control(
			'order',
			[
				'label'   => __( 'Sort order', 'dina-kala' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					''     => __( 'Inherit', 'dina-kala' ),
					'DESC' => __( 'Descending', 'dina-kala' ),
					'ASC'  => __( 'Ascending', 'dina-kala' ),
				),
			]
		);

		$this->add_control(
			'hide_empty',
			[
				'label'        => __( 'Hide empty categories', 'dina-kala' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'dina-kala' ),
				'label_off'    => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'cat_total_count',
			[
				'label'   => __( 'Categories total count', 'dina-kala' ),
				'type'    => Controls_Manager::NUMBER,
				'min'     => 1,
				'default' => 12,
				'step'    => 1,
			]
		);

		$this->add_responsive_control(
			'columns_count',
			[
				'label'              => esc_html__( 'Columns count', 'dina-kala' ),
				'type'               => Controls_Manager::NUMBER,
				'min'                => 2,
				'max'                => 10,
				'default'            => 6,
				'tablet_default'     => 3,
				'mobile_default'     => 2,
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'image_size',
			[
				'label'   => __( 'Image size', 'dina-kala' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'thumbnail',
				'options' => array(
					'thumbnail'             => __( '150*150', 'dina-kala' ),
					'woocommerce_thumbnail' => __( '300*300', 'dina-kala' ),
					'woocommerce_single'    => __( '600*600', 'dina-kala' ),
					'full'                  => __( 'Full size', 'dina-kala' ),
				),
			]
		);

		$this->add_responsive_control(
			'image_width',
			[
				'type'       => Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px' ], // better to allow both
				'label'      => esc_html__( 'Image width', 'azin-file' ),
				'range'      => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'devices'         => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => [
					'size' => 100,
					'unit' => '%',
				],
				'tablet_default' => [
					'size' => 100,
					'unit' => '%',
				],
				'mobile_default' => [
					'size' => 100,
					'unit' => '%',
				],
				'selectors' => [
					'{{WRAPPER}} .dina-term-cat img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'show_title',
			[
				'label'        => __( 'Show category title', 'dina-kala' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'dina-kala' ),
				'label_off'    => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default'      => '',
			]
		);

		$this->add_control(
			'show_product_count',
			[
				'label'        => __( 'Show products count', 'dina-kala' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'dina-kala' ),
				'label_off'    => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default'      => '',
			]
		);

		$this->end_controls_section();
		//End Categories Section
		
		//Start Style Section
		$this->start_controls_section(
			'style_section',
			[
				'label' => __( 'Style settings', 'dina-kala' ),
			]
		);

		$this->add_control(
			'white_box',
			[
				'label'        => __( 'White box style', 'dina-kala' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'dina-kala' ),
				'label_off'    => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default'      => '',
			]
		);

		$this->add_control(
			'row_style',
			[
				'label'        => __( 'Row style', 'dina-kala' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'dina-kala' ),
				'label_off'    => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default'      => '',
			]
		);

		$this->add_control(
			'align_center',
			[
				'label'        => __( 'Show categories in center alignment', 'dina-kala' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'dina-kala' ),
				'label_off'    => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default'      => '',
			]
		);

		$this->add_control(
			'dis_bw',
			[
				'label'        => __( 'Disable black & white style', 'dina-kala' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'dina-kala' ),
				'label_off'    => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default'      => '',
			]
		);

		$this->add_control(
			'hover_effect',
			[
				'label'   => __( 'Image hover effect', 'dina-kala' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'none',
				'options' => [
					'none'            => __( 'None', 'dina-kala' ),
					'dina-brightness' => __( 'Brightness', 'dina-kala' ),
					'dina-zoomin'     => __( 'Zoom In', 'dina-kala' ),
					'dina-rotate'     => __( 'Rotate', 'dina-kala' ),
					'dina-blur'       => __( 'Blur', 'dina-kala' ),
					'dina-gray'       => __( 'Gray Scale', 'dina-kala' ),
					'dina-opacity'    => __( 'Opacity', 'dina-kala' ),
					'dina-flash'      => __( 'Flashing', 'dina-kala' ),
					'dina-shine'      => __( 'Shine', 'dina-kala' ),
					'dina-circle'     => __( 'Circle', 'dina-kala' )
				],
			]
		);

		$this->add_control(
			'white_border',
			[
				'label'        => __( 'White Background activation', 'dina-kala' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'dina-kala' ),
				'label_off'    => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default'      => '',
			]
		);

		$this->add_control(
			'custom_background_color',
			[
				'label'        => __( 'Custom background color', 'dina-kala' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'dina-kala' ),
				'label_off'    => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default'      => '',
				'condition' => [
					'white_border' => 'yes',
				],
			]
		);

		$this->add_control(
			'background_color',
			[
				'label'     => __( 'Background Color', 'dina-kala' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fff',
				'selectors' => [
					'{{WRAPPER}} .dina-term-cat' => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'custom_background_color' => 'yes',
				],
			]
		);

		$this->add_control(
			'background_hover',
			[
				'label'        => __( 'Change background color on mouseover', 'dina-kala' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'dina-kala' ),
				'label_off'    => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default'      => '',
				'condition' => [
					'white_border' => 'yes',
				],
			]
		);

		$this->add_control(
			'custom_background_hover',
			[
				'label'        => __( 'Custom background color on mouseover', 'dina-kala' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'On', 'dina-kala' ),
				'label_off'    => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default'      => '',
				'condition' => [
					'background_hover' => 'yes',
				],
			]
		);

		$this->add_control(
			'background_hover_color',
			[
				'label'     => __( 'Background color on mouseover', 'dina-kala' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#17A2B8',
				'selectors' => [
					'{{WRAPPER}}' => '--dina-term-hover-color: {{VALUE}};',
				],
				'condition' => [
					'custom_background_hover' => 'yes',
				],
			]
		);

		$this->end_controls_section();
		//End Style Section

	}
	
	protected function render() {

        $settings = $this->get_settings_for_display();

		$product_cat     = $settings['product_cat'];
		$cat_total_count = $settings['cat_total_count'];
		$image_size      = $settings['image_size'];

		$args = array (
			'taxonomy'   => 'product_cat',
			'order'      => $settings['order'],
			'hide_empty' => 'yes' === $settings['hide_empty'],
			'include'    => $product_cat,
			'number'     => $cat_total_count
		);

		if ( $settings['orderby'] ) {
			$args['orderby'] = $settings['orderby'];
		}
		
		$terms = get_terms( $args );
		?>
		
		<?php
		if ( ! empty( $terms ) ) {

			$block_classes  = 'dina-cats-grid';
			$block_classes .= 'yes' === $settings['white_title'] ? ' white-title' : '';
			$block_classes .= 'yes' === $settings['white_box'] ? ' white-box' : '';
			$block_classes .= 'yes' === $settings['dis_bw'] ? ' dis-bw' : '';
			$block_classes .= isset( $settings['dark_title'] ) && 'yes' === $settings['dark_title'] ? ' dark-title' : '';
			$block_classes .= 'yes' === $settings['middle_title'] ? ' dina-middle-title' : ' dina-right-title';
		?>
			<div class="<?php echo $block_classes ?>">
				
				<?php if ( ! empty( $settings['title'] ) ) {
					$block_title_style = 'block-title-';
					if ( ! empty( $settings['remove_underline'] ) ) {
						$block_title_style .= 'none';
					} elseif ( ! empty( $settings['title_style'] ) && $settings['title_style'] != 'default' ) {
						$block_title_style .= $settings['title_style'];
					} else {
						$block_title_style .= dina_opt('block_title_style');
					}

					if ( 'yes' === $settings['middle_title'] ) {
						$block_title_style .= ' dina-center-title';
					}
				?>
					<div class="block-title <?= $block_title_style ?>">
						<?php echo ! isset ( $settings['title_tag'] ) ? '<h2 class="block-title-con">' : '<' . $settings['title_tag'] . ' class="block-title-con">'; ?>
							<?php if ( ! empty( $settings['custom_icon']['url'] ) ) { ?>
								<img src="<?php echo $settings['custom_icon']['url']; ?>" width="32" height="32" alt="<?php echo $settings['title']; ?>" class="cust-icon">
							<?php } elseif ( ! empty( $settings['icon'] ) ) { ?>
								<i class="fal fa-<?php echo $settings['icon']; ?>" aria-hidden="true"></i>
							<?php } ?>
							<?php echo $settings['title']; ?>
						<?php echo ! isset ( $settings['title_tag'] ) ? '</h2>' : '</' . $settings['title_tag'] . '>'; ?>
					</div>
				<?php } ?>

				<div class="row<?php echo 'yes' === $settings['align_center'] ? ' justify-content-center' : ''; ?>">

					<?php foreach ( $terms as $term ) {
						$term_link = get_term_link( $term, 'product_cat' );
						$thumbnail_id = get_term_meta ( $term->term_id, 'thumbnail_id', true );
						if ( ! empty( $thumbnail_id ) ) {
							$cat_attr = wp_get_attachment_image_src( $thumbnail_id, $image_size );
							$width    = ( isset( $cat_attr[1] ) ? ' width="'. $cat_attr[1] .'"' : '' );
							$height   = ( isset( $cat_attr[2] ) ? ' height="'. $cat_attr[2] .'"' : '' );
							if ( isset ( $cat_attr[0] ) ) {
								$cat_logo = $cat_attr[0];
							}
						} else {
							$cat_logo = '';
						}

						$item_cols = 'dina-term-cat-con';
						
						switch ( $settings['columns_count'] ) {
							case 2:
								$item_cols .= ' col-lg-6';
								break;
							case 3:
								$item_cols .= ' col-lg-4';
								break;
							case 4:
								$item_cols .= ' col-lg-3';
								break;
							case 5:
								$item_cols .= ' col col-p-5';
								break;
							case 6:
								$item_cols .= ' col-lg-2';
								break;
							case 7:
								$item_cols .= ' col col-p-7';
								break;
							case 8:
								$item_cols .= ' col col-p-8';
								break;
							case 9:
								$item_cols .= ' col col-p-9';
								break;
							case 10:
								$item_cols .= ' col col-p-10';
								break;
							default:
								$item_cols .= ' col col-md-2';
						}

						switch ( $settings['columns_count_tablet'] ) {
							case 2:
								$item_cols .= ' col-md-6';
								break;
							case 3:
								$item_cols .= ' col-md-4';
								break;
							case 4:
								$item_cols .= ' col-md-3';
								break;
							case 5:
								$item_cols .= ' col-t-5';
								break;
							case 6:
								$item_cols .= ' col-md-2';
								break;
							case 7:
								$item_cols .= ' col-t-7';
								break;
							case 8:
								$item_cols .= ' col-t-8';
								break;
							case 9:
								$item_cols .= ' col-t-9';
								break;
							case 10:
								$item_cols .= ' col-t-10';
								break;
							default:
								$item_cols .= ' col-md-4';
						}

						switch ( $settings['columns_count_mobile'] ) {
							case 2:
								$item_cols .= ' col-6';
								break;
							case 3:
								$item_cols .= ' col-4';
								break;
							case 4:
								$item_cols .= ' col-3';
								break;
							case 5:
								$item_cols .= ' col-m-5';
								break;
							case 6:
								$item_cols .= ' col-2';
								break;
							case 7:
								$item_cols .= ' col-m-7';
								break;
							case 8:
								$item_cols .= ' col-m-8';
								break;
							case 9:
								$item_cols .= ' col-m-9';
								break;
							case 10:
								$item_cols .= ' col-m-10';
								break;
							default:
								$item_cols .= ' col-6';
						}

						$item_classes  = 'dina-term-cat';
						$item_classes .= 'yes' === $settings['white_border'] ? ' shadow-box' : '';
						$item_classes .= 'yes' === $settings['white_border'] && 'yes' === $settings['background_hover'] ? ' dina-term-bg-hover' : '';
						$item_classes .= ' '. $settings['hover_effect'];
						$item_classes .= 'yes' === $settings['row_style'] ? ' dina-term-row' : '';
					?>

					<div class="<?php echo $item_cols; ?>">
					
						<div class="<?php echo $item_classes; ?>">

							<a href="<?php echo $term_link; ?>" title="<?php echo $term->name; ?>">
							<?php if ( ! empty ( $cat_logo ) ) { ?>
								<img src="<?php echo $cat_logo; ?>" alt="<?php echo $term->name; ?>"<?php echo $width . $height; ?>>
							<?php } else { ?>
								<img src="<?php echo esc_url( DI_URI ) . '/images/mthumb.png'; ?>" alt="<?php echo $term->name; ?>" width="150" height="150">
							<?php } ?>
							</a>

							<?php if ( 'yes' === $settings['show_title'] || 'yes' === $settings['show_product_count'] ) { ?>
								<div class="dina-term-desc">
							<?php } ?>

								<?php if ( 'yes' === $settings['show_title'] ) { ?>
									<a href="<?php echo $term_link; ?>" title="<?php echo $term->name; ?>">
										<span class="dina-term-name">
										<?php echo $term->name; ?>
										</span>
									</a>
								<?php } ?>

								<?php if ( 'yes' === $settings['show_product_count'] ) { ?>
									<span class="dina-term-count">
									<?php
									$count = '';
									$term_count = sprintf( _n( '%s product', '%s products', $count, 'dina-kala' ), $term->count );
									echo $term_count; ?>
									</span>
								<?php } ?>

							<?php if ( 'yes' === $settings['show_title'] || 'yes' === $settings['show_product_count'] ) { ?>
								</div>
							<?php } ?>

						</div>
						
					</div>

					<?php } ?>
				</div>
			</div>
        <?php
		}
	}
}