<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Demo Website: dinakala.i-design.ir
Author Website: i-design.ir
*/

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

$daily_time_range = array(
    array('from' => '09:00', 'to' => '12:00'),
    array('from' => '12:00', 'to' => '15:00'),
    array('from' => '15:00', 'to' => '18:00'),
    array('from' => '18:00', 'to' => '21:00'),
);

// Wocommerce Settings
Redux::setSection( $opt_name, array(
    'title'  => __( 'Woocommerce Settings', 'dina-kala' ),
    'id'     => 'menu_woo',
    'icon'   => 'fab fa-wordpress-simple',
    'fields' => array(
        array( 
            'id'       => 'woocommerce_settings_docs',
            'type'     => 'raw',
            'content'  => dina_admin_info( '', 'https://i-design.ir/docs/dinakala/?p=2209', 'info' )
        ),
        array(
            'id'       => 'remove_product_order',
            'type'     => 'switch',
            'title'    => __( 'Remove product sorting', 'dina-kala' ),
            'subtitle' => __( 'Remove product sorting from archive pages', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'product_sold_individually',
            'type'     => 'switch',
            'title'    => __( 'Removing the product quantity', 'dina-kala' ),
            'subtitle' => __( 'Removing the product quantity from WooCommerce products', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'mini_cart_quantity',
            'type'     => 'switch',
            'title'    => __( 'Ability to choose the number of products in the side shopping cart', 'dina-kala' ),
            'default'  => true,
        ),
        array(
            'id'       => 'remove_mini_cart_btn',
            'type'     => 'switch',
            'title'    => __( 'Removing the view cart button from the side cart', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'grant_download_access',
            'type'     => 'switch',
            'title'    => __( 'Grant download permissions for past WooCommerce orders', 'dina-kala' ),
            'subtitle' => __( 'By activating this option, permission to download new files added to the product will be granted to previous orders.', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'      => 'external_new_tab',
            'type'    => 'switch',
            'title'   => __( 'Opening the external/affiliate product link in a new tab', 'dina-kala' ),
            'default' => false,
        ),
        
        array(
            'id'       => 'remove_cart_fragments',
            'type'     => 'switch',
            'title'    => __( 'Remove cart fragments script', 'dina-kala' ),
            'subtitle' => __( 'Removing this script from the main page will increase the loading speed of your site, but if you use the cache plugin, removing this script will cause the shopping cart content to not be updated automatically when the page is loaded.', 'dina-kala' ),
            'default'  => false,
        ),

        array(
            'id'       => 'dina_fix_rankmath',
            'type'     => 'switch',
            'title'    => __( 'Fix ISO 4217 error in RankMeth plugin', 'dina-kala' ),
            'subtitle' => __( 'If you install the RankMath plugin and receive an IRT currency error in Google Search Console results, enable this option to fix it.', 'dina-kala' ),
            'default'  => false,
        ),

        //checkout-settings-start
        array(
            'id'     => 'checkout-settings-start',
            'type'   => 'section',
            'title'  => __( 'Checkout settings', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'      => 'redirect_checkout_login',
            'type'    => 'switch',
            'title'   => __( 'Show the login page instead of the payment page to guest users (non-members).' , 'dina-kala' ),
            'default' => false,
        ),
        array(
            'id'      => 'show_checkout_steps',
            'type'    => 'switch',
            'title'   => __( 'Display payment steps on shopping cart and checkout pages' , 'dina-kala' ),
            'default' => true,
        ),
        array(
            'id'       => 'override_address_fields',
            'type'     => 'switch',
            'title'    => __( 'Moving the state and city fields', 'dina-kala' ),
            'subtitle' => __( 'By activating this option, the state and city fields will be moved on the checkout page. If you use other plugins to edit the fields of the checkout page, activating this option may cause interference.', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'remove_extra_fields',
            'type'     => 'switch',
            'title'    => __( 'Remove extra fields', 'dina-kala' ),
            'subtitle' => __( 'Remove extra fields from products that do not have physical shipping', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'national_code_field',
            'type'     => 'switch',
            'title'    => __( 'Add the national code field', 'dina-kala' ),
            'subtitle' => __( 'Adding the national code field to the checkout page', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'optional_national_code_field',
            'type'     => 'switch',
            'title'    => __( 'Making the national code optional', 'dina-kala' ),
            'subtitle' => __( 'By activating this option, the national code becomes optional in the checkout form.', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'national_code_field', '=', true ),
        ),
        array(
            'id'       => 'remove_email_field',
            'type'     => 'switch',
            'title'    => __( 'Disabling the email field', 'dina-kala' ),
            'subtitle' => __( 'By activating this option, the email field will be removed from the checkout form. Be sure to check the correctness of the payment process after activating this option.', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'optional_email_field',
            'type'     => 'switch',
            'title'    => __( 'Making the email field optional', 'dina-kala' ),
            'subtitle' => __( 'By activating this option, the email field becomes optional in the checkout form. Be sure to check the correctness of the payment process after activating this option.', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'remove_postal_code_field',
            'type'     => 'switch',
            'title'    => __( 'Disabling the postcode/ZIP field', 'dina-kala' ),
            'subtitle' => __( 'By activating this option, the postcode/ZIP field will be removed from the checkout form. Be sure to check the correctness of the payment process after activating this option.', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'optional_postal_code_field',
            'type'     => 'switch',
            'title'    => __( 'Making the postal code field optional', 'dina-kala' ),
            'subtitle' => __( 'By activating this option, the postcode/ZIP field becomes optional in the checkout form. Be sure to check the correctness of the payment process after activating this option.', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'remove_phone_field',
            'type'     => 'switch',
            'title'    => __( 'Disabling the phone field', 'dina-kala' ),
            'subtitle' => __( 'By activating this option, the phone field will be removed from the checkout form. Be sure to check the correctness of the payment process after activating this option.', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'optional_phone_field',
            'type'     => 'switch',
            'title'    => __( 'Making the phone field optional', 'dina-kala' ),
            'subtitle' => __( 'By activating this option, the phone field becomes optional in the checkout form. Be sure to check the correctness of the payment process after activating this option.', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'validate_phone_field',
            'type'     => 'switch',
            'title'    => __( 'Phone field validation', 'dina-kala' ),
            'subtitle' => __( 'By activating this option, it is checked whether the phone number is 11 digits long and starts with 09.', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'remove_address_two',
            'type'     => 'switch',
            'title'    => __( 'Disabling the second address field', 'dina-kala' ),
            'subtitle' => __( 'By activating this option, the second address field will be removed from the checkout form. Be sure to check the correctness of the payment process after activating this option.', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'change_address_label',
            'type'     => 'switch',
            'title'    => __( 'Change the label of the address field', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'address_label',
            'type'     => 'text',
            'title'    => __( 'Address field label', 'dina-kala' ),
            'default'  => __( 'Street address', 'dina-kala' ),
            'required' => array( 'change_address_label', '=', true ),
        ),
        array(
            'id'       => 'remove_company',
            'type'     => 'switch',
            'title'    => __( 'Disabling the company field', 'dina-kala' ),
            'subtitle' => __( 'By activating this option, the company field will be removed from the checkout form. Be sure to check the correctness of the payment process after activating this option.', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'remove_note_field',
            'type'     => 'switch',
            'title'    => __( 'Disabling the order notes field', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'     => 'checkout-settings-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //checkout-msg-start
        array(
            'id'       => 'checkout-msg-start',
            'type'     => 'section',
            'title'    => __( 'Checkout page message settings', 'dina-kala' ),
            'subtitle' => __( 'With this section, you can display a message on the WooCommerce checkout page (for example, tips regarding online payments).', 'dina-kala' ),
            'indent'   => true,
        ),
        array(
            'id'       => 'checkout_msg',
            'type'     => 'switch',
            'title'    => __( 'Show checkout page message', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'checkout_msg_text',
            'type'     => 'editor',
            'title'    => __( 'Checkout page message text', 'dina-kala' ),
            'desc'     => __( 'You can also use the shortcode.', 'dina-kala' ),
            'args'     => array(
                'wpautop'       => true,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => true,
                'quicktags'     => true,
            ),
            'required' => array( 'checkout_msg', '=', true ),
        ),
        array(
            'id'       => 'checkout_msg_color',
            'type'     => 'select',
            'title'    => __( 'Checkout page message color', 'dina-kala' ),
            'options'  => array(
                'success' => __( 'Green', 'dina-kala' ),
                'error'   => __( 'Red', 'dina-kala' ),
                'notice'  => __( 'Blue', 'dina-kala' ),
            ),
            'default'  => 'success',
            'required' => array( 'checkout_msg', '=', true ),
        ),
        array(
            'id'     => 'checkout-msg-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //free-shipping-start
        array(
            'id'       => 'free-shipping-start',
            'type'     => 'section',
            'title'    => __( 'Free shipping settings', 'dina-kala' ),
            'subtitle' => __( 'Displaying changes in this section requires changes in the shopping cart content', 'dina-kala' ),
            'indent'   => true,
        ),
        array(
            'id'       => 'free_shipping_msg',
            'type'     => 'switch',
            'title'    => __( 'Show free shipping message', 'dina-kala' ),
            'subtitle' => __( 'If you have a method for free shipping on a certain amount of the order, you can display a message about the amount remaining until free shipping', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'shipping_is_free_msg',
            'type'     => 'switch',
            'title'    => __( 'Notify user when shipping is free', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'free_shipping_msg', '=', true ),
        ),
        array(
            'id'       => 'free_shipping_amount',
            'type'     => 'text',
            'title'    => __( 'Free shipping threshold', 'dina-kala' ),
            'subtitle' => __( 'The amount in which shipping is free, without monetary units and decimals and...', 'dina-kala' ),
            'required' => array( 'free_shipping_msg', '=', true ),
        ),
        array(
            'id'       => 'free_shipping_msg_cart',
            'type'     => 'switch',
            'title'    => __( 'Show free shipping message in cart page', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'free_shipping_msg', '=', true ),
        ),
        array(
            'id'       => 'free_shipping_msg_mini_cart',
            'type'     => 'switch',
            'title'    => __( 'Show free shipping message in mini-cart', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'free_shipping_msg', '=', true ),
        ),
        array(
            'id'      => 'free_shipping_mini_cart_color',
            'type'    => 'select',
            'title'   => __( 'Message color', 'dina-kala' ),
            'options' => array(
                'alert-info'    => __( 'Blue', 'dina-kala' ),
                'alert-warning' => __( 'Yellow', 'dina-kala' ),
                'alert-success' => __( 'Green', 'dina-kala' ),
                'alert-danger'  => __( 'Red', 'dina-kala' )
            ),
            'default'  => 'alert-info',
            'required' => array( 'free_shipping_msg_mini_cart', '=', true ),
        ),
        array(
            'id'       => 'free_shipping_mini_cart_progress',
            'type'     => 'switch',
            'title'    => __( 'Display progress bar of remaining amount', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'free_shipping_msg_mini_cart', '=', true ),
        ),
        array(
            'id'      => 'free_shipping_mini_cart_progress_color',
            'type'    => 'select',
            'title'   => __( 'Progress bar color', 'dina-kala' ),
            'options' => array(
                'bg-info'    => __( 'Blue', 'dina-kala' ),
                'bg-warning' => __( 'Yellow', 'dina-kala' ),
                'bg-success' => __( 'Green', 'dina-kala' ),
                'bg-danger'  => __( 'Red', 'dina-kala' )
            ),
            'default'  => 'bg-info',
            'required' => array( 'free_shipping_mini_cart_progress', '=', true ),
        ),
        array(
            'id'      => 'show_only_free_shipping',
            'type'    => 'switch',
            'title'   => __( 'Hide other shipping methods when free shipping is enabled', 'dina-kala' ),
            'default' => false,
        ),
        array(
            'id'     => 'free-shipping-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //cod-payment-start
        array(
            'id'       => 'cod-payment-start',
            'type'     => 'section',
            'title'    => __( 'Cash on delivery settings', 'dina-kala' ),
            'subtitle' => __( 'Displaying changes in this section requires changes in the shopping cart content', 'dina-kala' ),
            'indent'   => true,
        ),
        array(
            'id'       => 'cod_payment_condition',
            'type'     => 'switch',
            'title'    => __( 'Show cash on delivery purchase method in a certain amount', 'dina-kala' ),
            'subtitle' => __( 'If you have a method for cash on delivery, you can display this method in a certain amount of the shopping cart.', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'cod_payment_amount',
            'type'     => 'select',
            'title'    => __( 'Cart amount condition', 'dina-kala' ),
            'options'  => array(
                'min'      => __( 'From the minimum amount', 'dina-kala' ),
                'max'      => __( 'Up to the maximum amount', 'dina-kala' ),
                'min-max'  => __( 'From minimum to maximum amount', 'dina-kala' ),
            ),
            'default'  => 'min',
            'required' => array( 'cod_payment_condition', '=', true ),
        ),
        array(
            'id'       => 'cod_amount_min',
            'type'     => 'text',
            'title'    => __( 'Minimum shopping cart amount', 'dina-kala' ),
            'subtitle' => __( 'The minimum amount in which cash on delivery is active, without monetary units and decimals and...', 'dina-kala' ),
            'required' => array( 'cod_payment_amount', '=', array( 'min', 'min-max' ) ),
        ),
        array(
            'id'       => 'cod_amount_max',
            'type'     => 'text',
            'title'    => __( 'Maximum shopping cart amount', 'dina-kala' ),
            'subtitle' => __( 'The Maximum amount in which cash on delivery is active, without monetary units and decimals and...', 'dina-kala' ),
            'required' => array( 'cod_payment_amount', '=', array( 'max', 'min-max' ) ),
        ),
        array(
            'id'     => 'cod-payment-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //minimum-purchase-amount-start
        array(
            'id'       => 'minimum-purchase-start',
            'type'     => 'section',
            'title'    => __( 'Minimum purchase amount settings', 'dina-kala' ),
            'subtitle' => __( 'Displaying changes in this section requires changes in the shopping cart content', 'dina-kala' ),
            'indent'   => true,
        ),
        array(
            'id'       => 'minimum_purchase_msg',
            'type'     => 'switch',
            'title'    => __( 'Minimum purchase amount message', 'dina-kala' ),
            'subtitle' => __( 'If you have a minimum purchase amount, you can display a message about the remaining amount.', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'minimum_purchase_amount',
            'type'     => 'text',
            'title'    => __( 'Minimum purchase amount', 'dina-kala' ),
            'subtitle' => __( 'Minimum purchase amount, without currency, decimals, etc.', 'dina-kala' ),
            'required' => array( 'minimum_purchase_msg', '=', true ),
        ),
        array(
            'id'       => 'minimum_purchase_msg_cart',
            'type'     => 'switch',
            'title'    => __( 'Show message in cart page', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'minimum_purchase_msg', '=', true ),
        ),
        array(
            'id'       => 'minimum_purchase_msg_mini_cart',
            'type'     => 'switch',
            'title'    => __( 'Show message in mini-cart', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'minimum_purchase_msg', '=', true ),
        ),
        array(
            'id'      => 'minimum_purchase_mini_cart_color',
            'type'    => 'select',
            'title'   => __( 'Message color', 'dina-kala' ),
            'options' => array(
                'alert-info'    => __( 'Blue', 'dina-kala' ),
                'alert-warning' => __( 'Yellow', 'dina-kala' ),
                'alert-success' => __( 'Green', 'dina-kala' ),
                'alert-danger'  => __( 'Red', 'dina-kala' )
            ),
            'default'  => 'alert-warning',
            'required' => array( 'minimum_purchase_msg_mini_cart', '=', true ),
        ),
        array(
            'id'       => 'minimum_purchase_mini_cart_progress',
            'type'     => 'switch',
            'title'    => __( 'Display progress bar of remaining amount', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'minimum_purchase_msg_mini_cart', '=', true ),
        ),
        array(
            'id'      => 'minimum_purchase_mini_cart_progress_color',
            'type'    => 'select',
            'title'   => __( 'Progress bar color', 'dina-kala' ),
            'options' => array(
                'bg-info'    => __( 'Blue', 'dina-kala' ),
                'bg-warning' => __( 'Yellow', 'dina-kala' ),
                'bg-success' => __( 'Green', 'dina-kala' ),
                'bg-danger'  => __( 'Red', 'dina-kala' )
            ),
            'default'  => 'bg-info',
            'required' => array( 'minimum_purchase_mini_cart_progress', '=', true ),
        ),
        array(
            'id'     => 'minimum-purchase-amount-end',
            'type'   => 'section',
            'indent' => false,
        ),
    ),
) );

// Order Delivery Time Settings
Redux::setSection( $opt_name, array(
    'title'      => __( 'Order Delivery Time', 'dina-kala' ),
    'id'         => 'order_delivery_time',
    'desc'       => __( 'Order Delivery Time settings', 'dina-kala' ),
    'icon'       => 'fal fa-shipping-timed',
    'subsection' => true,
    'fields'     => array(
        array( 
            'id'       => 'order_delivery_time_help',
            'type'     => 'raw',
            'content'  => dina_admin_info( '', 'https://i-design.ir/docs/dinakala/?p=4041', 'info' )
        ),
        array(
            'id'       => 'enable_order_delivery_time',
            'type'     => 'switch',
            'title'    => __( 'Activate order delivery time', 'dina-kala' ),
            'subtitle' => __( 'By activating this option, a table containing the upcoming days will be displayed on the checkout page to select the delivery/shipping time for the order.', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'req_order_delivery_time',
            'type'     => 'switch',
            'title'    => __( 'This field is required', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'enable_order_delivery_time', '=', true ),
        ),
        array(
            'id'       => 'order_delivery_time_days',
            'type'     => 'text',
            'validate' => 'numeric',
            'title'    => __( 'Number of days', 'dina-kala' ),
            'subtitle' => __( 'Number of days displayed in the table', 'dina-kala' ),
            'default'  => 7,
            'required' => array( 'enable_order_delivery_time', '=', true ),
        ),
        array(
            'id'       => 'order_delivery_time_start',
            'type'     => 'text',
            'validate' => 'numeric',
            'title'    => __( 'The start of the days', 'dina-kala' ),
            'subtitle' => __( 'Specify how many days after the order date the displayed days should be displayed.', 'dina-kala' ),
            'desc'     => __( 'For example, if you enter the number 0, the first day will be the day the order is placed, if you enter 1, the first day will be the day after the order is placed, and so on.', 'dina-kala' ),
            'default'  => 1,
            'required' => array( 'enable_order_delivery_time', '=', true ),
        ),
        array(
            'id'       => 'order_delivery_time_min_hours_left',
            'type'     => 'text',
            'validate' => 'numeric',
            'title'    => __( 'Time remaining to deactivate the time slot', 'dina-kala' ),
            'subtitle' => __( 'If you are shipping on the day of order placement, you can use this option to specify the remaining time to deactivate the current day\'s time slots.', 'dina-kala' ),
            'desc'     => __( 'For example, if you enter 1, the time slot that ends within one hour of order placement will be deactivated. Time slots before the order placement time will also be automatically deactivated.', 'dina-kala' ),
            'default'  => 1,
            'required' => array( 'order_delivery_time_start', '=', 0 ),
        ),
        array(
            'id'       => 'order_delivery_time_disable_days',
            'type'     => 'select',
            'multi'    => true,
            'title'    => __( 'Inactive days of the week', 'dina-kala' ), 
            'subtitle' => __( 'Select days that are not available for selection.', 'dina-kala' ),
            'options' => array(
                'saturday'  => __( 'Saturday', 'dina-kala' ),
                'sunday'    => __( 'Sunday', 'dina-kala' ),
                'monday'    => __( 'Monday', 'dina-kala' ),
                'tuesday'   => __( 'Tuesday', 'dina-kala' ),
                'wednesday' => __( 'Wednesday', 'dina-kala' ),
                'thursday'  => __( 'Thursday', 'dina-kala' ),
                'friday'    => __( 'Friday', 'dina-kala' ),
            ),
            'required' => array( 'enable_order_delivery_time', '=', true ),
        ),
        array(
            'id'          => 'order_delivery_time_disable_dates',
            'type'        => 'multi_text',
            'title'       => __( 'Dates without posting', 'dina-kala' ),
            'subtitle'    => __( 'Select non-delivery dates (e.g. holidays)', 'dina-kala' ),
            'add_text'    => __( 'Add date', 'dina-kala' ),
            'show_empty'  => false,
            'class'       => is_rtl() ? 'dina-jalali-date-picker dina-none-delivery-dates' : 'dina-gregorian-date-picker dina-none-delivery-dates',
            'placeholder' => __( 'Click to enter a date', 'dina-kala' ),
            'required'    => array( 'enable_order_delivery_time', '=', true ),
        ),
        array(
            'id'       => 'order_delivery_time_location',
            'type'     => 'select',
            'multi'    => false,
            'title'    => __( 'Table display location', 'dina-kala' ),
            'options' => array(
                'woocommerce_checkout_before_order_review'     => __('Before order review', 'dina-kala'),
                'woocommerce_review_order_before_payment'      => __('Before payment', 'dina-kala'),
                'woocommerce_after_checkout_billing_form'      => __('After checkout billing form', 'dina-kala'),
            ),
            'default'  => array( 'woocommerce_checkout_before_order_review' ),
            'required' => array( 'enable_order_delivery_time', '=', true ),
        ),
        array(
            'id'       => 'order_delivery_time_disable_digital',
            'type'     => 'switch',
            'title'    => __( 'Not displayed in virtual products', 'dina-kala' ),
            'subtitle' => __( 'Not displayed on products without the need for shipping', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'enable_order_delivery_time', '=', true ),
        ),
        array(
            'id'       => 'order_delivery_time_default',
            'type'     => 'switch',
            'title'    => __( 'Select the first time by default', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'enable_order_delivery_time', '=', true ),
        ),
        array(
            'id'       => 'order_delivery_time_day_ranges',
            'type'     => 'dina_weekly_time_ranges',
            'title'    => __( 'Delivery hours on weekdays', 'dina-kala' ),
            'default'  => array(
                'saturday'  => $daily_time_range,
                'sunday'    => $daily_time_range,
                'monday'    => $daily_time_range,
                'tuesday'   => $daily_time_range,
                'wednesday' => $daily_time_range,
                'thursday'  => $daily_time_range,
                'friday'    => $daily_time_range,
            ),
            'required' => array( 'enable_order_delivery_time', '=', true ),
        ),
        array(
            'id'       => 'order_delivery_time_cities',
            'type'     => 'dina_province_city_selector',
            'title'    => __( 'Allowed cities', 'dina-kala' ),
            'subtitle' => __( 'Specify the cities where the shipping table will be displayed. If no city is specified, it will be displayed for all cities.', 'dina-kala' ),
            'required' => array( 'enable_order_delivery_time', '=', true ),
        ),

        // order-delivery-time-texts-start
        array(
            'id'     => 'order-delivery-time-texts-start',
            'type'   => 'section',
            'title'  => __( 'Text customization', 'dina-kala' ),
            'required' => array( 'enable_order_delivery_time', '=', true ),
            'indent' => true,
        ),
        array(
            'id'       => 'order_delivery_time_title',
            'type'     => 'text',
            'title'    => __( 'Table title', 'dina-kala' ),
            'default'  => __( 'Specify the delivery time', 'dina-kala' ),
            'required' => array( 'enable_order_delivery_time', '=', true ),
        ),
        array(
            'id'       => 'order_delivery_time_inactive',
            'type'     => 'text',
            'title'    => __( 'Inactive days title', 'dina-kala' ),
            'default'  => __( 'Inactive', 'dina-kala' ),
            'required' => array( 'enable_order_delivery_time', '=', true ),
        ),
        array(
            'id'       => 'order_delivery_hours_inactive',
            'type'     => 'text',
            'title'    => __( 'Inactive hours title', 'dina-kala' ),
            'default'  => __( 'Inactive', 'dina-kala' ),
            'required' => array( 'enable_order_delivery_time', '=', true ),
        ),
        array(
            'id'       => 'order_delivery_time_no_range',
            'type'     => 'text',
            'title'    => __( 'Text displayed on days without a time interval', 'dina-kala' ),
            'default'  => __( 'There is no shipping today.', 'dina-kala' ),
            'required' => array( 'enable_order_delivery_time', '=', true ),
        ),
        array(
            'id'       => 'order_delivery_time_req_error',
            'type'     => 'text',
            'title'    => __( 'Warning text if the field is required', 'dina-kala' ),
            'default'  => __( 'Please select the order delivery time frame.', 'dina-kala' ),
            'required' => array( 'enable_order_delivery_time', '=', true ),
        ),
        array(
            'id'       => 'order_delivery_time_thankyou',
            'type'     => 'text',
            'title'    => __( 'Text displayed on the order information page', 'dina-kala' ),
            'default'  => __( 'Selected delivery time:', 'dina-kala' ),
            'required' => array( 'enable_order_delivery_time', '=', true ),
        ),
        array(
            'id'       => 'order_delivery_time_admin',
            'type'     => 'text',
            'title'    => __( 'Text displayed on the order management page', 'dina-kala' ),
            'default'  => __( 'Shipping time:', 'dina-kala' ),
            'required' => array( 'enable_order_delivery_time', '=', true ),
        ),
        array(
            'id'     => 'order-delivery-time-texts-end',
            'type'   => 'section',
            'indent' => false,
        ),
    )
) );

// Order tracking Settings
Redux::setSection( $opt_name, array(
    'title'      => __( 'Order Tracking', 'dina-kala' ),
    'id'         => 'order_tracking',
    'desc'       => __( 'Order Tracking settings', 'dina-kala' ),
    'icon'       => 'fal fa-truck',
    'subsection' => true,
    'fields'     => array(
        array( 
            'id'       => 'order_tracking_help',
            'type'     => 'raw',
            'content'  => dina_admin_info( '', 'https://i-design.ir/docs/dinakala/?p=4219', 'info' )
        ),
        array(
            'id'       => 'order_tracking_code',
            'type'     => 'switch',
            'title'    => __( 'Order tracking code', 'dina-kala' ),
            'subtitle' => __( 'Ability to insert the tracking code on the order management page and display it on the user panel', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'order_tracking_code_title',
            'type'     => 'text',
            'title'    => __( 'Tracking code title', 'dina-kala' ),
            'default'  => __( 'Tracking code', 'dina-kala' ),
            'required' => array( 'order_tracking_code', '=', true ),
        ),
        array(
            'id'       => 'order_tracking_code_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Tracking code icon', 'dina-kala' ),
            'default'  => 'fal fa-truck',
            'required' => array( 'order_tracking_code', '=', true ),
        ),

        //woo-default-order-status-start
        array(
            'id'       => 'woo-default-order-status-start',
            'type'     => 'section',
            'title'    => __( 'WooCommerce Default Order Statuses', 'dina-kala' ),
            'subtitle' => __( 'After enabling or disabling each mode and saving the settings, you must refresh the page once to apply the changes.', 'dina-kala' ),
            'indent'   => true,
        ),
        array(
            'id'      => 'change_pending_status',
            'type'    => 'switch',
            'title'   => __( 'Change the title of the "Pending payment" status', 'dina-kala' ),
            'default' => false
        ),
        array(
            'id'       => 'label_pending',
            'type'     => 'text',
            'title'    => __( 'Status title', 'dina-kala' ),
            'default'  => __( 'Pending payment', 'dina-kala' ),
            'required' => array( 'change_pending_status', '=', true ),
        ),
        array(
            'id'      => 'change_processing_status',
            'type'    => 'switch',
            'title'   => __( 'Change the title of the "Processing" status', 'dina-kala' ),
            'default' => false
        ),
        array(
            'id'       => 'label_processing',
            'type'     => 'text',
            'title'    => __( 'Status title', 'dina-kala' ),
            'default'  => __( 'Processing', 'dina-kala' ),
            'required' => array( 'change_processing_status', '=', true ),
        ),
        array(
            'id'      => 'change_onhold_status',
            'type'    => 'switch',
            'title'   => __( 'Change the title of the "On hold" status', 'dina-kala' ),
            'default' => false
        ),
        array(
            'id'       => 'label_onhold',
            'type'     => 'text',
            'title'    => __( 'Status title', 'dina-kala' ),
            'default'  => __( 'On hold', 'dina-kala' ),
            'required' => array( 'change_onhold_status', '=', true ),
        ),
        array(
            'id'      => 'change_completed_status',
            'type'    => 'switch',
            'title'   => __( 'Change the title of the "Completed" status', 'dina-kala' ),
            'default' => false
        ),
        array(
            'id'       => 'label_completed',
            'type'     => 'text',
            'title'    => __( 'Status title', 'dina-kala' ),
            'default'  => __( 'Completed', 'dina-kala' ),
            'required' => array( 'change_completed_status', '=', true ),
        ),
        array(
            'id'      => 'change_cancelled_status',
            'type'    => 'switch',
            'title'   => __( 'Change the title of the "Cancelled" status', 'dina-kala' ),
            'default' => false
        ),
        array(
            'id'       => 'label_cancelled',
            'type'     => 'text',
            'title'    => __( 'Status title', 'dina-kala' ),
            'default'  => __( 'Cancelled', 'dina-kala' ),
            'required' => array( 'change_cancelled_status', '=', true ),
        ),
        array(
            'id'      => 'change_refunded_status',
            'type'    => 'switch',
            'title'   => __( 'Change the title of the "Refunded" status', 'dina-kala' ),
            'default' => false
        ),
        array(
            'id'       => 'label_refunded',
            'type'     => 'text',
            'title'    => __( 'Status title', 'dina-kala' ),
            'default'  => __( 'Refunded', 'dina-kala' ),
            'required' => array( 'change_refunded_status', '=', true ),
        ),
        array(
            'id'      => 'change_failed_status',
            'type'    => 'switch',
            'title'   => __( 'Change the title of the "Failed" status', 'dina-kala' ),
            'default' => false
        ),
        array(
            'id'       => 'label_failed',
            'type'     => 'text',
            'title'    => __( 'Status title', 'dina-kala' ),
            'default'  => __( 'Failed', 'dina-kala' ),
            'required' => array( 'change_failed_status', '=', true ),
        ),
        array(
            'id'     => 'woo-default-order-status-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //woo-default-order-status-end

        //custom-order-status-start
        array(
            'id'       => 'custom-order-status-start',
            'type'     => 'section',
            'title'    => __( 'Custom order status', 'dina-kala' ),
            'subtitle' => __( 'After enabling or disabling each mode and saving the settings, you must refresh the page once to apply the changes.', 'dina-kala' ),
            'indent'   => true,
        ),
        array(
            'id'      => 'delivered_order_status',
            'type'    => 'switch',
            'title'   => __( 'Activate order status delivered', 'dina-kala' ),
            'default' => true
        ),
        array(
            'id'       => 'label_delivered',
            'type'     => 'text',
            'title'    => __( 'Status title', 'dina-kala' ),
            'default'  => __( 'Delivered', 'dina-kala' ),
            'required' => array( 'delivered_order_status', '=', true ),
        ),
        array(
            'id'      => 'preparing_order_status',
            'type'    => 'switch',
            'title'   => __( 'Activate order status in preparation', 'dina-kala' ),
            'default' => true
        ),
        array(
            'id'       => 'label_preparing',
            'type'     => 'text',
            'title'    => __( 'Status title', 'dina-kala' ),
            'default'  => __( 'Preparing', 'dina-kala' ),
            'required' => array( 'preparing_order_status', '=', true ),
        ),
        array(
            'id'      => 'shipped_order_status',
            'type'    => 'switch',
            'title'   => __( 'Activate order status shipped', 'dina-kala' ),
            'default' => true
        ),
        array(
            'id'       => 'label_shipped',
            'type'     => 'text',
            'title'    => __( 'Status title', 'dina-kala' ),
            'default'  => __( 'Shipped', 'dina-kala' ),
            'required' => array( 'shipped_order_status', '=', true ),
        ),
        array(
            'id'     => 'custom-order-status-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //custom-order-status-end

        //order-status-steps-start
        array(
            'id'     => 'order-status-steps-start',
            'type'   => 'section',
            'title'  => __( 'Order status steps', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_order_status_steps',
            'type'     => 'switch',
            'title'    => __( 'Show order status steps', 'dina-kala' ),
            'subtitle' => __( 'By activating this option, the order process steps will be displayed on the user panel\'s order screen and order tracking screen according to the order status and in the steps you specify in the steps below.', 'dina-kala' ),
            'default'  => false
        ),
        array(
            'id'          => 'order_status_steps_color',
            'type'        => 'color',
            'title'       => __( 'Order status steps color', 'dina-kala' ),
            'default'     => '#ef394e',
            'validate'    => 'color',
            'transparent' => false,
            'required'    => array( 'show_order_status_steps', '=', true ),
        ),
        array(
            'id'       => 'order_tracking_step_one',
            'type'     => 'switch',
            'title'    => __( 'Enable the first step of order tracking', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_order_status_steps', '=', true ),
        ),
        array(
            'id'       => 'order_tracking_step_one_title',
            'type'     => 'text',
            'title'    => __( 'First step title', 'dina-kala' ),
            'default'  => __( 'Pending payment', 'dina-kala' ),
            'required' => array( 'order_tracking_step_one', '=', true ),
        ),
        array(
            'id'       => 'order_tracking_step_one_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'First step icon', 'dina-kala' ),
            'default'  => 'fal fa-credit-card',
            'required' => array( 'order_tracking_step_one', '=', true ),
        ),
        array(
            'id'       => 'order_tracking_step_one_status',
            'type'     => 'select',
            'title'    => __( 'Order status of the first step', 'dina-kala' ),
            'default'  => 'wc-pending',
            'data'     => 'callback',
            'args'     => 'dina_kala_get_order_status_options',
            'required' => array( 'order_tracking_step_one', '=', true ),
        ),
        array(
            'id'       => 'order_tracking_step_two',
            'type'     => 'switch',
            'title'    => __( 'Enable the second step of order tracking', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_order_status_steps', '=', true ),
        ),
        array(
            'id'       => 'order_tracking_step_two_title',
            'type'     => 'text',
            'title'    => __( 'Second step title', 'dina-kala' ),
            'default'  => __( 'Awaiting review', 'dina-kala' ),
            'required' => array( 'order_tracking_step_two', '=', true ),
        ),
        array(
            'id'       => 'order_tracking_step_two_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Second step icon', 'dina-kala' ),
            'default'  => 'fal fa-hourglass-half',
            'required' => array( 'order_tracking_step_two', '=', true ),
        ),
        array(
            'id'       => 'order_tracking_step_two_status',
            'type'     => 'select',
            'title'    => __( 'Order status of the second step', 'dina-kala' ),
            'default'  => 'wc-on-hold',
            'data'     => 'callback',
            'args'     => 'dina_kala_get_order_status_options',
            'required' => array( 'order_tracking_step_two', '=', true ),
        ),
        array(
            'id'       => 'order_tracking_step_three',
            'type'     => 'switch',
            'title'    => __( 'Enable the third step of order tracking', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_order_status_steps', '=', true ),
        ),
        array(
            'id'       => 'order_tracking_step_three_title',
            'type'     => 'text',
            'title'    => __( 'Third step title', 'dina-kala' ),
            'default'  => __( 'In progress', 'dina-kala' ),
            'required' => array( 'order_tracking_step_three', '=', true ),
        ),
        array(
            'id'       => 'order_tracking_step_three_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Third step icon', 'dina-kala' ),
            'default'  => 'fal fa-box-full',
            'required' => array( 'order_tracking_step_three', '=', true ),
        ),
        array(
            'id'       => 'order_tracking_step_three_status',
            'type'     => 'select',
            'title'    => __( 'Order status of the third step', 'dina-kala' ),
            'default'  => 'wc-processing',
            'data'     => 'callback',
            'args'     => 'dina_kala_get_order_status_options',
            'required' => array( 'order_tracking_step_three', '=', true ),
        ),
        array(
            'id'       => 'order_tracking_step_four',
            'type'     => 'switch',
            'title'    => __( 'Enable the fourth step of order tracking', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_order_status_steps', '=', true ),
        ),
        array(
            'id'       => 'order_tracking_step_four_title',
            'type'     => 'text',
            'title'    => __( 'Fourth step title', 'dina-kala' ),
            'default'  => __( 'Shipped', 'dina-kala' ),
            'required' => array( 'order_tracking_step_four', '=', true ),
        ),
        array(
            'id'       => 'order_tracking_step_four_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Fourth step icon', 'dina-kala' ),
            'default'  => 'fal fa-truck',
            'required' => array( 'order_tracking_step_four', '=', true ),
        ),
        array(
            'id'       => 'order_tracking_step_four_status',
            'type'     => 'select',
            'title'    => __( 'Order status of the fourth step', 'dina-kala' ),
            'default'  => 'wc-shipped',
            'data'     => 'callback',
            'args'     => 'dina_kala_get_order_status_options',
            'required' => array( 'order_tracking_step_four', '=', true ),
        ),
        array(
            'id'       => 'order_tracking_step_five',
            'type'     => 'switch',
            'title'    => __( 'Enable the fifth step of order tracking', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_order_status_steps', '=', true ),
        ),
        array(
            'id'       => 'order_tracking_step_five_title',
            'type'     => 'text',
            'title'    => __( 'Fifth step title', 'dina-kala' ),
            'default'  => __( 'Completed', 'dina-kala' ),
            'required' => array( 'order_tracking_step_five', '=', true ),
        ),
        array(
            'id'       => 'order_tracking_step_five_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Fifth step icon', 'dina-kala' ),
            'default'  => 'fal fa-box-check',
            'required' => array( 'order_tracking_step_five', '=', true ),
        ),
        array(
            'id'       => 'order_tracking_step_five_status',
            'type'     => 'select',
            'title'    => __( 'Order status of the fifth step', 'dina-kala' ),
            'default'  => 'wc-completed',
            'data'     => 'callback',
            'args'     => 'dina_kala_get_order_status_options',
            'required' => array( 'order_tracking_step_five', '=', true ),
        ),
        array(
            'id'     => 'order-status-steps-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //order-status-steps-end
        
    ),
) );