<?php
/**
 * Weekly Time Ranges Field for Redux Framework
 *
 * @package     Redux Framework/Fields
 * @author      Meysam Hosseinkhani
 * @version     1.0.1
 */

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Redux_Dina_Weekly_Time_Ranges', false ) ) {

	class Redux_Dina_Weekly_Time_Ranges extends Redux_Field {

		public function __construct( $field = array(), $value = '', $parent = null ) {
			parent::__construct( $field, $value, $parent );

			$this->field  = $field;
			$this->value  = is_string( $value ) ? $value : json_encode( $value, JSON_UNESCAPED_UNICODE );
			$this->parent = $parent;

			if ( empty( $value ) && ! empty( $this->field['default'] ) ) {
				$this->value = json_encode( $this->field['default'], JSON_UNESCAPED_UNICODE );
			}
		}

		public function render() {
			$days = [
				'saturday'  => __( 'Saturday', 'dina-kala' ),
				'sunday'    => __( 'Sunday', 'dina-kala' ),
				'monday'    => __( 'Monday', 'dina-kala' ),
				'tuesday'   => __( 'Tuesday', 'dina-kala' ),
				'wednesday' => __( 'Wednesday', 'dina-kala' ),
				'thursday'  => __( 'Thursday', 'dina-kala' ),
				'friday'    => __( 'Friday', 'dina-kala' ),
			];

			echo '<div class="dina-weekly-time-ranges">';

			foreach ( $days as $key => $label ) {
				echo '<div class="dina-day-block" data-day="' . esc_attr( $key ) . '">';
				echo '<div class="dina-day-header">' . esc_html( $label ) . '</div>';
				echo '<div class="dina-day-content">';
				echo '<div class="dina-time-entries"></div>';
				echo '<button type="button" class="dina-add-time-range button">' . esc_html__( 'Add range', 'dina-kala' ) . '</button>';
				echo '</div>';
				echo '</div>';
			}

			echo '<input type="hidden" name="' . esc_attr( $this->field['name'] ) . '" value="' . esc_attr( $this->value ) . '" class="dina-redux-weekly-time-json" />';
			echo '</div>';
		}

		public function enqueue() {
			wp_enqueue_script(
				'dina-weekly-time-ranges-js',
				DI_URI . '/includes/admin-panel/dina-weekly-time-ranges/assets/dina-weekly-time-ranges.js',
				array( 'jquery' ),
				time(),
				true
			);

			wp_localize_script(
				'dina-weekly-time-ranges-js',
				'dinaWeeklyTimeRangesData',
				array(
					'i18n' => array(
						'to' => esc_html__( 'To', 'dina-kala' ),
					),
				)
			);

			wp_enqueue_style(
				'dina-weekly-time-ranges-css',
				DI_URI . '/includes/admin-panel/dina-weekly-time-ranges/assets/dina-weekly-time-ranges.css',
				array(),
				time()
			);
		}
	}

	// Register the field with Redux
	class_alias( 'Redux_Dina_Weekly_Time_Ranges', 'ReduxFramework_dina_weekly_time_ranges' );
}