<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
if ( post_password_required() ) {
    return;
}

if ( dina_opt( 'post_comments_ajax_load' ) ) { ?>
    <div id="comments" class="comments-area">
        <?php
        if ( have_comments() ) :
            $raw_value = dina_opt( 'post_comments_per_page' );
            $comments_per_page = ( is_numeric( $raw_value ) && (int) $raw_value > 0 ) ? (int) $raw_value : 6;
            
            $total_parent_comments = get_comments( array(
                'post_id' => get_the_ID(),
                'status'  => 'approve',
                'parent'  => 0,
                'count'   => true,
            ) );

            if ( get_option( 'comment_order' ) === 'desc' ) {
                $page = ceil( $total_parent_comments / $comments_per_page );
            } else {
                $page = 1;
            }
            ?>

            <h2 class="comments-title">
                <?php
                $comments_number = get_comments_number();
                if ( '1' === $comments_number ) {
                    printf( _x( 'One reply on “%s”', 'comments title', 'dina-kala' ), get_the_title() );
                } else {
                    printf(
                        _nx(
                            '%1$s reply on “%2$s”',
                            '%1$s replies on “%2$s”',
                            $comments_number,
                            'comments title',
                            'dina-kala'
                        ),
                        number_format_i18n( $comments_number ),
                        get_the_title()
                    );
                }
                ?>
            </h2>

            <div class="dina-ajax-comment-list">

                <ol class="commentlist" id="dina-comment-list">
                    <?php
                    wp_list_comments( array(
                        'per_page'    => $comments_per_page,
						'page'        => $page,
                        'avatar_size' => 50,
                        'style'       => 'ol',
                        'short_ping'  => true,
                        'reply_text'  => __( 'Reply', 'dina-kala' ),
                    ) );
                    ?>
                </ol>

            <?php if ( $total_parent_comments > $comments_per_page ) : ?>
                <div class="dina-load-more-comments-wrapper">
                    <button id="dina-load-more-comments"
                        class="dina-load-more-comments btn btn-outline-dina"
                        data-page="2"
                        data-post="<?php echo esc_attr( get_the_ID() ); ?>"
                        data-perpage="<?php echo esc_attr( $comments_per_page ); ?>"
                        data-total="<?php echo esc_attr( $total_parent_comments ); ?>">
                        <i class="fal fa-comments"></i>
                        <?php _e( 'Load More Comments', 'dina-kala' ); ?>
                    </button>
                </div>
            <?php endif; ?>

            </div>

        <?php endif; ?>

        <?php
        if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
        ?>
            <p class="no-comments"><?php _e( 'Comments are closed.', 'dina-kala' ); ?></p>
        <?php endif; ?>

        <?php comment_form(); ?>
    </div>
<?php } else { ?>
    <div id="comments" class="comments-area">
        <?php
        if ( have_comments() ) : ?>
            <h2 class="comments-title">
                <?php
                $comments_number = get_comments_number();
                if ( '1' === $comments_number ) {
                    printf( _x( 'One reply on “%s”', 'comments title', 'dina-kala' ), get_the_title() );
                } else {
                    printf(
                        _nx(
                            '%1$s reply on “%2$s”',
                            '%1$s replies on “%2$s”',
                            $comments_number,
                            'comments title',
                            'dina-kala'
                        ),
                        number_format_i18n( $comments_number ),
                        get_the_title()
                    );
                }
                ?>
            </h2>

            <ol class="commentlist">
                <?php
                wp_list_comments( array(
                    'avatar_size' => 50,
                    'style'       => 'ol',
                    'short_ping'  => true,
                    'reply_text'  => __( 'Reply', 'dina-kala' ),
                    'max_depth'   => get_option( 'thread_comments_depth', 5 ),
                ) );
                ?>
            </ol>

            <?php
            the_comments_pagination( array(
                'prev_text' => '<span class="screen-reader-text">' . __( 'Previous', 'dina-kala' ) . '</span>',
                'next_text' => '<span class="screen-reader-text">' . __( 'Next', 'dina-kala' ) . '</span>',
            ) );
            ?>

        <?php endif; ?>

        <?php
        if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
        ?>
            <p class="no-comments"><?php _e( 'Comments are closed.', 'dina-kala' ); ?></p>
        <?php endif; ?>

        <?php comment_form(); ?>
    </div>
<?php } ?>