<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: i-design.ir
*/
// Exit if accessed directly

if ( ! defined( 'ABSPATH' ) )
    exit;

get_header(); 
?>

<div class="container main-con">
    <?php do_action( 'dina_before_cart_check' ); ?>
    <?php if ( is_checkout() && ! is_wc_endpoint_url( 'order-received' ) ) {
        do_action( 'dina_before_checkout' );
    } ?>
    <div class="row page-row">
        <?php if ( have_posts() ) : ?>
            <article role="main"  class="col-12">
                <div class="shadow-box page-con" id="post-<?php the_ID(); ?>">
                    <?php
                    $min_amount = dinafa_digits( dina_opt( 'minimum_purchase_amount' ) );
                    $current = WC()->cart->get_cart_contents_total();
                    if ( is_checkout() && ! is_wc_endpoint_url( 'order-received' ) && dina_opt( 'minimum_purchase_msg' ) && $current < $min_amount ) {
                        $added_text = sprintf( __( 'The minimum purchase amount from the store is %s. Please add another %s.', 'dina-kala' ), wc_price( $min_amount ), wc_price( $min_amount - $current ) );
                        $return_to  = wc_get_page_permalink( 'shop' );
                        $notice     = sprintf( '<a href="%s" class="button wc-forward">%s</a> %s', esc_url( $return_to ), __( 'Continue Shopping', 'dina-kala' ), $added_text );
                        echo '<div class="woocommerce">';
                        wc_print_notice( $notice, 'notice' );
                        echo '</div>';
                    } else {
                        while ( have_posts() ) : the_post();
                            the_content();
                        endwhile; 
                    } ?>
                </div>
            </article>
        <?php 
        endif; 
        ?>
    </div>
</div>

<?php get_footer();