<?php

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

$header_class  = 'dina-site-header';
$header_class .= dina_opt( 'head_bg_color' ) == 'transparent' ? ' dina-transparent-header' : '';
$header_class .= ( ! is_front_page() && ( ! dina_opt( 'show_bread' ) || ! dina_opt( 'show_bread_mobile' ) ) ) ? ' no-bread' : '';

?>

<header class="<?= $header_class ?>" <?php if ( dina_opt( 'site_schema' ) ) {?>itemscope itemtype="https://schema.org/Organization" <?php } ?>>
    <?php if ( dina_opt( 'site_schema' ) ) { 
    echo '<meta itemprop="url" content="'. esc_url( home_url() ) .'">';
    echo '<meta itemprop="name" content="'. esc_html( get_bloginfo( 'name' ) ) .'">';
    } ?>
    <!-- Header Div -->
    <?php
    $headercon_class  = 'container-fluid dina-header header';
    $headercon_class .= dina_opt( 'fixed_head_mobile' ) ? ' fixed-mobile' : '';
    ?>
    <div class="<?= $headercon_class ?>">
        <div class="container">
            
            <?php if ( ! dina_opt( 'hide_top_bar' ) ) { ?>
            <div class="row head-mc<?php if ( dina_opt( 'head_pos' ) == 2) {echo ' left-head'; } ?>">

                <!-- Header Menu -->
                <nav class="col-md-6 head-menu<?php if ( dina_opt( 'mobile_head_menu' ) ) {echo ' visible-mobile';} ?>" <?php if ( dina_opt( 'site_schema' ) ) {?>itemscope itemtype="https://schema.org/SiteNavigationElement" <?php } ?>>
                    <?php
                    if ( has_nav_menu( 'header' ) ) {
                        wp_nav_menu( array(
                            'menu'              => 'header',
                            'theme_location'    => 'header',
                            'depth'             => 1,
                            'container'         => 'div'
                            )
                        );
                    }
                    ?>
                </nav>
                <!-- Header Menu -->
                
                <?php if ( dina_opt( 'show_contact' ) && ! dina_opt( 'show_head_social' ) ) {
                $contact_nofollow    = ( dina_opt( 'contact_link_nofollow' ) ? ' rel="nofollow"' : '' );
                $contact_link_target = empty( dina_opt( 'contact_link_target' ) ) ? '_blank' : dina_opt( 'contact_link_target' );
                ?>
                <!-- Header Contact -->
                <div class="col-md-6 head-contact<?php echo dina_opt( 'show_contact_mobile' ) ? ' visible-mobile' : ''; ?>">
                    <meta itemprop="address" content="<?php echo dina_opt( 'addr_text' ); ?>">
                    <meta itemprop="image" content="<?php echo dina_to_https( dina_opt( 'site_logo_retina', 'url' ) ); ?>">

                    <?php if ( ! empty ( dina_opt( 'site_tel' ) ) ) { ?>
                    <div class="head-phone" <?php if ( dina_opt( 'site_schema' ) ) {?>itemprop="telephone"<?php } ?>>
                        <?php if ( dina_opt( 'site_tel_link' ) ) {
                            $tel_link = dina_opt( 'custom_tel_link' ) ? dina_opt( 'custom_tel_link_addr' ) : 'tel:' . dina_remove_dash( dina_opt( 'site_tel' ) ); ?>
                        <a href="<?php echo $tel_link; ?>" target="<?= $contact_link_target ?>"<?php echo $contact_nofollow; ?>>
                        <?php } ?>
                            <i class="fal fa-phone" aria-hidden="true"></i>
                            <?php echo dina_opt( 'site_tel' ); ?>
                        <?php if ( dina_opt( 'site_tel_link' ) ) { ?>
                        </a>
                        <?php } ?>
                    </div>
                    <?php } ?>

                    <?php if ( dina_opt( 'replace_email' ) && ! empty ( dina_opt( 'site_tel2' ) ) ) { ?>
                        <div class="head-phone" <?php if ( dina_opt( 'site_schema' ) ) {?>itemprop="telephone"<?php } ?>>
                            <?php if ( dina_opt( 'site_tel_link' ) ) {
                                $email_link = dina_opt( 'custom_email_link' ) ? dina_opt( 'custom_email_link_addr' ) : 'tel:' . dina_remove_dash( dina_opt( 'site_tel2' ) ); ?>
                            <a href="<?php echo $email_link; ?>" target="<?= $contact_link_target ?>"<?php echo $contact_nofollow; ?>>
                            <?php } ?>
                                <i class="fal fa-phone-rotary" aria-hidden="true"></i>
                                <?php echo dina_opt( 'site_tel2' ); ?>
                            <?php if ( dina_opt( 'site_tel_link' ) ) { ?>
                            </a>
                            <?php } ?>
                        </div>
                    <?php } elseif ( ! empty ( dina_opt( 'site_email' ) ) ) { ?>
                        <div class="head-email" <?php if ( dina_opt( 'site_schema' ) ) {?>itemprop="email"<?php } ?>>
                            <?php if ( dina_opt( 'site_email_link' ) ) {
                            $email_link = dina_opt( 'custom_email_link' ) ? dina_opt( 'custom_email_link_addr' ) : 'mailto:' . dina_opt( 'site_email' ); ?>
                            <a href="<?php echo $email_link; ?>" target="<?= $contact_link_target ?>"<?php echo $contact_nofollow; ?>>
                            <?php } ?>
                                <i class="fal fa-envelope" aria-hidden="true"></i>
                                <?php echo dina_opt( 'site_email' ); ?>
                            <?php if ( dina_opt( 'site_email_link' ) ) { ?>
                            </a>
                            <?php } ?>
                        </div>
                    <?php } ?>
                </div>
                <!-- Header Contact -->
                <?php } ?>

                <?php
                //Header Social Links
                if ( dina_opt( 'show_head_social' ) ) {
                ?>
                    <!-- Header Social -->
                    <div class="col-md-6 head-social<?php echo dina_opt( 'show_head_social_mobile' ) ? ' visible-mobile' : ''; ?>">
                        <?php dina_social_links( 'head-social-ul', true ) ?>
                    </div>
                    <!-- Header Social -->
                <?php } ?>

            </div>
            <?php } ?>

            <?php
                $logo_box_classes  = 'row logo-box';
                $logo_box_classes .= dina_opt( 'logo_pos' ) == 2 ? ' left-logo' : '';
                $logo_box_classes .= dina_opt( 'logo_pos' ) == 3 ? ' middle-logo' : '';
                $logo_box_classes .= dina_opt( 'logo_pos' ) == 3 && dina_opt( 'reverse_middle_logo_search' ) ? ' reverse-search' : '';
                $logo_box_classes .= dina_opt( 'mobile_logo_pos' ) == 1 ? ' mobile-right-logo' : '';
                $logo_box_classes .= dina_opt( 'mobile_logo_pos' ) == 3 ? ' mobile-middle-logo' : '';
                $logo_box_classes .= dina_opt( 'reverse_middle_logo_btns' ) ? ' mobile-reverse-btns' : '';
                $logo_box_classes .= dina_opt('search_near_logo') && dina_opt( 'logo_pos' ) != 3 ? ' dina-search-near-logo' : '';
            ?>

            <div class="<?= $logo_box_classes ?>">

                    <?php // mobile btns ?>
                    <div class="<?php echo dina_opt( 'mobile_logo_pos' ) == 3 ? 'col-3' : 'col-6'; if ( dina_opt( 'mobile_user_btn_style' ) ) { echo ' mobile-text-style'; } ?> mobile-btns">
                        <?php
                        do_action( 'dina_before_mobile_btns' );

                        if ( dina_opt( 'mobile_logo_pos' ) != 3 ) {
                            dina_mobile_header_menu_cart_btn();
                        }
                        
                        dina_mobile_user_btns();
                        ?>
                    </div>

                    <?php
                    // Logo
                    $logo_classes  = 'logo dina-logo';
                    $logo_classes .= dina_opt( 'logo_pos' ) == 3 ? ' col-6' : ' col-md-3 col-6';
                    ?>
                    <div class = "<?= $logo_classes ?>">
                        <?php
                        if ( is_front_page() && dina_opt( 'add_home_heading' ) ) 
                            echo '<h1>';

                        dina_site_logo( true, ' header-logo', true );

                        if ( is_front_page() && dina_opt( 'add_home_heading' ) )
                            echo '</h1>';
                        ?>
                    </div>

                    <?php // mobile btns if mobile middle logo 
                    if ( dina_opt( 'mobile_logo_pos' ) == 3 ) { ?>
                    <div class="col-3 mobile-btns mobile-menu-btns">
                        <?php do_action( 'dina_before_mobile_btns' ); 
                        dina_mobile_header_menu_cart_btn();
                        ?>
                    </div>
                    <?php } ?>

                    <?php 
                    // Search Box
                    if ( dina_opt( 'logo_pos' ) == 3 ) {
                        $search_classes = 'col-md-3 dina-search-con';
                    } else {
                        $search_classes = 'col-md-6 dina-search-con';
                    }

                    $search_classes .= dina_opt( 'mobile_search' ) ? ' mobile-search-con' : '';
                    $search_classes .= dina_opt( 'mobile_search' ) && dina_opt( 'cart_mobile_search' ) ? ' cart-mobile-search-con' : '';
                    ?>

                    <div class="<?= $search_classes ?>">
                        <?php
                        $ajax_search = dina_opt( 'ajax_search' ) ? true : false;
                        di_search_form( 'col-md-11', 'desktop-search-cat', $ajax_search );
                        dina_cart_mobile_search();
                        ?>
                    </div>

                    <?php // Desktop user btns
                    $user_con_classes = 'col-md-3'; ?>
                    <div class="<?= $user_con_classes ?> dina-user-con">
                        <?php if ( dina_opt( 'ch_user_head_btns' ) ) {
                            dina_header_btns();
                        } else {
                            dina_user_btns();
                        } ?>
                    </div>

            </div>
        </div>
    </div>
    <!-- Header Div -->

    <!-- Navbar -->
    <?php
    $navbar_classes  = 'dina-navbar';
    $navbar_classes .= dina_opt( 'fixed_head_top' ) ? ' dina-sticky-nav' : '';
    $navbar_classes .= ! empty( dina_opt( 'menu_bar_width' ) ) && dina_opt( 'menu_bar_width' ) == 'full-width' ? ' dina-nav-full' : ' container-fluid dina-nav-boxed';
    $navbar_classes .= dina_opt( 'menu_remove_shadow' ) ? ' menu-no-shadow' : '';
    ?>
    <div class="<?= $navbar_classes ?>">
        <nav class="<?= ! empty( dina_opt( 'menu_bar_width' ) ) && dina_opt( 'menu_bar_width' ) == 'boxed' ? 'container ' : '' ?>navbar navbar-expand-sm<?php if ( dina_opt( 'focus_nav' ) ) {echo ' focus-nav';} ?>" <?php if ( dina_opt( 'site_schema' ) ) {?>itemscope itemtype="https://schema.org/SiteNavigationElement"<?php } ?>>
            <div class="container dina-nav-con">
                <!-- Collect the nav links from WordPress -->
                <div class="collapse navbar-collapse" id="bootstrap-nav-collapse">
                    <?php 
                    $args = array(
                        'theme_location' => 'mega_menu',
                        'depth'             => 4,
                        'container'         => 'div',
                        'fallback_cb'       => 'Yamm_Nav_Walker_menu_fallback',
                        'walker'            => new Yamm_Nav_Walker()
                    );

                    $args['menu_class'] = 'nav navbar-nav ';

                    $args['menu_class'] .= ( dina_opt( 'mega_style' ) == 'second' ? 'yamm-s ' : 'yamm ' );

                    $args['menu_class'] .= ( is_rtl() ? 'dina-menu-rtl ' : 'dina-menu-ltr ' );

                    $args['menu_class'] .= ( dina_opt( 'menu_hover_bottom' ) ? 'menu-hover-bottom ' : 'menu-hover-top ' );

                    if ( dina_opt( 'fixed_head_logo' ) ) {
                        $args['items_wrap'] = dina_sticky_logo();
                    }

                    wp_nav_menu( $args );
                ?>
                </div><!-- ./collapse -->

                <?php dina_menu_bar_btn() ?>

                <?php if ( dina_opt( 'ch_user_head_btns' ) ) {
                    dina_user_btns();
                } else {
                    dina_header_btns();
                } ?>

            </div><!-- /.container -->
        </nav>
    </div>
    <!-- Navbar -->

</header>