<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

//Dina Header Codes
add_action( 'dina_header', 'dina_header_codes' );
function dina_header_codes() {
    
    //Show Page Loading
    dina_page_loading();
    
    $logged_msg = ( dina_opt( 'hide_msg_logged' ) && is_user_logged_in() ? true : false );

    if ( dina_opt( 'show_msg' ) && ! $logged_msg ) { ?>
        <!-- Header Massage Div -->
            <?php if ( dina_opt( 'show_img_msg' ) ) { ?>
                <aside class="head-img-msg-con">
                    <a href="<?= dina_opt( 'img_msg_link' ); ?>" class="head-img-msg" target="_blank" title="<?= dina_opt( 'img_msg_title' ); ?>"></a>
                </aside>
            <?php } else {
                if ( dina_opt( 'user_close' ) && dina_opt( 'msg_reshown' ) > 0 ) {
                    $msg_reshown = dina_opt( 'msg_reshown' );
                } else {
                    $msg_reshown = "null";
                }
                ?>
                <div class="container-fluid head-msg" id="dinaHeadMsg" data-reshown="<?= $msg_reshown; ?>">
                    <div class="container">
                        <div class="row">
                            <?php $text_class = dina_opt( 'msg_btn' ) ? 'col-12 col-md-10 msg-text' : 'col-12 msg-text'; ?>
                            <div class="<?= $text_class ?>">
                                <i aria-hidden="true" class="<?= dina_opt( 'msg_icon' ); ?> msg-icon"></i>
                                <span>
                                    <?= do_shortcode( dina_opt( 'site_msg' ) ); ?>
                                </span>
                            </div>
                            <?php if ( dina_opt( 'msg_btn' ) ) {
                                $msg_btn_class = ( dina_opt( 'msg_btn_icon_before' ) ? dina_opt( 'msg_btn_color' ) . ' msg-icon-before' : dina_opt( 'msg_btn_color' ) . '' ); ?>
                            <div class="col-12 col-md-2 msg-btn-con">
                                <a class="btn <?= $msg_btn_class; ?> msg-btn" href="<?= dina_opt( 'msg_btn_link' ); ?>" title="<?= dina_opt( 'msg_btn_text' ); ?>">
                                    <?= dina_opt( 'msg_btn_text' ); ?>
                                    <i class="<?= dina_opt( 'msg_btn_icon' ); ?>" aria-hidden="true"></i>
                                </a>
                            </div>
                            <?php } ?>
                        </div>
                    </div>
                    <?php if ( dina_opt( 'user_close' ) ) { ?>
                        <i class="fal fa-times msg-close" aria-hidden="true"></i>
                    <?php } ?>
                </div>
            <?php } ?>
        <!-- Header Massage Div -->
    <?php }

}

// dina_social_links
function dina_social_links( $class, $schema ) {
    $social_nofollow = dina_opt( 'nofollow_social_link' ) ? ' rel="nofollow"' : '';
    $link_schema     = $schema && dina_opt( 'site_schema' ) ? 'itemprop="sameAs" ' : '';
    $ul_class       = ! empty ( $class ) ? ' class="'. $class .'"' : '';
    ?>
    <ul<?php echo $ul_class; ?>>
        <?php if ( dina_opt( 'so_twitter' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="<?php echo dina_opt( 'so_twitter_link' ); ?>" title="<?php _e( 'Twitter', 'dina-kala' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="dico ico-twitter-x "></i>
            </a>
        </li>
        <?php } ?>
        <?php if ( dina_opt( 'so_facebook' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="<?php echo dina_opt( 'so_facebook_link' ); ?>" title="<?php _e( 'Facebook', 'dina-kala' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fab fa-facebook-f"></i>
            </a>
        </li>
        <?php } ?>
        <?php if ( dina_opt( 'so_google' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="<?php echo dina_opt( 'so_google_link' ); ?>" title="<?php _e( 'Google+', 'dina-kala' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fab fa-google-plus-g"></i>
            </a>
        </li>
        <?php } ?>
        <?php if ( dina_opt( 'so_whatsapp' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="<?php echo dina_opt( 'so_whatsapp_link' ); ?>" title="<?php _e( 'Whatsapp', 'dina-kala' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fab fa-whatsapp"></i>
            </a>
        </li>
        <?php } ?>
        <?php if ( dina_opt( 'so_threads' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="<?php echo dina_opt( 'so_threads_link' ); ?>" title="<?php _e( 'Threads', 'dina-kala' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="dico ico-threads"></i>
            </a>
        </li>
        <?php } ?>
        <?php if ( dina_opt( 'so_tiktok' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="<?php echo dina_opt( 'so_tiktok_link' ); ?>" title="<?php _e( 'Tiktok', 'dina-kala' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fab fa-tiktok"></i>
            </a>
        </li>
        <?php } ?>
        <?php if ( dina_opt( 'so_telegram' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="<?php echo dina_opt( 'so_telegram_link' ); ?>" title="<?php _e( 'Telegram', 'dina-kala' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fab fa-telegram-plane"></i>
            </a>
        </li>
        <?php } ?>

        <?php if ( dina_opt( 'so_instagram' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="<?php echo dina_opt( 'so_instagram_link' ); ?>" title="<?php _e( 'Instagram', 'dina-kala' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fab fa-instagram"></i>
            </a>
        </li>
        <?php } ?>

        <?php if ( dina_opt( 'so_soundcloud' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="<?php echo dina_opt( 'so_soundcloud_link' ); ?>" title="<?php _e( 'Soundcloud', 'dina-kala' ) ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fab fa-soundcloud"></i>
            </a>
        </li>
        <?php } ?>

        <?php if ( dina_opt( 'so_spotify' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="<?php echo dina_opt( 'so_spotify_link' ); ?>" title="<?php _e( 'Spotify', 'dina-kala' ) ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fab fa-spotify"></i>
            </a>
        </li>
        <?php } ?>

        <?php if ( dina_opt( 'so_google_podcasts' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="<?php echo dina_opt( 'so_google_podcasts_link' ); ?>" title="<?php _e( 'Google podcasts', 'dina-kala' ) ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="dico ico-google-podcasts"></i>
            </a>
        </li>
        <?php } ?>

        <?php if ( dina_opt( 'so_castbox' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="<?php echo dina_opt( 'so_castbox_link' ); ?>" title="<?php _e( 'Castbox', 'dina-kala' ) ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="dico ico-castbox"></i>
            </a>
        </li>
        <?php } ?>

        <?php if ( dina_opt( 'so_linktree' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="<?php echo dina_opt( 'so_linktree_link' ); ?>" title="<?php _e( 'Linktree', 'dina-kala' ) ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="dico ico-linktr"></i>
            </a>
        </li>
        <?php } ?>

        <?php if ( dina_opt( 'so_youtube' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="<?php echo dina_opt( 'so_youtube_link' ); ?>" title="<?php _e( 'Youtube', 'dina-kala' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fab fa-youtube"></i>
            </a>
        </li>
        <?php } ?>

        <?php if ( dina_opt( 'so_linkedin' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="<?php echo dina_opt( 'so_linkedin_link' ); ?>" title="<?php _e( 'Linkedin', 'dina-kala' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fab fa-linkedin-in"></i>
            </a>
        </li>
        <?php } ?>

        <?php if ( dina_opt( 'so_dribble' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="<?php echo dina_opt( 'so_dribble_link' ); ?>" title="<?php _e( 'Dribble', 'dina-kala' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fab fa-dribbble"></i>
            </a>
        </li>
        <?php } ?>

        <?php if ( dina_opt( 'so_behance' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="<?php echo dina_opt( 'so_behance_link' ); ?>" title="<?php _e( 'Behance', 'dina-kala' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fab fa-behance"></i>
            </a>
        </li>
        <?php } ?>

        <?php if ( dina_opt( 'so_pinterest' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="<?php echo dina_opt( 'so_pinterest_link' ); ?>" title="<?php _e( 'Pinterest', 'dina-kala' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fab fa-pinterest-p"></i>
            </a>
        </li>
        <?php } ?>

        <?php if ( dina_opt( 'so_aparat' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="<?php echo dina_opt( 'so_aparat_link' ); ?>" title="<?php _e( 'Aparat', 'dina-kala' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="dico ico-aparat"></i>
            </a>
        </li>
        <?php } ?>

        <?php if ( dina_opt( 'so_soroush' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="<?php echo dina_opt( 'so_soroush_link' ); ?>" title="<?php _e( 'Soroush', 'dina-kala' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="dico ico-Soroush"></i>
            </a>
        </li>
        <?php } ?>

        <?php if ( dina_opt( 'so_gap' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="<?php echo dina_opt( 'so_gap_link' ); ?>" title="<?php _e( 'Gap', 'dina-kala' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="dico ico-Gap"></i>
            </a>
        </li>
        <?php } ?>

        <?php if ( dina_opt( 'so_eitaa' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="<?php echo dina_opt( 'so_eitaa_link' ); ?>" title="<?php _e( 'Eitaa', 'dina-kala' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="dico ico-Eitaa"></i>
            </a>
        </li>
        <?php } ?>

        <?php if ( dina_opt( 'so_bisphone' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="<?php echo dina_opt( 'so_bisphone_link' ); ?>" title="<?php _e( 'Bisphone', 'dina-kala' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="dico ico-Bisphone"></i>
            </a>
        </li>
        <?php } ?>

        <?php if ( dina_opt( 'so_bale' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="<?php echo dina_opt( 'so_bale_link' ); ?>" title="<?php _e( 'Bale', 'dina-kala' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="dico ico-Bale"></i>
            </a>
        </li>
        <?php } ?>

        <?php if ( dina_opt( 'so_igap' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="<?php echo dina_opt( 'so_igap_link' ); ?>" title="<?php _e( 'iGap', 'dina-kala' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="dico ico-iGap"></i>
            </a>
        </li>
        <?php } ?>

        <?php if ( dina_opt( 'so_rubika' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="<?php echo dina_opt( 'so_rubika_link' ); ?>" title="<?php _e( 'Rubika', 'dina-kala' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="dico ico-rubika"></i>
            </a>
        </li>
        <?php } ?>

        <?php if ( dina_opt( 'so_hoorsa' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="<?php echo dina_opt( 'so_hoorsa_link' ); ?>" title="<?php _e( 'Hoorsa', 'dina-kala' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="dico ico-hoorsa"></i>
            </a>
        </li>
        <?php } ?>

        <?php if ( dina_opt( 'so_phone' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="<?php echo dina_opt( 'so_phone_remove_tel' ) ? dina_opt( 'so_phone_link' ) : 'tel:'. dina_remove_dash( dina_opt( 'so_phone_link' ) ); ?>" title="<?php _e( 'Phone', 'dina-kala' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fal fa-phone" aria-hidden="true"></i>
            </a>
        </li>
        <?php } ?>

        <?php if ( dina_opt( 'so_mobile' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="<?php echo dina_opt( 'so_mobile_remove_tel' ) ? dina_opt( 'so_mobile_link' ) : 'tel:'. dina_remove_dash( dina_opt( 'so_mobile_link' ) ); ?>" title="<?php _e( 'Mobile', 'dina-kala' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fal fa-mobile-alt" aria-hidden="true"></i>
            </a>
        </li>
        <?php } ?>

        <?php if ( dina_opt( 'so_email' ) ) { ?>
        <li>
            <a <?php echo $link_schema; ?>href="mailto:<?php echo dina_opt( 'so_email_link' ); ?>" title="<?php _e( 'Email', 'dina-kala' ); ?>" target="_blank"<?php echo $social_nofollow; ?>>
                <i class="fal fa-at" aria-hidden="true"></i>
            </a>
        </li>
        <?php } ?>

    </ul>
    <?php
}

// dina_header_btns
function dina_header_btns() {

    do_action( 'dina_before_header_btns' );

    // Dark Mode Toggle
    if ( dina_opt( 'dina_dark_mode' ) && dina_opt( 'dina_dark_mode_switch' ) ) {
    ?>
        <div class="btn-di-toggle">
            <i aria-hidden="true" class="di-toggle-icon dina-toggle-dark <?= dina_opt( 'toggle_dark_icon' ) ?>" data-toggle="tooltip" data-placement="top" title="<?php _e( 'Dark mode', 'dina-kala' ); ?>"></i>
            <i aria-hidden="true" class="di-toggle-icon dina-toggle-light <?= dina_opt( 'toggle_light_icon' ) ?>" data-toggle="tooltip" data-placement="top" title="<?php _e( 'Light mode', 'dina-kala' ); ?>"></i>
        </div>
    <?php
    }
    
    // Wishlist Button
    if ( dina_opt( 'show_wish_list' ) ) {
        if ( class_exists( 'WooCommerce' ) && class_exists( 'YITH_WCWL' ) ) {
            $wcwl_url = esc_url( YITH_WCWL()->get_wishlist_url() ); ?>
            <div class="btn-wish dina-yith-wcwl-btn">
                <a href="<?php echo $wcwl_url; ?>" aria-label="<?php _e( 'Wishlist', 'dina-kala' ); ?>" rel="nofollow" class="wish-icon" data-toggle="tooltip" data-placement="top" title="<?php _e( 'Wishlist', 'dina-kala' ); ?>">
                    <i aria-hidden="true" class="<?= dina_opt( 'head_wish_list_icon' ) ?>"></i>
                    <i class="wish-amount"><?php echo do_shortcode( '[yith_wcwl_items_count]' ); ?></i>
                </a>
            </div>
        <?php 
        }
    } 
    
    // Compare Button
    if ( dina_opt( 'show_compare_btn' ) ) {
    if ( class_exists( 'WooCommerce' ) && class_exists( 'YITH_Woocompare' ) ) {
        global $yith_woocompare; ?>
        <div class="btn-compare dina-yith-compare">
            <a href="<?php echo $yith_woocompare->obj->view_table_url() ?>" aria-label="<?php _e( 'Compare Products', 'dina-kala' ); ?>" rel="nofollow" class="compare-icon compare-link" data-toggle="tooltip" data-placement="top" title="<?php _e( 'Compare Products', 'dina-kala' ); ?>">
                <i aria-hidden="true" class="<?= dina_opt( 'head_compare_btn_icon' ) ?>"></i>
            </a>
        </div>
    <?php } elseif ( class_exists( 'WooCommerce' ) && defined( 'WCCM_VERISON' ) ) {
    $compare_url = wccm_get_compare_page_link( wccm_get_compare_list() );
    $compare_count = count(wccm_get_compare_list() ); ?>
        <div class="btn-compare">
            <a href="<?php echo $compare_url; ?>" aria-label="<?php _e( 'Compare Products', 'dina-kala' ); ?>" rel="nofollow" class="compare-icon compare-link" data-toggle="tooltip" data-placement="top" title="<?php _e( 'Compare Products', 'dina-kala' ); ?>">
                <i aria-hidden="true" class="<?= dina_opt( 'head_compare_btn_icon' ) ?>"></i>
                <i class="compare-amount"><?php echo $compare_count; ?></i>
            </a>
        </div>
    <?php } } 
    
    // Cart Button
    if ( class_exists( 'WooCommerce' ) && ! dina_opt( 'product_catalog_mode' ) && dina_opt( 'show_cart_btn' ) ) { ?>
    <div class="btn-cart">
        <?php if ( ! dina_opt( 'direct_cart_link' ) ) { ?>
            <span class="shop-icon" data-toggle="tooltip" data-placement="top" title="<?php _e( 'Shopping cart', 'dina-kala' ); ?>" onclick="dinaOpenCart()">
                <i aria-hidden="true" class="<?= dina_opt( 'head_cart_btn_icon' ) ?>"></i>
                <i class="dina-cart-amount">
                    <?php echo dina_cart_amount() ?>
                </i>
            </span>
        <?php } else { ?>
            <a class="shop-icon" data-toggle="tooltip" data-placement="top" title="<?php _e( 'Shopping cart', 'dina-kala' ); ?>" href="<?php echo wc_get_cart_url() ?>">
                <i aria-hidden="true" class="<?= dina_opt( 'head_cart_btn_icon' ) ?>"></i>
                <i class="dina-cart-amount">
                    <?php echo dina_cart_amount() ?>
                </i>
            </a>
        <?php } ?>
    </div>
    <?php }
    
    do_action( 'dina_after_header_btns' );
}

// dina_menu_bar_btn
function dina_menu_bar_btn() {
    if ( dina_opt( 'menu_bar_btn' ) && \c1e73e8486db872bfe089f271e35b::d1633996f5bf2c5d2a78dde2b() ) { ?>
        <a class="btn <?php echo dina_opt( 'menu_bar_btn_color' ); ?> dina-menu-bar-btn" href="<?php echo dina_opt( 'menu_bar_btn_link' ); ?>" title="<?php echo dina_opt( 'menu_bar_btn_text' ); ?>">
            <span class="dina-menu-btn-icon <?php echo dina_opt( 'menu_bar_btn_icon' ); ?>"></span>
            <?php echo dina_opt( 'menu_bar_btn_text' ); ?>
        </a>
    <?php }
}

function dina_mobile_header_menu_cart_btn() {
    
    if ( ! dina_opt( 'ch_menu_cart' ) ) { ?>
        <span class="btn btn-light mmenu<?php if ( dina_opt( 'mobile_menu_text_style' ) ) { echo ' menu-btn-text-style'; } ?>" onclick="openNav()">
            <i aria-hidden="true" data-title="<?php echo dina_opt( 'mobile_menu_text' ) ?>" class="fal fa-bars"></i>
        </span>
    <?php
    } elseif ( class_exists( 'WooCommerce' ) && ! dina_opt( 'product_catalog_mode' ) ) {
        if ( ! dina_opt( 'direct_cart_link' ) ) { ?>
            <span class="btn btn-light mobile-header-cart" onclick="dinaOpenCart()">
                <span aria-hidden="true" class="<?= dina_opt( 'head_cart_btn_icon' ) ?>">
                    <span class="dina-cart-amount">
                        <?php echo dina_cart_amount() ?>
                    </span>
                </span>
            </span>
        <?php } else { ?>
            <a class="btn btn-light mobile-header-cart" title="<?php _e( 'Shopping cart', 'dina-kala' ); ?>" href="<?php echo wc_get_cart_url() ?>">
                <span aria-hidden="true" class="<?= dina_opt( 'head_cart_btn_icon' ) ?>">
                    <span class="dina-cart-amount">
                        <?php echo dina_cart_amount() ?>
                    </span>
                </span>
            </a>
        <?php }
    }
}

// dina_mobile_user_btns
function dina_mobile_user_btns() {

    if ( ! dina_opt( 'show_user_btn' ) ) 
        return;

    if ( ! is_user_logged_in() ) {
        if ( dina_opt( 'replace_userbtns_shortcode' ) ) {
            echo do_shortcode( dina_opt( 'userbtns_shortcode' ) );
        } elseif ( function_exists( 'digits_version' ) && dina_opt( 'digits_mode' ) ) {
            $digits_mode = ( dina_opt( 'digits_page' ) ? 'digitlink' : 'digitpopup' ); ?>
            <span title="<?php _e( 'Login Or Register', 'dina-kala' ); ?>" class="btn btn-light mlogin mergedbtn digitsbtn <?php echo $digits_mode; ?>">
                <i aria-hidden="true" data-title="<?php _e( 'Login', 'dina-kala' ); ?>" class="fal fa-user"></i>
                <span class="login-separator">|</span>
                <i aria-hidden="true" data-title="<?php _e( 'Register', 'dina-kala' ); ?>" class="fal fa-user-plus"></i>
            </span>
        <?php } else { ?>
            <a title="<?php _e( 'Login Or Register', 'dina-kala' ); ?>" class="btn btn-light mlogin mergedbtn" <?php if ( dina_opt( 'ch_login_link' ) ) { echo 'href="'. dina_opt( 'login_link' ) .'"'; } else { echo 'href="javascript:void(0)" onclick="openLogin()"'; } ?>>
                <i aria-hidden="true" data-title="<?php _e( 'Login', 'dina-kala' ); ?>" class="fal fa-user"></i>
                <span class="login-separator">|</span>
                <i aria-hidden="true" data-title="<?php _e( 'Register', 'dina-kala' ); ?>" class="fal fa-user-plus"></i>
            </a>
        <?php }
    } else { ?>
        <a title="<?php _e( 'User Menu', 'dina-kala' ); ?>" class="btn btn-light musermenu" onclick="openUmenu()">
            <i aria-hidden="true" data-title="<?php _e( 'User Menu', 'dina-kala' ); ?>" class="fal fa-user"></i>
        </a>
    <?php }
}

// dina_user_btns
function dina_user_btns() {

    if ( ! dina_opt( 'show_user_btn' ) ) 
        return;

    if ( ! is_user_logged_in() ) {
        if ( dina_opt( 'replace_userbtns_shortcode' ) ) { 
            echo do_shortcode( dina_opt( 'userbtns_shortcode' ) );
        } elseif ( function_exists( 'digits_version' ) && dina_opt( 'digits_mode' ) ) { 
            $digits_mode = ( dina_opt( 'digits_page' ) ? 'digitlink' : 'digitpopup' );
            $btn_classes = dina_opt( 'user_btn_style' ) ? 'register-link digitsbtn '. $digits_mode : 'btn btn-success dina-btn-register digitsbtn ' . $digits_mode;
        ?>
            <span title="<?php _e( 'Login Or Register', 'dina-kala' ); ?>" class="<?php echo $btn_classes; ?>">
                <i aria-hidden="true" class="fal fa-user"></i>
                <?php _e( 'Login | Register', 'dina-kala' ); ?>
            </span>
        <?php } else {
            $btn_classes = dina_opt( 'user_btn_style' ) ? 'register-link merge-btn' : 'btn btn-success dina-btn-register merge-btn';
            $login_link  = dina_opt( 'ch_login_link' ) ? 'href="'. dina_opt( 'login_link' ) .'"' : 'href="javascript:void(0)" onclick="openLogin()"';
        ?>
            <a title="<?php _e( 'Login Or Register', 'dina-kala' ); ?>" <?php echo $login_link ?>
            class="<?php echo $btn_classes ?>">
                <i aria-hidden="true" class="fal fa-user"></i>
                <?php _e( 'Login | Register', 'dina-kala' ); ?>
            </a>
        <?php }
    } else {
        $user = wp_get_current_user(); ?>
        <div class="dropdown user-drop">
            <button class="dropdown-toggle user-menu" type="button">
            <?php if ( class_exists( 'WooCommerce' ) ) { ?>
                <a href="<?php echo esc_url( dina_myaccount_link() ); ?>" title="<?php _e( 'Dashboard', 'dina-kala' ); ?>">
            <?php } ?>
                <?php echo get_avatar( get_current_user_id() , 32, '', $user->display_name ); ?>
                <span class="user-name">
                    <?php echo $user->display_name; ?>
                    <?php if ( ! empty ( dina_get_wallet() ) ) {       
                        echo '<span class="wallet"> | '. dina_get_wallet() .'</span>';
                    } ?>
                </span>
                <span class="fal fa-chevron-down user-chevron-down" aria-hidden="true"></span>
            <?php if ( class_exists( 'WooCommerce' ) ) { ?>
                </a>
            <?php } ?>
            </button>

            <?php if ( dina_opt( 'replace_user_menu' ) && has_nav_menu( 'user_menu' ) ) { ?>
                <?php
                    wp_nav_menu( array(
                        'menu'              => 'user_menu',
                        'theme_location'    => 'user_menu',
                        'menu_class'        => 'dropdown-menu user-menu mu-menu col-12',
                        'depth'             => 1,
                        'container'         => ''
                        )
                    );
                ?>
            <?php } elseif ( class_exists( 'WooCommerce' ) ) { ?>
                <ul class="dropdown-menu user-menu mu-menu col-12">
                    <?php get_template_part( 'includes/umenu' ); ?>
                </ul>
            <?php } ?>
            
        </div>
    <?php }
}

// dina_cart_mobile_search
function dina_cart_mobile_search() {
    if ( ! dina_opt( 'mobile_search' ) || ! dina_opt( 'cart_mobile_search' ) )
        return;

    if ( ! dina_opt( 'direct_cart_link' ) ) { ?>
        <span class="cart-mobile-search" onclick="dinaOpenCart()">
            <span aria-hidden="true" class="<?= dina_opt( 'head_cart_btn_icon' ) ?> ">
                <span class="dina-cart-amount">
                    <?php echo dina_cart_amount() ?>
                </span>
            </span>
        </span>
    <?php } else { ?>
        <a class="cart-mobile-search" title="<?php _e( 'Shopping cart', 'dina-kala' ); ?>" href="<?php echo wc_get_cart_url() ?>">
            <span aria-hidden="true" class="<?= dina_opt( 'head_cart_btn_icon' ) ?> ">
                <span class="dina-cart-amount">
                    <?php echo dina_cart_amount() ?>
                </span>
            </span>
        </a>
    <?php } 
}