<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class Dina_El_Icon_Picker_Control extends Base_Data_Control {

    public function get_type() {
        return 'dina_iconpicker';
    }

    protected function get_default_settings() {
		return [
			'label_block' => true
		];
	}

    public function enqueue() {
        wp_register_style( 'dina-icon-picker-style', DI_URI . '/includes/el-widgets/controls/assets/icon-picker.css' );
        wp_register_script( 'dina-icon-picker-script', DI_URI . '/includes/el-widgets/controls/assets/icon-picker.js', array( 'jquery' ), DI_VER, false );

        wp_enqueue_style( 'dina-icon-picker-style' );
        wp_enqueue_script( 'dina-icon-picker-script' );

        wp_localize_script( 'dina-icon-picker-script', 'DinaElIconPicker', array(
            'ajaxurl' => admin_url( 'admin-ajax.php' ),
            'i18n' => array(
                'search'  => __('Search icons...', 'dina-kala'),
                'loading' => __('Loading icons...', 'dina-kala')
            ),
         ) );
    }

    public function content_template() {
        $control_uid = $this->get_control_uid();
        ?>
        <div class="elementor-control-field">
            <# if ( data.label ) {#>
				<label for="<?php echo $control_uid; ?>" class="elementor-control-title">{{{ data.label }}}</label>
			<# } #>
            <div class="elementor-control-input-wrapper">
                <div class="dina-icon-picker-control">
                    <input type="hidden" id="<?php echo $control_uid; ?>" data-setting="{{ data.name }}" value="{{ data.controlValue }}" class="dina-icon-picker-value" />
                    <span class="dina-icon-preview"></span>
                    <button type="button" class="button elementor-button dina-el-icon-picker-trigger"><?php _e( 'Choose Icon', 'dina-kala' ); ?></button>
                </div>
			</div>
            
            <# if ( data.description ) { #>
			<div class="elementor-control-field-description">{{{ data.description }}}</div>
		    <# } #>
        </div>
        <?php
    }
}