(function ($) {
    // اطمینان از لود شدن jQuery و Elementor
    $(window).on('elementor:init', function () {
        var DinaIconPickerControl = elementor.modules.controls.BaseData.extend({
            // متد onReady برای مقداردهی اولیه کنترل
            onReady: function () {
                var self = this;

                // پیدا کردن المنت‌های کنترل
                var $input = this.$el.find('.dina-icon-picker-value');
                var $trigger = this.$el.find('.dina-el-icon-picker-trigger');
                var $preview = this.$el.find('.dina-icon-preview');

                // ایجاد پاپ‌آپ فقط در صورت عدم وجود
                let $iconPopup = $('.dina-icon-picker-modal-backdrop');
                if (!$iconPopup.length) {
                    $iconPopup = $(
                        '<div class="dina-icon-picker-modal-backdrop">' +
                            '<div class="dina-icon-picker-modal">' +
                                '<button class="dina-icon-picker-close">&times;</button>' +
                                '<input type="text" class="dina-icon-picker-search" placeholder="' +
                                (DinaElIconPicker.i18n?.search || 'Search icons...') + '" />' +
                                '<div class="dina-icon-picker-grid"><span>' +
                                (DinaElIconPicker.i18n?.loading || 'Loading...') + '</span></div>' +
                            '</div>' +
                        '</div>'
                    );
                    $('body').append($iconPopup);
                }

                // نمایش آیکن ذخیره‌شده (اگر وجود داشته باشد)
                var savedIcon = this.getControlValue();
                if (savedIcon) {
                    $preview.attr('class', 'dina-icon-preview fal fa-' + savedIcon);
                    $input.val(savedIcon);
                }

                $trigger.on('click', function () {
                    openDinaIconPopup(function (selectedIconClass) {
                        var iconName = selectedIconClass.replace('fal fa-', '');
                        $input.val(iconName).trigger('input');
                        $preview.attr('class', 'dina-icon-preview ' + selectedIconClass);
                        self.setValue(iconName);
                    });
                });
            },

            // متد destroy برای تمیز کردن
            onDestroy: function () {
                $('.dina-icon-picker-modal-backdrop').remove();
            }
        });

        // ثبت کنترل در Elementor
        elementor.addControlView('dina_iconpicker', DinaIconPickerControl);
    });

    // تابع باز کردن پاپ‌آپ
    function openDinaIconPopup(onIconSelected) {
        let $iconPopup = $('.dina-icon-picker-modal-backdrop');
        const $grid = $iconPopup.find('.dina-icon-picker-grid');
        const $searchInput = $iconPopup.find('.dina-icon-picker-search');

        // بررسی وجود پاپ‌آپ
        if (!$iconPopup.length) {
            return;
        }

        // نمایش پاپ‌آپ
        $iconPopup.fadeIn().css({ display: 'flex' });
        $grid.html('<span>' + (DinaElIconPicker.i18n?.loading || 'Loading...') + '</span>');

        // بارگذاری آیکن‌ها
        if (!window._dinaIconsLoaded) {
            $.post(DinaElIconPicker.ajaxurl, { action: 'dina_el_load_icons' }, function (response) {
                if (response && typeof response === 'object') {
                    window._dinaIconsLoaded = response;
                    renderIcons(response);
                } else {
                    $grid.html('<span>Error: Failed to load icons</span>');
                }
            }).fail(function () {
                $grid.html('<span>Error: Failed to load icons</span>');
            });
        } else {
            renderIcons(window._dinaIconsLoaded);
        }

        // رندر آیکن‌ها
        function renderIcons(icons) {
            $grid.empty();
            Object.keys(icons).forEach(function (name) {
                const className = `fal fa-${name}`;
                const $icon = $('<i>', {
                    class: className,
                    title: name,
                    style: 'cursor: pointer; padding: 10px; font-size: 24px;'
                });

                $icon.on('click', function () {
                    $iconPopup.fadeOut();
                    if (typeof onIconSelected === 'function') {
                        onIconSelected(className);
                    }
                });

                $grid.append($icon);
            });
        }

        // جستجو با debounce
        $searchInput.val('').off('input').on('input', _.debounce(function () {
            const q = $(this).val().toLowerCase();
            $grid.find('i').each(function () {
                const title = $(this).attr('title').toLowerCase();
                $(this).toggle(title.includes(q));
            });
        }, 300));

        // بستن پاپ‌آپ
        $iconPopup.find('.dina-icon-picker-close').off('click').on('click', function () {
            $iconPopup.fadeOut();
        });

        $iconPopup.off('click').on('click', function (e) {
            if ($(e.target).is('.dina-icon-picker-modal-backdrop')) {
                $iconPopup.fadeOut();
            }
        });
    }
})(jQuery);