<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Demo Website: dinakala.i-design.ir
Author Website: i-design.ir
*/

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) )
    exit;

Redux::setSection( $opt_name, array(
    'title' => __( 'Product Settings', 'dina-kala' ),
    'id'    => 'product_setting',
    'icon'  => 'fal fa-shopping-cart',
) );

//Product archive SECTION
Redux::setSection( $opt_name, array(
    'title'      => __( 'Product archive', 'dina-kala' ),
    'id'         => 'product_archive_setting',
    'icon'       => 'fal fa-bags-shopping',
    'subsection' => true,
    'fields'     => array(
        array( 
            'id'       => 'product_archive_setting_docs',
            'type'     => 'raw',
            'content'  => dina_admin_info( '', 'https://i-design.ir/docs/dinakala/?p=2196', 'info' )
        ),
        array(
            'id'       => 'product_archive_side',
            'type'     => 'image_select',
            'title'    => __( 'Products Archive Sidebar', 'dina-kala' ),
            'subtitle' => __( 'Specify the location of the products sidebar in archive pages (Category page, Tag page, ...)', 'dina-kala' ),
            'options'  => array(
                '0' => array(
                    'alt' => __( 'No sidebar', 'dina-kala' ),
                    'img' => RE_URI . 'assets/img/1c.png'
                ),
                '1' => array(
                    'alt' => __( 'Left alignment', 'dina-kala' ),
                    'img' => RE_URI . 'assets/img/2cl.png'
                ),
                '2' => array(
                    'alt' => __( 'Right alignment', 'dina-kala' ),
                    'img' => RE_URI . 'assets/img/2cr.png'
                )
            ),
            'default'  => '1'
        ),
        array(
            'id'       => 'shop_page_side',
            'type'     => 'switch',
            'title'    => __( 'Separate shop page sidebar', 'dina-kala' ),
            'subtitle' => __( 'Separate shop page sidebar from archive pages', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'product_num',
            'type'     => 'select',
            'title'    => __( 'Number of products', 'dina-kala' ),
            'subtitle' => __( 'Number of products in archive pages', 'dina-kala' ),
            'options'  => $col_number,
            'default'  => 12,
        ),
        array(
            'id'       => 'product_col',
            'type'     => 'select',
            'title'    => __( 'Number of products columns', 'dina-kala' ),
            'subtitle' => __( 'Number of products columns in archive pages', 'dina-kala' ),
            'options'  => array(
                2 =>  2,
                3 =>  3,
                4 =>  4,
                5 =>  5,
            ),
            'default'  => 4,
        ),

        array(
            'id'       => 'mobile_single_row',
            'type'     => 'switch',
            'title'    => __( 'Display single row products in mobile mode', 'dina-kala' ),
            'subtitle' => __( 'Display single row products on archive pages in mobile mode', 'dina-kala' ),
            'default'  => false,
        ),

        array(
            'id'       => 'mobile_single_col',
            'type'     => 'switch',
            'title'    => __( 'Display single column products in mobile mode', 'dina-kala' ),
            'subtitle' => __( 'Display single column products on archive pages and product blocks in mobile mode', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'mobile_single_row', '!=', true ),
        ),
        array(
            'id'       => 'enable_woo_hook',
            'type'     => 'switch',
            'title'    => __( 'Activate WooCommerce Hooks on product archive pages', 'dina-kala' ),
            'subtitle' => __( 'WooCommerce Hooks is used by some plugins to insert content into products on archive pages, so enabling this option may cause confusion in products on archive pages.', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'open_prod_new_tab',
            'type'     => 'switch',
            'title'    => __( 'Open product and post link in a new window/tab', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'disable_archive_ajax_add',
            'type'     => 'switch',
            'title'    => __( 'Disabling Add to Cart Ajax on archive pages', 'dina-kala' ),
            'subtitle' => __( 'By activating this option, the Ajax add to cart button will be removed from the archive pages and the product view button will be displayed', 'dina-kala' ),
            'default'  => false,
        ),

        array(
            'id'       => 'show_count_archive',
            'type'     => 'switch',
            'title'    => __( 'Ability to select the number of products on archive pages', 'dina-kala' ),
            'subtitle' => __( 'By activating this option, users can select the number of products added to the shopping cart on the main page and archive pages (category, etc.).', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'disable_archive_ajax_add', '!=', true ),
        ),
        array(
            'id'       => 'show_star_rating',
            'type'     => 'switch',
            'title'    => __( 'Show product star rating', 'dina-kala' ),
            'subtitle' => __( 'Show product star rating in archive pages', 'dina-kala' ),
            'default'  => false,
        ),

        array(
            'id'      => 'stock_order',
            'type'    => 'switch',
            'title'   => __( 'Show out of stock products at the end of the product list', 'dina-kala' ),
            'default' => false,
        ),
        array(
            'id'       => 'ajax_prod',
            'type'     => 'switch',
            'title'    => __( 'Ajax Products Loading', 'dina-kala' ),
            'subtitle' => __( 'Loading products ajax and remove pagination', 'dina-kala' ),
            'default'  => true,
        ),
        array(
            'id'       => 'ajax_prod_auto',
            'type'     => 'switch',
            'title'    => __( 'Automatic loading of more products', 'dina-kala' ),
            'subtitle' => __( 'Automatic loading of more products when reaching the end of products', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'ajax_prod', '=', true ),
        ),
        array(
            'id'       => 'ajax_prod_history',
            'type'     => 'switch',
            'title'    => __( 'Show page number', 'dina-kala' ),
            'subtitle' => __( 'Display page number in Ajax loading mode', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'ajax_prod', '=', true ),
        ),
        array(
            'id'       => 'show_filters_closed',
            'type'     => 'switch',
            'title'    => __( 'Showing product archive filters in a closed form', 'dina-kala' ),
            'subtitle' => __( 'By activating this option, the filter widgets on the product archive pages will be displayed as closed with the ability to open', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'show_filter',
            'type'     => 'switch',
            'title'    => __( 'Show filter button', 'dina-kala' ),
            'subtitle' => __( 'Show the filter button at the top of the products on the archive page', 'dina-kala' ),
            'default'  => true,
        ),
        array(
            'id'       => 'product_discount_location',
            'type'     => 'select',
            'title'    => __( 'Discount percentage display position on archive pages', 'dina-kala' ),
            'subtitle' => __( 'Specify the location according to the location of other elements', 'dina-kala' ),
            'options'  => array(
                'product-discount-left'  => __( 'Left side', 'dina-kala' ),
                'product-discount-right' => __( 'Right side', 'dina-kala' ),
            ),
            'default'  => 'product-discount-left',
        ),
        array(
            'id'       => 'product_discount_style',
            'type'     => 'select',
            'title'    => __( 'Style for displaying discount percentages on archive pages', 'dina-kala' ),
            'options'  => array(
                'default'     => __( 'Default', 'dina-kala' ),
                'circle'      => __( 'Circle', 'dina-kala' ),
                'seal'        => __( 'Seal', 'dina-kala' ),
                'octagon'     => __( 'Octagon', 'dina-kala' ),
                'hexagon'     => __( 'Hexagon', 'dina-kala' ),
                'certificate' => __( 'Certificate', 'dina-kala' ),
            ),
            'default'  => 'default',
        ),

        //product-title-tag-section-start
        array(
            'id'     => 'product-title-tag-section-start',
            'type'   => 'section',
            'title'  => __( 'Product title tag settings', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'       => 'product_title_tag_home',
            'type'     => 'select',
            'title'    => __( 'Product title tag on home page', 'dina-kala' ),
            'options'  => array(
                'div' => __( 'div', 'dina-kala' ),
                'h2'  => __( 'h2', 'dina-kala' ),
                'h3'  => __( 'h3', 'dina-kala' ),
                'h4'  => __( 'h4', 'dina-kala' ),
            ),
            'default'  => 'div',
        ),
        array(
            'id'       => 'product_title_tag_archive',
            'type'     => 'select',
            'title'    => __( 'Product title tag on archive pages', 'dina-kala' ),
            'options'  => array(
                'div' => __( 'div', 'dina-kala' ),
                'h2'  => __( 'h2', 'dina-kala' ),
                'h3'  => __( 'h3', 'dina-kala' ),
                'h4'  => __( 'h4', 'dina-kala' ),
            ),
            'default'  => 'div',
        ),
        array(
            'id'     => 'product-title-tag-section-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //product-title-tag-section-end

        array(
            'id'     => 'hover-btns-section-start',
            'type'   => 'section',
            'title'  => __( 'Product hover button settings', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'       => 'quick_btns_location',
            'type'     => 'select',
            'title'    => __( 'Display position', 'dina-kala' ),
            'subtitle' => __( 'Specify the location according to the location of other elements', 'dina-kala' ),
            'options'  => array(
                'quick-btns-left'   => __( 'Left side', 'dina-kala' ),
                'quick-btns-right'  => __( 'Right side', 'dina-kala' ),
                'quick-btns-center' => __( 'Center', 'dina-kala' ),
            ),
            'default'  => 'quick-btns-left',
        ),
        array(
            'id'      => 'quick_btns_fix_mobile',
            'type'    => 'switch',
            'title'   => __( 'Display buttons fixed in mobile mode', 'dina-kala' ),
            'default' => false,
        ),
        array(
            'id'       => 'show_quick_view',
            'type'     => 'switch',
            'title'    => __( 'Show product quick view button', 'dina-kala' ),
            'subtitle' => __( 'Show product quick view button in archive pages', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'like_prod_archive',
            'type'     => 'switch',
            'title'    => __( 'Show product like button', 'dina-kala' ),
            'subtitle' => __( 'Show product like button in archive pages', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'compare_prod_archive',
            'type'     => 'switch',
            'title'    => __( 'Show product compare button', 'dina-kala' ),
            'subtitle' => __( 'Show product compare button in archive pages', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'     => 'hover-btns-section-end',
            'type'   => 'section',
            'indent' => false,
        ),
        
        //subcats-section-start'
        array(
            'id'     => 'subcats-section-start',
            'type'   => 'section',
            'title'  => __( 'Subcategory settings', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'      => 'show_sub_cats',
            'type'    => 'switch',
            'title'   => __( 'Show subcategories on the product category page', 'dina-kala' ),
            'default' => false,
        ),
        array(
            'id'      => 'show_sub_cats_shop',
            'type'    => 'switch',
            'title'   => __( 'Show subcategories on the shop page', 'dina-kala' ),
            'default' => false,
            'required' => array( 'show_sub_cats', '=', true ),
        ),
        array(
            'id'      => 'sub_cats_center',
            'type'    => 'switch',
            'title'   => __( 'Show subcategories in center alignment', 'dina-kala' ),
            'default' => false,
            'required' => array( 'show_sub_cats', '=', true ),
        ),
        array(
            'id'       => 'show_sub_cats_image',
            'type'     => 'switch',
            'title'    => __( 'Show subcategory image', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'show_sub_cats', '=', true ),
        ),
        array(
            'id'       => 'sub_cats_image_size',
            'type'     => 'select',
            'title'    => __( 'Image size', 'dina-kala' ),
            'options'  => array(
                'thumbnail'             => __( '150 * 150', 'dina-kala' ),
                'woocommerce_thumbnail' => __( '300 * 300', 'dina-kala' )
            ),
            'default'  => 'thumbnail',
            'required' => array( 'show_sub_cats_image', '=', true ),
        ),
        array(
            'id'       => 'show_sub_cats_title',
            'type'     => 'switch',
            'title'    => __( 'Show subcategory title', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'show_sub_cats', '=', true ),
        ),
        array(
            'id'       => 'show_sub_cats_mobile',
            'type'     => 'switch',
            'title'    => __( 'Show subcategories in mobile mode', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'show_sub_cats', '=', true ),
        ),
        array(
            'id'       => 'show_sub_cats_col',
            'type'     => 'text',
            'title'    => __( 'Columns count', 'dina-kala' ),
            'default'  => 8,
            'required' => array( 'show_sub_cats', '=', true ),
        ),
        array(
            'id'     => 'subcats-section-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //cat-desc-section-start
        array(
            'id'     => 'cat-desc-section-start',
            'type'   => 'section',
            'title'  => __( 'Category description settings', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_on_top_cat',
            'type'     => 'switch',
            'title'    => __( 'Show on top', 'dina-kala' ),
            'subtitle' => __( 'Show on top of products', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'show_first_text_cat',
            'type'     => 'switch',
            'title'    => __( 'Show category description only on the first page', 'dina-kala' ),
            'subtitle' => __( 'In case the ajax loading of products is disabled', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'show_full_text_cat',
            'type'     => 'switch',
            'title'    => __( 'Show full text', 'dina-kala' ),
            'subtitle' => __( 'Show full text instead of summary', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'     => 'cat-desc-section-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //arch-title-section-start
        array(
            'id'     => 'arch-title-section-start',
            'type'   => 'section',
            'title'  => __( 'Product archive title settings', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_archive_title',
            'type'     => 'switch',
            'title'    => __( 'Show product archive title', 'dina-kala' ),
            'subtitle' => __( 'Add archive title to woocommerce archive pages', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'show_archive_title_mobile',
            'type'     => 'switch',
            'title'    => __( 'Show product archive title in mobile mode', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'show_archive_title', '=', true ),
        ),
        array(
            'id'     => 'arch-title-section-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //archive-swatches-section-start
        array(
            'id'     => 'archive-swatches-section-start',
            'type'   => 'section',
            'title'  => __( 'Product attribute display settings on archive pages', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_swatches_archive',
            'type'     => 'switch',
            'title'    => __( 'Displaying product attribute on archive pages', 'dina-kala' ),
            'subtitle' => __( 'With this option, you can display the color scheme or other attributes of the product on the product archive pages', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'swatches_archive_attr',
            'type'     => 'select',
            'title'    => __( 'Select the attribute', 'dina-kala' ),
            'options'  => dina_product_attributes_array(),
            'required' => array( 'show_swatches_archive', '=', true ),
        ),
        array(
            'id'       => 'swatches_archive_attr_alternative',
            'type'     => 'select',
            'title'    => __( 'Select an alternative attribute', 'dina-kala' ),
            'subtitle' => __( 'If a product does not have a high attribute, this attribute will be displayed', 'dina-kala' ),
            'options'  => dina_product_attributes_array(),
            'required' => array( 'show_swatches_archive', '=', true ),
        ),
        array(
            'id'       => 'swatches_archive_location',
            'type'     => 'select',
            'title'    => __( 'Display position', 'dina-kala' ),
            'subtitle' => __( 'If you are using a product label or a product percent off label, it may not be appropriate to choose the display location in the corners', 'dina-kala' ),
            'options'  => array(
                'swatches-bottom-image'  => __( 'Bottom of product image', 'dina-kala' ),
                'swatches-above-title'   => __( 'Above the product title', 'dina-kala' ),
                'swatches-between-title' => __( 'Between the product title and price', 'dina-kala' ),
                'swatches-right-side'    => __( 'Right side', 'dina-kala' ),
                'swatches-left-side'     => __( 'Left side', 'dina-kala' ),
                'swatches-right-corner'  => __( 'Right corner', 'dina-kala' ),
                'swatches-left-corner'   => __( 'Left corner', 'dina-kala' ),
            ),
            'default'  => 'swatches-bottom-image',
        ),
        array(
            'id'       => 'show_swatches_archive_instock',
            'type'     => 'switch',
            'title'    => __( 'Only the attributes in stock are displayed', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_swatches_archive', '=', true ),
        ),
        array(
            'id'       => 'show_swatches_archive_title',
            'type'     => 'switch',
            'title'    => __( 'Show title of the attribute', 'dina-kala' ),
            'subtitle' => __( 'Show title of the attribute when hovering the mouse', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'show_swatches_archive', '=', true ),
        ),
        array(
            'id'       => 'swatches_circle_style',
            'type'     => 'switch',
            'title'    => __( 'Display in circle style', 'dina-kala' ),
            'subtitle' => __( 'For color attributes', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_swatches_archive', '=', true ),
        ),
        array(
            'id'       => 'enable_swatches_archive_count',
            'type'     => 'switch',
            'title'    => __( 'Show limited values', 'dina-kala' ),
            'subtitle' => __( 'By enabling this option, you can limit the number of displayed values', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_swatches_archive', '=', true ),
        ),
        array(
            'id'            => 'swatches_archive_count',
            'type'          => 'slider',
            'title'         => __( 'Number of visible values', 'dina-kala' ),
            "default"       => 5,
            "min"           => 1,
            "step"          => 1,
            "max"           => 20,
            'display_value' => 'label',
            'required'      => array( 'enable_swatches_archive_count', '=', true ),
        ),
        array(
            'id'     => 'archive-swatches-section-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //archive-swatches-section-end

        //cat-slider-section-start
        array(
            'id'     => 'cat-slider-section-start',
            'type'   => 'section',
            'title'  => __( 'Product Archive and shop slider settings', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'       => 'cat_slider_show',
            'type'     => 'switch',
            'title'    => __( 'Show slider in product archive page', 'dina-kala' ),
            'subtitle' => __( 'If the product archive (category, tag and brand) has a slider, enabling this option will cause the slider to be displayed on the product archive page. To insert the slider, edit the product archive you want from the product category, tag or brand section.', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'shop_slider_show',
            'type'     => 'switch',
            'title'    => __( 'Show slider in woocommerce shop page', 'dina-kala' ),
            'subtitle' => __( 'To insert the slider, edit the shop page.', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'cat_slider_show', '=', true ),
        ),
        array(
            'id'       => 'show_cat_slider_first',
            'type'     => 'switch',
            'title'    => __( 'Show product archive slider only on the first page', 'dina-kala' ),
            'subtitle' => __( 'In case the ajax loading of products is disabled', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'cat_slider_show', '=', true ),
        ),
        array(
            'id'       => 'cat_slider_top',
            'type'     => 'switch',
            'title'    => __( 'Show the slider under the breadcrumbs section', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'cat_slider_show', '=', true ),
        ),
        array(
            'id'       => 'cat_slider_show_arrows',
            'type'     => 'switch',
            'title'    => __( 'Show arrows', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'cat_slider_show', '=', true ),
        ),
        array(
            'id'       => 'cat_slider_auto_play',
            'type'     => 'switch',
            'title'    => __( 'Auto play', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'cat_slider_show', '=', true ),
        ),
        array(
            'id'            => 'cat_slider_time',
            'type'          => 'slider',
            'title'         => __( 'Auto play speed(ms)', 'dina-kala' ),
            "default"       => 8000,
            "min"           => 1000,
            "step"          => 1000,
            "max"           => 20000,
            'display_value' => 'label',
            'required'      => array( 'cat_slider_show', '=', true ),
        ),
        array(
            'id'       => 'cat_slider_pause_over',
            'type'     => 'switch',
            'title'    => __( 'Pause slider on mouse over', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'cat_slider_show', '=', true ),
        ),
        array(
            'id'       => 'cat_slider_show_dots',
            'type'     => 'switch',
            'title'    => __( 'Show navigation\'s dots', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'cat_slider_show', '=', true ),
        ),
        array(
            'id'       => 'cat_slider_show_title',
            'type'     => 'switch',
            'title'    => __( 'Show slide titles instead of navigation points', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'cat_slider_show', '=', true ),
        ),
        array(
            'id'     => 'cat-slider-section-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //cat-slider-section-end

        //product-label-section-start
        array(
            'id'     => 'product-label-section-start',
            'type'   => 'section',
            'title'  => __( 'Product label settings', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_product_label',
            'type'     => 'switch',
            'title'    => __( 'Show product label', 'dina-kala' ),
            'subtitle' => __( 'This tag is displayed on the product page and archive pages on the product image and is edited for each product on the product edit page.', 'dina-kala' ),
            'default'  => true,
        ),
        array(
            'id'       => 'product_label_location',
            'type'     => 'select',
            'title'    => __( 'Display position on archive pages', 'dina-kala' ),
            'subtitle' => __( 'Specify the location according to the location of other elements', 'dina-kala' ),
            'options'  => array(
                'product-label-right' => __( 'Right side', 'dina-kala' ),
                'product-label-left'  => __( 'Left side', 'dina-kala' ),
            ),
            'default'  => 'product-label-right',
        ),
        array(
            'id'       => 'product_label_single',
            'type'     => 'switch',
            'title'    => __( 'Show product label on product page', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'show_product_label', '=', true ),
        ),
        array(
            'id'       => 'product_label_single_mobile',
            'type'     => 'switch',
            'title'    => __( 'Show product label on product page in mobile mode', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'product_label_single', '=', true ),
        ),
        array(
            'id'       => 'product_label_archive',
            'type'     => 'switch',
            'title'    => __( 'Show product label on product archive pages', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'show_product_label', '=', true ),
        ),
        array(
            'id'       => 'product_label_archive_mobile',
            'type'     => 'switch',
            'title'    => __( 'Show product label on product archive pages in mobile mode', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'product_label_archive', '=', true ),
        ),
        array(
            'id'     => 'product-label-section-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //product-label-section-end
        
        //product-thumb-section-start
        array(
            'id'     => 'product-thumb-section-start',
            'type'   => 'section',
            'title'  => __( 'Default product thumbnail settings', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'       => 'prod_default_thumb',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'Default product thumbnail', 'dina-kala' ),
            'subtitle' => __( 'If your product does not have an thumbnail image, this image will be displayed.', 'dina-kala' ),
            'compiler' => 'true',
            'default'  => array( 'url' => DI_URI."/images/thumb.png" ),
        ),
        array(
            'id'     => 'product-thumb-section-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //product-thumb-section-end
    ),
) );

//Product page SECTION
Redux::setSection( $opt_name, array(
    'title'      => __( 'Product page', 'dina-kala' ),
    'id'         => 'product_page_setting',
    'icon'       => 'fal fa-shopping-bag',
    'subsection' => true,
    'fields'     => array(
        array( 
            'id'       => 'product_page_setting_docs',
            'type'     => 'raw',
            'content'  => dina_admin_info( '', 'https://i-design.ir/docs/dinakala/?p=2197', 'info' )
        ),
        array(
            'id'       => 'product_side',
            'type'     => 'image_select',
            'title'    => __( 'Products Sidebar', 'dina-kala' ),
            'subtitle' => __( 'Specify the location of the products sidebar, this feature is also customizable for each product.', 'dina-kala' ),
            'options'  => array(
                '0' => array(
                    'alt' => __( 'No sidebar', 'dina-kala' ),
                    'img' => RE_URI . 'assets/img/1c.png'
                ),
                '1' => array(
                    'alt' => __( 'Left alignment', 'dina-kala' ),
                    'img' => RE_URI . 'assets/img/2cl.png'
                ),
                '2' => array(
                    'alt' => __( 'Right alignment', 'dina-kala' ),
                    'img' => RE_URI . 'assets/img/2cr.png'
                )
            ),
            'default'  => '0'
        ),
        array(
            'id'       => 'product_page_side',
            'type'     => 'switch',
            'title'    => __( 'Separate product page sidebar', 'dina-kala' ),
            'subtitle' => __( 'Separate product page sidebar from archive pages', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'product_page_style',
            'type'     => 'select',
            'title'    => __( 'Products page style', 'dina-kala' ),
            'options'  => array(
                'stone' => __( 'Style 1', 'dina-kala' ),
                'sttwo' => __( 'Style 2', 'dina-kala' ),
            ),
            'default'  => 'stone',
        ),
        array(
            'id'          => 'shop_box_bg',
            'type'        => 'color',
            'title'       => __( 'Shopping box background color', 'dina-kala' ),
            'default'     => '#ffffff',
            'validate'    => 'color',
            'transparent' => false,
            'required'    => array( 'product_page_style', '=', 'sttwo' ),
        ),
        array(
            'id'       => 'show_video_thumbnail',
            'type'     => 'switch',
            'title'    => __( 'Display the product video or audio review in the product image gallery', 'dina-kala' ),
            'subtitle' => __( 'By activating this option, the first image of the product will act as the display of the product video or audio review.', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'video_thumbnail_color',
            'type'     => 'switch',
            'title'    => __( 'Inherit video icon color from skin color', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_video_thumbnail', '=', true ),
        ),
        array(
            'id'       => 'show_more',
            'type'     => 'switch',
            'title'    => __( 'Show the product description in a summary form on mobile', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'show_more_desktop',
            'type'     => 'switch',
            'title'    => __( 'Show the product description in a summary form on desktop', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_more', '=', true ),
        ),
        array(
            'id'       => 'out_stock_black',
            'type'     => 'switch',
            'title'    => __( 'Show out of stock products in black and white color', 'dina-kala' ),
            'default'  => true,
        ),
        array(
            'id'       => 'ajax_add',
            'type'     => 'switch',
            'title'    => __( 'Ajax add to cart', 'dina-kala' ),
            'subtitle' => __( 'Product has been added Ajax to the cart (without loading page again)', 'dina-kala' ),
            'default'  => true,
        ),
        array(
            'id'       => 'ajax_add_open_cart',
            'type'     => 'switch',
            'title'    => __( 'Open the shopping cart from the side', 'dina-kala' ),
            'subtitle' => __( 'Opening the shopping cart from the side after the product is added to the shopping cart', 'dina-kala' ),
            'default'  => true,
        ),
        array(
            'id'       => 'like_prod',
            'type'     => 'switch',
            'title'    => __( 'Like Product Button', 'dina-kala' ),
            'subtitle' => __( 'Show Like Product Button in product page', 'dina-kala' ),
            'default'  => true,
        ),
        array(
            'id'       => 'compare_prod',
            'type'     => 'switch',
            'title'    => __( 'Compare Product Button', 'dina-kala' ),
            'subtitle' => __( 'Show Compare Product Button in product page', 'dina-kala' ),
            'default'  => true,
        ),
        array(
            'id'       => 'share_prod',
            'type'     => 'switch',
            'title'    => __( 'Share Product Button', 'dina-kala' ),
            'subtitle' => __( 'Show Share Product Button in product page', 'dina-kala' ),
            'default'  => true,
        ),
        array(
            'id'       => 'price_chart',
            'type'     => 'switch',
            'title'    => __( 'Price Chart Button', 'dina-kala' ),
            'subtitle' => __( 'If you are using the DadeNeghar price chart plugin, activating this option will display the price chart button next to the product image. In the settings of the price chart plugin, be sure to set the display type to the shortcode option.', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'show_prod_sku',
            'type'     => 'switch',
            'title'    => __( 'Show product SKU', 'dina-kala' ),
            'subtitle' => __( 'Show product SKU in product page', 'dina-kala' ),
            'default'  => true,
        ),
        array(
            'id'       => 'show_prod_cats',
            'type'     => 'switch',
            'title'    => __( 'Show product categories', 'dina-kala' ),
            'subtitle' => __( 'Show product categories in product page', 'dina-kala' ),
            'default'  => true,
        ),
        array(
            'id'       => 'show_prod_tags',
            'type'     => 'switch',
            'title'    => __( 'Show product tags', 'dina-kala' ),
            'subtitle' => __( 'Show product tags in product page', 'dina-kala' ),
            'default'  => true,
        ),
        array(
            'id'       => 'show_prod_tags_down',
            'type'     => 'switch',
            'title'    => __( 'Show tags at the bottom', 'dina-kala' ),
            'subtitle' => __( 'By activating this option, the labels are displayed separately at the bottom of the side of the product image', 'dina-kala' ),
            'required' => array( 'show_prod_tags', '=', true ),
            'default'  => false,
        ),
        array(
            'id'       => 'show_prod_meta_sum',
            'type'     => 'switch',
            'title'    => __( 'Show product tags in summary form', 'dina-kala' ),
            'required' => array(
                array( 'show_prod_tags', '=', true ),
                array( 'show_prod_tags_down', '!=', true ),
            ),
            'default'  => false,
        ),
        array(
            'id'       => 'show_prod_up_date',
            'type'     => 'switch',
            'title'    => __( 'Show product update date', 'dina-kala' ),
            'subtitle' => __( 'Show product update date in product page', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'show_prod_views',
            'type'     => 'switch',
            'title'    => __( 'Show product views count', 'dina-kala' ),
            'subtitle' => __( 'Show product views count in product page', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'show_pros_top',
            'type'     => 'switch',
            'title'    => __( 'Show cons and pros in top', 'dina-kala' ),
            'subtitle' => __( 'Show product cons and pros section in top of description', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'remove_clear_option',
            'type'     => 'switch',
            'title'    => __( 'Remove clear options', 'dina-kala' ),
            'subtitle' => __( 'Remove clear options of variation product.', 'dina-kala' ),
            'default'  => false,
        ),

        array(
            'id'       => 'ch_reset_var_text',
            'type'     => 'switch',
            'title'    => __( 'Change text Clear options on variable product', 'dina-kala' ),
            'subtitle' => __( 'The text displayed below the selected variables', 'dina-kala' ),
            'default'  => false,
        ),

        array(
            'id'       => 'reset_var_text',
            'type'     => 'text',
            'title'    => __( 'Clear options text', 'dina-kala' ),
            'default'  => __( 'Clear options', 'dina-kala' ),                
            'required' => array( 'ch_reset_var_text', '=', true ),
        ),

        array(
            'id'       => 'display_discount',
            'type'     => 'switch',
            'title'    => __( 'Display discount percentage', 'dina-kala' ),
            'subtitle' => __( 'Display discount percentage on discounted products', 'dina-kala' ),
            'default'  => true,
        ),

        array(
            'id'       => 'display_spec',
            'type'     => 'switch',
            'title'    => __( 'Display special phrase instead of discount percentage', 'dina-kala' ),
            'subtitle' => __( 'Display special phrase instead of discount percentage on discounted products', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'display_discount', '=', true ),
        ),

        array(
            'id'      => 'display_review_count',
            'type'    => 'switch',
            'title'   => __( 'Show the number of reviews next to the star rating', 'dina-kala' ),
            'default' => false,
        ),

        array(
            'id'      => 'sub_title_tag',
            'type'    => 'select',
            'title'   => __( 'Product subtitle tag', 'dina-kala' ),
            'options' => array(
                'div'  => __( 'div', 'dina-kala' ),
                'span' => __( 'span', 'dina-kala' ),
                'h2'   => __( 'h2', 'dina-kala' ),
                'h3'   => __( 'h3', 'dina-kala' ),
                'h4'   => __( 'h4', 'dina-kala' ),
                'h5'   => __( 'h5', 'dina-kala' ),
            ),
            'default' => 'div',
        ),

        // product-counter-section-start
        array(
            'id'     => 'product-counter-section-start',
            'type'   => 'section',
            'title'  => __( 'Product discount counter settings', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'      => 'product_counter_format',
            'type'    => 'select',
            'title'   => __( 'Discount countdown format', 'dina-kala' ),
            'options' => array(
                'wdhm' => __( 'Week: Day: Hour: Minute: Second', 'dina-kala' ),
                'dhm'  => __( 'Day: Hour: Minute: Second', 'dina-kala' ),
            ),
            'default' => 'wdhm',
        ),
        array(
            'id'      => 'product_counter_style',
            'type'    => 'select',
            'title'   => __( 'Countdown style', 'dina-kala' ),
            'options' => array(
                'sale-count-black'   => __( 'Black', 'dina-kala' ),
                'sale-count-white'   => __( 'White', 'dina-kala' ),
                'sale-count-gray'    => __( 'Gray', 'dina-kala' ),
                'sale-count-outline' => __( 'Outline', 'dina-kala' ),
                'sale-count-text'    => __( 'Text style', 'dina-kala' ),
            ),
            'default' => 'sale-count-text',
        ),
        array(
            'id'     => 'product-counter-section-end',
            'type'   => 'section',
            'indent' => false,
        ),
        // product-counter-section-end

        //prod-tab-section-start
        array(
            'id'     => 'prod-tab-section-start',
            'type'   => 'section',
            'title'  => __( 'Product tabs settings', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'       => 'prod_tab_style',
            'type'     => 'select',
            'title'    => __( 'Product tabs style (descriptions, comments, etc.)', 'dina-kala' ),
            'options'  => array(
                'stone' => __( 'Style 1', 'dina-kala' ),
                'sttwo' => __( 'Style 2', 'dina-kala' ),
            ),
            'default'  => 'stone',
        ),
        array(
            'id'      => 'product_tab_fixed',
            'type'    => 'switch',
            'title'   => __( 'Display product page tabs in a fixed way while scrolling', 'dina-kala' ),
            'default' => true,
        ),
        array(
            'id'       => 'product_tab_scroll',
            'type'     => 'switch',
            'title'    => __( 'Display the content of the product page tabs sequentially', 'dina-kala' ),
            'subtitle' => __( 'In this case, the contents of the description tabs, product specifications, comments, etc. are displayed sequentially and consecutively.', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'product_tab_scroll_tag',
            'type'     => 'select',
            'title'    => __( 'Tab title tag', 'dina-kala' ),
            'options'  => array(
                'div' => __( 'div', 'dina-kala' ),
                'h2'  => __( 'h2', 'dina-kala' ),
                'h3'  => __( 'h3', 'dina-kala' ),
                'h4'  => __( 'h4', 'dina-kala' ),
                'h5'  => __( 'h5', 'dina-kala' ),
            ),
            'default'  => 'h2',
            'required' => array( 'product_tab_scroll', '=', true ),
        ),
        array(
            'id'     => 'prod-tab-section-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //sticky-add-section-start
        array(
            'id'     => 'sticky-add-section-start',
            'type'   => 'section',
            'title'  => __( 'Product purchase sticky bar settings', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_sticky_add',
            'type'     => 'switch',
            'title'    => __( 'Show product purchase sticky bar', 'dina-kala' ),
            'subtitle' => __( 'Show product purchase sticky bar at the bottom of the product page', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'      => 'desktop_sticky_add',
            'type'    => 'switch',
            'title'   => __( 'Display sticky purchase button in desktop mode', 'dina-kala' ),
            'default' => true,
        ),
        array(
            'id'      => 'mobile_sticky_add',
            'type'    => 'switch',
            'title'   => __( 'Display sticky purchase button in mobile mode', 'dina-kala' ),
            'default' => false,
        ),
        array(
            'id'       => 'show_mobile_sticky_add_title',
            'type'     => 'switch',
            'title'    => __( 'Display product title in mobile mode', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'mobile_sticky_add', '=', true ),
        ),
        array(
            'id'       => 'show_mobile_sticky_add_price',
            'type'     => 'switch',
            'title'    => __( 'Display product price in mobile mode', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'mobile_sticky_add', '=', true ),
        ),
        array(
            'id'     => 'sticky-add-section-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //sticky-add-section-end

        //catalog-mode-section-start
        array(
            'id'     => 'catalog-mode-section-start',
            'type'   => 'section',
            'title'  => __( 'Catalog mode settings', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'       => 'product_catalog_mode',
            'type'     => 'switch',
            'title'    => __( 'Activation of catalog mode', 'dina-kala' ),
            'subtitle' => __( 'By activating the catalog mode, the ability to buy products will be removed from your site, and the products will only be displayed.', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'product_catalog_price_mode',
            'type'     => 'switch',
            'title'    => __( 'Hide prices in catalog mode', 'dina-kala' ),
            'subtitle' => __( 'By activating this option, prices will be hidden along with the buy button in catalog mode', 'dina-kala' ),
            'required' => array( 'product_catalog_mode', '=', true ),
            'default'  => false,
        ),
        array(
            'id'     => 'catalog-mode-section-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //catalog-mode-section-end

        //excerpt-section-start
        array(
            'id'     => 'excerpt-section-start',
            'type'   => 'section',
            'title'  => __( 'Product excerpt settings', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'      => 'show_prod_excerpt',
            'type'    => 'switch',
            'title'   => __( 'Show product excerpt', 'dina-kala' ),
            'default' => true,
        ),
        array(
            'id'       => 'show_prod_excerpt_icon',
            'type'     => 'switch',
            'title'    => __( 'Show product excerpt icon', 'dina-kala' ),
            'required' => array( 'show_prod_excerpt', '=', true ),
            'default'  => true,
        ),
        array(
            'id'     => 'excerpt-section-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //excerpt-section-end

        //features-section-start
        array(
            'id'     => 'features-section-start',
            'type'   => 'section',
            'title'  => __( 'Settings of features next to product image', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_prodf_title',
            'type'     => 'switch',
            'title'    => __( 'Show product features title', 'dina-kala' ),
            'subtitle' => __( 'Show product features title in product page', 'dina-kala' ),
            'default'  => true,
        ),
        array(
            'id'       => 'show_features_grid',
            'type'     => 'switch',
            'title'    => __( 'Displaying features in a grid', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'prodf_title',
            'type'     => 'text',
            'title'    => __( 'Product features title', 'dina-kala' ),
            'default'  => __( 'Product Features:', 'dina-kala' ),                
            'required' => array( 'show_prodf_title', '=', true ),
        ),
        array(
            'id'       => 'replace_features',
            'type'     => 'switch',
            'title'    => __( 'Show product excerpt instead product features', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'replace_content_features',
            'type'     => 'switch',
            'title'    => __( 'Show product content instead product features', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'replace_features_tab',
            'type'     => 'switch',
            'title'    => __( 'Display the specifications in the Product Features tab instead of the product specifications', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'features_tab_count',
            'type'     => 'text',
            'title'    => __( 'Maximum number of features displayed', 'dina-kala' ),
            'default'  => 10,                
            'required' => array( 'replace_features_tab', '=', true ),
        ),
        array(
            'id'       => 'show_features_limited',
            'type'     => 'switch',
            'title'    => __( 'Limit the number of feature display lines with the "Show More" button feature', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_features_grid', '!=', true ),
        ),
        array(
            'id'       => 'show_features_tab_link',
            'type'     => 'switch',
            'title'    => __( 'Show a button to view the product features tab', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_features_grid', '=', true ),
        ),
        array(
            'id'       => 'features_limited_line',
            'type'     => 'text',
            'title'    => __( 'Number of lines displayed', 'dina-kala' ),
            'default'  => 4,                
            'required' => array( 'show_features_limited', '=', true ),
        ),
        array(
            'id'     => 'features-section-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //features-section-end

        //features-tab-section-start
        array(
            'id'     => 'features-tab-section-start',
            'type'   => 'section',
            'title'  => __( 'Product Features tab settings', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'       => 'remove_dimensions',
            'type'     => 'switch',
            'title'    => __( 'Hides the product’s weight and dimension', 'dina-kala' ),
            'subtitle' => __( 'Hides the product’s weight and dimension in the single product page.', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'remove_attr_link',
            'type'     => 'switch',
            'title'    => __( 'Remove product’s atribute link', 'dina-kala' ),
            'subtitle' => __( 'Remove product’s atribute link in the single product page.', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'replace_attr_symbol',
            'type'     => 'switch',
            'title'    => __( 'Replace the attribute with a tick and a cross', 'dina-kala' ),
            'subtitle' => __( 'Replacing desired texts with tick and cross symbols in product features', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'attr_symbol_tick',
            'type'     => 'text',
            'title'    => __( 'Tick icon text', 'dina-kala' ),
            'default'  => __( 'yes', 'dina-kala' ),             
            'required' => array( 'replace_attr_symbol', '=', true ),
        ),
        array(
            'id'       => 'attr_symbol_cross',
            'type'     => 'text',
            'title'    => __( 'Cross icon text', 'dina-kala' ),
            'default'  => __( 'no', 'dina-kala' ),             
            'required' => array( 'replace_attr_symbol', '=', true ),
        ),
        array(
            'id'     => 'features-tab-section-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //features-tab-section-end

        //price-section-start
        array(
            'id'     => 'price-section-start',
            'type'   => 'section',
            'title'  => __( 'Price settings', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'       => 'coming_soon_text',
            'type'     => 'text',
            'title'    => __( 'Alternative text for prices on products coming soon', 'dina-kala' ),
            'subtitle' => __( 'This text can be adjusted for each product separately on the product editing page', 'dina-kala' ),
            'default'  => __( 'Coming Soon...', 'dina-kala' ),
        ),
        array(
            'id'       => 'outofstock_text',
            'type'     => 'text',
            'title'    => __( 'Alternative text for prices of Out of stock products', 'dina-kala' ),
            'default'  => __( 'Out of stock', 'dina-kala' ),
        ),
        array(
            'id'       => 'show_free_price',
            'type'     => 'switch',
            'title'    => __( 'Show Free Price instead of zero price', 'dina-kala' ),
            'default'  => true,
        ),
        array(
            'id'       => 'free_price_text',
            'type'     => 'text',
            'title'    => __( 'Free Price text', 'dina-kala' ),
            'default'  => __( 'Free!', 'dina-kala' ),                
            'required' => array( 'show_free_price', '=', true ),
        ),
        array(
            'id'       => 'show_zero_call',
            'type'     => 'switch',
            'title'    => __( 'Show Call instead of Free Price', 'dina-kala' ),
            'subtitle' => __( 'Show phrase call instead of free quote for zero price products', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'zero_call_link',
            'type'     => 'text',
            'title'    => __( 'Contact text link', 'dina-kala' ),
            'subtitle' => __( 'If the link is empty, it will be deactivated', 'dina-kala' ),
            'default'  => '',                
            'required' => array( 'show_zero_call', '=', true ),
        ),
        array(
            'id'       => 'zero_call_text',
            'type'     => 'text',
            'title'    => __( 'Contact text', 'dina-kala' ),
            'default'  => __( 'Call!', 'dina-kala' ),                
            'required' => array( 'show_zero_call', '=', true ),
        ),
        array(
            'id'       => 'show_login_price',
            'type'     => 'switch',
            'title'    => __( 'Show price and add to cart button to logged in users', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'show_price_out',
            'type'     => 'switch',
            'title'    => __( 'Show price for out of stock products', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'show_price_out_archive',
            'type'     => 'switch',
            'title'    => __( 'Show price for out of stock products on archive pages', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'show_price_out', '=', true ),
        ),
        array(
            'id'       => 'remove_price_range',
            'type'     => 'switch',
            'title'    => __( 'Remove price range', 'dina-kala' ),
            'subtitle' => __( 'Remove price range and display the lowest price', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'show_max_price',
            'type'     => 'switch',
            'title'    => __( 'Display higher price', 'dina-kala' ),
            'subtitle' => __( 'Remove price range and display the higher price', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'remove_price_range', '=', true ),
        ),
        array(
            'id'       => 'show_def_price',
            'type'     => 'switch',
            'title'    => __( 'Display the default variable price', 'dina-kala' ),
            'subtitle' => __( 'Remove price range and display the default variable price', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'remove_price_range', '=', true ),
        ),
        array(
            'id'       => 'display_from_to',
            'type'     => 'switch',
            'title'    => __( 'Display "From" or "To" before the price', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'remove_price_range', '=', true ),
        ),
        array(
            'id'       => 'price_from_text',
            'type'     => 'text',
            'title'    => __( 'Text before the lowest price', 'dina-kala' ),
            'default'  => __( 'From', 'dina-kala' ),
            'required' => array( 'display_from_to', '=', true ),
        ),
        array(
            'id'       => 'price_upto_text',
            'type'     => 'text',
            'title'    => __( 'Text before the highest price', 'dina-kala' ),
            'default'  => __( 'Up to', 'dina-kala' ),
            'required' => array( 'display_from_to', '=', true ),
        ),
        array(
            'id'       => 'remove_dub_price_range',
            'type'     => 'switch',
            'title'    => __( 'Remove second price', 'dina-kala' ),
            'subtitle' => __( 'Remove second price in variable products (Prices should not be the same)', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'price_trim_zeros',
            'type'     => 'switch',
            'title'    => __( 'Removing decimals', 'dina-kala' ),
            'subtitle' => __( 'In some currency units, the decimal part is displayed in the price, which you can remove with this option', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id' => 'price-section-end',
            'type' => 'section',
            'indent' => false,
        ),
        //price-section-end

        //product-accessories-section-start
        array(
            'id'     => 'product-accessories-section-start',
            'type'   => 'section',
            'title'  => __( 'Product accessories settings', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_product_accessories',
            'type'     => 'switch',
            'title'    => __( 'Product accessories', 'dina-kala' ),
            'subtitle' => __( 'Show product accessories section in product page', 'dina-kala' ),
            'default'  => true,
        ),
        array(
            'id'       => 'product_accessories_upsell',
            'type'     => 'switch',
            'title'    => __( 'Using WooCommerce upsell products', 'dina-kala' ),
            'subtitle' => __( 'If this option is active, accessory products will be received from WooCommerce upsell products', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'product_accessories_title',
            'type'     => 'text',
            'title'    => __( 'Title', 'dina-kala' ),
            'default'  => __( 'Product accessories', 'dina-kala' ),
            'required' => array( 'show_product_accessories', '=', true ),
        ),
        array(
            'id'       => 'product_accessories_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Icon', 'dina-kala' ),
            'default'  => 'fal fa-shopping-cart',
            'required' => array( 'show_product_accessories', '=', true ),
        ),
        array(
            'id'       => 'product_accessories_rand',
            'type'     => 'switch',
            'title'    => __( 'Sort randomly', 'dina-kala' ),
            'default'  => true,
        ),
        array(
            'id'       => 'product_accessories_style',
            'type'     => 'select',
            'title'    => __( 'Product accessories style', 'dina-kala' ),
            'options'  => array(
                'table'    => __( 'Table (list)', 'dina-kala' ),
                'carousel' => __( 'Carousel', 'dina-kala' ),
                'checkbox' => __( 'Checkbox', 'dina-kala' ),
            ),
            'default'  => 'table',
        ),
        array(
            'id'      => 'checkbox_accessories_location',
            'type'    => 'select',
            'title'   => __( 'Product accessories location', 'dina-kala' ),
            'options' => array(
                'dina_before_product_features' => __( 'Above the features next to the product image', 'dina-kala' ),
                'dina_after_product_features'  => __( 'Below the features next to the product image', 'dina-kala' ),
                'dina_before_price_con'        => __( 'Above the product purchase button', 'dina-kala' ),
            ),
            'default'  => 'dina_before_price_con',
            'required' => array( 'product_accessories_style', '=', 'checkbox')
        ),
        array(
            'id'       => 'checkbox_accessories_link',
            'type'     => 'switch',
            'title'    => __( 'Display the link to view the product', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'product_accessories_style', '=', 'checkbox')
        ),
        array(
            'id'       => 'product_accessories_location',
            'type'     => 'select',
            'title'    => __( 'Product accessories location', 'dina-kala' ),
            'options'  => array(
                'above-description' => __( 'Above the product description', 'dina-kala' ),
                'separate-tab'      => __( 'Display in separate tab', 'dina-kala' ),
            ),
            'default'  => 'above-description',
            'required' => array( 'product_accessories_style', '=', array( 'table', 'carousel' ) )
        ),
        array(
            'id'       => 'product_accessories_thumb',
            'type'     => 'switch',
            'title'    => __( 'Show product thumbnail', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'product_accessories_style', '=', 'table' ),
        ),
        array(
            'id'       => 'product_accessories_quick',
            'type'     => 'switch',
            'title'    => __( 'Show quick view button', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'product_accessories_style', '=', 'table' ),
        ),
        array(
            'id'       => 'accessories_show_arrows',
            'type'     => 'switch',
            'title'    => __( 'Show arrows', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'product_accessories_style', '=', 'carousel' ),
        ),
        array(
            'id'       => 'accessories_prod_loop',
            'type'     => 'switch',
            'title'    => __( 'Product loop', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'product_accessories_style', '=', 'carousel' ),
        ),
        array(
            'id'       => 'accessories_auto_play',
            'type'     => 'switch',
            'title'    => __( 'Auto play', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'product_accessories_style', '=', 'carousel' ),
        ),
        array(
            'id'       => 'accessories_pcount',
            'type'     => 'text',
            'title'    => __( 'Slider columns count', 'dina-kala' ),
            'default'  => 5,
            'required' => array( 'product_accessories_style', '=', 'carousel' ),
        ),
        array(
            'id' => 'product-accessories-section-end',
            'type' => 'section',
            'indent' => false,
        ),
        //product-accessories-section-end

        //related-section-start
        array(
            'id'     => 'related-section-start',
            'type'   => 'section',
            'title'  => __( 'Related Products settings', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_related_p',
            'type'     => 'switch',
            'title'    => __( 'Related Products', 'dina-kala' ),
            'subtitle' => __( 'Show related product section in product page', 'dina-kala' ),
            'default'  => true,
        ),
        array(
            'id'       => 'show_related_top_desc',
            'type'     => 'switch',
            'title'    => __( 'Show the related products section above the product description', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_related_p', '=', true ),
        ),
        array(
            'id'       => 'show_related_p_top',
            'type'     => 'switch',
            'title'    => __( 'Show related products at the top of out of stock products', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'show_related_p', '=', true ),
        ),
        array(
            'id'       => 'related_p_title',
            'type'     => 'text',
            'title'    => __( 'Block title', 'dina-kala' ),
            'default'  => __( 'Related Produts', 'dina-kala' ),   
            'required' => array( 'show_related_p', '=', true ),
        ),
        array(
            'id'       => 'related_p_count',
            'type'     => 'text',
            'title'    => __( 'Product total count', 'dina-kala' ),
            'default'  => 8,   
            'required' => array( 'show_related_p', '=', true ),
        ),
        array(
            'id'       => 'related_p_by',
            'type'     => 'select',
            'title'    => __( 'Show related product by', 'dina-kala' ),
            'options'  => array(
                'product_cat'   => __( 'Product category', 'dina-kala' ),
                'product_tag'   => __( 'Product tag', 'dina-kala' ),
                'brand'         => __( 'Product brand', 'dina-kala' ),
                'cat_and_brand' => __( 'Product category And brand', 'dina-kala' ),
                'cat_or_brand'  => __( 'Product category Or brand', 'dina-kala' ),
                'manual'        => __( 'Manual selection', 'dina-kala' )
            ),
            'default'  => 'product_cat',
            'required' => array( 'show_related_p', '=', true ),
        ),
        array(
            'id'      => 'related_p_sort',
            'type'    => 'select',
            'title'   => __( 'Sort related products by', 'dina-kala' ),
            'options' => array(
                'random' => __( 'Random', 'dina-kala' ),
                'latest' => __( 'Latest', 'dina-kala' ),
                'viewed' => __( 'Most viewed', 'dina-kala' )
            ),
            'default'  => 'random',
            'required' => array( 'show_related_p', '=', true ),
        ),
        array(
            'id'       => 'show_by_last_cat',
            'type'     => 'switch',
            'title'    => __( 'Display based on the latest level of product category (If product category is selected)', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_related_p', '=', true ),
        ),
        array(
            'id'       => 'show_by_main_cat',
            'type'     => 'switch',
            'title'    => __( 'Display by main category', 'dina-kala' ),
            'subtitle' => __( 'If the main category for the product has been selected by the SEO plugin features.', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'show_by_last_cat', '=', true ),
        ),
        array(
            'id'       => 'show_out_prod',
            'type'     => 'switch',
            'title'    => __( 'Show in stock products', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'show_related_p', '=', true ),
        ),
        array(
            'id'       => 'show_arrows',
            'type'     => 'switch',
            'title'    => __( 'Show arrows', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'show_related_p', '=', true ),
        ),
        array(
            'id'       => 'prod_loop',
            'type'     => 'switch',
            'title'    => __( 'Product loop', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_related_p', '=', true ),
        ),
        array(
            'id'       => 'auto_play',
            'type'     => 'switch',
            'title'    => __( 'Auto play', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_related_p', '=', true ),
        ),
        array(
            'id'       => 'pcount',
            'type'     => 'text',
            'title'    => __( 'Slider columns count', 'dina-kala' ),
            'default'  => 5,
            'required' => array( 'show_related_p', '=', true ),
        ),
        array(
            'id'     => 'related-section-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //related-section-end

        //up-sells-section-start
        array(
            'id'     => 'up-sells-section-start',
            'type'   => 'section',
            'title'  => __( 'Up-selling products settings', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_up_sells',
            'type'     => 'switch',
            'title'    => __( 'Show up-selling products', 'dina-kala' ),
            'default'  => true,
        ),
        array(
            'id'       => 'show_up_sells_top_desc',
            'type'     => 'switch',
            'title'    => __( 'Show the up-selling products section above the product description', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_up_sells', '=', true ),
        ),
        array(
            'id'       => 'show_up_sells_out_top',
            'type'     => 'switch',
            'title'    => __( 'Show the up-selling products section at the top of out of stock products', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_up_sells', '=', true ),
        ),
        array(
            'id'       => 'up_sells_title',
            'type'     => 'text',
            'title'    => __( 'Block title', 'dina-kala' ),
            'default'  => __( 'You may also like', 'dina-kala' ),
            'required' => array( 'show_up_sells', '=', true ),
        ),
        array(
            'id'       => 'up-sells-section-end',
            'type'     => 'section',
            'indent'   => false,
        ),
        //up-sells-section-end

        //cross-sells-section-start
        array(
            'id'     => 'cross-sells-section-start',
            'type'   => 'section',
            'title'  => __( 'Cross-selling products settings', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_cross_sells',
            'type'     => 'switch',
            'title'    => __( 'Show cross-selling products', 'dina-kala' ),
            'default'  => true,
        ),
        array(
            'id'       => 'cross_sells_title',
            'type'     => 'text',
            'title'    => __( 'Block title', 'dina-kala' ),
            'default'  => __( 'You may be interested in', 'dina-kala' ),                
            'required' => array( 'show_cross_sells', '=', true ),
        ),
        array(
            'id'       => 'cross_sells_count',
            'type'     => 'text',
            'title'    => __( 'Product total count', 'dina-kala' ),
            'default'  => 8,
            'required' => array( 'show_cross_sells', '=', true ),
        ),
        array(
            'id'       => 'cross-sells-section-end',
            'type'     => 'section',
            'indent'   => false,
        ),

        array(
            'id'     => 'related-product-posts-section-start',
            'type'   => 'section',
            'title'  => __( 'Product related posts settings', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_related_product_posts',
            'type'     => 'switch',
            'title'    => __( 'Show related posts in product page', 'dina-kala' ),
            'subtitle' => __( 'By activating this option, articles related to the product will be displayed on the product page. These entries are selected by the same tag as the product.', 'dina-kala' ),   
            'default'  => false,
        ),
        array(
            'id'       => 'related_product_posts_title',
            'type'     => 'text',
            'title'    => __( 'Block title', 'dina-kala' ),
            'default'  => __( 'Related Posts', 'dina-kala' ),   
            'required' => array( 'show_related_product_posts', '=', true ),
        ),
        array(
            'id'       => 'related_product_posts_count',
            'type'     => 'text',
            'title'    => __( 'Post total count', 'dina-kala' ),
            'default'  => 8,
            'required' => array( 'show_related_product_posts', '=', true ),
        ),
        array(
            'id'      => 'related_product_posts_by',
            'type'    => 'select',
            'title'   => __( 'Show Related posts by', 'dina-kala' ),
            'options' => array(
                'tag'    => __( 'Tags', 'dina-kala' ),
                'manual' => __( 'Manual selection', 'dina-kala' )
            ),
            'default'  => 'tag',
            'required' => array( 'show_related_product_posts', '=', true ),
        ),
        array(
            'id'      => 'related_product_posts_sort',
            'type'    => 'select',
            'title'   => __( 'Sort related posts by', 'dina-kala' ),
            'options' => array(
                'random' => __( 'Random', 'dina-kala' ),
                'latest' => __( 'Latest', 'dina-kala' ),
                'viewed' => __( 'Most viewed', 'dina-kala' )
            ),
            'default'  => 'random',
            'required' => array( 'show_related_product_posts', '=', true ),
        ),
        array(
            'id'       => 'show_product_posts_arrows',
            'type'     => 'switch',
            'title'    => __( 'Show arrows', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'show_related_product_posts', '=', true ),
        ),
        array(
            'id'       => 'product_posts_loop',
            'type'     => 'switch',
            'title'    => __( 'Post loop', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_related_product_posts', '=', true ),
        ),
        array(
            'id'       => 'auto_product_posts_play',
            'type'     => 'switch',
            'title'    => __( 'Auto play', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_related_product_posts', '=', true ),
        ),
        array(
            'id'       => 'product_posts_count',
            'type'     => 'text',
            'title'    => __( 'Slider columns count', 'dina-kala' ),
            'default'  => 5,                
            'required' => array( 'show_related_product_posts', '=', true ),
        ),
        array(
            'id'     => 'related-product-posts-section',
            'type'   => 'section',
            'indent' => false,
        ),
        //related-product-posts-section

        //extra-section-start
        array(
            'id'     => 'extra-section-start',
            'type'   => 'section',
            'title'  => __( 'Site features settings', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'      => 'show_extra',
            'type'    => 'switch',
            'title'   => __( 'View site features section', 'dina-kala' ),
            'default' => true
        ),
        array(
            'id'       => 'show_extra_mobile',
            'type'     => 'switch',
            'title'    => __( 'View site features section in mobile mode', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'show_extra', '=', true ),
        ),
        array(
            'id'       => 'show_extra_one',
            'type'     => 'switch',
            'title'    => __( 'Show first feature', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'show_extra', '=', true ),
        ),
        array(
            'id'       => 'extra_one_title',
            'type'     => 'text',
            'title'    => __( 'First feature title', 'dina-kala' ),
            'default'  => __( 'Guarantee the best market price', 'dina-kala' ),
            'required' => array( 'show_extra_one', '=', true ),
        ),
        array(
            'id'       => 'extra_one_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Icon', 'dina-kala' ),
            'default'  => 'fal fa-credit-card',
            'required' => array( 'show_extra_one', '=', true ),
        ),
        array(
            'id'       => 'extra_one_img',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'Or custom icon', 'dina-kala' ),
            'compiler' => 'true',
            'desc'     => __( 'Suitable size: 32px by 32px', 'dina-kala' ),
        ),
        array(
            'id'       => 'extra_one_link',
            'type'     => 'text',
            'title'    => __( 'First feature Link', 'dina-kala' ),
            'required' => array( 'show_extra_one', '=', true ),
        ),
        array(
            'id'       => 'show_extra_two',
            'type'     => 'switch',
            'title'    => __( 'Show second feature', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'show_extra', '=', true ),
        ),
        array(
            'id'       => 'extra_two_title',
            'type'     => 'text',
            'title'    => __( 'Second feature title', 'dina-kala' ),
            'default'  => __( 'Excellent support, 7 days a week', 'dina-kala' ),
            'required' => array( 'show_extra_two', '=', true ),
        ),
        array(
            'id'       => 'extra_two_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Icon', 'dina-kala' ),
            'default'  => 'fal fa-headset',
            'required' => array( 'show_extra_two', '=', true ),
        ),
        array(
            'id'       => 'extra_two_img',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'Or custom icon', 'dina-kala' ),
            'compiler' => 'true',
            'desc'     => __( 'Suitable size: 32px by 32px', 'dina-kala' ),
        ),
        array(
            'id'       => 'extra_two_link',
            'type'     => 'text',
            'title'    => __( 'Second feature Link', 'dina-kala' ),
            'required' => array( 'show_extra_two', '=', true ),
        ),
        array(
            'id'       => 'show_extra_three',
            'type'     => 'switch',
            'title'    => __( 'Show third feature', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'show_extra', '=', true ),
        ),
        array(
            'id'       => 'extra_three_title',
            'type'     => 'text',
            'title'    => __( 'Third feature title', 'dina-kala' ),
            'default'  => __( 'Refund if unsatisfied', 'dina-kala' ),
            'required' => array( 'show_extra_three', '=', true ),
        ),
        array(
            'id'       => 'extra_three_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Icon', 'dina-kala' ),
            'default'  => 'fal fa-history',
            'required' => array( 'show_extra_three', '=', true ),
        ),
        array(
            'id'       => 'extra_three_img',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'Or custom icon', 'dina-kala' ),
            'compiler' => 'true',
            'desc'     => __( 'Suitable size: 32px by 32px', 'dina-kala' ),
        ),
        array(
            'id'       => 'extra_three_link',
            'type'     => 'text',
            'title'    => __( 'Third feature Link', 'dina-kala' ),
            'required' => array( 'show_extra_three', '=', true ),
        ),
        array(
            'id'       => 'show_extra_four',
            'type'     => 'switch',
            'title'    => __( 'Show fourth feature', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'show_extra', '=', true ),
        ),
        array(
            'id'       => 'extra_four_title',
            'type'     => 'text',
            'title'    => __( 'Fourth feature title', 'dina-kala' ),
            'default'  => __( 'Originality of goods from top brands', 'dina-kala' ),
            'required' => array( 'show_extra_four', '=', true ),
        ),
        array(
            'id'       => 'extra_four_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Icon', 'dina-kala' ),
            'default'  => 'fal fa-certificate',
            'required' => array( 'show_extra_four', '=', true ),
        ),
        array(
            'id'       => 'extra_four_img',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'Or custom icon', 'dina-kala' ),
            'compiler' => 'true',
            'desc'     => __( 'Suitable size: 32px by 32px', 'dina-kala' ),
        ),
        array(
            'id'       => 'extra_four_link',
            'type'     => 'text',
            'title'    => __( 'Fourth feature Link', 'dina-kala' ),
            'required' => array( 'show_extra_four', '=', true ),
        ),
        array(
            'id'       => 'show_extra_five',
            'type'     => 'switch',
            'title'    => __( 'Show fifth feature', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'show_extra', '=', true ),
        ),
        array(
            'id'       => 'extra_five_title',
            'type'     => 'text',
            'title'    => __( 'Fifth feature title', 'dina-kala' ),
            'default'  => __( 'Falt delivery in the shortest possible time', 'dina-kala' ),
            'required' => array( 'show_extra_five', '=', true ),
        ),
        array(
            'id'       => 'extra_five_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Icon', 'dina-kala' ),
            'default'  => 'fal fa-shipping-fast',
            'required' => array( 'show_extra_five', '=', true ),
        ),
        array(
            'id'       => 'extra_five_img',
            'type'     => 'media',
            'url'      => true,
            'readonly' => false,
            'title'    => __( 'Or custom icon', 'dina-kala' ),
            'compiler' => 'true',
            'desc'     => __( 'Suitable size: 32px by 32px', 'dina-kala' ),
        ),
        array(
            'id'       => 'extra_five_link',
            'type'     => 'text',
            'title'    => __( 'Fifth feature Link', 'dina-kala' ),
            'required' => array( 'show_extra_five', '=', true ),
        ),
        array(
            'id'     => 'extra-section-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //extra-section-end
        
        //pinfo-section-start
        array(
            'id'     => 'pinfo-section-start',
            'type'   => 'section',
            'title'  => __( 'Additional product information settings', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_add_prod_info',
            'type'     => 'switch',
            'subtitle' => __( 'Display the desired text below the product price', 'dina-kala' ),
            'title'    => __( 'Show Additional product information', 'dina-kala' ),
            'default'  => false,
        ),
        array(
            'id'       => 'add_prod_info_title',
            'type'     => 'text',
            'title'    => __( 'Additional product information title', 'dina-kala' ),
            'default'  => __( 'Title', 'dina-kala' ),
            'required' => array( 'show_add_prod_info', '=', true ),
        ),
        array(
            'id'      => 'add_prod_info_text',
            'type'    => 'editor',
            'title'   => __( 'Additional product information text', 'dina-kala' ),
            'default' => __( 'Text', 'dina-kala' ),
            'args'    => array(
                'wpautop'       => true,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => false,
                'quicktags'     => true,
            ),
            'required' => array( 'show_add_prod_info', '=', true ),
        ),
        array(
            'id'     => 'pinfo-section-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //pinfo-section-end
    ),
) );

//Additional product tab SECTION
Redux::setSection( $opt_name, array(
    'title'      => __( 'Additional product tab', 'dina-kala' ),
    'id'         => 'additional_product_tab',
    'icon'       => 'fal fa-folder',
    'subsection' => true,
    'fields'     => array(
        array( 
            'id'       => 'additional_product_tab_docs',
            'type'     => 'raw',
            'content'  => dina_admin_info( '', 'https://i-design.ir/docs/dinakala/?p=2198', 'info' )
        ),
        //faq-product-tab-start
        array(
            'id'     => 'faq-product-tab-start',
            'type'   => 'section',
            'title'  => __( 'Product FAQ tab settings', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'       => 'show_faq_product_tab',
            'type'     => 'switch',
            'title'    => __( 'Show tab', 'dina-kala' ),
            'subtitle' => __( 'By activating this option, a section for adding product FAQs will be added to the product edit page', 'dina-kala' ),
            'default'  => true,
        ),
        array(
            'id'       => 'faq_product_schema',
            'type'     => 'switch',
            'title'    => __( 'Adding FAQ schema to product page', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_faq_product_tab', '=', true ),
        ),
        array(
            'id'       => 'faq_separate_woo',
            'type'     => 'switch',
            'title'    => __( 'Separating schema code from WooCommerce schema', 'dina-kala' ),
            'subtitle' => __( 'Enable this option when WooCommerce schema has been disabled by plugins like RankMeth and the FAQ schema code has been removed from the product page.', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'faq_product_schema', '=', true ),
        ),
        array(
            'id'       => 'faq_product_tab_end',
            'type'     => 'switch',
            'title'    => __( 'Show FAQ at the end of product description', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_faq_product_tab', '=', true ),
        ),
        array(
            'id'       => 'faq_product_tab_title',
            'type'     => 'text',
            'title'    => __( 'Tab title', 'dina-kala' ),
            'default'  => __( 'FAQ', 'dina-kala' ),
            'required' => array( 'show_faq_product_tab', '=', true ),
        ),
        array(
            'id'       => 'faq_title_tag',
            'type'     => 'select',
            'title'    => __( 'FAQ title tag', 'dina-kala' ),
            'options'  => array(
                'div' => __( 'div', 'dina-kala' ),
                'h2'  => __( 'h2', 'dina-kala' ),
                'h3'  => __( 'h3', 'dina-kala' ),
                'h4'  => __( 'h4', 'dina-kala' ),
                'h5'  => __( 'h5', 'dina-kala' ),
            ),
            'default'  => 'h5',
        ),
        array(
            'id'       => 'faq_product_tab_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Tab icon', 'dina-kala' ),
            'default'  => 'fal fa-question-square',
            'required' => array( 'show_faq_product_tab', '=', true ),
        ),
        array(
            'id'     => 'faq-product-tab-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //additional-product-tab-one-start
        array(
            'id'     => 'additional-product-tab-one-start',
            'type'   => 'section',
            'title'  => __( 'Settings of the first additional tab of products', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'      => 'show_add_prod_tab_one',
            'type'    => 'switch',
            'title'   => __( 'Show tab', 'dina-kala' ),
            'default' => false,
        ),
        array(
            'id'       => 'add_prod_tab_one_title',
            'type'     => 'text',
            'title'    => __( 'Tab title', 'dina-kala' ),
            'default'  => __( 'Title', 'dina-kala' ),
            'required' => array( 'show_add_prod_tab_one', '=', true ),
        ),
        array(
            'id'       => 'add_prod_tab_one_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Tab icon', 'dina-kala' ),
            'default'  => 'fal fa-info-circle',
            'required' => array( 'show_add_prod_tab_one', '=', true ),
        ),
        array(
            'id'       => 'tab_one_in_cats',
            'type'     => 'switch',
            'title'    => __( 'Show tab in specific categories', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_add_prod_tab_one', '=', true ),
        ),
        array(
            'id'    => 'add_prod_tab_one_cats',
            'type'  => 'select',
            'ajax'     => true,
            'multi' => true,
            'title' => __( 'Categories', 'dina-kala' ),
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => array( 'product_cat' ),
                'hide_empty' => false,
            ),
            'required' => array( 'tab_one_in_cats', '=', true )
        ),
        array(
            'id'      => 'add_prod_tab_one_content',
            'type'    => 'editor',
            'title'   => __( 'Tab content', 'dina-kala' ),
            'default' => __( 'Text', 'dina-kala' ),
            'args'    => array(
                'wpautop'       => true,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => false,
                'quicktags'     => true,
            ),
            'required' => array( 'show_add_prod_tab_one', '=', true ),
        ),
        array(
            'id'     => 'additional-product-tab-one-end',
            'type'   => 'section',
            'indent' => false,
        ),

        array(
            'id'     => 'additional-product-tab-two-start',
            'type'   => 'section',
            'title'  => __( 'Settings of the second additional tab of products', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'      => 'show_add_prod_tab_two',
            'type'    => 'switch',
            'title'   => __( 'Show tab', 'dina-kala' ),
            'default' => false,
        ),
        array(
            'id'       => 'add_prod_tab_two_title',
            'type'     => 'text',
            'title'    => __( 'Tab title', 'dina-kala' ),
            'default'  => __( 'Title', 'dina-kala' ),
            'required' => array( 'show_add_prod_tab_two', '=', true ),
        ),
        array(
            'id'       => 'add_prod_tab_two_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Tab icon', 'dina-kala' ),
            'default'  => 'fal fa-certificate',
            'required' => array( 'show_add_prod_tab_two', '=', true ),
        ),
        array(
            'id'       => 'tab_two_in_cats',
            'type'     => 'switch',
            'title'    => __( 'Show tab in specific categories', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_add_prod_tab_two', '=', true ),
        ),
        array(
            'id'    => 'add_prod_tab_two_cats',
            'type'  => 'select',
            'ajax'     => true,
            'multi' => true,
            'title' => __( 'Categories', 'dina-kala' ),
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => array( 'product_cat' ),
                'hide_empty' => false,
            ),
            'required' => array( 'tab_two_in_cats', '=', true )
        ),
        array(
            'id'      => 'add_prod_tab_two_content',
            'type'    => 'editor',
            'title'   => __( 'Tab content', 'dina-kala' ),
            'default' => __( 'Text', 'dina-kala' ),
            'args'    => array(
                'wpautop'       => true,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => false,
                'quicktags'     => true,
            ),
            'required' => array( 'show_add_prod_tab_two', '=', true ),
        ),
        array(
            'id'     => 'additional-product-tab-two-end',
            'type'   => 'section',
            'indent' => false,
        ),

        array(
            'id'     => 'additional-product-tab-three-start',
            'type'   => 'section',
            'title'  => __( 'Settings of the Third additional tab of products', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'      => 'show_add_prod_tab_three',
            'type'    => 'switch',
            'title'   => __( 'Show tab', 'dina-kala' ),
            'default' => false,
        ),
        array(
            'id'       => 'add_prod_tab_three_title',
            'type'     => 'text',
            'title'    => __( 'Tab title', 'dina-kala' ),
            'default'  => __( 'Title', 'dina-kala' ),
            'required' => array( 'show_add_prod_tab_three', '=', true ),
        ),
        array(
            'id'       => 'add_prod_tab_three_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Tab icon', 'dina-kala' ),
            'default'  => 'fal fa-info-circle',
            'required' => array( 'show_add_prod_tab_three', '=', true ),
        ),
        array(
            'id'       => 'tab_three_in_cats',
            'type'     => 'switch',
            'title'    => __( 'Show tab in specific categories', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_add_prod_tab_three', '=', true ),
        ),
        array(
            'id'    => 'add_prod_tab_three_cats',
            'type'  => 'select',
            'ajax'     => true,
            'multi' => true,
            'title' => __( 'Categories', 'dina-kala' ),
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => array( 'product_cat' ),
                'hide_empty' => false,
            ),
            'required' => array( 'tab_three_in_cats', '=', true )
        ),
        array(
            'id'      => 'add_prod_tab_three_content',
            'type'    => 'editor',
            'title'   => __( 'Tab content', 'dina-kala' ),
            'default' => __( 'Text', 'dina-kala' ),
            'args'    => array(
                'wpautop'       => true,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => false,
                'quicktags'     => true,
            ),
            'required' => array( 'show_add_prod_tab_three', '=', true ),
        ),
        array(
            'id'     => 'additional-product-tab-three-end',
            'type'   => 'section',
            'indent' => false,
        ),

        array(
            'id'     => 'additional-product-tab-four-start',
            'type'   => 'section',
            'title'  => __( 'Settings of the Fourth additional tab of products', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'      => 'show_add_prod_tab_four',
            'type'    => 'switch',
            'title'   => __( 'Show tab', 'dina-kala' ),
            'default' => false,
        ),
        array(
            'id'       => 'add_prod_tab_four_title',
            'type'     => 'text',
            'title'    => __( 'Tab title', 'dina-kala' ),
            'default'  => __( 'Title', 'dina-kala' ),
            'required' => array( 'show_add_prod_tab_four', '=', true ),
        ),
        array(
            'id'       => 'add_prod_tab_four_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Tab icon', 'dina-kala' ),
            'default'  => 'fal fa-info-circle',
            'required' => array( 'show_add_prod_tab_four', '=', true ),
        ),
        array(
            'id'       => 'tab_four_in_cats',
            'type'     => 'switch',
            'title'    => __( 'Show tab in specific categories', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_add_prod_tab_four', '=', true ),
        ),
        array(
            'id'    => 'add_prod_tab_four_cats',
            'type'  => 'select',
            'ajax'     => true,
            'multi' => true,
            'title' => __( 'Categories', 'dina-kala' ),
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => array( 'product_cat' ),
                'hide_empty' => false,
            ),
            'required' => array( 'tab_four_in_cats', '=', true )
        ),
        array(
            'id'      => 'add_prod_tab_four_content',
            'type'    => 'editor',
            'title'   => __( 'Tab content', 'dina-kala' ),
            'default' => __( 'Text', 'dina-kala' ),
            'args'    => array(
                'wpautop'       => true,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => false,
                'quicktags'     => true,
            ),
            'required' => array( 'show_add_prod_tab_four', '=', true ),
        ),
        array(
            'id'     => 'additional-product-tab-four-end',
            'type'   => 'section',
            'indent' => false,
        ),

        //custom-product-tabs-start
        array(
            'id'     => 'custom-product-tabs-start',
            'type'   => 'section',
            'title'  => __( 'Settings for additional tabs on the product edit page', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'      => 'custom_product_tab_one',
            'title'   => __( 'Activation of the first tab', 'dina-kala' ),
            'type'    => 'switch',
            'default' => true,
        ),
        array(
            'id'      => 'custom_product_tab_two',
            'title'   => __( 'Activation of the second tab', 'dina-kala' ),
            'type'    => 'switch',
            'default' => false,
        ),
        array(
            'id'      => 'custom_product_tab_three',
            'title'   => __( 'Activation of the third tab', 'dina-kala' ),
            'type'    => 'switch',
            'default' => false,
        ),
        array(
            'id'     => 'custom-product-tabs-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //custom-product-tabs-end
    ),
) );

//Public meta of products SECTION
Redux::setSection( $opt_name, array(
    'title'      => __( 'Public meta of products', 'dina-kala' ),
    'id'         => 'public_product_metas',
    'icon'       => 'fal fa-list-alt',
    'desc'       => __( "Through this section, you can define additional product information such as warranty, shipping method, etc., this information is displayed on the product page next to information such as category, product brand, and product ID.", 'dina-kala' ),
    'subsection' => true,
    'fields'     => array(
        array( 
            'id'       => 'public_product_metas_docs',
            'type'     => 'raw',
            'content'  => dina_admin_info( '', 'https://i-design.ir/docs/dinakala/?p=2199', 'info' )
        ),
        //public_product_meta_one
        array(
            'id'     => 'public-product-meta-one-start',
            'type'   => 'section',
            'title'  => __( 'Settings for the first public meta of products', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'      => 'show_public_product_meta_one',
            'type'    => 'switch',
            'title'   => __( 'Show meta', 'dina-kala' ),
            'default' => false,
        ),
        array(
            'id'       => 'public_product_meta_one_purchasable',
            'type'     => 'switch',
            'title'    => __( 'Display meta only in purchasable products', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_public_product_meta_one', '=', true ),
        ),
        array(
            'id'       => 'public_product_meta_one_title',
            'type'     => 'text',
            'title'    => __( 'Meta title', 'dina-kala' ),
            'default'  => __( 'Title', 'dina-kala' ),
            'required' => array( 'show_public_product_meta_one', '=', true ),
        ),
        array(
            'id'       => 'public_product_meta_one_value',
            'type'     => 'text',
            'title'    => __( 'Meta value', 'dina-kala' ),
            'default'  => '',
            'required' => array( 'show_public_product_meta_one', '=', true ),
        ),
        array(
            'id'       => 'public_product_meta_one_link',
            'type'     => 'text',
            'title'    => __( 'Meta link', 'dina-kala' ),
            'default'  => '',
            'required' => array( 'show_public_product_meta_one', '=', true ),
        ),
        array(
            'id'       => 'public_product_meta_one_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Meta icon', 'dina-kala' ),
            'default'  => 'fal fa-shield-check',
            'required' => array( 'show_public_product_meta_one', '=', true ),
        ),
        array(
            'id'       => 'public_product_meta_one_per_product',
            'type'     => 'switch',
            'title'    => __( 'Ability to edit meta for each product individually', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_public_product_meta_one', '=', true ),
        ),
        array(
            'id'       => 'meta_one_in_cats',
            'type'     => 'switch',
            'title'    => __( 'Show product meta in specific categories', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_public_product_meta_one', '=', true ),
        ),
        array(
            'id'    => 'meta_one_cats',
            'type'  => 'select',
            'ajax'     => true,
            'multi' => true,
            'title' => __( 'Categories', 'dina-kala' ),
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => array( 'product_cat' ),
                'hide_empty' => false,
            ),
            'required' => array( 'meta_one_in_cats', '=', true )
        ),
        array(
            'id'     => 'public-product-meta-one-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //public_product_meta_one

        //public_product_meta_two
        array(
            'id'     => 'public-product-meta-two-start',
            'type'   => 'section',
            'title'  => __( 'Settings for the second public meta of products', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'      => 'show_public_product_meta_two',
            'type'    => 'switch',
            'title'   => __( 'Show meta', 'dina-kala' ),
            'default' => false,
        ),
        array(
            'id'       => 'public_product_meta_two_purchasable',
            'type'     => 'switch',
            'title'    => __( 'Display meta only in purchasable products', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_public_product_meta_two', '=', true ),
        ),
        array(
            'id'       => 'public_product_meta_two_title',
            'type'     => 'text',
            'title'    => __( 'Meta title', 'dina-kala' ),
            'default'  => __( 'Title', 'dina-kala' ),
            'required' => array( 'show_public_product_meta_two', '=', true ),
        ),
        array(
            'id'       => 'public_product_meta_two_value',
            'type'     => 'text',
            'title'    => __( 'Meta value', 'dina-kala' ),
            'default'  => '',
            'required' => array( 'show_public_product_meta_two', '=', true ),
        ),
        array(
            'id'       => 'public_product_meta_two_link',
            'type'     => 'text',
            'title'    => __( 'Meta link', 'dina-kala' ),
            'default'  => '',
            'required' => array( 'show_public_product_meta_two', '=', true ),
        ),
        array(
            'id'       => 'public_product_meta_two_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Meta icon', 'dina-kala' ),
            'default'  => 'fal fa-shield-check',
            'required' => array( 'show_public_product_meta_two', '=', true ),
        ),
        array(
            'id'       => 'public_product_meta_two_per_product',
            'type'     => 'switch',
            'title'    => __( 'Ability to edit meta for each product individually', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_public_product_meta_two', '=', true ),
        ),
        array(
            'id'       => 'meta_two_in_cats',
            'type'     => 'switch',
            'title'    => __( 'Show product meta in specific categories', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_public_product_meta_two', '=', true ),
        ),
        array(
            'id'    => 'meta_two_cats',
            'type'  => 'select',
            'ajax'  => true,
            'multi' => true,
            'title' => __( 'Categories', 'dina-kala' ),
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => array( 'product_cat' ),
                'hide_empty' => false,
            ),
            'required' => array( 'meta_two_in_cats', '=', true )
        ),
        array(
            'id'     => 'public-product-meta-two-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //public_product_meta_two

        //public_product_meta_three
        array(
            'id'     => 'public-product-meta-three-start',
            'type'   => 'section',
            'title'  => __( 'Settings for the third public meta of products', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'      => 'show_public_product_meta_three',
            'type'    => 'switch',
            'title'   => __( 'Show meta', 'dina-kala' ),
            'default' => false,
        ),
        array(
            'id'       => 'public_product_meta_three_purchasable',
            'type'     => 'switch',
            'title'    => __( 'Display meta only in purchasable products', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_public_product_meta_three', '=', true ),
        ),
        array(
            'id'       => 'public_product_meta_three_title',
            'type'     => 'text',
            'title'    => __( 'Meta title', 'dina-kala' ),
            'default'  => __( 'Title', 'dina-kala' ),
            'required' => array( 'show_public_product_meta_three', '=', true ),
        ),
        array(
            'id'       => 'public_product_meta_three_value',
            'type'     => 'text',
            'title'    => __( 'Meta value', 'dina-kala' ),
            'default'  => '',
            'required' => array( 'show_public_product_meta_three', '=', true ),
        ),
        array(
            'id'       => 'public_product_meta_three_link',
            'type'     => 'text',
            'title'    => __( 'Meta link', 'dina-kala' ),
            'default'  => '',
            'required' => array( 'show_public_product_meta_three', '=', true ),
        ),
        array(
            'id'       => 'public_product_meta_three_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Meta icon', 'dina-kala' ),
            'default'  => 'fal fa-shield-check',
            'required' => array( 'show_public_product_meta_three', '=', true ),
        ),
        array(
            'id'       => 'public_product_meta_three_per_product',
            'type'     => 'switch',
            'title'    => __( 'Ability to edit meta for each product individually', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_public_product_meta_three', '=', true ),
        ),
        array(
            'id'       => 'meta_three_in_cats',
            'type'     => 'switch',
            'title'    => __( 'Show product meta in specific categories', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_public_product_meta_three', '=', true ),
        ),
        array(
            'id'    => 'meta_three_cats',
            'type'  => 'select',
            'ajax'  => true,
            'multi' => true,
            'title' => __( 'Categories', 'dina-kala' ),
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => array( 'product_cat' ),
                'hide_empty' => false,
            ),
            'required' => array( 'meta_three_in_cats', '=', true )
        ),
        array(
            'id'     => 'public-product-meta-three-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //public_product_meta_three

        //public_product_meta_four
        array(
            'id'     => 'public-product-meta-four-start',
            'type'   => 'section',
            'title'  => __( 'Settings for the fourth public meta of products', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'      => 'show_public_product_meta_four',
            'type'    => 'switch',
            'title'   => __( 'Show meta', 'dina-kala' ),
            'default' => false,
        ),
        array(
            'id'       => 'public_product_meta_four_purchasable',
            'type'     => 'switch',
            'title'    => __( 'Display meta only in purchasable products', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_public_product_meta_four', '=', true ),
        ),
        array(
            'id'       => 'public_product_meta_four_title',
            'type'     => 'text',
            'title'    => __( 'Meta title', 'dina-kala' ),
            'default'  => __( 'Title', 'dina-kala' ),
            'required' => array( 'show_public_product_meta_four', '=', true ),
        ),
        array(
            'id'       => 'public_product_meta_four_value',
            'type'     => 'text',
            'title'    => __( 'Meta value', 'dina-kala' ),
            'default'  => '',
            'required' => array( 'show_public_product_meta_four', '=', true ),
        ),
        array(
            'id'       => 'public_product_meta_four_link',
            'type'     => 'text',
            'title'    => __( 'Meta link', 'dina-kala' ),
            'default'  => '',
            'required' => array( 'show_public_product_meta_four', '=', true ),
        ),
        array(
            'id'       => 'public_product_meta_four_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Meta icon', 'dina-kala' ),
            'default'  => 'fal fa-shield-check',
            'required' => array( 'show_public_product_meta_four', '=', true ),
        ),
        array(
            'id'       => 'public_product_meta_four_per_product',
            'type'     => 'switch',
            'title'    => __( 'Ability to edit meta for each product individually', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_public_product_meta_four', '=', true ),
        ),
        array(
            'id'       => 'meta_four_in_cats',
            'type'     => 'switch',
            'title'    => __( 'Show product meta in specific categories', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_public_product_meta_four', '=', true ),
        ),
        array(
            'id'    => 'meta_four_cats',
            'type'  => 'select',
            'ajax'     => true,
            'multi' => true,
            'title' => __( 'Categories', 'dina-kala' ),
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => array( 'product_cat' ),
                'hide_empty' => false,
            ),
            'required' => array( 'meta_four_in_cats', '=', true )
        ),
        array(
            'id'     => 'public-product-meta-four-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //public_product_meta_four

        //public_product_meta_five
        array(
            'id'     => 'public-product-meta-five-start',
            'type'   => 'section',
            'title'  => __( 'Settings for the fifth public meta of products', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'      => 'show_public_product_meta_five',
            'type'    => 'switch',
            'title'   => __( 'Show meta', 'dina-kala' ),
            'default' => false,
        ),
        array(
            'id'       => 'public_product_meta_five_purchasable',
            'type'     => 'switch',
            'title'    => __( 'Display meta only in purchasable products', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_public_product_meta_five', '=', true ),
        ),
        array(
            'id'       => 'public_product_meta_five_title',
            'type'     => 'text',
            'title'    => __( 'Meta title', 'dina-kala' ),
            'default'  => __( 'Title', 'dina-kala' ),
            'required' => array( 'show_public_product_meta_five', '=', true ),
        ),
        array(
            'id'       => 'public_product_meta_five_value',
            'type'     => 'text',
            'title'    => __( 'Meta value', 'dina-kala' ),
            'default'  => '',
            'required' => array( 'show_public_product_meta_five', '=', true ),
        ),
        array(
            'id'       => 'public_product_meta_five_link',
            'type'     => 'text',
            'title'    => __( 'Meta link', 'dina-kala' ),
            'default'  => '',
            'required' => array( 'show_public_product_meta_five', '=', true ),
        ),
        array(
            'id'       => 'public_product_meta_five_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Meta icon', 'dina-kala' ),
            'default'  => 'fal fa-shield-check',
            'required' => array( 'show_public_product_meta_five', '=', true ),
        ),
        array(
            'id'       => 'public_product_meta_five_per_product',
            'type'     => 'switch',
            'title'    => __( 'Ability to edit meta for each product individually', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_public_product_meta_five', '=', true ),
        ),
        array(
            'id'       => 'meta_five_in_cats',
            'type'     => 'switch',
            'title'    => __( 'Show product meta in specific categories', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_public_product_meta_five', '=', true ),
        ),
        array(
            'id'    => 'meta_five_cats',
            'type'  => 'select',
            'ajax'     => true,
            'multi' => true,
            'title' => __( 'Categories', 'dina-kala' ),
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => array( 'product_cat' ),
                'hide_empty' => false,
            ),
            'required' => array( 'meta_five_in_cats', '=', true )
        ),
        array(
            'id'     => 'public-product-meta-five-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //public_product_meta_five

    ),
) );

//Product page messages SECTION
Redux::setSection( $opt_name, array(
    'title'      => __( 'Product page messages', 'dina-kala' ),
    'id'         => 'product_page_messages',
    'icon'       => 'fal fa-comments-alt',
    'desc'       => __( "Through this section, you can display messages in different sections of the product page.", 'dina-kala' ),
    'subsection' => true,
    'fields'     => array(
        array( 
            'id'       => 'product_page_messages_docs',
            'type'     => 'raw',
            'content'  => dina_admin_info( '', 'https://i-design.ir/docs/dinakala/?p=2208', 'info' )
        ),
          //product_page_message_one
        array(
            'id'     => 'product-page-message-one-start',
            'type'   => 'section',
            'title'  => __( 'Settings for the first message of the product page', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'      => 'show_product_page_message_one',
            'type'    => 'switch',
            'title'   => __( 'Show first message', 'dina-kala' ),
            'default' => false,
        ),
        array(
            'id'       => 'product_page_message_one_purchasable',
            'type'     => 'switch',
            'title'    => __( 'Display message only in purchasable products', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_product_page_message_one', '=', true ),
        ),
        array(
            'id'      => 'product_page_message_one_content',
            'type'    => 'editor',
            'title'   => __( 'Message content', 'dina-kala' ),
            'default' => __( 'Message content', 'dina-kala' ),
            'desc'    => __( 'You can also use the shortcode', 'dina-kala' ),
            'args'    => array(
                'wpautop'       => true,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => false,
                'quicktags'     => true,
            ),
            'required' => array( 'show_product_page_message_one', '=', true ),
        ),
        array(
            'id'       => 'product_page_message_one_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Message icon', 'dina-kala' ),
            'default'  => 'fal fa-info-circle',
            'required' => array( 'show_product_page_message_one', '=', true ),
        ),
        array(
            'id'      => 'product_page_message_one_location',
            'type'    => 'select',
            'title'   => __( 'Message location', 'dina-kala' ),
            'options' => array(
                'dina_before_product_features'    => __( 'Above the features next to the product image', 'dina-kala' ),
                'dina_after_product_features'     => __( 'Below the features next to the product image', 'dina-kala' ),
                'dina_before_price_con'           => __( 'Above the product purchase button', 'dina-kala' ),
                'dina_after_price_con'            => __( 'Below the product purchase button', 'dina-kala' ),
                'dina_before_product_description' => __( 'Above the product description', 'dina-kala' ),
                'dina_after_product_description'  => __( 'Below the product description', 'dina-kala' ),
                'dina_after_single_meta'          => __( 'Below product metas', 'dina-kala' ),
            ),
            'default'  => 'dina_before_product_features',
            'required' => array( 'show_product_page_message_one', '=', true ),
        ),
        array(
            'id'      => 'product_page_message_one_color',
            'type'    => 'select',
            'title'   => __( 'Message color', 'dina-kala' ),
            'options' => array(
                'alert-primary'   => __( 'Blue', 'dina-kala' ),
                'alert-info'      => __( 'Light Blue', 'dina-kala' ),
                'alert-warning'   => __( 'Yellow', 'dina-kala' ),
                'alert-success'   => __( 'Green', 'dina-kala' ),
                'alert-light'     => __( 'White', 'dina-kala' ),
                'alert-secondary' => __( 'Grey', 'dina-kala' ),
                'alert-danger'    => __( 'Red', 'dina-kala' ),
                'alert-dark'      => __( 'Dark Grey', 'dina-kala' ),
            ),
            'default'  => 'alert-success',
            'required' => array( 'show_product_page_message_one', '=', true ),
        ),
        array(
            'id'       => 'product_page_message_one_per_product',
            'type'     => 'switch',
            'title'    => __( 'Ability to edit message for each product individually', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_product_page_message_one', '=', true ),
        ),
        array(
            'id'       => 'product_page_message_one_in_cats',
            'type'     => 'switch',
            'title'    => __( 'Show message in specific categories', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_product_page_message_one', '=', true ),
        ),
        array(
            'id'    => 'product_page_message_one_cats',
            'type'  => 'select',
            'ajax'  => true,
            'multi' => true,
            'title' => __( 'Categories', 'dina-kala' ),
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => array( 'product_cat' ),
                'hide_empty' => false,
            ),
            'required' => array( 'product_page_message_one_in_cats', '=', true )
        ),
        array(
            'id'     => 'product-page-message-one-end',
            'type'   => 'section',
            'indent' => false,
        ),
          //product_page_message_one


          //product_page_message_two
        array(
            'id'     => 'product-page-message-two-start',
            'type'   => 'section',
            'title'  => __( 'Settings for the second message of the product page', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'      => 'show_product_page_message_two',
            'type'    => 'switch',
            'title'   => __( 'Show second message', 'dina-kala' ),
            'default' => false,
        ),
        array(
            'id'      => 'product_page_message_two_purchasable',
            'type'    => 'switch',
            'title'   => __( 'Display message only in purchasable products', 'dina-kala' ),
            'default' => false,
            'required' => array( 'show_product_page_message_two', '=', true ),
        ),
        array(
            'id'      => 'product_page_message_two_content',
            'type'    => 'editor',
            'title'   => __( 'Message content', 'dina-kala' ),
            'default' => __( 'Message content', 'dina-kala' ),
            'desc'    => __( 'You can also use the shortcode', 'dina-kala' ),
            'args'    => array(
                'wpautop'       => true,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => false,
                'quicktags'     => true,
            ),
            'required' => array( 'show_product_page_message_two', '=', true ),
        ),
        array(
            'id'       => 'product_page_message_two_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Message icon', 'dina-kala' ),
            'default'  => 'fal fa-info-circle',
            'required' => array( 'show_product_page_message_two', '=', true ),
        ),
        array(
            'id'      => 'product_page_message_two_location',
            'type'    => 'select',
            'title'   => __( 'Message location', 'dina-kala' ),
            'options' => array(
                'dina_before_product_features'    => __( 'Above the features next to the product image', 'dina-kala' ),
                'dina_after_product_features'     => __( 'Below the features next to the product image', 'dina-kala' ),
                'dina_before_price_con'           => __( 'Above the product purchase button', 'dina-kala' ),
                'dina_after_price_con'            => __( 'Below the product purchase button', 'dina-kala' ),
                'dina_before_product_description' => __( 'Above the product description', 'dina-kala' ),
                'dina_after_product_description'  => __( 'Below the product description', 'dina-kala' ),
                'dina_after_single_meta'          => __( 'Below product metas', 'dina-kala' ),
            ),
            'default'  => 'dina_before_product_features',
            'required' => array( 'show_product_page_message_two', '=', true ),
        ),
        array(
            'id'      => 'product_page_message_two_color',
            'type'    => 'select',
            'title'   => __( 'Message color', 'dina-kala' ),
            'options' => array(
                'alert-primary'   => __( 'Blue', 'dina-kala' ),
                'alert-info'      => __( 'Light Blue', 'dina-kala' ),
                'alert-warning'   => __( 'Yellow', 'dina-kala' ),
                'alert-success'   => __( 'Green', 'dina-kala' ),
                'alert-light'     => __( 'White', 'dina-kala' ),
                'alert-secondary' => __( 'Grey', 'dina-kala' ),
                'alert-danger'    => __( 'Red', 'dina-kala' ),
                'alert-dark'      => __( 'Dark Grey', 'dina-kala' ),
            ),
            'default'  => 'alert-success',
            'required' => array( 'show_product_page_message_two', '=', true ),
        ),
        array(
            'id'       => 'product_page_message_two_per_product',
            'type'     => 'switch',
            'title'    => __( 'Ability to edit message for each product individually', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_product_page_message_two', '=', true ),
        ),
        array(
            'id'       => 'product_page_message_two_in_cats',
            'type'     => 'switch',
            'title'    => __( 'Show message in specific categories', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_product_page_message_two', '=', true ),
        ),
        array(
            'id'    => 'product_page_message_two_cats',
            'type'  => 'select',
            'ajax'  => true,
            'multi' => true,
            'title' => __( 'Categories', 'dina-kala' ),
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => array( 'product_cat' ),
                'hide_empty' => false,
            ),
            'required' => array( 'product_page_message_two_in_cats', '=', true )
        ),
        array(
            'id'     => 'product-page-message-two-end',
            'type'   => 'section',
            'indent' => false,
        ),
          //product_page_message_two

          //product_page_message_three
        array(
            'id'     => 'product-page-message-three-start',
            'type'   => 'section',
            'title'  => __( 'Settings for the third message of the product page', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'      => 'show_product_page_message_three',
            'type'    => 'switch',
            'title'   => __( 'Show third message', 'dina-kala' ),
            'default' => false,
        ),
        array(
            'id'       => 'product_page_message_three_purchasable',
            'type'     => 'switch',
            'title'    => __( 'Display message only in purchasable products', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_product_page_message_three', '=', true ),
        ),
        array(
            'id'      => 'product_page_message_three_content',
            'type'    => 'editor',
            'title'   => __( 'Message content', 'dina-kala' ),
            'default' => __( 'Message content', 'dina-kala' ),
            'desc'    => __( 'You can also use the shortcode', 'dina-kala' ),
            'args'    => array(
                'wpautop'       => true,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => false,
                'quicktags'     => true,
            ),
            'required' => array( 'show_product_page_message_three', '=', true ),
        ),
        array(
            'id'       => 'product_page_message_three_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Message icon', 'dina-kala' ),
            'default'  => 'fal fa-info-circle',
            'required' => array( 'show_product_page_message_three', '=', true ),
        ),
        array(
            'id'      => 'product_page_message_three_location',
            'type'    => 'select',
            'title'   => __( 'Message location', 'dina-kala' ),
            'options' => array(
                'dina_before_product_features'    => __( 'Above the features next to the product image', 'dina-kala' ),
                'dina_after_product_features'     => __( 'Below the features next to the product image', 'dina-kala' ),
                'dina_before_price_con'           => __( 'Above the product purchase button', 'dina-kala' ),
                'dina_after_price_con'            => __( 'Below the product purchase button', 'dina-kala' ),
                'dina_before_product_description' => __( 'Above the product description', 'dina-kala' ),
                'dina_after_product_description'  => __( 'Below the product description', 'dina-kala' ),
                'dina_after_single_meta'          => __( 'Below product metas', 'dina-kala' ),
            ),
            'default'  => 'dina_before_product_features',
            'required' => array( 'show_product_page_message_three', '=', true ),
        ),
        array(
            'id'      => 'product_page_message_three_color',
            'type'    => 'select',
            'title'   => __( 'Message color', 'dina-kala' ),
            'options' => array(
                'alert-primary'   => __( 'Blue', 'dina-kala' ),
                'alert-info'      => __( 'Light Blue', 'dina-kala' ),
                'alert-warning'   => __( 'Yellow', 'dina-kala' ),
                'alert-success'   => __( 'Green', 'dina-kala' ),
                'alert-light'     => __( 'White', 'dina-kala' ),
                'alert-secondary' => __( 'Grey', 'dina-kala' ),
                'alert-danger'    => __( 'Red', 'dina-kala' ),
                'alert-dark'      => __( 'Dark Grey', 'dina-kala' ),
            ),
            'default'  => 'alert-success',
            'required' => array( 'show_product_page_message_three', '=', true ),
        ),
        array(
            'id'       => 'product_page_message_three_per_product',
            'type'     => 'switch',
            'title'    => __( 'Ability to edit message for each product individually', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_product_page_message_three', '=', true ),
        ),
        array(
            'id'       => 'product_page_message_three_in_cats',
            'type'     => 'switch',
            'title'    => __( 'Show message in specific categories', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_product_page_message_three', '=', true ),
        ),
        array(
            'id'    => 'product_page_message_three_cats',
            'type'  => 'select',
            'ajax'  => true,
            'multi' => true,
            'title' => __( 'Categories', 'dina-kala' ),
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => array( 'product_cat' ),
                'hide_empty' => false,
            ),
            'required' => array( 'product_page_message_three_in_cats', '=', true )
        ),
        array(
            'id'     => 'product-page-message-three-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //product_page_message_three

        //product_page_message_four
        array(
            'id'     => 'product-page-message-four-start',
            'type'   => 'section',
            'title'  => __( 'Settings for the forth message of the product page', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'      => 'show_product_page_message_four',
            'type'    => 'switch',
            'title'   => __( 'Show forth message', 'dina-kala' ),
            'default' => false,
        ),
        array(
            'id'       => 'product_page_message_four_purchasable',
            'type'     => 'switch',
            'title'    => __( 'Display message only in purchasable products', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_product_page_message_four', '=', true ),
        ),
        array(
            'id'      => 'product_page_message_four_content',
            'type'    => 'editor',
            'title'   => __( 'Message content', 'dina-kala' ),
            'default' => __( 'Message content', 'dina-kala' ),
            'desc'    => __( 'You can also use the shortcode', 'dina-kala' ),
            'args'    => array(
                'wpautop'       => true,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => false,
                'quicktags'     => true,
            ),
            'required' => array( 'show_product_page_message_four', '=', true ),
        ),
        array(
            'id'       => 'product_page_message_four_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Message icon', 'dina-kala' ),
            'default'  => 'fal fa-info-circle',
            'required' => array( 'show_product_page_message_four', '=', true ),
        ),
        array(
            'id'      => 'product_page_message_four_location',
            'type'    => 'select',
            'title'   => __( 'Message location', 'dina-kala' ),
            'options' => array(
                'dina_before_product_features'    => __( 'Above the features next to the product image', 'dina-kala' ),
                'dina_after_product_features'     => __( 'Below the features next to the product image', 'dina-kala' ),
                'dina_before_price_con'           => __( 'Above the product purchase button', 'dina-kala' ),
                'dina_after_price_con'            => __( 'Below the product purchase button', 'dina-kala' ),
                'dina_before_product_description' => __( 'Above the product description', 'dina-kala' ),
                'dina_after_product_description'  => __( 'Below the product description', 'dina-kala' ),
                'dina_after_single_meta'          => __( 'Below product metas', 'dina-kala' ),
            ),
            'default'  => 'dina_before_product_features',
            'required' => array( 'show_product_page_message_four', '=', true ),
        ),
        array(
            'id'      => 'product_page_message_four_color',
            'type'    => 'select',
            'title'   => __( 'Message color', 'dina-kala' ),
            'options' => array(
                'alert-primary'   => __( 'Blue', 'dina-kala' ),
                'alert-info'      => __( 'Light Blue', 'dina-kala' ),
                'alert-warning'   => __( 'Yellow', 'dina-kala' ),
                'alert-success'   => __( 'Green', 'dina-kala' ),
                'alert-light'     => __( 'White', 'dina-kala' ),
                'alert-secondary' => __( 'Grey', 'dina-kala' ),
                'alert-danger'    => __( 'Red', 'dina-kala' ),
                'alert-dark'      => __( 'Dark Grey', 'dina-kala' ),
            ),
            'default'  => 'alert-success',
            'required' => array( 'show_product_page_message_four', '=', true ),
        ),
        array(
            'id'       => 'product_page_message_four_per_product',
            'type'     => 'switch',
            'title'    => __( 'Ability to edit message for each product individually', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_product_page_message_four', '=', true ),
        ),
        array(
            'id'       => 'product_page_message_four_in_cats',
            'type'     => 'switch',
            'title'    => __( 'Show message in specific categories', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_product_page_message_four', '=', true ),
        ),
        array(
            'id'    => 'product_page_message_four_cats',
            'type'  => 'select',
            'ajax'     => true,
            'multi' => true,
            'title' => __( 'Categories', 'dina-kala' ),
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => array( 'product_cat' ),
                'hide_empty' => false,
            ),
            'required' => array( 'product_page_message_four_in_cats', '=', true )
        ),
        array(
            'id'     => 'product-page-message-four-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //product_page_message_four

        //product_page_message_five
        array(
            'id'     => 'product-page-message-five-start',
            'type'   => 'section',
            'title'  => __( 'Settings for the fifth message of the product page', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'      => 'show_product_page_message_five',
            'type'    => 'switch',
            'title'   => __( 'Show fifth message', 'dina-kala' ),
            'default' => false,
        ),
        array(
            'id'       => 'product_page_message_five_purchasable',
            'type'     => 'switch',
            'title'    => __( 'Display message only in purchasable products', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_product_page_message_five', '=', true ),
        ),
        array(
            'id'      => 'product_page_message_five_content',
            'type'    => 'editor',
            'title'   => __( 'Message content', 'dina-kala' ),
            'default' => __( 'Message content', 'dina-kala' ),
            'desc'    => __( 'You can also use the shortcode', 'dina-kala' ),
            'args'    => array(
                'wpautop'       => true,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => false,
                'quicktags'     => true,
            ),
            'required' => array( 'show_product_page_message_five', '=', true ),
        ),
        array(
            'id'       => 'product_page_message_five_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Message icon', 'dina-kala' ),
            'default'  => 'fal fa-info-circle',
            'required' => array( 'show_product_page_message_five', '=', true ),
        ),
        array(
            'id'      => 'product_page_message_five_location',
            'type'    => 'select',
            'title'   => __( 'Message location', 'dina-kala' ),
            'options' => array(
                'dina_before_product_features'    => __( 'Above the features next to the product image', 'dina-kala' ),
                'dina_after_product_features'     => __( 'Below the features next to the product image', 'dina-kala' ),
                'dina_before_price_con'           => __( 'Above the product purchase button', 'dina-kala' ),
                'dina_after_price_con'            => __( 'Below the product purchase button', 'dina-kala' ),
                'dina_before_product_description' => __( 'Above the product description', 'dina-kala' ),
                'dina_after_product_description'  => __( 'Below the product description', 'dina-kala' ),
                'dina_after_single_meta'          => __( 'Below product metas', 'dina-kala' ),
            ),
            'default'  => 'dina_before_product_features',
            'required' => array( 'show_product_page_message_five', '=', true ),
        ),
        array(
            'id'      => 'product_page_message_five_color',
            'type'    => 'select',
            'title'   => __( 'Message color', 'dina-kala' ),
            'options' => array(
                'alert-primary'   => __( 'Blue', 'dina-kala' ),
                'alert-info'      => __( 'Light Blue', 'dina-kala' ),
                'alert-warning'   => __( 'Yellow', 'dina-kala' ),
                'alert-success'   => __( 'Green', 'dina-kala' ),
                'alert-light'     => __( 'White', 'dina-kala' ),
                'alert-secondary' => __( 'Grey', 'dina-kala' ),
                'alert-danger'    => __( 'Red', 'dina-kala' ),
                'alert-dark'      => __( 'Dark Grey', 'dina-kala' ),
            ),
            'default'  => 'alert-success',
            'required' => array( 'show_product_page_message_five', '=', true ),
        ),
        array(
            'id'       => 'product_page_message_five_per_product',
            'type'     => 'switch',
            'title'    => __( 'Ability to edit message for each product individually', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_product_page_message_five', '=', true ),
        ),
        array(
            'id'       => 'product_page_message_five_in_cats',
            'type'     => 'switch',
            'title'    => __( 'Show message in specific categories', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_product_page_message_five', '=', true ),
        ),
        array(
            'id'    => 'product_page_message_five_cats',
            'type'  => 'select',
            'ajax'     => true,
            'multi' => true,
            'title' => __( 'Categories', 'dina-kala' ),
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => array( 'product_cat' ),
                'hide_empty' => false,
            ),
            'required' => array( 'product_page_message_five_in_cats', '=', true )
        ),
        array(
            'id'     => 'product-page-message-five-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //product_page_message_five
    ),
) );

//Product page buttons SECTION
Redux::setSection( $opt_name, array(
    'title'      => __( 'Additional product button', 'dina-kala' ),
    'id'         => 'additional_product_button',
    'icon'       => 'fal fa-plus-square',
    'desc'       => __( "Activate the Additional buttons on the product page. You can manage this buttons for each product separately.", 'dina-kala' ),
    'subsection' => true,
    'fields'     => array(

        array( 
            'id'       => 'product_page_btns_docs',
            'type'     => 'raw',
            'content'  => dina_admin_info( '', 'https://i-design.ir/docs/dinakala/?p=3834', 'info' )
        ),

        //pbtn-section-start
        array(
            'id'     => 'pbtn-section-start',
            'type'   => 'section',
            'title'  => __( 'Additional product button settings', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'      => 'show_add_prod_btn',
            'type'    => 'switch',
            'title'   => __( 'Display Additional button in product page', 'dina-kala' ),
            'default' => false,
        ),
        array(
            'id'       => 'show_add_prod_call',
            'type'     => 'switch',
            'title'    => __( 'Display Additional button in non-purchasable products', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'add_prod_btn_in_cats',
            'type'     => 'switch',
            'title'    => __( 'Display Additional button in specific categories', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_add_prod_btn', '=', true ),
        ),
        array(
            'id'    => 'add_prod_btn_cats',
            'type'  => 'select',
            'ajax'     => true,
            'multi' => true,
            'title' => __( 'Categories', 'dina-kala' ),
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => array( 'product_cat' ),
                'hide_empty' => false,
            ),
            'required' => array( 'add_prod_btn_in_cats', '=', true )
        ),
        array(
            'id'       => 'add_prod_btn_not_cats',
            'type'     => 'switch',
            'title'    => __( 'Hide Additional button in specific categories', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_add_prod_btn', '=', true ),
        ),
        array(
            'id'    => 'add_prod_btn_ncats',
            'type'  => 'select',
            'ajax'     => true,
            'multi' => true,
            'title' => __( 'Categories', 'dina-kala' ),
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => array( 'product_cat' ),
                'hide_empty' => false,
            ),
            'required' => array( 'add_prod_btn_not_cats', '=', true )
        ),
        array(
            'id'       => 'add_per_prod_link',
            'type'     => 'switch',
            'title'    => __( 'Activate the ability to customize the title and link for each product', 'dina-kala' ),
            'default'  => false,
            'required' => array( 
                array( 'show_add_prod_btn', '=', true ),
                array( 'show_add_prod_popup', '!=', true ),
            )
        ),
        array(
            'id'       => 'add_cat_prod_link',
            'type'     => 'switch',
            'title'    => __( 'Activate the ability to customize the title and link for each product category', 'dina-kala' ),
            'default'  => false,
            'required' => array( 
                array( 'show_add_prod_btn', '=', true ),
                array( 'show_add_prod_popup', '!=', true ),
            )
        ),
        array(
            'id'      => 'add_prod_btn_location',
            'type'    => 'select',
            'title'   => __( 'Button display location', 'dina-kala' ),
            'options' => array(
                'location1'  => __( 'Below are the product features', 'dina-kala' ),
                'location2'  => __( 'Next to the buy button', 'dina-kala' ),
            ),
            'default'  => 'location1',
            'required' => array( 'show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'add_prod_btn_title',
            'type'     => 'text',
            'title'    => __( 'Additional product button title', 'dina-kala' ),
            'default'  => __( 'Title', 'dina-kala' ),
            'required' => array( 'show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'add_prod_btn_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Additional product button icon', 'dina-kala' ),
            'default'  => 'fal fa-bell',
            'required' => array( 'show_add_prod_btn', '=', true ),
        ),
        array(
            'id'      => 'add_prod_btn_color',
            'type'    => 'select',
            'title'   => __( 'Button color', 'dina-kala' ),
            'options' => array(
                'btn-outline-dina'    => __( 'Theme Color', 'dina-kala' ),
                'btn-outline-info'    => __( 'Blue', 'dina-kala' ),
                'btn-outline-primary' => __( 'Dark Blue', 'dina-kala' ),
                'btn-outline-warning' => __( 'Yellow', 'dina-kala' ),
                'btn-outline-success' => __( 'Green', 'dina-kala' ),
                'btn-outline-dark'    => __( 'Dark', 'dina-kala' ),
                'btn-outline-danger'  => __( 'Red', 'dina-kala' ),
                'btn-info'            => __( 'Solid Blue', 'dina-kala' ),
                'btn-primary'         => __( 'Solid Dark Blue', 'dina-kala' ),
                'btn-warning'         => __( 'Solid Yellow', 'dina-kala' ),
                'btn-success'         => __( 'Solid Green', 'dina-kala' ),
                'btn-dark'            => __( 'Solid Dark', 'dina-kala' ),
                'btn-danger'          => __( 'Solid Red', 'dina-kala' )
            ),
            'default'  => 'btn-outline-dina',
            'required' => array( 'show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'add_prod_btn_size',
            'type'     => 'select',
            'title'    => __( 'Button size', 'dina-kala' ),
            'options'  => array(
                'btn-sm' => __( 'Small', 'dina-kala' ),
                'btn-md' => __( 'Medium', 'dina-kala' ),
                'btn-lg' => __( 'Large', 'dina-kala' )
            ),
            'default'  => 'btn-md',
            'required' => array( 'show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'add_prod_btn_link',
            'type'     => 'text',
            'title'    => __( 'Additional product button link', 'dina-kala' ),
            'desc'     => __( 'You can also use the shortcode. For example: [dina_title] = product title, [dina_short_link] = product short link, [dina_price] = product price</br>WhatsApp link example:</br><pre>https://api.whatsapp.com/send?phone=989123334444&text=[dina_title] - [dina_short_link]</pre>', 'dina-kala' ),
            'default'  => __( '#', 'dina-kala' ),
            'required' => array( 
                array( 'show_add_prod_btn', '=', true ),
                array( 'show_add_prod_popup', '!=', true ),
            )
        ),
        array(
            'id'      => 'add_prod_btn_link_target',
            'type'    => 'select',
            'title'   => __( 'Link Target', 'dina-kala' ),
            'options' => array(
                '_blank' => __( 'New Window', 'dina-kala' ),
                '_self'  => __( 'Same Window', 'dina-kala' ),
            ),
            'default'  => '_blank',
            'required' => array( 
                array( 'show_add_prod_btn', '=', true ),
                array( 'show_add_prod_popup', '!=', true ),
            )
        ),
        array(
            'id'       => 'add_prod_btn_link_nofollow',
            'type'     => 'switch',
            'title'    => __( 'Add nofollow property to link', 'dina-kala' ),
            'default'  => false,
            'required' => array( 
                array( 'show_add_prod_btn', '=', true ),
                array( 'show_add_prod_popup', '!=', true ),
            )
        ),
        array(
            'id'       => 'show_add_prod_popup',
            'type'     => 'switch',
            'title'    => __( 'Show pop-up by clicking the button', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'add_per_prod_popup',
            'type'     => 'switch',
            'title'    => __( 'Activate the ability to customize the title and content for each product', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_add_prod_popup', '=', true ),
        ),
        array(
            'id'       => 'add_cat_prod_popup',
            'type'     => 'switch',
            'title'    => __( 'Activate the ability to customize the title and content for each product category', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'show_add_prod_popup', '=', true ),
        ),
        array(
            'id'       => 'add_prod_popup_title',
            'type'     => 'text',
            'title'    => __( 'Pop-up title', 'dina-kala' ),
            'default'  => __( 'Title', 'dina-kala' ),
            'required' => array( 'show_add_prod_popup', '=', true ),
        ),
        array(
            'id'      => 'add_prod_popup_size',
            'type'    => 'select',
            'title'   => __( 'Pop-up size', 'dina-kala' ),
            'options' => array(
                'modal-sm' => __( 'Small', 'dina-kala' ),
                'modal-md' => __( 'Default', 'dina-kala' ),
                'modal-lg' => __( 'Larg', 'dina-kala' ),
            ),
            'default'  => 'modal-md',
            'required' => array( 'show_add_prod_popup', '=', true ),
        ),
        array(
            'id'      => 'add_prod_popup_text',
            'type'    => 'editor',
            'title'   => __( 'Pop-up content', 'dina-kala' ),
            'desc'    => __( 'You can also use the shortcode', 'dina-kala' ),
            'default' => __( 'Content', 'dina-kala' ),
            'args'    => array(
                'wpautop'       => true,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => false,
                'quicktags'     => true,
            ),
            'required' => array( 'show_add_prod_popup', '=', true ),
        ),
        array(
            'id'     => 'pbtn-section-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //pinfo-section-end

        //second-pbtn-section-start
        array(
            'id'     => 'second-pbtn-section-start',
            'type'   => 'section',
            'title'  => __( 'Second additional product button settings', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'      => 'second_show_add_prod_btn',
            'type'    => 'switch',
            'title'   => __( 'Display second additional button in product page', 'dina-kala' ),
            'default' => false,
        ),
        array(
            'id'       => 'second_show_add_prod_call',
            'type'     => 'switch',
            'title'    => __( 'Display Second additional button in non-purchasable products', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'second_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'second_add_prod_btn_in_cats',
            'type'     => 'switch',
            'title'    => __( 'Display second additional button in specific categories', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'second_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'    => 'second_add_prod_btn_cats',
            'type'  => 'select',
            'ajax'     => true,
            'multi' => true,
            'title' => __( 'Categories', 'dina-kala' ),
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => array( 'product_cat' ),
                'hide_empty' => false,
            ),
            'required' => array( 'second_add_prod_btn_in_cats', '=', true )
        ),
        array(
            'id'       => 'second_add_prod_btn_not_cats',
            'type'     => 'switch',
            'title'    => __( 'Hide second additional button in specific categories', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'second_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'    => 'second_add_prod_btn_ncats',
            'type'  => 'select',
            'ajax'     => true,
            'multi' => true,
            'title' => __( 'Categories', 'dina-kala' ),
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => array( 'product_cat' ),
                'hide_empty' => false,
            ),
            'required' => array( 'second_add_prod_btn_not_cats', '=', true )
        ),
        array(
            'id'       => 'second_add_per_prod_link',
            'type'     => 'switch',
            'title'    => __( 'Activate the ability to customize the title and link for each product', 'dina-kala' ),
            'default'  => false,
            'required' => array( 
                array( 'second_show_add_prod_btn', '=', true ),
                array( 'second_show_add_prod_popup', '!=', true ),
            )
        ),
        array(
            'id'       => 'second_add_cat_prod_link',
            'type'     => 'switch',
            'title'    => __( 'Activate the ability to customize the title and link for each product category', 'dina-kala' ),
            'default'  => false,
            'required' => array( 
                array( 'second_show_add_prod_btn', '=', true ),
                array( 'second_show_add_prod_popup', '!=', true ),
            )
        ),
        array(
            'id'      => 'second_add_prod_btn_location',
            'type'    => 'select',
            'title'   => __( 'Button display location', 'dina-kala' ),
            'options' => array(
                'location1'  => __( 'Below are the product features', 'dina-kala' ),
                'location2'  => __( 'Next to the buy button', 'dina-kala' ),
            ),
            'default'  => 'location1',
            'required' => array( 'second_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'second_add_prod_btn_title',
            'type'     => 'text',
            'title'    => __( 'Second additional product button title', 'dina-kala' ),
            'default'  => __( 'Title', 'dina-kala' ),
            'required' => array( 'second_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'second_add_prod_btn_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Second additional product button icon', 'dina-kala' ),
            'default'  => 'fal fa-bell',
            'required' => array( 'second_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'      => 'second_add_prod_btn_color',
            'type'    => 'select',
            'title'   => __( 'Button color', 'dina-kala' ),
            'options' => array(
                'btn-outline-dina'    => __( 'Theme Color', 'dina-kala' ),
                'btn-outline-info'    => __( 'Blue', 'dina-kala' ),
                'btn-outline-primary' => __( 'Dark Blue', 'dina-kala' ),
                'btn-outline-warning' => __( 'Yellow', 'dina-kala' ),
                'btn-outline-success' => __( 'Green', 'dina-kala' ),
                'btn-outline-dark'    => __( 'Dark', 'dina-kala' ),
                'btn-outline-danger'  => __( 'Red', 'dina-kala' ),
                'btn-info'            => __( 'Solid Blue', 'dina-kala' ),
                'btn-primary'         => __( 'Solid Dark Blue', 'dina-kala' ),
                'btn-warning'         => __( 'Solid Yellow', 'dina-kala' ),
                'btn-success'         => __( 'Solid Green', 'dina-kala' ),
                'btn-dark'            => __( 'Solid Dark', 'dina-kala' ),
                'btn-danger'          => __( 'Solid Red', 'dina-kala' )
            ),
            'default'  => 'btn-outline-dina',
            'required' => array( 'second_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'second_add_prod_btn_size',
            'type'     => 'select',
            'title'    => __( 'Button size', 'dina-kala' ),
            'options'  => array(
                'btn-sm' => __( 'Small', 'dina-kala' ),
                'btn-md' => __( 'Medium', 'dina-kala' ),
                'btn-lg' => __( 'Large', 'dina-kala' )
            ),
            'default'  => 'btn-md',
            'required' => array( 'second_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'second_add_prod_btn_link',
            'type'     => 'text',
            'title'    => __( 'Second additional product button link', 'dina-kala' ),
            'desc'     => __( 'You can also use the shortcode. For example: [dina_title] = product title, [dina_short_link] = product short link, [dina_price] = product price</br>WhatsApp link example:</br><pre>https://api.whatsapp.com/send?phone=989123334444&text=[dina_title] - [dina_short_link]</pre>', 'dina-kala' ),
            'default'  => __( '#', 'dina-kala' ),
            'required' => array( 
                array( 'second_show_add_prod_btn', '=', true ),
                array( 'second_show_add_prod_popup', '!=', true ),
            )
        ),
        array(
            'id'      => 'second_add_prod_btn_link_target',
            'type'    => 'select',
            'title'   => __( 'Link Target', 'dina-kala' ),
            'options' => array(
                '_blank' => __( 'New Window', 'dina-kala' ),
                '_self'  => __( 'Same Window', 'dina-kala' ),
            ),
            'default'  => '_blank',
            'required' => array( 
                array( 'second_show_add_prod_btn', '=', true ),
                array( 'second_show_add_prod_popup', '!=', true ),
            )
        ),
        array(
            'id'       => 'second_add_prod_btn_link_nofollow',
            'type'     => 'switch',
            'title'    => __( 'Add nofollow property to link', 'dina-kala' ),
            'default'  => false,
            'required' => array( 
                array( 'second_show_add_prod_btn', '=', true ),
                array( 'second_show_add_prod_popup', '!=', true ),
            )
        ),
        array(
            'id'       => 'second_show_add_prod_popup',
            'type'     => 'switch',
            'title'    => __( 'Show pop-up by clicking the button', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'second_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'second_add_per_prod_popup',
            'type'     => 'switch',
            'title'    => __( 'Activate the ability to customize the title and content for each product', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'second_show_add_prod_popup', '=', true ),
        ),
        array(
            'id'       => 'second_add_cat_prod_popup',
            'type'     => 'switch',
            'title'    => __( 'Activate the ability to customize the title and content for each product category', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'second_show_add_prod_popup', '=', true ),
        ),
        array(
            'id'       => 'second_add_prod_popup_title',
            'type'     => 'text',
            'title'    => __( 'Pop-up title', 'dina-kala' ),
            'default'  => __( 'Title', 'dina-kala' ),
            'required' => array( 'second_show_add_prod_popup', '=', true ),
        ),
        array(
            'id'      => 'second_add_prod_popup_size',
            'type'    => 'select',
            'title'   => __( 'Pop-up size', 'dina-kala' ),
            'options' => array(
                'modal-sm' => __( 'Small', 'dina-kala' ),
                'modal-md' => __( 'Default', 'dina-kala' ),
                'modal-lg' => __( 'Larg', 'dina-kala' ),
            ),
            'default'  => 'modal-md',
            'required' => array( 'second_show_add_prod_popup', '=', true ),
        ),
        array(
            'id'      => 'second_add_prod_popup_text',
            'type'    => 'editor',
            'title'   => __( 'Pop-up content', 'dina-kala' ),
            'desc'    => __( 'You can also use the shortcode', 'dina-kala' ),
            'default' => __( 'Content', 'dina-kala' ),
            'args'    => array(
                'wpautop'       => true,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => false,
                'quicktags'     => true,
            ),
            'required' => array( 'second_show_add_prod_popup', '=', true ),
        ),
        array(
            'id'     => 'second-pbtn-section-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //second-pbtn-section-end

        //third-pbtn-section-start
        array(
            'id'     => 'third-pbtn-section-start',
            'type'   => 'section',
            'title'  => __( 'Third additional product button settings', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'      => 'third_show_add_prod_btn',
            'type'    => 'switch',
            'title'   => __( 'Display third additional button in product page', 'dina-kala' ),
            'default' => false,
        ),
        array(
            'id'       => 'third_show_add_prod_call',
            'type'     => 'switch',
            'title'    => __( 'Display third additional button in non-purchasable products', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'third_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'third_add_prod_btn_in_cats',
            'type'     => 'switch',
            'title'    => __( 'Display third additional button in specific categories', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'third_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'    => 'third_add_prod_btn_cats',
            'type'  => 'select',
            'ajax'     => true,
            'multi' => true,
            'title' => __( 'Categories', 'dina-kala' ),
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => array( 'product_cat' ),
                'hide_empty' => false,
            ),
            'required' => array( 'third_add_prod_btn_in_cats', '=', true )
        ),
        array(
            'id'       => 'third_add_prod_btn_not_cats',
            'type'     => 'switch',
            'title'    => __( 'Hide third additional button in specific categories', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'third_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'    => 'third_add_prod_btn_ncats',
            'type'  => 'select',
            'ajax'     => true,
            'multi' => true,
            'title' => __( 'Categories', 'dina-kala' ),
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => array( 'product_cat' ),
                'hide_empty' => false,
            ),
            'required' => array( 'third_add_prod_btn_not_cats', '=', true )
        ),
        array(
            'id'       => 'third_add_per_prod_link',
            'type'     => 'switch',
            'title'    => __( 'Activate the ability to customize the title and link for each product', 'dina-kala' ),
            'default'  => false,
            'required' => array( 
                array( 'third_show_add_prod_btn', '=', true ),
                array( 'third_show_add_prod_popup', '!=', true ),
            )
        ),
        array(
            'id'       => 'third_add_cat_prod_link',
            'type'     => 'switch',
            'title'    => __( 'Activate the ability to customize the title and link for each product category', 'dina-kala' ),
            'default'  => false,
            'required' => array( 
                array( 'third_show_add_prod_btn', '=', true ),
                array( 'third_show_add_prod_popup', '!=', true ),
            )
        ),
        array(
            'id'      => 'third_add_prod_btn_location',
            'type'    => 'select',
            'title'   => __( 'Button display location', 'dina-kala' ),
            'options' => array(
                'location1'  => __( 'Below are the product features', 'dina-kala' ),
                'location2'  => __( 'Next to the buy button', 'dina-kala' ),
            ),
            'default'  => 'location1',
            'required' => array( 'third_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'third_add_prod_btn_title',
            'type'     => 'text',
            'title'    => __( 'Third additional product button title', 'dina-kala' ),
            'default'  => __( 'Title', 'dina-kala' ),
            'required' => array( 'third_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'third_add_prod_btn_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Third additional product button icon', 'dina-kala' ),
            'default'  => 'fal fa-bell',
            'required' => array( 'third_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'      => 'third_add_prod_btn_color',
            'type'    => 'select',
            'title'   => __( 'Button color', 'dina-kala' ),
            'options' => array(
                'btn-outline-dina'    => __( 'Theme Color', 'dina-kala' ),
                'btn-outline-info'    => __( 'Blue', 'dina-kala' ),
                'btn-outline-primary' => __( 'Dark Blue', 'dina-kala' ),
                'btn-outline-warning' => __( 'Yellow', 'dina-kala' ),
                'btn-outline-success' => __( 'Green', 'dina-kala' ),
                'btn-outline-dark'    => __( 'Dark', 'dina-kala' ),
                'btn-outline-danger'  => __( 'Red', 'dina-kala' ),
                'btn-info'            => __( 'Solid Blue', 'dina-kala' ),
                'btn-primary'         => __( 'Solid Dark Blue', 'dina-kala' ),
                'btn-warning'         => __( 'Solid Yellow', 'dina-kala' ),
                'btn-success'         => __( 'Solid Green', 'dina-kala' ),
                'btn-dark'            => __( 'Solid Dark', 'dina-kala' ),
                'btn-danger'          => __( 'Solid Red', 'dina-kala' )
            ),
            'default'  => 'btn-outline-dina',
            'required' => array( 'third_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'third_add_prod_btn_size',
            'type'     => 'select',
            'title'    => __( 'Button size', 'dina-kala' ),
            'options'  => array(
                'btn-sm' => __( 'Small', 'dina-kala' ),
                'btn-md' => __( 'Medium', 'dina-kala' ),
                'btn-lg' => __( 'Large', 'dina-kala' )
            ),
            'default'  => 'btn-md',
            'required' => array( 'third_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'third_add_prod_btn_link',
            'type'     => 'text',
            'title'    => __( 'Third additional product button link', 'dina-kala' ),
            'desc'     => __( 'You can also use the shortcode. For example: [dina_title] = product title, [dina_short_link] = product short link, [dina_price] = product price</br>WhatsApp link example:</br><pre>https://api.whatsapp.com/send?phone=989123334444&text=[dina_title] - [dina_short_link]</pre>', 'dina-kala' ),
            'default'  => __( '#', 'dina-kala' ),
            'required' => array( 
                array( 'third_show_add_prod_btn', '=', true ),
                array( 'third_show_add_prod_popup', '!=', true ),
            )
        ),
        array(
            'id'      => 'third_add_prod_btn_link_target',
            'type'    => 'select',
            'title'   => __( 'Link Target', 'dina-kala' ),
            'options' => array(
                '_blank' => __( 'New Window', 'dina-kala' ),
                '_self'  => __( 'Same Window', 'dina-kala' ),
            ),
            'default'  => '_blank',
            'required' => array( 
                array( 'third_show_add_prod_btn', '=', true ),
                array( 'third_show_add_prod_popup', '!=', true ),
            )
        ),
        array(
            'id'       => 'third_add_prod_btn_link_nofollow',
            'type'     => 'switch',
            'title'    => __( 'Add nofollow property to link', 'dina-kala' ),
            'default'  => false,
            'required' => array( 
                array( 'third_show_add_prod_btn', '=', true ),
                array( 'third_show_add_prod_popup', '!=', true ),
            )
        ),
        array(
            'id'       => 'third_show_add_prod_popup',
            'type'     => 'switch',
            'title'    => __( 'Show pop-up by clicking the button', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'third_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'third_add_per_prod_popup',
            'type'     => 'switch',
            'title'    => __( 'Activate the ability to customize the title and content for each product', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'third_show_add_prod_popup', '=', true ),
        ),
        array(
            'id'       => 'third_add_cat_prod_popup',
            'type'     => 'switch',
            'title'    => __( 'Activate the ability to customize the title and content for each product category', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'third_show_add_prod_popup', '=', true ),
        ),
        array(
            'id'       => 'third_add_prod_popup_title',
            'type'     => 'text',
            'title'    => __( 'Pop-up title', 'dina-kala' ),
            'default'  => __( 'Title', 'dina-kala' ),
            'required' => array( 'third_show_add_prod_popup', '=', true ),
        ),
        array(
            'id'      => 'third_add_prod_popup_size',
            'type'    => 'select',
            'title'   => __( 'Pop-up size', 'dina-kala' ),
            'options' => array(
                'modal-sm' => __( 'Small', 'dina-kala' ),
                'modal-md' => __( 'Default', 'dina-kala' ),
                'modal-lg' => __( 'Larg', 'dina-kala' ),
            ),
            'default'  => 'modal-md',
            'required' => array( 'third_show_add_prod_popup', '=', true ),
        ),
        array(
            'id'      => 'third_add_prod_popup_text',
            'type'    => 'editor',
            'title'   => __( 'Pop-up content', 'dina-kala' ),
            'desc'    => __( 'You can also use the shortcode', 'dina-kala' ),
            'default' => __( 'Content', 'dina-kala' ),
            'args'    => array(
                'wpautop'       => true,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => false,
                'quicktags'     => true,
            ),
            'required' => array( 'third_show_add_prod_popup', '=', true ),
        ),
        array(
            'id'     => 'third-pbtn-section-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //third-pbtn-section-end

        //fourth-pbtn-section-start
        array(
            'id'     => 'fourth-pbtn-section-start',
            'type'   => 'section',
            'title'  => __( 'Fourth additional product button settings', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'      => 'fourth_show_add_prod_btn',
            'type'    => 'switch',
            'title'   => __( 'Display fourth additional button in product page', 'dina-kala' ),
            'default' => false,
        ),
        array(
            'id'       => 'fourth_show_add_prod_call',
            'type'     => 'switch',
            'title'    => __( 'Display fourth additional button in non-purchasable products', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'fourth_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'fourth_add_prod_btn_in_cats',
            'type'     => 'switch',
            'title'    => __( 'Display fourth additional button in specific categories', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'fourth_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'    => 'fourth_add_prod_btn_cats',
            'type'  => 'select',
            'ajax'     => true,
            'multi' => true,
            'title' => __( 'Categories', 'dina-kala' ),
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => array( 'product_cat' ),
                'hide_empty' => false,
            ),
            'required' => array( 'fourth_add_prod_btn_in_cats', '=', true )
        ),
        array(
            'id'       => 'fourth_add_prod_btn_not_cats',
            'type'     => 'switch',
            'title'    => __( 'Hide fourth additional button in specific categories', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'fourth_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'    => 'fourth_add_prod_btn_ncats',
            'type'  => 'select',
            'ajax'     => true,
            'multi' => true,
            'title' => __( 'Categories', 'dina-kala' ),
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => array( 'product_cat' ),
                'hide_empty' => false,
            ),
            'required' => array( 'fourth_add_prod_btn_not_cats', '=', true )
        ),
        array(
            'id'       => 'fourth_add_per_prod_link',
            'type'     => 'switch',
            'title'    => __( 'Activate the ability to customize the title and link for each product', 'dina-kala' ),
            'default'  => false,
            'required' => array( 
                array( 'fourth_show_add_prod_btn', '=', true ),
                array( 'fourth_show_add_prod_popup', '!=', true ),
            )
        ),
        array(
            'id'       => 'fourth_add_cat_prod_link',
            'type'     => 'switch',
            'title'    => __( 'Activate the ability to customize the title and link for each product category', 'dina-kala' ),
            'default'  => false,
            'required' => array( 
                array( 'fourth_show_add_prod_btn', '=', true ),
                array( 'fourth_show_add_prod_popup', '!=', true ),
            )
        ),
        array(
            'id'      => 'fourth_add_prod_btn_location',
            'type'    => 'select',
            'title'   => __( 'Button display location', 'dina-kala' ),
            'options' => array(
                'location1'  => __( 'Below are the product features', 'dina-kala' ),
                'location2'  => __( 'Next to the buy button', 'dina-kala' ),
            ),
            'default'  => 'location1',
            'required' => array( 'fourth_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'fourth_add_prod_btn_title',
            'type'     => 'text',
            'title'    => __( 'Fourth additional product button title', 'dina-kala' ),
            'default'  => __( 'Title', 'dina-kala' ),
            'required' => array( 'fourth_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'fourth_add_prod_btn_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Fourth additional product button icon', 'dina-kala' ),
            'default'  => 'fal fa-bell',
            'required' => array( 'fourth_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'      => 'fourth_add_prod_btn_color',
            'type'    => 'select',
            'title'   => __( 'Button color', 'dina-kala' ),
            'options' => array(
                'btn-outline-dina'    => __( 'Theme Color', 'dina-kala' ),
                'btn-outline-info'    => __( 'Blue', 'dina-kala' ),
                'btn-outline-primary' => __( 'Dark Blue', 'dina-kala' ),
                'btn-outline-warning' => __( 'Yellow', 'dina-kala' ),
                'btn-outline-success' => __( 'Green', 'dina-kala' ),
                'btn-outline-dark'    => __( 'Dark', 'dina-kala' ),
                'btn-outline-danger'  => __( 'Red', 'dina-kala' ),
                'btn-info'            => __( 'Solid Blue', 'dina-kala' ),
                'btn-primary'         => __( 'Solid Dark Blue', 'dina-kala' ),
                'btn-warning'         => __( 'Solid Yellow', 'dina-kala' ),
                'btn-success'         => __( 'Solid Green', 'dina-kala' ),
                'btn-dark'            => __( 'Solid Dark', 'dina-kala' ),
                'btn-danger'          => __( 'Solid Red', 'dina-kala' )
            ),
            'default'  => 'btn-outline-dina',
            'required' => array( 'fourth_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'fourth_add_prod_btn_size',
            'type'     => 'select',
            'title'    => __( 'Button size', 'dina-kala' ),
            'options'  => array(
                'btn-sm' => __( 'Small', 'dina-kala' ),
                'btn-md' => __( 'Medium', 'dina-kala' ),
                'btn-lg' => __( 'Large', 'dina-kala' )
            ),
            'default'  => 'btn-md',
            'required' => array( 'fourth_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'fourth_add_prod_btn_link',
            'type'     => 'text',
            'title'    => __( 'Fourth additional product button link', 'dina-kala' ),
            'desc'     => __( 'You can also use the shortcode. For example: [dina_title] = product title, [dina_short_link] = product short link, [dina_price] = product price</br>WhatsApp link example:</br><pre>https://api.whatsapp.com/send?phone=989123334444&text=[dina_title] - [dina_short_link]</pre>', 'dina-kala' ),
            'default'  => __( '#', 'dina-kala' ),
            'required' => array( 
                array( 'fourth_show_add_prod_btn', '=', true ),
                array( 'fourth_show_add_prod_popup', '!=', true ),
            )
        ),
        array(
            'id'      => 'fourth_add_prod_btn_link_target',
            'type'    => 'select',
            'title'   => __( 'Link Target', 'dina-kala' ),
            'options' => array(
                '_blank' => __( 'New Window', 'dina-kala' ),
                '_self'  => __( 'Same Window', 'dina-kala' ),
            ),
            'default'  => '_blank',
            'required' => array( 
                array( 'fourth_show_add_prod_btn', '=', true ),
                array( 'fourth_show_add_prod_popup', '!=', true ),
            )
        ),
        array(
            'id'       => 'fourth_add_prod_btn_link_nofollow',
            'type'     => 'switch',
            'title'    => __( 'Add nofollow property to link', 'dina-kala' ),
            'default'  => false,
            'required' => array( 
                array( 'fourth_show_add_prod_btn', '=', true ),
                array( 'fourth_show_add_prod_popup', '!=', true ),
            )
        ),
        array(
            'id'       => 'fourth_show_add_prod_popup',
            'type'     => 'switch',
            'title'    => __( 'Show pop-up by clicking the button', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'fourth_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'fourth_add_per_prod_popup',
            'type'     => 'switch',
            'title'    => __( 'Activate the ability to customize the title and content for each product', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'fourth_show_add_prod_popup', '=', true ),
        ),
        array(
            'id'       => 'fourth_add_cat_prod_popup',
            'type'     => 'switch',
            'title'    => __( 'Activate the ability to customize the title and content for each product category', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'fourth_show_add_prod_popup', '=', true ),
        ),
        array(
            'id'       => 'fourth_add_prod_popup_title',
            'type'     => 'text',
            'title'    => __( 'Pop-up title', 'dina-kala' ),
            'default'  => __( 'Title', 'dina-kala' ),
            'required' => array( 'fourth_show_add_prod_popup', '=', true ),
        ),
        array(
            'id'      => 'fourth_add_prod_popup_size',
            'type'    => 'select',
            'title'   => __( 'Pop-up size', 'dina-kala' ),
            'options' => array(
                'modal-sm' => __( 'Small', 'dina-kala' ),
                'modal-md' => __( 'Default', 'dina-kala' ),
                'modal-lg' => __( 'Larg', 'dina-kala' ),
            ),
            'default'  => 'modal-md',
            'required' => array( 'fourth_show_add_prod_popup', '=', true ),
        ),
        array(
            'id'      => 'fourth_add_prod_popup_text',
            'type'    => 'editor',
            'title'   => __( 'Pop-up content', 'dina-kala' ),
            'desc'    => __( 'You can also use the shortcode', 'dina-kala' ),
            'default' => __( 'Content', 'dina-kala' ),
            'args'    => array(
                'wpautop'       => true,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => false,
                'quicktags'     => true,
            ),
            'required' => array( 'fourth_show_add_prod_popup', '=', true ),
        ),
        array(
            'id'     => 'fourth-pbtn-section-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //fourth-pbtn-section-end

        //fifth-pbtn-section-start
        array(
            'id'     => 'fifth-pbtn-section-start',
            'type'   => 'section',
            'title'  => __( 'Fifth additional product button settings', 'dina-kala' ),
            'indent' => true,
        ),
        array(
            'id'      => 'fifth_show_add_prod_btn',
            'type'    => 'switch',
            'title'   => __( 'Display fifth additional button in product page', 'dina-kala' ),
            'default' => false,
        ),
        array(
            'id'       => 'fifth_show_add_prod_call',
            'type'     => 'switch',
            'title'    => __( 'Display fifth additional button in non-purchasable products', 'dina-kala' ),
            'default'  => true,
            'required' => array( 'fifth_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'fifth_add_prod_btn_in_cats',
            'type'     => 'switch',
            'title'    => __( 'Display fifth additional button in specific categories', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'fifth_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'    => 'fifth_add_prod_btn_cats',
            'type'  => 'select',
            'ajax'  => true,
            'multi' => true,
            'title' => __( 'Categories', 'dina-kala' ),
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => array( 'product_cat' ),
                'hide_empty' => false,
            ),
            'required' => array( 'fifth_add_prod_btn_in_cats', '=', true )
        ),
        array(
            'id'       => 'fifth_add_prod_btn_not_cats',
            'type'     => 'switch',
            'title'    => __( 'Hide fifth additional button in specific categories', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'fifth_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'    => 'fifth_add_prod_btn_ncats',
            'type'  => 'select',
            'ajax'  => true,
            'multi' => true,
            'title' => __( 'Categories', 'dina-kala' ),
            'data'  => 'terms',
            'args'  => array(
                'taxonomies' => array( 'product_cat' ),
                'hide_empty' => false,
            ),
            'required' => array( 'fifth_add_prod_btn_not_cats', '=', true )
        ),
        array(
            'id'       => 'fifth_add_per_prod_link',
            'type'     => 'switch',
            'title'    => __( 'Activate the ability to customize the title and link for each product', 'dina-kala' ),
            'default'  => false,
            'required' => array( 
                array( 'fifth_show_add_prod_btn', '=', true ),
                array( 'fifth_show_add_prod_popup', '!=', true ),
            )
        ),
        array(
            'id'       => 'fifth_add_cat_prod_link',
            'type'     => 'switch',
            'title'    => __( 'Activate the ability to customize the title and link for each product category', 'dina-kala' ),
            'default'  => false,
            'required' => array( 
                array( 'fifth_show_add_prod_btn', '=', true ),
                array( 'fifth_show_add_prod_popup', '!=', true ),
            )
        ),
        array(
            'id'      => 'fifth_add_prod_btn_location',
            'type'    => 'select',
            'title'   => __( 'Button display location', 'dina-kala' ),
            'options' => array(
                'location1' => __( 'Below are the product features', 'dina-kala' ),
                'location2' => __( 'Next to the buy button', 'dina-kala' ),
            ),
            'default'  => 'location1',
            'required' => array( 'fifth_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'fifth_add_prod_btn_title',
            'type'     => 'text',
            'title'    => __( 'Fifth additional product button title', 'dina-kala' ),
            'default'  => __( 'Title', 'dina-kala' ),
            'required' => array( 'fifth_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'fifth_add_prod_btn_icon',
            'type'     => 'dina_icon_picker',
            'title'    => __( 'Fifth additional product button icon', 'dina-kala' ),
            'default'  => 'fal fa-bell',
            'required' => array( 'fifth_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'      => 'fifth_add_prod_btn_color',
            'type'    => 'select',
            'title'   => __( 'Button color', 'dina-kala' ),
            'options' => array(
                'btn-outline-dina'    => __( 'Theme Color', 'dina-kala' ),
                'btn-outline-info'    => __( 'Blue', 'dina-kala' ),
                'btn-outline-primary' => __( 'Dark Blue', 'dina-kala' ),
                'btn-outline-warning' => __( 'Yellow', 'dina-kala' ),
                'btn-outline-success' => __( 'Green', 'dina-kala' ),
                'btn-outline-dark'    => __( 'Dark', 'dina-kala' ),
                'btn-outline-danger'  => __( 'Red', 'dina-kala' ),
                'btn-info'            => __( 'Solid Blue', 'dina-kala' ),
                'btn-primary'         => __( 'Solid Dark Blue', 'dina-kala' ),
                'btn-warning'         => __( 'Solid Yellow', 'dina-kala' ),
                'btn-success'         => __( 'Solid Green', 'dina-kala' ),
                'btn-dark'            => __( 'Solid Dark', 'dina-kala' ),
                'btn-danger'          => __( 'Solid Red', 'dina-kala' )
            ),
            'default'  => 'btn-outline-dina',
            'required' => array( 'fifth_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'fifth_add_prod_btn_size',
            'type'     => 'select',
            'title'    => __( 'Button size', 'dina-kala' ),
            'options'  => array(
                'btn-sm' => __( 'Small', 'dina-kala' ),
                'btn-md' => __( 'Medium', 'dina-kala' ),
                'btn-lg' => __( 'Large', 'dina-kala' )
            ),
            'default'  => 'btn-md',
            'required' => array( 'fifth_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'fifth_add_prod_btn_link',
            'type'     => 'text',
            'title'    => __( 'Fifth additional product button link', 'dina-kala' ),
            'desc'     => __( 'You can also use the shortcode. For example: [dina_title] = product title, [dina_short_link] = product short link, [dina_price] = product price</br>WhatsApp link example:</br><pre>https://api.whatsapp.com/send?phone=989123334444&text=[dina_title] - [dina_short_link]</pre>', 'dina-kala' ),
            'default'  => __( '#', 'dina-kala' ),
            'required' => array( 
                array( 'fifth_show_add_prod_btn', '=', true ),
                array( 'fifth_show_add_prod_popup', '!=', true ),
            )
        ),
        array(
            'id'      => 'fifth_add_prod_btn_link_target',
            'type'    => 'select',
            'title'   => __( 'Link Target', 'dina-kala' ),
            'options' => array(
                '_blank' => __( 'New Window', 'dina-kala' ),
                '_self'  => __( 'Same Window', 'dina-kala' ),
            ),
            'default'  => '_blank',
            'required' => array( 
                array( 'fifth_show_add_prod_btn', '=', true ),
                array( 'fifth_show_add_prod_popup', '!=', true ),
            )
        ),
        array(
            'id'       => 'fifth_add_prod_btn_link_nofollow',
            'type'     => 'switch',
            'title'    => __( 'Add nofollow property to link', 'dina-kala' ),
            'default'  => false,
            'required' => array( 
                array( 'fifth_show_add_prod_btn', '=', true ),
                array( 'fifth_show_add_prod_popup', '!=', true ),
            )
        ),
        array(
            'id'       => 'fifth_show_add_prod_popup',
            'type'     => 'switch',
            'title'    => __( 'Show pop-up by clicking the button', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'fifth_show_add_prod_btn', '=', true ),
        ),
        array(
            'id'       => 'fifth_add_per_prod_popup',
            'type'     => 'switch',
            'title'    => __( 'Activate the ability to customize the title and content for each product', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'fifth_show_add_prod_popup', '=', true ),
        ),
        array(
            'id'       => 'fifth_add_cat_prod_popup',
            'type'     => 'switch',
            'title'    => __( 'Activate the ability to customize the title and content for each product category', 'dina-kala' ),
            'default'  => false,
            'required' => array( 'fifth_show_add_prod_popup', '=', true ),
        ),
        array(
            'id'       => 'fifth_add_prod_popup_title',
            'type'     => 'text',
            'title'    => __( 'Pop-up title', 'dina-kala' ),
            'default'  => __( 'Title', 'dina-kala' ),
            'required' => array( 'fifth_show_add_prod_popup', '=', true ),
        ),
        array(
            'id'      => 'fifth_add_prod_popup_size',
            'type'    => 'select',
            'title'   => __( 'Pop-up size', 'dina-kala' ),
            'options' => array(
                'modal-sm' => __( 'Small', 'dina-kala' ),
                'modal-md' => __( 'Default', 'dina-kala' ),
                'modal-lg' => __( 'Larg', 'dina-kala' ),
            ),
            'default'  => 'modal-md',
            'required' => array( 'fifth_show_add_prod_popup', '=', true ),
        ),
        array(
            'id'      => 'fifth_add_prod_popup_text',
            'type'    => 'editor',
            'title'   => __( 'Pop-up content', 'dina-kala' ),
            'desc'    => __( 'You can also use the shortcode', 'dina-kala' ),
            'default' => __( 'Content', 'dina-kala' ),
            'args'    => array(
                'wpautop'       => true,
                'media_buttons' => true,
                'textarea_rows' => 5,
                'teeny'         => false,
                'quicktags'     => true,
            ),
            'required' => array( 'fifth_show_add_prod_popup', '=', true ),
        ),
        array(
            'id'     => 'fifth-pbtn-section-end',
            'type'   => 'section',
            'indent' => false,
        ),
        //fifth-pbtn-section-end
    ),
) );