<?php
/**
 * Province City Selector Field for Redux Framework
 *
 * @package     Redux Framework/Fields
 * @author      Meysam Hosseinkhani
 * @version     1.0.1
 */

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Redux_Dina_Province_City_Selector', false ) ) {

    class Redux_Dina_Province_City_Selector extends Redux_Field {

        public function __construct( $field = array(), $value = '', $parent = null ) {
            parent::__construct( $field, $value, $parent );

            $this->field  = $field;
            $this->parent = $parent;

            if ( empty( $value ) && ! empty( $this->field['default'] ) ) {
                $this->value = json_encode( $this->field['default'], JSON_UNESCAPED_UNICODE );
            } else {
                $this->value = is_string( $value ) ? $value : json_encode( $value, JSON_UNESCAPED_UNICODE );
            }
        }

        public function render() {
            echo '<div class="dina-province-city-wrapper">';

            echo '<div class="dina-select-row">';
            echo '<select class="dina-province-select"><option value="">' . esc_html__( 'Select province', 'dina-kala' ) . '</option></select>';
            echo '<select class="dina-city-select" disabled><option value="">' . esc_html__( 'Select city', 'dina-kala' ) . '</option></select>';
            echo '<button type="button" class="dina-add-city button">' . esc_html__( 'Add city', 'dina-kala' ) . '</button>';
            echo '</div>';

            echo '<ul class="dina-city-list"></ul>';

            echo '<input type="hidden" name="' . esc_attr( $this->field['name'] ) . '" value="' . esc_attr( $this->value ) . '" class="dina-redux-province-city-json" />';
            echo '</div>';
        }

        public function enqueue() {
            wp_enqueue_script(
                'dina-province-city-selector-js',
                DI_URI . '/includes/admin-panel/dina-province-city-selector/assets/dina-province-city-selector.js',
                array( 'jquery' ),
                time(),
                true
            );

            wp_enqueue_style(
                'dina-province-city-selector-css',
                DI_URI . '/includes/admin-panel/dina-province-city-selector/assets/dina-province-city-selector.css',
                array(),
                time()
            );

            wp_localize_script(
                'dina-province-city-selector-js',
                'dinaProvinceCityData',
                array(
                    'data'      => json_decode( file_get_contents( DI_DIR . '/includes/admin-panel/dina-province-city-selector/assets/iran_provinces_cities.json' ), true ),
                    'direction' => is_rtl() ? 'rtl' : 'ltr',
                    'i18n'      => array(
                        'selectprovince' => esc_html__( 'Select province', 'dina-kala' ),
                        'noresult'       => esc_html__( 'No results found.', 'dina-kala' ),
                        'selectcity'     => esc_html__( 'Select city', 'dina-kala' ),
                        'delete'         => esc_html__( 'Delete', 'dina-kala' ),
                    )
                )
            );
        }
    }

    class_alias( 'Redux_Dina_Province_City_Selector', 'ReduxFramework_dina_province_city_selector' );
}
