<?php
/**
 * Icon Picker Field for Redux Framework
 *
 * @package     Redux Framework/Fields
 * @author      Meysam Hosseinkhani
 * @version     1.0.0
 */

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Redux_Dina_Icon_Picker', false ) ) {

	class Redux_Dina_Icon_Picker extends Redux_Field {

		public function __construct( $field = array(), $value = '', $parent = null ) {
			parent::__construct( $field, $value, $parent );
		}
		
		public function render() {
			$field_id = esc_attr( $this->field['id'] );
			$value    = esc_attr( $this->value );

			echo '<div class="dina-icon-picker-field" id="dina-icon-picker-' . $field_id . '">';
			echo '<input type="hidden" id="' . $field_id . '" name="' . $this->field['name'] . $this->field['name_suffix'] . '" value="' . $value . '" />';
			echo '<div class="dina-icon-preview"><i class="' . $value . '"></i></div>';
			echo '<button type="button" class="dina-icon-picker-trigger button">' . esc_html__( 'Select icon', 'dina-kala' ) . '</button>';
			echo '</div>';
		}

		/**
		 * Output variables (optional for this field).
		 */
		public function output_variables() {
			// Optional - used when your field affects front-end CSS variables.
		}
	}

	// Class alias for backward compatibility (if needed)
	class_alias( 'Redux_Dina_Icon_Picker', 'ReduxFramework_dina_icon_picker' );
}