<?php
/**
 * ReduxFramework admin-panel Config File
 * For full documentation, please visit: http://docs.reduxframework.com/
*/

if ( ! class_exists( 'Redux' ) ) {
    return;
}

// This is your option name where all the Redux data is stored.
$opt_name = "di_data";

//Redux's constants
define ( 'RE_URI' , DI_URI . '/includes/ReduxCore/' );
define ( 'RE_DIR' , DI_DIR . '/includes/ReduxCore/' );

// Background Patterns Reader
$background_patterns_path = RE_DIR . 'assets/img/patterns/';
$background_patterns_url  = RE_URI . 'assets/img/patterns/';
$background_patterns      = array();

if ( is_dir( $background_patterns_path ) ) {

    if ( $background_patterns_dir = opendir( $background_patterns_path ) ) {
        $background_patterns = array();

        while ( ( $background_patterns_file = readdir( $background_patterns_dir ) ) !== false ) {

            if ( stristr( $background_patterns_file, '.png' ) !== false || stristr( $background_patterns_file, '.jpg' ) !== false ) {
                $name              = explode( '.', $background_patterns_file );
                $name              = str_replace( '.' . end( $name ), '', $background_patterns_file );
                $background_patterns[] = array(
                    'alt' => $name,
                    'img' => $background_patterns_url . $background_patterns_file
                );
            }
        }
    }
}

//Footer Background Patterns Reader
$footer_patterns_path = RE_DIR . 'assets/img/fbg/';
$footer_patterns_url  = RE_URI . 'assets/img/fbg/';
$footer_patterns      = array();

if ( is_dir( $footer_patterns_path ) ) {

    if ( $footer_patterns_dir = opendir( $footer_patterns_path ) ) {
        $footer_patterns = array();

        while ( ( $footer_patterns_file = readdir( $footer_patterns_dir ) ) !== false ) {

            if ( stristr( $footer_patterns_file, '.png' ) !== false || stristr( $footer_patterns_file, '.jpg' ) !== false ) {
                $name              = explode( '.', $footer_patterns_file );
                $name              = str_replace( '.' . end( $name ), '', $footer_patterns_file );
                $footer_patterns[] = array(
                    'alt' => 'image-'. $name,
                    'img' => $footer_patterns_url . $footer_patterns_file
                );
            }
        }
    }
}

// Footer Seprator SVGs Reader
$seprator_folder  = DI_DIR . '/includes/admin-panel/assets/shapes/';
$seprator_url     = DI_URI . '/includes/admin-panel/assets/shapes/';
$seprator_options = array();

if ( is_dir( $seprator_folder ) ) {
    $files = scandir( $seprator_folder );
    foreach ( $files as $file ) {
        if ( pathinfo( $file, PATHINFO_EXTENSION ) === 'svg' ) {
            $key = pathinfo( $file, PATHINFO_FILENAME );
            $seprator_options[ $key ] = array(
                'alt' => ucfirst( str_replace('-', ' ', $key) ),
                'img' => $seprator_url . $file,
            );
        }
    }
}

$col_number = [];
foreach( range(1, 100) as $number )
{
    $col_number[$number] = $number;
}

//Dina product attributes array
if ( ! function_exists( 'dina_product_attributes_array' ) ) {
    function dina_product_attributes_array() {

        if ( ! function_exists( 'wc_get_attribute_taxonomies' ) ) {
            return;
        }
        $attributes = array();

        foreach ( wc_get_attribute_taxonomies() as $attribute ) {
            $attributes[ 'pa_' . $attribute->attribute_name ] = $attribute->attribute_label;
        }

        return $attributes;
    }
}

// SET ARGUMENTS

$theme = wp_get_theme(); // For use with some settings. Not necessary.

$args = array(
    'opt_name'             => $opt_name,
    'display_name'         => $theme->get( 'Name' ),
    'display_version'      => $theme->get( 'Version' ),
    'menu_type'            => 'submenu',
    'allow_sub_menu'       => true,
    'menu_title'           => __( 'Theme Settings', 'dina-kala' ),
    'page_title'           => __( 'Theme Settings', 'dina-kala' ),
    'google_api_key'       => '',
    'google_update_weekly' => false,
    'async_typography'     => true,
    'admin_bar'            => true,
    'admin_bar_icon'       => 'dashicons-admin-generic',
    'admin_bar_priority'   => 50,
    'global_variable'      => '',
    'dev_mode'             => true,
    'text_domain'          => 'dina-kala',
    'update_notice'        => true,
    'customizer'           => true,
    'page_priority'        => null,
    'page_parent'          => 'themes.php',
    'page_permissions'     => 'manage_options',
    'menu_icon'            => '',
    'last_tab'             => '',
    'page_icon'            => 'icon-themes',
    'page_slug'            => '',
    'save_defaults'        => true,
    'default_show'         => false,
    'default_mark'         => '',
    'show_import_export'   => true,
    'transient_time'       => 60 * MINUTE_IN_SECONDS,
    'output'               => true,
    'output_tag'           => true,
    'database'             => '',
    'use_cdn'              => false,
    'forced_dev_mode_off' => true,
    'show_options_object' => false,
    'hints'                => array(
        'icon'          => 'fal fa-question-circle',
        'icon_position' => 'right',
        'icon_color'    => 'lightgray',
        'icon_size'     => 'normal',
        'tip_style'     => array(
            'color'   => 'red',
            'shadow'  => true,
            'rounded' => false,
            'style'   => '',
        ),
        'tip_position'  => array(
            'my' => 'top left',
            'at' => 'bottom right',
        ),
        'tip_effect'    => array(
            'show' => array(
                'effect'   => 'slide',
                'duration' => '500',
                'event'    => 'mouseover',
            ),
            'hide' => array(
                'effect'   => 'slide',
                'duration' => '500',
                'event'    => 'click mouseleave',
            ),
        ),
    ),
    'admin_theme'               => 'wp',
    'flyout_submenus'           => true,
    'font_display'              => 'swap',
    'database'                  => '',
    'network_admin'             => true,
    'search'                    => true,
    'disable_google_fonts_link' => true
);


// Panel Intro text -> before the form
if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
    if ( ! empty( $args['global_variable'] ) ) {
        $v = $args['global_variable'];
    } else {
        $v = str_replace( '-', '_', $args['opt_name'] );
    }
    $args['intro_text'] = '';
} else {
    $args['intro_text'] = '';
}

// Add content after the form.
$args['footer_text'] = '';

Redux::setArgs( $opt_name, $args );
// END ARGUMENTS

// dina_enqueue_admin_panel_assets
function dina_enqueue_admin_panel_assets( $hook ) {

    if ( strpos( $hook, 'appearance_page_' ) !== false ) {

        if ( is_rtl() ) {
            wp_enqueue_style( 'dina-jalalidatepicker-style', DI_URI . '/includes/admin-panel/assets/jalalidatepicker.min.css' );
            wp_enqueue_script( 'dina-jalalidatepicker-script', DI_URI . '/includes/admin-panel/assets/jalalidatepicker.min.js', array( 'jquery' ), DI_VER, true );
        } else {
            wp_enqueue_script( 'dina-gregoriandatepicker-script', DI_URI . '/includes/admin-panel/assets/gregoriandatepicker.min.js', array( 'jquery' ), DI_VER, true );
            wp_enqueue_style( 'dina-jalalidatepicker-style', DI_URI . '/includes/admin-panel/assets/gregoriandatepicker.min.css' );
        }

        wp_enqueue_style( 'dina-icon-picker-style', DI_URI . '/includes/admin-panel/dina-icon-picker/assets/icon-picker.css' );
        wp_enqueue_script( 'dina-icon-picker-script', DI_URI . '/includes/admin-panel/dina-icon-picker/assets/icon-picker.js', array( 'jquery' ), DI_VER, true );

        wp_localize_script( 'dina-icon-picker-script', 'dinaIconPicker', array(
            'ajaxurl' => admin_url( 'admin-ajax.php' ),
            'i18n' => array(
                'selectIcon' => __( 'Select icon', 'dina-kala' ),
                'loading'    => __( 'Loading...', 'dina-kala' ),
                'close'      => __( 'Close', 'dina-kala' ),
                'search'     => __( 'Search icon...', 'dina-kala' ),
            )
        ) );
    }
}
add_action( 'admin_enqueue_scripts', 'dina_enqueue_admin_panel_assets' );

// Add icon picker filed
add_filter( 'redux/'. $opt_name .'/field/class/dina_icon_picker', function( $class ) {
    return DI_DIR . '/includes/admin-panel/dina-icon-picker/dina_icon_picker.php';
});

// Add weekly time ranges
add_filter( 'redux/'. $opt_name .'/field/class/dina_weekly_time_ranges', function( $class ) {
    return DI_DIR . '/includes/admin-panel/dina-weekly-time-ranges/dina_weekly_time_ranges.php';
});

// Add province city selector
add_filter( 'redux/'. $opt_name .'/field/class/dina_province_city_selector', function( $class ) {
    return DI_DIR . '/includes/admin-panel/dina-province-city-selector/dina_province_city_selector.php';
});

add_filter( 'redux/'. $opt_name .'fields/ace/script', 'dina_force_local_ace_editor_url' );
function dina_force_local_ace_editor_url( $url ) {
    return DI_URI . '/includes/admin-panel/assets/ace/ace.min.js';
}

// dina_load_fontawesome_icons_callback
add_action( 'wp_ajax_load_fontawesome_icons', 'dina_load_fontawesome_icons_callback' );
function dina_load_fontawesome_icons_callback() {
    $json_file = DI_DIR . '/includes/admin-panel/dina-icon-picker/assets/fa-icons.json';
    if ( file_exists( $json_file ) ) {
        $json_data = file_get_contents( $json_file );
        $options   = json_decode( $json_data, true );
        wp_send_json( $options );
    } else {
        wp_send_json_error( __( 'Icons file not found.', 'dina-kala' ) );
    }
}

// START HELP TABS
$tabs = array(
    array(
        'id'      => 'dinakala-help-tab',
        'title'   => __( 'Template guide', 'dina-kala' ),
        'content' => __( 'If you have questions about working with the template, contact meysam98@gmail.com.', 'dina-kala' )
    ),
);
Redux::set_help_tab( $opt_name, $tabs );
//END HELP TABS


// START SECTIONS

// Home settings
require_once DI_DIR . '/includes/admin-panel/home-settings.php';

// General settings
require_once DI_DIR . '/includes/admin-panel/general-settings.php';

// Product Settings
require_once DI_DIR . '/includes/admin-panel/product-settings.php';

// Woocommerce Settings
require_once DI_DIR . '/includes/admin-panel/woocommerce-settings.php';

// Dokan Settings
require_once DI_DIR . '/includes/admin-panel/dokan-settings.php';

// User panel settings
require_once DI_DIR . '/includes/admin-panel/user-panel-settings.php';

// Product brand settings
require_once DI_DIR . '/includes/admin-panel/brand-settings.php';

// Comment Settings
require_once DI_DIR . '/includes/admin-panel/comment-settings.php';

// Dokan settings
require_once DI_DIR . '/includes/admin-panel/post-settings.php';

// Page settings
require_once DI_DIR . '/includes/admin-panel/page-settings.php';

// Popup settings
require_once DI_DIR . '/includes/admin-panel/popup-settings.php';

// Social Media
require_once DI_DIR . '/includes/admin-panel/social-media.php';

// Custom Codes
require_once DI_DIR . '/includes/admin-panel/custom-codes.php';

// Dinakala guide
require_once DI_DIR . '/includes/admin-panel/dinakala-guide.php';

// END SECTIONS

// If Redux is running as a plugin, this will remove the demo notice and links
add_action( 'redux/loaded', 'dina_remove_demo' );
if ( ! function_exists( 'dina_remove_demo' ) ) {
    function dina_remove_demo() {
        // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
        if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
            remove_filter( 'plugin_row_meta', array(
                ReduxFrameworkPlugin::instance(),
                'plugin_metalinks'
            ), null, 2 );

            // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
            remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
        }
    }
}

function removeDemoModeLink() { // Be sure to rename this function to something more unique
    if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
        remove_filter( 'plugin_row_meta', array( ReduxFrameworkPlugin::get_instance(), 'plugin_metalinks' ), null, 2 );
    }
    if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
        remove_action( 'admin_notices', array( ReduxFrameworkPlugin::get_instance(), 'admin_notices' ) );    
    }
}
add_action( 'init', 'removeDemoModeLink' );

// dina_admin_info
function dina_admin_info( $text = null, $link = null, $color = 'success' )
{
    $text = empty ( $text ) ? __( 'View the training documentation of this section of the settings', 'dina-kala' ) : $text;
    ob_start();
    ?>
    <div class="dina-admin-info dina-alert dina-alert-<?= $color ?>">
        <?php if ( ! empty( $link ) ) { ?>
            <a href=<?= $link ?> target="_blank">
        <?php } ?>
            <i class="fal fa-question-circle"></i>
            <?= $text ?>
        <?php if ( ! empty( $link ) ) { ?>
            </a>
        <?php } ?>
    </div>
    <?php
    $info = ob_get_clean();
    return $info;
}