<?php

// Exit if accessed directly
if (!defined('ABSPATH') ) {
    exit;
}

global $di_data; ?>

<header class="site-header<?php if( !is_front_page() && ( ! $di_data['show_bread'] || ! $di_data['show_bread_mobile'] ) ) { echo ' no-bread'; }  ?>" <?php if ( $di_data['site_schema'] ) {?>itemscope itemtype="https://schema.org/Organization" <?php } ?>>
       <?php if( $di_data['site_schema'] ) { 
        echo '<meta itemprop="url" content="'. esc_url( home_url() ) .'">';
        echo '<meta itemprop="name" content="'. esc_html( get_bloginfo('name') ) .'">';
        } ?>
    <!-- Header Div -->
        <div class="container-fluid dina-header header">
            <div class="container<?php if( $di_data['fixed_head_mobile'] ) { echo ' fixed-mobile'; } ?>">
                
                <?php if(!$di_data['hide_top_bar'] ) { ?>
                <div class="row head-mc<?php if ( $di_data['head_pos'] == 2) {echo ' left-head'; } ?>">

                    <!-- Header Menu -->
                    <nav class="col-md-6 head-menu<?php if ( $di_data['mobile_head_menu'] ) {echo ' visible-mobile';} ?>" <?php if( $di_data['site_schema'] ) {?>itemscope itemtype="https://schema.org/SiteNavigationElement" <?php } ?>>
                        <?php
                        if (has_nav_menu('header') ) {
                            wp_nav_menu( array(
                                'menu'              => 'header',
                                'theme_location'    => 'header',
                                'depth'             => 1,
                                'container'         => 'div'
                                )
                            );
                        }
                        ?>
                    </nav>
                    <!-- Header Menu -->
                    
                    <?php if( $di_data['show_contact'] && !$di_data['show_head_social'] ) { ?>
                    <!-- Header Contact -->
                    <div class="col-md-6 head-contact">
                        <div class="head-phone" <?php if( $di_data['site_schema'] ) {?>itemprop="telephone"<?php } ?>>
                            <a href="tel:<?php echo dina_remove_dash($di_data['site_tel'] ); ?>" target="_blank">
                                <i class="fal fa-phone" aria-hidden="true"></i>
                                <?php echo $di_data['site_tel']; ?>
                            </a>
                        </div>
                        <?php if( $di_data['replace_email'] ) { ?>
                            <div class="head-phone" <?php if( $di_data['site_schema'] ) {?>itemprop="telephone"<?php } ?>>
                                <a href="tel:<?php echo dina_remove_dash($di_data['site_tel2'] ); ?>" target="_blank">
                                    <i class="fal fa-phone-rotary" aria-hidden="true"></i>
                                    <?php echo $di_data['site_tel2']; ?>
                                </a>
                            </div>
                        <?php } else { ?>
                            <div class="head-email" <?php if( $di_data['site_schema'] ) {?>itemprop="email"<?php } ?>>
                                <a href="mailto:<?php echo $di_data['site_email']; ?>" target="_blank">
                                    <i class="fal fa-envelope" aria-hidden="true"></i>
                                    <?php echo $di_data['site_email']; ?>
                                </a>
                            </div>
                        <?php } ?>
                    </div>
                    <!-- Header Contact -->
                    <?php } ?>

                    <?php if( $di_data['show_head_social'] ) { ?>
                    <!-- Header Social -->
                    <div class="col-md-6 head-social">
                        <ul class="head-social-ul">
                            <?php if( $di_data['so_twitter'] ) { ?>
                            <li>
                                <a <?php if( $di_data['site_schema'] ) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_twitter_link']; ?>" title="<?php _e( 'Twitter', 'dina-kala' ); ?>" target="_blank">
                                    <i class="fab fa-twitter"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if( $di_data['so_facebook'] ) { ?>
                            <li>
                                <a <?php if( $di_data['site_schema'] ) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_facebook_link']; ?>" title="<?php _e( 'Facebook', 'dina-kala' ); ?>" target="_blank">
                                    <i class="fab fa-facebook-f"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if( $di_data['so_google'] ) { ?>
                            <li>
                                <a <?php if( $di_data['site_schema'] ) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_google_link']; ?>" title="<?php _e( 'Google+', 'dina-kala' ); ?>" target="_blank">
                                    <i class="fab fa-google-plus-g"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if( $di_data['so_whatsapp'] ) { ?>
                            <li>
                                <a <?php if( $di_data['site_schema'] ) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_whatsapp_link']; ?>" title="<?php _e( 'Whatsapp', 'dina-kala' ); ?>" target="_blank">
                                    <i class="fab fa-whatsapp"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if( $di_data['so_tiktok'] ) { ?>
                            <li>
                                <a <?php if( $di_data['site_schema'] ) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_tiktok_link']; ?>" title="<?php _e( 'Tiktok', 'dina-kala' ); ?>" target="_blank">
                                    <i class="fab fa-tiktok"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if( $di_data['so_telegram'] ) { ?>
                            <li>
                                <a <?php if( $di_data['site_schema'] ) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_telegram_link']; ?>" title="<?php _e( 'Telegram', 'dina-kala' ); ?>" target="_blank">
                                    <i class="fab fa-telegram-plane"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if( $di_data['so_instagram'] ) { ?>
                            <li>
                                <a <?php if( $di_data['site_schema'] ) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_instagram_link']; ?>" title="<?php _e( 'Instagram', 'dina-kala' ); ?>" target="_blank">
                                    <i class="fab fa-instagram"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if( $di_data['so_youtube'] ) { ?>
                            <li>
                                <a <?php if( $di_data['site_schema'] ) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_youtube_link']; ?>" title="<?php _e( 'Youtube', 'dina-kala' ); ?>" target="_blank">
                                    <i class="fab fa-youtube"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if( $di_data['so_linkedin'] ) { ?>
                            <li>
                                <a <?php if( $di_data['site_schema'] ) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_linkedin_link']; ?>" title="<?php _e( 'Linkedin', 'dina-kala' ); ?>" target="_blank">
                                    <i class="fab fa-linkedin-in"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if( $di_data['so_dribble'] ) { ?>
                            <li>
                                <a <?php if( $di_data['site_schema'] ) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_dribble_link']; ?>" title="<?php _e( 'Dribble', 'dina-kala' ); ?>" target="_blank">
                                    <i class="fab fa-dribbble"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if( $di_data['so_behance'] ) { ?>
                            <li>
                                <a <?php if( $di_data['site_schema'] ) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_behance_link']; ?>" title="<?php _e( 'Behance', 'dina-kala' ); ?>" target="_blank">
                                    <i class="fab fa-behance"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if( $di_data['so_pinterest'] ) { ?>
                            <li>
                                <a <?php if( $di_data['site_schema'] ) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_pinterest_link']; ?>" title="<?php _e( 'Pinterest', 'dina-kala' ); ?>" target="_blank">
                                    <i class="fab fa-pinterest-p"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if( $di_data['so_aparat'] ) { ?>
                            <li>
                                <a <?php if( $di_data['site_schema'] ) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_aparat_link']; ?>" title="<?php _e('Aparat', 'dina-kala'); ?>" target="_blank">
                                    <i class="dico ico-aparat"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if( $di_data['so_soroush'] ) { ?>
                            <li>
                                <a <?php if( $di_data['site_schema'] ) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_soroush_link']; ?>" title="<?php _e('Soroush', 'dina-kala'); ?>" target="_blank">
                                    <i class="dico ico-Soroush"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if( $di_data['so_gap'] ) { ?>
                            <li>
                                <a <?php if( $di_data['site_schema'] ) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_gap_link']; ?>" title="<?php _e('Gap', 'dina-kala'); ?>" target="_blank">
                                    <i class="dico ico-Gap"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if( $di_data['so_eitaa'] ) { ?>
                            <li>
                                <a <?php if( $di_data['site_schema'] ) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_eitaa_link']; ?>" title="<?php _e('Eitaa', 'dina-kala'); ?>" target="_blank">
                                    <i class="dico ico-Eitaa"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if( $di_data['so_bisphone'] ) { ?>
                            <li>
                                <a <?php if( $di_data['site_schema'] ) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_bisphone_link']; ?>" title="<?php _e('Bisphone', 'dina-kala'); ?>" target="_blank">
                                    <i class="dico ico-Bisphone"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if( $di_data['so_bale'] ) { ?>
                            <li>
                                <a <?php if( $di_data['site_schema'] ) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_bale_link']; ?>" title="<?php _e('Bale', 'dina-kala'); ?>" target="_blank">
                                    <i class="dico ico-Bale"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if( $di_data['so_igap'] ) { ?>
                            <li>
                                <a <?php if( $di_data['site_schema'] ) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_igap_link']; ?>" title="<?php _e('iGap', 'dina-kala'); ?>" target="_blank">
                                    <i class="dico ico-iGap"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if( $di_data['so_rubika'] ) { ?>
                            <li>
                                <a <?php if( $di_data['site_schema'] ) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_rubika_link']; ?>" title="<?php _e('Rubika', 'dina-kala'); ?>" target="_blank">
                                    <i class="dico ico-rubika"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if( $di_data['so_hoorsa'] ) { ?>
                            <li>
                                <a <?php if( $di_data['site_schema'] ) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_hoorsa_link']; ?>" title="<?php _e('Hoorsa', 'dina-kala'); ?>" target="_blank">
                                    <i class="dico ico-hoorsa"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if( $di_data['so_phone'] ) { ?>
                            <li>
                                <a <?php if( $di_data['site_schema'] ) {?>itemprop="sameAs" <?php } ?> href="tel:<?php echo dina_remove_dash($di_data['so_phone_link'] ); ?>" title="<?php _e('Phone', 'dina-kala'); ?>" target="_blank">
                                    <i class="fal fa-phone" aria-hidden="true"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if( $di_data['so_mobile'] ) { ?>
                            <li>
                                <a <?php if( $di_data['site_schema'] ) {?>itemprop="sameAs" <?php } ?> href="tel:<?php echo dina_remove_dash($di_data['so_mobile_link'] ); ?>" title="<?php _e('Mobile', 'dina-kala'); ?>" target="_blank">
                                    <i class="fal fa-mobile-alt" aria-hidden="true"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if( $di_data['so_email'] ) { ?>
                            <li>
                                <a <?php if( $di_data['site_schema'] ) {?>itemprop="sameAs" <?php } ?> href="mailto:<?php echo $di_data['so_email_link']; ?>" title="<?php _e('Email', 'dina-kala'); ?>" target="_blank">
                                    <i class="fal fa-at" aria-hidden="true"></i>
                                </a>
                            </li>
                            <?php } ?>
                        </ul>
                    </div>
                    <!-- Header Social -->
                    <?php } ?>

                </div>
                <?php } ?>

                <div class="row logo-box<?php if ( $di_data['logo_pos'] == 2) {echo ' left-logo'; } if ( $di_data['mobile_logo_pos'] == 1) {echo ' mobile-right-logo'; } elseif ( $di_data['mobile_logo_pos'] == 3) {echo ' mobile-middle-logo'; } ?>">

                        <div class="<?php echo $di_data['mobile_logo_pos'] == 3 ? 'col-3' : 'col-6'; ?> mobile-btns">
                            <?php if ( $di_data['mobile_logo_pos'] != 3) { ?>
                                <?php if ( ! $di_data['ch_menu_cart'] ) { ?>
                                    <span class="btn btn-light mmenu" onclick="openNav()">
                                        <i aria-hidden="true" class="fal fa-bars"></i>
                                    </span>
                                <?php } elseif ( class_exists( 'WooCommerce' ) ) { ?>
                                    <span class="btn btn-light mobile-header-cart" onclick="openCart()">
                                        <span aria-hidden="true" class="fal fa-shopping-bag ">
                                            <span class="cart-amount"><?php echo WC()->cart->get_cart_contents_count(); ?></span>
                                        </span>
                                    </span>
                                <?php } ?>
                            <?php } ?>
                            <?php if( $di_data['show_user_btn'] ) { ?>
                            <?php if( ! is_user_logged_in() ) { ?>
                                <?php
                                if ( $di_data['replace_userbtns_shortcode'] ) { 
                                    echo do_shortcode( $di_data['userbtns_shortcode'] );
                                } elseif (function_exists('digits_version') && $di_data['digits_mode'] ) {
                                    $digits_mode = ( $di_data['digits_page'] ? 'digitlink' : 'digitpopup' ); ?>
                                    <span title="<?php _e('Login Or Register', 'dina-kala'); ?>" class="btn btn-light mlogin digitsbtn <?php echo $digits_mode; ?>">
                                        <i aria-hidden="true" class="fal fa-user"></i>
                                        /
                                        <i aria-hidden="true" class="fal fa-user-plus"></i>
                                    </span>
                                <?php } elseif( $di_data['merge_user_btn'] ) { ?>
                                    <a title="<?php _e('Login Or Register', 'dina-kala'); ?>" class="btn btn-light mlogin mergedbtn" <?php if( $di_data['ch_login_link'] ) {echo 'href="'.$di_data['login_link'].'"'; } else {echo 'href="' . esc_url( dina_myaccount_link() ) .'"'; } ?>>
                                        <i aria-hidden="true" class="fal fa-user"></i>
                                        /
                                        <i aria-hidden="true" class="fal fa-user-plus"></i>
                                    </a>
                                <?php } else { ?>
                                <a title="<?php _e('Login', 'dina-kala'); ?>" <?php if( $di_data['ch_login_link'] ) {echo 'href="'.$di_data['login_link'].'"'; } else {echo 'href="#" onclick="openLogin()"';} ?>
                                    class="btn btn-light mlogin">
                                    <i aria-hidden="true" class="fal fa-user"></i>
                                </a>
                                <a title="<?php _e('Register', 'dina-kala'); ?>" <?php if( $di_data['ch_register_link'] ) {echo 'href="'.$di_data['register_link'].'"'; } else { echo 'href="' .esc_url( dina_myaccount_link() ).'"'; } ?>
                                    class="btn btn-light mregister">
                                    <i aria-hidden="true" class="fal fa-user-plus"></i>
                                </a>
                            <?php } } else { ?>
                                <a title="<?php _e('User Menu', 'dina-kala'); ?>" class="btn btn-light mlogin" onclick="openUmenu()">
                                    <i aria-hidden="true" class="fal fa-user"></i>
                                </a>
                            <?php } } ?>
                        </div>

                        <div class="col-md-3 <?php echo $di_data['mobile_logo_pos'] == 3 ? 'col-5' : 'col-6'; ?> logo dina-logo">
                            <?php if ( is_front_page() && $di_data['add_home_heading'] ) { echo '<h1>'; } ?>
                                <a href="<?php echo esc_url( home_url() ); ?>" title="<?php bloginfo('name'); ?> | <?php bloginfo('description'); ?>" rel="home">
                                    <?php
                                    $logo_width = ( ! empty( $di_data['site_logo']['width'] ) ) ? $di_data['site_logo']['width'] : '160';
                                    $logo_height = ( ! empty( $di_data['site_logo']['height'] ) ) ? $di_data['site_logo']['height'] : '57'; ?>
                                    <img <?php if( $di_data['site_schema'] ) {?>itemprop="logo" <?php } ?> src="<?php echo dina_to_https( $di_data['site_logo']['url'] ); ?>" srcset="<?php echo dina_to_https( $di_data['site_logo_retina']['url'] ); ?> 2x" width="<?php echo $logo_width; ?>" height="<?php echo $logo_height; ?>" alt="<?php bloginfo('name'); ?> | <?php bloginfo('description'); ?>" title="<?php bloginfo('name'); ?> | <?php bloginfo('description'); ?>" class="img-logo"/>
                                    <strong><?php bloginfo('name'); ?> | <?php bloginfo('description'); ?> </strong>
                                </a>
                            <?php if ( is_front_page() && $di_data['add_home_heading'] ) { echo '</h1>'; } ?>
                        </div>

                        <?php if ( $di_data['mobile_logo_pos'] == 3) { ?>
                            <div class="col-3 mobile-btns mobile-menu-btns">
                                <?php if ( ! $di_data['ch_menu_cart'] ) { ?>
                                    <span class="btn btn-light mmenu" onclick="openNav()">
                                        <i aria-hidden="true" class="fal fa-bars"></i>
                                    </span>
                                <?php } else { ?>
                                    <span class="btn btn-light mobile-header-cart" onclick="openCart()">
                                        <span aria-hidden="true" class="fal fa-shopping-bag ">
                                            <span class="cart-amount"><?php echo WC()->cart->get_cart_contents_count(); ?></span>
                                        </span>
                                    </span>
                                <?php } ?>
                        </div>
                        <?php } ?>
                        
                        <div class="col-md-6 search-con<?php if( $di_data['mobile_search'] ) { ?> mobile-search-con<?php } ?>">
                            <?php
                            if ( ! $di_data['replace_search_shortcode'] ) {
                                $ajax_search = $di_data['ajax_search'] ? true : false;
                                di_search_form( 'col-md-11', $ajax_search );
                            } else {
                                echo do_shortcode( $di_data['search_shortcode'] );
                            }
                            ?>
                        </div>

                        <?php if( $di_data['show_user_btn'] ) { ?>
                            <?php if(!is_user_logged_in() ) { ?>
                            <div class="col-md-3 user-btn">
                                <?php
                                if ( $di_data['replace_userbtns_shortcode'] ) { 
                                    echo do_shortcode( $di_data['userbtns_shortcode'] );
                                } elseif (function_exists('digits_version') && $di_data['digits_mode'] ) { 
                                    $digits_mode = ( $di_data['digits_page'] ? 'digitlink' : 'digitpopup' ); ?>
                                    <?php if( $di_data['user_btn_style'] ) { ?>
                                        <span title="<?php _e('Login Or Register', 'dina-kala'); ?>" class="register-link digitsbtn <?php echo $digits_mode; ?>">
                                            <i aria-hidden="true" class="fal fa-user"></i>
                                            <span class="hidden-ta"><?php _e('Login', 'dina-kala'); ?></span>
                                            /
                                            <i aria-hidden="true" class="fal fa-user-plus"></i>
                                            <span class="hidden-ta"><?php _e('Register', 'dina-kala'); ?></span>
                                        </span>
                                    <?php } else { ?>
                                        <span title="<?php _e('Login Or Register', 'dina-kala'); ?>" class="btn btn-success btn-register digitsbtn <?php echo $digits_mode; ?>">
                                            <i aria-hidden="true" class="fal fa-user"></i>
                                            <span class="hidden-ta"><?php _e('Login', 'dina-kala'); ?></span>
                                            /
                                            <i aria-hidden="true" class="fal fa-user-plus"></i>
                                            <span class="hidden-ta"><?php _e('Register', 'dina-kala'); ?></span>
                                        </span>
                                    <?php } ?>
                                <?php } else { ?>
                                    <?php if( $di_data['user_btn_style'] ) { ?>
                                        <?php if( $di_data['merge_user_btn'] ) { ?>
                                            <a title="<?php _e('Login Or Register', 'dina-kala'); ?>" <?php if( $di_data['ch_login_link'] ) {echo 'href="'.$di_data['login_link'].'"'; } else { echo 'href="' .esc_url( dina_myaccount_link() ).'"'; } ?>
                                            class="register-link merge-btn">
                                                <i aria-hidden="true" class="fal fa-user"></i>
                                                <span class="hidden-ta"><?php _e('Login', 'dina-kala'); ?></span>
                                                /
                                                <i aria-hidden="true" class="fal fa-user-plus"></i>
                                                <span class="hidden-ta"><?php _e('Register', 'dina-kala'); ?></span>
                                            </a>
                                        <?php } else { ?>
                                            <a title="<?php _e('Login', 'dina-kala'); ?>" <?php if( $di_data['ch_login_link'] ) {echo 'href="'.$di_data['login_link'].'"'; } else {echo 'href="#" onclick="openLogin()"';} ?>
                                                class="login-link">
                                                <i aria-hidden="true" class="fal fa-user"></i>
                                                <span class="hidden-ta"><?php _e('Login', 'dina-kala'); ?></span>
                                            </a>
                                            /
                                            <a title="<?php _e('Register', 'dina-kala'); ?>" <?php if( $di_data['ch_register_link'] ) {echo 'href="'.$di_data['register_link'].'"'; } else { echo 'href="' .esc_url( dina_myaccount_link() ).'"'; } ?>
                                                class="register-link">
                                                <i aria-hidden="true" class="fal fa-user-plus"></i>
                                                <span class="hidden-ta"><?php _e('Register', 'dina-kala'); ?></span>
                                            </a>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <?php if( $di_data['merge_user_btn'] ) { ?>
                                            <a title="<?php _e('Login Or Register', 'dina-kala'); ?>" <?php if( $di_data['ch_login_link'] ) {echo 'href="'.$di_data['login_link'].'"'; } else { echo 'href="' .esc_url( dina_myaccount_link() ).'"'; } ?>
                                                class="btn btn-success btn-register merge-btn">
                                                <i aria-hidden="true" class="fal fa-user"></i>
                                                <span class="hidden-ta"><?php _e('Login', 'dina-kala'); ?></span>
                                                /
                                                <i aria-hidden="true" class="fal fa-user-plus"></i>
                                                <span class="hidden-ta"><?php _e('Register', 'dina-kala'); ?></span>
                                            </a>
                                        <?php } else { ?>
                                            <a title="<?php _e('Login', 'dina-kala'); ?>" <?php if( $di_data['ch_login_link'] ) {echo 'href="'.$di_data['login_link'].'"'; } else {echo 'href="#" onclick="openLogin()"';} ?>
                                                class="btn btn-outline-success btn-login">
                                                <i aria-hidden="true" class="fal fa-user"></i>
                                                <span class="hidden-ta"><?php _e('Login', 'dina-kala'); ?></span>
                                            </a>
                                            <a title="<?php _e('Register', 'dina-kala'); ?>" <?php if( $di_data['ch_register_link'] ) {echo 'href="'.$di_data['register_link'].'"'; } else { echo 'href="' .esc_url( dina_myaccount_link() ).'"'; } ?>
                                                class="btn btn-success btn-register">
                                                <i aria-hidden="true" class="fal fa-user-plus"></i>
                                                <span class="hidden-ta"><?php _e('Register', 'dina-kala'); ?></span>
                                            </a>
                                        <?php } ?>
                                    <?php } ?>
                                <?php } ?>
                            </div>
                            <?php } else {
                            $user = wp_get_current_user(); ?>
                            <div class="col-md-3 drop-con">
                            <div class="dropdown user-drop">
                                <button class="dropdown-toggle user-menu" type="button">
                                <?php if ( class_exists( 'WooCommerce' ) ) { ?>
                                    <a href="<?php echo esc_url( dina_myaccount_link() ); ?>" title="<?php _e( 'Dashboard', 'dina-kala' ); ?>">
                                <?php } ?>
                                    <?php echo get_avatar( get_current_user_id() , 32, '', $user->display_name ); ?>
                                    <span class="user-name">
                                        <?php echo $user->display_name; ?>
                                        <?php if ( class_exists( 'WooCommerce' ) && class_exists( 'WooWallet' ) ) {       
                                            echo '<span class="wallet hidden-ta">';
                                            $wallet = woo_wallet()->wallet->get_wallet_balance( get_current_user_id() );
                                            echo ' | '. $wallet;
                                            echo '</span>';
                                        } ?>
                                    </span>
                                    <span class="fal fa-chevron-down user-chevron-down" aria-hidden="true"></span>
                                <?php if ( class_exists( 'WooCommerce' ) ) { ?>
                                    </a>
                                <?php } ?>
                                </button>

                                <?php if( $di_data['replace_user_menu'] && has_nav_menu('user_menu') ) { ?>
                                    <?php
                                        wp_nav_menu( array(
                                            'menu'              => 'user_menu',
                                            'theme_location'    => 'user_menu',
                                            'menu_class'        => 'dropdown-menu user-menu mu-menu col-12',
                                            'depth'             => 1,
                                            'container'         => ''
                                            )
                                        );
                                    ?>
                                <?php } elseif ( class_exists( 'WooCommerce' ) ) { ?>
                                    <ul class="dropdown-menu user-menu mu-menu col-12">
                                        <?php get_template_part('includes/umenu'); ?>
                                    </ul>
                                <?php } ?>
                            </div>
                            </div>
                        <?php } } ?>
                </div>
            </div>
        </div>
        <!-- Header Div -->

        <!-- Navbar -->
        <div class="dina-navbar">
            <nav class="navbar navbar-expand-sm<?php if ( $di_data['fixed_head_top'] ) {echo ' fixed-nav';} ?><?php if ( $di_data['focus_nav'] ) {echo ' focus-nav';} ?>" <?php if( $di_data['site_schema'] ) {?>itemscope itemtype="https://schema.org/SiteNavigationElement"<?php } ?>>
                <div class="container nav-con">
                    <!-- Collect the nav links from WordPress -->
                    <div class="collapse navbar-collapse" id="bootstrap-nav-collapse">
                        <?php 
                        $args = array(
                            'theme_location' => 'mega_menu',
                            'depth'             => 4,
                            'container'         => 'div',
                            'fallback_cb'       => 'Yamm_Nav_Walker_menu_fallback',
                            'walker'            => new Yamm_Nav_Walker()
                            );

                        if( $di_data['mega_style'] == 'second') {
                            $args['menu_class'] = 'nav navbar-nav yamm-s';
                        } else {
                            $args['menu_class'] = 'nav navbar-nav yamm';
                        }

                        if ( $di_data['fixed_head_logo'] ) {
                            if( $di_data['site_schema'] ) { $itemprop = 'itemprop="logo"'; } else { $itemprop = ''; }
                            if( $di_data['change_fixed_logo'] && !empty( dina_to_https( $di_data['sticky_logo']['url'] ) ) ) {
                                $sticky_logo = '<li class="sticky-logo"><a href="'. esc_url( home_url() ) .'" title="'. get_bloginfo('name') .' | '. get_bloginfo('description') .'" rel="home" class="menu-logo">
                                            <img '. $itemprop .'src="'. dina_to_https( $di_data['sticky_logo']['url'] ) .'" alt="'. get_bloginfo('name') .' | '. get_bloginfo('description') .'" width="107" height="37" title="'. get_bloginfo('name') .' | '. get_bloginfo('description') .'" class="img-logo"/>
                                        </a></li>';
                            } else {
                                $sticky_logo = '<li class="sticky-logo"><a href="'. esc_url( home_url() ) .'" title="'. get_bloginfo('name') .' | '. get_bloginfo('description') .'" rel="home" class="menu-logo">
                                            <img '. $itemprop .'src="'. dina_to_https( $di_data['site_logo']['url'] ) .'" srcset="'. dina_to_https( $di_data['site_logo_retina']['url'] ) .' 2x" alt="'. get_bloginfo('name') .' | '. get_bloginfo('description') .'" width="107" height="37" title="'. get_bloginfo('name') .' | '. get_bloginfo('description') .'" class="img-logo"/>
                                        </a></li>';
                            }
                            
                            $items_wrap = '<ul id="%1$s" class="%2$s">'.$sticky_logo.'%3$s';
                            $items_wrap .= '</ul>';
                            $args['items_wrap'] = $items_wrap;
                        }

                        wp_nav_menu($args);
                    ?>
                    </div><!-- ./collapse -->

                    <?php
                    if( $di_data['show_wish_list'] ) {
                        if ( class_exists( 'WooCommerce' ) && class_exists('YITH_WCWL') ) {
                            $wcwl_url = esc_url( YITH_WCWL()->get_wishlist_url() ); ?>
                            <div class="btn-wish dina-yith-wcwl-btn">
                                <a href="<?php echo $wcwl_url; ?>" aria-label="<?php _e('Wishlist', 'dina-kala'); ?>" rel="nofollow" class="wish-icon" data-toggle="tooltip" data-placement="top" title="<?php _e('Wishlist', 'dina-kala'); ?>">
                                    <i aria-hidden="true" class="fal fa-heart"></i>
                                    <i class="wish-amount"><?php echo do_shortcode( '[yith_wcwl_items_count]' ); ?></i>
                                </a>
                            </div>
                        <?php 
                        } elseif( class_exists( 'WooCommerce' ) && class_exists( 'JVM_WooCommerce_Wishlist' ) ) {
                            $wish_url = jvm_get_wishlist_url();
                            $wish_count = jvm_woocommerce_wishlist_get_count(); ?>
                            <div class="btn-wish">
                                <a href="<?php echo $wish_url; ?>" aria-label="<?php _e('Wishlist', 'dina-kala'); ?>" rel="nofollow" class="wish-icon" data-toggle="tooltip" data-placement="top" title="<?php _e('Wishlist', 'dina-kala'); ?>">
                                    <i aria-hidden="true" class="fal fa-heart"></i>
                                    <i class="wish-amount"><?php echo $wish_count; ?></i>
                                </a>
                            </div>
                    <?php 
                        } 
                    } ?>

                    <?php 
                    if ( $di_data['show_compare_btn'] ) {
                    if( class_exists( 'WooCommerce' ) && class_exists('YITH_Woocompare') ) {
                        global $yith_woocompare; ?>
                        <div class="btn-compare dina-yith-compare">
                            <a href="<?php echo $yith_woocompare->obj->view_table_url() ?>" aria-label="<?php _e('Compare Products', 'dina-kala'); ?>" rel="nofollow" class="compare-icon compare-link" data-toggle="tooltip" data-placement="top" title="<?php _e('Compare Products', 'dina-kala'); ?>">
                                <i aria-hidden="true" class="fal fa-random"></i>
                            </a>
                        </div>
                    <?php } elseif( class_exists( 'WooCommerce' ) && defined( 'WCCM_VERISON' ) ) {
                    $compare_url = wccm_get_compare_page_link( wccm_get_compare_list() );
                    $compare_count = count(wccm_get_compare_list() ); ?>
                        <div class="btn-compare">
                            <a href="<?php echo $compare_url; ?>" aria-label="<?php _e('Compare Products', 'dina-kala'); ?>" rel="nofollow" class="compare-icon compare-link" data-toggle="tooltip" data-placement="top" title="<?php _e('Compare Products', 'dina-kala'); ?>">
                                <i aria-hidden="true" class="fal fa-random"></i>
                                <i class="compare-amount"><?php echo $compare_count; ?></i>
                            </a>
                        </div>
                    <?php } } ?>

                    <?php if( class_exists( 'WooCommerce' ) && $di_data['show_cart_btn'] ) { ?>
                    <div class="btn-cart">
                        <span class="shop-icon" data-toggle="tooltip" data-placement="top" title="<?php _e('Shopping cart', 'dina-kala'); ?>" onclick="openCart()">
                        <i aria-hidden="true" class="fal fa-shopping-bag"></i>
                        <i class="cart-amount"><?php echo WC()->cart->get_cart_contents_count(); ?></i>
                        </span>
                    </div>
                    <?php } ?>

                </div><!-- /.container -->
            </nav>
        </div>
        <!-- Navbar -->

    </header>

    <div class="di-header-offset"></div>