<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Demo Website: Dina.Elmfile.ir
Author Website: Hosseinkhani.ir
*/

// Exit if accessed directly
if (!defined('ABSPATH') ) {
    exit;
}
global $di_data;
require_once DI_DIR . '/includes/single-product-func.php';
//require_once DI_DIR . '/includes/order-tracking.php';
require_once DI_DIR . '/includes/prod-hover-btns.php';
if ( ! $di_data['remove_myacc_hooks'] ) {
    require_once DI_DIR . '/includes/my-account-func.php';
    require_once DI_DIR . '/includes/udash.php';
}

//Change number or products per row
add_filter('loop_shop_columns', 'dina_loop_columns', 999);
if ( ! function_exists('dina_loop_columns') ) {
    function dina_loop_columns() {
        global $di_data;
        $prods = $di_data['product_col'];
        return $prods;
    }
}

//Change number of products that are displayed per page (shop page)
add_filter( 'loop_shop_per_page', 'dina_product_per_page', 20 );
function dina_product_per_page( $cols ) {
    global $di_data;
    $cols = $di_data['product_num'];
    return $cols;
}

//Check product is free
function dina_woo_free( $id ) {
    $product = wc_get_product( $id );
    if ( '' === $product->get_price() || 0 == $product->get_price() && defined( 'SOMDN_PATH' ) ) {
        return true;
    } else {
        return false;
    }
}

//Free Price for free products
add_filter( 'woocommerce_get_price_html', 'dina_free_zero_empty', 100, 2 );
function dina_free_zero_empty( $price, $product ){
    global $di_data;

    $coming = get_post_meta( $product->get_id(), 'dina_coming', true );

    $variable_call = false;
    if( $product->is_type( 'variable' ) ) {
        $min_var_reg_price = $product->get_variation_regular_price( 'min', true );
        $min_var_sale_price = $product->get_variation_sale_price( 'min', true );
        $max_var_reg_price = $product->get_variation_regular_price( 'max', true );
        $max_var_sale_price = $product->get_variation_sale_price( 'max', true );
        if ( ( $min_var_reg_price == $max_var_reg_price && $max_var_reg_price == 0 ) || ( $min_var_sale_price == $max_var_sale_price && $max_var_sale_price == 0 ) || ( $min_var_reg_price === $max_var_reg_price && $max_var_reg_price === '' ) || ( $min_var_sale_price === $max_var_sale_price && $max_var_sale_price === '' ) ) {
            $variable_call = true;
        }
    }

    if ( show_login_price() ) {

        remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30);

        if( is_singular( 'product') ) {
            if (function_exists( 'digits_version') && $di_data[ 'digits_mode' ] ) {
                $digits_mode = ( $di_data[ 'digits_page' ] ? 'digitsbtn digitlink' : 'digitsbtn digitpopup' );
                $price = '<span class="woocommerce-Price-amount amount '. $digits_mode .'">'. __( 'Login to see prices', 'dina-kala') .'</span>';
            } elseif( $di_data[ 'merge_user_btn' ] ) {
                $login_link = ( $di_data[ 'ch_login_link' ] ? 'href="'. $di_data[ 'login_link' ] .'"' : 'href="' . esc_url( dina_myaccount_link() ) .'"' );
                $price = '<a title="'. __( 'Login Or Register', 'dina-kala') .'" class="login-price-link" '. $login_link .'>';
                $price .= '<span class="woocommerce-Price-amount amount">'. __( 'Login to see prices', 'dina-kala') .'</span>';
                $price .= '</a>';
            } else {
                $login_link = ( $di_data[ 'ch_login_link' ] ? 'href="'. $di_data[ 'login_link' ] .'"' : 'href="javascript:void(0)" onclick="openLogin()"' );
                $price = '<a title="'. __( 'Login Or Register', 'dina-kala') .'" class="login-price-link" '. $login_link .'>';
                $price .= '<span class="woocommerce-Price-amount amount">'. __( 'Login to see prices', 'dina-kala') .'</span>';
                $price .= '</a>';
            }
        } else {
            $price = '<span class="woocommerce-Price-amount amount">'. __( 'Login to see prices', 'dina-kala') .'</span>';
        }

    } elseif ( $coming ) {

        remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30);
        $price = '<span class="woocommerce-Price-amount amount">'. __( 'Coming Soon...', 'dina-kala') .'</span>';

    } elseif ( ( $product->is_type( 'variable' ) && $variable_call === true ) && $di_data[ 'show_zero_call' ] && ( '' === $product->get_price() || 0 == $product->get_price() ) ) {
        
        $price = '<span class="woocommerce-Price-amount amount">'. __( 'Call!', 'dina-kala') .'</span>';

        if( is_singular( 'product' ) && ! empty ( $di_data[ 'zero_call_link' ] ) ) {
            $price = '<a class="call-pro-link" href="'. $di_data[ 'zero_call_link' ] .'" title="'. __( 'Call!', 'dina-kala' ).'" target="_blank">' . $price;
            $price = $price .'</a>';
        }
        
    } elseif ( ! $product->is_type( 'variable' ) && $di_data[ 'show_zero_call' ] && ( '' === $product->get_price() || 0 == $product->get_price() ) ) {

        $price = '<span class="woocommerce-Price-amount amount">'. __( 'Call!', 'dina-kala') .'</span>';

        if(is_singular( 'product') && ! empty ( $di_data[ 'zero_call_link' ] ) ) {
            $price = '<a class="call-pro-link" href="'. $di_data[ 'zero_call_link' ] .'" title="'. __( 'Call!', 'dina-kala') .'" target="_blank">' . $price;
            $price = $price .'</a>';
        }

    } elseif ( $di_data[ 'show_free_price' ] && ( '' === $product->get_price() || 0 == $product->get_price() ) ) {

        $price = '<span class="woocommerce-Price-amount amount">'. __( 'Free!', 'dina-kala') .'</span>';

    }
    return $price;
}

//Change several of the breadcrumb defaults
add_filter( 'woocommerce_breadcrumb_defaults', 'dina_woocommerce_breadcrumbs' );
function dina_woocommerce_breadcrumbs() {
    global $di_data;
    if( $di_data['change_home_text'] ) {
        $home_text = $di_data['home_text'];
    } else {
        $home_text = _x( 'Home', 'breadcrumb', 'dina-kala' );
    }
    $bread_mobile = ($di_data['show_bread_mobile'] ? '' : ' mobile-hidden' );
    return array(
            'delimiter'   => '',
            'wrap_before' => '<div class="row bread-row'.$bread_mobile.'"><nav class="col-12 shadow-box breadcrumbs dina-breadcrumb" itemprop="breadcrumb">',
            'wrap_after'  => '</nav></div>',
            'before'      => '',
            'after'       => '',
            'home'        => $home_text,
        );
}

//Show cart contents / total Ajax
add_filter( 'woocommerce_add_to_cart_fragments', 'woocommerce_header_add_to_cart_fragment' );
function woocommerce_header_add_to_cart_fragment( $fragments ) {
	global $woocommerce;
	ob_start();
	?>
	<i class="cart-amount">
    <?php echo $woocommerce->cart->cart_contents_count; ?></i>
	<?php
	$fragments['.cart-amount'] = ob_get_clean();
	return $fragments;
}

//Total Sales of woocommerce products
function di_woo_get_total_sales() {
    $total_orders = wc_orders_count( 'completed' );
    return $total_orders;
}

//Woo Dis price
function disw_price ($id){
    $product = wc_get_product( $id );

    if ( $product->is_type( 'variable' ) ) {
        $children_ids = $product->get_children();
        foreach ( $children_ids as $children_id ) {
            $product = wc_get_product( $children_id );
            $sale_price = $product->get_sale_price();
            if ( ! empty( $sale_price ) ) {
                $regular_price = $product->get_regular_price();
                $r_price = $regular_price;
                $s_price = $sale_price;
            }
        }
    } else {
        $r_price = $product->get_regular_price();
        $s_price = $product->get_sale_price();
    }
    $d_price = (int)$r_price - (int)$s_price;
    $t_price = round( ( $d_price / $r_price ) * 100 );
    return $t_price;
}

//Dina Dis price
function dina_dis_price ($id) {
    global $di_data;
    if ( ! $di_data['display_discount'] )
        return;
    $product = wc_get_product( $id );
    if($product->is_type( 'variable' ) ){
        $s_price = $product->get_variation_sale_price( 'min' );
    } else {
        $s_price = $product->get_sale_price();
    }
    if(!empty($s_price) && disw_price ($id) != 0) {
        if( $di_data['display_spec'] ) {
            $t_price ='<span class="product-dis product-dis-spec">'. __( 'Sale!', 'dina-kala' ) .'</span>';
        } elseif(is_rtl() ) {
            $t_price ='<span class="product-dis">٪'. disw_price ($id) .'</span>';
        } else {
            $t_price ='<span class="product-dis">'. disw_price ($id) .'%</span>';
        }
        return $t_price;
    }
}

//dina_woo_show_page_title
add_filter( 'woocommerce_show_page_title', 'dina_woo_show_page_title' );
function dina_woo_show_page_title() {
    return false;
}

//dina_woo_add_product_class
add_filter('post_class', 'dina_woo_add_product_class');
function dina_woo_add_product_class($classes) {
    global $di_data;
    global $product;
    if(is_single() && 'product' == get_post_type() ) {
        $pside = get_post_meta( get_the_ID(), 'dina_pside', true );
        $content_sticky = ($di_data['side_sticky'] ? 'content-sticky' : '');
        $classes[] .= $content_sticky;
        if($pside == 'wside') { 
        $classes[] .= 'col-12';
        }
        elseif( !empty($pside) ) {
            $classes[] .= 'col-lg-9 col-12';
        } elseif ( $di_data['product_side'] > 0) {
        $classes[] .= 'col-lg-9 col-12';}
        else{
            $classes[] .= 'col-12';
        }
        $classes[] .= ( !$product->is_type( 'variable' ) && $di_data['show_zero_call'] && ( '' === $product->get_price() || 0 == $product->get_price() ) ? 'call-pro' : '' );
        $classes[] .= ( $di_data['prod_tab_style'] == 'sttwo'  ? 'product-tab-style-two' : '' );
        $classes[] .= ( is_rtl()  ? 'product-rtl' : 'product-ltr' );
        $classes[] .= ( $di_data['product_page_style'] == 'stone'  ? 'product-page-style-one' : 'product-page-style-two' );
        $classes[] .= ( class_exists( 'Cipg_Slider' )  ? 'dina-wpgs-gallery' : 'dina-woo-gallery' );
        $classes[] .= ( get_post_meta( $product->get_id(), 'dina_coming', true )  ? 'product-coming' : '' );
        $classes[] .= ( show_login_price() ? 'dina-login-price' : '' );
    }
    return $classes;
}

//dina_woo_before_main_content
add_action('woocommerce_before_main_content', 'dina_woo_before_main_content',21);
function dina_woo_before_main_content() {
    global $di_data;

    if ( $di_data['show_sub_cats'] && is_product_category() ) {
        dina_show_sub_cats();
    }

    if ( $di_data['show_head_banner'] && !is_checkout() && !is_cart() ) {
         dina_header_banner(); 
        } 

    if( !is_singular('product') ) {
        $side = ($di_data['product_archive_side'] == 2 ? ' right-side' : ''); ?> 
        <div class="row prod-row<?php echo $side ?>">
    <?php } else {

    $pside = get_post_meta( get_the_ID(), 'dina_pside', true );

    if($pside == 'rside') { 
        $side = ' right-side';
    } elseif ( $pside == 'lside') {
        $side = '';
    } elseif ( $di_data['product_side'] == 2 ) {
        $side = ' right-side';
    } else {
        $side = '';
    } ?>

    <div class="row prod-row<?php echo $side ?>">
    <?php }
}

//dina_woo_after_main_content
add_action('woocommerce_after_main_content', 'dina_woo_after_main_content');
function dina_woo_after_main_content() { ?>
    </div>    
<?php }

//dina_woo_before_shop_loop
add_action('woocommerce_before_shop_loop', 'dina_woo_before_shop_loop',16);
function dina_woo_before_shop_loop() { 
    global $di_data;
    $content_sticky = ($di_data['side_sticky'] ? ' content-sticky' : '');
    $ajax_prod = ($di_data['ajax_prod'] ? ' ajax-prod' : '');
    $col = ($di_data['product_archive_side'] == 0 ? 'col-12' : 'col-lg-9 col-12'); ?>
    <div class="<?php echo $col; ?><?php echo $content_sticky; ?><?php echo $ajax_prod; ?>">
<?php
}

//dina_woo_after_shop_loop
add_action('woocommerce_after_shop_loop', 'dina_woo_after_shop_loop',15);
function dina_woo_after_shop_loop() { ?>
    </div>    
<?php }

//Dina Category Slider
add_action( 'woocommerce_before_shop_loop', 'dina_category_slider', 17 );
function dina_category_slider() {
    global $di_data;
    if( is_woocommerce() && is_archive() && $di_data['cat_slider_show'] ) {

        $term_id  = get_queried_object_id();

        $cat_slide_fields = get_term_meta( $term_id, 'dina_cat_slide_fields', true );
        
        if( !empty( $cat_slide_fields ) ) {

            $slider_prameters = '';
            $slider_prameters .= $di_data['cat_slider_show_title'] ?  ' data-itemdotsc="#slider-title"' : '';
            $slider_prameters .= $di_data['cat_slider_show_arrows'] ? ' data-itemnavs="true"' : ' data-itemnavs="false"';
            $slider_prameters .= $di_data['cat_slider_show_dots'] ? ' data-itemdots="true"' : ' data-itemdots="false"';
            $slider_prameters .= $di_data['cat_slider_auto_play'] ? ' data-itemplay="true" data-itemtime="'. $di_data['cat_slider_time'] .'"' : ' data-itemplay="false"';
            $slider_prameters .= $di_data['cat_slider_pause_over'] ? ' data-itemover="true"' : ' data-itemover="false"'; ?>

            <!-- start slider -->
            <div class="scon dina-category-slider shadow-box">
                <div class="slider-con owl-carousel" <?php echo $slider_prameters; ?> data-dir="<?php echo dina_rtl(); ?>">
                    <?php
                    foreach ( (array) $cat_slide_fields as $key => $cat_slide_field ) { 
                    ?>
                        <div class="item">
                            <?php if( ! empty( $cat_slide_field['dina_cat_slide_link'] ) ) { ?>
                                <a href="<?php echo $cat_slide_field['dina_cat_slide_link']; ?>" title="<?php echo $cat_slide_field['dina_cat_slide_title']; ?>" >
                            <?php }
                            $image_id = attachment_url_to_postid( esc_url( $cat_slide_field['dina_cat_slide_image'] ) );
                            $image_attributes = wp_get_attachment_image_src( $image_id, 'full');
                            ?>
                                <img src="<?php echo $cat_slide_field['dina_cat_slide_image']; ?>" alt="<?php echo $cat_slide_field['dina_cat_slide_title']; ?>" width="<?php echo $image_attributes[1]; ?>" height="<?php echo $image_attributes[2]; ?>" class="slider-img">
                            <?php if( ! empty( $cat_slide_field['dina_cat_slide_link'] ) ) { ?>
                                </a>
                            <?php } ?>
                        </div>
                    <?php
                    }
                    ?>
                </div>

                <?php if ( $di_data['cat_slider_show_title'] ) { ?>
                <div class="col-12 slider-title-outer">
                    <ul id="slider-title">
                        <?php
                        foreach ( (array) $cat_slide_fields as $key => $cat_slide_field ) { ?>
                        <li>
                            <span class="slide-title"><?php echo $cat_slide_field['dina_cat_slide_title']; ?></span>
                        </li>
                        <?php
                        } ?>
                    </ul>
                </div>
                <?php } ?>
            </div>
            <!-- end slider -->
       <?php 
        }
    }
}

//dina_woo_before_order_con
add_action('woocommerce_before_shop_loop', 'dina_woo_before_order_con',19);
function dina_woo_before_order_con() { 
    global $di_data;

    $show_filter = (dina_check_side() == 2 && $di_data['show_filter'] ? ' show-filter' : ''); ?>

    <div class="col-12 shadow-box woocommerce-ordering-con<?php echo $show_filter; ?>">

    <i class="fal fa-sort-amount-up-alt sort-icon" aria-hidden="true"></i>

    <ul class="dina-order-products">
    <?php
    
    if( isset($_GET['orderby'] ) ) {
        $orderby = $_GET['orderby'];
    } elseif( is_search() ) {
        $orderby = 'relevance';
    } else {
        $orderby = get_option( 'woocommerce_default_catalog_orderby' );
    }
    ?>

        <?php if( is_search() ){ ?>
        <li class="order-item order-relevance<?php echo ($orderby == 'relevance' ? ' is-active' : ''); ?>">
            <a rel="nofollow" href="<?php echo dina_order_get_link( 'relevance' ); ?>">
                <?php _e('Relevance' , 'dina-kala'); ?>
            </a>
        </li>

        <?php } elseif( $orderby == 'menu_order' || $orderby == '' ){ ?>
        <li class="order-item order-menu-order<?php echo ($orderby == 'menu_order' || $orderby == '' ? ' is-active' : ''); ?>">
            <a rel="nofollow" href="<?php echo dina_order_get_link( 'menu_order' ); ?>">
                <?php _e('Default' , 'dina-kala'); ?>
            </a>
        </li>
        <?php } ?>

        <li class="order-item order-rating<?php echo ($orderby == 'rating' ? ' is-active' : ''); ?>">
            <a rel="nofollow" href="<?php echo dina_order_get_link( 'rating' ); ?>">
                <?php _e('Rating' , 'dina-kala'); ?>
            </a>
        </li>

        <li class="order-item order-popularity<?php echo ($orderby == 'popularity' ? ' is-active' : ''); ?>">
            <a rel="nofollow" href="<?php echo dina_order_get_link( 'popularity' ); ?>">
                <?php _e('Popularity' , 'dina-kala'); ?>
            </a>
        </li>

        <li class="order-item order-date<?php echo ($orderby == 'date' ? ' is-active' : ''); ?>">
            <a rel="nofollow" href="<?php echo dina_order_get_link( 'date' ); ?>">
                <?php _e('Latest' , 'dina-kala'); ?>
            </a>
        </li>

        <li class="order-item order-price<?php echo ($orderby == 'price' ? ' is-active' : ''); ?>">
            <a rel="nofollow" href="<?php echo dina_order_get_link( 'price' ); ?>">
                <?php _e('Low Price' , 'dina-kala'); ?>
            </a>
        </li>

        <li class="order-item order-price-desc<?php echo ($orderby == 'price-desc' ? ' is-active' : ''); ?>">
            <a rel="nofollow" href="<?php echo dina_order_get_link( 'price-desc' ); ?>">
                <?php _e('High Price' , 'dina-kala'); ?>
            </a>
        </li>
    </ul>
<?php }

//dina_order_get_link
function dina_order_get_link( $order_type ) {
    $base_link            = dina_shop_page_link( true );
    $link                 = remove_query_arg( 'orderby', $base_link );

    if( $order_type != 'menu_order' ) {
        $link = add_query_arg( 'orderby', $order_type, $link );
        $link = str_replace( '%2C', ',', $link );
    }

    return $link;
}

//dina_woo_after_order
add_action('woocommerce_before_shop_loop', 'dina_woo_after_order',35);
function dina_woo_after_order() { 
    global $di_data;
    if ( dina_check_side() == 2 && $di_data['show_filter'] ) { ?>
        <span class="show-filter-btn open-side" onclick="openSide()">
            <span aria-hidden="true" class="fal fa-filter" title="<?php _e('Show filters', 'dina-kala'); ?>"></span>
            <span><?php _e('Show filters', 'dina-kala'); ?></span>
        </span>
    <?php } ?>
    </div>
<?php
}

//Show Product Category Description
remove_action( 'woocommerce_archive_description', 'woocommerce_taxonomy_archive_description' );
remove_action( 'woocommerce_archive_description', 'woocommerce_product_archive_description' );
if ( $di_data['show_on_top_cat'] ) {
    add_action('woocommerce_before_shop_loop', 'dina_archive_description', 18);
    add_action('woocommerce_after_shop_loop', 'dina_second_archive_description',14);
} else {
    add_action('woocommerce_after_shop_loop', 'dina_archive_description',14);
    add_action('woocommerce_before_shop_loop', 'dina_second_archive_description', 18);
}

//Dina second product category archive description
function dina_second_archive_description() {
    global $di_data;
    if( is_woocommerce() && is_product_category() ) {
        $term_id  = get_queried_object_id();
        $dina_second_cat_desc = get_term_meta( $term_id, 'dina_second_cat_desc', true );

        if( !empty( $dina_second_cat_desc ) ) {

            $cat_full = ( ! $di_data['show_full_text_cat'] ? ' class="cat-text dina-more-less" data-more="'. __('Show More', 'dina-kala') .'" data-less="'. __('Show Less', 'dina-kala') .'"' : '');

            echo '<div class="shadow-box cat-desc col-12">
            <div'. $cat_full .'>
            '. dina_wpautop_content( $dina_second_cat_desc ) .'
            </div>
            </div>';
        }
    }
}

//remove woocommerce_breadcrumb
if ( ! $di_data['show_bread'] ) {
    remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0);
}

//dina_pagination_args
add_filter( 'woocommerce_pagination_args', 'dina_pagination_args' );
function dina_pagination_args() {
    $total   = isset( $total ) ? $total : wc_get_loop_prop( 'total_pages' );
    $current = isset( $current ) ? $current : wc_get_loop_prop( 'current_page' );
    $base    = isset( $base ) ? $base : esc_url_raw( str_replace( 999999999, '%#%', remove_query_arg( 'add-to-cart', get_pagenum_link( 999999999, false ) ) ) );
    $format  = isset( $format ) ? $format : '';
    if ( $total <= 1 ) {
        return;
    }
        return array(
            'base'         => $base,
            'format'       => $format,
            'add_args'     => false,
            'current'      => max( 1, $current ),
            'total'        => $total,
            'prev_text' => __('<i class="fal fa-chevron-right" aria-hidden="true" title="Next"></i>') ,
            'next_text' => __('<i class="fal fa-chevron-left" aria-hidden="true" title="Prev"></i>') ,
            'type'         => 'list',
            'end_size'     => 3,
            'mid_size'     => 3,
            );
}

//dina_cart_item_name
add_filter( 'woocommerce_cart_item_name', 'dina_cart_item_name', 10, 3 );
function dina_cart_item_name( $item_name,  $cart_item,  $cart_item_key ) {
    return '<span class="side-cart-name">'.$item_name.'</span>';
}

//dina_no_products_found
remove_action( 'woocommerce_no_products_found', 'wc_no_products_found' );
add_action('woocommerce_no_products_found', 'dina_no_products_found', 10);
function dina_no_products_found(){
    global $di_data;
    $content_sticky = ($di_data['side_sticky'] ? ' content-sticky' : '');
    $col = ($di_data['product_archive_side'] == 0 ? 'col-12' : 'col-lg-9 col-12');
    ?>
    <div class="<?php echo $col; ?><?php echo $content_sticky; ?>">
     <div class="alert alert-warning" role="alert">
         <strong><span class="fal fa-bell fa-lg" aria-hidden="true">
         </span> <?php _e('No products found!', 'dina-kala') ?></strong>
      </div>
    </div>
<?php }

//Remove Favorite button product archive pages
if ( class_exists( 'JVM_WooCommerce_Wishlist' ) ) {
    remove_action( 'woocommerce_after_shop_loop_item', 'jvm_woocommerce_add_to_wishlist', 15 );
    remove_action( 'woocommerce_after_add_to_cart_button', 'jvm_woocommerce_add_to_wishlist' );
}

//Remove Compare button product archive pages
if (defined( 'WCCM_VERISON' ) ) {
    remove_action( 'woocommerce_before_shop_loop', 'wccm_register_add_compare_button_hook' );
    remove_action( 'woocommerce_single_product_summary', 'wccm_add_single_product_compare_buttton', 35 );
    remove_action( 'woocommerce_before_shop_loop', 'wccm_render_catalog_compare_info' );
    remove_action( 'wp_enqueue_scripts', 'wccm_enqueue_catalog_scripts' );
    remove_action( 'widgets_init', 'wccm_widgets_init' );
}

//Ajax Load More
if( $di_data['ajax_prod'] ) {
    add_action('woocommerce_after_shop_loop', 'dina_product_load_more', 11);
}
function dina_product_load_more() { ?>
    <div class="col-12 load-more">
        <div class="page-load-status">
            <p class="infinite-scroll-request"><i class="fal fa-spinner-third fa-spin" aria-hidden="true"></i></p>
            <p class="infinite-scroll-last alert alert-info"><?php _e('End of products', 'dina-kala') ?></p>
            <p class="infinite-scroll-error alert alert-info"><?php _e('No more pages to load', 'dina-kala') ?></p>
        </div>
        <span id="load-more-button" class="btn btn-outline-dina"><?php _e('Load More Products', 'dina-kala') ?></span>
    </div>
<?php }

//Option to remove product sku
if(!$di_data['show_prod_sku'] ) {
    add_filter( 'wc_product_sku_enabled', 'dina_remove_product_page_skus' );
}
function dina_remove_product_page_skus( $enabled ) {
    if ( ! is_admin() && is_product() ) {
        return false;
    }
    return $enabled;
}

//Remove download item from woo menu
if( $di_data['remove_download'] ) {
    add_filter( 'woocommerce_account_menu_items', 'remove_my_account_download_items' );
}
function remove_my_account_download_items( $items ) {
    unset($items['downloads'] );
    return $items;
}

//remove or change reset variations text
if( $di_data['remove_clear_option'] ) {
    add_filter('woocommerce_reset_variations_link', '__return_empty_string');
} else {
    add_action( 'woocommerce_reset_variations_link' , 'dina_change_clear_text', 15 );
}
function dina_change_clear_text() {
   global $di_data;
   $reset_var_text = ($di_data['ch_reset_var_text']? $di_data['reset_var_text'] : __( 'Clear options', 'dina-kala' ) );
   echo '<a class="reset_variations" rel="nofollow" href="#">' . $reset_var_text . '</a>';
}

//Ajax add to cart on archives
function dina_add_to_cart( $product ) {

    global $di_data;

    if ( ! $di_data['show_hover_btns'] ) 
         return;

    $coming = get_post_meta( $product->get_id(), 'dina_coming', true );

    if( show_login_price() || ! $product->is_purchasable() || ! $product->is_in_stock() || $coming || ( ! $product->is_type( 'variable' ) && $di_data['show_zero_call'] && ('' === $product->get_price() || 0 == $product->get_price() ) ) ) { ?>
        <a href="<?php the_permalink(); ?>" class="btn btn-success btn-buy<?php if( $di_data['show_hover_btns_fixed'] ) { echo ' btn-buy-fixed'; } if( $di_data['hover_btns_fixed_mobile'] ) { echo ' btn-buy-fixed-mobile'; } ?> button">
            <i class="fal fa-eye" aria-hidden="true"></i>
            <?php _e( 'View Product', 'dina-kala' ); ?>
	    </a>
    <?php

    } elseif ( $di_data['show_count_archive'] && ( get_option( 'woocommerce_enable_ajax_add_to_cart' ) === 'yes' ) && ( $product->is_type( 'simple' ) ) ) {
        dina_archive_add_cart();
    } elseif ( get_option( 'woocommerce_enable_ajax_add_to_cart' ) === 'yes' ) {
        echo sprintf( '<a href="%s" data-quantity="1" class="%s" %s>%s</a>',
            esc_url( $product->add_to_cart_url() ),
            esc_attr( implode( ' ', array_filter( array(
                'btn', 'btn-success', 'btn-buy', 'button', 'product_type_' . $product->get_type(),
                $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                $di_data['show_hover_btns_fixed'] ? ' btn-buy-fixed' : '',
                $di_data['hover_btns_fixed_mobile'] ? ' btn-buy-fixed-mobile' : '',
                $product->supports( 'ajax_add_to_cart' ) ? 'ajax_add_to_cart' : '',
            ) ) ) ),
            wc_implode_html_attributes( array(
                'data-product_id'  => $product->get_id(),
                'data-product_sku' => $product->get_sku(),
                'aria-label'       => $product->add_to_cart_description(),
                'rel'              => 'nofollow',
            ) ),
            esc_html( $product->add_to_cart_text() )
        );
    } else { ?>
        <a href="<?php the_permalink(); ?>" class="btn btn-success btn-buy<?php if( $di_data['show_hover_btns_fixed'] ) { echo ' btn-buy-fixed'; } if( $di_data['hover_btns_fixed_mobile'] ) { echo ' btn-buy-fixed-mobile'; } ?> button">
            <i class="fal fa-cart-plus" aria-hidden="true"></i>
            <?php _e( 'View And Buy', 'dina-kala' ); ?>
	    </a>
    <?php
    }
}

//dina_mini_product_classes
function dina_mini_product_classes( $id ) {
    global $di_data;
    $product = wc_get_product( $id );

    $class = "woocommerce shadow-box ".$di_data['prod_hover']." mini-product". ' product-'.$id;
    $class .= ('' === $product->get_price() || 0 == $product->get_price() ? ' zero-prod' : '' );
    $class .= ( $product->is_in_stock() ? '' : ' prod-out-stock' );
    $class .= ( $product->is_type( 'variable' ) ? ' prod-variable' : '' );
    $class .= ( !$di_data['remove_price_range'] ? ' prod-remove-range' : '' );
    $class .= ( get_post_meta( $product->get_id(), 'dina_coming', true ) ? ' prod-coming' : '' );
    $class .= ( show_login_price() ? ' dina-login-price' : '' );
    $class .= ( $di_data['show_hover_btns_fixed'] ? ' prod-add-btn-fixed' : '' );
    $class .= ( $di_data['hover_btns_fixed_mobile'] ? ' prod-add-btn-fixed-mobile' : '' );
    $class .= ( $di_data['quick_btns_fix_mobile'] ? ' quick-btns-fix-mobile' : '' );

    if( $di_data['show_sec_img'] ) {
        $attachment_ids = $product->get_gallery_image_ids();
        if ( is_array( $attachment_ids ) && !empty( $attachment_ids ) ) {
            $class .= ' hover-image';
        }
    }
    return $class;
}

//Remove Select2 for WooCommerce
add_action('wp_enqueue_scripts', 'wc_disable_select2', 100);
function wc_disable_select2() {
    if ( class_exists('woocommerce') ) {
        if( is_woocommerce() && is_archive() )
        {
            wp_dequeue_style('select2');
            wp_deregister_style('select2');
    
            // WooCommerce 3.2.1.x and below
            wp_dequeue_script('select2');
            wp_deregister_script('select2');
    
            // WooCommerce 3.2.1+
            wp_dequeue_script('selectWoo');
            wp_deregister_script('selectWoo');
        }
    } 
}

//Dina_product_rating
function dina_product_rating( $id ){
    global $di_data;
    $product = wc_get_product( $id );

    if ( ! wc_review_ratings_enabled() || !$di_data['show_star_rating'] ) {
        return;
    }

    $rating_count = $product->get_rating_count();
    $review_count = $product->get_review_count();
    $average      = $product->get_average_rating();

    if ( $rating_count > 0 ) {
        echo '<div class="woocommerce-product-rating">';
        echo wc_get_rating_html( $average, $rating_count );
        echo '</div>';
    }
}

//Dina_check_product_purchasable
function dina_check_product_purchasable(){
    global $di_data;
    global $product;
    $coming = get_post_meta( get_the_id(), 'dina_coming', true );
    if(!$product->is_purchasable() || !$product->is_in_stock() || $coming || ( $di_data['show_zero_call'] && ('' === $product->get_price() || 0 == $product->get_price() ) ) ) { 
        return false;
    } else{
        return true;
    }
}

//Get product deeper category
function dina_get_prod_deep_cats( $product_id ) {
    $prod_deep_cat = '';
    // get all product cats for the current post
    $categories = get_the_terms( $product_id, 'product_cat' ); 

    // wrapper to hide any errors from top level categories or products without category
    if ( $categories ) : 
        // loop through each cat
        $cats = array();
        foreach( $categories as $category ) :
        // get the children (if any) of the current cat
        $children = get_categories( array ( 'taxonomy' => 'product_cat', 'parent' => $category->term_id ) );

        if ( count( $children ) == 0 ) {
            // if no children, then echo the category name.
            $cats[] = $category->term_id;
        }
        endforeach;
    endif;

    return $cats;
}

//Remove password strength check.
if( $di_data['remove_password_strength'] ) {
    add_action( 'wp_print_scripts', 'di_remove_password_strength', 10 );
}
function di_remove_password_strength() {
    wp_dequeue_script( 'wc-password-strength-meter' );
}

//Add archive title to woocommerce archive pages
if( $di_data['show_archive_title'] ) {
    add_action('woocommerce_before_shop_loop', 'dina_woo_archive_title',17);
}

function dina_woo_archive_title() {
   global $di_data;
   $show_archive_mobile = ( $di_data['show_archive_title_mobile'] ? '' : ' mobile-hidden' );
   if ( is_woocommerce() && is_archive() ) {
       echo '<div class="row archive-title-con'. $show_archive_mobile .'"><div class="col-12 shadow-box"><h1>';
           woocommerce_page_title();
       echo '</h1></div></div>';
   }
}

//Poduct archive hover
function dina_prod_hover($product_id) {
    if ( ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) || ( \Elementor\Plugin::$instance->preview->is_preview_mode() ) ) {
        return;
    }
    
    global $di_data; ?>

    <span class="prod-hover-btns">

        <?php if ( $di_data['show_quick_view'] ) { ?>
            <span data-dina-product-id="<?php echo $product_id; ?>" data-toggle="tooltip" data-placement="right" data-delay='{"show":"500", "hide":"0"}' class="quick-view-btn prod-hover-btn btn btn-light" title="<?php _e('Quick View', 'dina-kala'); ?>">
                <i class="fal fa-eye" aria-hidden="true"></i>
            </span>
        <?php } ?>

        <?php if ( $di_data['like_prod_archive'] ) {
            if( class_exists('YITH_WCWL') ) { ?>
                <span data-toggle="tooltip" data-placement="right" data-delay='{"show":"500", "hide":"0"}' class="like-prod-btn dina-yith-wcwl prod-hover-btn btn btn-light" title="<?php _e('Add to Wishlist', 'dina-kala'); ?>">
                    <?php echo preg_replace("/<img[^>]+\>/i", " ", do_shortcode('[yith_wcwl_add_to_wishlist]') ); ?>
                </span>
            <?php } elseif ( class_exists( 'JVM_WooCommerce_Wishlist' ) ) { ?>
                <span data-toggle="tooltip" data-placement="right" data-delay='{"show":"500", "hide":"0"}' class="like-prod-btn prod-hover-btn btn btn-light" title="<?php _e('Add to Wishlist', 'dina-kala'); ?>">
                <?php echo do_shortcode('[jvm_woocommerce_add_to_wishlist]'); ?>
                </span>
        <?php }
        } ?>
        
        <?php if ( $di_data['compare_prod_archive'] ) { 
            if( class_exists('YITH_Woocompare') ) { ?>
            <div class="dina-compare-button prod-hover-btn btn btn-light" data-toggle="tooltip" data-placement="right" data-delay='{"show":"500", "hide":"0"}' title="<?php _e('Compare Product', 'dina-kala'); ?>">
                <?php echo do_shortcode('[yith_compare_button]'); ?>
            </div>
        <?php } elseif( defined( 'WCCM_VERISON' ) ) { ?>
            <?php 
            if ( in_array( $product_id, wccm_get_compare_list() ) ) {
                $compare_title= __('Remove From Compare', 'dina-kala');
                $compare_class = " in-compare";
            } else {
                $compare_title= __('Compare Product', 'dina-kala');
                $compare_class = "";
            }
            ?>
            <span data-dina-compare-id="<?php echo $product_id; ?>" data-toggle="tooltip" data-placement="right" data-delay='{"show":"500", "hide":"0"}' class="compare-ajax-btn prod-hover-btn btn btn-light<?php echo $compare_class; ?>" title="<?php echo $compare_title; ?>">
                <i class="fal fa-random" aria-hidden="true"></i>
            </span>
        <?php }
        } ?>

    </span>
<?php }

//WooCommerce Show Product Image at Checkout Page
add_filter( 'woocommerce_cart_item_name', 'dina_product_image_on_checkout', 10, 3 );
function dina_product_image_on_checkout( $name, $cart_item, $cart_item_key ) {
    /* Return if not checkout page */
    if ( ! is_checkout() ) {
        return $name;
    }
    /* Get product object */
    $_product = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
    /* Get product thumbnail */
    $thumbnail = $_product->get_image('thumbnail');
    $image = '<div class="dina-ch-product-image">'
                . $thumbnail .
            '</div>'; 
    /* Prepend image to name and return it */
    return $image . $name;
}

//Dina before cart
add_action('woocommerce_before_cart', 'dina_before_cart');
function dina_before_cart() {
    echo '<div class="dina-cart-content-wrapper row">';
}

//Dina after cart
add_action('woocommerce_after_cart', 'dina_after_cart');
function dina_after_cart() {  
    echo '</div>';
}

//Dina empty cart
add_action('woocommerce_cart_is_empty', 'dina_empty_cart');
function dina_empty_cart() { ?>
    <div class="dina-empty-cart">
        <i class="fal fa-shopping-cart empty-cart-icon" aria-hidden="true"></i>
        <div class="dina-empty-cart-text">
            <?php _e('Before proceed to checkout you must add some products to your shopping cart.', 'dina-kala'); ?>
            <br>
            <?php _e('You will find a lot of interesting products on our "Shop" page.', 'dina-kala'); ?>
        </div>
    </div>
<?php }

//Change Cross Sell Display Place
remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display', 10 );
add_action( 'woocommerce_before_cart_collaterals', 'woocommerce_cross_sell_display', 10 );

//Dina Product Label
add_action('woocommerce_product_thumbnails' , 'dina_product_label' );
function dina_product_label($id) {

        global $product;
        $id = $product->get_id();

    $plabel = get_post_meta( $id, 'dina_plabel', true );
    $plabel_color = get_post_meta( $id, 'dina_plabel_color', true );
    $product_label = '';

    if ( ! empty( $plabel ) ) {

        $product_label .= '<span class="product-label product-label-'. $plabel_color .'">'. $plabel .'</span>';

    }
    
    echo $product_label;

}

//Show price to logged in users
function show_login_price() {
    global $di_data;
    if ( ! is_user_logged_in() && $di_data['show_login_price'] ) 
        return true;
}

//Show Product Category Sub Category
function dina_show_sub_cats() {
    global $di_data;
    $term_id  = get_queried_object_id();
        $taxonomy = 'product_cat';
    
        // Get subcategories of the current category
        $terms    = get_terms( [
            'taxonomy'    => $taxonomy,
            'hide_empty'  => true,
            'parent'      => get_queried_object_id()
        ] );

        if ( empty($terms ) ) 
        return;
        $mobile_cats = ( ! $di_data['show_sub_cats_mobile'] ? ' dina-hide-cats-mobile' : '' );
        $output = '<div class="row dina-sub-cat-row'. $mobile_cats .'">
        <div class="col-12 shadow-box dina-sub-cats">
            <div class="dina-subcat-list-title">'. __( 'Subcategories' , 'dina-kala' ) .'</div>';
        $output .= '<ul class="dina-subcat-list owl-carousel" data-dir="'. dina_rtl() .'">';
    
        // Loop through product subcategories WP_Term Objects
        foreach ( $terms as $term ) {
            $term_link = get_term_link( $term, $taxonomy );
            $thumbnail_id = get_term_meta ( $term->term_id, 'thumbnail_id', true );
            $image_attributes = wp_get_attachment_image_src( $thumbnail_id );
            $cat_img = ( !empty( $image_attributes[0] ) ? $image_attributes[0] : esc_url( get_template_directory_uri() ) . '/images/mthumb.png' );
            $output .= '<li class="dina-cat-thumb item '. $di_data['prod_hover'] .'">
                                <a class="dina-cat-link" href="'. $term_link .'" title="'. $term->name .'">
                                    <div class="dina-cat-img-con">
                                        <img width="150" height="150" src="'. $cat_img .'" class="dina-cat-img" alt="'. $term->name .'">
                                    </div>
                                    <span class="dina-cat-title">'. $term->name .'</span>
                                </a>
                        </li>';
        }

        $output . '</ul>';

        $output .= '</div></div>';
    
        echo $output;
}

remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close' );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart' ); 

if ( ! function_exists( 'dina_widget_get_current_page_url' ) ) {
	function dina_widget_get_current_page_url( $link ) {
		if ( isset( $_GET['stock_status'] ) ) {
			$link = add_query_arg( 'stock_status', wc_clean( $_GET['stock_status'] ), $link );
		}

        if ( isset( $_GET['product_brand'] ) ) {
			$link = add_query_arg( 'product_brand', wc_clean( $_GET['product_brand'] ), $link );
		}

        if ( isset( $_GET['dprod_cat'] ) ) {
			$link = add_query_arg( 'dprod_cat', wc_clean( $_GET['dprod_cat'] ), $link );
		}

		return $link;
	}

	add_filter( 'woocommerce_widget_get_current_page_url', 'dina_widget_get_current_page_url' );
}

//Dina Get base shop page link
if ( ! function_exists( 'dina_shop_page_link' ) ) {
	function dina_shop_page_link( $keep_query = false, $taxonomy = '' ) {
		// Base Link decided by current page
		$link = '';
        
		if ( class_exists( 'Automattic\Jetpack\Constants' ) && Automattic\Jetpack\Constants::is_defined( 'SHOP_IS_ON_FRONT' ) ) {
			$link = home_url();
		} elseif ( is_post_type_archive( 'product' ) || is_page( wc_get_page_id( 'shop' ) ) || is_shop() ) {
			$link = get_permalink( wc_get_page_id( 'shop' ) );
		} elseif ( is_product_category() ) {
			$link = get_term_link( get_query_var( 'product_cat' ), 'product_cat' );
		} elseif ( is_product_tag() ) {
			$link = get_term_link( get_query_var( 'product_tag' ), 'product_tag' );
		} elseif ( get_queried_object() ) {
			$queried_object = get_queried_object();

			if ( property_exists( $queried_object, 'taxonomy' ) ) {
				$link = get_term_link( $queried_object->slug, $queried_object->taxonomy );
			}
		}

		if ( $keep_query ) {

			// Min/Max
			if ( isset( $_GET['min_price'] ) ) {
				$link = add_query_arg( 'min_price', wc_clean( $_GET['min_price'] ), $link );
			}

			if ( isset( $_GET['max_price'] ) ) {
				$link = add_query_arg( 'max_price', wc_clean( $_GET['max_price'] ), $link );
			}

			// Orderby
			if ( isset( $_GET['orderby'] ) ) {
				$link = add_query_arg( 'orderby', wc_clean( $_GET['orderby'] ), $link );
			}

			if ( isset( $_GET['stock_status'] ) ) {
				$link = add_query_arg( 'stock_status', wc_clean( $_GET['stock_status'] ), $link );
			}

            if ( isset( $_GET['product_brand'] ) ) {
				$link = add_query_arg( 'product_brand', wc_clean( $_GET['product_brand'] ), $link );
			}

            if ( isset( $_GET['dprod_cat'] ) ) {
				$link = add_query_arg( 'dprod_cat', wc_clean( $_GET['dprod_cat'] ), $link );
			}

			if ( isset( $_GET['per_row'] ) ) {
				$link = add_query_arg( 'per_row', wc_clean( $_GET['per_row'] ), $link );
			}

			if ( isset( $_GET['per_page'] ) ) {
				$link = add_query_arg( 'per_page', wc_clean( $_GET['per_page'] ), $link );
			}

			if ( isset( $_GET['shop_view'] ) ) {
				$link = add_query_arg( 'shop_view', wc_clean( $_GET['shop_view'] ), $link );
			}

			if ( isset( $_GET['shortcode'] ) ) {
				$link = add_query_arg( 'shortcode', wc_clean( $_GET['shortcode'] ), $link );
			}

			/**
			 * Search Arg.
			 * To support quote characters, first they are decoded from &quot; entities, then URL encoded.
			 */
			if ( get_search_query() ) {
				$link = add_query_arg( 's', rawurlencode( wp_specialchars_decode( get_search_query() ) ), $link );
			}

			// Post Type Arg
			if ( isset( $_GET['post_type'] ) ) {
				$link = add_query_arg( 'post_type', wc_clean( wp_unslash( $_GET['post_type'] ) ), $link );

				// Prevent post type and page id when pretty permalinks are disabled.
				if ( is_shop() ) {
					$link = remove_query_arg( 'page_id', $link );
				}
			}

			// Min Rating Arg
			if ( isset( $_GET['min_rating'] ) ) {
				$link = add_query_arg( 'min_rating', wc_clean( $_GET['min_rating'] ), $link );
			}

			// All current filters
			if ( $_chosen_attributes = WC_Query::get_layered_nav_chosen_attributes() ) {
				foreach ( $_chosen_attributes as $name => $data ) {
					if ( $name === $taxonomy ) {
						continue;
					}
					$filter_name = sanitize_title( str_replace( 'pa_', '', $name ) );
					if ( ! empty( $data['terms'] ) ) {
						$link = add_query_arg( 'filter_' . $filter_name, implode( ',', $data['terms'] ), $link );
					}
					if ( 'or' == $data['query_type'] ) {
						$link = add_query_arg( 'query_type_' . $filter_name, 'or', $link );
					}
				}
			}
		}

		$link = apply_filters( 'dina_shop_page_link', $link, $keep_query, $taxonomy );

		if ( is_string( $link ) ) {
			return $link;
		} else {
			return '';
		}
	}
}

//Dina shop filter query
add_action( 'woocommerce_product_query', 'dina_shop_filter_query' );
if ( ! function_exists( 'dina_shop_filter_query' ) ) {
    function dina_shop_filter_query( $q ){
    global $di_data;
    if ( ( ( is_woocommerce() && is_archive() ) || is_shop() ) ) {
    
        $current_stock_status = isset( $_GET['stock_status'] ) ? explode( ',', $_GET['stock_status'] ) : array();
        $product_brand = isset( $_GET['product_brand'] ) ? explode( ',', $_GET['product_brand'] ) : array();
        $product_cat = isset( $_GET['dprod_cat'] ) ? explode( ',', $_GET['dprod_cat'] ) : array();
            
            if( in_array( 'onsale', $current_stock_status ) ) {
                $product_ids_on_sale = wc_get_product_ids_on_sale();
                $q->set( 'post__in', $product_ids_on_sale );
            }

            if( in_array( 'instock', $current_stock_status ) ) {
                $query_array = array(
                    'relation' => 'AND',
                    array(
                        'key' => '_stock_status',
                        'value' => 'instock',
                        'compare' => '=',
                    )
                );
                $q->set( 'meta_query', $query_array );
            }

            if( !empty( $product_brand ) ) {
                $tax_query = array(
                    'relation' => 'AND',
                    array(
                        'taxonomy' => $di_data['product_brand_taxonomy'],
                        'field' => 'term_id',
                        'terms' => $product_brand,
                    )
                );
                $q->set( 'tax_query', $tax_query );
            }

            if( !empty( $product_cat ) ) {
                $tax_query = array(
                    'relation' => 'AND',
                    array(
                        'taxonomy' => 'product_cat',
                        'field' => 'term_id',
                        'terms' => $product_cat,
                    )
                );
                $q->set( 'tax_query', $tax_query );
            }
        }
    }
}

//Set template of Woocomemrce MyAccount
add_filter( 'page_template', 'dina_my_account_page_template' );
function dina_my_account_page_template( $page_template ) {
    $post_id = get_the_ID();
    if ( $post_id === (int)get_option('woocommerce_myaccount_page_id' ) ) {
        $page_template = get_stylesheet_directory() . '/tpls/my-account.php'; 
    }
    return $page_template;
}

//Set template of Cart & Checkout pages
if ( $di_data['show_checkout_steps'] ) {
    add_filter( 'page_template', 'dina_cart_checkout_page_template' );
}
function dina_cart_checkout_page_template( $page_template ) {
    if ( is_cart() || is_checkout() ) {
        $page_template = get_stylesheet_directory() . '/tpls/cart.php'; 
    }
    return $page_template;
}

//Dina Checkout Steps
add_action( 'dina_before_cart_check', 'dina_checkout_steps', 10 );
if( ! function_exists( 'dina_checkout_steps' ) ) {
	function dina_checkout_steps() {
		?>

        <div class="dina-checkout-steps shadow-box">
            <div class="row d-flex justify-content-center">
                <div class="progressbar-con col-12">
                    <ul id="progressbar" class="text-center">
                        <li class="active step dina-step-cart"></li>
                        <li class="<?php echo ( is_checkout() ) ? 'active ' : ''; ?>step dina-step-checkout"></li>
                        <li class="<?php echo ( is_checkout() && is_order_received_page() ) ? 'active ' : ''; ?>step dina-step-complete"></li>
                    </ul>
                </div>
            </div>
            <div class="row justify-content-between">
                <div class="col d-flex justify-content-center">
                    <a href="<?php echo esc_url( wc_get_cart_url() ); ?>" title="<?php _e( 'Shopping cart', 'dina-kala'); ?>">
                        <?php _e( '1. Shopping cart', 'dina-kala'); ?>
                    </a>
                </div>
                <div class="col d-flex justify-content-center">
                    <a href="<?php echo esc_url( wc_get_checkout_url() ); ?>" title="<?php _e( 'Checkout', 'dina-kala'); ?>">
                        <?php _e( '2. Checkout', 'dina-kala'); ?>
                    </a>
                </div>
                <div class="col d-flex justify-content-center">
                    <?php _e( '3. Order complete', 'dina-kala'); ?>
                </div>
            </div>
        </div>
    

		<?php
	}
}

//Dina track product views.
add_action( 'template_redirect', 'dina_track_product_view', 20 );
if( ! function_exists( 'dina_track_product_view' ) ) {
    function dina_track_product_view() {
        if ( ! is_singular( 'product' ) ) {
            return;
        }

        global $post;

        if ( empty( $_COOKIE['dina_recently_viewed'] ) ) {
            $viewed_products = array();
        } else {
            $viewed_products = wp_parse_id_list( (array) explode( '|', wp_unslash( $_COOKIE['dina_recently_viewed'] ) ) );
        }

        // Unset if already in viewed products list.
        $keys = array_flip( $viewed_products );

        if ( isset( $keys[ $post->ID ] ) ) {
            unset( $viewed_products[ $keys[ $post->ID ] ] );
        }

        $viewed_products[] = $post->ID;

        if ( count( $viewed_products ) > 15 ) {
            array_shift( $viewed_products );
        }

        // Store for session only.
        wc_setcookie( 'dina_recently_viewed', implode( '|', $viewed_products ) );
    }
}

//dina_scheduled_sale_products
function dina_scheduled_sale_products($no_of_items=10,$app_ver=''){

    global $wpdb, $woocommerce;

    $productdata = array();

    $qur = "SELECT posts.ID, posts.post_parent
    FROM $wpdb->posts posts
    INNER JOIN $wpdb->postmeta ON (posts.ID = $wpdb->postmeta.post_id)
    INNER JOIN $wpdb->postmeta AS mt1 ON (posts.ID = mt1.post_id)
    WHERE
        posts.post_status = 'publish'
        AND  (mt1.meta_key = '_sale_price_dates_to' AND mt1.meta_value >= ".time().")

        GROUP BY posts.ID
        ORDER BY rand()";

    $product_ids_raw = $wpdb->get_results( $qur );

    $product_ids_on_sale = array();


    foreach ( $product_ids_raw as $product_raw )
    {
        if(!empty($product_raw->post_parent))
        {
            $product_ids_on_sale[] = $product_raw->post_parent;
        }
        else
        {
            $product_ids_on_sale[] = $product_raw->ID;
        }
    }
    $product_ids_on_sale = array_unique($product_ids_on_sale);

    return $product_ids_on_sale;
}

//dina_archive_add_cart
function dina_archive_add_cart(){
    global $di_data;
    global $product;

    if ( ! $product->is_purchasable() ) {
        return;
    }

    if ( $product->is_in_stock() ) {  ?>
    
	<div class="dina-add-cart-archive<?php echo $di_data['show_hover_btns_fixed'] ? ' btn-buy-fixed' : ''; echo $di_data['hover_btns_fixed_mobile'] ? ' btn-buy-fixed-mobile' : ''; ?>">

		<?php
		woocommerce_quantity_input(
			array(
				'min_value'   => apply_filters( 'woocommerce_quantity_input_min', $product->get_min_purchase_quantity(), $product ),
				'max_value'   => apply_filters( 'woocommerce_quantity_input_max', $product->get_max_purchase_quantity(), $product ),
				'input_value' => isset( $_POST['quantity'] ) ? wc_stock_amount( wp_unslash( $_POST['quantity'] ) ) : $product->get_min_purchase_quantity(), // WPCS: CSRF ok, input var ok.
			)
		);
		

        echo sprintf( '<a href="%s" data-quantity="1" class="%s" %s>%s</a>',
                esc_url( $product->add_to_cart_url() ),
                esc_attr( implode( ' ', array_filter( array(
                    'btn', 'btn-success', 'btn-buy', 'button', 'product_type_' . $product->get_type(),
                    $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                    $product->supports( 'ajax_add_to_cart' ) ? 'ajax_add_to_cart' : '',
                ) ) ) ),
                wc_implode_html_attributes( array(
                    'data-product_id'  => $product->get_id(),
                    'data-product_sku' => $product->get_sku(),
                    'aria-label'       => $product->add_to_cart_description(),
                    'rel'              => 'nofollow',
                ) ),
                '<span>' . esc_html( $product->add_to_cart_text() ) . '</span>'
            );
        ?>

	</div>

<?php }
}

//remove brand name from breadcrumb
add_filter('woocommerce_get_breadcrumb', 'remove_shop_crumb', 20, 2);
function remove_shop_crumb($crumbs, $breadcrumb)
{
    $new_crumbs = array();
    foreach ($crumbs as $key => $crumb) {
        if ( $crumb[0] !== 'برند' && $crumb[0] !== 'brand' ) {
            $new_crumbs[] = $crumb;
        }
    }
    return $new_crumbs;
}