<?php

if( class_exists( 'WeDevs_Dokan' ) ) { 
    remove_action( 'woocommerce_account_dashboard', 'dokan_set_go_to_vendor_dashboard_btn' );
}

add_action( 'woocommerce_account_dashboard', 'dina_dashboard_content' );
if( ! function_exists( 'dina_dashboard_content' ) ) {
    function dina_dashboard_content() {
        global $di_data; ?>
        
        <ul class="dina-dashboard-stats row">
            <li class="col-lg-3 col-md-6 col-12">
                <div class="dina-dashboard-stat-con shadow-box">
                    <i class="fal fa-shopping-cart"></i>
                    <span class="col dina-stats-con d-flex">
                        <span class="dina-dashboard-stats-count">
                            <?php echo dina_get_customer_total_order( get_current_user_id() ); ?>
                        </span>
                        <span class="dina-dashboard-stats-title">
                            <?php _e( 'Total Orders', 'dina-kala' ); ?>
                        </span>
                    </span>
                </div>
            </li>

            <li class="col-lg-3 col-md-6 col-12">
                <div class="dina-dashboard-stat-con shadow-box">
                    <i class="fal fa-box-check"></i>
                    <span class="col dina-stats-con d-flex">
                        <span class="dina-dashboard-stats-count">
                            <?php echo dina_get_customer_completed_order( get_current_user_id() ); ?>
                        </span>
                        <span class="dina-dashboard-stats-title">
                            <?php _e( 'Completed orders', 'dina-kala' ); ?>
                        </span>
                    </span>
                </div>
            </li>

            <?php if ( class_exists( 'WooWallet' ) ) { ?>
            <li class="col-lg-3 col-md-6 col-12">
                <div class="dina-dashboard-stat-con shadow-box">
                    <i class="fal fa-wallet"></i>
                    <span class="col dina-stats-con d-flex">
                        <span class="dina-dashboard-stats-count">
                            <?php
                            $wallet = woo_wallet()->wallet->get_wallet_balance( get_current_user_id() );
                            echo $wallet; ?>
                        </span>
                        <span class="dina-dashboard-stats-title">
                            <?php _e( 'Wallet Inventory', 'dina-kala' ); ?>
                        </span>
                    </span>
                </div>
            </li>
            <?php } ?>

            <li class="col-lg-3 col-md-6 col-12">
                <div class="dina-dashboard-stat-con shadow-box">
                    <i class="fal fa-user-plus"></i>
                    <span class="col dina-stats-con d-flex">
                        <span class="dina-dashboard-stats-count">
                            <?php echo dina_register_date( get_current_user_id() ); ?>
                        </span>
                        <span class="dina-dashboard-stats-title">
                            <?php _e( 'Registration date', 'dina-kala' ); ?>
                        </span>
                    </span>
                </div>
            </li>

        </ul>
        
        <?php if ( $di_data['show_dashboard_message'] ) { ?>
            <div class="row dina-dashbord-message">
                <div class="col-12">
                    
                    <?php if ( ! empty( $di_data['dashboard_message_one'] ) ) { ?>
                        <div class="woocommerce-message" role="alert">
                            <?php echo $di_data['dashboard_message_one'] ?>
                        </div>
                    <?php } ?>

                    <?php if ( ! empty( $di_data['dashboard_message_two'] ) ) { ?>
                        <div class="woocommerce-info" role="alert">
                            <?php echo $di_data['dashboard_message_two'] ?>
                        </div>
                    <?php } ?>

                    <?php if ( ! empty( $di_data['dashboard_message_three'] ) ) { ?>
                        <div class="woocommerce-error" role="alert">
                            <?php echo $di_data['dashboard_message_three'] ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        <?php } ?>

        <ul class="dina-dashbord-items row">
            <?php foreach ( wc_get_account_menu_items() as $endpoint => $label ) :
                if ( $endpoint != 'dashboard' ) { ?>
                <li class="col-sm-4 col-6 <?php echo wc_get_account_menu_item_classes( $endpoint ); ?>">
                    <a href="<?php echo esc_url( wc_get_account_endpoint_url( $endpoint ) ); ?>" class="shadow-box">
                        <?php echo esc_html( $label ); ?>
                    </a>
                </li>
            <?php } 
            endforeach; ?>
        
            <?php if ( class_exists('WUPPAutoloader') ) { ?>
                <li class="col-sm-4 col-6 woocommerce-MyAccount-navigation-link woocommerce-MyAccount-navigation-link--customer-logout">
                    <a href="<?php echo wp_logout_url( home_url() ); ?>" class="shadow-box">
                        <?php _e('Logout', 'dina-kala'); ?>
                    </a>
                </li>
            <?php } ?>
        </ul>
<?php }
}

//Dina Get Customer's Orders Value
function dina_get_customer_total_order( $id ) {
    $customer_orders = get_posts( array(
        'numberposts' => - 1,
        'meta_key'    => '_customer_user',
        'meta_value'  => $id,
        'post_type'   => array( 'shop_order' ),
        'post_status' => array( 'wc-completed' )
    ) );

    $total = 0;
    foreach ( $customer_orders as $customer_order ) {
        $order = wc_get_order( $customer_order );
        $total += $order->get_total();
    }

    $total = wc_price( $total );

    return $total;
}

//Dina Get Customer's Orders
function dina_get_customer_completed_order( $id ) {
    $customer_orders = get_posts( array(
        'numberposts' => - 1,
        'meta_key'    => '_customer_user',
        'meta_value'  => $id,
        'post_type'   => array( 'shop_order' ),
        'post_status' => array( 'wc-completed' )
    ) );

    $total = 0;
    foreach ( $customer_orders as $customer_order ) {
        $order = wc_get_order( $customer_order );
        $total += 1;
    }

    $total = $total . __( ' Order(s)', 'dina-kala' );

    return $total;
}

//Dina Registration Date 
function dina_register_date( $author ) {
    $user_reg = strtotime( get_the_author_meta( 'user_registered', $author ) );
    if ( function_exists( 'parsidate' ) ) {
		echo parsidate( 'j F Y', get_the_author_meta( 'user_registered', $author ),$lang='per' );
	} elseif ( function_exists( 'wp_date' ) ) {
		echo wp_date( 'j F Y', $user_reg,null);
    } else {
		echo date( 'j F Y' );
	}
}

//Add Affiliate link to my account page
if( class_exists( 'Affiliate_WP' ) ) {
    add_filter ( 'woocommerce_account_menu_items', 'affiliate_one_more_link' );
    function affiliate_one_more_link( $menu_links ){
        // we will hook "affiliate-wp" later
        $new = array( 'affiliate-wp' => __('Affiliates' , 'dina-kala') ); 
        // or in case you need 2 links
        // $new = array( 'link1' => 'Link 1', 'link2' => 'Link 2' );
    
        // array_slice() is good when you want to add an element between the other ones
        $menu_links = array_slice( $menu_links, 0, 5, true ) 
        + $new 
        + array_slice( $menu_links, 1, NULL, true );
        return $menu_links;
    }
    add_filter( 'woocommerce_get_endpoint_url', 'affiliate_hook_endpoint', 5, 4 );
    function affiliate_hook_endpoint( $url, $endpoint, $value, $permalink ){
        if( $endpoint === 'affiliate-wp' ) {
            // ok, here is the place for your custom URL, it could be external
            $url = esc_url( affwp_get_affiliate_area_page_url() );
        }
        return $url;
    }
}

//Add Wishlist link to my account page
if ( class_exists('YITH_WCWL') || class_exists( 'JVM_WooCommerce_Wishlist' ) ) {
    add_filter ( 'woocommerce_account_menu_items', 'dina_wishlist_link' );
    add_filter( 'woocommerce_get_endpoint_url', 'dina_wishlist_link_endpoint', 5, 4 );
}

function dina_wishlist_link( $menu_links ){
    $new = array( 'dina-wishlist-link' => __('Wishlist' , 'dina-kala') ); 
    $menu_links = array_slice( $menu_links, 0, 5, true ) 
    + $new 
    + array_slice( $menu_links, 1, NULL, true );
    return $menu_links;
}

function dina_wishlist_link_endpoint( $url, $endpoint, $value, $permalink ){
    if( $endpoint === 'dina-wishlist-link' ) {
        if ( class_exists('YITH_WCWL') ) {
            $url = esc_url( YITH_WCWL()->get_wishlist_url() );
        } elseif( class_exists( 'JVM_WooCommerce_Wishlist' ) ) {
            $url = jvm_get_wishlist_url();
        }
    }
    return $url;
}


//Add thrid custom link to my account page
if ( $di_data['dashboard_link_three'] ) {
    add_filter ( 'woocommerce_account_menu_items', 'dina_dashboard_link_three' );
    function dina_dashboard_link_three( $menu_links ) {
        global $di_data;
        $new = array( 'dina-dashboard-link-three' => $di_data['dashboard_link_three_title'] ); 
        $menu_links = array_slice( $menu_links, 0, 1, true ) 
        + $new 
        + array_slice( $menu_links, 1, NULL, true );
        return $menu_links;
    }

    add_filter( 'woocommerce_get_endpoint_url', 'dina_dashboard_link_three_endpoint', 10, 4 );
    function dina_dashboard_link_three_endpoint( $url, $endpoint, $value, $permalink ) {
        global $di_data;
        if ( $endpoint === 'dina-dashboard-link-three' ) {
            $url = esc_url( $di_data['dashboard_link_three_url'] );
        }
        return $url;
    }
}

//Add second custom link to my account page
if ( $di_data['dashboard_link_two'] ) {
    add_filter ( 'woocommerce_account_menu_items', 'dina_dashboard_link_two' );
    function dina_dashboard_link_two( $menu_links ) {
        global $di_data;
        $new = array( 'dina-dashboard-link-two' => $di_data['dashboard_link_two_title'] ); 
        $menu_links = array_slice( $menu_links, 0, 1, true ) 
        + $new 
        + array_slice( $menu_links, 1, NULL, true );
        return $menu_links;
    }

    add_filter( 'woocommerce_get_endpoint_url', 'dina_dashboard_link_two_endpoint', 10, 4 );
    function dina_dashboard_link_two_endpoint( $url, $endpoint, $value, $permalink ) {
        global $di_data;
        if ( $endpoint === 'dina-dashboard-link-two' ) {
            $url = esc_url( $di_data['dashboard_link_two_url'] );
        }
        return $url;
    }
}

//Add first custom link to my account page
if ( $di_data['dashboard_link_one'] ) {
    add_filter ( 'woocommerce_account_menu_items', 'dina_dashboard_link_one' );
    function dina_dashboard_link_one( $menu_links ) {
        global $di_data;
        $new = array( 'dina-dashboard-link-one' => $di_data['dashboard_link_one_title'] ); 
        $menu_links = array_slice( $menu_links, 0, 1, true ) 
        + $new 
        + array_slice( $menu_links, 1, NULL, true );
        return $menu_links;
    }

    add_filter( 'woocommerce_get_endpoint_url', 'dina_dashboard_link_one_endpoint', 10, 4 );
    function dina_dashboard_link_one_endpoint( $url, $endpoint, $value, $permalink ) {
        global $di_data;
        if ( $endpoint === 'dina-dashboard-link-one' ) {
            $url = esc_url( $di_data['dashboard_link_one_url'] );
        }
        return $url;
    }
}