<?php 

// Exit if accessed directly
if (!defined('ABSPATH') ) {
    exit;
}

global $di_data;

require_once DI_DIR . '/includes/mobile-nav-bar.php';

//Dina Footer Codes
add_action( 'wp_footer', 'dina_footer_codes' );

if ( $di_data['maintenance'] && ! current_user_can('administrator') )
{
    remove_action( 'wp_footer', 'dina_footer_codes' );
}

function dina_footer_codes() {
    global $di_data;
    if ( ! is_admin() ) { ?>
    <div class="overlay-blur"></div>

    <?php
    if ( $di_data['mobile_sticky_add'] && is_singular('product') && dina_check_product_purchasable() ) { 
        dina_mobile_sticky_add();
    }
    ?>

    <?php if ( ! $di_data['hide_mobile_bar'] ) { 
        $mftitle = $di_data['mobile_bar_title']; ?>
        <div class="mobile-footer">
            <ul>
            <?php 
                $i = 0;
                foreach( $di_data['mobile_bar_btns'] as $btn ) {
                    if ($i++ > 4) break;
                    switch ( $btn ) {
                        case 'back-top':
                            dina_nav_back_top_btn( $mftitle );
                            break;
                        case 'wishlist':
                            dina_nav_wishlist_btn( $mftitle );
                            break;
                        case 'home-add-cart':
                            dina_nav_home_buy_btn( $mftitle );
                            break;
                        case 'compare-btn':
                            dina_nav_compare_btn( $mftitle );
                            break;
                        case 'cart-btn':
                            dina_nav_cart_btn( $mftitle );
                            break;
                        case 'my-account':
                            dina_nav_my_account_btn( $mftitle );
                            break;
                        case 'menu':
                            dina_nav_menu_btn( $mftitle );
                            break;
                        case 'custom-btn-one':
                            dina_nav_custom_btn_one( $mftitle );
                            break;
                        case 'custom-btn-two':
                            dina_nav_custom_btn_two( $mftitle );
                            break;
                    }
                }
            ?>
            </ul>
        </div>
    <?php } ?>

    <?php if( $di_data['show_alert_app'] ) { ?>
        <div class="alert alert-dark alert-app alert-dismissible fade show" role="alert">
            <button type="button" class="alert-app-close close" data-dismiss="alert" aria-label="Close">
                <i class="fal fa-times" aria-hidden="true"></i>
            </button>
            <span class="alert-app-title">
                <?php echo $di_data['alert_app_title']; ?>
            </span>
            <?php if( $di_data['and_link'] != '') { ?>
                <a href="<?php echo $di_data['and_link']; ?>" rel="nofollow" class="btn btn-success and-btn"><i class="fab fa-android" aria-hidden="true"></i><?php _e(' Android' , 'dina-kala'); ?></a>
                <?php } ?>
                <?php if( $di_data['ios_link'] != '') { ?>
                <a href="<?php echo $di_data['ios_link']; ?>" rel="nofollow" class="btn btn-secondary ios-btn"><i class="fab fa-apple" aria-hidden="true"></i> <?php _e(' IOS' , 'dina-kala'); ?></a>
            <?php } ?>
        </div>
    <?php } ?>

    <?php if( $di_data['show_return_top'] && !$di_data['return_top_style_two'] ) { ?>
    <div id="back-top">
        <a href="#top">
            <i class="fal fa-chevron-up" aria-hidden="true"></i>
        </a>
    </div>
    <?php } ?>

    <?php if ( $di_data['show_social_btn'] ) {
        $social_side = ($di_data['social_btn_left']?' social-right':' social-left'); ?>
    <div class="di-socialbtn<?php if( $di_data['social_btn_mobile'] ) {echo ' social-mobile';} echo $social_side;?>">

        <?php
        if ( $di_data['social_btn_fix_title'] ) {
            $tooltip = ''; ?>
            <span class="di-socialbtn-title">
                <?php echo $di_data['social_btn_title']; ?>
            </span>
        <?php
        } else {
            $tooltip = ' data-title="'. $di_data['social_btn_title'] .'" data-toggle="tooltip" data-placement="top" ';
        } ?>
        
        <a aria-label="<?php echo $di_data['social_btn_title']; ?>" href="<?php echo $di_data['social_btn_link']; ?>"<?php echo $tooltip; ?>title="<?php echo $di_data['social_btn_title']; ?>" target="_blank">
            <span class="di-socialbtn-one <?php echo $di_data['social_btn_icon']; ?>" aria-hidden="true"></span>
        </a>

        <?php if ( $di_data['show_second_social_btn'] ) { ?>
        <a class="di-second-socialbtn" aria-label="<?php echo $di_data['second_social_btn_title']; ?>" href="<?php echo $di_data['second_social_btn_link']; ?>" data-title="<?php echo $di_data['second_social_btn_title']; ?>" data-toggle="tooltip" data-placement="top" title="<?php echo $di_data['second_social_btn_title']; ?>" target="_blank">
            <span class="di-socialbtn-two <?php echo $di_data['second_social_btn_icon']; ?>" aria-hidden="true"></span>
        </a>
        <?php } ?>

    </div>
    <?php } ?>
    
    <?php if ( class_exists('WooCommerce') ) { ?>
    <!-- side cart -->
    <?php $side_open = ( $di_data['ajax_add_open_cart'] ? 'dina-open-side' : '' ); ?>
    <div id="mySideCart" class="sidecart <?php echo $side_open; ?>">
        <div class="side-head">
        <a href="javascript:void(0)" class="mclosebtn" aria-label="<?php _e('Close', 'dina-kala'); ?>" data-title="<?php _e('Close', 'dina-kala'); ?>" rel="nofollow" onclick="closeCart()">
            <i class="fal fa-times" aria-hidden="true"></i>
        </a>
        <div class="side-title">
             <i class="fal fa-shopping-bag" aria-hidden="true"></i> <?php _e( 'Shopping Cart', 'dina-kala' ); ?>
        </div>
        </div>

        <?php do_action( 'dina-before-side-cart' ); ?>

        <div class="widget_shopping_cart_content">
            <?php woocommerce_mini_cart() ?>
        </div>
        
        <?php do_action( 'dina-after-side-cart' ); ?>

        <i class="fal fa-bags-shopping side-icon" aria-hidden="true"></i>
    </div>
    <div id="myCanvasCart" class="overlay3" onclick="closeCart()"></div>
    <!-- side cart -->
    <?php } ?>

    <?php if( $di_data['ch_login_link'] || !is_user_logged_in() ) { ?>
    <!-- side login -->
    <div id="mySideLogin" class="sidelogin">
        <div class="side-head">
            <a href="javascript:void(0)" class="mclosebtn" aria-label="<?php _e('Close', 'dina-kala'); ?>" data-title="<?php _e('Close', 'dina-kala'); ?>" rel="nofollow" onclick="closeLogin()">
                <i class="fal fa-times" aria-hidden="true"></i>
            </a>
            <div class="side-title">
                <i class="fal fa-user-circle" aria-hidden="true"></i> <?php _e( 'Login to the site', 'dina-kala' ); ?>
            </div>
        </div>
        <?php if (function_exists('digits_version') && $di_data['digits_mode'] ) { $digits_class = ' digits-login'; } else { $digits_class='';} ?>
        <form name="login_form" class="login_form <?php echo $digits_class; ?>" id="login_form" action="#" method="post">
            <div class="row">
                <div class="col-12">
                <div class="status"></div>
                <div class="form-group">
                    <div class="input-group">
                    <div class="input-group-prepend" id="basic-addon1">
                        <span class="input-group-text">
                        <i class="fal fa-user" aria-hidden="true"></i>
                        </span>
                    </div>
                    <input name="username" type="text" class="form-control" id="username" placeholder="<?php _e('Username', 'dina-kala'); ?>" required="required" />
                    </div>
                </div>
                <div class="form-group">
                    <div class="input-group">
                    <div class="input-group-prepend" id="basic-addon2">
                        <span class="input-group-text">
                        <i class="fal fa-key" aria-hidden="true"></i>
                        </span>
                    </div>
                    <input name="password" type="password" class="form-control" id="password" placeholder="<?php _e('Password', 'dina-kala'); ?>" required="required" />
                    </div>
                </div>
                <a href="<?php echo wp_lostpassword_url(); ?>" title="<?php _e('Reset password', 'dina-kala'); ?>" class="lost-password"><?php _e('Reset password', 'dina-kala'); ?></a>
                <a <?php if( $di_data['ch_register_link'] ) { echo 'href="'.$di_data['register_link'].'"'; } else {echo 'href="'. esc_url( dina_myaccount_link() ) .'"'; } ?> class="pregisterlink"><?php _e('Create an account', 'dina-kala'); ?></a>
                <?php if( $di_data['recapcha_login'] ) { ?>
                <div class="g-recaptcha" data-sitekey="<?php echo $di_data['site_key']; ?>"></div>
                <?php } ?>
                <?php wp_nonce_field( 'ajax-login-nonce', 'security' ); ?>
                <button class="btn btn-success plogin-btn" id="loginSubmit">
                    <i class="fal fa-user" aria-hidden="true"></i><?php _e('  Login to the site', 'dina-kala'); ?>
                </button>
                </div>
            </div>
        </form>
        <i class="fal fa-user-circle side-icon" aria-hidden="true"></i>
    </div>
    <div id="myCanvasLogin" class="overlay3" onclick="closeLogin()"></div>
    <!-- side login -->
    <?php } ?>

    <?php if (is_user_logged_in() ) { ?>
    <!-- side user-menu -->
    <div id="myUmenu" class="usermenu">
        <div class="side-head">
            <a href="javascript:void(0)" class="closebtn" aria-label="<?php _e('Close', 'dina-kala'); ?>" data-title="<?php _e('Close', 'dina-kala'); ?>" rel="nofollow" onclick="closeUmenu()">
                <i class="fal fa-times" aria-hidden="true"></i>
            </a>
            <?php 
                $user = wp_get_current_user(); 
                echo get_avatar(get_current_user_id() , 65,'' ,$user->display_name ); ?>
            <span class="side-uname">
                <?php echo $user->display_name; ?>
            </span>
            <?php
            if ( class_exists('WooCommerce') && class_exists( 'WooWallet' ) )
            {       
                $wallet = woo_wallet()->wallet->get_wallet_balance( get_current_user_id() );
                echo '<span class="m-wallet">'.__('Wallet Inventory: ', 'dina-kala').$wallet.'</span>';
            }
            ?>
        </div>
        <?php if( $di_data['replace_user_menu'] && has_nav_menu('user_menu') ) { ?>
        <?php
            wp_nav_menu( array(
                'menu'              => 'user_menu',
                'theme_location'    => 'user_menu',
                'menu_class'        => 'usmenu',
                'depth'             => 1,
                'container'         => ''
                )
            );
        ?>
        <?php } elseif ( class_exists('WooCommerce') ) { ?>
            <ul class="usmenu">
                <?php get_template_part('includes/umenu'); ?>
            </ul>
        <?php } ?>
        
        <i class="fal fa-id-card side-icon" aria-hidden="true"></i>
    </div>
    <div id="myCanvasUser" class="overlay3" onclick="closeUmenu()"></div>
    <!-- side user-menu -->
    <?php } ?>

    <!-- mobile menu -->
    <div id="myNav" class="sidenav">
        <div class="side-head<?php if( $di_data['mobile_search'] ) { echo ' nsearch'; } ?>">

            <a href="javascript:void(0)" class="mclosebtn" aria-label="<?php _e('Close', 'dina-kala'); ?>" data-title="<?php _e('Close', 'dina-kala'); ?>" rel="nofollow" onclick="closeNav()">
                <i class="fal fa-times" aria-hidden="true"></i>
            </a>

            <?php if( $di_data['show_mobile_logo'] ) { ?>
                <a href="<?php echo esc_url(home_url() ); ?>" title="<?php bloginfo('name'); ?> | <?php bloginfo('description'); ?>" rel="home">
                <?php 
                    $logo_width = (!empty($di_data['site_logo']['width'] ) ) ? $di_data['site_logo']['width'] : '160';
                    $logo_height = (!empty($di_data['site_logo']['height'] ) ) ? $di_data['site_logo']['height'] : '57'; ?>
                    <img <?php if( $di_data['site_schema'] ) {?>itemprop="logo" <?php } ?> src="<?php echo dina_to_https( $di_data['site_logo']['url'] ); ?>" srcset="<?php echo dina_to_https( $di_data['site_logo_retina']['url'] ); ?> 2x" width="<?php echo $logo_width; ?>" height="<?php echo $logo_height; ?>" alt="<?php bloginfo('name'); ?> | <?php bloginfo('description'); ?>" title="<?php bloginfo('name'); ?> | <?php bloginfo('description'); ?>" class="mobile-menu-logo img-logo"/>
                </a>
            <?php } ?>

            <?php
            if( ! $di_data['mobile_search'] ) {
                if ( ! $di_data['replace_search_shortcode'] ) {
                    di_search_form( 'msform', false );
                } else {
                    echo do_shortcode( $di_data['search_shortcode'] );
                }
            }
            ?>

        </div>
        <?php
        $dina_remove_parent_link = ($di_data['remove_parent_link'] ? ' dina-remove-parent-link' : '');
        ?>                            
        <nav id="cssmenu" class="dina-mobile-menu<?php echo $dina_remove_parent_link; ?>" <?php if( $di_data['site_schema'] ) {?>itemscope itemtype="https://schema.org/SiteNavigationElement"<?php } ?>>
            <?php
            if( $di_data['replace_mobile_menu'] ) {
                wp_nav_menu(array(
                    'menu'              => 'mobile_menu',
                    'theme_location'    => 'mobile_menu',
                    'container_id'      => 'cssmenu',
                    'fallback_cb'       => 'CSS_Menu_Maker_fallback',
                    'walker' => new CSS_Menu_Maker_Walker()
                ) );
            } else {
                wp_nav_menu(array(
                    'menu'              => 'mega_menu',
                    'theme_location'    => 'mega_menu',
                    'container_id'      => 'cssmenu',
                    'fallback_cb'       => 'CSS_Menu_Maker_fallback',
                    'walker' => new CSS_Menu_Maker_Walker()
                ) );
            }
            
            ?>
       </nav>

       <i class="fal fa-file-search side-icon" aria-hidden="true"></i>

    </div>

    <div id="myCanvasNav" class="overlay3" onclick="closeNav()"></div>
    <!-- mobile menu -->
<?php } }

if(!empty($di_data['footer_codes'] ) ) {
    add_action( 'wp_footer', 'dina_js_footer_codes' );
}
function dina_js_footer_codes() { 
    global $di_data;
    print_r($di_data['footer_codes'] ) . "\n";
}

add_action( 'wp_footer', 'dina_js_gallery_codes', 100 );
function dina_js_gallery_codes() { 
    if( is_singular('product') ) { ?>
    <script>
    jQuery(document).ready(function(e){e(".flex-control-nav").addClass("owl-carousel"),e(".flex-control-nav li").addClass("item"),e(".product-ltr .flex-control-nav").owlCarousel({nav:!0,navText:["",""],autoplay:!1,autoplayHoverPause:!1,dots:!1,loop:!1,margin:5,responsiveClass:!0,responsive:{0:{items:4},341:{items:4},600:{items:5},1e3:{items:5}}}),e(".product-rtl .flex-control-nav").owlCarousel({rtl:!0,nav:!0,navText:["",""],autoplay:!1,autoplayHoverPause:!1,dots:!1,loop:!1,margin:5,responsiveClass:!0,responsive:{0:{items:4},341:{items:4},600:{items:5},1e3:{items:5}}})});
    </script>
<?php }
}

add_action( 'wp_footer', 'dina_auto_update_cart', 100 );
function dina_auto_update_cart() { 
    if ( ! class_exists('WooCommerce') ) 
        return;
    if( is_cart() ) { ?>
    <script>
    var timeout;
    jQuery( function( $ ) {
        $('.woocommerce').on('change', 'input.qty', function(){
            if ( timeout !== undefined ) {
                clearTimeout( timeout );
            }
            timeout = setTimeout(function() {
                $("[name='update_cart']").trigger("click");
            }, 1000 ); // 1 second delay, half a second (500) seems comfortable too
        });
        $('.woocommerce').on('click', "button.plus, button.minus", function(){
            if ( timeout !== undefined ) {
                clearTimeout( timeout );
            }
            timeout = setTimeout(function() {
                $("[name='update_cart']").trigger("click");
            }, 500 ); // 1 second delay, half a second (500) seems comfortable too
        });
    } );
    </script>
<?php }
}

add_action( 'wp_footer', 'dina_sticky_add_to_cart' );
function dina_sticky_add_to_cart() { 
    global $product;
    global $di_data;

    if( is_singular('product') ) {

    $coming = get_post_meta( get_the_ID(), 'dina_coming', true );

    if( $product->is_type( 'simple' ) && $di_data['show_zero_call'] && ( '' === $product->get_price() || 0 == $product->get_price() ) )
     return;

    if( !show_login_price() && !$coming && $product->is_purchasable() && $product->is_in_stock() && $di_data['show_sticky_add'] ) { ?>
    <div class="dina-sticky-add-cart">

        <div class="dina-sticky-thumb">
            <?php if ( has_post_thumbnail() ) {
                the_post_thumbnail( 'thumbnail' );
            } else { 
                prod_defualt_thumb();
            } ?>
        </div>

        <div class="dina-sticky-title">
            <?php the_title(); ?>
        </div>

        <div class="dina-sticky-price">
            <?php woocommerce_template_single_price(); ?>
        </div>

        <?php if( $product->is_type( 'simple' ) )  { ?>
            <div class="dina-sticky-add">
                <?php woocommerce_simple_add_to_cart(); ?>
            </div>
        <?php } elseif ( $product->is_type( 'variable' ) ) { ?>
            <div class="dina-sticky-add">
                <span class="single_add_to_cart_button button alt go-to-add">
                    <?php _e('Select options' , 'dina-kala'); ?>
                </span>
            </div>
        <?php } ?>

    </div>
<?php } }
}

//Product & Post Share Modal
add_action( 'wp_footer', 'dina_add_btn_modal' );
function dina_add_btn_modal() {
    global $post;
    global $di_data;

    if( !is_object($post) ) 
        return;

    if( is_singular('product') ) {

        $prod_title = esc_html( get_post_meta( get_the_ID(), 'dina_popup_title', true ) );
        $prod_content = dina_output_content( 'dina_popup_content', get_the_ID() );

        $popup_title = ( !empty( $prod_title ) ? $prod_title : $di_data['add_prod_popup_title'] );
        $popup_content = ( !empty( $prod_content ) ? $prod_content : do_shortcode( $di_data['add_prod_popup_text'] ) );
    ?>
    <!-- Add Btn Modal -->
    <div class="modal fade" id="addbtnModal">
        <div class="modal-dialog <?php echo $di_data['add_prod_popup_size']; ?> modal-dialog-centered">
            <div class="modal-content">

            <!-- Add Btn Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title">
                    <i aria-hidden="true" class="<?php echo $di_data['add_prod_btn_icon']; ?>"></i>
                    <?php echo $popup_title; ?>
                </h4>
                <button type="button" class="close" data-dismiss="modal">
                    <i class="fal fa-times" aria-hidden="true"></i>
                </button>
            </div>

            <!-- Add Btn Modal body -->
            <div class="modal-body">
               <?php echo $popup_content; ?>
            </div>

            </div>
        </div>
    </div>
<?php } }
 	