<?php
namespace Elementor;

class Dina_Recently_Viewed_Products extends Widget_Base {

	public function get_name() {
		return 'dina-recently-viewed-products';
	}
	
	public function get_title() {
		return __( 'Dina recently viewed products', 'dina-kala' );
	}
	
	public function get_icon() {
		return 'fal fa-eye';
	}
	
	public function get_categories() {
		return [ 'dina-kala' ];
	}
	
	protected function register_controls() {
		global $di_data;
		require get_template_directory() . '/includes/el-widgets/fa.php';
		
		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Dina recently viewed products', 'dina-kala' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'Title', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'Recently viewed products', 'dina-kala' ),
			]
		);

		$this->add_control(
			'hide_desk_title',
			[
				'label' => __( 'Hide title in desktop mode', 'dina-kala' ),
				'description' => __( 'Suitable for the case where you consider an image containing a title for the block', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'out_prod',
			[
				'label' => __( 'Show in stock products', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'product_icon',
			[
				'label' => __( 'Icon', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
			]
		);

		$this->add_control(
			'custom_icon',
			[
				'label' => __( 'Or custom icon (Suitable size: 32px by 32px)', 'dina-kala' ),
				'type' => Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'white_title',
			[
				'label' => __( 'White title (Suitable for background mode)', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'white_box',
			[
				'label' => __( 'White box style', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'show_arrows',
			[
				'label' => __( 'Show Arrows', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'auto_play',
			[
				'label' => __( 'Auto play', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'time',
			[
				'label' => __( 'Auto play speed(ms)', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1000,
				'max' => 20000,
				'step' => 1000,
				'default' => 8000,
			]
		);

		$this->add_control(
			'pause_over',
			[
				'label' => __( 'Pause slider on mouse over', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'slide_by',
			[
				'label' => __( 'Items displayed when scrolling', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 40,
				'step' => 1,
				'default' => 1,
			]
		);

		$this->add_control(
			'prod_loop',
			[
				'label' => __( 'Product loop', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'ptotalcount',
			[
				'label' => __( 'Product total count', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 200,
				'step' => 1,
				'default' => 8,
			]
		);

		$this->add_control(
			'pcount',
			[
				'label' => __( 'Slider columns count', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 6,
				'step' => 1,
				'default' => 5,
			]
		);
		
		$this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings_for_display();
		global $di_data; 

		$viewed_ids = ! empty( $_COOKIE['dina_recently_viewed'] ) ? (array) explode( '|', wp_unslash( $_COOKIE['dina_recently_viewed'] ) ) : array();
		$viewed_ids = array_reverse( array_filter( array_map( 'absint', $viewed_ids ) ) );

		if ( empty( $viewed_ids ) ) {
			echo '<div class="not-dina-recently-viewed"></div>';
			return;
		}
        
        $args = array(
			'posts_per_page' => 16,
			'no_found_rows'  => 1,
			'post_status'    => 'publish',
			'post_type'      => 'product',
			'post__in'       => $viewed_ids,
			'orderby'        => 'post__in',
		);

        $viewed_products = new \WP_Query( $args );

		if ( $viewed_products->have_posts() ) {

			$block_classes = '';
			$block_classes .= ( empty($settings['title'] ) && $di_data['prod_navs'] == 'stone' ? ' nav-type-one' : '' ); 
			$block_classes .= ( $di_data['prod_navs'] == 'sttwo' ? ' nav-type-two' : '' );
			$block_classes .= ( 'yes' === $settings['white_title'] ? ' white-title' : '' );
			$block_classes .= ( 'yes' === $settings['white_box'] ? ' white-box' : '' );
			$block_classes .= ( 'yes' === $settings['hide_desk_title'] ? ' hide-desk-title' : '' );
			$block_classes .= ( 'yes' === $settings['hide_desk_title'] && $di_data['prod_navs'] == 'stone' ? ' hide-desk-title-one' : '' ); ?>
		
			<div class="product-block dina-recently-viewed<?php echo $block_classes; ?>">

				<?php if( ! empty( $settings['title'] ) ) { ?>
					<div class="block-title">
						<h2>
							<?php if( ! empty( $settings['custom_icon']['url'] ) ) { ?>
								<img src="<?php echo $settings['custom_icon']['url']; ?>" width="32" height="32" alt="<?php echo $settings['title']; ?>" class="cust-icon">
							<?php } else { ?>
								<i class="fal fa-<?php echo $settings['product_icon']; ?>" aria-hidden="true"></i>
							<?php } ?>
							<?php echo $settings['title']; ?>
						</h2>
					</div>
				<?php } ?>
			
				<?php $mobile_col = ( $di_data['mobile_single_col'] ? 1 : 2 ); ?>
				<div class="owl-carousel" data-mcol="<?php echo $mobile_col; ?>" <?php if ( 'yes' === $settings['show_arrows'] ) { echo 'data-itemnavs="true"'; } else { echo 'data-itemnavs="false"'; } ?> <?php if ( 'yes' === $settings['prod_loop'] ) { echo 'data-itemloop="true"'; } else { echo 'data-itemloop="false"'; } ?> <?php if ( 'yes' === $settings['auto_play'] ) { echo 'data-itemplay="true"'; echo ' data-itemtime="'. $settings['time'] .'"'; } else { echo 'data-itemplay="false"'; } ?> <?php if ( 'yes' === $settings['pause_over'] ) { echo 'data-itemover="true"'; } else { echo 'data-itemover="false"'; } ?> data-itemscount="<?php echo $settings['pcount']; ?>" data-item-slideby="<?php echo $settings['slide_by']; ?>" data-dir="<?php echo dina_rtl(); ?>">
				<?php
					while ( $viewed_products->have_posts() ) : $viewed_products->the_post(); ?>
					<div class="item">
						<?php get_template_part('includes/content-product'); ?>
					</div>
					<?php endwhile; ?>
				</div>

			</div>

        <?php
		}
		
		wp_reset_postdata();
	}
}