<?php
namespace Elementor;

class Special_Offer extends Widget_Base {
	
	public function get_name() {
		return 'special-offer';
	}
	
	public function get_title() {
		return __( 'Special offer', 'dina-kala' );
	}
	
	public function get_icon() {
		return 'fal fa-star';
	}
	
	public function get_categories() {
		return [ 'dina-kala' ];
	}
	
	protected function register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Special offer', 'dina-kala' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'Title', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your title', 'dina-kala' ),
                'default' => __( 'Special offer', 'dina-kala' ),
			]
		);

		$this->add_control(
			'site_name',
			[
				'label' => __( 'Site name', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your site name', 'dina-kala' ),
                'default' => __( 'Sample', 'dina-kala' ),
			]
        );

        $this->add_control(
			'hide_no_prod',
			[
				'label' => __( 'Hide the block if there is no product', 'dina-kala' ),
				'description' => __( 'suitable for when the product discount expires', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

        $this->add_control(
			'show_dis',
			[
				'label' => __( 'Only show discounted products', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
        );
        
        $this->add_control(
			'ptotalcount',
			[
				'label' => __( 'Product total count', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 200,
				'step' => 1,
				'default' => 5,
			]
		);

        $this->add_control(
			'out_stock',
			[
				'label' => __( 'Text finished product in stock', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Out of stock!', 'dina-kala' ),
                'default' => __( 'Out of stock!', 'dina-kala' ),
			]
        );

        $this->add_control(
			'out_icon',
			[
				'label' => __( 'Show out of stock icon', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

        $this->add_control(
			'rand_prod',
			[
				'label' => __( 'Select products randomly', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

        $this->add_control(
			'auto_play',
			[
				'label' => __( 'Auto play', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
        );
        
        $this->add_control(
			'pause_over',
			[
				'label' => __( 'Pause slider on mouse over', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'time',
			[
				'label' => __( 'Auto play speed(ms)', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1000,
				'max' => 20000,
				'step' => 1000,
				'default' => 8000,
			]
		);
        
		$this->end_controls_section();
	}
	
	protected function render() {
        global $di_data;
        $settings = $this->get_settings_for_display();
        
        ?>
        
        <div class="row shadow-box special-box">
                <?php 

                   $args = array(
                   'posts_per_page' => $settings['ptotalcount'],
                   'post_type' => 'product',
                   'post_status' => 'publish',
                   'meta_query' => array(
                   'relation' => 'AND',
                    array(
                        'key' => 'dina_special',
                        'value' => 'on',
                        'compare' => '='
                    )
                    ),
                   'order' => 'DESC'  );

                    if ( 'yes' === $settings['show_dis'] ) {
                    $args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
                    }

                    if ( 'yes' === $settings['rand_prod'] ) {
                        $args['orderby'] = 'rand';
                    }

                   $specialpost = new \WP_Query( $args );

                if ( $specialpost->have_posts() ) { ?>
                <div class="col-lg-8 col-12 owl-carousel special-slider" <?php if ( 'yes' === $settings['auto_play'] ) { echo 'data-itemplay="true"'; } else { echo 'data-itemplay="false"'; } ?> <?php if ( 'yes' === $settings['pause_over'] ) { echo 'data-itemover="true"'; } else { echo 'data-itemover="false"'; } ?> data-itemtime="<?php echo $settings['time']; ?>" data-dir="<?php echo dina_rtl(); ?>">
                    <?php while ( $specialpost->have_posts() ) : $specialpost->the_post();
                    $product = wc_get_product( get_the_ID() );
                    $coming = get_post_meta( $product->get_id(), 'dina_coming', true );
                    ?>
                    
                    <div class="col-12 item">
                        <?php if( !$product->is_in_stock() ) { ?>
                        <div class="pnot-in-stock">
                            <span class="not-stock-text">
                                <?php if ( 'yes' === $settings['out_icon'] ) { ?>
                                    <i class="fal fa-frown" aria-hidden="true"></i>
                                <?php } ?>
                                <?php echo $settings['out_stock']; ?>
                            </span>
                        </div>
                        <?php } ?>
                        <?php if( ! $product->is_in_stock() ) { ?>
                            <div class="pblur">
                        <?php } ?>
                                <?php if( $product->is_on_sale() && $di_data['display_discount'] ) { ?>
                                <span class="sp-discount<?php if( $di_data['display_spec'] ) { echo ' sp-discount-sepcial';  }?>">
                                    <span>
                                        <?php if( $di_data['display_spec'] ) { ?>
                                           <?php _e( 'Special!', 'dina-kala' ); ?>
                                        <?php } elseif(is_rtl() ) { ?>
                                            ٪<?php echo disw_price(get_the_ID() ) ?> <?php _e( 'Discount', 'dina-kala' ); ?>
                                        <?php } else { ?>
                                            <?php echo disw_price(get_the_ID() ) ?>% <?php _e( 'Discount', 'dina-kala' ); ?>
                                        <?php } ?>
                                    </span>
                                </span>
                                <?php } ?>
                                <div class="col-md-4 col-12 special-img">
                                    <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                                    <?php if ( has_post_thumbnail() ) {
                                        the_post_thumbnail('woocommerce_thumbnail', ['class' => 'skip-lazy no-lazyload'] );
                                    } else { 
                                        prod_defualt_thumb();
                                    } ?>
                                    </a>
                                </div>
                                <div class="col-md-8 col-12 special-text">
                                    <div class="sp-stitle">
                                        <?php echo $settings['title']; ?> <span class="sp-red"><?php echo $settings['site_name']; ?></span>
                                    </div>
                                    <div class="col-12 sp-title">
                                        <i class="fal fa-chevron-left" aria-hidden="true"></i>
                                        <?php the_title(); ?>
                                    </div>
                                    
                                    <div class="col-12 sp-price">
                                            <?php if ( $product->is_in_stock() || $di_data['show_price_out'] || show_login_price() ) {
                                                echo $product->get_price_html();
                                            } else {
                                                _e( 'Out of stock', 'dina-kala' );
                                            } ?>
                                    </div>
                                    
                                    <?php 
                                        if ( $product -> is_type( 'variable' ) ) {
                                            $children_ids = $product->get_children();
                                            $date = '';
                                            foreach ( $children_ids as $children_id ) {
                                                if ( ! empty( $date ) )
                                                    break;
                                                $child_date = get_post_meta( $children_id, '_sale_price_dates_to', true );
                                                if ( ! empty( $child_date ) ) {
                                                    $date = $child_date;
                                                }
                                            }
                                        } else {
                                            $date = get_post_meta( get_the_ID(), '_sale_price_dates_to', true );
                                        }
                                        if(!$coming && !empty($date) && $product->is_purchasable() && $product->is_in_stock() && !show_login_price() ){
                                        $date += 24*60*60;
                                        $sale_price_date = ( $date ) ? date( 'Y/m/d', $date ) : '';
                                        $date_diff = ( $date ) ? date( 'Y-m-d', $date ) : '';
                                        $now = time(); // or your date as well
                                        $your_date = strtotime($date_diff);
                                        $diff = $your_date - $now;
                                        $datediff = round($diff / (60 * 60 * 24) ); ?>
                                    <?php if($product->is_on_sale() && !show_login_price() ) { ?>
                                    <div class="col-12">
                                        <div class="salecount" data-datediff="<?php echo $datediff; ?>" data-countdown="<?php echo $sale_price_date; ?>" data-dir="<?php echo (is_rtl() )?'rtl':'ltr';?>" data-seconds="<?php _e('Seconds' , 'dina-kala'); ?>" data-minutes="<?php _e('Minutes' , 'dina-kala'); ?>" data-hours="<?php _e('Hours' , 'dina-kala'); ?>" data-days="<?php _e('Days' , 'dina-kala'); ?>" data-weeks="<?php _e('Weeks' , 'dina-kala'); ?>"></div>
                                    </div>
                                    <?php } ?>
                                    <?php } ?>
                                    
                                    <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" class="btn btn-outline-dina sp-btn">
                                    <?php if( show_login_price() || !$product->is_purchasable() || !$product->is_in_stock() || $coming || ( !$product->is_type( 'variable' ) && $di_data['show_zero_call'] && ('' === $product->get_price() || 0 == $product->get_price() ) ) ) { ?>
                                        <i class="fal fa-eye" aria-hidden="true"></i>
                                        <?php _e( 'View Product', 'dina-kala' ); ?>
                                    <?php } else { ?>
                                        <i class="fal fa-cart-plus" aria-hidden="true"></i>
                                        <?php _e( 'Buy Product', 'dina-kala' ); ?>
                                    <?php } ?>
                                    </a>
                                </div>
                        <?php if( !$product->is_in_stock() ) { ?>
                            </div>
                        <?php } ?>
                    </div>
                    <?php endwhile; ?>
                </div>
                <div class="col-lg-4 d-none d-lg-block special-title">
                    <ul id="slider-nav">
                        <?php while ( $specialpost->have_posts() ) : $specialpost->the_post(); ?>
                        <li>
                        <?php the_title(); ?>
                        </li>
                        <?php endwhile; ?>
                    </ul>
                </div>
                <?php } else { 
                    $no_prod_class = ( 'yes' === $settings['hide_no_prod'] ? ' not-dina-timed-product' : '' );
                    echo '<div class="col-12 not-msg'. $no_prod_class .'">'.__( 'No product with the desired conditions was found.', 'dina-kala' ).'</div>';
                } ?>
            </div>
         <?php

	}

}