<?php
namespace Elementor;

class Dina_Woo_Offer extends Widget_Base {

	public function get_name() {
		return 'dina-woo-offer';
	}
	
	public function get_title() {
		return __( 'Dina Woo Offer', 'dina-kala' );
	}
	
	public function get_icon() {
		return 'fal fa-badge-percent';
	}
	
	public function get_categories() {
		return [ 'dina-kala' ];
	}
	
	protected function register_controls() {
		
		$prod_cata = array();
		$categories = get_terms("product_cat");
		if ( !empty( $categories ) && !is_wp_error( $categories ) ){
		foreach ( $categories as $category ) {
		$prod_cata[ $category->term_id ] = $category->name;
		}
		}

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Dina Woo Offer', 'dina-kala' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'Title', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'Instant Offer', 'dina-kala' ),
				'default' => __( 'Instant Offer', 'dina-kala' ),
			]
		);

		$this->add_control(
			'product_cat',
			[
				'label' => __( 'Product category', 'dina-kala' ),
				'description' => __( 'Empty categories (no product) are not displayed', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => $prod_cata,
			]
		);

		$this->add_control(
			'hide_no_prod',
			[
				'label' => __( 'Hide the block if there is no product', 'dina-kala' ),
				'description' => __( 'suitable for when the product discount expires', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'show_dis',
			[
				'label' => __( 'Only show discounted products', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
        );

		$this->add_control(
			'ptotalcount',
			[
				'label' => __( 'Product total count', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 200,
				'step' => 1,
				'default' => 5,
			]
		);

		$this->add_control(
			'time',
			[
				'label' => __( 'Auto play speed(ms)', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1000,
				'max' => 20000,
				'step' => 1000,
				'default' => 5000,
			]
		);

		$this->add_control(
			'pause_over',
			[
				'label' => __( 'Pause slider on mouse over', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->end_controls_section();
	}
	
	protected function render() {
		global $di_data;
        $settings = $this->get_settings_for_display(); ?>
        <div class="offer-block shadow-box">
			<div class="block-title">
				<h2>
					<?php echo $settings['title']; ?>
				</h2>
				<div class="slide-progress"></div>
			</div>
		<?php
			$product_cat = $settings['product_cat'];
			$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'meta_query' => array(
						array(
						'key' => '_stock_status',
						'value' => 'instock',
						'compare' => '=',
						)
                    ),
					'orderby' => 'rand',
					'fields'          => 'ids',
					'no_found_rows'   => true,
					'update_post_term_cache' => false );
			if ( 'yes' === $settings['show_dis'] ) {
				$args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
			}
			if (!empty($product_cat) ) {
				$args['tax_query'] = array(
					array(
					'taxonomy' => 'product_cat',
					'field' => 'term_id',
					'terms' => $product_cat
					)
				);
			}
			$offerquery = new \WP_Query( $args );
		?>
		
		<?php if ( $offerquery->have_posts() ) { ?>
		<div class="owl-carousel" data-itemtime="<?php echo $settings['time']; ?>" <?php if ( 'yes' === $settings['pause_over'] ) { echo 'data-itemover="true"'; } else { echo 'data-itemover="false"'; } ?> data-dir="<?php echo dina_rtl(); ?>">
        <?php while ( $offerquery->have_posts() ) : $offerquery->the_post();
		global $product; ?>
			<div class="item">
				<div class="mini-product">
					<?php $link_target = ($di_data['open_prod_new_tab'] ? '_blank' : '_self'); ?>
					<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" class="product-link" target="<?php echo $link_target; ?>">
						<?php if ( has_post_thumbnail() ) {
							the_post_thumbnail('woocommerce_thumbnail', ['class' => 'skip-lazy no-lazyload'] );
						} else { 
							prod_defualt_thumb();
						} ?>
						<?php if($product->is_on_sale() ) { ?>
						<?php echo dina_dis_price(get_the_ID() ); ?>
						<?php } ?>
						<?php echo dina_product_label(get_the_ID() ); ?>
						<span class="product-title">
							<?php the_title(); ?>
						</span>
						<span class="product-price">
							<span class="price-con product-not-on-sale">
							<?php if( $product->is_in_stock() || $di_data['show_price_out'] || show_login_price() ) { ?>
								<?php echo $product->get_price_html(); ?>
							<?php } else { ?>
								<?php _e( 'Out of stock', 'dina-kala' ); ?>
							<?php } ?>
							</span>
						</span>
					</a>
				</div>
			</div>
        <?php endwhile; ?>
        </div>

		<?php 
		} else {		
			$no_prod_class = ( 'yes' === $settings['hide_no_prod'] ? ' not-dina-timed-product' : '' );
		echo '<div class="col-12 not-msg'. $no_prod_class .'">'.__( 'No product with the desired conditions was found.', 'dina-kala' ).'</div>';}
		wp_reset_postdata();
		?>
        </div>
        <?php
	}
}