<?php
namespace Elementor;

class Dina_Daily_Slider extends Widget_Base {
	
	public function get_name() {
		return 'dina-daily-slider';
	}
	
	public function get_title() {
		return __( 'Daily Slider', 'dina-kala' );
	}
	
	public function get_icon() {
		return 'fal fa-images';
	}
	
	public function get_categories() {
		return [ 'dina-kala' ];
	}
	
	protected function register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Daily Slider', 'dina-kala' ),
			]
		);

		$this->add_control(
			'important_note',
			[
				'label' => __( 'Important Note:', 'dina-kala' ),
				'type' => Controls_Manager::RAW_HTML,
				'raw' => __( 'This widget displays as many random slides as you specify. You must add at least two slides.', 'dina-kala' ),
				'content_classes' => 'your-class',
			]
		);
		
		$slider = new Repeater();

		$slider->add_control(
			'slide_title', [
				'label' => __( 'Slide title', 'dina-kala' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);

		$slider->add_control(
			'slide_link',
			[
				'label' => __( 'Slide link', 'dina-kala' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'dina-kala' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => true,
					'nofollow' => false,
				],
			]
        );
        
        $slider->add_control(
			'slide_image',
			[
				'label' => __( 'Choose Image', 'dina-kala' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'slides',
			[
				'label' => __( 'Sliders', 'dina-kala' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $slider->get_controls(),
				'default' => [
					[
						'slide_title' => __( 'Slide title', 'dina-kala' ),
						'slide_link' => __( 'https://your-link.com', 'dina-kala' ),
					],
				],
				'title_field' => '{{{ slide_title }}}',
			]
		);

		$this->add_control(
			'slides_count',
			[
				'label' => __( 'Number of slides', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 2,
				'max' => 200,
				'step' => 1,
				'default' => 2,
			]
		);

		$this->add_control(
			'show_arrows',
			[
				'label' => __( 'Show arrows', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'auto_play',
			[
				'label' => __( 'Auto play', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'time',
			[
				'label' => __( 'Auto play speed(ms)', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1000,
				'max' => 20000,
				'step' => 1000,
				'default' => 8000,
			]
		);

		$this->add_control(
			'show_dots',
			[
				'label' => __( 'Show navigation\'s dots', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'pause_over',
			[
				'label' => __( 'Pause slider on mouse over', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'show_titles',
			[
				'label' => __( 'Show slide titles instead of navigation points', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
        
		$this->end_controls_section();
	}
	
	protected function render() {
        $settings = $this->get_settings_for_display();
		?>

		<!-- start slider -->
		<div class="scon shadow-box">
			<?php
				$daily_slides = $settings['slides'];
				$slides_count = $settings['slides_count'];
				add_option( 'dina_daily_slides', $daily_slides, '', 'yes' );
				add_option( 'dina_daily_slides_count', $slides_count, '', 'yes' );
	
				if(get_option( 'dina_daily_slides' ) != $daily_slides || get_option( 'dina_daily_slides_count' ) != $slides_count ) {
					delete_transient('dina_daily_slides_tr');
					update_option( 'dina_daily_slides', $daily_slides, '', 'yes' );
					update_option( 'dina_daily_slides_count', $slides_count, '', 'yes' );
				}

				if ( false === ( $random_slides = get_transient( 'dina_daily_slides_tr' ) ) ) {
				
					$random_slides = array_rand($daily_slides, $slides_count);
	
					//Now we store the array for one day.
					$timezone = get_option('timezone_string');
					date_default_timezone_set($timezone);
					$seconds_until_next_day = strtotime('tomorrow') - time();
					set_transient( 'dina_daily_slides_tr', $random_slides, $seconds_until_next_day );
				}

			?>
		<div class="slider-con owl-carousel" <?php if ( 'yes' === $settings['show_titles'] ) { echo 'data-itemdotsc="#slider-title"'; } ?> <?php if ( 'yes' === $settings['show_arrows'] ) { echo 'data-itemnavs="true"'; } else { echo 'data-itemnavs="false"'; } ?> <?php if ( 'yes' === $settings['show_dots'] ) { echo 'data-itemdots="true"'; } else { echo 'data-itemdots="false"'; } ?> <?php if ( 'yes' === $settings['auto_play'] ) { echo 'data-itemplay="true"'; echo ' data-itemtime="'. $settings['time'] .'"'; } else { echo 'data-itemplay="false"'; } ?> <?php if ( 'yes' === $settings['pause_over'] ) { echo 'data-itemover="true"'; } else { echo 'data-itemover="false"'; } ?> data-dir="<?php echo dina_rtl(); ?>">
			<?php

			if ( $random_slides ) {
				foreach (  $random_slides as $count ) {
					$item = $daily_slides[$count];
					$target = $item['slide_link']['is_external'] ? ' target="_blank"' : '';
					$nofollow = $item['slide_link']['nofollow'] ? ' rel="nofollow"' : ''; ?>
					<div class="item">
						<?php if(!empty($item['slide_link']['url'] ) ) { ?>
							<a href="<?php echo $item['slide_link']['url']; ?>" title="<?php echo $item['slide_title']; ?>"<?php if(!empty($target) ) { echo $target;} ?> <?php if(!empty($nofollow) ) { echo $nofollow;} ?>>
						<?php } 
							$image_attributes = wp_get_attachment_image_src( $item['slide_image']['id'], 'full');
						?>
								<img src="<?php echo $item['slide_image']['url']; ?>" alt="<?php echo $item['slide_title']; ?>" width="<?php echo $image_attributes[1]; ?>" height="<?php echo $image_attributes[2]; ?>" class="slider-img skip-lazy no-lazyload">
						<?php if(!empty($item['slide_link']['url'] ) ) { ?>
							</a>
						<?php } ?>
					</div>
				<?php } 
			} ?>
		</div>

		<?php if ( 'yes' === $settings['show_titles'] ) { ?>
		<div class="col-12 slider-title-outer">
			<ul id="slider-title" class="">
				<?php if ( $random_slides ) {
				foreach (  $random_slides as $count ) {
					$item = $daily_slides[$count]; ?>
					<li>
						<span class="slide-title">
							<?php echo $item['slide_title']; ?>
						</span>
					</li>
				<?php } } ?>
			</ul>
		</div>
		<?php } ?>

		</div>
		<!-- end slider -->
         <?php

	}


}