<?php
namespace Elementor;

class Dina_Dialy_Discount extends Widget_Base {

	public function get_name() {
		return 'dina-dialy-discount';
	}
	
	public function get_title() {
		return __( 'Dina daily discounted products', 'dina-kala' );
	}
	
	public function get_icon() {
		return 'fal fa-percent';
	}
	
	public function get_categories() {
		return [ 'dina-kala' ];
	}
	
	protected function register_controls() {
	require get_template_directory() . '/includes/el-widgets/fa.php';
		$prod_cata = array();
		$categories = get_terms("product_cat");
		if ( !empty( $categories ) && !is_wp_error( $categories ) ){
		foreach ( $categories as $category ) {
		$prod_cata[ $category->term_id ] = $category->name;
		}
		}
		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Dina daily discounted products', 'dina-kala' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'Title', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your title', 'dina-kala' ),
			]
		);

		$this->add_control(
			'hide_desk_title',
			[
				'label' => __( 'Hide title in desktop mode', 'dina-kala' ),
				'description' => __( 'Suitable for the case where you consider an image containing a title for the block', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'product_cat',
			[
				'label' => __( 'Product category', 'dina-kala' ),
				'description' => __( 'Empty categories (no product) are not displayed', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => $prod_cata,
			]
		);

		$this->add_control(
			'product_icon',
			[
				'label' => __( 'Icon', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
			]
		);

		$this->add_control(
			'custom_icon',
			[
				'label' => __( 'Or custom icon (Suitable size: 32px by 32px)', 'dina-kala' ),
				'type' => Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'white_title',
			[
				'label' => __( 'White title (Suitable for background mode)', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'white_box',
			[
				'label' => __( 'White box style', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'show_arrows',
			[
				'label' => __( 'Show Arrows', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'auto_play',
			[
				'label' => __( 'Auto play', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'time',
			[
				'label' => __( 'Auto play speed(ms)', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1000,
				'max' => 20000,
				'step' => 1000,
				'default' => 8000,
			]
		);

		$this->add_control(
			'pause_over',
			[
				'label' => __( 'Pause slider on mouse over', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'slide_by',
			[
				'label' => __( 'Items displayed when scrolling', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 40,
				'step' => 1,
				'default' => 1,
			]
		);

		$this->add_control(
			'prod_loop',
			[
				'label' => __( 'Product loop', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'ptotalcount',
			[
				'label' => __( 'Product total count', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 200,
				'step' => 1,
				'default' => 8,
			]
		);

		$this->add_control(
			'pcount',
			[
				'label' => __( 'Slider columns count', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 6,
				'step' => 1,
				'default' => 5,
			]
		);
		
		$this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings_for_display();
		global $di_data;

		$block_classes = '';
		$block_classes .= ( empty($settings['title'] ) && $di_data['prod_navs'] == 'stone' ? ' nav-type-one' : '' ); 
		$block_classes .= ( $di_data['prod_navs'] == 'sttwo' ? ' nav-type-two' : '' );
		$block_classes .= ( 'yes' === $settings['white_title'] ? ' white-title' : '' );
		$block_classes .= ( 'yes' === $settings['white_box'] ? ' white-box' : '' );
		$block_classes .= ( 'yes' === $settings['hide_desk_title'] ? ' hide-desk-title' : '' );
		$block_classes .= ( 'yes' === $settings['hide_desk_title'] && $di_data['prod_navs'] == 'stone' ? ' hide-desk-title-one' : '' ); ?>
		
		<div class="product-block<?php echo $block_classes; ?>">

		<?php
			$product_cat = $settings['product_cat'];
			$product_count = $settings['ptotalcount'];
			add_option( 'dina_daily_products_cat', $product_cat, '', 'yes' );
			add_option( 'dina_daily_products_count', $product_count, '', 'yes' );

			if(get_option( 'dina_daily_products_cat' ) != $product_cat || get_option( 'dina_daily_products_count' ) != $product_count ) {
				delete_transient('dina_daily_products');
				update_option( 'dina_daily_products_cat', $product_cat, '', 'yes' );
				update_option( 'dina_daily_products_count', $product_count, '', 'yes' );
			}

			if ( false === ( $productsquery = get_transient( 'dina_daily_products' ) ) ) {
			  
				$args = array(
					'posts_per_page'    => $settings['ptotalcount'],
					'post_status'       => 'publish',
					'orderby'        	=> 'rand',
					'post_type'         => 'product',
					'fields'                    => 'ids',
					'no_found_rows'             => true,
					'update_post_term_cache'    => false,
					'meta_query' => array(
						array(
						'key' => '_stock_status',
						'value' => 'instock',
						'compare' => '=',
						)
                    ),
					'post__in' => array_merge( array( 0 ), wc_get_product_ids_on_sale() )
				);

				if (!empty($product_cat) ) {
					$args['tax_query'] = array(
						array(
						'taxonomy' => 'product_cat',
						'field' => 'term_id',
						'terms' => $product_cat
						)
					);
				}
	
				$productsquery = new \WP_Query( $args );
			  
				//Now we store the array for one day.
				$timezone = get_option('timezone_string');
				date_default_timezone_set($timezone);
				$seconds_until_next_day = strtotime('tomorrow') - time();
				set_transient( 'dina_daily_products', $productsquery, $seconds_until_next_day );
			}

		?>
		
		<?php if ( $productsquery->have_posts() ) { ?>
		
		<?php if( !empty( $settings['title'] ) ) { ?>
		<div class="block-title">
			<h2> 
				<?php if(!empty($settings['custom_icon']['url'] ) ){ ?>
					<img src="<?php echo $settings['custom_icon']['url']; ?>" width="32" height="32" alt="<?php echo $settings['title']; ?>" class="cust-icon">
				<?php } else { ?>
					<i class="fal fa-<?php echo $settings['product_icon']; ?>" aria-hidden="true"></i>
				<?php } ?>
				<?php echo $settings['title']; ?>
			</h2>
		</div>
		<?php } ?>
		<?php $mobile_col = ($di_data['mobile_single_col'] ? 1 : 2); ?>
		<div class="owl-carousel" data-mcol="<?php echo $mobile_col; ?>" <?php if ( 'yes' === $settings['show_arrows'] ) { echo 'data-itemnavs="true"'; } else { echo 'data-itemnavs="false"'; } ?> <?php if ( 'yes' === $settings['prod_loop'] ) { echo 'data-itemloop="true"'; } else { echo 'data-itemloop="false"'; } ?> <?php if ( 'yes' === $settings['auto_play'] ) { echo 'data-itemplay="true"'; echo ' data-itemtime="'. $settings['time'] .'"'; } else { echo 'data-itemplay="false"'; } ?> <?php if ( 'yes' === $settings['pause_over'] ) { echo 'data-itemover="true"'; } else { echo 'data-itemover="false"'; } ?> data-itemscount="<?php echo $settings['pcount']; ?>" data-item-slideby="<?php echo $settings['slide_by']; ?>" data-dir="<?php echo dina_rtl(); ?>">
		    
		<?php
		while ( $productsquery->have_posts() ): $productsquery->the_post(); ?>
			<?php global $product;
				$in_stock = $product->is_in_stock();
			?>
			<div class="item">
				<div class="<?php echo dina_mini_product_classes($product->get_id() ); ?>">
					<?php $link_target = ($di_data['open_prod_new_tab'] ? '_blank' : '_self'); ?>
					<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" class="product-link" target="<?php echo $link_target; ?>">
						<?php pr_img() ?>
						<?php if($in_stock && $product->is_on_sale() ) { ?>
						<?php echo dina_dis_price(get_the_ID() ); ?>
						<?php } ?>
						<?php echo dina_product_label(get_the_ID() ); ?>
						<span class="product-title">
							<?php the_title(); ?>
						</span>

						<?php

						$timezone = get_option('timezone_string');
						date_default_timezone_set($timezone);
                        $date = strtotime('tomorrow');

						if ( !empty($date) && $product->is_purchasable() && $product->is_in_stock() && !show_login_price() ) {
							
							$sale_price_date = ( $date ) ? date( 'Y/m/d', $date ) : '';
							if($product->is_on_sale() ) { ?>
								<span class="counter-con">
									<span class="prodcounter" data-datediff="1" data-countdown="<?php echo $sale_price_date; ?>" data-dir="<?php echo (is_rtl() )?'rtl':'ltr';?>"></span>
								</span>
							<?php } 
						}
						?>
						
						<div class="product-price">
							
								<?php if($in_stock || $di_data['show_price_out'] ) { ?>
									<?php echo $product->get_price_html(); ?>
								<?php } else { ?>
									<?php _e( 'Out of stock', 'dina-kala' ); ?>
								<?php } ?>
							
						</div>
					</a>
					
					<?php
					dina_prod_hover($product->get_id() );
					dina_add_to_cart($product); 
					dina_product_rating($product->get_id() ); 
					if( class_exists( 'WeDevs_Dokan' ) && $di_data['show_product_vendor_archive'] ) {
					dina_get_product_vendor($product->get_id() );
					} 
					?>
				</div>
			</div>
        <?php endwhile; ?>
        </div>

		<?php 
		} else {		
			echo '<div class="col-12 not-msg">'.__( 'No product with the desired conditions was found.', 'dina-kala' ).'</div>';
		}
		
		wp_reset_postdata();
		?>
        </div>
        <?php

	}

}