<?php
namespace Elementor;

class Category_Slider extends Widget_Base {
	
	public function get_name() {
		return 'category-slider';
	}
	
	public function get_title() {
		return __( 'Category slider', 'dina-kala' );
	}
	
	public function get_icon() {
		return 'fal fa-sitemap';
	}
	
	public function get_categories() {
		return [ 'dina-kala' ];
	}
	
	protected function register_controls() {
	require get_template_directory() . '/includes/el-widgets/fa.php';
	
		$prod_cats = array();

		$args = array (
			'taxonomy'    => 'product_cat',
            'hide_empty'  => false
		);

		$prod_cats = get_terms( $args );
		
		$product_cat = array();
		if ( ! empty( $prod_cats ) && ! is_wp_error( $prod_cats ) ) {
			foreach ( $prod_cats as $prod_cat ) {
				$product_cat[ $prod_cat->term_id ] = $prod_cat->name;
			}
		}

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Category slider', 'dina-kala' ),
			]
		);

		$this->add_control(
			'slider_title',
			[
				'label' => __( 'Slider title', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your title', 'dina-kala' ),
                'default' => __( 'Categories', 'dina-kala' ),
			]
		);

		$this->add_control(
			'slider_icon',
			[
				'label' => __( 'Slider icon', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'sitemap '
			]
		);

		$this->add_control(
			'custom_icon',
			[
				'label' => __( 'Or custom icon (Suitable size: 32px by 32px)', 'dina-kala' ),
				'type' => Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'product_cat',
			[
				'label' => __( 'Categories', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => $product_cat,
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'   => __( 'Order by', 'dina-kala' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					''           => '',
					'id'         => __( 'ID', 'dina-kala' ),
					'date'       => __( 'Date', 'dina-kala' ),
					'title'      => __( 'Title', 'dina-kala' ),
					'menu_order' => __( 'Menu order', 'dina-kala' ),
					'modified'   => __( 'Last modified date', 'dina-kala' ),
				),
			]
		);

		$this->add_control(
			'order',
			[
				'label'   => __( 'Sort order', 'dina-kala' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					''     => __( 'Inherit', 'dina-kala' ),
					'DESC' => __( 'Descending', 'dina-kala' ),
					'ASC'  => __( 'Ascending', 'dina-kala' ),
				),
			]
		);

		$this->add_control(
			'hide_empty',
			[
				'label' => __( 'Hide empty categories', 'dina-kala' ),
				'description' => __( 'Empty categories (no product) are not displayed', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'cat_total_count',
			[
				'label' => __( 'Categories total count', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
			]
		);
		
		$this->add_control(
			'white_box',
			[
				'label' => __( 'White box style', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'dis_bw',
			[
				'label' => __( 'Disable black & white style', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'show_arrows',
			[
				'label' => __( 'Show arrows', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'auto_play',
			[
				'label' => __( 'Auto play', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'time',
			[
				'label' => __( 'Auto play speed(ms)', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1000,
				'max' => 20000,
				'step' => 1000,
				'default' => 8000,
			]
		);

		$this->add_control(
			'pause_over',
			[
				'label' => __( 'Pause slider on mouse over', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'slide_by',
			[
				'label' => __( 'Items displayed when scrolling', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 40,
				'step' => 1,
				'default' => 1,
			]
		);

		$this->add_control(
			'cat_loop',
			[
				'label' => __( 'Category loop', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'cat_count',
			[
				'label' => __( 'Slider columns count', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 8,
				'step' => 1,
				'default' => 6,
			]
		);

		$this->add_control(
			'show_dots',
			[
				'label' => __( 'Show navigation\'s dots', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
        
		$this->end_controls_section();
	}
	
	protected function render() {
        $settings = $this->get_settings_for_display();

		$product_cat = $settings['product_cat'];
		$cat_total_count = $settings['cat_total_count'];

		$args = array (
			'taxonomy'    => 'product_cat',
			'order'       => $settings['order'],
			'hide_empty'  => 'yes' === $settings['hide_empty'],
			'include' 	  => $product_cat,
			'number'	  => $cat_total_count
		);

		if ( $settings['orderby'] ) {
			$args['orderby'] = $settings['orderby'];
		}
		
		$terms = get_terms( $args );
		?>
		
		<?php
		if ( ! empty( $terms ) ) {
		?>
			<div class="dina-logos<?php if ( 'yes' === $settings['white_box'] ) { echo ' white-box'; } ?><?php if ( 'yes' === $settings['dis_bw'] ) { echo ' dis-bw'; } ?>">
				
				<?php if ( ! empty ( $settings['slider_title'] ) ) { ?>
					<h2>
						<?php if( ! empty ( $settings['custom_icon']['url'] ) ) { ?>
							<img src="<?php echo $settings['custom_icon']['url']; ?>" width="32" height="32" alt="<?php echo $settings['slider_title']; ?>" class="cust-icon">
						<?php } else { ?>
							<i class="fal fa-<?php echo $settings['slider_icon']; ?>" aria-hidden="true"></i>
						<?php } ?>
						<?php echo $settings['slider_title']; ?>
					</h2>
				<?php } ?>

				<?php
					$slider_options = ''; 
					$slider_options .= 'yes' === $settings['show_arrows'] ? ' data-itemnavs="true"' : ' data-itemnavs="false"'; 
					$slider_options .= 'yes' === $settings['cat_loop'] ? ' data-itemloop="true"' : ' data-itemloop="false"'; 
					$slider_options .= 'yes' === $settings['auto_play'] ? ' data-itemplay="true" data-itemtime="'. $settings['time'] .'"' : ' data-itemplay="false"'; 
					$slider_options .= 'yes' === $settings['pause_over'] ? ' data-itemover="true"' : ' data-itemover="false"'; 
					$slider_options .= 'yes' === $settings['show_dots'] ? ' data-itemdots="true"' : ' data-itemdots="false"'; 
					$slider_options .= ' data-itemscount="'. $settings['cat_count'] .'"'; 
					$slider_options .= ' data-item-slideby="'. $settings['slide_by'] .'"'; 
					$slider_options .= ' data-dir="'. dina_rtl() .'"';
				?>

				<div class="owl-carousel logo-slider category-slider"<?php echo $slider_options; ?>>

					<?php foreach ( $terms as $term ) {
						$term_link = get_term_link( $term, 'product_cat' );
						$thumbnail_id = get_term_meta ( $term->term_id, 'thumbnail_id', true );
						if ( ! empty( $thumbnail_id ) ) {
							$cat_attr = wp_get_attachment_image_src( $thumbnail_id );
							$cat_logo = $cat_attr[0];
						} else {
							$cat_logo = '';
						}
						
					?>

					<div class="item">
						<a href="<?php echo $term_link; ?>" title="<?php echo $term->name; ?>">
						<?php if ( ! empty ( $cat_logo ) ) { ?>
							<img src="<?php echo $cat_logo; ?>" alt="<?php echo $term->name; ?>" width="<?php echo $cat_attr[1]; ?>" height="<?php echo $cat_attr[2]; ?>">
						<?php } else { ?>
							<img src="<?php echo esc_url( get_template_directory_uri() ) . '/images/mthumb.png'; ?>" alt="<?php echo $term->name; ?>" width="150" height="150">
						<?php } ?>
						</a>
					</div>

					<?php } ?>
				</div>
			</div>
        <?php
		}
	}
}