<?php
namespace Elementor;

class Brands_Slider extends Widget_Base {
	
	public function get_name() {
		return 'brands-slider';
	}
	
	public function get_title() {
		return __( 'Brands slider', 'dina-kala' );
	}
	
	public function get_icon() {
		return 'fal fa-tags';
	}
	
	public function get_categories() {
		return [ 'dina-kala' ];
	}
	
	protected function register_controls() {
		
		global $di_data;
		require get_template_directory() . '/includes/el-widgets/fa.php';
	
		$prod_brand = array();

		$args = array (
			'taxonomy'    => $di_data['product_brand_taxonomy'],
            'hide_empty'  => false
		);
		$brands = get_terms( $args );

		$prod_brand = array();
		if ( ! empty( $brands ) && ! is_wp_error( $brands ) ) {
			foreach ( $brands as $brand ) {
				$prod_brand[ $brand->term_id ] = $brand->name;
			}
		}

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Brands slider', 'dina-kala' ),
			]
		);

		$this->add_control(
			'slider_title',
			[
				'label' => __( 'Slider title', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your title', 'dina-kala' ),
                'default' => __( 'Brands', 'dina-kala' ),
			]
		);

		$this->add_control(
			'slider_icon',
			[
				'label' => __( 'Slider icon', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'gem '
			]
		);

		$this->add_control(
			'custom_icon',
			[
				'label' => __( 'Or custom icon (Suitable size: 32px by 32px)', 'dina-kala' ),
				'type' => Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'product_brand',
			[
				'label' => __( 'Brands', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => $prod_brand,
			]
		);

		$this->add_control(
			'orderby',
			[
				'label'   => __( 'Order by', 'dina-kala' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					''           => '',
					'id'         => __( 'ID', 'dina-kala' ),
					'date'       => __( 'Date', 'dina-kala' ),
					'title'      => __( 'Title', 'dina-kala' ),
					'menu_order' => __( 'Menu order', 'dina-kala' ),
					'modified'   => __( 'Last modified date', 'dina-kala' ),
				),
			]
		);

		$this->add_control(
			'order',
			[
				'label'   => __( 'Sort order', 'dina-kala' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					''     => __( 'Inherit', 'dina-kala' ),
					'DESC' => __( 'Descending', 'dina-kala' ),
					'ASC'  => __( 'Ascending', 'dina-kala' ),
				),
			]
		);

		$this->add_control(
			'hide_empty',
			[
				'label' => __( 'Hide Empty Brands', 'dina-kala' ),
				'description' => __( 'Empty brands (no product) are not displayed', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'br_total_count',
			[
				'label' => __( 'Brands total count', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
			]
		);
		
		$this->add_control(
			'white_box',
			[
				'label' => __( 'White box style', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'dis_bw',
			[
				'label' => __( 'Disable black & white style', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'show_arrows',
			[
				'label' => __( 'Show arrows', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'auto_play',
			[
				'label' => __( 'Auto play', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'time',
			[
				'label' => __( 'Auto play speed(ms)', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1000,
				'max' => 20000,
				'step' => 1000,
				'default' => 8000,
			]
		);

		$this->add_control(
			'pause_over',
			[
				'label' => __( 'Pause slider on mouse over', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'slide_by',
			[
				'label' => __( 'Items displayed when scrolling', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 40,
				'step' => 1,
				'default' => 1,
			]
		);

		$this->add_control(
			'brand_loop',
			[
				'label' => __( 'Brand loop', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'brcount',
			[
				'label' => __( 'Slider columns count', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 8,
				'step' => 1,
				'default' => 6,
			]
		);

		$this->add_control(
			'show_dots',
			[
				'label' => __( 'Show navigation\'s dots', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
        
		$this->end_controls_section();
	}
	
	protected function render() {
		global $di_data;
        $settings = $this->get_settings_for_display();

		$product_brand = $settings['product_brand'];
		$br_total_count = $settings['br_total_count'];

		$args = array (
			'taxonomy'    => $di_data['product_brand_taxonomy'],
			'order'       => $settings['order'],
			'hide_empty'  => 'yes' === $settings['hide_empty'],
			'include' 	  => $product_brand,
			'number'	  => $br_total_count
		);

		if ( $settings['orderby'] ) {
			$args['orderby'] = $settings['orderby'];
		}
		
		$terms = get_terms( $args );
		?>
		
		<?php
		if ( ! empty( $terms ) ) {
		?>
			<div class="dina-logos<?php if ( 'yes' === $settings['white_box'] ) { echo ' white-box'; } ?><?php if ( 'yes' === $settings['dis_bw'] ) { echo ' dis-bw'; } ?>">
				
				<?php if ( ! empty ( $settings['slider_title'] ) ) { ?>
					<h2>
						<?php if( ! empty ( $settings['custom_icon']['url'] ) ) { ?>
							<img src="<?php echo $settings['custom_icon']['url']; ?>" width="32" height="32" alt="<?php echo $settings['slider_title']; ?>" class="cust-icon">
						<?php } else { ?>
							<i class="fal fa-<?php echo $settings['slider_icon']; ?>" aria-hidden="true"></i>
						<?php } ?>
						<?php echo $settings['slider_title']; ?>
					</h2>
				<?php } ?>

				<?php
					$slider_options = ''; 
					$slider_options .= 'yes' === $settings['show_arrows'] ? ' data-itemnavs="true"' : ' data-itemnavs="false"'; 
					$slider_options .= 'yes' === $settings['brand_loop'] ? ' data-itemloop="true"' : ' data-itemloop="false"'; 
					$slider_options .= 'yes' === $settings['auto_play'] ? ' data-itemplay="true" data-itemtime="'. $settings['time'] .'"' : ' data-itemplay="false"'; 
					$slider_options .= 'yes' === $settings['pause_over'] ? ' data-itemover="true"' : ' data-itemover="false"'; 
					$slider_options .= 'yes' === $settings['show_dots'] ? ' data-itemdots="true"' : ' data-itemdots="false"'; 
					$slider_options .= ' data-itemscount="'. $settings['brcount'] .'"'; 
					$slider_options .= ' data-item-slideby="'. $settings['slide_by'] .'"'; 
					$slider_options .= ' data-dir="'. dina_rtl() .'"';
				?>

				<div class="owl-carousel logo-slider brands-slider"<?php echo $slider_options; ?>>

					<?php foreach ( $terms as $term ) {
						$term_link = get_term_link( $term, $di_data['product_brand_taxonomy'] );
						$brand_logo = get_term_meta( $term->term_id, 'dina_brand_logo', true );
					?>

					<div class="item">
						<a href="<?php echo $term_link; ?>" title="<?php echo $term->name; ?>">
						<?php if ( ! empty ( $brand_logo ) ) {
							$image_id = attachment_url_to_postid( esc_url( $brand_logo ) );
							$brand_attr = wp_get_attachment_image_src( $image_id, 'full'); ?>
							<img src="<?php echo $brand_logo; ?>" alt="<?php echo $term->name; ?>" width="<?php echo $brand_attr[1]; ?>" height="<?php echo $brand_attr[2]; ?>">
						<?php } else { ?>
							<img src="<?php echo esc_url( get_template_directory_uri() ) . '/images/mthumb.png'; ?>" alt="<?php echo $term->name; ?>" width="150" height="150">
						<?php } ?>
						</a>
					</div>

					<?php } ?>
				</div>
			</div>
        <?php
		}
	}
}