<?php
//Add Dokan link to my account page
if( class_exists( 'WeDevs_Dokan' ) ) {
    add_filter ( 'woocommerce_account_menu_items', 'dokan_acc_link' );
    function dokan_acc_link( $menu_links ) {
        if( user_seller() ) {
            $new = array( 'dokan-link' => __('Vendor Dashboard' , 'dina-kala') ); 
        } else {
            $new = array( 'dokan-link-become' => __('Become a Vendor' , 'dina-kala') ); 
        }
        $menu_links = array_slice( $menu_links, 0, 1, true )
        + $new 
        + array_slice( $menu_links, 1, NULL, true );
        return $menu_links;
    }
    add_filter( 'woocommerce_get_endpoint_url', 'dokan_hook_endpoint', 5, 4 );
    function dokan_hook_endpoint( $url, $endpoint, $value, $permalink ) {
        if( $endpoint === 'dokan-link' ) {
            $url = esc_url( user_dashboard() );
        } elseif( $endpoint === 'dokan-link-become' ) {
            $url = esc_url( dokan_get_page_url( 'myaccount', 'woocommerce', 'account-migration' ) );
        }
        return $url;
    }
}

//Get Seller Dashboard Address
function user_dashboard() {
    if (class_exists('WeDevs_Dokan') ) {
        if (is_user_logged_in() ) {
            $user = wp_get_current_user();
        }
    if ( user_can( $user, 'dokandar' ) ) {
            $seller_dashboard = dokan_get_option( 'dashboard', 'dokan_pages' );
            if ( $seller_dashboard != -1 ) {
                $seller_page = get_permalink( $seller_dashboard );
            }
    }
    return $seller_page;
    }
}

//Check User is Dokan Seller
function user_seller(){
    if (class_exists('WeDevs_Dokan') ) {
        $user_id = '';
        if (is_user_logged_in() ) {
            $user = wp_get_current_user();
            $user_id = get_current_user_id();
        }
        $user_seller = dokan_is_user_seller($user_id);
    }
    if($user_seller) {
        return true;
    }
}

//dina_dokan_dashboard_wrap_start
add_action('dokan_dashboard_wrap_start', 'dina_dokan_dashboard_wrap_start', 10);
function dina_dokan_dashboard_wrap_start(){
    global $di_data;
 ?>
    <div class="container main-con">
        <?php if ( $di_data['show_bread'] ) { dina_breadcrumb(); } ?>
        <div class="row">
            <article role="main" class="col-12">
<?php }

//dina_dokan_dashboard_wrap_end
add_action('dokan_dashboard_wrap_end', 'dina_dokan_dashboard_wrap_end', 10);
function dina_dokan_dashboard_wrap_end(){
 ?>
        </article>
    </div>
</div>
<?php }

//Set template of Dokan dashboard
if( class_exists( 'WeDevs_Dokan' ) && !class_exists( 'WUPP_User_Panel' ) ) { 
    add_filter( 'page_template', 'dokan_page_template' );
    function dokan_page_template( $page_template ) {
        global $post;
        if( !is_object($post) ) 
        return;
        $post_id = $post->ID;
        if($post_id === dokan_get_option( 'dashboard', 'dokan_pages' ) ) {
                $page_template = get_stylesheet_directory() . '/dashboard.php'; 
        } 
        return $page_template;
    }
}

//Remove shippng tab from WooCommerce single product page
if( class_exists( 'WeDevs_Dokan' ) && $di_data['hide_dokan_shipping'] ) { 
    add_filter( 'woocommerce_product_tabs', 'dina_remove_shipping_product_tab', 98 );
    function dina_remove_shipping_product_tab($tabs) {
        unset($tabs['shipping'] );
        return $tabs;
    }
}

//Remove seller product tab from WooCommerce single product page
if( class_exists( 'WeDevs_Dokan' ) && $di_data['hide_dokan_seller_info'] ) { 
    add_filter( 'woocommerce_product_tabs', 'dina_remove_seller_product_tab', 98 );
    function dina_remove_seller_product_tab($tabs) {
        unset($tabs['seller'] );
        return $tabs;
    }
}

//Remove more seller product tab from WooCommerce single product page
if( class_exists( 'WeDevs_Dokan' ) && $di_data['hide_dokan_more_product'] ) { 
    add_filter( 'woocommerce_product_tabs', 'dina_remove_more_seller_product_tab', 98 );
    function dina_remove_more_seller_product_tab($tabs) {
        unset($tabs['more_seller_product'] );
        return $tabs;
    }
}

//Add vendor's name to product's meta
if( class_exists( 'WeDevs_Dokan' ) && $di_data['show_product_vendor'] ) {
    add_action('woocommerce_product_meta_start', 'dina_product_vendor', 12);
    }
    
    function dina_product_vendor() {
        if( class_exists( 'WeDevs_Dokan' ) ) {
            global $product;
            $author = get_post_field( 'post_author', $product->get_id() );
            $author_data = get_userdata( absint( $author ) );
    ?>
    <span class="vendor_wrapper"><?php _e('Vendor:', 'dina-kala') ?>
        <span class="product-vendor"><?php printf( '<a href="%s">%s</a>', esc_url( dokan_get_store_url( $author_data->ID ) ), esc_attr( $author_data->display_name ) ); ?></span>
    </span>
    <?php
        }
    }

//Get product's vendor name
function dina_get_product_vendor($id) {
    global $di_data;
        $author = get_post_field( 'post_author', $id );
        $author_data = get_userdata( absint( $author ) );
?>
<div class="product-vendor-name">
    <i class="fal fa-store" aria-hidden="true"></i>
    <?php _e('Vendor:', 'dina-kala'); ?>
    <?php echo esc_attr( $author_data->display_name ); ?>
</div>
<?php
}

//Remove Dokan FontAwesome Library
add_action( 'wp_enqueue_scripts', 'remove_default_stylesheet' );
function remove_default_stylesheet() {
    wp_dequeue_style( 'dokan-fontawesome' );
    wp_deregister_style( 'dokan-fontawesome' );
}