<?php 

global $di_data;

if( $di_data['show_product_brand'] ) {
add_action('woocommerce_product_meta_start', 'dina_product_brand', 12);
}

function dina_product_brand() {
    global $di_data;
    if( !empty( get_the_terms( get_the_ID(), $di_data['product_brand_taxonomy'] ) ) ) {
    ?>
        <span class="brand_wrapper"><?php _e('Brand:', 'dina-kala') ?>
            <span class="product-brand"><?php the_terms( get_the_ID(), $di_data['product_brand_taxonomy'], '', '، ', '' );  ?></span>
        </span>
    <?php
    }
}

// Register dina_taxonomy_brand
add_action( 'init', 'dina_taxonomy_brand' );
function dina_taxonomy_brand()  {

global $di_data;

$labels = array(
    'name'                       => __('Brand', 'dina-kala'),
    'singular_name'              => __('Brand', 'dina-kala'),
    'menu_name'                  => __('Brand of products', 'dina-kala'),
    'all_items'                  => __('All Brands', 'dina-kala'),
    'parent_item'                => __('Parent brand', 'dina-kala'),
    'parent_item_colon'          => __('Parent brand', 'dina-kala'),
    'new_item_name'              => __('New brand name', 'dina-kala'),
    'add_new_item'               => __('Add new brand', 'dina-kala'),
    'edit_item'                  => __('Edit brand', 'dina-kala'),
    'update_item'                => __('Update brand', 'dina-kala'),
    'separate_items_with_commas' => __('Separate brands with commas', 'dina-kala'),
    'search_items'               => __('Search brands', 'dina-kala'),
    'add_or_remove_items'        => __('Add or remove brands', 'dina-kala'),
    'choose_from_most_used'      => __('Choose from most used brand', 'dina-kala'),
);

$brand_slug = $di_data['product_brand_slug'];

$args = array(
    'labels'                     => $labels,
    'hierarchical'               => true,
    'public'                     => true,
    'show_ui'                    => true,
    'show_admin_column'          => true,
    'show_in_nav_menus'          => true,
    'show_tagcloud'              => true,
    'query_var'                  => true,
	'rewrite'                    => array( 'slug' => $brand_slug ),
);

register_taxonomy( $di_data['product_brand_taxonomy'], 'product', $args );

register_taxonomy_for_object_type( $di_data['product_brand_taxonomy'], 'product' );
}

if( $di_data['add_brand_schema'] ) {
    add_filter( 'woocommerce_structured_data_product', 'dina_woocommerce_structured_data_product_offer', 10, 2 );
}

function dina_woocommerce_structured_data_product_offer( $markup, $product ) {
    global $di_data;
    $terms = get_the_terms( get_the_ID(), $di_data['product_brand_taxonomy'] );

    if( !empty($terms) ) {
        $term = array_pop($terms);

        $markup[ 'brand' ] = array(
            '@type'  => 'Thing',
            'name'   => $term -> name,
        );

        return $markup;
    }
}


if( $di_data['show_product_brand_tab'] ) {
    add_filter( 'woocommerce_product_tabs', 'dina_woocommerce_product_tabs_brand' );
}

function dina_woocommerce_product_tabs_brand( $tabs1 ) {
    global $di_data;
    
    $brands = get_the_terms( get_the_ID(), $di_data['product_brand_taxonomy'] );
    if( !empty($brands) ) {
    $brand = array_pop($brands);
    $tabs1['dina_brand'] = array(
        'title'     => $di_data['product_brand_tab_title'],
        'priority'  => 20,
        'callback'  => 'dina_woocommerce_product_tabs_brand_content'
    );
    }

    return $tabs1;
}

function dina_woocommerce_product_tabs_brand_content() {
    global $di_data;
    $brands = get_the_terms( get_the_ID(), $di_data['product_brand_taxonomy'] );
    $brand = array_pop($brands);
    $brand_logo = get_term_meta( $brand -> term_id, 'dina_brand_logo', true );  
    $brand_link = get_term_link( $brand -> term_id, $di_data['product_brand_taxonomy'] );

    if( !empty($brand -> name) ) {
        echo '<a href="'. $brand_link .'" class="brand-link" title="'. $brand -> name .'">';
            echo '<h3 class="brand-name">'. $brand -> name .'</h3>';
        echo '</a>';
    }

    if( !empty($brand_logo) ) {
        echo '<a href="'. $brand_link .'" class="brand-link" title="'. $brand -> name .'">';
            echo '<img src="'. $brand_logo . '" alt="'. $brand -> name .'" title="'. $brand -> name .'" class="brand-logo">';
        echo '</a>';
    }

    if( !empty($brand -> description) ) {
        echo '<div class="brand-description">'. $brand -> description .'</div>';
    }
}