<?php
    /**
     * ReduxFramework Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */
    load_theme_textdomain( 'dina-kala', get_template_directory() . '/languages' );
    if ( ! class_exists( 'Redux' ) ) {
        return;
    }
    if ( ! class_exists( 'ReduxFramework_extension_vendor_support' ) ) {
        if ( file_exists( dirname( __FILE__ ) . '/sample/vendor_support/extension_vendor_support.php' ) ) {
            require dirname( __FILE__ ) . '/sample/vendor_support/extension_vendor_support.php';
            new ReduxFramework_extension_vendor_support();
        }
    }

    //FontAwesome Icons
    require_once( dirname( __FILE__ ) . '/sample/fa.php' );
    require_once( dirname( __FILE__ ) . '/sample/fab.php' );
    require_once( dirname( __FILE__ ) . '/sample/iricons.php' );

    $alliconArray = array_merge( $iconArray, $biconArray, $iriconArray );
    // This is your option name where all the Redux data is stored.
    $opt_name = "di_data";

    //Redux's constants
    define ('RE_URI' , get_template_directory_uri() . '/includes/ReduxCore/');
    define ('RE_DIR' , get_template_directory() . '/includes/ReduxCore/');

    // Background Patterns Reader
    $sample_patterns_path = RE_DIR . 'assets/img/patterns/';
    $sample_patterns_url  = RE_URI . 'assets/img/patterns/';
    $sample_patterns      = array();
    
    if ( is_dir( $sample_patterns_path ) ) {

        if ( $sample_patterns_dir = opendir( $sample_patterns_path ) ) {
            $sample_patterns = array();

            while ( ( $sample_patterns_file = readdir( $sample_patterns_dir ) ) !== false ) {

                if ( stristr( $sample_patterns_file, '.png' ) !== false || stristr( $sample_patterns_file, '.jpg' ) !== false ) {
                    $name              = explode( '.', $sample_patterns_file );
                    $name              = str_replace( '.' . end( $name ), '', $sample_patterns_file );
                    $sample_patterns[] = array(
                        'alt' => $name,
                        'img' => $sample_patterns_url . $sample_patterns_file
                    );
                }
            }
        }
    }

    //Footer Background Patterns Reader
    $footer_patterns_path = RE_DIR . 'assets/img/fbg/';
    $footer_patterns_url  = RE_URI . 'assets/img/fbg/';
    $footer_patterns      = array();
    
    if ( is_dir( $footer_patterns_path ) ) {

        if ( $footer_patterns_dir = opendir( $footer_patterns_path ) ) {
            $footer_patterns = array();

            while ( ( $footer_patterns_file = readdir( $footer_patterns_dir ) ) !== false ) {

                if ( stristr( $footer_patterns_file, '.png' ) !== false || stristr( $footer_patterns_file, '.jpg' ) !== false ) {
                    $name              = explode( '.', $footer_patterns_file );
                    $name              = str_replace( '.' . end( $name ), '', $footer_patterns_file );
                    $footer_patterns[] = array(
                        'alt' => $name,
                        'img' => $footer_patterns_url . $footer_patterns_file
                    );
                }
            }
        }
    }

    $col_number = [];
    foreach(range(1, 40) as $number)
    {
        $col_number[$number] = $number;
    }

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        // TYPICAL -> Change these values as you need/desire
        'opt_name'             => $opt_name,
        // This is where your data is stored in the database and also becomes your global variable name.
        'display_name'         => $theme->get( 'Name' ),
        // Name that appears at the top of your panel
        'display_version'      => $theme->get( 'Version' ),
        // Version that appears at the top of your panel
        'menu_type'            => 'submenu',
        //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
        'allow_sub_menu'       => true,
        // Show the sections below the admin menu item or not
        'menu_title'           => __( 'Theme Settings', 'dina-kala' ),
        'page_title'           => __( 'Theme Settings', 'dina-kala' ),
        // You will need to generate a Google API key to use this feature.
        // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
        'google_api_key'       => '',
        // Set it you want google fonts to update weekly. A google_api_key value is required.
        'google_update_weekly' => false,
        // Must be defined to add google fonts to the typography module
        'async_typography'     => true,
        // Use a asynchronous font on the front end or font string
        //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
        'admin_bar'            => true,
        // Show the panel pages on the admin bar
        'admin_bar_icon'       => 'dashicons-admin-generic',
        // Choose an icon for the admin bar menu
        'admin_bar_priority'   => 50,
        // Choose an priority for the admin bar menu
        'global_variable'      => '',
        // Set a different name for your global variable other than the opt_name
        'dev_mode'             => false,
        // Show the time the page took to load, etc
        'update_notice'        => true,
        // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
        'customizer'           => true,
        // Enable basic customizer support
        //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
        //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

        // OPTIONAL -> Give you extra features
        'page_priority'        => null,
        // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
        'page_parent'          => 'themes.php',
        // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
        'page_permissions'     => 'manage_options',
        // Permissions needed to access the options panel.
        'menu_icon'            => '',
        // Specify a custom URL to an icon
        'last_tab'             => '',
        // Force your panel to always open to a specific tab (by id)
        'page_icon'            => 'icon-themes',
        // Icon displayed in the admin panel next to your menu_title
        'page_slug'            => '',
        // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
        'save_defaults'        => true,
        // On load save the defaults to DB before user clicks save or not
        'default_show'         => false,
        // If true, shows the default value next to each field that is not the default value.
        'default_mark'         => '',
        // What to print by the field's title if the value shown is default. Suggested: *
        'show_import_export'   => true,
        // Shows the Import/Export panel when not used as a field.

        // CAREFUL -> These options are for advanced use only
        'transient_time'       => 60 * MINUTE_IN_SECONDS,
        'output'               => true,
        // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
        'output_tag'           => true,
        // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
        // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

        // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
        'database'             => '',
        // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
        'use_cdn'              => false,
        'forced_dev_mode_off' => true,
        'show_options_object' => false,
        // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

        // HINTS
        'hints'                => array(
            'icon'          => 'el el-question-sign',
            'icon_position' => 'right',
            'icon_color'    => 'lightgray',
            'icon_size'     => 'normal',
            'tip_style'     => array(
                'color'   => 'red',
                'shadow'  => true,
                'rounded' => false,
                'style'   => '',
            ),
            'tip_position'  => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect'    => array(
                'show' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'mouseover',
                ),
                'hide' => array(
                    'effect'   => 'slide',
                    'duration' => '500',
                    'event'    => 'click mouseleave',
                ),
            ),
        )
    );
    // Panel Intro text -> before the form
    if ( ! isset( $args['global_variable'] ) || $args['global_variable'] !== false ) {
        if ( ! empty( $args['global_variable'] ) ) {
            $v = $args['global_variable'];
        } else {
            $v = str_replace( '-', '_', $args['opt_name'] );
        }
        $args['intro_text'] = '';
    } else {
        $args['intro_text'] = '';
    }

    

    // Add content after the form.
    $args['footer_text'] = '';

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */


    /*
     * ---> START HELP TABS
     */

    $tabs = array(
        array(
            'id'      => 'redux-help-tab-1',
            'title'   => __( 'Template guide', 'dina-kala' ),
            'content' => __( 'If you have questions about working with the template, contact meysam98@gmail.com.', 'dina-kala' )
        ),
    );
    Redux::setHelpTab( $opt_name, $tabs );
    /*
     * <--- END HELP TABS
     */


    /*
     *
     * ---> START SECTIONS
     *
     */

    // -> START Basic Fields
    Redux::setSection( $opt_name, array(
        'title'            => __( 'Home Settings', 'dina-kala' ),
        'id'               => 'menu_home',
        'desc'             => __( 'Home page settings', 'dina-kala' ),
        'customizer_width' => '400px',
        'icon'             => 'el el-home'
    ) );

    Redux::setSection( $opt_name, array(
        'title'            => __( 'Site logo', 'dina-kala' ),
        'icon'             => 'el el-picasa',
        'id'               => 'sitelogo',
        'subsection'       => true,
        'customizer_width' => '450px',
        'desc'             => __( 'Site Logo Settings', 'dina-kala' ),
        'fields'           => array(
            array(
                'id'       => 'site_logo',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'Your logo', 'dina-kala' ),
                'compiler' => 'true',
                'desc'     => __( 'Upload your site logo from this section.', 'dina-kala' ),
                'subtitle' => __( 'Appropriate size: 160(w) in 57(h)', 'dina-kala' ),
                'default'  => array( 'url' => get_template_directory_uri()."/images/logo.png" ),
            ),
            array(
                'id'       => 'site_logo_retina',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'Retina logo', 'dina-kala' ),
                'compiler' => 'true',
                'desc'     => __( 'Upload a site logo in a two-dimensional size to the current logo', 'dina-kala' ),
                'subtitle' => __( 'Appropriate size: 320(w) in 114(h)', 'dina-kala' ),
                'default'  => array( 'url' => get_template_directory_uri()."/images/logo2x.png" ),
            ),
            array(
                'id'       => 'site_favicon',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'Favicon', 'dina-kala' ),
                'compiler' => 'true',
                'mode'      => false, 
                'desc'     => __( 'Upload your site icons. This icon is displayed in some browsers next to your site URL.', 'dina-kala' ),
                'default'  => array( 'url' => get_template_directory_uri()."/images/favicon.png" ),
            ),
            array(
                'id'       => 'login_logo_switch',
                'type'     => 'switch',
                'title'    => __( 'Change the WordPress login page logo', 'dina-kala' ),
                'subtitle' => __( 'Enabling this option will change the WordPress logo on the login page of the logo you selected in the Retina logo section.', 'dina-kala' ),
                'default'  => true
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'            => __( 'Font settings', 'dina-kala' ),
        'icon'             => 'el el-font',
        'id'               => 'theme-font',
        'subsection'       => true,
        'customizer_width' => '500px',
        'desc'             => __( 'Template font settings', 'dina-kala' ),
        'fields'           => array(

            array(
                'id' => 'content_font_size',
                'type' => 'slider',
                'title' => __('Content font size (products, posts and pages)', 'dina-kala'),
                'default' => 14,
                'min' => 12,
                'step' => 1,
                'max' => 30,
                'display_value' => 'label'
            ),

            array(
                'id'       => 'theme_font',
                'type'     => 'select',
                'title' => __('Template font', 'dina-kala'),
                'subtitle' => __('Select the template font', 'dina-kala'),
                'options'  => array(
                    'dana' => __('Dana', 'dina-kala'),
                    'sans' =>  __('Iran Sans', 'dina-kala'),
                    'yekan' =>  __('Iran Yekan', 'dina-kala'),
                ),
                'default'  => 'dana',
                'required' => array( 'custom_font', '=', false ),
            ),

            array(
                'id'       => 'custom_font',
                'type'     => 'switch',
                'title'    => __( 'Use custom fonts', 'dina-kala' ),
                'subtitle' => __( 'With this option you can use your own custom fonts.', 'dina-kala' ),
                'default'  => false
            ),

            //Custom Font Normal
            array(
                'id' => 'normal-font-section-start',
                'type' => 'section',
                'title' => __( 'Normal weight upload', 'dina-kala' ),
                'indent' => true,
                'required' => array( 'custom_font', '=', true ),
            ),
            array(
                'id'       => 'theme_font_woff2',
                'type'     => 'media', 
                'title'    => __('WOFF2 font', 'dina-kala'),
                'url'      => true,
                'readonly' => false,
                'library_filter' => array('woff2'),
                'mode' => false,
                'preview'  => false,
                'default'  => '',
                'required' => array( 'custom_font', '=', true ),
            ),
            array(
                'id'       => 'theme_font_woff',
                'type'     => 'media', 
                'title'    => __('WOFF font', 'dina-kala'),
                'url'      => true,
                'readonly' => false,
                'library_filter' => array('woff'),
                'mode' => false,
                'preview'  => false,
                'default'  => '',
                'required' => array( 'custom_font', '=', true ),
            ),
            array(
                'id'       => 'theme_font_ttf',
                'type'     => 'media', 
                'title'    => __('TTF font', 'dina-kala'),
                'url'      => true,
                'readonly' => false,
                'library_filter' => array('ttf'),
                'mode' => false,
                'preview'  => false,
                'default'  => '',
                'required' => array( 'custom_font', '=', true ),
            ),
            array(
                'id'       => 'theme_font_eot',
                'type'     => 'media', 
                'title'    => __('EOT font', 'dina-kala'),
                'url'      => true,
                'readonly' => false,
                'library_filter' => array('eot'),
                'mode' => false,
                'preview'  => false,
                'default'  => '',
                'required' => array( 'custom_font', '=', true ),
            ),
            array(
                'id'       => 'theme_font_svg',
                'type'     => 'media', 
                'title'    => __('SVG font', 'dina-kala'),
                'url'      => true,
                'readonly' => false,
                'library_filter' => array('svg'),
                'mode' => false,
                'preview'  => false,
                'default'  => '',
                'required' => array( 'custom_font', '=', true ),
            ),
            array(
                'id'     => 'normal-font-section-end',
                'type'   => 'section',
                'indent' => false,
            ),

            //Custom Font Bold
            array(
                'id' => 'bold-font-section-start',
                'type' => 'section',
                'title' => __( 'Bold weight upload', 'dina-kala' ),
                'indent' => true,
                'required' => array( 'custom_font', '=', true ),
            ),
            array(
                'id'       => 'custom_bold_font',
                'type'     => 'switch',
                'title'    => __( 'Bold weight upload', 'dina-kala' ),
                'subtitle' => __( 'By activating this option, you can upload the bold font weight.', 'dina-kala' ),
                'default'  => false
            ),
            array(
                'id'       => 'theme_font_bold_woff2',
                'type'     => 'media',
                'title'    => __('WOFF2 font', 'dina-kala'),
                'url'      => true,
                'readonly' => false,
                'library_filter' => array('woff2'),
                'mode' => false,
                'preview'  => false,
                'default'  => '',
                'required' => array( 'custom_bold_font', '=', true ),
            ),
            array(
                'id'       => 'theme_font_bold_woff',
                'type'     => 'media', 
                'title'    => __('WOFF font', 'dina-kala'),
                'url'      => true,
                'readonly' => false,
                'library_filter' => array('woff'),
                'mode' => false,
                'preview'  => false,
                'default'  => '',
                'required' => array( 'custom_bold_font', '=', true ),
            ),
            array(
                'id'       => 'theme_font_bold_ttf',
                'type'     => 'media', 
                'title'    => __('TTF font', 'dina-kala'),
                'url'      => true,
                'readonly' => false,
                'library_filter' => array('ttf'),
                'mode' => false,
                'preview'  => false,
                'default'  => '',
                'required' => array( 'custom_bold_font', '=', true ),
            ),
            array(
                'id'       => 'theme_font_bold_eot',
                'type'     => 'media', 
                'title'    => __('EOT font', 'dina-kala'),
                'url'      => true,
                'readonly' => false,
                'library_filter' => array('eot'),
                'mode' => false,
                'preview'  => false,
                'default'  => '',
                'required' => array( 'custom_bold_font', '=', true ),
            ),
            array(
                'id'       => 'theme_font_bold_svg',
                'type'     => 'media', 
                'title'    => __('SVG font', 'dina-kala'),
                'url'      => true,
                'readonly' => false,
                'library_filter' => array('svg'),
                'mode' => false,
                'preview'  => false,
                'default'  => '',
                'required' => array( 'custom_bold_font', '=', true ),
            ),
            array(
                'id'     => 'bold-font-section-end',
                'type'   => 'section',
                'indent' => false,
            ),

            //Custom Font Farsi Digits
            array(
                'id' => 'farsi-digits-section-start',
                'type' => 'section',
                'title' => __( 'Farsi Digits Version upload', 'dina-kala' ),
                'indent' => true,
                'required' => array( 'custom_font', '=', true ),
            ),
            array(
                'id'       => 'custom_farsi_font',
                'type'     => 'switch',
                'title'    => __( 'Farsi Digits Version upload', 'dina-kala' ),
                'subtitle' => __( 'By activating this option, you can upload the farsi digits version, this version is used in some parts of the template to display Persian numbers.', 'dina-kala' ),
                'default'  => false
            ),
            array(
                'id'       => 'theme_font_farsi_woff2',
                'type'     => 'media',
                'title'    => __('WOFF2 font', 'dina-kala'),
                'url'      => true,
                'readonly' => false,
                'library_filter' => array('woff2'),
                'mode' => false,
                'preview'  => false,
                'default'  => '',
                'required' => array( 'custom_farsi_font', '=', true ),
            ),
            array(
                'id'       => 'theme_font_farsi_woff',
                'type'     => 'media', 
                'title'    => __('WOFF font', 'dina-kala'),
                'url'      => true,
                'readonly' => false,
                'library_filter' => array('woff'),
                'mode' => false,
                'preview'  => false,
                'default'  => '',
                'required' => array( 'custom_farsi_font', '=', true ),
            ),
            array(
                'id'       => 'theme_font_farsi_ttf',
                'type'     => 'media', 
                'title'    => __('TTF font', 'dina-kala'),
                'url'      => true,
                'readonly' => false,
                'library_filter' => array('ttf'),
                'mode' => false,
                'preview'  => false,
                'default'  => '',
                'required' => array( 'custom_farsi_font', '=', true ),
            ),
            array(
                'id'       => 'theme_font_farsi_eot',
                'type'     => 'media', 
                'title'    => __('EOT font', 'dina-kala'),
                'url'      => true,
                'readonly' => false,
                'library_filter' => array('eot'),
                'mode' => false,
                'preview'  => false,
                'default'  => '',
                'required' => array( 'custom_farsi_font', '=', true ),
            ),
            array(
                'id'       => 'theme_font_farsi_svg',
                'type'     => 'media', 
                'title'    => __('SVG font', 'dina-kala'),
                'url'      => true,
                'readonly' => false,
                'library_filter' => array('svg'),
                'mode' => false,
                'preview'  => false,
                'default'  => '',
                'required' => array( 'custom_farsi_font', '=', true ),
            ),
            array(
                'id'     => 'farsi-digits-section-end',
                'type'   => 'section',
                'indent' => false,
            ),

        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'            => __( 'Template style', 'dina-kala' ),
        'icon'             => 'el el-brush',
        'id'               => 'theme-style',
        'subsection'       => true,
        'customizer_width' => '500px',
        'desc'             => __( 'Customize and change the color and style of the template', 'dina-kala' ),
        'fields'           => array(

            array(
                'id'       => 'prod_navs',
                'type'     => 'select',
                'title' => __('Products carousel navigation style', 'dina-kala'),
                'options'  => array(
                    'stone' => __('Style 1', 'dina-kala'),
                    'sttwo' =>  __('Style 2', 'dina-kala'),
                ),
                'default'  => 'stone',
            ),
            array(
                'id'       => 'prod_hover',
                'type'     => 'select',
                'title' => __('Products and posts hover effect', 'dina-kala'),
                'options'  => array(
                    'prblur' => __('Blur', 'dina-kala'),
                    'przoom' =>  __('Zoom in', 'dina-kala'),
                    'prsimple' =>  __('Simple', 'dina-kala'),
                ),
                'default'  => 'prblur',
            ),
            array(
                'id'       => 'full_width_style',
                'type'     => 'switch',
                'title'    => __( 'Full width mode', 'dina-kala' ),
                'subtitle' => __( 'In full width mode, page content is displayed as full screen.', 'dina-kala' ),
                'default'  => false
            ),
            array(
                'id'       => 'rounded_corners',
                'type'     => 'switch',
                'title'    => __( 'Rounded Corners', 'dina-kala' ),
                'subtitle' => __( 'Round corners for different parts of the site.', 'dina-kala' ),
                'default'  => true
            ),
            array(
                'id'       => 'show_sec_img',
                'type'     => 'switch',
                'title'    => __( 'Show the second product image', 'dina-kala' ),
                'subtitle' => __( 'Display the second product image when hovering', 'dina-kala' ),
                'default'  => false
            ),
            array(
                'id'       => 'dis_mobile_color',
                'type'     => 'switch',
                'title'    => __( 'Disable mobile browser address bar color', 'dina-kala' ),
                'default'  => false
            ),
            array(
                'id'       => 'ch_mobile_color',
                'type'     => 'switch',
                'title'    => __( 'Change mobile browser address bar color', 'dina-kala' ),
                'subtitle' => __( 'By default the color of this bar is received from the default color of the theme', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'dis_mobile_color', '!=', true ),
            ),
            array(
                'id'       => 'mobile_bar_color',
                'type'     => 'color',
                'title'    => __( 'Mobile browser address bar color', 'dina-kala' ),
                'default'  => '#17A2B8',
                'validate' => 'color',
                'transparent' => false,
                'required' => array( 'ch_mobile_color', '=', true ),
            ),
                
            array(
            'id'       => 'custom_color',
            'type'     => 'color',
            'title'    => __( 'Template color', 'dina-kala' ),
            'subtitle' => __( 'Choose the color scheme for the template, this color will be displayed as the main theme of the site in most sections, such as the menu and widgets.', 'dina-kala' ),
            'default'  => '#17A2B8',
            'validate' => 'color',
            'transparent' => false,
            ),

            array(
                'id'       => 'slider_tab_color',
                'type'     => 'color',
                'title'    => __( 'Slider title color', 'dina-kala' ),
                'default'  => '#607d8b',
                'validate' => 'color',
                'transparent' => false,
            ),

            array(
                'id'       => 'slider_tab_color_active',
                'type'     => 'color',
                'title'    => __( 'Active slider title color', 'dina-kala' ),
                'default'  => '#455a64',
                'validate' => 'color',
                'transparent' => false,
            ),

            array(
                'id'       => 'price_color',
                'type'     => 'color',
                'title'    => __( 'Price color', 'dina-kala' ),
                'subtitle' => __( 'Choose the color for the prices.', 'dina-kala' ),
                'default'  => '#39b156',
                'validate' => 'color',
                'transparent' => false,
            ),

            array(
                'id' => 'price_font_size',
                'type' => 'slider',
                'title' => __('Product price font size on product page (pixel)', 'dina-kala'),
                "default" => 19,
                "min" => 12,
                "step" => 1,
                "max" => 30,
                'display_value' => 'label'
            ),

            array(
                'id'       => 'dis_color',
                'type'     => 'color',
                'title'    => __( 'Discount badge color', 'dina-kala' ),
                'subtitle' => __( 'Choose the color for the Discount badge.', 'dina-kala' ),
                'default'  => '#ef5350',
                'validate' => 'color',
                'transparent' => false,
            ),

            array(
                'id'       => 'dis_text_color',
                'type'     => 'color',
                'title'    => __( 'Discount badge text color', 'dina-kala' ),
                'subtitle' => __( 'Choose the color for the Discount badge text.', 'dina-kala' ),
                'default'  => '#fff',
                'validate' => 'color',
                'transparent' => false,
            ),

/*
            array(
                'id' => 'dark-mode-section-start',
                'type' => 'section',
                'title' => __( 'Dark mode settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'dina_dark_mode',
                'type'     => 'switch',
                'title'    => __( 'Dark Mode', 'dina-kala' ),
                'subtitle' => __( 'By activating this mode, the coloring of different parts of the template will be displayed in dark mode (dark mode)', 'dina-kala' ),
                'default'  => false
            ),
            array(
                'id'     => 'dark-mode-section-end',
                'type'   => 'section',
                'indent' => false,
            ),
*/
            array(
                'id' => 'read-view-section-start',
                'type' => 'section',
                'title' => __( 'Read more and View product (Add to cart) buttons in archive pages', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_hover_btns',
                'type'     => 'switch',
                'title'    => __( 'Show read more and view product buttons', 'dina-kala' ),
                'default'  => true
            ),
            array(
                'id'       => 'show_hover_btns_fixed',
                'type'     => 'switch',
                'title'    => __( 'Display buttons fixed', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'show_hover_btns', '=', true ),
            ),
            array(
                'id'       => 'hover_btns_fixed_mobile',
                'type'     => 'switch',
                'title'    => __( 'Buttons fixed only in mobile mode', 'dina-kala' ),
                'default'  => false,
                'required' => array( 
                    array( 'show_hover_btns', '=', true ), 
                    array( 'show_hover_btns_fixed', '!=', true ) 
                )
            ),
            array(
            'id'       => 'read_product_color',
            'type'     => 'color',
            'title'    => __( 'Read more and View product buttons color', 'dina-kala' ),
            'default'  => '#28A745',
            'validate' => 'color',
            'transparent' => false,
            'required' => array( 'show_hover_btns', '=', true ),
            ),
            array(
            'id'       => 'read_product_text_color',
            'type'     => 'color',
            'title'    => __( 'Read more and View product buttons text color', 'dina-kala' ),
            'default'  => '#fff',
            'validate' => 'color',
            'transparent' => false,
            'required' => array( 'show_hover_btns', '=', true ),
            ),
            array(
            'id'       => 'read_product_hover_color',
            'type'     => 'color',
            'title'    => __( 'Read more and View product buttons hover and click color', 'dina-kala' ),
            'default'  => '#1E7E34',
            'validate' => 'color',
            'transparent' => false, 
            'required' => array( 'show_hover_btns', '=', true ),
            ),
            array(
            'id'       => 'read_product_hover_text_color',
            'type'     => 'color',
            'title'    => __( 'Read more and View product buttons hover and click text color', 'dina-kala' ),
            'default'  => '#fff',
            'validate' => 'color',
            'transparent' => false,
            'required' => array( 'show_hover_btns', '=', true ),
            ),
            array(
                'id'     => 'read-view-section-end',
                'type'   => 'section',
                'indent' => false,
           ),
           
           array(
            'id' => 'add-btn-section-start',
            'type' => 'section',
            'title' => __( 'Add to cart button in product page', 'dina-kala' ),
            'indent' => true,
            ),
           array(
            'id'       => 'add_btn_color',
            'type'     => 'color',
            'title'    => __( 'Add to cart button color', 'dina-kala' ),
            'default'  => '#28A745',
            'validate' => 'color',
            'transparent' => false,
            ),
            array(
            'id'       => 'add_btn_text_color',
            'type'     => 'color',
            'title'    => __( 'Add to cart button text color', 'dina-kala' ),
            'default'  => '#fff',
            'validate' => 'color',
            'transparent' => false,
            ),
            array(
                'id'     => 'add-btn-section-end',
                'type'   => 'section',
                'indent' => false,
           ),

           //login btn color
           array(
            'id' => 'login-btn-section-start',
            'type' => 'section',
            'title' => __( 'Login button in header', 'dina-kala' ),
            'indent' => true,
            ),
           array(
            'id'       => 'login_btn_color',
            'type'     => 'color',
            'title'    => __( 'Login button color', 'dina-kala' ),
            'default'  => '#fff',
            'validate' => 'color',
            'transparent' => false,
            ),
            array(
            'id'       => 'login_btn_text_color',
            'type'     => 'color',
            'title'    => __( 'Login button text color', 'dina-kala' ),
            'default'  => '#28a745',
            'validate' => 'color',
            'transparent' => false,
            ),
            array(
            'id'       => 'login_btn_hover_color',
            'type'     => 'color',
            'title'    => __( 'Login button hover and click color', 'dina-kala' ),
            'default'  => '#28a745',
            'validate' => 'color',
            'transparent' => false,
            ),
            array(
            'id'       => 'login_btn_hover_text_color',
            'type'     => 'color',
            'title'    => __( 'Login button hover and click text color', 'dina-kala' ),
            'default'  => '#fff',
            'validate' => 'color',
            'transparent' => false,
            ),
            array(
                'id'     => 'login-btn-section-end',
                'type'   => 'section',
                'indent' => false,
           ),

           //register btn color
           array(
            'id' => 'register-btn-section-start',
            'type' => 'section',
            'title' => __( 'Register button in header', 'dina-kala' ),
            'indent' => true,
            ),
           array(
            'id'       => 'register_btn_color',
            'type'     => 'color',
            'title'    => __( 'Register button color', 'dina-kala' ),
            'default'  => '#28a745',
            'validate' => 'color',
            'transparent' => false,
            ),
            array(
            'id'       => 'register_btn_text_color',
            'type'     => 'color',
            'title'    => __( 'Register button text color', 'dina-kala' ),
            'default'  => '#fff',
            'validate' => 'color',
            'transparent' => false,
            ),
            array(
            'id'       => 'register_btn_hover_color',
            'type'     => 'color',
            'title'    => __( 'Register button hover and click color', 'dina-kala' ),
            'default'  => '#218838',
            'validate' => 'color',
            'transparent' => false,
            ),
            array(
            'id'       => 'register_btn_hover_text_color',
            'type'     => 'color',
            'title'    => __( 'Register button hover and click text color', 'dina-kala' ),
            'default'  => '#fff',
            'validate' => 'color',
            'transparent' => false,
            ),
            array(
                'id'     => 'register-btn-section-end',
                'type'   => 'section',
                'indent' => false,
           ),
            
            //Site Background Section
            array(
                'id' => 'bg-section-start',
                'type' => 'section',
                'title' => __( 'Site Background', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'site_bg',
                'type'     => 'image_select',
                'output'    => array('body.theme-dinakala'), // An array of CSS selectors
                'tiles'    => true,
                'title'    => __( 'Background', 'dina-kala' ),
                'subtitle' => __( 'Select a picture as a background.', 'dina-kala' ),
                'options'  => $sample_patterns,
                'required' => array( 'bg_switch', '!=', true ),
            ),
            array(
                'id'       => 'bg_switch',
                'type'     => 'switch',
                'title'    => __( 'Custom background', 'dina-kala' ),
                'subtitle' => __( 'Choose a background color or upload a custom photo', 'dina-kala' ),
                'default'  => false
            ),
            array(         
                'id'       => 'site_bg_custom',
                'output'    => array('body.theme-dinakala'), // An array of CSS selectors
                'type'     => 'background',
                'title'    => __( 'Customize the site background according to your taste.', 'dina-kala' ),
                'default'  => array(
                    'background-color' => '#F5F5F5',
                ),
                'required' => array( 'bg_switch', '=', true ),
            ),
            array(
                'id'     => 'bg-section-end',
                'type'   => 'section',
                'indent' => false,
           ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'            => __( 'General settings', 'dina-kala' ),
        'id'               => 'general_setting',
        'customizer_width' => '500px',
        'icon'             => 'el el-cogs',
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Maintenance mode', 'dina-kala' ),
        'icon'       => 'el el-wrench',
        'id'         => 'maintenance_mode',
        'desc'       => __( 'In the site maintenance mode it will be unavailable to users and only the administrator can view it', 'dina-kala' ),
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'maintenance',
                'type'     => 'switch',
                'title'    => __( 'Enable maintenance mode', 'dina-kala' ),
                'subtitle' => __( 'In this case, the site will be unavailable to users', 'dina-kala' ),
                'default'  => false,
            ),
            array(
                'id'       => 'show_counter',
                'type'     => 'switch',
                'title'    => __( 'Enable date countdown', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'maintenance', '=', true ),
            ),
            array(
                'id'          => 'date_counter',
                'type'        => 'date',
                'title'       => __('Completion date', 'dina-kala'),
                'subtitle'    => __('Completion date of the countdown', 'dina-kala'),
                'placeholder' => __('Click to enter a date', 'dina-kala'),
                'required'    => array( 'show_counter', '=', true ),
            ),
            array(
                'id'       => 'maintenance_title',
                'type'     => 'text',
                'title'    => __( 'Title', 'dina-kala' ),
                'subtitle' => __( 'Maintenance mode title', 'dina-kala' ),
                'default'  => __( 'Maintenance Mode', 'dina-kala' ),
                'required' => array( 'maintenance', '=', true ),
            ),
            array(
                'id'      => 'maintenance_msg',
                'type'    => 'editor',
                'title'   => __( 'Message', 'dina-kala' ),
                'default'  => __( 'Site is under construction, please be patient.', 'dina-kala' ),
                'args'    => array(
                    'wpautop'       => false,
                    'media_buttons' => false,
                    'textarea_rows' => 5,
                    'teeny'         => false,
                    'quicktags'     => true,
                ),
                'required' => array( 'maintenance', '=', true ),
            ),

            array(
                'id' => 'maintenance-style-section-start',
                'type' => 'section',
                'title' => __( 'Maintenance mode style settings', 'dina-kala' ),
                'indent' => true,
                'required' => array( 'maintenance', '=', true ),
            ),
            array(
                'id'       => 'maintenance_text_color',
                'type'     => 'color',
                'title'    => __( 'Maintenance mode text color', 'dina-kala' ),
                'default'  => '#212529',
                'validate' => 'color',
                'transparent' => false,
                'required' => array( 
                    array( 'maintenance', '=', true ), 
                )
            ),
            array(
                'id'       => 'maintenance_bg',
                'type'     => 'image_select',
                'output'    => array('.maintenance-mode'),
                'tiles'    => true,
                'title'    => __('Maintenance mode background', 'dina-kala'),
                'subtitle' => __("Select an image as the background of the maintenance mode.",'dina-kala'),
                'options'  => $footer_patterns,
                'required' => array( 
                    array( 'maintenance', '=', true ), 
                    array( 'mbg_switch', '!=', true ) 
                )
            ),
            array(
                'id'       => 'mbg_switch',
                'type'     => 'switch',
                'title'    => __('Custom Maintenance mode Background', 'dina-kala'),
                'subtitle' => __('Choose a background color or upload a custom photo to the Maintenance mode', 'dina-kala'),
                'default'  => false,
                'required' => array( 'maintenance', '=', true ),
            ),
            array(         
                'id'       => 'maintenance_custom_bg',
                'output'    => array('.maintenance-mode'),
                'type'     => 'background',
                'title'    => __( 'Maintenance mode background', 'dina-kala' ),
                'default'  => array(
                    'background-color' => '#F4F5F9',
                ),
                'required' => array( 'mbg_switch', '=', true ),
                'required' => array( 
                    array( 'maintenance', '=', true ),
                    array( 'mbg_switch', '=', true ) 
                )
            ),
            array(
                'id' => 'maintenance-style-section-end',
                'type' => 'section',
                'indent' => false,
            ),
        ),
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Header settings', 'dina-kala' ),
        'icon'       => 'el el-credit-card',
        'id'         => 'header-setting',
        'subsection' => true,
        'desc'       => __( 'Customize site header', 'dina-kala' ),
        'fields'     => array(
            array(
                'id'       => 'head_pos',
                'type'     => 'image_select',
                'title'    =>  __( 'Header Menu position', 'dina-kala' ),
                'subtitle' => __( 'Locate the Header Menu.', 'dina-kala' ),
                'options'  => array(
                    '1' => array(
                        'alt' => __( 'Right', 'dina-kala' ),
                        'img' => RE_URI . 'assets/img/rmenu.png'
                    ),
                    '2' => array(
                        'alt' => __( 'Left', 'dina-kala' ),
                        'img' => RE_URI . 'assets/img/lmenu.png'
                    ),
                ),
                'default'  => '1'
            ),
            array(
                'id'       => 'logo_pos',
                'type'     => 'image_select',
                'title'    =>  __( 'Logo position', 'dina-kala' ),
                'subtitle' => __( 'Locate the site logo.', 'dina-kala' ),
                'options'  => array(
                    '1' => array(
                        'alt' => __( 'Right alignment', 'dina-kala' ),
                        'img' => RE_URI . 'assets/img/rlogo.png'
                    ),
                    '2' => array(
                        'alt' => __( 'Left alignment', 'dina-kala' ),
                        'img' => RE_URI . 'assets/img/llogo.png'
                    ),
                ),
                'default'  => '1'
            ),
            array(
                'id'       => 'mobile_logo_pos',
                'type'     => 'image_select',
                'title'    =>  __( 'Mobile logo position', 'dina-kala' ),
                'subtitle' => __( 'Locate the site logo in mobile.', 'dina-kala' ),
                'options'  => array(
                    '1' => array(
                        'alt' => __( 'Right alignment', 'dina-kala' ),
                        'img' => RE_URI . 'assets/img/rlogo.png'
                    ),
                    '3' => array(
                        'alt' => __( 'Middle alignment', 'dina-kala' ),
                        'img' => RE_URI . 'assets/img/mlogo.png'
                    ),
                    '2' => array(
                        'alt' => __( 'Left alignment', 'dina-kala' ),
                        'img' => RE_URI . 'assets/img/llogo.png'
                    ),
                ),
                'default'  => '2'
            ),
            array(
                'id'       => 'add_home_heading',
                'type'     => 'switch',
                'title'    => __('Add an H1 tag to the logo', 'dina-kala'),
                'subtitle' => __('Add an H1 tag to the logo on the home screen', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'hide_top_bar',
                'type'     => 'switch',
                'title'    => __('Hide Site Top Bar (Contact, Menu and Social)', 'dina-kala'),
                'subtitle' => __('By Activating this option site top bar not displayed.', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'show_cart_btn',
                'type'     => 'switch',
                'title'    => __( 'Show Cart button', 'dina-kala' ),
                'subtitle' => __( 'Show Cart button in menu bar', 'dina-kala' ),
                'default'  => true,
            ),
            array(
                'id'       => 'show_wish_list',
                'type'     => 'switch',
                'title'    => __( 'Show Wishlist button', 'dina-kala' ),
                'subtitle' => __( 'Show Wishlist button in menu bar', 'dina-kala' ),
                'default'  => true,
            ),
            array(
                'id'       => 'show_compare_btn',
                'type'     => 'switch',
                'title'    => __( 'Show Compare button', 'dina-kala' ),
                'subtitle' => __( 'Show Compare button in menu bar', 'dina-kala' ),
                'default'  => true,
            ),
           
            array(
                'id'       => 'show_loading_bar',
                'type'     => 'switch',
                'title'    => __( 'Loading bar', 'dina-kala' ),
                'subtitle' => __( 'View the loading bar at the top of the site', 'dina-kala' ),
                'default'  => true,
            ),

            array(
                'id' => 'mobile-header-section-start',
                'type' => 'section',
                'title' => __( 'Mobile header settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'ch_menu_cart',
                'type'     => 'switch',
                'title'    => __( 'Change mobile menu button to shopping cart', 'dina-kala' ),
                'subtitle' => __( 'Enabling this option will change the mobile menu open button to the shopping cart, you can display the menu button in the bottom bar of the mobile from the mobile navigation bar settings.', 'dina-kala' ),
                'default'  => false,
            ),
            array(
                'id'     => 'mobile-header-section-end',
                'type'   => 'section',
                'indent' => false,
            ),

            array(
                'id' => 'bread-section-start',
                'type' => 'section',
                'title' => __( 'Breadcrumbs settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_bread',
                'type'     => 'switch',
                'title'    => __( 'Breadcrumbs', 'dina-kala' ),
                'subtitle' => __( 'Show the breadcrumbs (your links on the route sign)', 'dina-kala' ),
                'default'  => true,
            ),
            array(
                'id'       => 'show_bread_mobile',
                'type'     => 'switch',
                'title'    => __( 'Show breadcrumbs in mobile mode', 'dina-kala' ),
                'default'  => true,
                'required' => array( 'show_bread', '=', true ),
            ),
            array(
                'id'       => 'change_home_text',
                'type'     => 'switch',
                'title'    => __( 'Change home text', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'show_bread', '=', true ),
            ),
            array(
                'id'       => 'home_text',
                'type'     => 'text',
                'title' => __('Home text', 'dina-kala'),
                'required' => array( 'change_home_text', '=', true ),
            ),
            array(
                'id'     => 'bread-section-end',
                'type'   => 'section',
                'indent' => false,
            ),

            array(
                'id' => 'menu-section-start',
                'type' => 'section',
                'title' => __( 'Menu settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'mobile_head_menu',
                'type'     => 'switch',
                'title'    => __('Display header menu in mobile mode', 'dina-kala'),
                'default'  => false,
                'required' => array( 'hide_top_bar', '!=', true ),
            ),
            array(
                'id'       => 'maga_column',
                'type'     => 'select',
                'title' => __('Number of Megamenu columns', 'dina-kala'),
                'options'  => array(
                    'three' => __('Three columns', 'dina-kala'),
                    'four' =>  __('Four columns', 'dina-kala'),
                    'five' =>  __('Five columns', 'dina-kala'),
                    'six' =>  __('Six columns', 'dina-kala'),
                    'seven' =>  __('Seven columns', 'dina-kala'),
                    'eight' =>  __('Eight columns', 'dina-kala'),
                ),
                'default'  => 'four',
            ),
            array(
                'id'       => 'mega_style',
                'type'     => 'select',
                'title' => __('Megamenu style', 'dina-kala'),
                'options'  => array(
                    'first' => __('First style', 'dina-kala'),
                    'second' =>  __('Second style', 'dina-kala'),
                ),
                'default'  => 'first',
            ),
            array(
                'id'       => 'menu_hover_bottom',
                'type'     => 'switch',
                'title'    => __( 'Show the hover menu line at the bottom', 'dina-kala' ),
                'default'  => false,
            ),
            array(
                'id'       => 'fixed_head_top',
                'type'     => 'switch',
                'title'    => __( 'Fixed menu', 'dina-kala' ),
                'subtitle' => __( 'Fixed the header menu when scrolling through the site', 'dina-kala' ),
                'default'  => true,
            ),
            array(
                'id'       => 'fixed_head_mobile',
                'type'     => 'switch',
                'title'    => __( 'Fixed menu in mobile', 'dina-kala' ),
                'subtitle' => __( 'Fixed the header menu when scrolling through the site in mobile mode', 'dina-kala' ),
                'default'  => false,
            ),
            array(
                'id'       => 'fixed_head_logo',
                'type'     => 'switch',
                'title'    => __( 'Display the logo in the sticky menu', 'dina-kala' ),
                'subtitle' => __( 'Display the logo in the computer sticky menu', 'dina-kala' ),
                'default'  => false,
            ),
            array(
                'id'       => 'change_fixed_logo',
                'type'     => 'switch',
                'title'    => __( 'Replace the sticky menu logo', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'fixed_head_logo', '=', true ),
            ),
            array(
                'id'       => 'sticky_logo',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'Sticky logo', 'dina-kala' ),
                'compiler' => 'true',
                'subtitle' => __( 'Appropriate size: 107(w) in 37(h)', 'dina-kala' ),
                'required' => array( 'change_fixed_logo', '=', true ),
            ),
            array(
                'id'       => 'show_mobile_logo',
                'type'     => 'switch',
                'title'    => __( 'Display the logo in the mobile side menu', 'dina-kala' ),
                'default'  => false,
            ),
            array(
                'id'       => 'replace_mobile_menu',
                'type'     => 'switch',
                'title'    => __( 'Replace mobile menu with custom menu', 'dina-kala' ),
                'subtitle' => __( 'Enabling this option will add a separate place for the mobile side menu to the menu management page.', 'dina-kala' ),
                'default'  => false,
            ),
            array(
                'id'       => 'focus_nav',
                'type'     => 'switch',
                'title'    => __( 'Page darkening', 'dina-kala' ),
                'subtitle' => __( 'Darken the page by hovering over the menu', 'dina-kala' ),
                'default'  => true,
            ),
            array(
                'id'       => 'remove_parent_link',
                'type'     => 'switch',
                'title'    => __( 'Remove the parent menus link', 'dina-kala' ),
                'subtitle' => __( 'Remove the parent menus link in the mobile menu', 'dina-kala' ),
                'default'  => false,
            ),
            array(
                'id'       => 'menu_label_text_color',
                'type'     => 'color',
                'title'    => __( 'Menu label text color', 'dina-kala' ),
                'subtitle' => __( 'The text color of the labels added from the menu management page', 'dina-kala' ),
                'default'  => '#ffffff',
                'validate' => 'color',
                'transparent' => false,
            ),
            array(
                'id'       => 'menu_label_bg_color',
                'type'     => 'color',
                'title'    => __( 'Menu label background color', 'dina-kala' ),
                'subtitle' => __( 'The background color of the labels added from the menu management page', 'dina-kala' ),
                'default'  => '#EF5350',
                'validate' => 'color',
                'transparent' => false,
            ),
            array(
                'id'     => 'menu-section-end',
                'type'   => 'section',
                'indent' => false,
           ),

            array(
                'id' => 'search-section-start',
                'type' => 'section',
                'title' => __( 'Search settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'mobile_search',
                'type'     => 'switch',
                'title'    => __('Move search box from site menu to site logo on mobile', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'ajax_search',
                'type'     => 'switch',
                'title'    => __('Ajax live search', 'dina-kala'),
                'subtitle' => __('Enabling this feature will show search results by entering a keyword', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'ajax_count',
                'type'     => 'spinner', 
                'title'    => __('Number of Ajax search results', 'dina-kala'),
                'default'  => '10',
                'min'      => '1',
                'step'     => '1',
                'max'      => '20',
                'required' => array( 'ajax_search', '=', true ),
            ),
            array(
                'id'       => 'ajax_search_stock',
                'type'     => 'switch',
                'title'    => __('Sort results by stock status', 'dina-kala'),
                'default'  => false,
                'required' => array( 'ajax_search', '=', true ),
            ),
            array(
                'id'       => 'search_cat',
                'type'     => 'switch',
                'title'    => __('Show Search Category', 'dina-kala'),
                'subtitle' => __('Show category box in search section', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'search_cat_sort',
                'type'     => 'switch',
                'title'    => __('Sort categories alphabetically', 'dina-kala'),
                'default'  => false,
                'required' => array( 'search_cat', '=', true )
            ),
            array(
                'id'       => 'search_cat_parent',
                'type'     => 'switch',
                'title'    => __('Parent categories only', 'dina-kala'),
                'subtitle' => __('By activating this option, only the first level categories are displayed', 'dina-kala'),
                'default'  => false,
                'required' => array( 'search_cat', '=', true )
            ),
            array(
                'id'    => 'search_cat_cats',
                'type'     => 'select',
                'multi'    => true,
                'title' => __( 'Hide categories', 'dina-kala' ), 
                'subtitle' => __('Selected categories are not displayed in the search box', 'dina-kala'),
                'data'  => 'terms',
                'args'  => array(
                    'taxonomies' => array( 'product_cat' ),
                    'hide_empty' => false,
                ),
                'required' => array( 'search_cat', '=', true )
            ),
            array(
                'id'       => 'search_others',
                'type'     => 'switch',
                'title'    => __('Search pages and posts', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'search_by_sku',
                'type'     => 'switch',
                'title'    => __('Search by product SKU', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'replace_search_shortcode',
                'type'     => 'switch',
                'title'    => __('Insert shortcode instead of search form', 'dina-kala'),
                'subtitle' => __('The content of this shortcode will be displayed instead of the search box', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'search_shortcode',
                'type'     => 'text',
                'title'    => __('Search shortcode', 'dina-kala'),
                'subtitle'  => __('With this feature, you can use the short code of other search plugins', 'dina-kala'),
                'required' => array( 'replace_search_shortcode', '=', true ),
            ),
            array(
                'id'       => 'replace_search_shortcode',
                'type'     => 'switch',
                'title'    => __('Insert shortcode instead of search form', 'dina-kala'),
                'subtitle' => __('The content of this shortcode will be displayed instead of the search box', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'search_shortcode',
                'type'     => 'text',
                'title'    => __('Search shortcode', 'dina-kala'),
                'subtitle'  => __('With this feature, you can use the shortcode of other search plugins', 'dina-kala'),
                'required' => array( 'replace_search_shortcode', '=', true ),
            ),
            array(
                'id'     => 'search-section-end',
                'type'   => 'section',
                'indent' => false,
            ),

            
            array(
                'id' => 'user-btn-section-start',
                'type' => 'section',
                'title' => __( 'User Buttons settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_user_btn',
                'type'     => 'switch',
                'title'    => __( 'User Buttons', 'dina-kala' ),
                'subtitle' => __( 'Show user buttons (login, register and user menu) in the header section', 'dina-kala' ),
                'default'  => true,
            ),
            array(
                'id'       => 'merge_user_btn',
                'type'     => 'switch',
                'title'    => __( 'Merge buttons', 'dina-kala' ),
                'subtitle' => __( 'Integration of login and registration buttons', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'show_user_btn', '=', true ),
            ),
            array(
                'id'       => 'user_btn_style',
                'type'     => 'switch',
                'title'    => __( 'User Buttons Text style', 'dina-kala' ),
                'subtitle' => __( 'Show user buttons (login and register) in text style', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'show_user_btn', '=', true ),
            ),
            array(
                'id'       => 'show_mo_btn',
                'type'     => 'switch',
                'title'    => __( 'Show user buttons in mobile mode', 'dina-kala' ),
                'default'  => true,
                'required' => array( 'show_user_btn', '=', true ),
            ),
            array(
                'id'       => 'digits_mode',
                'type'     => 'switch',
                'title'    => __( 'Compatibility with Digits plugin', 'dina-kala' ),
                'subtitle' => __('If you have a Digit plugin installed, the login and registration buttons will be connected to this plugin', 'dina-kala'),
                'default'  => true,
                'required' => array( 'show_user_btn', '=', true ),
            ),
            array(
                'id'       => 'digits_page',
                'type'     => 'switch',
                'title'    => __( 'Link to Digits page instead of pop-up mode', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'digits_mode', '=', true ),
            ),
            array(
                'id'       => 'recapcha_login',
                'type'     => 'switch',
                'title'    => __('Google Captcha in the login section', 'dina-kala'),
                'subtitle' => __('Activate Google Captcha in login form', 'dina-kala'),
                'default'  => false,
                'required' => array( 'show_user_btn', '=', true ),
            ),
            array(
                'id'       => 'site_key',
                'type'     => 'text',
                'title' => __('Site key', 'dina-kala'),
                'description' => __('Get it from the link: <a href="https://www.google.com/recaptcha/" target="_blank"> Google</a>', 'dina-kala'),
                'required' => array( 'recapcha_login', '=', true ),
            ),
            array(
                'id'       => 'site_secret',
                'type'     => 'text',
                'title' => __('Security key', 'dina-kala'),
                'description' => __('Get it from the link: <a href="https://www.google.com/recaptcha/" target="_blank"> Google</a>', 'dina-kala'),
                'required' => array( 'recapcha_login', '=', true ),
            ),
            array(
                'id'       => 'ch_login_link',
                'type'     => 'switch',
                'title' => __( 'Change link to the login page', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'show_user_btn', '=', true ),
            ),
            array(
                'id'       => 'login_link',
                'type'     => 'text',
                'title' => __( 'Link to the login page', 'dina-kala' ),
                'Subtitle' => __( 'Full page link', 'dina-kala' ),
                'description' => __( 'Example: http://example.com/login', 'dina-kala' ),
                'default'  => '#',
                'required' => array( 'ch_login_link', '=', true ),
            ),
            array(
                'id'       => 'ch_register_link',
                'type'     => 'switch',
                'title' => __( 'Change link to the register page', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'show_user_btn', '=', true ),
            ),
            array(
                'id'       => 'register_link',
                'type'     => 'text',
                'title'    => __( 'Link to the register page', 'dina-kala' ),
                'subtitle' => __( 'Full page link', 'dina-kala' ),
                'description' => __( 'Example: http://example.com/register', 'dina-kala' ),
                'default'  => '#',
                'required' => array( 'ch_register_link', '=', true ),
            ),
            array(
                'id'       => 'replace_user_menu',
                'type'     => 'switch',
                'title' => __( 'Replace the user menu with a custom menu', 'dina-kala' ),
                'subtitle' => __( 'Added a place in WordPress menus to replace the user menu (this menu options are displayed instead of the user menu)', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'show_user_btn', '=', true ),
            ),
            array(
                'id'       => 'replace_userbtns_shortcode',
                'type'     => 'switch',
                'title'    => __('Insert shortcode instead of user buttons', 'dina-kala'),
                'subtitle' => __('The content of this shortcode will be displayed instead of the user buttons', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'userbtns_shortcode',
                'type'     => 'text',
                'title'    => __('User buttons shortcode', 'dina-kala'),
                'subtitle'  => __('With this feature, you can use the shortcode of other user panel plugins', 'dina-kala'),
                'required' => array( 'replace_userbtns_shortcode', '=', true ),
            ),
            array(
                'id' => 'user-btn-section-end',
                'type' => 'section',
                'indent' => false,
            ),

            array(
                'id' => 'msg-section-start',
                'type' => 'section',
                'title' => __( 'Message section settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_msg',
                'type'     => 'switch',
                'title'    => __( 'Show message', 'dina-kala' ),
                'subtitle' => __( 'Show message section', 'dina-kala' ),
                'default'  => true,
            ),
            array(
                'id'       => 'hide_msg_logged',
                'type'     => 'switch',
                'title'    => __( 'Hide for logged in users', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'show_msg', '=', true )
            ),
            array(
                'id'=>'site_msg',
                'type' => 'textarea',
                'title' => __( 'Text message', 'dina-kala' ),
                'default' => __( 'Sell Easy with DinaKala and Start Making Your Internet Money!', 'dina-kala' ),
                'allowed_html' => array(
                    'a' => array(
                        'href' => array(),
                        'title' => array()
                    ),
                    'br' => array(),
                    'em' => array(),
                    'strong' => array()
                ),
                'required' => array(
                    array( 'show_msg', '=', true ), 
                    array( 'show_img_msg', '!=', true ) 
                )
            ),
            array(
                'id'       => 'msg_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __( 'Icon', 'dina-kala' ),
                'class'    => ' font-icons fal',
                'default'  => 'fal fa-bell',
                'options'  => $alliconArray,
                'required' => array( 
                    array( 'show_msg', '=', true ), 
                    array( 'show_img_msg', '!=', true ) 
                )
            ),
            array(
                'id'       => 'msg_btn',
                'type'     => 'switch',
                'title'    => __( 'Show button', 'dina-kala' ),
                'default'  => false,
                'required' => array( 
                    array( 'show_msg', '=', true ), 
                    array( 'show_img_msg', '!=', true ) 
                )
            ),
            array(
                'id'       => 'msg_btn_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __( 'Button icon', 'dina-kala' ),
                'class'    => ' font-icons fal',
                'default'  => 'fal fa-arrow-left',
                'options'  => $alliconArray,
                'required' => array( 
                    array( 'show_msg', '=', true ), 
                    array( 'show_img_msg', '!=', true ) 
                )
            ),
            array(
                'id'       => 'msg_btn_icon_before',
                'type'     => 'switch',
                'title'    => __( 'Show icon before text', 'dina-kala' ),
                'default'  => false,
                'required' => array( 
                    array( 'show_msg', '=', true ), 
                    array( 'show_img_msg', '!=', true ) 
                )
            ),
            array(
                'id'       => 'msg_btn_color',
                'type'     => 'select',
                'title' => __( 'Button color', 'dina-kala' ),
                'options'  => array(
                    'btn-outline-dina'  =>  __( 'Theme Color', 'dina-kala' ),
                    'btn-outline-info'  =>  __( 'Blue', 'dina-kala' ),
                    'btn-outline-primary'  =>  __( 'Dark Blue', 'dina-kala' ),
                    'btn-outline-warning' =>  __( 'Yellow', 'dina-kala' ),
                    'btn-outline-success'  =>  __( 'Green', 'dina-kala' ),
                    'btn-outline-dark'  =>  __( 'Dark', 'dina-kala' ),
                    'btn-outline-danger'  =>  __( 'Red', 'dina-kala' ),
                    'btn-info'  =>  __( 'Solid Blue', 'dina-kala' ),
                    'btn-primary'  =>  __( 'Solid Dark Blue', 'dina-kala' ),
                    'btn-warning' =>  __( 'Solid Yellow', 'dina-kala' ),
                    'btn-success'  =>  __( 'Solid Green', 'dina-kala' ),
                    'btn-dark'  =>  __( 'Solid Dark', 'dina-kala' ),
                    'btn-danger'  =>  __( 'Solid Red', 'dina-kala' )
                ),
                'default'  => 'btn-success',
                'required' => array( 'msg_btn', '=', true ),
            ),
            array(
                'id'       => 'msg_btn_text',
                'type'     => 'text',
                'title' => __( 'Button text', 'dina-kala' ),
                'default'  => __( 'View and buy', 'dina-kala' ),
                'required' => array( 'msg_btn', '=', true ),
            ),
            array(
                'id'       => 'msg_btn_link',
                'type'     => 'text',
                'title' => __( 'Button link', 'dina-kala' ),
                'default'  => '#',
                'required' => array( 'msg_btn', '=', true ),
            ),
            array(
                'id'       => 'user_close',
                'type'     => 'switch',
                'title'    => __( 'User closure', 'dina-kala' ),
                'default'  => true,
                'required' => array( 
                    array( 'show_msg', '=', true ), 
                    array( 'show_img_msg', '!=', true ) 
                )
            ),
            array(
            'id'       => 'msg_bgcolor',
            'type'     => 'color',
            'title'    => __( 'Background color', 'dina-kala' ),
            'default'  => '#37474F',
            'validate' => 'color',
            'transparent' => false,
            'required' => array( 
                array( 'show_msg', '=', true ), 
                array( 'show_img_msg', '!=', true ) 
            )
            ),
            array(
            'id'       => 'msg_fcolor',
            'type'     => 'color',
            'title'    => __( 'Text message color', 'dina-kala' ),
            'default'  => '#ffffff',
            'validate' => 'color',
            'transparent' => false,
            'required' => array( 
                array( 'show_msg', '=', true ), 
                array( 'show_img_msg', '!=', true ) 
            )
            ),
            //show_img_msg
            array(
                'id'       => 'show_img_msg',
                'type'     => 'switch',
                'title'    => __( 'Replace the message with an image', 'dina-kala' ),
                'subtitle' => __( 'By activating this option, the image you want will be displayed instead of the message at the top of the site', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'show_msg', '=', true ),
            ),
            array(
                'id'       => 'img_msg_image',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'Message image', 'dina-kala' ),
                'compiler' => 'true',
                'mode'      => false,
                'desc'     => __( 'Upload your message image.', 'dina-kala' ),
                'subtitle' => __( 'Appropriate size: 2560(w) in 60(h). This image is displayed in different screen sizes, cut from the sides and is not displayed in mobile mode. Place the subject of the image in the center of the image.', 'dina-kala' ),
                'required' => array( 'show_img_msg', '=', true ),
            ),
            array(
                'id'       => 'img_msg_image_mobile',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'Mobile message image', 'dina-kala' ),
                'compiler' => 'true',
                'mode'      => false,
                'desc'     => __( 'Upload your message image for mobile devices.', 'dina-kala' ),
                'subtitle' => __( 'Appropriate size: 425(w) in 60(h). This image is displayed in mobile mode. Place the subject of the image in the center of the image.', 'dina-kala' ),
                'required' => array( 'show_img_msg', '=', true ),
            ),
            array(
                'id'       => 'img_msg_title',
                'type'     => 'text',
                'title' => __( 'Message image title', 'dina-kala' ),
                'default'  => __( 'Image title', 'dina-kala' ),
                'required' => array( 'show_img_msg', '=', true ),
            ),
            array(
                'id'       => 'img_msg_link',
                'type'     => 'text',
                'title' => __( 'Message image link', 'dina-kala' ),
                'default'  => '#',
                'required' => array( 'show_img_msg', '=', true ),
            ),
            array(
                'id' => 'msg-section-end',
                'type' => 'section',
                'indent' => false,
            ),

            array(
                'id' => 'contact-section-start',
                'type' => 'section',
                'title' => __( 'Contact information settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_head_social',
                'type'     => 'switch',
                'title'    => __( 'View social networks in header', 'dina-kala' ),
                'subtitle' => __( 'View social networks instead of contact information', 'dina-kala' ),
                'default'  => false,
            ),
            array(
                'id'       => 'show_contact',
                'type'     => 'switch',
                'title'    => __( 'Contact information', 'dina-kala' ),
                'subtitle' => __( 'Show contact information', 'dina-kala' ),
                'default'  => true,
                'required' => array( 'show_head_social', '!=', true ),
            ),
            array(
                'id'       => 'replace_email',
                'type'     => 'switch',
                'title'    => __( 'Replace email with phone', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'show_head_social', '!=', true ),
            ),
            array(
                'id'       => 'site_tel',
                'type'     => 'text',
                'title'    => __( 'Phone', 'dina-kala' ),
                'default'  => '09123332222',
                'required' => array( 'show_contact', '=', true ),
            ),
            array(
                'id'       => 'site_email',
                'type'     => 'text',
                'title' => __( 'Email', 'dina-kala' ),
                'default'  => 'info@site.com',
                'required' => array( 
                    array( 'show_contact', '=', true ), 
                    array( 'replace_email', '!=', true ) 
                )
            ),
            array(
                'id'       => 'site_tel2',
                'type'     => 'text',
                'title' => __( 'Phone2', 'dina-kala' ),
                'default'  => '09123332222',
                'required' => array( 'replace_email', '=', true ),
            ),
            array(
                'id' => 'contact-section-end',
                'type' => 'section',
                'indent' => false,
            ),

            array(
                'id' => 'hstyle-section-start',
                'type' => 'section',
                'title' => __( 'Header style settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
            'id'       => 'head_bg_color',
            'type'     => 'color',
            'title'    => __( 'Header background color', 'dina-kala' ),
            'subtitle' => __( 'Choose the color scheme for the site header background color', 'dina-kala' ),
            'default'  => '#fff',
            'validate' => 'color',
            'transparent' => false,
            ),
            array(
            'id'       => 'head_text_color',
            'type'     => 'color',
            'title'    => __( 'Header text color', 'dina-kala' ),
            'subtitle' => __( 'Choose the color scheme for the site header text color', 'dina-kala' ),
            'default'  => '#505763',
            'validate' => 'color',
            'transparent' => false,
            ),
            array(
            'id'       => 'menu_bg_color',
            'type'     => 'color',
            'title'    => __( 'Primary menu background color', 'dina-kala' ),
            'subtitle' => __( 'Choose the color scheme for the primary menu background color', 'dina-kala' ),
            'default'  => '#F7F6F6',
            'validate' => 'color',
            'transparent' => false,
            ),
            array(
            'id'       => 'menu_text_color',
            'type'     => 'color',
            'title'    => __( 'Primary menu text color', 'dina-kala' ),
            'subtitle' => __( 'Choose the color scheme for the primary menu text color', 'dina-kala' ),
            'default'  => '#4D4D4D',
            'validate' => 'color',
            'transparent' => false,
            ),
            array(
                'id' => 'hstyle-section-end',
                'type' => 'section',
                'indent' => false ,
            ),

            array(
                'id' => 'head-banner-section-start',
                'type' => 'section',
                'title' => __( 'Header advertising banner settings', 'dina-kala' ),
                'subtitle' => __( 'This banner is displayed on the archive pages, postd and products at the bottom of the breadcrumbs.', 'dina-kala' ),
                'indent' => true,
            ),


            array(
                'id'       => 'show_head_banner',
                'type'     => 'switch',
                'title'    => __( 'Show header banner', 'dina-kala' ),
                'default'  => false
            ),
            array(
                'id'       => 'show_head_mobile',
                'type'     => 'switch',
                'title'    => __( 'Show header banner in mobile mode', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'show_head_banner', '=', true ),
            ),
            array(
                'id'       => 'head_banner',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'Header banner image', 'dina-kala' ),
                'compiler' => 'true',
                'subtitle' =>  __( 'Appropriate size: 1260(w) in 142(h)', 'dina-kala' ),
                'required' => array( 'show_head_banner', '=', true ),
            ),
            array(
                'id'       => 'head_banner_link',
                'type'     => 'text',
                'title'    => __( 'Header banner link', 'dina-kala' ),
                'default'  => '#',
                'required' => array( 'show_head_banner', '=', true ),
            ),
            array(
                'id'       => 'head_banner_title',
                'type'     => 'text',
                'title'    => __( 'Header banner title', 'dina-kala' ),
                'default'  => '#',
                'required' => array( 'show_head_banner', '=', true ),
            ),
            array(
                'id' => 'head-banner-section-end',
                'type' => 'section',
                'indent' => false ,
            ),

        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Footer settings', 'dina-kala' ),
        'icon'       => 'el el-credit-card',
        'id'         => 'footer-setting',
        'subsection' => true,
        'desc'       => __( 'Customize site footer', 'dina-kala' ),
        'fields'     => array(
            array(
                'id'       => 'footer_widgets',
                'type'     => 'image_select',
                'title'    =>  __( 'Footer widgets columns', 'dina-kala' ),
                'options'  => array(
                    '4' => array(
                        'alt' => __( 'Four columns', 'dina-kala' ),
                        'img' => RE_URI . 'assets/img/4col.png'
                    ),
                    '3' => array(
                        'alt' => __( 'Three columns', 'dina-kala' ),
                        'img' => RE_URI . 'assets/img/3col.png'
                    ),
                ),
                'default'  => '4'
            ),
            array(
                'id'       => 'hide_footer',
                'type'     => 'switch',
                'title' => __( 'Hide footer in mobile mode', 'dina-kala' ),
                'subtitle' => __( 'Hide footer section include footer widgets, info bar, address and application icons in mobile mode', 'dina-kala' ),
                'default'  => false,
            ),
            array(
                'id'       => 'show_footer_social',
                'type'     => 'switch',
                'title' => __( 'Show social networks', 'dina-kala' ),
                'subtitle' => __( 'Show social network links in footer', 'dina-kala' ),
                'default'  => true,
            ),

            array(
                'id' => 'info-section-start',
                'type' => 'section',
                'title' => __( 'Site information settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_info_bar',
                'type'     => 'switch',
                'title' => __( 'Site information section', 'dina-kala' ),
                'subtitle' => __( 'Display information section in the footer section to show the number of users, purchases and ...', 'dina-kala' ),
                'default'  => false,
            ),
            array(
                'id'       => 'info_bar_prods',
                'type'     => 'switch',
                'title' => __( 'Show products count', 'dina-kala' ),
                'default'  => true,
                'required' => array( 'show_info_bar', '=', true ),
            ),
            array(
                'id'       => 'edit_bar_prods',
                'type'     => 'switch',
                'title' => __( 'Edit products count', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'info_bar_prods', '=', true ),
            ),
            array(
                'id'       => 'bar_prods_title',
                'type'     => 'text',
                'title' => __( 'Products count title', 'dina-kala' ),
                'default'  => __('Products', 'dina-kala'),
                'required' => array( 'edit_bar_prods', '=', true ),
            ),
            array(
                'id'       => 'bar_prods_value',
                'type'     => 'text',
                'title' => __( 'Products count value', 'dina-kala' ),
                'default'  => '+1',
                'required' => array( 'edit_bar_prods', '=', true ),
            ),
            array(
                'id'       => 'bar_prods_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __('Products count icon', 'dina-kala'),
                'class'    => ' font-icons fal',
                'default'  => 'fal fa-shopping-bag',
                'options'  => $alliconArray,
                'required' => array( 'edit_bar_prods', '=', true ),
            ),
            array(
                'id'       => 'info_bar_sales',
                'type'     => 'switch',
                'title' => __( 'Show sales count', 'dina-kala' ),
                'default'  => true,
                'required' => array( 'show_info_bar', '=', true ),
            ),
            array(
                'id'       => 'edit_bar_sales',
                'type'     => 'switch',
                'title' => __( 'Edit sales count', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'info_bar_sales', '=', true ),
            ),
            array(
                'id'       => 'bar_sales_title',
                'type'     => 'text',
                'title' => __( 'Sales count title', 'dina-kala' ),
                'default'  => __('Order completed', 'dina-kala'),
                'required' => array( 'edit_bar_sales', '=', true ),
            ),
            array(
                'id'       => 'bar_sales_value',
                'type'     => 'text',
                'title' => __( 'Sales count value', 'dina-kala' ),
                'default'  => '+1',
                'required' => array( 'edit_bar_sales', '=', true ),
            ),
            array(
                'id'       => 'bar_sales_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __('Sales count icon', 'dina-kala'),
                'class'    => ' font-icons fal',
                'default'  => 'fal fa-box-check',
                'options'  => $alliconArray,
                'required' => array( 'edit_bar_sales', '=', true ),
            ),
            array(
                'id'       => 'info_bar_users',
                'type'     => 'switch',
                'title' => __( 'Show users count', 'dina-kala' ),
                'default'  => true,
                'required' => array( 'show_info_bar', '=', true ),
            ),
            array(
                'id'       => 'edit_bar_users',
                'type'     => 'switch',
                'title' => __( 'Edit users count', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'info_bar_users', '=', true ),
            ),
            array(
                'id'       => 'bar_users_title',
                'type'     => 'text',
                'title' => __( 'Users count title', 'dina-kala' ),
                'default'  => __('Members', 'dina-kala'),
                'required' => array( 'edit_bar_users', '=', true ),
            ),
            array(
                'id'       => 'bar_users_value',
                'type'     => 'text',
                'title' => __( 'Users count value', 'dina-kala' ),
                'default'  => '+1',
                'required' => array( 'edit_bar_users', '=', true ),
            ),
            array(
                'id'       => 'bar_users_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __('Users count icon', 'dina-kala'),
                'class'    => ' font-icons fal',
                'default'  => 'fal fa-users',
                'options'  => $alliconArray,
                'required' => array( 'edit_bar_users', '=', true ),
            ),
            array(
                'id'       => 'info_bar_posts',
                'type'     => 'switch',
                'title' => __( 'Show posts count', 'dina-kala' ),
                'default'  => true,
                'required' => array( 'show_info_bar', '=', true ),
            ),
            array(
                'id'       => 'edit_bar_posts',
                'type'     => 'switch',
                'title' => __( 'Edit posts count', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'info_bar_posts', '=', true ),
            ),
            array(
                'id'       => 'bar_posts_title',
                'type'     => 'text',
                'title' => __( 'Posts count title', 'dina-kala' ),
                'default'  => __('Blog content', 'dina-kala'),
                'required' => array( 'edit_bar_posts', '=', true ),
            ),
            array(
                'id'       => 'bar_posts_value',
                'type'     => 'text',
                'title' => __( 'Posts count value', 'dina-kala' ),
                'default'  => '+1',
                'required' => array( 'edit_bar_posts', '=', true ),
            ),
            array(
                'id'       => 'bar_posts_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __('Posts count icon', 'dina-kala'),
                'class'    => ' font-icons fal',
                'default'  => 'fal fa-file-alt',
                'options'  => $alliconArray,
                'required' => array( 'edit_bar_posts', '=', true ),
            ),
            array(
                'id' => 'info-section-end',
                'type' => 'section',
                'indent' => false,
            ),

            array(
                'id' => 'addr-section-start',
                'type' => 'section',
                'title' => __( 'Address section settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_addr',
                'type'     => 'switch',
                'title' => __( 'Address section', 'dina-kala' ),
                'subtitle' => __( 'Display the Address section in the footer', 'dina-kala' ),
                'default'  => false,
            ),
            array(
                'id'       => 'show_faddr',
                'type'     => 'switch',
                'title' => __( 'View Address', 'dina-kala' ),
                'subtitle' => __( 'View Address in the footer', 'dina-kala' ),
                'default'  => true,
                'required' => array( 'show_addr', '=', true ),
            ),
            array(
                'id'       => 'addr_text',
                'type'     => 'text',
                'title' => __( 'Address', 'dina-kala' ),
                'default'  => __( 'Tehran Province, Tehran, Central Street, Central Building, No. 7', 'dina-kala' ),
                'required' => array( 'show_faddr', '=', true ),
            ),
            array(
                'id'       => 'show_ftel',
                'type'     => 'switch',
                'title' => __( 'View phone', 'dina-kala' ),
                'subtitle' => __( 'View phone in the footer', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'show_addr', '=', true ),
            ),
            array(
                'id'       => 'show_fmail',
                'type'     => 'switch',
                'title' => __( 'View email', 'dina-kala' ),
                'subtitle' => __( 'View email in the footer', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'show_addr', '=', true ),
            ),
            array(
                'id'       => 'show_apps',
                'type'     => 'switch',
                'title' => __( 'Application Buttons', 'dina-kala' ),
                'subtitle' => __( 'Display application buttons in the footer', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'show_addr', '=', true ),
            ),
            array(
                'id'       => 'and_link',
                'type'     => 'text',
                'title' => __( 'Android Link', 'dina-kala' ),
                'default'  => '#',
                'required' => array( 'show_apps', '=', true ),
            ),
            array(
                'id'       => 'ios_link',
                'type'     => 'text',
                'title' => __( 'IOS Link', 'dina-kala' ),
                'default'  => '#',
                'required' => array( 'show_apps', '=', true ),
            ),
            array(
                'id' => 'addr-section-end',
                'type' => 'section',
                'indent' => false,
            ),

            array(
                'id' => 'alert-app-section-start',
                'type' => 'section',
                'title' => __( 'Application download bar settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_alert_app',
                'type'     => 'switch',
                'title' => __( 'Application download bar', 'dina-kala' ),
                'subtitle' => __( 'Show application download bar on mobile', 'dina-kala' ),
                'default'  => false,
            ),
            array(
                'id'       => 'alert_app_title',
                'type'     => 'text',
                'title' => __( 'Download bar title', 'dina-kala' ),
                'default'  => __('Optimal display in mobile application' , 'dina-kala'),
                'required' => array( 'show_alert_app', '=', true ),
            ),
            array(
                'id' => 'alert-app-section-end',
                'type' => 'section',
                'indent' => false,
            ),

            array(
                'id' => 'ftext-section-start',
                'type' => 'section',
                'title' => __( 'Footer text settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_footer_text',
                'type'     => 'switch',
                'title'    => __('Display text section of footer', 'dina-kala'),
                'subtitle' => __('Show a section to display text in the footer area', 'dina-kala'),
                'default'  => false
            ),
            array(
                'id'       => 'footer_text_main',
                'type'     => 'switch',
                'title'    => __('Show footer text only in main page', 'dina-kala'),
                'default'  => false,
                'required' => array( 'show_footer_text', '=', true ),
            ),
            array(
                'id'       => 'less_footer_text',
                'type'     => 'switch',
                'title'    => __('Show summary text', 'dina-kala'),
                'subtitle' => __('Show summary text instead of full', 'dina-kala'),
                'default'  => false,
                'required' => array( 'show_footer_text', '=', true ),
            ),
            array(
                'id'       => 'ftext_title',
                'default'  => __( 'Footer text', 'dina-kala' ),
                'type'     => 'text',
                'title'    => __( 'Footer text section title', 'dina-kala' ),
                'required' => array( 'show_footer_text', '=', true ),
            ),
            array(
                'id'      => 'ftext_text',
                'type'    => 'editor',
                'title'   => __( 'Footer section text', 'dina-kala' ),
                'default' => __('<p>This text is editable through the theme settings section. You can display text in the footer section of the site.</p>', 'dina-kala'),
                'args'    => array(
                    'wpautop'       => false,
                    'media_buttons' => false,
                    'textarea_rows' => 5,
                    'teeny'         => false,
                    'quicktags'     => true,
                ),
                'required' => array( 'show_footer_text', '=', true ),            
            ),
            array(
                'id' => 'ftext-section-end',
                'type' => 'section',
                'indent' => false,
            ),

            array(
                'id' => 'copy-section-start',
                'type' => 'section',
                'title' => __( 'Copyright settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'hide_copy',
                'type'     => 'switch',
                'title' => __( 'Hide copyright in mobile mode', 'dina-kala' ),
                'subtitle' => __( 'Hide copyright section include copyright text and social icons in mobile mode', 'dina-kala' ),
                'default'  => false,
            ),
            array(
                'id'=>'copy_text',
                'type'    => 'editor',
                'title' => __( 'Copyright text', 'dina-kala' ),
                'subtitle' => __( 'Change the text in the site footer.', 'dina-kala' ),
                'default' => __( 'All rights reserved to our site.', 'dina-kala' ),
                'args'    => array(
                    'wpautop'       => false,
                    'media_buttons' => false,
                    'textarea_rows' => 5,
                    'teeny'         => false,
                    'quicktags'     => true,
                ),
            ),
            array(
                'id'       => 'copy_bg_color',
                'type'     => 'color',
                'title'    => __( 'Copyright Background color', 'dina-kala' ),
                'subtitle' => __( 'Choose the color scheme for the copyright background color', 'dina-kala' ),
                'default'  => '#fff',
                'validate' => 'color',
                'transparent' => false,
            ),
            array(
                'id'       => 'copy_text_color',
                'type'     => 'color',
                'title'    => __( 'Copyright text color', 'dina-kala' ),
                'subtitle' => __( 'Choose the color scheme for the copyright text color', 'dina-kala' ),
                'default'  => '#212529',
                'validate' => 'color',
                'transparent' => false,
            ),
            array(
                'id' => 'copy-section-end',
                'type' => 'section',
                'indent' => false,
            ),
            
            array(
                'id' => 'fstyle-section-start',
                'type' => 'section',
                'title' => __( 'Footer style settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'footer_text_color',
                'type'     => 'color',
                'title'    => __( 'Footer site text color', 'dina-kala' ),
                'default'  => '#212529',
                'validate' => 'color',
                'transparent' => false,
            ),
            array(
                'id'       => 'footer_bg',
                'type'     => 'image_select',
                'output'    => array('.sfooter'),
                'tiles'    => true,
                'title'    => __('Footer site background', 'dina-kala'),
                'subtitle' => __("Select an image as the background of the site's footer.",'dina-kala'),
                'options'  => $footer_patterns,
                'required' => array( 'fbg_switch', '!=', true ),
            ),
            array(
                'id'       => 'fbg_switch',
                'type'     => 'switch',
                'title'    => __('Custom Footer Background', 'dina-kala'),
                'subtitle' => __('Choose a background color or upload a custom photo to the site footer', 'dina-kala'),
                'default'  => false
            ),
            array(         
                'id'       => 'site_fbg_custom',
                'output'    => array('.sfooter'),
                'type'     => 'background',
                'title'    => __("Customize the background of the site's footer to your liking.",'dina-kala'),
                'default'  => array(
                    'background-color' => '#2d2d2d',
                ),
                'required' => array( 'fbg_switch', '=', true ),
            ),
            array(
                'id' => 'fstyle-section-end',
                'type' => 'section',
                'indent' => false,
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Mobile Navigation Bar', 'dina-kala' ),
        'icon'       => 'el el-website',
        'id'         => 'mobile-nav-setting',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'hide_mobile_bar',
                'type'     => 'switch',
                'title'    => __( 'Hide mobile navigation bar' , 'dina-kala'),
                'subtitle' => __( 'Hide the bottom bar displayed at the bottom of the site in mobile mode' , 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'mobile_bar_title',
                'type'     => 'switch',
                'title' => __( 'Hide mobile navigation bar titles' , 'dina-kala'),
                'subtitle' => __( 'Hide the mobile navigation bar icon title' , 'dina-kala'),
                'default'  => true,
                'required' => array( 'hide_mobile_bar', '!=', true ),
            ),
            array(
                'id'       => 'mobile_bar_btns',
                'type'     => 'select',
                'multi'    => true,
                'title'    => __( 'Mobile navigation bar buttons', 'dina-kala' ), 
                'subtitle' => __( 'In this section, you can select up to 5 buttons to display in the mobile navigation bar. No more than 5 items will be displayed in the output.', 'dina-kala' ),
                'desc'     => __( 'No more than 5 items will be displayed in the output.', 'dina-kala' ),
                'options'  => array(
                    'back-top' => __( 'Back top / Filters', 'dina-kala' ),
                    'wishlist' => __( 'Wishlist', 'dina-kala' ),
                    'home-add-cart' => __( 'Home / Buy product', 'dina-kala' ),
                    'compare-btn' => __( 'Compare', 'dina-kala' ),
                    'cart-btn' => __( 'Shopping cart', 'dina-kala' ),
                    'my-account' => __( 'My Account', 'dina-kala' ),
                    'menu' => __( 'Menu', 'dina-kala' ),
                    'custom-btn-one' => __( 'Custom button one', 'dina-kala' ),
                    'custom-btn-two' => __( 'Custom button two', 'dina-kala' ),
                ),
                'required' => array( 'hide_mobile_bar', '!=', true ),
                'default'  => array( 'cart-btn', 'compare-btn', 'home-add-cart', 'wishlist', 'back-top' )
            ),

            array(
                'id' => 'mobile-nav-btn-one-section-start',
                'type' => 'section',
                'title' => __( 'Settings of the first custom mobile navigation bar button', 'dina-kala' ),
                'indent' => true,
                'required' => array( 'hide_mobile_bar', '!=', true ),
            ),
            array(
                'id'       => 'mobile_nav_btn_one',
                'type'     => 'switch',
                'title' => __( 'Enable Button' , 'dina-kala'),
                'subtitle' => __( 'Enable first custom mobile navigation bar button' , 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'mobile_nav_btn_one_title',
                'type'     => 'text',
                'title' => __( 'Button title', 'dina-kala' ),
                'default'  => __('Button one', 'dina-kala'),
                'required' => array( 'mobile_nav_btn_one', '=', true ),
            ),
            array(
                'id'       => 'mobile_nav_btn_one_link',
                'type'     => 'text',
                'title' => __( 'Button link', 'dina-kala' ),
                'default'  => '#',
                'required' => array( 'mobile_nav_btn_one', '=', true ),
            ),
            array(
                'id'       => 'mobile_nav_btn_one_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __('Button icon', 'dina-kala'),
                'class'    => ' font-icons fal',
                'default'  => 'fal fa-chevron-up',
                'options'  => $alliconArray,
                'required' => array( 'mobile_nav_btn_one', '=', true ),
            ),
            array(
                'id' => 'mobile-nav-btn-one-section-end',
                'type' => 'section',
                'indent' => false,
            ),

            array(
                'id' => 'mobile-nav-btn-two-section-start',
                'type' => 'section',
                'title' => __( 'Settings of the second custom mobile navigation bar button', 'dina-kala' ),
                'indent' => true,
                'required' => array( 'hide_mobile_bar', '!=', true ),
            ),
            array(
                'id'       => 'mobile_nav_btn_two',
                'type'     => 'switch',
                'title' => __( 'Enable Button' , 'dina-kala'),
                'subtitle' => __( 'Enable first custom mobile navigation bar button' , 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'mobile_nav_btn_two_title',
                'type'     => 'text',
                'title' => __( 'Button two', 'dina-kala' ),
                'default'  => __('Return', 'dina-kala'),
                'required' => array( 'mobile_nav_btn_two', '=', true ),
            ),
            array(
                'id'       => 'mobile_nav_btn_two_link',
                'type'     => 'text',
                'title' => __( 'Button link', 'dina-kala' ),
                'default'  => '#',
                'required' => array( 'mobile_nav_btn_two', '=', true ),
            ),
            array(
                'id'       => 'mobile_nav_btn_two_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __('Button icon', 'dina-kala'),
                'class'    => ' font-icons fal',
                'default'  => 'fal fa-chevron-up',
                'options'  => $alliconArray,
                'required' => array( 'mobile_nav_btn_two', '=', true ),
            ),
            array(
                'id' => 'mobile-nav-btn-two-section-end',
                'type' => 'section',
                'indent' => false,
            ),

            array(
                'id' => 'back-top-section-start',
                'type' => 'section',
                'title' => __( 'Mobile Back to top Button settings', 'dina-kala' ),
                'indent' => true,
                'required' => array( 'hide_mobile_bar', '!=', true ),
            ),
            array(
                'id'       => 'ch_back_top_btn',
                'type'     => 'switch',
                'title' => __( 'Change Back to top Button' , 'dina-kala'),
                'subtitle' => __( 'Change Back to top Button displayed at the bottom of the site in mobile mode' , 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'back_top_btn_title',
                'type'     => 'text',
                'title' => __( 'Button title', 'dina-kala' ),
                'default'  => __('Return', 'dina-kala'),
                'required' => array( 'ch_back_top_btn', '=', true ),
            ),
            array(
                'id'       => 'back_top_btn_link',
                'type'     => 'text',
                'title' => __( 'Button link', 'dina-kala' ),
                'default'  => '#',
                'required' => array( 'ch_back_top_btn', '=', true ),
            ),
            array(
                'id'       => 'back_top_btn_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __('Button icon', 'dina-kala'),
                'class'    => ' font-icons fal',
                'default'  => 'fal fa-chevron-up',
                'options'  => $alliconArray,
                'required' => array( 'ch_back_top_btn', '=', true ),
            ),
            array(
                'id' => 'back-top-section-end',
                'type' => 'section',
                'indent' => false,
            ),
            
            array(
                'id' => 'whish-section-start',
                'type' => 'section',
                'title' => __( 'Wishlist Button settings', 'dina-kala' ),
                'indent' => true,
                'required' => array( 'hide_mobile_bar', '!=', true ),
            ),
            array(
                'id'       => 'ch_whish_btn',
                'type'     => 'switch',
                'title' => __( 'Change Wishlist Button' , 'dina-kala'),
                'subtitle' => __( 'Change Wishlist Button displayed at the bottom of the site in mobile mode' , 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'whish_btn_title',
                'type'     => 'text',
                'title' => __( 'Button title', 'dina-kala' ),
                'default'  => __('Wishlist ', 'dina-kala'),
                'required' => array( 'ch_whish_btn', '=', true ),
            ),
            array(
                'id'       => 'whish_btn_link',
                'type'     => 'text',
                'title' => __( 'Button link', 'dina-kala' ),
                'default'  => '#',
                'required' => array( 'ch_whish_btn', '=', true ),
            ),
            array(
                'id'       => 'whish_btn_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __('Button icon', 'dina-kala'),
                'class'    => ' font-icons fal',
                'default'  => 'fal fa-heart',
                'options'  => $alliconArray,
                'required' => array( 'ch_whish_btn', '=', true ),
            ),
            array(
                'id' => 'whish-section-end',
                'type' => 'section',
                'indent' => false,
            ),
            
            array(
                'id' => 'compare-section-start',
                'type' => 'section',
                'title' => __( 'Compare Button settings', 'dina-kala' ),
                'indent' => true,
                'required' => array( 'hide_mobile_bar', '!=', true ),
            ),
            array(
                'id'       => 'ch_compare_btn',
                'type'     => 'switch',
                'title' => __( 'Change Compare Button' , 'dina-kala'),
                'subtitle' => __( 'Change Compare Button displayed at the bottom of the site in mobile mode' , 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'compare_btn_title',
                'type'     => 'text',
                'title' => __( 'Button title', 'dina-kala' ),
                'default'  => __('Compare ', 'dina-kala'),
                'required' => array( 'ch_compare_btn', '=', true ),
            ),
            array(
                'id'       => 'compare_btn_link',
                'type'     => 'text',
                'title' => __( 'Button link', 'dina-kala' ),
                'default'  => '#',
                'required' => array( 'ch_compare_btn', '=', true ),
            ),
            array(
                'id'       => 'compare_btn_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __('Button icon', 'dina-kala'),
                'class'    => ' font-icons fal',
                'default'  => 'fal fa-random',
                'options'  => $alliconArray,
                'required' => array( 'ch_compare_btn', '=', true ),
            ),
            array(
                'id' => 'compare-section-end',
                'type' => 'section',
                'indent' => false,
            ),

        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Other settings', 'dina-kala' ),
        'icon'       => 'el el-cog',
        'id'         => 'side-setting',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'side_sticky',
                'type'     => 'switch',
                'title'    => __( 'Sticky Sidebar' , 'dina-kala'),
                'subtitle' => __( 'In this case the widgets and the content section remain fixed while scrolling the page so that no space is left.' , 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'site_schema',
                'type'     => 'switch',
                'title' => __( 'Schema Codes' , 'dina-kala'),
                'subtitle' => __( 'Add Schema codes to product sections and content' , 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'dis_rss_feeds',
                'type'     => 'switch',
                'title' => __( 'Disable RSS feeds' , 'dina-kala'),
                'subtitle' => __( 'Disable WordPress RSS feeds' , 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'tag_number',
                'type'     => 'text',
                'title' => __( 'Number of Widget tags', 'dina-kala' ),
                'subtitle' => __( 'The number of tags displayed in the cloud tag widget.', 'dina-kala' ),
                'default'  => 32,
            ),

            array(
                'id' => '404-page-section-start',
                'type' => 'section',
                'title' => __( '404 page settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'custom_404_page',
                'type'     => 'select',
                'multi'    => false,
                'data'      => 'pages',
                'title'    => __('Custom 404 page', 'dina-kala'),
                'subtitle' => __('Select a page that will be shown as your default 404 error page.', 'dina-kala'),
            ),
            array(
                'id' => '404-page-section-end',
                'type' => 'section',
                'indent' => false,
            ),

            array(
                'id' => 'rtop-section-start',
                'type' => 'section',
                'title' => __( 'Sticky Back to top button settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_return_top',
                'type'     => 'switch',
                'title' => __( 'Back to top button', 'dina-kala' ),
                'subtitle' => __( 'Show back to top button', 'dina-kala' ),
                'default'  => true,
            ),
            array(
                'id'       => 'return_top_left',
                'type'     => 'switch',
                'title' => __( 'Show button on the left', 'dina-kala' ),
                'required' => array(
                    array( 'show_return_top', '=', true ), 
                    array( 'return_top_style_two', '!=', true ) 
                ),
                'default'  => false,
            ),
            array(
                'id'       => 'return_top_bottom',
                'type'     => 'text',
                'title' =>  __( 'Distance from the bottom', 'dina-kala' ),
                'default'  => '40',
                'required' => array(
                    array( 'show_return_top', '=', true ), 
                    array( 'return_top_style_two', '!=', true ) 
                )
            ),
            array(
                'id'       => 'return_top_right',
                'type'     => 'text',
                'title' => __( 'Distance from the side', 'dina-kala' ),
                'default'  => '20',
                'required' => array(
                    array( 'show_return_top', '=', true ), 
                    array( 'return_top_style_two', '!=', true ) 
                )
            ),
            array(
                'id'       => 'return_top_style_two',
                'type'     => 'switch',
                'title' => __( 'Activate the second style of the button', 'dina-kala' ),
                'subtitle' => __( 'Show back to top button in footer', 'dina-kala' ),
                'default'  => false,
            ),
            array(
                'id' => 'rtop-section-end',
                'type' => 'section',
                'indent' => false,
            ),

            array(
                'id' => 'social-section-start',
                'type' => 'section',
                'title' => __( 'Social network button settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_social_btn',
                'type'     => 'switch',
                'title' => __( 'Show social network button', 'dina-kala' ),
                'default'  => false,
            ),
            array(
                'id'       => 'social_btn_left',
                'type'     => 'switch',
                'title' => __( 'Show button on the right', 'dina-kala' ),
                'required' => array( 'show_social_btn', '=', true ),
                'default'  => false,
            ),
            array(
                'id'       => 'social_btn_mobile',
                'type'     => 'switch',
                'title' => __( 'Show button on mobile devices', 'dina-kala' ),
                'required' => array( 'show_social_btn', '=', true ),
                'default'  => false,
            ),
            array(
                'id'       => 'social_btn_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __('Social network button icon', 'dina-kala'),
                'class'    => ' font-icons fab',
                'default'  => 'fab fa-paper-plane',
                'options'  => $alliconArray,
                'required' => array( 'show_social_btn', '=', true ),
            ),
            array(
                'id'       => 'social_btn_color',
                'type'     => 'color',
                'title'    => __( 'Social network button color', 'dina-kala' ),
                'default'  => '#31AAFF',
                'validate' => 'color',
                'transparent' => false,
                'required' => array( 'show_social_btn', '=', true ),
            ),
            array(
                'id'       => 'social_btn_title',
                'type'     => 'text',
                'title' =>  __( 'Social network button title', 'dina-kala' ),
                'default'  => __( 'Telegram', 'dina-kala' ),
                'required' => array( 'show_social_btn', '=', true ),
            ),
            array(
                'id'       => 'social_btn_fix_title',
                'type'     => 'switch',
                'title' => __( 'Display the title permanently', 'dina-kala' ),
                'required' => array( 'show_social_btn', '=', true ),
                'default'  => false,
            ),
            array(
                'id'       => 'social_btn_link',
                'type'     => 'text',
                'title' =>  __( 'Social network button link', 'dina-kala' ),
                'default'  => '#',
                'required' => array( 'show_social_btn', '=', true ),
            ),
            array(
                'id'       => 'social_btn_bottom',
                'type'     => 'text',
                'title' =>  __( 'Distance from the bottom', 'dina-kala' ),
                'default'  => '40',
                'required' => array( 'show_social_btn', '=', true ),
            ),
            array(
                'id'       => 'social_btn_right',
                'type'     => 'text',
                'title' => __( 'Distance from the side', 'dina-kala' ),
                'default'  => '20',
                'required' => array( 'show_social_btn', '=', true ),
            ),
            array(
                'id' => 'social-section-end',
                'type' => 'section',
                'indent' => false,
            ),

            array(
                'id' => 'second-social-section-start',
                'type' => 'section',
                'title' => __( 'Second social network button settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_second_social_btn',
                'type'     => 'switch',
                'title' => __( 'Show second social network button', 'dina-kala' ),
                'default'  => false,
            ),
            array(
                'id'       => 'second_social_btn_color',
                'type'     => 'color',
                'title'    => __( 'Second social network button color', 'dina-kala' ),
                'default'  => '#AC34A7',
                'validate' => 'color',
                'transparent' => false,
                'required' => array( 'show_second_social_btn', '=', true ),
            ),
            array(
                'id'       => 'second_social_btn_title',
                'type'     => 'text',
                'title' =>  __( 'Second social network button title', 'dina-kala' ),
                'default'  => __( 'Instagram', 'dina-kala' ),
                'required' => array( 'show_second_social_btn', '=', true ),
            ),
            array(
                'id'       => 'second_social_btn_link',
                'type'     => 'text',
                'title' =>  __( 'Second social network button link', 'dina-kala' ),
                'default'  => '#',
                'required' => array( 'show_second_social_btn', '=', true ),
            ),
            array(
                'id'       => 'second_social_btn_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __('Second social network button icon', 'dina-kala'),
                'class'    => ' font-icons fab',
                'default'  => 'fab fa-instagram',
                'options'  => $alliconArray,
                'required' => array( 'show_second_social_btn', '=', true ),
            ),
            array(
                'id' => 'second-social-section-end',
                'type' => 'section',
                'indent' => false,
            ),

            array(
                'id' => 'abar-section-start',
                'type' => 'section',
                'title' => __( 'Admin bar settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_abar',
                'type'     => 'switch',
                'title' => __( 'Hide the Admin Bar', 'dina-kala' ),
                'subtitle' => __( 'Hide admin bar when viewing site', 'dina-kala' ),
                'default'  => true,
            ),
            array(
                'id'       => 'show_abar_admin',
                'type'     => 'switch',
                'title' => __( 'Show only for admin', 'dina-kala' ),
                'subtitle' => __( 'Show admin bar only for site admin', 'dina-kala' ),
                'default'  => true,
                'required' => array( 'show_abar', '=', true ),
            ),
            array(
                'id' => 'abar-section-end',
                'type' => 'section',
                'indent' => false,
            ),

            array(
                'id' => 'loading-section-start',
                'type' => 'section',
                'title' => __( 'Loading settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_page_loading',
                'type'     => 'switch',
                'title' => __( 'Display loading', 'dina-kala' ),
                'subtitle' => __( 'Show loading mode when loading pages', 'dina-kala' ),
                'default'  => true,
            ),
            array( 
                'id'       => 'load_img',
                'type'     => 'select_image',
                'title'    => __( 'Loading image', 'dina-kala' ),
                'subtitle' => __( 'Select image loading', 'dina-kala' ),
                'options'  => Array(
                    Array (
                         'alt'  => __( 'Image 1', 'dina-kala' ),
                         'img'  => RE_URI .'assets/img/loading/loader0.gif',
                    ),
                    Array (
                         'alt'  => __( 'Image 2', 'dina-kala' ),
                         'img'  => RE_URI .'assets/img/loading/loader1.gif',
                    ),
                    Array (
                         'alt'  => __( 'Image 3', 'dina-kala' ),
                         'img'  => RE_URI .'assets/img/loading/loader2.gif',
                    ),
                    Array (
                         'alt'  => __( 'Image 4', 'dina-kala' ),
                         'img'  => RE_URI .'assets/img/loading/loader3.gif',
                    ),
                    Array (
                         'alt'  => __( 'Image 5', 'dina-kala' ),
                         'img'  => RE_URI .'assets/img/loading/loader4.gif',
                    ),
                    Array (
                         'alt'  => __( 'Image 6', 'dina-kala' ),
                         'img'  => RE_URI .'assets/img/loading/loader5.gif',
                    ),
                    Array (
                         'alt'  => __( 'Image 7', 'dina-kala' ),
                         'img'  => RE_URI .'assets/img/loading/loader6.gif',
                    ),
                    Array (
                         'alt'  => __( 'Image 8', 'dina-kala' ),
                         'img'  => RE_URI .'assets/img/loading/loader7.gif',
                    ),
                    Array (
                         'alt'  => __( 'Image 9', 'dina-kala' ),
                         'img'  => RE_URI .'assets/img/loading/loader8.gif',
                    ),
                    Array (
                         'alt'  => __( 'Image 10', 'dina-kala' ),
                         'img'  => RE_URI .'assets/img/loading/loader9.gif',
                    ),
                    Array (
                         'alt'  => __( 'Image 11', 'dina-kala' ),
                         'img'  => RE_URI .'assets/img/loading/loader10.gif',
                    )
                    
                ),
                'default'  => RE_URI .'assets/img/loading/loader0.gif',
                'required' => array( 
                    array( 'show_page_loading', '=', true ),
                    array( 'show_custom_loading', '!=', true ),
                )
            ),
            array(
                'id'       => 'show_custom_loading',
                'type'     => 'switch',
                'title' => __( 'Display Custom loading image', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'show_page_loading', '=', true ),
            ),
            array(
                'id'       => 'custom_loading_image',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'Your custom loading image', 'dina-kala' ),
                'compiler' => 'true',
                'desc'     => __( 'Upload your custom loading image from this section.', 'dina-kala' ),
                'default'  => array( 'url' => RE_URI .'assets/img/loading/loader0.gif' ),
                'required' => array( 'show_custom_loading', '=', true ),
            ),
            array(
                'id' => 'loading-section-end',
                'type' => 'section',
                'indent' => false,
            ),

            array(
                'id'       => 'open_cat_widget',
                'type'     => 'switch',
                'title' => __('Open subcategories in the category widget', 'dina-kala'),
                'subtitle' => __('Open subcategories in the category widget by default', 'dina-kala'),
                'default'  => false,
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Product Settings', 'dina-kala' ),
        'id'         => 'product_setting',
        'icon'       => 'el el-shopping-cart',
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Product archive', 'dina-kala' ),
        'id'         => 'product_archive_setting',
        'icon'       => 'el el-th',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'product_archive_side',
                'type'     => 'image_select',
                'title'    => __('Products Archive Sidebar', 'dina-kala'),
                'subtitle' => __('Specify the location of the products sidebar in archive pages (Category page, Tag page, ...)', 'dina-kala'),
                'options'  => array(
                    '0' => array(
                        'alt' => __('No sidebar', 'dina-kala'),
                        'img' => RE_URI . 'assets/img/1c.png'
                    ),
                    '1' => array(
                        'alt' => __('Left alignment', 'dina-kala'),
                        'img' => RE_URI . 'assets/img/2cl.png'
                    ),
                    '2' => array(
                        'alt' => __('Right alignment', 'dina-kala'),
                        'img' => RE_URI . 'assets/img/2cr.png'
                    )
                ),
                'default'  => '1'
            ),
            array(
                'id'       => 'shop_page_side',
                'type'     => 'switch',
                'title'    => __('Separate shop page sidebar', 'dina-kala'),
                'subtitle' => __('Separate shop page sidebar from archive pages', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'product_num',
                'type'     => 'select',
                'title' => __('Number of products', 'dina-kala'),
                'subtitle' => __('Number of products in archive pages', 'dina-kala'),
                'options'  => $col_number,
                'default'  => 12,
            ),
            array(
                'id'       => 'product_col',
                'type'     => 'select',
                'title' => __('Number of products columns', 'dina-kala'),
                'subtitle' => __('Number of products columns in archive pages', 'dina-kala'),
                'options'  => array(
                    2 =>  2,
                    3 =>  3,
                    4 =>  4,
                    5 =>  5,
                ),
                'default'  => 4,
            ),

            array(
                'id'       => 'mobile_single_col',
                'type'     => 'switch',
                'title'    => __('Display single column products in mobile mode', 'dina-kala'),
                'subtitle'    => __('Display single column products on archive pages and product blocks in mobile mode', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'enable_woo_hook',
                'type'     => 'switch',
                'title'    => __('Activate WooCommerce Hooks on product archive pages', 'dina-kala'),
                'subtitle'    => __('WooCommerce Hooks is used by some plugins to insert content into products on archive pages, so enabling this option may cause confusion in products on archive pages.', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'open_prod_new_tab',
                'type'     => 'switch',
                'title'    => __('Open product and post link in a new window/tab', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'show_count_archive',
                'type'     => 'switch',
                'title'    => __('Ability to select the number of products on archive pages', 'dina-kala'),
                'subtitle'    => __('By activating this option, users can select the number of products added to the shopping cart on the main page and archive pages (category, etc.).', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'show_star_rating',
                'type'     => 'switch',
                'title'    => __('Show product star rating', 'dina-kala'),
                'subtitle'    => __('Show product star rating in archive pages', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'stock_order',
                'type'     => 'switch',
                'title'    => __('Show out of stock products at the end of the product list', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'ajax_prod',
                'type'     => 'switch',
                'title'    => __('Ajax Products Loading', 'dina-kala'),
                'subtitle' => __('Loading products ajax and remove pagination', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'show_filter',
                'type'     => 'switch',
                'title'    => __('Show filter button', 'dina-kala'),
                'subtitle' => __('Show the filter button at the top of the products on the archive page', 'dina-kala'),
                'default'  => true,
            ),

            array(
                'id' => 'hover-btns-section-start',
                'type' => 'section',
                'title' => __( 'Product hover button settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'quick_btns_fix_mobile',
                'type'     => 'switch',
                'title'    => __('Display buttons fixed in mobile mode', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'show_quick_view',
                'type'     => 'switch',
                'title'    => __('Show product quick view button', 'dina-kala'),
                'subtitle' => __('Show product quick view button in archive pages', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'like_prod_archive',
                'type'     => 'switch',
                'title'    => __('Show product like button', 'dina-kala'),
                'subtitle' => __('Show product like button in archive pages', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'compare_prod_archive',
                'type'     => 'switch',
                'title'    => __('Show product compare button', 'dina-kala'),
                'subtitle' => __('Show product compare button in archive pages', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id' => 'hover-btns-section-end',
                'type' => 'section',
                'indent' => false,
            ),
            
            array(
                'id' => 'subcats-section-start',
                'type' => 'section',
                'title' => __( 'Subcategory settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_sub_cats',
                'type'     => 'switch',
                'title'    => __('Show subcategories on the product category page', 'dina-kala'),
                'default'  => false,
            ),

            array(
                'id'       => 'show_sub_cats_mobile',
                'type'     => 'switch',
                'title'    => __('Show subcategories in mobile mode', 'dina-kala'),
                'default'  => true,
                'required' => array( 'show_sub_cats', '=', true ),
            ),
            array(
                'id' => 'subcats-section-end',
                'type' => 'section',
                'indent' => false,
            ),

            array(
                'id' => 'cat-desc-section-start',
                'type' => 'section',
                'title' => __( 'Category description settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_on_top_cat',
                'type'     => 'switch',
                'title' => __('Show on top', 'dina-kala'),
                'subtitle' => __('Show on top of products', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'show_full_text_cat',
                'type'     => 'switch',
                'title' => __('Show full text', 'dina-kala'),
                'subtitle' => __('Show full text instead of summary', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id' => 'cat-desc-section-end',
                'type' => 'section',
                'indent' => false,
            ),

            array(
                'id' => 'arch-title-section-start',
                'type' => 'section',
                'title' => __( 'Product archive title settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_archive_title',
                'type'     => 'switch',
                'title'    => __('Show product archive title', 'dina-kala'),
                'subtitle'    => __('Add archive title to woocommerce archive pages', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'show_archive_title_mobile',
                'type'     => 'switch',
                'title'    => __('Show product archive title in mobile mode', 'dina-kala'),
                'default'  => true,
                'required' => array( 'show_archive_title', '=', true ),
            ),
            array(
                'id' => 'arch-title-section-end',
                'type' => 'section',
                'indent' => false,
            ),

            array(
                'id' => 'cat-slider-section-start',
                'type' => 'section',
                'title' => __( 'Category slider settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'cat_slider_show',
                'type'     => 'switch',
                'title'    => __('Show category slider in category page', 'dina-kala'),
                'subtitle' => __('If the product category has a slider, enabling this option will cause the slider to be displayed on the product category page. To insert the slider, edit the category you want from the product category section.', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'cat_slider_show_arrows',
                'type'     => 'switch',
                'title'    => __('Show arrows', 'dina-kala'),
                'default'  => true,
                'required' => array( 'cat_slider_show', '=', true ),
            ),
            array(
                'id'       => 'cat_slider_auto_play',
                'type'     => 'switch',
                'title'    => __('Auto play', 'dina-kala'),
                'default'  => true,
                'required' => array( 'cat_slider_show', '=', true ),
            ),
            array(
                'id' => 'cat_slider_time',
                'type' => 'slider',
                'title' => __('Auto play speed(ms)', 'dina-kala'),
                "default" => 8000,
                "min" => 1000,
                "step" => 1000,
                "max" => 20000,
                'display_value' => 'label',
                'required' => array( 'cat_slider_show', '=', true ),
            ),
            array(
                'id'       => 'cat_slider_pause_over',
                'type'     => 'switch',
                'title'    => __('Pause slider on mouse over', 'dina-kala'),
                'default'  => false,
                'required' => array( 'cat_slider_show', '=', true ),
            ),
            array(
                'id'       => 'cat_slider_show_dots',
                'type'     => 'switch',
                'title'    => __('Show navigation\'s dots', 'dina-kala'),
                'default'  => true,
                'required' => array( 'cat_slider_show', '=', true ),
            ),
            array(
                'id'       => 'cat_slider_show_title',
                'type'     => 'switch',
                'title'    => __('Show slide titles instead of navigation points', 'dina-kala'),
                'default'  => false,
                'required' => array( 'cat_slider_show', '=', true ),
            ),
            array(
                'id' => 'cat-slider-section-end',
                'type' => 'section',
                'indent' => false,
            ),
            

            array(
                'id' => 'product-thumb-section-start',
                'type' => 'section',
                'title' => __( 'Default product thumbnail settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'prod_defualt_thumb',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'Default product thumbnail', 'dina-kala' ),
                'subtitle' =>  __( 'If your product does not have an thumbnail image, this image will be displayed.', 'dina-kala' ),
                'compiler' => 'true',
                'default'  => array( 'url' => get_template_directory_uri()."/images/thumb.png" ),
            ),
            array(
                'id' => 'product-thumb-section-end',
                'type' => 'section',
                'indent' => false,
            ),
        ),
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Product page', 'dina-kala' ),
        'id'         => 'product_page_setting',
        'icon'       => 'el el-shopping-cart-sign',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'product_side',
                'type'     => 'image_select',
                'title'    => __('Products Sidebar', 'dina-kala'),
                'subtitle' => __('Specify the location of the products sidebar, this feature is also customizable for each product.', 'dina-kala'),
                'options'  => array(
                    '0' => array(
                        'alt' => __('No sidebar', 'dina-kala'),
                        'img' => RE_URI . 'assets/img/1c.png'
                    ),
                    '1' => array(
                        'alt' => __('Left alignment', 'dina-kala'),
                        'img' => RE_URI . 'assets/img/2cl.png'
                    ),
                    '2' => array(
                        'alt' => __('Right alignment', 'dina-kala'),
                        'img' => RE_URI . 'assets/img/2cr.png'
                    )
                ),
                'default'  => '0'
            ),
            array(
                'id'       => 'product_page_side',
                'type'     => 'switch',
                'title'    => __('Separate product page sidebar', 'dina-kala'),
                'subtitle' => __('Separate product page sidebar from archive pages', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'product_page_style',
                'type'     => 'select',
                'title' => __('Products page style', 'dina-kala'),
                'options'  => array(
                    'stone' => __('Style 1', 'dina-kala'),
                    'sttwo' =>  __('Style 2', 'dina-kala'),
                ),
                'default'  => 'stone',
            ),
            array(
                'id'       => 'prod_tab_style',
                'type'     => 'select',
                'title' => __('Product tab style (descriptions, comments, etc.)', 'dina-kala'),
                'options'  => array(
                    'stone' => __('Style 1', 'dina-kala'),
                    'sttwo' =>  __('Style 2', 'dina-kala'),
                ),
                'default'  => 'stone',
            ),
            array(
                'id'       => 'show_sticky_add',
                'type'     => 'switch',
                'title'    => __('Show product purchase sticky bar', 'dina-kala'),
                'subtitle' => __('Show product purchase sticky bar at the bottom of the product page', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'mobile_sticky_add',
                'type'     => 'switch',
                'title'    => __('Display sticky purchase button in mobile mode', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'show_more',
                'type'     => 'switch',
                'title'    => __('Product descriptions are summarized in mobile mode', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'out_stock_black',
                'type'     => 'switch',
                'title'    => __('Show out of stock products in black and white color', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'ajax_add',
                'type'     => 'switch',
                'title'    => __('Ajax add to cart', 'dina-kala'),
                'subtitle' => __('Product has been added Ajax to the cart (without loading page again)', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'ajax_add_open_cart',
                'type'     => 'switch',
                'title'    => __('Open the shopping cart from the side', 'dina-kala'),
                'subtitle' => __('Opening the shopping cart from the side after the product is added to the shopping cart', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'like_prod',
                'type'     => 'switch',
                'title' => __('Like Product Button', 'dina-kala'),
                'subtitle' => __('Show Like Product Button in product page', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'compare_prod',
                'type'     => 'switch',
                'title' => __('Compare Product Button', 'dina-kala'),
                'subtitle' => __('Show Compare Product Button in product page', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'share_prod',
                'type'     => 'switch',
                'title' => __('Share Product Button', 'dina-kala'),
                'subtitle' => __('Show Share Product Button in product page', 'dina-kala'),
                'default'  => true,
            ),
            /*array(
                'id'       => 'plot_prod',
                'type'     => 'switch',
                'title' => __('Price Changes Chart Button', 'dina-kala'),
                'subtitle' => __('Show Price Changes Chart Button in product page', 'dina-kala'),
                'default'  => true,
            ),*/
            array(
                'id'       => 'show_prod_sku',
                'type'     => 'switch',
                'title' => __('Show product SKU', 'dina-kala'),
                'subtitle' => __('Show product SKU in product page', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'show_prod_cats',
                'type'     => 'switch',
                'title' => __('Show product categories', 'dina-kala'),
                'subtitle' => __('Show product categories in product page', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'show_prod_tags',
                'type'     => 'switch',
                'title' => __('Show product tags', 'dina-kala'),
                'subtitle' => __('Show product tags in product page', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'show_prod_tags_down',
                'type'     => 'switch',
                'title' => __('Show tags at the bottom', 'dina-kala'),
                'subtitle' => __('By activating this option, the labels are displayed separately at the bottom of the side of the product image', 'dina-kala'),
                'required' => array( 'show_prod_tags', '=', true ),
                'default'  => false,
            ),
            array(
                'id'       => 'show_prod_meta_sum',
                'type'     => 'switch',
                'title' => __('Show product tags in summary form', 'dina-kala'),
                'required' => array(
                    array( 'show_prod_tags', '=', true ),
                    array( 'show_prod_tags_down', '!=', true ),
                ),
                'default'  => false,
            ),
            array(
                'id'       => 'show_prod_up_date',
                'type'     => 'switch',
                'title' => __('Show product update date', 'dina-kala'),
                'subtitle' => __('Show product update date in product page', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'show_pros_top',
                'type'     => 'switch',
                'title' => __('Show cons and pros in top', 'dina-kala'),
                'subtitle' => __('Show product cons and pros section in top of description', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'remove_dimensions',
                'type'     => 'switch',
                'title' => __('Hides the product’s weight and dimension', 'dina-kala'),
                'subtitle' => __('Hides the product’s weight and dimension in the single product page.', 'dina-kala'),
                'default'  => false,
            ),

            array(
                'id'       => 'remove_attr_link',
                'type'     => 'switch',
                'title' => __('Remove product’s atribute link', 'dina-kala'),
                'subtitle' => __('Remove product’s atribute link in the single product page.', 'dina-kala'),
                'default'  => false,
            ),

            array(
                'id'       => 'remove_clear_option',
                'type'     => 'switch',
                'title' => __('Remove clear options', 'dina-kala'),
                'subtitle' => __('Remove clear options of variation product.', 'dina-kala'),
                'default'  => false,
            ),

            array(
                'id'       => 'ch_reset_var_text',
                'type'     => 'switch',
                'title'    => __('Change text Clear options on variable product', 'dina-kala'),
                'subtitle' => __('The text displayed below the selected variables', 'dina-kala'),
                'default'  => false,
            ),

            array(
                'id'       => 'reset_var_text',
                'type'     => 'text',
                'title' => __('Clear options text', 'dina-kala'),
                'default'  => __('Clear options', 'dina-kala'),                
                'required' => array( 'ch_reset_var_text', '=', true ),
            ),

            array(
                'id'       => 'display_discount',
                'type'     => 'switch',
                'title' => __('Display discount percentage', 'dina-kala'),
                'subtitle' => __('Display discount percentage on discounted products', 'dina-kala'),
                'default'  => true,
            ),

            array(
                'id'       => 'display_spec',
                'type'     => 'switch',
                'title' => __('Display special phrase instead of discount percentage', 'dina-kala'),
                'subtitle' => __('Display special phrase instead of discount percentage on discounted products', 'dina-kala'),
                'default'  => false,
                'required' => array( 'display_discount', '=', true ),
            ),

            array(
                'id'       => 'reset_var_text',
                'type'     => 'text',
                'title' => __('Clear options text', 'dina-kala'),
                'default'  => __('Clear options', 'dina-kala'),                
                'required' => array( 'ch_reset_var_text', '=', true ),
            ),

            array(
                'id' => 'excerpt-section-start',
                'type' => 'section',
                'title' => __( 'Product excerpt settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_prod_excerpt',
                'type'     => 'switch',
                'title' => __('Show product excerpt', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'show_prod_excerpt_icon',
                'type'     => 'switch',
                'title' => __('Show product excerpt icon', 'dina-kala'),
                'required' => array( 'show_prod_excerpt', '=', true ),
                'default'  => true,
            ),
            array(
                'id' => 'excerpt-section-end',
                'type' => 'section',
                'indent' => false,
            ),

            array(
                'id' => 'features-section-start',
                'type' => 'section',
                'title' => __( 'Product features settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_prodf_title',
                'type'     => 'switch',
                'title' => __('Show product features title', 'dina-kala'),
                'subtitle' => __('Show product features title in product page', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'prodf_title',
                'type'     => 'text',
                'title'    => __('Product features title', 'dina-kala'),
                'default'  => __('Product Features:', 'dina-kala'),                
                'required' => array( 'show_prodf_title', '=', true ),
            ),
            array(
                'id'       => 'replace_features',
                'type'     => 'switch',
                'title'    => __('Show product excerpt instead product features', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'replace_features_tab',
                'type'     => 'switch',
                'title'    => __('Display the specifications in the Product Features tab instead of the product specifications', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'features_tab_count',
                'type'     => 'text',
                'title'    => __('Maximum number of features displayed', 'dina-kala'),
                'default'  => 10,                
                'required' => array( 'replace_features_tab', '=', true ),
            ),
            array(
                'id' => 'features-section-end',
                'type' => 'section',
                'indent' => false,
            ),

            array(
                'id' => 'price-section-start',
                'type' => 'section',
                'title' => __( 'Price settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_free_price',
                'type'     => 'switch',
                'title'    => __('Show Free Price instead of zero price', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'show_zero_call',
                'type'     => 'switch',
                'title'    => __('Show Call instead of Free Price', 'dina-kala'),
                'subtitle' => __('Show phrase call instead of free quote for zero price products', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'zero_call_link',
                'type'     => 'text',
                'title' => __('Contact text link', 'dina-kala'),
                'subtitle' => __('If the link is empty, it will be deactivated', 'dina-kala'),
                'default'  => '',                
                'required' => array( 'show_zero_call', '=', true ),
            ),
            array(
                'id'       => 'show_login_price',
                'type'     => 'switch',
                'title'    => __('Show price and add to cart button to logged in users', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'show_price_out',
                'type'     => 'switch',
                'title'    => __('Show price for out of stock products', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'remove_price_range',
                'type'     => 'switch',
                'title'    => __('Remove price range', 'dina-kala'),
                'subtitle' => __('Remove price range and display the lowest price', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'show_max_price',
                'type'     => 'switch',
                'title'    => __('Display higher price', 'dina-kala'),
                'subtitle' => __('Remove price range and display the higher price', 'dina-kala'),
                'default'  => false,
                'required' => array( 'remove_price_range', '=', true ),
            ),
            array(
                'id'       => 'remove_dub_price_range',
                'type'     => 'switch',
                'title'    => __('Remove second price', 'dina-kala'),
                'subtitle' => __('Remove second price in variable products (Prices should not be the same)', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id' => 'price-section-end',
                'type' => 'section',
                'indent' => false,
            ),

            array(
                'id' => 'related-section-start',
                'type' => 'section',
                'title' => __( 'Related Products settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_related_p',
                'type'     => 'switch',
                'title' => __('Related Products', 'dina-kala'),
                'subtitle' => __('Show related product section in product page', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'show_related_p_top',
                'type'     => 'switch',
                'title' => __('Show related products at the top of out of stock products', 'dina-kala'),
                'default'  => true,
                'required' => array( 'show_related_p', '=', true ),
            ),
            array(
                'id'       => 'related_p_title',
                'type'     => 'text',
                'title' => __('Block title', 'dina-kala'),
                'default'  => __('Related Produts', 'dina-kala'),   
                'required' => array( 'show_related_p', '=', true ),
            ),
            array(
                'id'       => 'related_p_count',
                'type'     => 'text',
                'title' => __('Product total count', 'dina-kala'),
                'default'  => 8,   
                'required' => array( 'show_related_p', '=', true ),
            ),
            array(
                'id'       => 'related_p_by',
                'type'     => 'select',
                'title' => __('Show related product by', 'dina-kala'),
                'options'  => array(
                    'product_cat' =>  __('Product category', 'dina-kala'),
                    'product_tag'  =>  __('Product tag', 'dina-kala'),
                    'brand'  =>  __('Product brand', 'dina-kala'),
                    'cat_and_brand'  =>  __('Product category And brand', 'dina-kala'),
                    'cat_or_brand'  =>  __('Product category Or brand', 'dina-kala')
                ),
                'default'  => 'product_cat',
                'required' => array( 'show_related_p', '=', true ),
            ),
            array(
                'id'       => 'show_by_last_cat',
                'type'     => 'switch',
                'title' => __('Display based on the latest level of product category (If product category is selected)', 'dina-kala'),
                'default'  => false,
                'required' => array( 'show_related_p', '=', true ),
            ),
            array(
                'id'       => 'show_out_prod',
                'type'     => 'switch',
                'title' => __('Show in stock products', 'dina-kala'),
                'default'  => true,
                'required' => array( 'show_related_p', '=', true ),
            ),
            array(
                'id'       => 'show_arrows',
                'type'     => 'switch',
                'title' => __('Show arrows', 'dina-kala'),
                'default'  => true,
                'required' => array( 'show_related_p', '=', true ),
            ),
            array(
                'id'       => 'prod_loop',
                'type'     => 'switch',
                'title' => __('Product loop', 'dina-kala'),
                'default'  => false,
                'required' => array( 'show_related_p', '=', true ),
            ),
            array(
                'id'       => 'auto_play',
                'type'     => 'switch',
                'title' => __('Auto play', 'dina-kala'),
                'default'  => false,
                'required' => array( 'show_related_p', '=', true ),
            ),
            array(
                'id'       => 'pcount',
                'type'     => 'text',
                'title' => __('Slider columns count', 'dina-kala'),
                'default'  => 5,                
                'required' => array( 'show_related_p', '=', true ),
            ),
            array(
                'id' => 'related-section-end',
                'type' => 'section',
                'indent' => false,
            ),

            array(
                'id' => 'up-sells-section-start',
                'type' => 'section',
                'title' => __( 'Up-selling products settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_up_sells',
                'type'     => 'switch',
                'title'    => __('Show up-selling products', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'up_sells_title',
                'type'     => 'text',
                'title'    => __('Block title', 'dina-kala'),
                'default'  => __('You may also like', 'dina-kala'),                
                'required' => array( 'show_up_sells', '=', true ),
            ),
            array(
                'id'       => 'up-sells-section-end',
                'type'     => 'section',
                'indent'   => false,
            ),

            array(
                'id' => 'extra-section-start',
                'type' => 'section',
                'title' => __( 'Site features settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_extra',
                'type'     => 'switch',
                'title'    => __('View site features section', 'dina-kala'),
                'default'  => true
            ),
            array(
                'id'       => 'show_extra_mobile',
                'type'     => 'switch',
                'title'    => __('View site features section in mobile mode', 'dina-kala'),
                'default'  => true,
                'required' => array( 'show_extra', '=', true ),
            ),
            array(
                'id'       => 'show_extra_one',
                'type'     => 'switch',
                'title'    => __('Show first feature', 'dina-kala'),
                'default'  => true,
                'required' => array( 'show_extra', '=', true ),
            ),
            array(
                'id'       => 'extra_one_title',
                'type'     => 'text',
                'title' => __('First feature title', 'dina-kala'),
                'default'  => __('Guarantee the best market price', 'dina-kala'),
                'required' => array( 'show_extra_one', '=', true ),
            ),
            array(
                'id'       => 'extra_one_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __('Icon', 'dina-kala'),
                'class'    => ' font-icons fal',
                'default'  => 'fal fa-credit-card',
                'options'  => $alliconArray,
                'required' => array( 'show_extra_one', '=', true ),
            ),
            array(
                'id'       => 'extra_one_img',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'Or custom icon', 'dina-kala' ),
                'compiler' => 'true',
                'desc'     => __( 'Suitable size: 32px by 32px', 'dina-kala' ),
            ),
            array(
                'id'       => 'extra_one_link',
                'type'     => 'text',
                'title' => __('First feature Link', 'dina-kala'),
                'required' => array( 'show_extra_one', '=', true ),
            ),
            array(
                'id'       => 'show_extra_two',
                'type'     => 'switch',
                'title'    => __('Show second feature', 'dina-kala'),
                'default'  => true,
                'required' => array( 'show_extra', '=', true ),
            ),
            array(
                'id'       => 'extra_two_title',
                'type'     => 'text',
                'title'    => __('Second feature title', 'dina-kala'),
                'default'  => __('Excellent support, 7 days a week', 'dina-kala'),
                'required' => array( 'show_extra_two', '=', true ),
            ),
            array(
                'id'       => 'extra_two_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __('Icon', 'dina-kala'),
                'class'    => ' font-icons fal',
                'default'  => 'fal fa-headset',
                'options'  => $alliconArray,
                'required' => array( 'show_extra_two', '=', true ),
            ),
            array(
                'id'       => 'extra_two_img',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'Or custom icon', 'dina-kala' ),
                'compiler' => 'true',
                'desc'     => __( 'Suitable size: 32px by 32px', 'dina-kala' ),
            ),
            array(
                'id'       => 'extra_two_link',
                'type'     => 'text',
                'title' => __('Second feature Link', 'dina-kala'),
                'required' => array( 'show_extra_two', '=', true ),
            ),
            array(
                'id'       => 'show_extra_three',
                'type'     => 'switch',
                'title'    => __('Show third feature', 'dina-kala'),
                'default'  => true,
                'required' => array( 'show_extra', '=', true ),
            ),
            array(
                'id'       => 'extra_three_title',
                'type'     => 'text',
                'title'    => __('Third feature title', 'dina-kala'),
                'default'  => __('Refund if unsatisfied', 'dina-kala'),
                'required' => array( 'show_extra_three', '=', true ),
            ),
            array(
                'id'       => 'extra_three_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __('Icon', 'dina-kala'),
                'class'    => ' font-icons fal',
                'default'  => 'fal fa-history',
                'options'  => $alliconArray,
                'required' => array( 'show_extra_three', '=', true ),
            ),
            array(
                'id'       => 'extra_three_img',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'Or custom icon', 'dina-kala' ),
                'compiler' => 'true',
                'desc'     => __( 'Suitable size: 32px by 32px', 'dina-kala' ),
            ),
            array(
                'id'       => 'extra_three_link',
                'type'     => 'text',
                'title' => __('Third feature Link', 'dina-kala'),
                'required' => array( 'show_extra_three', '=', true ),
            ),
            array(
                'id'       => 'show_extra_four',
                'type'     => 'switch',
                'title'    => __('Show fourth feature', 'dina-kala'),
                'default'  => true,
                'required' => array( 'show_extra', '=', true ),
            ),
            array(
                'id'       => 'extra_four_title',
                'type'     => 'text',
                'title'    => __('Fourth feature title', 'dina-kala'),
                'default'  => __('Originality of goods from top brands', 'dina-kala'),
                'required' => array( 'show_extra_four', '=', true ),
            ),
            array(
                'id'       => 'extra_four_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __('Icon', 'dina-kala'),
                'class'    => ' font-icons fal',
                'default'  => 'fal fa-certificate',
                'options'  => $alliconArray,
                'required' => array( 'show_extra_four', '=', true ),
            ),
            array(
                'id'       => 'extra_four_img',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'Or custom icon', 'dina-kala' ),
                'compiler' => 'true',
                'desc'     => __( 'Suitable size: 32px by 32px', 'dina-kala' ),
            ),
            array(
                'id'       => 'extra_four_link',
                'type'     => 'text',
                'title' => __('Fourth feature Link', 'dina-kala'),
                'required' => array( 'show_extra_four', '=', true ),
            ),
            array(
                'id'       => 'show_extra_five',
                'type'     => 'switch',
                'title'    => __('Show fifth feature', 'dina-kala'),
                'default'  => true,
                'required' => array( 'show_extra', '=', true ),
            ),
            array(
                'id'       => 'extra_five_title',
                'type'     => 'text',
                'title'    => __('Fifth feature title', 'dina-kala'),
                'default'  => __('Falt delivery in the shortest possible time', 'dina-kala'),
                'required' => array( 'show_extra_five', '=', true ),
            ),
            array(
                'id'       => 'extra_five_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __('Icon', 'dina-kala'),
                'class'    => ' font-icons fal',
                'default'  => 'fal fa-shipping-fast',
                'options'  => $alliconArray,
                'required' => array( 'show_extra_five', '=', true ),
            ),
            array(
                'id'       => 'extra_five_img',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'Or custom icon', 'dina-kala' ),
                'compiler' => 'true',
                'desc'     => __( 'Suitable size: 32px by 32px', 'dina-kala' ),
            ),
            array(
                'id'       => 'extra_five_link',
                'type'     => 'text',
                'title' => __('Fifth feature Link', 'dina-kala'),
                'required' => array( 'show_extra_five', '=', true ),
            ),
            array(
                'id' => 'extra-section-end',
                'type' => 'section',
                'indent' => false,
            ),
            
            array(
                'id' => 'pinfo-section-start',
                'type' => 'section',
                'title' => __( 'Additional product information settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_add_prod_info',
                'type'     => 'switch',
                'subtitle'  => __('Display the desired text below the product price', 'dina-kala'),   
                'title'    => __('Show Additional product information', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'add_prod_info_title',
                'type'     => 'text',
                'title'    => __('Additional product information title', 'dina-kala'),
                'default'  => __('Title', 'dina-kala'),
                'required' => array( 'show_add_prod_info', '=', true ),
            ),
            array(
                'id'      => 'add_prod_info_text',
                'type'    => 'editor',
                'title'   => __( 'Additional product information text', 'dina-kala' ),
                'default'  => __( 'Text', 'dina-kala' ),
                'args'    => array(
                    'wpautop'       => false,
                    'media_buttons' => false,
                    'textarea_rows' => 5,
                    'teeny'         => false,
                    'quicktags'     => true,
                ),
                'required' => array( 'show_add_prod_info', '=', true ),
            ),
            array(
                'id' => 'pinfo-section-end',
                'type' => 'section',
                'indent' => false,
            ),

            array(
                'id' => 'pbtn-section-start',
                'type' => 'section',
                'title' => __( 'Additional product button settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_add_prod_btn',
                'type'     => 'switch',
                'title'    => __('Display Additional button in product page', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'show_add_prod_call',
                'type'     => 'switch',
                'title'    => __('Display Additional button in non-purchasable products', 'dina-kala'),
                'default'  => true,
                'required' => array( 'show_add_prod_btn', '=', true ),
            ),
            array(
                'id'       => 'add_prod_btn_title',
                'type'     => 'text',
                'title'    => __('Additional product button title', 'dina-kala'),
                'default'  => __('Title', 'dina-kala'),
                'required' => array( 'show_add_prod_btn', '=', true ),
            ),
            array(
                'id'       => 'add_prod_btn_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __( 'Additional product button icon', 'dina-kala' ),
                'class'    => ' font-icons fal',
                'default'  => 'fal fa-bell',
                'options'  => $alliconArray,
                'required' => array( 'show_add_prod_btn', '=', true ),
            ),
            array(
                'id'       => 'add_prod_btn_color',
                'type'     => 'select',
                'title' => __( 'Button color', 'dina-kala' ),
                'options'  => array(
                    'btn-outline-dina'  =>  __( 'Theme Color', 'dina-kala' ),
                    'btn-outline-info'  =>  __( 'Blue', 'dina-kala' ),
                    'btn-outline-primary'  =>  __( 'Dark Blue', 'dina-kala' ),
                    'btn-outline-warning' =>  __( 'Yellow', 'dina-kala' ),
                    'btn-outline-success'  =>  __( 'Green', 'dina-kala' ),
                    'btn-outline-dark'  =>  __( 'Dark', 'dina-kala' ),
                    'btn-outline-danger'  =>  __( 'Red', 'dina-kala' ),
                    'btn-info'  =>  __( 'Solid Blue', 'dina-kala' ),
                    'btn-primary'  =>  __( 'Solid Dark Blue', 'dina-kala' ),
                    'btn-warning' =>  __( 'Solid Yellow', 'dina-kala' ),
                    'btn-success'  =>  __( 'Solid Green', 'dina-kala' ),
                    'btn-dark'  =>  __( 'Solid Dark', 'dina-kala' ),
                    'btn-danger'  =>  __( 'Solid Red', 'dina-kala' )
                ),
                'default'  => 'btn-outline-dina',
                'required' => array( 'show_add_prod_btn', '=', true ),
            ),
            array(
                'id'       => 'add_prod_btn_link',
                'type'     => 'text',
                'title'    => __('Additional product button link', 'dina-kala'),
                'default'  => __('#', 'dina-kala'),
                'required' => array( 
                    array( 'show_add_prod_btn', '=', true ),
                    array( 'show_add_prod_popup', '!=', true ),
                )
            ),
            array(
                'id'       => 'add_prod_btn_link_target',
                'type'     => 'select',
                'title' => __( 'Link Target', 'dina-kala' ),
                'options'  => array(
                    '_blank'  =>  __( 'New Window', 'dina-kala' ),
                    '_self'  =>  __( 'Same Window', 'dina-kala' ),
                ),
                'default'  => '_blank',
                'required' => array( 
                    array( 'show_add_prod_btn', '=', true ),
                    array( 'show_add_prod_popup', '!=', true ),
                )
            ),
            array(
                'id'       => 'show_add_prod_popup',
                'type'     => 'switch',
                'title'    => __('Show pop-up by clicking the button', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'add_per_prod_popup',
                'type'     => 'switch',
                'title'    => __('Activate the ability to customize the title and content for each product', 'dina-kala'),
                'default'  => false,
                'required' => array( 'show_add_prod_popup', '=', true ),
            ),
            array(
                'id'       => 'add_prod_popup_title',
                'type'     => 'text',
                'title'    => __('Pop-up title', 'dina-kala'),
                'default'  => __('Title', 'dina-kala'),
                'required' => array( 'show_add_prod_popup', '=', true ),
            ),
            array(
                'id'       => 'add_prod_popup_size',
                'type'     => 'select',
                'title' => __('Pop-up size', 'dina-kala'),
                'options'  => array(
                    'modal-sm' => __('Small', 'dina-kala'),
                    'modal-md' =>  __('Default', 'dina-kala'),
                    'modal-lg' =>  __('Larg', 'dina-kala'),
                ),
                'default'  => 'modal-md',
                'required' => array( 'show_add_prod_popup', '=', true ),
            ),
            array(
                'id'      => 'add_prod_popup_text',
                'type'    => 'editor',
                'title'   => __( 'Pop-up content', 'dina-kala' ),
                'desc'       => __( 'You can also use the shortcode', 'dina-kala' ),
                'default'  => __( 'Content', 'dina-kala' ),
                'args'    => array(
                    'wpautop'       => false,
                    'media_buttons' => false,
                    'textarea_rows' => 5,
                    'teeny'         => false,
                    'quicktags'     => true,
                ),
                'required' => array( 'show_add_prod_popup', '=', true ),
            ),
            array(
                'id' => 'pinfo-section-end',
                'type' => 'section',
                'indent' => false,
            ),

        ),
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Additional product tab', 'dina-kala' ),
        'id'         => 'additional_product_tab',
        'icon'       => 'el el-folder',
        'subsection' => true,
        'fields'     => array(
            array(
                'id' => 'additional-product-tab-one-start',
                'type' => 'section',
                'title' => __( 'Settings of the first additional tab of products', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_add_prod_tab_one',
                'type'     => 'switch',
                'title'  => __('Show tab', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'add_prod_tab_one_title',
                'type'     => 'text',
                'title'    => __('Tab title', 'dina-kala'),
                'default'  => __('Title', 'dina-kala'),
                'required' => array( 'show_add_prod_tab_one', '=', true ),
            ),
            array(
                'id'       => 'add_prod_tab_one_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __( 'Tab icon', 'dina-kala' ),
                'class'    => ' font-icons fal',
                'default'  => 'fal fa-info-circle',
                'options'  => $alliconArray,
                'required' => array( 'show_add_prod_tab_one', '=', true ),
            ),
            array(
                'id'       => 'tab_one_in_cats',
                'type'     => 'switch',
                'title'    => __('Show tab in specific categories', 'dina-kala'),
                'default'  => false,
                'required' => array( 'show_add_prod_tab_one', '=', true ),
            ),
            array(
                'id'    => 'add_prod_tab_one_cats',
                'type'     => 'select',
                'multi'    => true,
                'title' => __( 'Categories', 'dina-kala' ), 
                'data'  => 'terms',
                'args'  => array(
                    'taxonomies' => array( 'product_cat' ),
                    'hide_empty' => false,
                ),
                'required' => array( 'tab_one_in_cats', '=', true )
            ),
            array(
                'id'      => 'add_prod_tab_one_content',
                'type'    => 'editor',
                'title'   => __( 'Tab content', 'dina-kala' ),
                'default'  => __( 'Text', 'dina-kala' ),
                'args'    => array(
                    'wpautop'       => false,
                    'media_buttons' => false,
                    'textarea_rows' => 5,
                    'teeny'         => false,
                    'quicktags'     => true,
                ),
                'required' => array( 'show_add_prod_tab_one', '=', true ),
            ),
            array(
                'id' => 'additional-product-tab-one-end',
                'type' => 'section',
                'indent' => false,
            ),

            array(
                'id' => 'additional-product-tab-two-start',
                'type' => 'section',
                'title' => __( 'Settings of the second additional tab of products', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_add_prod_tab_two',
                'type'     => 'switch',
                'title'  => __('Show tab', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'add_prod_tab_two_title',
                'type'     => 'text',
                'title'    => __('Tab title', 'dina-kala'),
                'default'  => __('Title', 'dina-kala'),
                'required' => array( 'show_add_prod_tab_two', '=', true ),
            ),
            array(
                'id'       => 'add_prod_tab_two_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __( 'Tab icon', 'dina-kala' ),
                'class'    => ' font-icons fal',
                'default'  => 'fal fa-certificate',
                'options'  => $alliconArray,
                'required' => array( 'show_add_prod_tab_two', '=', true ),
            ),
            array(
                'id'       => 'tab_two_in_cats',
                'type'     => 'switch',
                'title'    => __('Show tab in specific categories', 'dina-kala'),
                'default'  => false,
                'required' => array( 'show_add_prod_tab_two', '=', true ),
            ),
            array(
                'id'    => 'add_prod_tab_two_cats',
                'type'     => 'select',
                'multi'    => true,
                'title' => __( 'Categories', 'dina-kala' ), 
                'data'  => 'terms',
                'args'  => array(
                    'taxonomies' => array( 'product_cat' ),
                    'hide_empty' => false,
                ),
                'required' => array( 'tab_two_in_cats', '=', true )
            ),
            array(
                'id'      => 'add_prod_tab_two_content',
                'type'    => 'editor',
                'title'   => __( 'Tab content', 'dina-kala' ),
                'default'  => __( 'Text', 'dina-kala' ),
                'args'    => array(
                    'wpautop'       => false,
                    'media_buttons' => false,
                    'textarea_rows' => 5,
                    'teeny'         => false,
                    'quicktags'     => true,
                ),
                'required' => array( 'show_add_prod_tab_two', '=', true ),
            ),
            array(
                'id' => 'additional-product-tab-two-end',
                'type' => 'section',
                'indent' => false,
            ),
        ),
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __('Woocommerce Settings', 'dina-kala'),
        'id'         => 'menu_woo',
        'icon'       => 'el el-wordpress',
        'fields'     => array(
            array(
                'id'       => 'show_checkout_steps',
                'type'     => 'switch',
                'title'    => __( 'Display payment steps on shopping cart and checkout pages' , 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'remove_download',
                'type'     => 'switch',
                'title' => __( 'Remove download option' , 'dina-kala'),
                'subtitle' => __( 'Remove download option from menu and user panel' , 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'remove_password_strength',
                'type'     => 'switch',
                'title' => __( 'Remove password strength' , 'dina-kala'),
                'subtitle' => __( 'Remove password strength in woocommerce register form' , 'dina-kala'),
                'default'  => false,
            ),

            /*array(
                'id'       => 'remove_extra_fields',
                'type'     => 'switch',
                'title' => __( 'Remove extra fields', 'dina-kala'),
                'subtitle' => __( 'Remove extra fields from products that do not have physical shipping', 'dina-kala'),
                'default'  => false,
            ),*/
        ),
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'User panel settings', 'dina-kala' ),
        'id'         => 'user_panel_setting',
        'icon'       => 'el el-user',
        'fields'     => array(
            array(
                'id'       => 'remove_myacc_hooks',
                'type'     => 'switch',
                'title' => __( 'Remove template hooks from WooCommerce user panel' , 'dina-kala'),
                'subtitle'  => __( 'Enabling this option removes the template code from the WooCommerce user panel. Enabling this option is used to eliminate interference with other user panel plugins.','dina-kala'),
                'default'  => false,
            ),

            array(
                'id' => 'dashboard-link-one-section-start',
                'type' => 'section',
                'title' => __( 'Settings for the first custom dashboard link', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'dashboard_link_one',
                'type'     => 'switch',
                'title' => __( 'Activate the first link', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'dashboard_link_one_title',
                'type'     => 'text',
                'title' => __( 'Title', 'dina-kala'),
                'default'  => __( 'First link', 'dina-kala'),                
                'required' => array( 'dashboard_link_one', '=', true ),
            ),
            array(
                'id'       => 'dashboard_link_one_url',
                'type'     => 'text',
                'title' => __( 'Link', 'dina-kala'),
                'default'  => '#',                
                'required' => array( 'dashboard_link_one', '=', true ),
            ),
            array(
                'id'       => 'dashboard_link_one_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __( 'Icon', 'dina-kala'),
                'class'    => ' font-icons fal',
                'default'  => 'fal fa-link',
                'options'  => $iconArray,
                'required' => array( 'dashboard_link_one', '=', true ),
            ),
            array(
                'id' => 'dashboard-link-one-section-end',
                'type' => 'section',
                'indent' => false ,
            ),

            array(
                'id' => 'dashboard-link-two-section-start',
                'type' => 'section',
                'title' => __( 'Settings for the second custom dashboard link', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'dashboard_link_two',
                'type'     => 'switch',
                'title' => __( 'Activate the second link', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'dashboard_link_two_title',
                'type'     => 'text',
                'title' => __( 'Title', 'dina-kala'),
                'default'  => __( 'Second link', 'dina-kala'),                
                'required' => array( 'dashboard_link_two', '=', true ),
            ),
            array(
                'id'       => 'dashboard_link_two_url',
                'type'     => 'text',
                'title' => __( 'Link', 'dina-kala'),
                'default'  => '#',                
                'required' => array( 'dashboard_link_two', '=', true ),
            ),
            array(
                'id'       => 'dashboard_link_two_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __( 'Icon', 'dina-kala'),
                'class'    => ' font-icons fal',
                'default'  => 'fal fa-link',
                'options'  => $iconArray,
                'required' => array( 'dashboard_link_two', '=', true ),
            ),
            array(
                'id' => 'dashboard-link-two-section-end',
                'type' => 'section',
                'indent' => false ,
            ),

            array(
                'id' => 'dashboard-link-three-section-start',
                'type' => 'section',
                'title' => __( 'Settings for the third custom dashboard link', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'dashboard_link_three',
                'type'     => 'switch',
                'title' => __( 'Activate the third link', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'dashboard_link_three_title',
                'type'     => 'text',
                'title' => __( 'Title', 'dina-kala'),
                'default'  => __( 'Third link', 'dina-kala'),                
                'required' => array( 'dashboard_link_three', '=', true ),
            ),
            array(
                'id'       => 'dashboard_link_three_url',
                'type'     => 'text',
                'title' => __( 'Link', 'dina-kala'),
                'default'  => '#',                
                'required' => array( 'dashboard_link_three', '=', true ),
            ),
            array(
                'id'       => 'dashboard_link_three_icon',
                'type'     => 'select',
                'select2'  => array( 'containerCssClass' => 'fa' ),
                'title'    => __( 'Icon', 'dina-kala'),
                'class'    => ' font-icons fal',
                'default'  => 'fal fa-link',
                'options'  => $iconArray,
                'required' => array( 'dashboard_link_three', '=', true ),
            ),
            array(
                'id' => 'dashboard-link-three-section-end',
                'type' => 'section',
                'indent' => false ,
            ),

            array(
                'id' => 'dashboard-message-section-start',
                'type' => 'section',
                'title' => __( 'Settings for dashboard messages', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_dashboard_message',
                'type'     => 'switch',
                'title' => __( 'Display messages in users panel' , 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'dashboard_message_one',
                'type'     => 'textarea',
                'title' => __('The text of the first message', 'dina-kala'),
                'subtitle'  => __('The text of the first message displayed in the user panel', 'dina-kala'),   
                'default'  => __( 'From your account dashboard you can view your recent orders, manage your billing address, and edit your password and account details.', 'dina-kala' ),
                'required' => array( 'show_dashboard_message', '=', true ),
            ),

            array(
                'id'       => 'dashboard_message_two',
                'type'     => 'textarea',
                'title' => __('The text of the second message', 'dina-kala'),
                'subtitle'  => __('The text of the second message displayed in the user panel', 'dina-kala'),
                'default'  => '',
                'required' => array( 'show_dashboard_message', '=', true ),
            ),

            array(
                'id'       => 'dashboard_message_three',
                'type'     => 'textarea',
                'title' => __('The text of the third message', 'dina-kala'),
                'subtitle'  => __('The text of the third message displayed in the user panel', 'dina-kala'),   
                'default'  => '',
                'required' => array( 'show_dashboard_message', '=', true ),
            ),
            array(
                'id' => 'dashboard-message-section-end',
                'type' => 'section',
                'indent' => false ,
            ),            
        ),
    ) );

    if( class_exists( 'WeDevs_Dokan' ) ) { 
    Redux::setSection( $opt_name, array(
        'title'      => __( 'Dokan Settings', 'dina-kala' ),
        'id'         => 'dokan_setting',
        'desc'       => __( "Dokan plugin settings (Multivendor Plugin)", 'dina-kala' ),
        'icon'       => 'el el-group',
        'fields'     => array(
            array(
                'id'       => 'show_product_vendor',
                'type'     => 'switch',
                'title'    => __('Show product vendor name in product page', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'show_product_vendor_archive',
                'type'     => 'switch',
                'title'    => __('Show product vendor name in product archive page', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'hide_dokan_shipping',
                'type'     => 'switch',
                'title'    => __('Remove dokan shipping tab in product page', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'hide_dokan_seller_info',
                'type'     => 'switch',
                'title'    => __('Remove dokan seller info tab in product page', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'hide_dokan_more_product',
                'type'     => 'switch',
                'title'    => __('Remove dokan more seller products tab in product page', 'dina-kala'),
                'default'  => false,
            ),
        ),
    ) );
    }


    Redux::setSection( $opt_name, array(
        'title'      => __( 'Products brand', 'dina-kala' ),
        'id'         => 'product_br',
        'desc'       => __( "Products brand's settings (In case of error 404, re-save permalinks once.)", 'dina-kala' ),
        'icon'       => 'el el-tag',
        'fields'     => array(
            array(
                'id'       => 'product_brand',
                'type'     => 'switch',
                'title'    => __('Activate the product brand feature', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'product_brand_slug',
                'type'     => 'text',
                'title' => __('Product brand slug', 'dina-kala'),
                'subtitle'  => __('After save settings, go to wordpress permalink setting and click save.', 'dina-kala'),   
                'default'  => 'brand',
                'required' => array( 'product_brand', '=', true ),
            ),
            array(
                'id'       => 'product_brand_taxonomy',
                'type'     => 'text',
                'title' => __('Product brand taxonomy', 'dina-kala'),
                'subtitle'  => __('After save settings, go to wordpress permalink setting and click save. With this section, you can change the taxonomy of the brand that is stored in the database, note that by changing this section, the brands you have already created will not be displayed, this section is used to be compatible with other brands of templates and plugins.', 'dina-kala'),   
                'default'  => 'brand',
                'required' => array( 'product_brand', '=', true ),
            ),
            array(
                'id'       => 'show_product_brand',
                'type'     => 'switch',
                'title'    => __('Show product brand', 'dina-kala'),
                'subtitle'    => __('Show product brand section in product page', 'dina-kala'),
                'default'  => true,
                'required' => array( 'product_brand', '=', true ),
            ),
            array(
                'id'       => 'add_brand_schema',
                'type'     => 'switch',
                'title'    => __('Add brand schema', 'dina-kala'),
                'subtitle'    => __('Add brand schema to product schema', 'dina-kala'),
                'default'  => true,
                'required' => array( 'product_brand', '=', true ),
            ),
            array(
                'id'       => 'show_product_brand_tab',
                'type'     => 'switch',
                'title'    => __('Show product brand tab', 'dina-kala'),
                'subtitle'    => __('Show product brand tab in product page', 'dina-kala'),
                'default'  => false,
                'required' => array( 'product_brand', '=', true ),
            ),
            array(
                'id'       => 'product_brand_tab_title',
                'type'     => 'text',
                'title' => __('Product brand tab title', 'dina-kala'),  
                'default'  => __( 'Product brand', 'dina-kala' ),
                'required' => array( 'show_product_brand_tab', '=', true ),
            ),
        ),
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Post Settings', 'dina-kala' ),
        'id'         => 'post_setting',
        'icon'       => 'el el-list-alt',
        'fields'     => array(
            array(
                'id'       => 'post_side',
                'type'     => 'image_select',
                'title'    => __('Posts Sidebar', 'dina-kala'),
                'subtitle' => __('Specify the location of the posts sidebar, this feature is also customizable for each post.', 'dina-kala'),
                'options'  => array(
                    '0' => array(
                        'alt' => __('No sidebar', 'dina-kala'),
                        'img' => RE_URI . 'assets/img/1c.png'
                    ),
                    '1' => array(
                        'alt' => __('Left alignment', 'dina-kala'),
                        'img' => RE_URI . 'assets/img/2cl.png'
                    ),
                    '2' => array(
                        'alt' => __('Right alignment', 'dina-kala'),
                        'img' => RE_URI . 'assets/img/2cr.png'
                    )
                ),
                'default'  => '1'
            ),
            array(
                'id'       => 'post_archive_side',
                'type'     => 'image_select',
                'title'    => __('Posts Archive Sidebar', 'dina-kala'),
                'subtitle' => __('Specify the location of the posts sidebar in archive pages (Category page, Tag page, ...)', 'dina-kala'),
                'options'  => array(
                    '0' => array(
                        'alt' => __('No sidebar', 'dina-kala'),
                        'img' => RE_URI . 'assets/img/1c.png'
                    ),
                    '1' => array(
                        'alt' => __('Left alignment', 'dina-kala'),
                        'img' => RE_URI . 'assets/img/2cl.png'
                    ),
                    '2' => array(
                        'alt' => __('Right alignment', 'dina-kala'),
                        'img' => RE_URI . 'assets/img/2cr.png'
                    )
                ),
                'default'  => '1'
            ),
            array(
                'id'       => 'post_col',
                'type'     => 'select',
                'title' => __('Number of posts columns', 'dina-kala'),
                'subtitle' => __('Number of posts columns in archive pages', 'dina-kala'),
                'options'  => array(
                    2 =>  2,
                    3 =>  3,
                    4 =>  4,
                    5 =>  5,
                ),
                'default'  => 4,
            ),
            array(
                'id'       => 'show_parchive_title',
                'type'     => 'switch',
                'title'    => __('Show post archive title', 'dina-kala'),
                'subtitle'    => __('Add archive title to post archive pages', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'custom_post_thumb',
                'type'     => 'switch',
                'title'    => __('Custom size for thumbnails of posts', 'dina-kala'),
                'subtitle' => __('Need to regenerate thumbnails by the plugin (regenerate thumbnails)', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'post_thumb_width',
                'type'     => 'text',
                'title' => __('Width', 'dina-kala'),
                'default'  => '300',                
                'required' => array( 'custom_post_thumb', '=', true ),
            ),
            array(
                'id'       => 'post_thumb_height',
                'type'     => 'text',
                'title' => __('Height', 'dina-kala'),
                'default'  => '300',                
                'required' => array( 'custom_post_thumb', '=', true ),
            ),
            array(
                'id'       => 'show_post_cat',
                'type'     => 'switch',
                'title'    => __('Show post category on the thumbnail image', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'show_post_pub',
                'type'     => 'switch',
                'title'    => __('Show post publish date on the thumbnail image', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'show_post_excerpt',
                'type'     => 'switch',
                'title'    => __('Show post excerpt in post archive pages', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'show_author_block',
                'type'     => 'switch',
                'title'    => __('Show author info block in post page', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'show_more_s',
                'type'     => 'switch',
                'title'    => __('Post descriptions are summarized in mobile mode', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'ajax_post',
                'type'     => 'switch',
                'title'    => __('Ajax Posts loading', 'dina-kala'),
                'subtitle' => __('Loading posts ajax and remove pagination', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'show_post_thumb',
                'type'     => 'switch',
                'title' => __('Show Post Thumbnail', 'dina-kala'),
                'subtitle' => __('Show Post Thumbnail in top of post content', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'show_post_tags',
                'type'     => 'switch',
                'title'    => __('View Post tags section', 'dina-kala'),
                'default'  => true
            ),
            array(
                'id'       => 'show_post_cats',
                'type'     => 'switch',
                'title'    => __('View Post category section', 'dina-kala'),
                'default'  => true
            ),
            array(
                'id'       => 'show_post_view',
                'type'     => 'switch',
                'title'    => __('View Post view section', 'dina-kala'),
                'default'  => true
            ),
            array(
                'id'       => 'show_post_aut',
                'type'     => 'switch',
                'title'    => __('Show author name in post page', 'dina-kala'),
                'default'  => true
            ),
            array(
                'id'       => 'show_post_pubdate',
                'type'     => 'switch',
                'title'    => __('Show publish date in post page', 'dina-kala'),
                'default'  => true
            ),
            array(
                'id'       => 'show_post_up',
                'type'     => 'switch',
                'title'    => __('Show update date in post page', 'dina-kala'),
                'default'  => false,
                'required' => array( 'show_post_pubdate', '=', true ),
            ),
            array(
                'id'       => 'share_post',
                'type'     => 'switch',
                'title' => __('Share Post Button', 'dina-kala'),
                'subtitle' => __('Show Share Post Button in post page', 'dina-kala'),
                'default'  => true,
            ),

            array(
                'id' => 'relatedp-section-start',
                'type' => 'section',
                'title' => __( 'Related Posts settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_related_post',
                'type'     => 'switch',
                'title' => __('Related Post', 'dina-kala'),
                'subtitle' => __('Show related post section in post page', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'related_post_title',
                'type'     => 'text',
                'title' => __('Block title', 'dina-kala'),
                'default'  => __('Related Posts', 'dina-kala'),   
                'required' => array( 'show_related_post', '=', true ),
            ),
            array(
                'id'       => 'related_post_count',
                'type'     => 'text',
                'title' => __('Post total count', 'dina-kala'),
                'default'  => 8,   
                'required' => array( 'show_related_post', '=', true ),
            ),
            array(
                'id'       => 'related_post_by',
                'type'     => 'select',
                'title' => __('Show related post by', 'dina-kala'),
                'options'  => array(
                    'category' =>  __('Post category', 'dina-kala'),
                    'post_tag'  =>  __('Post tag', 'dina-kala'),
                ),
                'default'  => 'category',
                'required' => array( 'show_related_post', '=', true ),
            ),
            array(
                'id'       => 'show_post_arrows',
                'type'     => 'switch',
                'title' => __('Show arrows', 'dina-kala'),
                'default'  => true,
                'required' => array( 'show_related_post', '=', true ),
            ),
            array(
                'id'       => 'post_loop',
                'type'     => 'switch',
                'title' => __('Post loop', 'dina-kala'),
                'default'  => false,
                'required' => array( 'show_related_post', '=', true ),
            ),
            array(
                'id'       => 'auto_post_play',
                'type'     => 'switch',
                'title' => __('Auto play', 'dina-kala'),
                'default'  => false,
                'required' => array( 'show_related_post', '=', true ),
            ),
            array(
                'id'       => 'postcount',
                'type'     => 'text',
                'title' => __('Post count', 'dina-kala'),
                'default'  => 5,                
                'required' => array( 'show_related_post', '=', true ),
            ),
            array(
                'id' => 'relatedp-section-end',
                'type' => 'section',
                'indent' => false,
            ),

            array(
                'id'     => 'section-dl-box-start',
                'type'   => 'section',
                'title' => __('Download Box Settings', 'dina-kala'),
                'indent' => true,
            ),
            array(
                'id'       => 'dl_box_product',
                'type'     => 'switch',
                'title' => __('Activate the download box in the products', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'dl_box_login',
                'type'     => 'switch',
                'title' => __('Show download links to logged in users', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'dl_guide_title',
                'type'     => 'text',
                'title' => __('Download guide title', 'dina-kala'),
                'default'  => __('Download guide', 'dina-kala'),
            ), 
            array(
                'id'      => 'dl_guide_text',
                'type'    => 'editor',
                'title'   => __('Download guide text', 'dina-kala'),
                'default' => __('Download guide', 'dina-kala'),
                'args'    => array(
                    'wpautop'       => false,
                    'media_buttons' => false,
                    'textarea_rows' => 5,
                    'teeny'         => false,
                    'quicktags'     => true,
                ),
            ),
            array(
                'id'       => 'dl_box_pass',
                'type'     => 'text',
                'title' => __('Default Password', 'dina-kala'),
                'subtitle' => __('This item can be set for each post individually on the post page', 'dina-kala'),
                'default'  => 'www.example.com',
            ),
            array(
                'id'     => 'section-dl-box-end',
                'type'   => 'section',
                'indent' => false,
            ),

            array(
                'id' => 'post-top-banner-section-start',
                'type' => 'section',
                'title' => __( 'Ad banner settings above posts', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_post_top_banner',
                'type'     => 'switch',
                'title'    => __( 'Show banner ad above posts', 'dina-kala' ),
                'default'  => false
            ),
            array(
                'id'       => 'show_post_top_mobile',
                'type'     => 'switch',
                'title'    => __( 'Show banner in mobile mode', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'show_post_top_banner', '=', true ),
            ),
            array(
                'id'       => 'post_top_banner',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'Banner image', 'dina-kala' ),
                'compiler' => 'true',
                'subtitle' =>  __( 'Appropriate size: 940(w) in 150(h)', 'dina-kala' ),
                'required' => array( 'show_post_top_banner', '=', true ),
            ),
            array(
                'id'       => 'post_top_banner_link',
                'type'     => 'text',
                'title'    => __( 'Banner link', 'dina-kala' ),
                'default'  => '#',
                'required' => array( 'show_post_top_banner', '=', true ),
            ),
            array(
                'id'       => 'post_top_banner_title',
                'type'     => 'text',
                'title'    => __( 'Banner title', 'dina-kala' ),
                'default'  => '#',
                'required' => array( 'show_post_top_banner', '=', true ),
            ),
            array(
                'id' => 'post-top-banner-section-end',
                'type' => 'section',
                'indent' => false ,
            ),

            array(
                'id' => 'post-bottom-banner-section-start',
                'type' => 'section',
                'title' => __( 'Ad banner settings below posts', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'show_post_bottom_banner',
                'type'     => 'switch',
                'title'    => __( 'Show banner ad below posts', 'dina-kala' ),
                'default'  => false
            ),
            array(
                'id'       => 'show_post_bottom_mobile',
                'type'     => 'switch',
                'title'    => __( 'Show banner in mobile mode', 'dina-kala' ),
                'default'  => false,
                'required' => array( 'show_post_bottom_banner', '=', true ),
            ),
            array(
                'id'       => 'post_bottom_banner',
                'type'     => 'media',
                'url'      => true,
                'readonly' => false,
                'title'    => __( 'Banner image', 'dina-kala' ),
                'compiler' => 'true',
                'subtitle' =>  __( 'Appropriate size: 940(w) in 150(h)', 'dina-kala' ),
                'required' => array( 'show_post_bottom_banner', '=', true ),
            ),
            array(
                'id'       => 'post_bottom_banner_link',
                'type'     => 'text',
                'title'    => __( 'Banner link', 'dina-kala' ),
                'default'  => '#',
                'required' => array( 'show_post_bottom_banner', '=', true ),
            ),
            array(
                'id'       => 'post_bottom_banner_title',
                'type'     => 'text',
                'title'    => __( 'Banner title', 'dina-kala' ),
                'default'  => '#',
                'required' => array( 'show_post_bottom_banner', '=', true ),
            ),
            array(
                'id' => 'post-bottom-banner-section-end',
                'type' => 'section',
                'indent' => false ,
            ),

            array(
                'id' => 'comments-section-start',
                'type' => 'section',
                'title' => __( 'Comments settings', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'comment_remove_url',
                'type'     => 'switch',
                'title' => __('Remove the website field from the comment form', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'comment_remove_email',
                'type'     => 'switch',
                'title' => __('Remove the email field from the comment form', 'dina-kala'),
                'subtitle' => __( 'After disabling email field, disable "Comment author must fill out name and email" from settings > discussion', 'dina-kala' ),
                'default'  => false,
            ),
            array(
                'id'       => 'comment_remove_cookie',
                'type'     => 'switch',
                'title' => __('Remove the cookie save field from the comment form', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id' => 'commnets-section-end',
                'type' => 'section',
                'indent' => false ,
            ),

        ),
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Page Settings', 'dina-kala' ),
        'id'         => 'page_setting',
        'icon'       => 'el el-file',
        'fields'     => array(
            array(
                'id'       => 'page_side',
                'type'     => 'image_select',
                'title'    => __('Pages Sidebar', 'dina-kala'),
                'subtitle' => __('Specify the location of the pages sidebar, this feature is also customizable for each page.', 'dina-kala'),
                'options'  => array(
                    '0' => array(
                        'alt' => __('No sidebar', 'dina-kala'),
                        'img' => RE_URI . 'assets/img/1c.png'
                    ),
                    '1' => array(
                        'alt' => __('Left alignment', 'dina-kala'),
                        'img' => RE_URI . 'assets/img/2cl.png'
                    ),
                    '2' => array(
                        'alt' => __('Right alignment', 'dina-kala'),
                        'img' => RE_URI . 'assets/img/2cr.png'
                    )
                ),
                'default'  => '1'
            ),
            array(
                'id'       => 'show_page_thumb',
                'type'     => 'switch',
                'title' => __('Show Page Thumbnail', 'dina-kala'),
                'subtitle' => __('Show page Thumbnail in top of page content', 'dina-kala'),
                'default'  => false,
            ),
        ),
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Social Media', 'dina-kala' ),
        'id'         => 'menu_social',
        'icon'       => 'el el-facebook',
        'fields'     => array(

            array(
                'id' => 'share-links-section-start',
                'type' => 'section',
                'title' => __( 'Settings for product and post sharing links', 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'share_facebook',
                'type'     => 'switch',
                'title' => __( 'Facebook', 'dina-kala' ),
                'default'  => true,
            ),
            array(
                'id'       => 'share_google',
                'type'     => 'switch',
                'title' => __('Google+', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'share_pinterest',
                'type'     => 'switch',
                'title' => __('Pinterest', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'share_twitter',
                'type'     => 'switch',
                'title' => __('Twitter', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'share_linkedin',
                'type'     => 'switch',
                'title' => __('Linkedin', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'share_telegram',
                'type'     => 'switch',
                'title' => __('Telegram', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'share_whatsapp',
                'type'     => 'switch',
                'title' => __('Whatsapp', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'share_email',
                'type'     => 'switch',
                'title' => __('Email', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'share_copy',
                'type'     => 'switch',
                'title' => __('Copy short link', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id' => 'share-links-section-end',
                'type' => 'section',
                'indent' => false ,
            ),

            array(
                'id' => 'social-links-section-start',
                'type' => 'section',
                'title' => __( "Enter the link to the site's social pages", 'dina-kala' ),
                'indent' => true,
            ),
            array(
                'id'       => 'so_facebook',
                'type'     => 'switch',
                'title' => __( 'Facebook', 'dina-kala' ),
                'default'  => true,
            ),
            array(
                'id'       => 'so_facebook_link',
                'type'     => 'text',
                'title' => __('Link', 'dina-kala'),
                'default'  => '#',                
                'required' => array( 'so_facebook', '=', true ),
            ),
            array(
                'id'       => 'so_google',
                'type'     => 'switch',
                'title' => __('Google+', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'so_google_link',
                'type'     => 'text',
                'title' => __('Link', 'dina-kala'),
                'default'  => '#',
                'required' => array( 'so_google', '=', true ),
            ),
            array(
                'id'       => 'so_twitter',
                'type'     => 'switch',
                'title' => __('Twitter', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'so_twitter_link',
                'type'     => 'text',
                'title' => __('Link', 'dina-kala'),
                'default'  => '#',
                'required' => array( 'so_twitter', '=', true ),
            ),
            array(
                'id'       => 'so_youtube',
                'type'     => 'switch',
                'title' => __('Youtube', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'so_youtube_link',
                'type'     => 'text',
                'title' => __('Link', 'dina-kala'),
                'default'  => '#',
                'required' => array( 'so_youtube', '=', true ),
            ),
            array(
                'id'       => 'so_dribble',
                'type'     => 'switch',
                'title' => __('Dribble', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'so_dribble_link',
                'type'     => 'text',
                'title' => __('Link', 'dina-kala'),
                'default'  => '#',
                'required' => array( 'so_dribble', '=', true ),
            ),
            array(
                'id'       => 'so_behance',
                'type'     => 'switch',
                'title' => __('Behance', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'so_behance_link',
                'type'     => 'text',
                'title' => __('Link', 'dina-kala'),
                'default'  => '#',
                'required' => array( 'so_behance', '=', true ),
            ),
            array(
                'id'       => 'so_linkedin',
                'type'     => 'switch',
                'title' => __('Linkedin', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'so_linkedin_link',
                'type'     => 'text',
                'title' => __('Link', 'dina-kala'),
                'default'  => '#',
                'required' => array( 'so_linkedin', '=', true ),
            ),
            array(
                'id'       => 'so_instagram',
                'type'     => 'switch',
                'title' => __('Instagram', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'so_instagram_link',
                'type'     => 'text',
                'title' => __('Link', 'dina-kala'),
                'default'  => '#',
                'required' => array( 'so_instagram', '=', true ),
            ),
            array(
                'id'       => 'so_telegram',
                'type'     => 'switch',
                'title' => __('Telegram', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'so_telegram_link',
                'type'     => 'text',
                'title' => __('Link', 'dina-kala'),
                'default'  => '#',
                'required' => array( 'so_telegram', '=', true ),
            ),
            array(
                'id'       => 'so_pinterest',
                'type'     => 'switch',
                'title' => __('Pinterest', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'so_pinterest_link',
                'type'     => 'text',
                'title' => __('Link', 'dina-kala'),
                'default'  => '#',
                'required' => array( 'so_pinterest', '=', true ),
            ),
            array(
                'id'       => 'so_whatsapp',
                'type'     => 'switch',
                'title' => __('Whatsapp', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'so_whatsapp_link',
                'type'     => 'text',
                'title' => __('Link', 'dina-kala'),
                'default'  => '#',
                'required' => array( 'so_whatsapp', '=', true ),
            ),
            array(
                'id'       => 'so_tiktok',
                'type'     => 'switch',
                'title' => __('Tiktok', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'so_tiktok_link',
                'type'     => 'text',
                'title' => __('Link', 'dina-kala'),
                'default'  => '#',
                'required' => array( 'so_tiktok', '=', true ),
            ),
            array(
                'id'       => 'so_aparat',
                'type'     => 'switch',
                'title' => __('Aparat', 'dina-kala'),
                'default'  => true,
            ),
            array(
                'id'       => 'so_aparat_link',
                'type'     => 'text',
                'title' => __('Link', 'dina-kala'),
                'default'  => '#',
                'required' => array( 'so_aparat', '=', true ),
            ),
            array(
                'id'       => 'so_soroush',
                'type'     => 'switch',
                'title' => __('Soroush', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'so_soroush_link',
                'type'     => 'text',
                'title' => __('Link', 'dina-kala'),
                'default'  => '#',
                'required' => array( 'so_soroush', '=', true ),
            ),
            array(
                'id'       => 'so_gap',
                'type'     => 'switch',
                'title' => __('Gap', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'so_gap_link',
                'type'     => 'text',
                'title' => __('Link', 'dina-kala'),
                'default'  => '#',
                'required' => array( 'so_gap', '=', true ),
            ),
            array(
                'id'       => 'so_eitaa',
                'type'     => 'switch',
                'title' => __('Eitaa', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'so_eitaa_link',
                'type'     => 'text',
                'title' => __('Link', 'dina-kala'),
                'default'  => '#',
                'required' => array( 'so_eitaa', '=', true ),
            ),
            array(
                'id'       => 'so_bisphone',
                'type'     => 'switch',
                'title' => __('Bisphone', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'so_bisphone_link',
                'type'     => 'text',
                'title' => __('Link', 'dina-kala'),
                'default'  => '#',
                'required' => array( 'so_bisphone', '=', true ),
            ),
            array(
                'id'       => 'so_bale',
                'type'     => 'switch',
                'title' => __('Bale', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'so_bale_link',
                'type'     => 'text',
                'title' => __('Link', 'dina-kala'),
                'default'  => '#',
                'required' => array( 'so_bale', '=', true ),
            ),
            array(
                'id'       => 'so_igap',
                'type'     => 'switch',
                'title' => __('iGap', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'so_igap_link',
                'type'     => 'text',
                'title' => __('Link', 'dina-kala'),
                'default'  => '#',
                'required' => array( 'so_igap', '=', true ),
            ),
            array(
                'id'       => 'so_rubika',
                'type'     => 'switch',
                'title' => __('Rubika', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'so_rubika_link',
                'type'     => 'text',
                'title' => __('Link', 'dina-kala'),
                'default'  => '#',
                'required' => array( 'so_rubika', '=', true ),
            ),
            array(
                'id'       => 'so_hoorsa',
                'type'     => 'switch',
                'title' => __('Hoorsa', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'so_hoorsa_link',
                'type'     => 'text',
                'title' => __('Link', 'dina-kala'),
                'default'  => '#',
                'required' => array( 'so_hoorsa', '=', true ),
            ),
            array(
                'id'       => 'so_phone',
                'type'     => 'switch',
                'title' => __('Phone', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'so_phone_link',
                'type'     => 'text',
                'title' => __('Link', 'dina-kala'),
                'default'  => '#',
                'required' => array( 'so_phone', '=', true ),
            ),
            array(
                'id'       => 'so_mobile',
                'type'     => 'switch',
                'title' => __('Mobile', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'so_mobile_link',
                'type'     => 'text',
                'title' => __('Link', 'dina-kala'),
                'default'  => '#',
                'required' => array( 'so_mobile', '=', true ),
            ),
            array(
                'id'       => 'so_email',
                'type'     => 'switch',
                'title' => __('Email', 'dina-kala'),
                'default'  => false,
            ),
            array(
                'id'       => 'so_email_link',
                'type'     => 'text',
                'title' => __('Link', 'dina-kala'),
                'default'  => '#',
                'required' => array( 'so_email', '=', true ),
            ),
            array(
                'id' => 'social-links-section-end',
                'type' => 'section',
                'indent' => false ,
            ),
        ),
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __( 'Custom Codes', 'dina-kala' ),
        'id'         => 'menu_example',
        'desc'       => __( 'Custom Codes Settings', 'dina-kala' ),
        'icon'       => 'el el-css',
        'fields'     => array(
            array(
                'id'       => 'custom_css',
                'type'     => 'ace_editor',
                'title'    => __( 'Custom style sheet', 'dina-kala' ),
                'subtitle' => __( 'Add your custom stylesheets quickly to the template.', 'dina-kala' ),
                'mode'     => 'css',
                'theme'    => 'chrome'
            ),
            array(
                'id'       => 'header_codes',
                'type'     => 'ace_editor',
                'title'    => __( 'Header script', 'dina-kala' ),
                'subtitle' => __( 'Enter the codes you need to add to the header section of the template (like meta tags) here.', 'dina-kala' ),
                'mode'     => 'javascript',
                'theme'    => 'chrome'
            ),
            array(
                'id'       => 'footer_codes',
                'type'     => 'ace_editor',
                'title'    => __( 'Footer script', 'dina-kala' ),
                'subtitle' => __( 'Add the codes you need to add to the footer template (like Google Analytics) here.', 'dina-kala' ),
                'mode'     => 'javascript',
                'theme'    => 'chrome'
            ),
        ),
    ) );
    /*
     * <--- END SECTIONS
     */


    /*
     *
     * YOU MUST PREFIX THE FUNCTIONS BELOW AND ACTION FUNCTION CALLS OR ANY OTHER CONFIG MAY OVERRIDE YOUR CODE.
     *
     */

    /*
    *
    * --> Action hook examples
    *
    */

    // If Redux is running as a plugin, this will remove the demo notice and links
    //add_action( 'redux/loaded', 'remove_demo' );

    // Function to test the compiler hook and demo CSS output.
    // Above 10 is a priority, but 2 in necessary to include the dynamically generated CSS to be sent to the function.
    //add_filter('redux/options/' . $opt_name . '/compiler', 'compiler_action', 10, 3);

    // Change the arguments after they've been declared, but before the panel is created
    //add_filter('redux/options/' . $opt_name . '/args', 'change_arguments' );

    // Change the default value of a field after it's been set, but before it's been useds
    //add_filter('redux/options/' . $opt_name . '/defaults', 'change_defaults' );

    // Dynamically add a section. Can be also used to modify sections/fields
    //add_filter('redux/options/' . $opt_name . '/sections', 'dynamic_section');

    /**
     * This is a test function that will let you see when the compiler hook occurs.
     * It only runs if a field    set with compiler=>true is changed.
     * */
    if ( ! function_exists( 'compiler_action' ) ) {
        function compiler_action( $options, $css, $changed_values ) {
            echo '<h1>The compiler hook has run!</h1>';
            echo "<pre>";
            print_r( $changed_values ); // Values that have changed since the last save
            echo "</pre>";
            //print_r($options); //Option values
            //print_r($css); // Compiler selector CSS values  compiler => array( CSS SELECTORS )
        }
    }

    /**
     * Custom function for the callback validation referenced above
     * */
    if ( ! function_exists( 'redux_validate_callback_function' ) ) {
        function redux_validate_callback_function( $field, $value, $existing_value ) {
            $error   = false;
            $warning = false;

            //do your validation
            if ( $value == 1 ) {
                $error = true;
                $value = $existing_value;
            } elseif ( $value == 2 ) {
                $warning = true;
                $value   = $existing_value;
            }

            $return['value'] = $value;

            if ( $error == true ) {
                $field['msg']    = 'your custom error message';
                $return['error'] = $field;
            }

            if ( $warning == true ) {
                $field['msg']      = 'your custom warning message';
                $return['warning'] = $field;
            }

            return $return;
        }
    }

    /**
     * Custom function for the callback referenced above
     */
    if ( ! function_exists( 'redux_my_custom_field' ) ) {
        function redux_my_custom_field( $field, $value ) {
            print_r( $field );
            echo '<br/>';
            print_r( $value );
        }
    }

    /**
     * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
     * Simply include this function in the child themes functions.php file.
     * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
     * so you must use get_template_directory_uri() if you want to use any of the built in icons
     * */
    if ( ! function_exists( 'dynamic_section' ) ) {
        function dynamic_section( $sections ) {
            //$sections = array();
            $sections[] = array(
                'title'  => __( 'Section via hook', 'dina-kala' ),
                'desc'   => __( '<p class="description">This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.</p>', 'dina-kala' ),
                'icon'   => 'el el-paper-clip',
                // Leave this as a blank section, no options just some intro text set above.
                'fields' => array()
            );

            return $sections;
        }
    }

    /**
     * Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
     * */
    if ( ! function_exists( 'change_arguments' ) ) {
        function change_arguments( $args ) {
            //$args['dev_mode'] = false;

            return $args;
        }
    }

    /**
     * Filter hook for filtering the default value of any given field. Very useful in development mode.
     * */
    if ( ! function_exists( 'change_defaults' ) ) {
        function change_defaults( $defaults ) {
            $defaults['str_replace'] = 'Testing filter hook!';

            return $defaults;
        }
    }

    /**
     * Removes the demo link and the notice of integrated demo from the redux-framework plugin
     */
    if ( ! function_exists( 'remove_demo' ) ) {
        function remove_demo() {
            // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
            if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
                remove_filter( 'plugin_row_meta', array(
                    ReduxFrameworkPlugin::instance(),
                    'plugin_metalinks'
                ), null, 2 );

                // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
                remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
            }
        }
    }

function removeDemoModeLink() { // Be sure to rename this function to something more unique
    if ( class_exists('ReduxFrameworkPlugin') ) {
        remove_filter( 'plugin_row_meta', array( ReduxFrameworkPlugin::get_instance(), 'plugin_metalinks'), null, 2 );
    }
    if ( class_exists('ReduxFrameworkPlugin') ) {
        remove_action('admin_notices', array( ReduxFrameworkPlugin::get_instance(), 'admin_notices' ) );    
    }
}
add_action('init', 'removeDemoModeLink');