<?php 
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Demo Website: Dina.Elmfile.ir
Author Website: Hosseinkhani.ir
*/

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

//Theme's Languages
function dina_localisation(){
    function dina_localised( $locale ) {
        if ( isset( $_GET['l'] ) ) {
            return sanitize_key( $_GET['l'] );
        }
        return $locale;
    }
    add_filter( 'locale', 'dina_localised' );
    load_theme_textdomain( 'dina-kala', get_template_directory() . '/languages' );
}
add_action( 'after_setup_theme', 'dina_localisation' );

//Theme's constants
define ( 'DI_URI', get_template_directory_uri() );
define ( 'DI_DIR', get_template_directory() );

//Theme version
if ( ! defined( 'DI_VER' ) ) {
	define( 'DI_VER', '4.5.1' );
}

//Incluse Theme Files
if ( ! class_exists( 'ReduxFramework' ) && file_exists( dirname( __FILE__ ) . '/includes/ReduxCore/framework.php' ) ) {
    require_once( dirname( __FILE__ ) . '/includes/ReduxCore/framework.php' );
}
if ( ! isset( $redux_demo ) && file_exists( dirname( __FILE__ ) . '/includes/admin-panel-config.php' ) ) {
    require_once( dirname( __FILE__ ) . '/includes/admin-panel-config.php' );
}

Redux::init('di_data');

require_once DI_DIR . '/plugins/plugin.php';
require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
require_once DI_DIR . '/includes/meta-box.php';
require_once DI_DIR . '/includes/ajax-login.php';
require_once DI_DIR . '/includes/recaptchalib.php';
require_once DI_DIR . '/includes/dynamic_style.php';
require_once DI_DIR . '/includes/d-sidebar.php';
require_once DI_DIR . '/includes/thumbnail-upscale.php';
if ( class_exists( 'WooCommerce' ) ) {
    require_once DI_DIR . '/includes/woo.php';
}
require_once DI_DIR . '/includes/header-codes.php';
require_once DI_DIR . '/includes/footer-codes.php';
require_once DI_DIR . '/includes/menu-icon.php';
require_once DI_DIR . '/includes/mmenu_walker.php';
require_once DI_DIR . '/includes/views.php';
require_once DI_DIR . '/includes/fa-cheets.php';
if( class_exists( 'WooCommerce' ) && class_exists( 'WeDevs_Dokan' ) ) {
require_once DI_DIR . '/includes/dokan.php';
}
if( ! function_exists('yoast_breadcrumb') && ! class_exists('RankMath') ) {
require_once DI_DIR . '/includes/visual-term-description-editor/visual-term-description-editor.php';
}
//Widgets
require_once DI_DIR . '/includes/widgets/simple-link-list-widget/simple-link-list-widget.php';
require_once DI_DIR . '/includes/widgets/dina-logo-slider.php';
require_once DI_DIR . '/includes/widgets/image-banner.php';
require_once DI_DIR . '/includes/widgets/logo-namad.php';
require_once DI_DIR . '/includes/widgets/epay.php';
if ( class_exists( 'WooCommerce' ) ) {
    //require_once DI_DIR . '/includes/widgets/category-filter.php';
    require_once DI_DIR . '/includes/widgets/products.php';
    require_once DI_DIR . '/includes/widgets/stock-status.php';
    if( $di_data['ajax_add'] && get_option( 'woocommerce_enable_ajax_add_to_cart' ) === 'yes' && get_option( 'woocommerce_cart_redirect_after_add' ) === 'no') {
        require_once DI_DIR . '/includes/ajax-add.php';
    }
    if( $di_data['stock_order'] ) {
        require_once DI_DIR . '/includes/order-class.php';
    }
    if( $di_data['product_brand'] ) {
        require_once DI_DIR . '/includes/widgets/brand-filter.php';
        require_once DI_DIR . '/includes/brand.php';
    }
    if( $di_data['search_by_sku'] ) {
        require_once DI_DIR . '/includes/sku-search.php';
    }
}
require_once DI_DIR . '/includes/widgets/posts.php';
require_once DI_DIR . '/includes/widgets/fnews.php';

//Register Elementor Widgets
if ( did_action( 'elementor/loaded' ) ) {
require_once DI_DIR . '/includes/elementor.php';
}
if( $di_data['mega_style'] == 'second') {
require_once DI_DIR . '/includes/yamm-s.php';
} else {
require_once DI_DIR . '/includes/yamm.php';
}
if( $di_data['ajax_search'] ) {
require_once DI_DIR . '/includes/searchwp-live-ajax-search/searchwp-live-ajax-search.php';
}

require_once DI_DIR . '/includes/dina-demos.php';


//Register Theme's styles
add_action('wp_enqueue_scripts','dina_styles');
function dina_styles() {
    global $di_data;
    $dina_bootstrap_style = ( is_rtl() ? 'bootstrap-rtl.min.css' : 'bootstrap.min.css' );
    
    wp_register_style('dina-boot-rtl', DI_URI . '/css/' . $dina_bootstrap_style, array(), DI_VER);
    wp_enqueue_style('dina-boot-rtl');

    wp_register_style('dina-awe', DI_URI . '/css/fontawesome.min.css', array(), DI_VER);
    wp_enqueue_style('dina-awe');

    wp_register_style('dina-style', DI_URI . '/style.css', array() , DI_VER);
    wp_enqueue_style('dina-style');

    if ( ! $di_data['custom_font'] ) {
        wp_register_style('dina-font', DI_URI . '/css/'.$di_data['theme_font'].'.css', array() , DI_VER);
        wp_enqueue_style('dina-font');
    }
    
    if( $di_data['full_width_style'] ) {
        wp_register_style('dina-full', DI_URI . '/css/full-width.css', array() , DI_VER);
        wp_enqueue_style('dina-full');
    }
    if( class_exists( 'WeDevs_Dokan' ) ) {
        wp_register_style('dina-dokan', DI_URI . '/css/dokan.css', array(), DI_VER);
        wp_enqueue_style('dina-dokan');
    }
    if ( !is_rtl() ) {
        wp_register_style('dina-style-ltr', DI_URI . '/css/ltr.css', array(), DI_VER);
        wp_enqueue_style('dina-style-ltr');
    }
    /*
    if ( $di_data['dina_dark_mode'] ) {
        wp_register_style('dina-style-dark', DI_URI . '/css/dina-dark.css', array(), DI_VER);
        wp_enqueue_style('dina-style-dark');
    }
    */
}

//Register Theme's Scripts
add_action('init', 'dina_scripts');
function dina_scripts() {
if ( is_admin() ) return;
    wp_enqueue_script('dina-js-boot', DI_URI . '/js/bootstrap.min.js', array('jquery'), DI_VER, true);
    wp_enqueue_script('dina-js-main', DI_URI . '/js/main.js', array('jquery'), DI_VER, true);
}

add_action( 'wp_footer', 'dina_vcrtl_conflict', 11 );
function dina_vcrtl_conflict() { 
    if ( defined('WPB_VC_VERSION') && is_singular('product') ) {
        wp_deregister_script( 'flexslider' );
        wp_enqueue_script('flexslider', DI_URI . '/js/jquery.flexslider.min.js', array('jquery'), DI_VER, true);
    }
}

//Add Admin Scripts
add_action( 'admin_enqueue_scripts', 'dina_upload_script' );
function dina_upload_script() {
    wp_enqueue_media();
    wp_enqueue_script( 'ads_script', DI_URI . '/js/upload-media.js', false, DI_VER, true );
}

// Add Theme Support
add_action('after_setup_theme','dina_support');
function dina_support() {
    global $di_data;
    add_theme_support('title-tag');
    add_theme_support( 'html5', array( 'comment-list', 'comment-form', 'search-form', 'gallery', 'caption', 'style', 'script' ) );
    add_theme_support('automatic-feed-links');
    add_theme_support( 'woocommerce' );
    add_theme_support( 'wc-product-gallery-zoom' );
    add_theme_support( 'wc-product-gallery-lightbox' );
    add_theme_support( 'wc-product-gallery-slider' );
    add_theme_support( 'rank-math-breadcrumbs' );
    add_theme_support('post-thumbnails');
    if ( $di_data['custom_post_thumb'] ) {
        $width = $di_data['post_thumb_width'];
        $height = $di_data['post_thumb_height'];
        add_image_size('dpost_thumbnail', $width, $height, true);
    }
}

//Rregister navigation menu
register_nav_menus( array(
    'mega_menu'   => __( 'Mega Menu', 'dina-kala' ),
    'header' => __( 'Header Menu', 'dina-kala' ),
) );

if ( $di_data['replace_user_menu'] ) {
    register_nav_menus( array(
        'user_menu'   => __( 'User Menu', 'dina-kala' ),
    ) );
}

if ( $di_data['replace_mobile_menu'] ) {
    register_nav_menus( array(
        'mobile_menu'   => __( 'Mobile Menu', 'dina-kala' ),
    ) );
}

//Redux Menu
if ( ! function_exists ('remove_redux_menu') ) {
    add_action('admin_menu', 'remove_redux_menu', 12);
    function remove_redux_menu()
    {
        remove_submenu_page('tools.php', 'redux-about');
    }
}

//Redux Styles
add_action( 'admin_enqueue_scripts', 'redux_custom_styles' );
function redux_custom_styles( $page ) {
    wp_enqueue_style( 'redux-custom-style', DI_URI .'/includes/redux.css' );
}

//Fontawesome admin icons
add_action('admin_init', 'fa_dashboard');
function fa_dashboard()
{
    wp_enqueue_style('fa_di_admin', DI_URI . '/css/fontawesome.min.css');
    wp_enqueue_style('irico_di_admin', DI_URI . '/css/ir-icons.css');
}

//Widget tag's number
add_filter( 'widget_tag_cloud_args', 'dina_tag_cloud_limit' );
function dina_tag_cloud_limit($args){ 
    global $di_data;
    // Check if taxonomy option of the widget is set to tags
    if ( isset($args['taxonomy'] ) ) {
        $args['number'] = $di_data['tag_number']; // Number of tags to show
        }
    return $args;
}

//Loads admin-side menu-icon scripts and styles
add_action('admin_enqueue_scripts', 'admin_menu_icon_styles');
function admin_menu_icon_styles($page)
{
if ( $page == 'nav-menus.php')
    {
    wp_enqueue_style('select2', DI_URI . '/includes/select2.min.css');
    wp_enqueue_style('menu-icon-admin-style', DI_URI . '/includes/menu-icon-admin.css');
    wp_enqueue_script('my_s2', DI_URI . '/includes/select2.min.js');
    wp_enqueue_script('my_s1', DI_URI . '/includes/select2.js');
    }
}

//Pagination
function wp_pagination()
{
global $wp_query;
$big = 999999999;
$page_format = paginate_links(array(
    'base' => str_replace($big, '%#%', esc_url(get_pagenum_link($big) )) ,
    'format' => '?paged=%#%',
    'current' => max(1, get_query_var('paged') ) ,
    'total' => $wp_query->max_num_pages,
    'prev_text' => __('<i class="fal fa-chevron-right" aria-hidden="true" title="Next"></i>') ,
    'next_text' => __('<i class="fal fa-chevron-left" aria-hidden="true" title="Prev"></i>') ,
    'type' => 
    'array'
) );
if (is_array($page_format) )
    {
    $paged = (get_query_var('paged') == 0) ? 1 : get_query_var('paged');
    echo '<div class="col-12 pagination"><ul>';
    foreach($page_format as $page)
        {
        echo "<li>$page</li>";
        }
    echo '</ul></div>';
    }
}

function p_img() { 
   if ( has_post_thumbnail() ) {
        the_post_thumbnail('woocommerce_thumbnail');
    } else {
        prod_defualt_thumb();
    }
}

function pr_img() { 
    global $di_data;
    echo '<div class="img-con">';
    if ( has_post_thumbnail() ) {
         the_post_thumbnail('woocommerce_thumbnail');
    } else { 
        prod_defualt_thumb();
    }
    if( $di_data['show_sec_img'] ) {
        global $product;
        $attachment_ids = $product->get_gallery_image_ids();
        if ( is_array( $attachment_ids ) && !empty($attachment_ids) ) {
            $first_image_url = wp_get_attachment_image_src($attachment_ids[0], 'woocommerce_thumbnail');
            echo '<img width="'.$first_image_url[1].'" height="'.$first_image_url[2].'" src="'.$first_image_url[0].'" alt="'.get_the_title().'" class="second-img wp-post-image">';
        }
    }
    echo '</div>';
 }

function po_img(){ 
    global $di_data;
    echo '<div class="img-con">';
    if ( has_post_thumbnail() ) {
        if( $di_data['custom_post_thumb'] ) {
            the_post_thumbnail('dpost_thumbnail');
        } else {
            the_post_thumbnail('woocommerce_thumbnail');
        }
    } else { 
        prod_defualt_thumb();
    }
    if( $di_data['show_post_pub'] ) {
        echo '<span class="post-pub">';
            echo get_jdate_publish_time();
        echo '</span>';
    }
    echo '</div>';
}

//Product Defualt Thumb Image
function prod_defualt_thumb() {
    global $di_data;
    $thumb_width = (!empty($di_data['prod_defualt_thumb']['width'] ) ) ? $di_data['prod_defualt_thumb']['width'] : '150';
    $thumb_height = (!empty($di_data['prod_defualt_thumb']['height'] ) ) ? $di_data['prod_defualt_thumb']['height'] : '150';
    echo '<img src="'. dina_to_https( $di_data['prod_defualt_thumb']['url'] ) .'" width="'. $thumb_width .'" height="'. $thumb_height .'" alt="'.the_title_attribute('echo=0').'" class="post-thumb">';
}

function remove_admin_bar() {
global $di_data;
if ((current_user_can('administrator') || current_user_can('shop_manager') ) && $di_data['show_abar_admin'] ) {
    add_filter('show_admin_bar', '__return_true');
} else {
    add_filter('show_admin_bar', '__return_false');
}
}
if ( $di_data['show_abar'] )
	{ 
	add_action('after_setup_theme', 'remove_admin_bar');
}

/**
* Updating the subscriber role
*/
$subscriber_role = get_role( 'subscriber' );
if($subscriber_role){
// Adding a new capability to role
$subscriber_role->add_cap( 'view_ticket' );
$subscriber_role->add_cap( 'create_ticket' );
$subscriber_role->add_cap( 'close_ticket' );
$subscriber_role->add_cap( 'reply_ticket' );
$subscriber_role->add_cap( 'attach_files' );
}

$customer_role = get_role( 'customer' );
if($customer_role){
// Adding a new capability to role
$customer_role->add_cap( 'view_ticket' );
$customer_role->add_cap( 'create_ticket' );
$customer_role->add_cap( 'close_ticket' );
$customer_role->add_cap( 'reply_ticket' );
$customer_role->add_cap( 'attach_files' );
}

$seller_role = get_role( 'seller' );
if($seller_role){
// Adding a new capability to role
$seller_role->add_cap( 'view_ticket' );
$seller_role->add_cap( 'create_ticket' );
$seller_role->add_cap( 'close_ticket' );
$seller_role->add_cap( 'reply_ticket' );
$seller_role->add_cap( 'attach_files' );
}

if( class_exists( 'Awesome_Support' ) ) { 
add_filter( 'page_template', 'ticket_page_template' );
function ticket_page_template( $page_template ) {
        global $post;
        if( !is_object($post) ) 
        return;
        $ticket_id = wpas_get_option( 'ticket_list' );
        $ticket_submit_id = wpas_get_option( 'ticket_submit' );
        if(is_array($ticket_submit_id) ){
            $ticket_submit = $ticket_submit_id[0];
        }
        else{
            $ticket_submit = $ticket_submit_id;
        }
        $post_id = $post->ID;
        if( ($post_id === (int)$ticket_id) || ($post_id === (int)$ticket_submit) ) {
                $page_template = get_stylesheet_directory() . '/tickets.php'; 
        } 
    return $page_template;
}
}

if( class_exists( 'Affiliate_WP' ) ) { 
add_filter( 'page_template', 'affiliate_page_template' );
function affiliate_page_template( $page_template ) {
        global $post;
        if( !is_object($post) ) 
        return;
        $post_id = $post->ID;
        if($post_id === affwp_get_affiliate_area_page_id() ) {
                $page_template = get_stylesheet_directory() . '/affiliate-area.php'; 
        } 
    return $page_template;
}
}

add_filter( 'comment_form_fields', 'wpb_move_comment_field_to_bottom');
function wpb_move_comment_field_to_bottom( $fields ) {
$comment_field = $fields['comment'];
unset( $fields['comment'] );
$fields['comment'] = $comment_field;
return $fields;
}

function get_post_primary_category($post_id, $term='category', $return_all_categories=false){
    $return = array();

    if (class_exists('WPSEO_Primary_Term') ){
        // Show Primary category by Yoast if it is enabled & set
        $wpseo_primary_term = new WPSEO_Primary_Term( $term, $post_id );
        $primary_term = get_term($wpseo_primary_term->get_primary_term() );

        if (!is_wp_error($primary_term) ){
            $return['primary_category'] = $primary_term;
        }
    }

    if (empty($return['primary_category'] ) || $return_all_categories) {
        $categories_list = get_the_terms($post_id, $term);

        if (empty($return['primary_category'] ) && !empty($categories_list) ){
            $return['primary_category'] = $categories_list[0];  //get the first category
        }
        if ( $return_all_categories){
            $return['all_categories'] = array();

            if (!empty($categories_list) ){
                foreach($categories_list as &$category){
                    $return['all_categories'][] = $category->term_id;
                }
            }
        }
    }
    return $return;
}

function get_jdate_publish_time(){
	$greg_date = get_post_time('j F Y');
    $timestamp = strtotime($greg_date);
    if (defined('PW_VERSION') && PW_VERSION >= '4.0.0') {
        echo get_the_date('j F Y');
    } elseif ( function_exists('jdate') ) {
		echo jdate('j F Y',$timestamp);
	} elseif( function_exists('parsidate') ) {
        echo parsidate('j F Y',$timestamp);
    } elseif( function_exists('wpp_jdate') ) {
        echo wpp_jdate('j F Y',$timestamp);
    } elseif( function_exists('wp_date') ) {
        echo wp_date('j F Y',$timestamp);
    } else {
		echo $greg_date;
	}
}



//Check site direction is RTL
function dina_rtl() {
    if ( is_rtl() ) {
        return 'true';
    } else {
        return 'false';
    }
}

//dina_custom_excerpt_length
add_filter( 'excerpt_length', 'dina_custom_excerpt_length', 999 );
function dina_custom_excerpt_length( $length ) {
    return 20;
}

//dina_remove_brackets_excerpt
function dina_custom_excerpt_more( $excerpt ) {
    return ' ...';
}
add_filter( 'excerpt_more', 'dina_custom_excerpt_more' );

//Dina remove dashes
function dina_remove_dash($input) {
    $output = preg_replace("/[^A-Za-z0-9]/", "", $input);
    return $output;
}

//Dina Header Banner
function dina_header_banner() {
    global $di_data;
    if ( !empty( dina_to_https ( $di_data['head_banner']['url'] ) ) ) { ?>

    <div class="row head-banner-row<?php if (!$di_data['show_head_mobile'] ) { echo ' mobile-hidden'; }?>">
        <div class="col-12 bnr-image shadow-box">
            <a href="<?php echo $di_data['head_banner_link']; ?>" title="<?php echo $di_data['head_banner_title']; ?>" aria-label="<?php echo $di_data['head_banner_title']; ?>">
                <?php
                    $headb_width = (!empty($di_data['head_banner']['width'] ) ) ? $di_data['head_banner']['width'] : '1260';
                    $headb_height = (!empty($di_data['head_banner']['height'] ) ) ? $di_data['head_banner']['height'] : '142'; 
                ?>
                <img src="<?php echo dina_to_https( $di_data['head_banner']['url'] ); ?>" alt="<?php echo $di_data['head_banner_title']; ?>" class="head-banner shadow-box" width="<?php echo $headb_width; ?>" height="<?php echo $headb_height; ?>" />
            </a>
        </div>
    </div>

<?php 
    }
}

//Run Shortcodes in the_excerpt
add_filter( 'the_excerpt', 'shortcode_unautop');
add_filter( 'the_excerpt', 'do_shortcode');

/* Convert hexdec color string to rgb(a) string */
function hex2rgba( $hex, $alpha = '' ) {
    $hex = str_replace( "#", "", $hex );
    if ( strlen( $hex ) == 3 ) {
        $r = hexdec( substr( $hex, 0, 1 ) . substr( $hex, 0, 1 ) );
        $g = hexdec( substr( $hex, 1, 1 ) . substr( $hex, 1, 1 ) );
        $b = hexdec( substr( $hex, 2, 1 ) . substr( $hex, 2, 1 ) );
    } else {
        $r = hexdec( substr( $hex, 0, 2 ) );
        $g = hexdec( substr( $hex, 2, 2 ) );
        $b = hexdec( substr( $hex, 4, 2 ) );
    }
    $rgb = $r . ',' . $g . ',' . $b;

    if ( '' == $alpha ) {
        return $rgb;
    } else {
        $alpha = floatval( $alpha );

        return 'rgba(' . $rgb . ',' . $alpha . ')';
    }
}

//Add Body Classes
add_filter( 'body_class', 'dina_body_class' );
function dina_body_class( $classes ) {
    global $di_data;
    //Add body class for dark mode
    //$classes[] = ( $di_data['dina_dark_mode'] ? 'dina-dark' : '' );
    //Add body class for mobile bar
    $classes[] = ( $di_data['hide_mobile_bar'] ? 'no-bbar' : '' );
    //Add body class for category widget
    $classes[] = ( $di_data['open_cat_widget'] ? 'dina-open-cat' : '' );
 
    return $classes;
}

//Get YITH Wishlist product's count
if ( defined( 'YITH_WCWL' ) && ! function_exists( 'yith_wcwl_get_items_count' ) ) {
    function yith_wcwl_get_items_count() {
      ob_start();
        echo esc_html( yith_wcwl_count_all_products() );
      return ob_get_clean();
    }
  
    add_shortcode( 'yith_wcwl_items_count', 'yith_wcwl_get_items_count' );
  }
  
  if ( defined( 'YITH_WCWL' ) && ! function_exists( 'yith_wcwl_ajax_update_count' ) ) {
    function yith_wcwl_ajax_update_count() {
      wp_send_json( array(
        'count' => yith_wcwl_count_all_products()
      ) );
    }
  
    add_action( 'wp_ajax_yith_wcwl_update_wishlist_count', 'yith_wcwl_ajax_update_count' );
    add_action( 'wp_ajax_nopriv_yith_wcwl_update_wishlist_count', 'yith_wcwl_ajax_update_count' );
  }
  
  if ( defined( 'YITH_WCWL' ) && ! function_exists( 'yith_wcwl_enqueue_custom_script' ) ) {
    function yith_wcwl_enqueue_custom_script() {
      wp_add_inline_script(
        'jquery-yith-wcwl',
        "
          jQuery( function( $ ) {
            $( document ).on( 'added_to_wishlist removed_from_wishlist', function() {
              $.get( yith_wcwl_l10n.ajax_url, {
                action: 'yith_wcwl_update_wishlist_count'
              }, function( data ) {
                $('.dina-yith-wcwl-btn .wish-amount').html( data.count );
              } );
            } );
          } );
        "
      );
    }
  
    add_action( 'wp_enqueue_scripts', 'yith_wcwl_enqueue_custom_script', 20 );
}

//Dina Download Box
function dina_dl_box($post_id) {
    global $di_data;

    $dlbox_title = get_post_meta( $post_id, 'dina_dlbox_title', true );
    $dlbox_size = get_post_meta( $post_id, 'dina_dlbox_size', true );
    $dlbox_pass = get_post_meta( $post_id, 'dina_dlbox_pass', true );
    $dlbox_files = get_post_meta( $post_id, 'dina_dlbox_files', true );

    ob_start();
    ?>

    <div class="dlbox">
        <div class="dltitle">
            <i class="fal fa-cloud-download"></i><?php echo $dlbox_title; ?>
        </div>

        <?php if( !is_user_logged_in() && $di_data['dl_box_login'] ) {
            if (function_exists('digits_version') && $di_data['digits_mode'] ) {
                $digits_mode = ( $di_data['digits_page'] ? 'digitsbtn digitlink' : 'digitsbtn digitpopup' );
                $login_msg = '<span class="dina-dl-login-links '. $digits_mode .'">'.__('Login to view links.', 'dina-kala').'</span>';
            } elseif( $di_data['merge_user_btn'] ) {
                $login_link = ( $di_data['ch_login_link'] ? 'href="'. $di_data['login_link'] .'"' : 'href="'. esc_url( dina_myaccount_link() ) .'"' );
                $login_msg = '<a title="'. __('Login Or Register', 'dina-kala') .'" class="login-price-link" '. $login_link .'>';
                $login_msg .= '<span class="dina-dl-login-links">'.__('Login to view links.', 'dina-kala').'</span>';
                $login_msg .= '</a>';
            } else {
                $login_link = ( $di_data['ch_login_link'] ? 'href="'. $di_data['login_link'] .'"' : 'href="javascript:void(0)" onclick="openLogin()"' );
                $login_msg = '<a title="'. __('Login Or Register', 'dina-kala') .'" class="login-price-link" '. $login_link .'>';
                $login_msg .= '<span class="dina-dl-login-links">'.__('Login to view links.', 'dina-kala').'</span>';
                $login_msg .= '</a>';
            }
            echo '<div class="dlbox-links">';
            echo $login_msg;
            echo '</div>';

         } else { ?>

        <div class="dlbox-links">
            <?php 
            if ( !empty( $dlbox_files ) ) {
                foreach ( (array) $dlbox_files as $key => $file ) {
                    if (isset( $file['dina_dlbox_subtitle'] ) && $file['dina_dlbox_subtitle'] ) {
                        $file_name = esc_html($file['dina_dlbox_file'] );
                        if(!empty($file_name) ) {
                            echo '<div class="plain">'.$file_name.'</div>';
                        }
                    } else {
                        $file_name = esc_html($file['dina_dlbox_file'] );
                        $file_link = esc_html($file['dina_dlbox_link'] ); 
                        if(!empty($file_name) && !empty($file_link) ) {
                            echo '<a href="'.$file_link.'" title="'.$file_name.'" class="flink"><i class="fal fa-download"></i>'.$file_name.'</a>';
                        }
                    }
                }
            } ?>
        </div>

        <?php } ?>

        <div class="row fdet">

            <?php if( !empty($dlbox_size) ) { ?>
            <div class="col-md-4 sdet">
                <i class="fal fa-save"></i>
                <span aria-hidden="true">
                    <?php _e('File size:', 'dina-kala'); ?>
                    <?php echo $dlbox_size; ?>
                </span>
            </div>
            <?php } ?>

            <?php if( !empty($dlbox_pass) ) { ?>
            <div class="col-md-4 sdet">
                <i class="fal fa-lock"></i>
                <span aria-hidden="true">
                <?php _e('Password:', 'dina-kala'); ?>
                <?php echo $dlbox_pass; ?>
                </span>
            </div>
            <?php } ?>

            <?php if( !empty($di_data['dl_guide_text'] ) ) { ?>
            <div class="col-md-4 sdet">
                <span class="dhelp" data-toggle="modal" data-target="#dhelp">
                    <i class="fal fa-question-circle"></i>
                    <span aria-hidden="true">
                        <?php _e('Download guide', 'dina-kala'); ?>
                    </span>
                </span>
            </div>
            <?php } ?>

        </div>

        <?php if( !empty($di_data['dl_guide_text'] ) ) { ?>
        <!-- Dl-Box Help Modal -->
        <div class="modal fade dhelp-modal" id="dhelp">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">
                    <i class="fal fa-question-circle"></i>
                    <?php echo $di_data['dl_guide_title']; ?>
                </h4>
                <button type="button" class="close" data-dismiss="modal">
                    <i class="fal fa-times" aria-hidden="true"></i>
                </button>
            </div>
            <div class="modal-body">
                <?php echo $di_data['dl_guide_text']; ?>
            </div>
            </div>
        </div>
        </div>
        <!-- Dl-Box Help Modal -->
        <?php } ?>

    </div>
<?php 
    $dl_box = ob_get_clean();
    return $dl_box;
}

//Check is Elementor Edit mode
function di_elementor_edit_mode() {
    $elementor_edit_mode = false;
    if (did_action( 'elementor/loaded' ) ) {
        if ( ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) || ( \Elementor\Plugin::$instance->preview->is_preview_mode() ) ) {
            $elementor_edit_mode = true;
        }
    }
    return $elementor_edit_mode;
}

//DinaKala Search form
function di_search_form( $class, $ajax ){
    global $di_data;
?>
    <form class="<?php echo $class; ?>" id="head-search" role="search" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
        <?php if( ! $di_data['search_others'] ) { ?>
            <input type="hidden" name="post_type" value="product" />
        <?php } ?>
        <div class="input-group search-form">
            <?php 

            if ( $di_data['search_cat'] ) {
                $args = array (
                    'taxonomy'    => 'product_cat',
                    'hide_empty'  => true,
                );

                if ( $di_data['search_cat_sort'] ) {
                    $args['orderby'] = 'name';
                    $args['order'] = 'ASC';
                }

                if ( $di_data['search_cat_parent'] ) {
                    $args['parent'] = 0;
                }

                if ( ! empty ( $di_data['search_cat_cats'] ) ) {
                    $args['exclude'] = $di_data['search_cat_cats'];
                }

                $categories = get_terms( $args );

            if ( ! empty( $categories ) && !is_wp_error( $categories ) ) {
                ?>
                <div class="input-group-before prod-cat">
                    <?php echo '<select name="product_cat" >';
                    echo '<option value="">'.__("Category",'dina-kala').'</option>';
                    foreach ( $categories as $category ) {
                    echo '<option value="'.$category->slug.'">'.$category->name.'</option>';
                    }
                    echo '</select>'; ?>
                </div>
            <?php } 
            } ?>

            <input autocomplete="off"<?php if( $ajax ) { echo ' data-swplive="true"'; } ?> name="s" type="text" class="form-control search-input" placeholder="<?php _e('Search Products...', 'dina-kala'); ?>" aria-label="<?php _e("Search", 'dina-kala'); ?>" required>
            <div class="input-group-append">
                <button class="btn btn-search" type="submit" aria-label="<?php _e("Search", 'dina-kala'); ?>">
                    <i class="fal fa-search" aria-hidden="true"></i>
                </button>
            </div>
        </div>
    </form>
<?php
}

//Change wordpress login logo
if ( $di_data['login_logo_switch'] ) {
    add_action( 'login_head', 'dina_login_logo' );
}
function dina_login_logo() {
    global $di_data;
    echo '<style type="text/css">
    h1 a {background-image: url( '. dina_to_https( $di_data['site_logo_retina']['url'] ) .' ) !important;
    width: 320px!important;
    height: 114px!important;
    background-size: contain!important;
    margin-bottom: 0px!important;
    }
    </style>';
}

//Change wordpress login logo link
add_filter( 'login_headerurl', 'dina_login_headerurl', 10, 2 );
function dina_login_headerurl() {
    return esc_url( home_url() );
}
    

//Remove wallet checkout styles
add_action( 'wp_enqueue_scripts', 'remove_wallet_stylesheet' );
function remove_wallet_stylesheet() {
    if ( ! class_exists( 'WooCommerce' ) ) 
        return;
    if( is_checkout() ) {
        wp_deregister_script('jquery-ui-tooltip');
        wp_dequeue_script('jquery-ui-tooltip');
    }
}

//dina_adjustBrightness
if( ! function_exists( 'dina_adjustBrightness' ) ) {
    function dina_adjustBrightness( $hexCode, $adjustPercent ) {
        $hexCode = ltrim( $hexCode, '#' );
    
        if ( strlen( $hexCode ) == 3 ) {
            $hexCode = $hexCode[0] . $hexCode[0] . $hexCode[1] . $hexCode[1] . $hexCode[2] . $hexCode[2];
        }
    
        $hexCode = array_map( 'hexdec', str_split( $hexCode, 2 ) );
    
        foreach ( $hexCode as & $color ) {
            $adjustableLimit = $adjustPercent < 0 ? $color : 255 - $color;
            $adjustAmount = ceil( $adjustableLimit * $adjustPercent );
    
            $color = str_pad( dechex( $color + $adjustAmount ), 2, '0', STR_PAD_LEFT );
        }
    
        return '#' . implode( $hexCode );
    }
}

//Dina Replace Http to Https
function dina_to_https( $url ){
    if( is_ssl() ){
        $url = str_replace( "http://", "https://", $url );
    }
    return $url;
}

//Dina filter comment fields
add_filter( 'comment_form_default_fields', 'dina_comments_fields' );
function dina_comments_fields( $fields ) {
    global $di_data;
    if( isset( $fields['url'] ) && $di_data['comment_remove_url'] )
        unset( $fields['url'] );
    if( isset( $fields['email'] ) && $di_data['comment_remove_email'] )
        unset( $fields['email'] );
    return $fields;
}

//Remove Cookie filed from comment form
if ( $di_data['comment_remove_cookie'] ) {
    remove_action( 'set_comment_cookies', 'wp_set_comment_cookies' );
}

//Remove Woo_Variation_Swatches actions
if ( ! class_exists( 'Woo_Variation_Swatches_Pro' ) ) {
	remove_filter( 'woocommerce_product_data_tabs', 'add_wvs_pro_preview_tab' );
	remove_filter( 'woocommerce_product_data_panels', 'add_wvs_pro_preview_tab_panel' );
}
if ( class_exists( 'Woo_Variation_Swatches' ) ) {
    remove_filter( 'pre_update_option_woocommerce_thumbnail_image_width', 'wvs_clear_transient' );
    remove_filter( 'pre_update_option_woocommerce_thumbnail_cropping', 'wvs_clear_transient' );
}

//Dina archive description
function dina_archive_description() {
    global $di_data;
    if ( is_search() ) { 
        return;
    } 
    if ( class_exists('WooCommerce') && is_shop() ) { 
        return;
    } 
    $cat_full = ( ! $di_data['show_full_text_cat'] ? ' class="cat-text dina-more-less" data-more="'. __('Show More', 'dina-kala') .'" data-less="'. __('Show Less', 'dina-kala') .'"' : '');
    the_archive_description('<div class="shadow-box cat-desc col-12">
    <div'. $cat_full .'>','</div>
    </div>');
}

//Get Woocomemrce MyAccount Link
function dina_myaccount_link() {

    $myaccount_page_url = '';

    if( class_exists( 'WooCommerce' ) ) {
        $myaccount_page_url = '';
        $myaccount_page = (int)get_option('woocommerce_myaccount_page_id' );

        if ( $myaccount_page ) {
            $myaccount_page_url = get_permalink( $myaccount_page );
        }
    } else {
        $myaccount_page_url = "#";
    }

    return $myaccount_page_url;
}

//Dina Check Sidebar
function dina_check_side(){
    global $di_data;
    $post_id = get_the_ID();
    $side = 0;
    $pside = get_post_meta( $post_id, 'dina_pside', true );
    $postside = get_post_meta( $post_id, 'dina_postside', true );
    $pageside = get_post_meta( $post_id, 'dina_pageside', true );
    $ticket_page = 0;
    $aff_page = 0;
    $dokan_page = 0;
    if( class_exists( 'WooCommerce' ) && class_exists( 'WeDevs_Dokan' ) ){
        if( $post_id === dokan_get_option( 'dashboard', 'dokan_pages' ) ) {
            $dokan_page = 1;
        } 
    }
    if( class_exists( 'Awesome_Support' ) ) { 
        $ticket_id = wpas_get_option( 'ticket_list' );
        $ticket_submit_id = wpas_get_option( 'ticket_submit' );
        if(is_array($ticket_submit_id) ){
            $ticket_submit = $ticket_submit_id[0];
        }
        else{
            $ticket_submit = $ticket_submit_id;
        }
        if( ($post_id === (int)$ticket_id) || ($post_id === (int)$ticket_submit) ) {
            $ticket_page = 1; 
        } 
    }
    if( class_exists( 'Affiliate_WP' ) ) {
        if( $post_id === affwp_get_affiliate_area_page_id() ) {
            $aff_page = 1;
        }
    }

    if( ( class_exists( 'WooCommerce' ) && is_woocommerce() && is_archive() ) && $di_data['product_archive_side'] != 0 ) {
        $side = 2;
    } elseif( ( class_exists( 'WooCommerce' ) && is_woocommerce() && is_archive() ) && $di_data['product_archive_side'] == 0) {
        $side = 0;
    } elseif ( is_page_template() || ( class_exists( 'WooCommerce' ) && is_account_page() ) || $dokan_page == 1 || $aff_page == 1 || $ticket_page == 1){
        $side = 0;
    } elseif ( is_single() && 'post' == get_post_type() && $postside != 'wside') {
        $side = 1;
    } elseif ( is_single() && 'product' == get_post_type() && $pside != 'wside') {
        if ( ( $pside == 'rside' || $pside == 'lside') && $pside != 'wside') {
            $side = 1;
        } elseif ( $di_data['product_side'] > 0 && $pside != 'wside') {
            $side = 1;
        }
    } elseif(is_page() && $pageside != 'wside'){
        $side = 1;
    } elseif(is_archive() && $di_data['post_archive_side'] != 0){
        $side = 1;
    }
    return $side;
}

//Get terms link
function dina_get_term_links( $term_tax, $term_ids ) {
    
    if ( is_array( $term_ids ) )
    {	
        $term_tax_link = ( $term_tax == 'category' ? 'cat' : $term_tax );
        $term_tax_link = ( $term_tax == 'post_tag' ? 'tag' : $term_tax );
        if( count( $term_ids ) == 1 ) {
            $term_link = get_term_link( (int)$term_ids[0], $term_tax );
        } else {
            $term_link = get_home_url() . '/?'.$term_tax_link.'=';
            foreach( $term_ids as $id ) {
                $term = get_term( $id, $term_tax );
                $slug = $term->slug;
                $term_link .= $slug . ',';
            }
        }
    } else {
		$term_link = get_term_link( (int)$term_ids, $term_tax );
    }
    return $term_link;
}

//Disable RSS Feeds in WordPress
function dina_disable_feed() {
    $site_url = get_bloginfo('url');
    wp_die( sprintf( __( 'No feed available,please visit our <a href="%s">homepage</a>!', 'dina-kala' ), $site_url ) );
}
     
if ( $di_data['dis_rss_feeds'] ) {
    add_action('do_feed', 'dina_disable_feed', 1);
    add_action('do_feed_rdf', 'dina_disable_feed', 1);
    add_action('do_feed_rss', 'dina_disable_feed', 1);
    add_action('do_feed_rss2', 'dina_disable_feed', 1);
    add_action('do_feed_atom', 'dina_disable_feed', 1);
    add_action('do_feed_rss2_comments', 'dina_disable_feed', 1);
    add_action('do_feed_atom_comments', 'dina_disable_feed', 1);
    remove_action( 'wp_head', 'feed_links_extra', 3 );
    remove_action( 'wp_head', 'feed_links', 2 );
}

//Function to set custom 404 page
if ( ! function_exists( 'dina_custom_404_page' ) ) {
	function dina_custom_404_page( $template ) {
		global $wp_query;
        global $di_data;
		$custom_404 = $di_data['custom_404_page'];
		if ( $custom_404 == 'default' || empty( $custom_404 )  ) return $template;

		$wp_query->query( 'page_id=' . $custom_404 );
		$wp_query->the_post();
		$template = get_page_template();
		rewind_posts();

		return $template;
	}
    add_filter( '404_template', 'dina_custom_404_page', 999 );
}

if ( ! function_exists( 'dina_breadcrumb') ) {
    function dina_breadcrumb() {
        global $di_data;
        if( $di_data['show_bread'] ) {

            if ( function_exists( 'yoast_breadcrumb' ) ) {
                $breadcrumbs_enabled = WPSEO_Options::get( 'breadcrumbs-enable', false );
            }

            if ( function_exists( 'yoast_breadcrumb' ) && $breadcrumbs_enabled ) {
                yoast_breadcrumb( '<div class="row bread-row"><nav class="col-12 shadow-box breadcrumbs">','</nav></div>' );
            } elseif ( function_exists('rank_math_the_breadcrumbs') ) {
                echo '<div class="row bread-row"><nav class="col-12 shadow-box breadcrumbs">';
                rank_math_the_breadcrumbs();
                echo '</nav></div>';
            } elseif ( class_exists( 'WooCommerce' ) ) {
                woocommerce_breadcrumb();
            }
        }
    }
}

//Allowed mime types and file extensions 
add_filter( 'upload_mimes', 'dina_add_fonts_to_allowed_mimes' );
function dina_add_fonts_to_allowed_mimes( $mimes ) {
    $mimes['woff']  = 'application/x-font-woff';
    $mimes['woff2'] = 'application/x-font-woff2';
    $mimes['ttf']   = 'application/x-font-ttf';
    $mimes['svg']   = 'image/svg+xml';
    $mimes['eot']   = 'application/vnd.ms-fontobject';
    $mimes['otf']   = 'font/otf';

    return $mimes;
}

//Correct the mome types and extension for the font types.
add_filter( 'wp_check_filetype_and_ext', 'dina_update_mime_types', 10, 3 );
function dina_update_mime_types( $defaults, $file, $filename ) {
    if ( 'ttf' === pathinfo( $filename, PATHINFO_EXTENSION ) ) {
        $defaults['type'] = 'application/x-font-ttf';
        $defaults['ext']  = 'ttf';
    }

    if ( 'otf' === pathinfo( $filename, PATHINFO_EXTENSION ) ) {
        $defaults['type'] = 'application/x-font-otf';
        $defaults['ext']  = 'otf';
    }

    return $defaults;
}

// Disables the block editor from managing widgets in the Gutenberg plugin.
add_filter( 'gutenberg_use_widgets_block_editor', '__return_false' );
// Disables the block editor from managing widgets.
add_filter( 'use_widgets_block_editor', '__return_false' );