<?php
/**
 * Single Product Up-Sells
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/up-sells.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce/Templates
 * @version     3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $di_data;
global $product;

if ( $upsells ) : ?>

<div class="product-block<?php if($di_data['prod_navs'] == 'sttwo') { ?> nav-type-two<?php } ?> related block">
    <div class="block-title">
        <h2>
            <i class="fal fa-bags-shopping" aria-hidden="true"></i>
            <?php esc_html_e( 'You may also like', 'dina-kala' ); ?>
        </h2>
    </div>
    <?php $mobile_col = ($di_data['mobile_single_col'] ? 1 : 2); ?>
    <div class="owl-carousel" data-mcol="<?php echo $mobile_col; ?>" <?php if ( $di_data['show_arrows'] ) { echo 'data-itemnavs="true"'; } else { echo 'data-itemnavs="false"'; } ?> <?php if ( $di_data['prod_loop'] ) { echo 'data-itemloop="true"'; } else { echo 'data-itemloop="false"'; } ?> <?php if ( $di_data['auto_play'] ) { echo 'data-itemplay="true"'; } else { echo 'data-itemplay="false"'; } ?> data-itemscount="<?php echo $di_data['pcount']; ?>" data-dir="<?php dina_rtl(); ?>">

		<?php //woocommerce_product_loop_start(); ?>

			<?php foreach ( $upsells as $upsell ) : ?>

				<?php
				$post_object = get_post( $upsell->get_id() );
				setup_postdata( $GLOBALS['post'] =& $post_object );
				?>
<?php 
                            global $product;
                                $in_stock = $product->is_in_stock();
                                 ?>
                            <div class="item">
                                <?php get_template_part('includes/content-product'); ?>
                            </div>

			<?php endforeach; ?>

		<?php //woocommerce_product_loop_end(); ?>

        </div>
                    </div>

	<?php
endif;

wp_reset_postdata();