<!doctype html>
<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: Hosseinkhani.ir
*/
   // Exit if accessed directly
   if (!defined('ABSPATH')) {
    exit;
}
global $di_data;
?>
<html <?php language_attributes(); ?>>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=<?php bloginfo( 'charset' ); ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <meta name="theme-color" content="<?php echo $di_data['custom_color']; ?>" />
    <title>
        <?php bloginfo('name');
        dfile_check(); ?>
    </title>
    <link rel="shortcut icon" href="<?php echo $di_data['site_favicon']['url']; ?>" type="image/x-icon" />
    <style>
        .container.under{
            color:<?php echo $di_data['maintenance_text_color']; ?>!important;
        }
    </style>
    <?php wp_head(); ?>
</head>

<body class="maintenance-mode">
    <div class="container-fluid">
        <div class="row">
            <div class="container under">
                <h1>
                    <a href="<?php echo esc_url( home_url() ); ?>" title="<?php bloginfo( 'name' );?> | <?php bloginfo('description'); ?>" rel="home">
                    <?php 
                    $logo_width = (!empty($di_data['site_logo_retina']['width'])) ? $di_data['site_logo_retina']['width'] : '320';
                    $logo_height = (!empty($di_data['site_logo_retina']['height'])) ? $di_data['site_logo_retina']['height'] : '114'; ?>
                        <img class="skip-lazy" src="<?php echo $di_data['site_logo_retina']['url']; ?>" width="<?php echo $logo_width; ?>" height="<?php echo $logo_height; ?>" alt="<?php bloginfo( 'name' );?> | <?php bloginfo('description'); ?>" title="<?php bloginfo( 'name' );?> | <?php bloginfo('description'); ?>" />
                    </a>
                </h1>

                <?php
                //show maintenance mode countdown
                $date = $di_data['date_counter'];
                if( $di_data['show_counter'] && !empty( $date ) ) {
                    
                    $date = date("Y/m/d",strtotime($date));
                    
                    $now = time(); // or your date as well
                    $end_date = strtotime($date);
                    $diff = $end_date - $now;
                    $datediff = round($diff / (60 * 60 * 24));
                ?>
                    <div class="salecount" data-datediff="<?php echo $datediff; ?>" data-countdown="<?php echo $date; ?>" data-dir="<?php echo (is_rtl())?'rtl':'ltr';?>" data-seconds="<?php _e('Seconds' , 'dina-kala'); ?>" data-minutes="<?php _e('Minutes' , 'dina-kala'); ?>" data-hours="<?php _e('Hours' , 'dina-kala'); ?>" data-days="<?php _e('Days' , 'dina-kala'); ?>" data-weeks="<?php _e('Weeks' , 'dina-kala'); ?>">
                    </div>
                <?php }  ?>

                <h2>
                    <?php echo $di_data['maintenance_title']; ?>
                </h2>
                <h3>
                    <?php echo $di_data['maintenance_msg']; ?>
                </h3>
            </div>
        </div>
    </div>
    <?php wp_footer(); ?>
</body>

</html>