<?php

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

global $di_data; ?>

<header class="site-header<?php if( !is_front_page() && (!$di_data['show_bread'] || !$di_data['show_bread_mobile']) ) { echo ' no-bread'; }  ?>" <?php if($di_data['site_schema'] ) {?>itemscope itemtype="https://schema.org/Organization" <?php } ?>>
       <?php if($di_data['site_schema']) { 
        echo '<meta itemprop="url" content="'.esc_url(home_url()).'">';
        echo '<meta itemprop="name" content="'.esc_html(get_bloginfo('name')).'">';
        } ?>
    <!-- Header Div -->
        <div class="container-fluid dina-header header<?php if($di_data['fixed_head_mobile']) {echo ' fixed-mobile';} ?>">
            <div class="container">
                
                <?php if(!$di_data['hide_top_bar']) { ?>
                <div class="row head-mc<?php if ($di_data['head_pos'] == 2) {echo ' left-head';} ?>">

                    <!-- Header Menu -->
                    <nav class="col-md-6 head-menu<?php if ($di_data['mobile_head_menu']) {echo ' visible-mobile';} ?>" <?php if($di_data['site_schema']) {?>itemscope itemtype="https://schema.org/SiteNavigationElement" <?php } ?>>
                        <?php
                        if (has_nav_menu('header')) {
                            wp_nav_menu( array(
                                'menu'              => 'header',
                                'theme_location'    => 'header',
                                'depth'             => 1,
                                'container'         => 'div'
                                )
                            );
                        }
                        ?>
                    </nav>
                    <!-- Header Menu -->
                    
                    <?php if($di_data['show_contact'] && !$di_data['show_head_social']) { ?>
                    <!-- Header Contact -->
                    <div class="col-md-6 head-contact">
                        <div class="head-phone" <?php if($di_data['site_schema']) {?>itemprop="telephone"<?php } ?>>
                            <a href="tel:<?php echo dina_remove_dash($di_data['site_tel']); ?>" target="_blank">
                                <i class="fal fa-phone" aria-hidden="true"></i>
                                <?php echo $di_data['site_tel']; ?>
                            </a>
                        </div>
                        <?php if($di_data['replace_email']) { ?>
                            <div class="head-phone" <?php if($di_data['site_schema']) {?>itemprop="telephone"<?php } ?>>
                                <a href="tel:<?php echo dina_remove_dash($di_data['site_tel2']); ?>" target="_blank">
                                    <i class="fal fa-phone-rotary" aria-hidden="true"></i>
                                    <?php echo $di_data['site_tel2']; ?>
                                </a>
                            </div>
                        <?php } else { ?>
                            <div class="head-email" <?php if($di_data['site_schema']) {?>itemprop="email"<?php } ?>>
                                <a href="mailto:<?php echo $di_data['site_email']; ?>" target="_blank">
                                    <i class="fal fa-envelope" aria-hidden="true"></i>
                                    <?php echo $di_data['site_email']; ?>
                                </a>
                            </div>
                        <?php } ?>
                    </div>
                    <!-- Header Contact -->
                    <?php } ?>

                    <?php if($di_data['show_head_social']) { ?>
                    <!-- Header Social -->
                    <div class="col-md-6 head-social">
                        <ul class="head-social-ul">
                            <?php if($di_data['so_twitter']) { ?>
                            <li>
                                <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_twitter_link']; ?>" title="<?php echo __( 'Twitter', 'dina-kala' ); ?>" target="_blank">
                                    <i class="fab fa-twitter"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if($di_data['so_facebook']) { ?>
                            <li>
                                <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_facebook_link']; ?>" title="<?php echo __( 'Facebook', 'dina-kala' ); ?>" target="_blank">
                                    <i class="fab fa-facebook-f"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if($di_data['so_google']) { ?>
                            <li>
                                <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_google_link']; ?>" title="<?php echo __( 'Google+', 'dina-kala' ); ?>" target="_blank">
                                    <i class="fab fa-google-plus-g"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if($di_data['so_whatsapp']) { ?>
                            <li>
                                <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_whatsapp_link']; ?>" title="<?php echo __( 'Whatsapp', 'dina-kala' ); ?>" target="_blank">
                                    <i class="fab fa-whatsapp"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if($di_data['so_tiktok']) { ?>
                            <li>
                                <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_tiktok_link']; ?>" title="<?php echo __( 'Tiktok', 'dina-kala' ); ?>" target="_blank">
                                    <i class="fab fa-tiktok"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if($di_data['so_telegram']) { ?>
                            <li>
                                <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_telegram_link']; ?>" title="<?php echo __( 'Telegram', 'dina-kala' ); ?>" target="_blank">
                                    <i class="fab fa-telegram-plane"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if($di_data['so_instagram']) { ?>
                            <li>
                                <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_instagram_link']; ?>" title="<?php echo __( 'Instagram', 'dina-kala' ); ?>" target="_blank">
                                    <i class="fab fa-instagram"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if($di_data['so_youtube']) { ?>
                            <li>
                                <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_youtube_link']; ?>" title="<?php echo __( 'Youtube', 'dina-kala' ); ?>" target="_blank">
                                    <i class="fab fa-youtube"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if($di_data['so_linkedin']) { ?>
                            <li>
                                <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_linkedin_link']; ?>" title="<?php echo __( 'Linkedin', 'dina-kala' ); ?>" target="_blank">
                                    <i class="fab fa-linkedin-in"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if($di_data['so_dribble']) { ?>
                            <li>
                                <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_dribble_link']; ?>" title="<?php echo __( 'Dribble', 'dina-kala' ); ?>" target="_blank">
                                    <i class="fab fa-dribbble"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if($di_data['so_behance']) { ?>
                            <li>
                                <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_behance_link']; ?>" title="<?php echo __( 'Behance', 'dina-kala' ); ?>" target="_blank">
                                    <i class="fab fa-behance"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if($di_data['so_pinterest']) { ?>
                            <li>
                                <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_pinterest_link']; ?>" title="<?php echo __( 'Pinterest', 'dina-kala' ); ?>" target="_blank">
                                    <i class="fab fa-pinterest-p"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if($di_data['so_aparat']) { ?>
                            <li>
                                <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_aparat_link']; ?>" title="<?php echo __('Aparat','dina-kala'); ?>" target="_blank">
                                    <i class="dico ico-aparat"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if($di_data['so_cloob']) { ?>
                            <li>
                                <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_cloob_link']; ?>" title="<?php echo __('Aparat','dina-kala'); ?>" target="_blank">
                                    <i class="dico ico-cloob"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if($di_data['so_soroush']) { ?>
                            <li>
                                <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_soroush_link']; ?>" title="<?php echo __('Soroush','dina-kala'); ?>" target="_blank">
                                    <i class="dico ico-Soroush"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if($di_data['so_gap']) { ?>
                            <li>
                                <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_gap_link']; ?>" title="<?php echo __('Gap','dina-kala'); ?>" target="_blank">
                                    <i class="dico ico-Gap"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if($di_data['so_eitaa']) { ?>
                            <li>
                                <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_eitaa_link']; ?>" title="<?php echo __('Eitaa','dina-kala'); ?>" target="_blank">
                                    <i class="dico ico-Eitaa"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if($di_data['so_bisphone']) { ?>
                            <li>
                                <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_bisphone_link']; ?>" title="<?php echo __('Bisphone','dina-kala'); ?>" target="_blank">
                                    <i class="dico ico-Bisphone"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if($di_data['so_bale']) { ?>
                            <li>
                                <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_bale_link']; ?>" title="<?php echo __('Bale','dina-kala'); ?>" target="_blank">
                                    <i class="dico ico-Bale"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if($di_data['so_igap']) { ?>
                            <li>
                                <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_igap_link']; ?>" title="<?php echo __('iGap','dina-kala'); ?>" target="_blank">
                                    <i class="dico ico-iGap"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if($di_data['so_rubika']) { ?>
                            <li>
                                <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_rubika_link']; ?>" title="<?php echo __('Rubika','dina-kala'); ?>" target="_blank">
                                    <i class="dico ico-rubika"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if($di_data['so_hoorsa']) { ?>
                            <li>
                                <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="<?php echo $di_data['so_hoorsa_link']; ?>" title="<?php echo __('Hoorsa','dina-kala'); ?>" target="_blank">
                                    <i class="dico ico-hoorsa"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if($di_data['so_phone']) { ?>
                            <li>
                                <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="tel:<?php echo dina_remove_dash($di_data['so_phone_link']); ?>" title="<?php echo __('Phone','dina-kala'); ?>" target="_blank">
                                    <i class="fal fa-phone" aria-hidden="true"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if($di_data['so_mobile']) { ?>
                            <li>
                                <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="tel:<?php echo dina_remove_dash($di_data['so_mobile_link']); ?>" title="<?php echo __('Mobile','dina-kala'); ?>" target="_blank">
                                    <i class="fal fa-mobile-alt" aria-hidden="true"></i>
                                </a>
                            </li>
                            <?php } ?>
                            <?php if($di_data['so_email']) { ?>
                            <li>
                                <a <?php if($di_data['site_schema']) {?>itemprop="sameAs" <?php } ?> href="mailto:<?php echo $di_data['so_email_link']; ?>" title="<?php echo __('Email','dina-kala'); ?>" target="_blank">
                                    <i class="fal fa-at" aria-hidden="true"></i>
                                </a>
                            </li>
                            <?php } ?>
                        </ul>
                    </div>
                    <!-- Header Social -->
                    <?php } ?>

                </div>
                <?php } ?>

                <div class="row logo-box<?php if ($di_data['logo_pos'] == 2) {echo ' left-logo';} if ($di_data['mobile_logo_pos'] == 1) {echo ' mobile-right-logo';} ?>">

                        <div class="col-6 mobile-btns">
                            <span class="btn btn-light mmenu" onclick="openNav()">
                                    <i aria-hidden="true" class="fal fa-bars"></i>
                            </span>
                            <?php if($di_data['show_user_btn']) { ?>
                            <?php if(!is_user_logged_in()) { ?>
                                <?php if (function_exists('digits_version') && $di_data['digits_mode']) {
                                    $digits_mode = ( $di_data['digits_page'] ? 'digitlink' : 'digitpopup' ); ?>
                                    <span title="<?php echo __('Login Or Register', 'dina-kala'); ?>" class="btn btn-light mlogin digitsbtn <?php echo $digits_mode; ?>">
                                        <i aria-hidden="true" class="fal fa-user"></i>
                                        /
                                        <i aria-hidden="true" class="fal fa-user-plus"></i>
                                    </span>
                                <?php } elseif($di_data['merge_user_btn']) { ?>
                                    <a title="<?php echo __('Login Or Register', 'dina-kala'); ?>" class="btn btn-light mlogin" <?php if($di_data['ch_login_link']) {echo 'href="'.$di_data['login_link'].'"'; } else {echo 'href="' .esc_url(home_url()).'/my-account"';} ?>>
                                        <i aria-hidden="true" class="fal fa-user"></i>
                                        /
                                        <i aria-hidden="true" class="fal fa-user-plus"></i>
                                    </a>
                                <?php } else { ?>
                                <a title="<?php echo __('Login', 'dina-kala'); ?>" <?php if($di_data['ch_login_link']) {echo 'href="'.$di_data['login_link'].'"'; } else {echo 'href="#" onclick="openLogin()"';} ?>
                                    class="btn btn-light mlogin">
                                    <i aria-hidden="true" class="fal fa-user"></i>
                                </a>
                                <a title="<?php echo __('Register', 'dina-kala'); ?>" <?php if($di_data['ch_register_link']) {echo 'href="'.$di_data['register_link'].'"'; } else {echo 'href="' .esc_url(home_url()).'/my-account"';} ?>
                                    class="btn btn-light mregister">
                                    <i aria-hidden="true" class="fal fa-user-plus"></i>
                                </a>
                            <?php } } else { ?>
                                <a title="<?php echo __('User Menu', 'dina-kala'); ?>" class="btn btn-light mlogin" onclick="openUmenu()">
                                    <i aria-hidden="true" class="fal fa-user"></i>
                                </a>
                            <?php } } ?>
                        </div>

                        <div class="col-md-3 col-6 logo dina-logo">
                        <?php if (is_front_page()) {echo '<h1>';} ?>
                        <a href="<?php echo esc_url(home_url()); ?>" title="<?php bloginfo('name'); ?> | <?php bloginfo('description'); ?>" rel="home">
                        <?php 
                        $logo_width = (!empty($di_data['site_logo']['width'])) ? $di_data['site_logo']['width'] : '160';
                        $logo_height = (!empty($di_data['site_logo']['height'])) ? $di_data['site_logo']['height'] : '57'; ?>
                            <img <?php if($di_data['site_schema']) {?>itemprop="logo" <?php } ?> src="<?php echo $di_data['site_logo']['url']; ?>" srcset="<?php echo $di_data['site_logo_retina']['url']; ?> 2x" width="<?php echo $logo_width; ?>" height="<?php echo $logo_height; ?>" alt="<?php bloginfo('name'); ?> | <?php bloginfo('description'); ?>" title="<?php bloginfo('name'); ?> | <?php bloginfo('description'); ?>" class="img-logo"/>
                            <strong><?php bloginfo('name'); ?> | <?php bloginfo('description'); ?> </strong>
                        </a>
                        <?php if (is_front_page()) {echo '</h1>';} ?>
                        </div>
                        
                        <div class="col-md-6 search-con<?php if($di_data['mobile_search']) { ?> mobile-search-con<?php } ?>">
                            <form class="col-md-11" id="head-search" role="search" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                            <?php if(!$di_data['search_others']) { ?>
                                <input type="hidden" name="post_type" value="product" />
                            <?php } ?>
                            <div class="input-group search-form">
                                <?php 
                                if ( $di_data['search_cat'] ) {
                                $categories = get_terms("product_cat");
                                if (!empty( $categories ) && !is_wp_error( $categories ) ) {
                                ?>
                                <div class="input-group-before prod-cat">
                                    <?php echo '<select name="product_cat" >';
                                    echo '<option value="">'.__("Category",'dina-kala').'</option>';
                                    foreach ( $categories as $category ) {
                                    echo '<option value="'.$category->slug.'">'.$category->name.'</option>';
                                    }
                                    echo '</select>'; ?>
                                </div>
                                <?php } } ?>
                                <input autocomplete="off"<?php if($di_data['ajax_search']) { echo ' data-swplive="true"' ; } ?> name="s" type="text" class="form-control search-input" placeholder="<?php _e('Search Products...', 'dina-kala'); ?>" aria-label="<?php _e("Search", 'dina-kala'); ?>" required>
                                <div class="input-group-append">
                                    <button class="btn btn-search" type="submit" aria-label="<?php _e("Search", 'dina-kala'); ?>">
                                        <i class="fal fa-search" aria-hidden="true"></i>
                                    </button>
                                </div>
                            </div>
                            </form>
                        </div>

                        <?php if($di_data['show_user_btn']) { ?>
                            <?php if(!is_user_logged_in()) { ?>
                            <div class="col-md-3 user-btn">
                                <?php if (function_exists('digits_version') && $di_data['digits_mode']) { 
                                    $digits_mode = ( $di_data['digits_page'] ? 'digitlink' : 'digitpopup' ); ?>
                                    <?php if($di_data['user_btn_style']) { ?>
                                        <span title="<?php echo __('Login Or Register', 'dina-kala'); ?>" class="register-link digitsbtn <?php echo $digits_mode; ?>">
                                            <i aria-hidden="true" class="fal fa-user"></i>
                                            <span class="hidden-ta"><?php echo __('Login', 'dina-kala'); ?></span>
                                            /
                                            <i aria-hidden="true" class="fal fa-user-plus"></i>
                                            <span class="hidden-ta"><?php echo __('Register', 'dina-kala'); ?></span>
                                        </span>
                                    <?php } else { ?>
                                        <span title="<?php echo __('Login Or Register', 'dina-kala'); ?>" class="btn btn-success btn-register digitsbtn <?php echo $digits_mode; ?>">
                                            <i aria-hidden="true" class="fal fa-user"></i>
                                            <span class="hidden-ta"><?php echo __('Login', 'dina-kala'); ?></span>
                                            /
                                            <i aria-hidden="true" class="fal fa-user-plus"></i>
                                            <span class="hidden-ta"><?php echo __('Register', 'dina-kala'); ?></span>
                                        </span>
                                    <?php } ?>
                                <?php } else { ?>
                                    <?php if($di_data['user_btn_style']) { ?>
                                        <?php if($di_data['merge_user_btn']) { ?>
                                            <a title="<?php echo __('Login Or Register', 'dina-kala'); ?>" <?php if($di_data['ch_login_link']) {echo 'href="'.$di_data['login_link'].'"'; } else {echo 'href="' .esc_url(home_url()).'/my-account"';} ?>
                                            class="register-link merge-btn">
                                                <i aria-hidden="true" class="fal fa-user"></i>
                                                <span class="hidden-ta"><?php echo __('Login', 'dina-kala'); ?></span>
                                                /
                                                <i aria-hidden="true" class="fal fa-user-plus"></i>
                                                <span class="hidden-ta"><?php echo __('Register', 'dina-kala'); ?></span>
                                            </a>
                                        <?php } else { ?>
                                            <a title="<?php echo __('Login', 'dina-kala'); ?>" <?php if($di_data['ch_login_link']) {echo 'href="'.$di_data['login_link'].'"'; } else {echo 'href="#" onclick="openLogin()"';} ?>
                                                class="login-link">
                                                <i aria-hidden="true" class="fal fa-user"></i>
                                                <span class="hidden-ta"><?php echo __('Login', 'dina-kala'); ?></span>
                                            </a>
                                            /
                                            <a title="<?php echo __('Register', 'dina-kala'); ?>" <?php if($di_data['ch_register_link']) {echo 'href="'.$di_data['register_link'].'"'; } else {echo 'href="' .esc_url(home_url()).'/my-account"';} ?>
                                                class="register-link">
                                                <i aria-hidden="true" class="fal fa-user-plus"></i>
                                                <span class="hidden-ta"><?php echo __('Register', 'dina-kala'); ?></span>
                                            </a>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <?php if($di_data['merge_user_btn']) { ?>
                                            <a title="<?php echo __('Login Or Register', 'dina-kala'); ?>" <?php if($di_data['ch_login_link']) {echo 'href="'.$di_data['login_link'].'"'; } else {echo 'href="' .esc_url(home_url()).'/my-account"';} ?>
                                                class="btn btn-success btn-register merge-btn">
                                                <i aria-hidden="true" class="fal fa-user"></i>
                                                <span class="hidden-ta"><?php echo __('Login', 'dina-kala'); ?></span>
                                                /
                                                <i aria-hidden="true" class="fal fa-user-plus"></i>
                                                <span class="hidden-ta"><?php echo __('Register', 'dina-kala'); ?></span>
                                            </a>
                                        <?php } else { ?>
                                            <a title="<?php echo __('Login', 'dina-kala'); ?>" <?php if($di_data['ch_login_link']) {echo 'href="'.$di_data['login_link'].'"'; } else {echo 'href="#" onclick="openLogin()"';} ?>
                                                class="btn btn-outline-success btn-login">
                                                <i aria-hidden="true" class="fal fa-user"></i>
                                                <span class="hidden-ta"><?php echo __('Login', 'dina-kala'); ?></span>
                                            </a>
                                            <a title="<?php echo __('Register', 'dina-kala'); ?>" <?php if($di_data['ch_register_link']) {echo 'href="'.$di_data['register_link'].'"'; } else {echo 'href="' .esc_url(home_url()).'/my-account"';} ?>
                                                class="btn btn-success btn-register">
                                                <i aria-hidden="true" class="fal fa-user-plus"></i>
                                                <span class="hidden-ta"><?php echo __('Register', 'dina-kala'); ?></span>
                                            </a>
                                        <?php } ?>
                                    <?php } ?>
                                <?php } ?>
                            </div>
                            <?php } else {
                            $user = wp_get_current_user(); ?>
                            <div class="col-md-3 drop-con">
                            <div class="dropdown user-drop">
                                <button class="dropdown-toggle user-menu" type="button" data-toggle="dropdown">
                                <?php echo get_avatar(get_current_user_id() , 32,'',$user->display_name ); ?>
                                <span class="user-name"><?php echo $user->display_name; ?>
                                <?php if (class_exists( 'WooWallet' ))
                                {       
                                echo '<span class="wallet hidden-ta">';
                                $wallet = woo_wallet()->wallet->get_wallet_balance( get_current_user_id() );
                                        echo ' | '. $wallet;
                                echo '</span>';
                                } ?></span>
                                <span class="fal fa-chevron-down user-chevron-down" aria-hidden="true"></span>
                                </button>

                                <?php if($di_data['replace_user_menu'] && has_nav_menu('user_menu')) { ?>
                                    <?php
                                        wp_nav_menu( array(
                                            'menu'              => 'user_menu',
                                            'theme_location'    => 'user_menu',
                                            'menu_class'        => 'dropdown-menu user-menu mu-menu col-12',
                                            'depth'             => 1,
                                            'container'         => ''
                                            )
                                        );
                                    ?>
                                <?php } else { ?>
                                    <ul class="dropdown-menu user-menu mu-menu col-12">
                                        <?php get_template_part('includes/umenu'); ?>
                                    </ul>
                                <?php } ?>
                            </div>
                            </div>
                        <?php } } ?>
                </div>
            </div>
        </div>
        <!-- Header Div -->

        <!-- Navbar -->
        <div class="dina-navbar">
            <nav class="navbar navbar-expand-sm<?php if ($di_data['fixed_head_top']) {echo ' fixed-nav';} ?><?php if ($di_data['focus_nav']) {echo ' focus-nav';} ?>" <?php if($di_data['site_schema']) {?>itemscope itemtype="https://schema.org/SiteNavigationElement"<?php } ?>>
                <div class="container nav-con">
                    <!-- Collect the nav links from WordPress -->
                    <div class="collapse navbar-collapse" id="bootstrap-nav-collapse">
                        <?php 
                        $args = array(
                            'theme_location' => 'mega_menu',
                            'depth'             => 4,
                            'container'         => 'div',
                            'fallback_cb'       => 'Yamm_Nav_Walker_menu_fallback',
                            'walker'            => new Yamm_Nav_Walker()
                            );

                        if($di_data['mega_style'] == 'second') {
                            $args['menu_class'] = 'nav navbar-nav yamm-s';
                        } else {
                            $args['menu_class'] = 'nav navbar-nav yamm';
                        }

                        if ($di_data['fixed_head_logo']) {
                            if($di_data['site_schema']) { $itemprop = 'itemprop="logo"'; } else { $itemprop = ''; }
                            if($di_data['change_fixed_logo'] && !empty($di_data['sticky_logo']['url'])) {
                                $sticky_logo = '<li class="sticky-logo"><a href="'. esc_url(home_url()) .'" title="'. get_bloginfo('name') .' | '. get_bloginfo('description') .'" rel="home" class="menu-logo">
                                            <img '. $itemprop .'src="'. $di_data['sticky_logo']['url'] .'" alt="'. get_bloginfo('name') .' | '. get_bloginfo('description') .'" width="107" height="37" title="'. get_bloginfo('name') .' | '. get_bloginfo('description') .'" class="img-logo"/>
                                        </a></li>';
                            } else {
                                $sticky_logo = '<li class="sticky-logo"><a href="'. esc_url(home_url()) .'" title="'. get_bloginfo('name') .' | '. get_bloginfo('description') .'" rel="home" class="menu-logo">
                                            <img '. $itemprop .'src="'. $di_data['site_logo']['url'] .'" srcset="'. $di_data['site_logo_retina']['url'] .' 2x" alt="'. get_bloginfo('name') .' | '. get_bloginfo('description') .'" width="107" height="37" title="'. get_bloginfo('name') .' | '. get_bloginfo('description') .'" class="img-logo"/>
                                        </a></li>';
                            }
                            
                            $items_wrap = '<ul id="%1$s" class="%2$s">'.$sticky_logo.'%3$s';
                            $items_wrap .= '</ul>';
                            $args['items_wrap'] = $items_wrap;
                        }

                        //$args['menu_class'] = 'nav navbar-nav yamm';
                        wp_nav_menu($args);
                    ?>
                    </div><!-- ./collapse -->

                    <?php
                    if($di_data['show_wish_list'] ) {
                        if ( class_exists('YITH_WCWL') ) {
                            $wcwl_url = esc_url( YITH_WCWL()->get_wishlist_url() ); ?>
                            <div class="btn-wish dina-yith-wcwl-btn">
                                <a href="<?php echo $wcwl_url; ?>" aria-label="<?php echo __('Wishlist', 'dina-kala'); ?>" rel="nofollow" class="wish-icon" data-toggle="tooltip" data-placement="top" title="<?php echo __('Wishlist', 'dina-kala'); ?>">
                                    <i aria-hidden="true" class="fal fa-heart"></i>
                                    <i class="wish-amount"><?php echo do_shortcode( '[yith_wcwl_items_count]' ); ?></i>
                                </a>
                            </div>
                        <?php 
                        } elseif( class_exists( 'JVM_WooCommerce_Wishlist' ) ) {
                            $wish_url = jvm_get_wishlist_url();
                            $wish_count = jvm_woocommerce_wishlist_get_count(); ?>
                            <div class="btn-wish">
                                <a href="<?php echo $wish_url; ?>" aria-label="<?php echo __('Wishlist', 'dina-kala'); ?>" rel="nofollow" class="wish-icon" data-toggle="tooltip" data-placement="top" title="<?php echo __('Wishlist', 'dina-kala'); ?>">
                                    <i aria-hidden="true" class="fal fa-heart"></i>
                                    <i class="wish-amount"><?php echo $wish_count; ?></i>
                                </a>
                            </div>
                    <?php 
                        } 
                    } ?>

                    <?php 
                    if ( $di_data['show_compare_btn'] ) {
                    if( class_exists('YITH_Woocompare') ) {
                        global $yith_woocompare; ?>
                        <div class="btn-compare dina-yith-compare">
                            <a href="<?php echo $yith_woocompare->obj->view_table_url() ?>" aria-label="<?php echo __('Compare Products', 'dina-kala'); ?>" rel="nofollow" class="compare-icon compare-link" data-toggle="tooltip" data-placement="top" title="<?php echo __('Compare Products', 'dina-kala'); ?>">
                                <i aria-hidden="true" class="fal fa-random"></i>
                            </a>
                        </div>
                    <?php } elseif( defined( 'WCCM_VERISON' ) ) {
                    $compare_url = wccm_get_compare_page_link( wccm_get_compare_list() );
                    $compare_count = count(wccm_get_compare_list()); ?>
                        <div class="btn-compare">
                            <a href="<?php echo $compare_url; ?>" aria-label="<?php echo __('Compare Products', 'dina-kala'); ?>" rel="nofollow" class="compare-icon compare-link" data-toggle="tooltip" data-placement="top" title="<?php echo __('Compare Products', 'dina-kala'); ?>">
                                <i aria-hidden="true" class="fal fa-random"></i>
                                <i class="compare-amount"><?php echo $compare_count; ?></i>
                            </a>
                        </div>
                    <?php } } ?>

                    <?php if($di_data['show_cart_btn']) { ?>
                    <div class="btn-cart">
                        <span class="shop-icon" data-toggle="tooltip" data-placement="top" title="<?php echo __('Shopping cart', 'dina-kala'); ?>" onclick="openCart()">
                        <i aria-hidden="true" class="fal fa-shopping-bag"></i>
                        <i class="cart-amount"><?php echo WC()->cart->get_cart_contents_count(); ?></i>
                        </span>
                    </div>
                    <?php } ?>

                </div><!-- /.container -->
            </nav>
        </div>
        <!-- Navbar -->

    </header>