<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: Hosseinkhani.ir
*/
   // Exit if accessed directly
   if (!defined('ABSPATH')) {
      exit;
   }

   // Creating the widget
   class dina_brand_filter_widget extends WP_Widget {
   
      function __construct() {
      
         parent::__construct(
         
         // Base ID of your widget
         'dina_brand_filter_widget',
         
         // Widget name will appear in UI
         __('Brand filter (Dinakala)', 'dina-kala'),
         
         // Widget description
         array( 'description' => __('Product brand filter', 'dina-kala'), )
         
         );
      
      }
   
      function get_link( $brand_id ) {
         $base_link            = dina_shop_page_link( true );
         $link                 = remove_query_arg( 'product_brand', $base_link );
         $current_product_brand = isset( $_GET['product_brand'] ) ? explode( ',', $_GET['product_brand'] ) : array();
         $option_is_set        = in_array( $brand_id, $current_product_brand );

         if ( ! in_array( $brand_id, $current_product_brand ) ) {
            $current_product_brand[] = $brand_id;
         }
         
         foreach ( $current_product_brand as $key => $value ) {
            if ( $option_is_set && $value == $brand_id ) {
               unset( $current_product_brand[ $key ] );
            }
         }

         if ( $current_product_brand ) {
            asort( $current_product_brand );
            $link = add_query_arg( 'product_brand', implode( ',', $current_product_brand ), $link );
         }

         $link = str_replace( '%2C', ',', $link );
         return $link;
      }
   
      //Creating widget front-end   
      public function widget( $args, $instance ) {

         if( is_shop() || is_product_taxonomy() ) {
      
            $title = apply_filters( 'widget_title', $instance['title'] );
            $show_brand_logo = isset( $instance['show_brand_logo'] ) ? $instance['show_brand_logo'] : '';
         
            // before and after widget arguments are defined by themes
            echo $args['before_widget'];
         
            if ( ! empty( $title ) )
               echo $args['before_title'] . $title . $args['after_title'];

            // This is where you run the code and display the output
            $product_brand = isset( $_GET['product_brand'] ) ? explode( ',', $_GET['product_brand'] ) : array();
         ?>
            <?php $prod_brand = array();
            $brands = get_terms("brand");
            if ( !empty( $brands ) && !is_wp_error( $brands ) ){ ?>

            <ul class="dina-brand-filter">

               <?php foreach ( $brands as $brand ) {

                  $brand_logo = $show_brand_logo ? get_term_meta( $brand -> term_id, 'dina_brand_logo', true ) : '';
                                  
                  ?>
                     <li class="dina-filter-item<?php echo in_array( $brand->term_id, $product_brand ) ? ' is-active' : ''; ?>">
                        <a rel="nofollow" href="<?php echo esc_attr( $this->get_link( $brand->term_id ) ); ?>">
                        <?php if( !empty( $brand_logo ) ){ 
                           echo '<img src="'.$brand_logo.'" alt="'.$brand -> name.'" title="'.$brand -> name.'" class="filter-brand-logo">';
                           }
                           echo $brand->name; 
                           ?>
                        </a>
                     </li>
               <?php } ?>

            </ul>
            <?php } else {
               _e('No brand found!', 'dina-kala');
            } ?>
         <?php
            echo $args['after_widget'];
         }

      }
   
   
      // Widget Backend
      public function form( $instance ) {
      
         $title        = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : __('Brand filter', 'dina-kala');
         $show_brand_logo = isset( $instance['show_brand_logo'] ) ? $instance['show_brand_logo'] : '';
         
         // Widget admin form
         ?>
         <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'dina-kala' ); ?></label>
            <input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
         </p>

         <p>
            <label for="<?php echo $this->get_field_id( 'show_brand_logo' ); ?>">
            <input type="checkbox" id="<?php echo $this->get_field_id( 'show_brand_logo' ); ?>" value="true" name="<?php echo $this->get_field_name( 'show_brand_logo' ); ?>" <?php checked( $show_brand_logo, 'true' ); ?> />
            <?php _e('Show brand logo','dina-kala') ?>
            </label>
         </p>

      <?php
      }
   
      // Updating widget replacing old instances with new
      public function update( $new_instance, $old_instance ) {
      
         $instance = array();
         
         $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
         $instance['show_brand_logo'] = sanitize_text_field( $new_instance['show_brand_logo']);
         
         return $instance;
      
      }
   
   }
   
   // Register and load the widget
   function dina_brand_filter_load_widget() {
      register_widget( 'dina_brand_filter_widget' );
   }
   add_action( 'widgets_init', 'dina_brand_filter_load_widget' );   