<?php
/**
 * Include and setup custom metaboxes and fields. (make sure you copy this file to outside the CMB2 directory)
 *
 * Be sure to replace all instances of 'dina_' with your project's prefix.
 * http://nacin.com/2010/05/11/in-wordpress-prefix-everything/
 *
 * @category YourThemeOrPlugin
 * @package  Demo_CMB2
 * @license  http://www.opensource.org/licenses/gpl-license.php GPL v2.0 (or later)
 * @link     https://github.com/CMB2/CMB2
 */

/**
 * Get the bootstrap! If using the plugin from wordpress.org, REMOVE THIS!
 */

if ( file_exists( dirname( __FILE__ ) . '/cmb2/init.php' ) ) {
	require_once dirname( __FILE__ ) . '/cmb2/init.php';
} elseif ( file_exists( dirname( __FILE__ ) . '/CMB2/init.php' ) ) {
	require_once dirname( __FILE__ ) . '/CMB2/init.php';
}

if ( file_exists( dirname( __FILE__ ) . '/cmb2/cmb-field-select2.php' ) ) {
	require_once dirname( __FILE__ ) . '/cmb2/cmb-field-select2.php';
}

if ( file_exists( dirname( __FILE__ ) . '/cmb2/fa.php' ) ) {
	require_once dirname( __FILE__ ) . '/cmb2/fa.php';
}

/**
 * CMB2 Field Type: Select2 asset path
 *
 * Filter the path to front end assets (JS/CSS).
 */
function dina_cmb2_field_select2_asset_path() {
	return get_stylesheet_directory_uri() . '/includes/cmb2';
}
add_filter( 'pw_cmb2_field_select2_asset_path', 'dina_cmb2_field_select2_asset_path' );
/**
 * Conditionally displays a metabox when used as a callback in the 'show_on_cb' cmb2_box parameter
 *
 * @param  CMB2 $product CMB2 object.
 *
 * @return bool      True if metabox should show
 */
function dina_show_if_front_page( $product ) {
	// Don't show this metabox if it's not the front page template.
	if ( get_option( 'page_on_front' ) !== $product->object_id ) {
		return false;
	}
	return true;
}

/**
 * Conditionally displays a field when used as a callback in the 'show_on_cb' field parameter
 *
 * @param  CMB2_Field $field Field object.
 *
 * @return bool              True if metabox should show
 */
function dina_hide_if_no_cats( $field ) {
	// Don't show this field if not in the cats category.
	if ( ! has_tag( 'cats', $field->object_id ) ) {
		return false;
	}
	return true;
}

/**
 * Manually render a field.
 *
 * @param  array      $field_args Array of field arguments.
 * @param  CMB2_Field $field      The field object.
 */
function dina_render_row_cb( $field_args, $field ) {
	$classes     = $field->row_classes();
	$id          = $field->args( 'id' );
	$label       = $field->args( 'name' );
	$name        = $field->args( '_name' );
	$value       = $field->escaped_value();
	$description = $field->args( 'description' );
	?>
	<div class="custom-field-row <?php echo esc_attr( $classes ); ?>">
		<p><label for="<?php echo esc_attr( $id ); ?>"><?php echo esc_html( $label ); ?></label></p>
		<p><input id="<?php echo esc_attr( $id ); ?>" type="text" name="<?php echo esc_attr( $name ); ?>" value="<?php echo $value; ?>"/></p>
		<p class="description"><?php echo esc_html( $description ); ?></p>
	</div>
	<?php
}

/**
 * Manually render a field column display.
 *
 * @param  array      $field_args Array of field arguments.
 * @param  CMB2_Field $field      The field object.
 */
function dina_display_text_small_column( $field_args, $field ) {
	?>
	<div class="custom-column-display <?php echo esc_attr( $field->row_classes() ); ?>">
		<p><?php echo $field->escaped_value(); ?></p>
		<p class="description"><?php echo esc_html( $field->args( 'description' ) ); ?></p>
	</div>
	<?php
}

/**
 * Conditionally displays a message if the $post_id is 2
 *
 * @param  array      $field_args Array of field parameters.
 * @param  CMB2_Field $field      Field object.
 */
function dina_before_row_if_2( $field_args, $field ) {
	if ( 2 == $field->object_id ) {
		echo '<p>Testing <b>"before_row"</b> parameter (on $post_id 2)</p>';
	} else {
		echo '<p>Testing <b>"before_row"</b> parameter (<b>NOT</b> on $post_id 2)</p>';
	}
}

add_action( 'cmb2_admin_init', 'dina_register_metabox' );
/**
 * Hook in and add a demo metabox. Can only happen on the 'cmb2_admin_init' or 'cmb2_init' hook.
 */
function dina_register_metabox() {
	global $di_data;
	global $font_awesome_icons;

	$prefix = 'dina_';

	//Product Settings MetaBox
	$product = new_cmb2_box( array(
		'id'            => $prefix . 'metabox',
		'title'         => esc_html__( 'Product Settings', 'dina-kala' ),
		'object_types'  => array( 'product' ), // Post type
		// 'show_on_cb' => 'dina_show_if_front_page', // function should return a bool value
		// 'context'    => 'normal',
		'priority'   => 'high',
		// 'show_names' => true, // Show field names on the left
		// 'cmb_styles' => false, // false to disable the CMB stylesheet
		// 'closed'     => true, // true to keep the metabox closed by default
		// 'classes'    => 'extra-class', // Extra cmb2-wrap classes
		// 'classes_cb' => 'dina_add_some_classes', // Add classes through a callback.
		// 'mb_callback_args' => array( '__block_editor_compatible_meta_box' => false ),
	) );

	$product->add_field( array(
		'name'       => esc_html__( 'Text under product title (under title)', 'dina-kala' ),
		'id'         => $prefix . 'under_title',
		'type'       => 'text',
	) );

	$product->add_field( array(
		'name' => esc_html__( 'Product Label', 'dina-kala' ),
		'desc' => esc_html__( 'This tag is displayed on the product image in the archive pages', 'dina-kala' ),
		'id'   => $prefix . 'plabel',
		'type' => 'text_small',
	) );

	$product->add_field( array(
		'name'             => esc_html__( 'Product Label Color', 'dina-kala' ),
		'desc'             => esc_html__( 'Select the label color', 'dina-kala' ),
		'id'               => $prefix . 'plabel_color',
		'type'             => 'pw_select',
		'default'          => 'none',
		'options'          => array(
			'none'     => __( 'Select', 'dina-kala' ),
			'red' => __( 'Red', 'dina-kala' ),
			'green'   => __( 'Green', 'dina-kala' ),
			'blue'   => __( 'Blue', 'dina-kala' ),
			'yellow'   => __( 'Yellow', 'dina-kala' ),
			'orange'   => __( 'Orange', 'dina-kala' ),
			'purple'   => __( 'Purple', 'dina-kala' ),
			'black'   => __( 'Black', 'dina-kala' ),
		),
	) );

	$product->add_field( array(
		'name' => esc_html__( 'Comingsoon Mode', 'dina-kala' ),
		'desc' => esc_html__( 'View Comingsoon instead of price', 'dina-kala' ),
		'id'   => $prefix . 'coming',
		'type' => 'checkbox',
	) );

	$product->add_field( array(
		'name' => esc_html__( 'Special Product', 'dina-kala' ),
		'desc' => esc_html__( 'View Product in Special Offer Products section', 'dina-kala' ),
		'id'   => $prefix . 'special',
		'type' => 'checkbox',
	) );

	$product->add_field( array(
		'name' => esc_html__( 'Review Video', 'dina-kala' ),
		'desc' => esc_html__( 'Upload Video Review of the Product', 'dina-kala' ),
		'id'   => $prefix . 'rvideo',
		'text'    => array(
		'add_upload_file_text' => esc_html__( 'Add Video', 'dina-kala' )
		),
		'type' => 'file',
	) );

	$product->add_field( array(
		'name' => esc_html__( 'Aparat Video', 'dina-kala' ),
		'desc' => esc_html__( 'Enter only id of the video (example: 4pN2B)', 'dina-kala' ),
		'id'   => $prefix . 'aparat',
		'type' => 'text_small',
	) );

	$product->add_field( array(
		'name'             => esc_html__( 'Product Sidebar Setting', 'dina-kala' ),
		'id'               => $prefix . 'pside',
		'type'             => 'radio_inline',
		'show_option_none' => esc_html__( 'Defualt Settings', 'dina-kala' ),
		'options'          => array(
			'wside' => esc_html__( 'Without Sidebar', 'dina-kala' ),
			'rside'   => esc_html__( 'Right Sidebar', 'dina-kala' ),
			'lside'     => esc_html__( 'Left Sidebar', 'dina-kala' ),
		),
	) );

	$product->add_field( array(
		'name'             => esc_html__( 'Additional product information', 'dina-kala' ),
		'id'               => $prefix . 'prod_info_text',
		'desc'             => esc_html__( 'This item is displayed below the product price and can be defined for all products in the Theme settings > Product Settings section.', 'dina-kala' ),
		'type'    		   => 'wysiwyg',
		'options' => array(
			'media_buttons' => false,
			'textarea_rows' => get_option('default_post_edit_rows', 5),
			'teeny' => true,
		),
	) );

	$product_features = $product->add_field( array(
		'id'          => $prefix . 'product_features',
		'type'        => 'group',
		'description' => esc_html__( 'Product features shown above product price', 'dina-kala' ),
		'options'     => array(
			'group_title'    => esc_html__( 'Feature {#}', 'dina-kala' ),
			'add_button'     => esc_html__( 'Add Another Feature', 'dina-kala' ),
			'remove_button'  => esc_html__( 'Remove Feature', 'dina-kala' ),
			'sortable'       => true,
			'closed'      => true, // true to have the groups closed by default
			'remove_confirm' => esc_html__( 'Are you sure you want to remove this feature?', 'dina-kala' ),
		),
	) );

	$product->add_group_field( $product_features, array(
		'name'       => esc_html__( 'Feature Title', 'dina-kala' ),
		'id'         => 'ftitle',
		'type'       => 'text',
	) );

	$product->add_group_field( $product_features, array(
		'name'       => esc_html__( 'Feature Description', 'dina-kala' ),
		'id'         => 'fdesc',
		'type'       => 'text',
	) );

	$product->add_group_field( $product_features, array(
		'name'       => esc_html__( 'Feature Icon', 'dina-kala' ),
		'id'         => 'ficon',
		'type'       => 'pw_select',
		'classes'    => 'ficon_select',
		'default'    => 'none',
		'options'    => $font_awesome_icons,
	) );

	$product->add_field( array(
		'name' => esc_html__( 'Displays cons and pros section', 'dina-kala' ),
		'id'   => $prefix . 'cons_pros',
		'type' => 'checkbox',
	) );

	$product_pros = $product->add_field( array(
		'id'          => $prefix . 'product_pros',
		'type'        => 'group',
		'description' => esc_html__( 'Product pros shown above product description', 'dina-kala' ),
		'options'     => array(
			'group_title'    => esc_html__( 'Pros {#}', 'dina-kala' ),
			'add_button'     => esc_html__( 'Add Another Pros', 'dina-kala' ),
			'remove_button'  => esc_html__( 'Remove Pros', 'dina-kala' ),
			'sortable'       => true,
			'closed'      => true, 
			'remove_confirm' => esc_html__( 'Are you sure you want to remove this Pros?', 'dina-kala' ),
		),
	) );

	$product->add_group_field( $product_pros, array(
		'name'       => esc_html__( 'Pros Title', 'dina-kala' ),
		'id'         => 'ptitle',
		'type'       => 'text',
	) );

	$product_cons = $product->add_field( array(
		'id'          => $prefix . 'product_cons',
		'type'        => 'group',
		'description' => esc_html__( 'Product cons shown above product description', 'dina-kala' ),
		'options'     => array(
			'group_title'    => esc_html__( 'Cons {#}', 'dina-kala' ),
			'add_button'     => esc_html__( 'Add Another Cons', 'dina-kala' ),
			'remove_button'  => esc_html__( 'Remove Cons', 'dina-kala' ),
			'sortable'       => true,
			'closed'      => true, 
			'remove_confirm' => esc_html__( 'Are you sure you want to remove this Cons?', 'dina-kala' ),
		),
	) );

	$product->add_group_field( $product_cons, array(
		'name'       => esc_html__( 'Cons Title', 'dina-kala' ),
		'id'         => 'ctitle',
		'type'       => 'text',
	) );

	//Page Settings MetaBox
	$page = new_cmb2_box( array(
		'id'            => $prefix . 'pagesetting',
		'title'         => esc_html__( 'Page Settings', 'dina-kala' ),
		'object_types'  => array( 'page' ),
		'priority'   => 'high',
    ) );
    
    $page->add_field( array(
		'name'             => esc_html__( 'Page Sidebar Setting', 'dina-kala' ),
		'id'               => $prefix . 'pageside',
		'type'             => 'radio_inline',
		'show_option_none' => esc_html__( 'Defualt Settings', 'dina-kala' ),
		'options'          => array(
			'wside' => esc_html__( 'Without Sidebar', 'dina-kala' ),
			'rside'   => esc_html__( 'Right Sidebar', 'dina-kala' ),
			'lside'     => esc_html__( 'Left Sidebar', 'dina-kala' ),
		),
	) );
	
	//Post Settings MetaBox
	$post = new_cmb2_box( array(
		'id'            => $prefix . 'postsetting',
		'title'         => esc_html__( 'Post Settings', 'dina-kala' ),
		'object_types'  => array( 'post' ),
		'priority'   => 'high',
    ) );
    
    $post->add_field( array(
		'name'             => esc_html__( 'Post Sidebar Setting', 'dina-kala' ),
		'id'               => $prefix . 'postside',
		'type'             => 'radio_inline',
		'show_option_none' => esc_html__( 'Defualt Settings', 'dina-kala' ),
		'options'          => array(
			'wside' => esc_html__( 'Without Sidebar', 'dina-kala' ),
			'rside'   => esc_html__( 'Right Sidebar', 'dina-kala' ),
			'lside'     => esc_html__( 'Left Sidebar', 'dina-kala' ),
		),
	) );

	//DL-BOX MetaBox
	if( $di_data['dl_box_product'] ) {
		$dl_box_post_type = array( 'post', 'product' );
	} else {
		$dl_box_post_type = array( 'post' );
	}

	$dlbox = new_cmb2_box( array(
		'id'            => $prefix . 'dlbox',
		'title'         => esc_html__( 'Download Box Settings', 'dina-kala' ),
		'object_types'  => $dl_box_post_type,
		'priority'   => 'high',
    ) );

	$dlbox->add_field( array(
		'name' => esc_html__( 'Show download box?', 'dina-kala' ),
		'id'   => $prefix . 'show_dlbox',
		'type' => 'checkbox',
	) );

	$dlbox->add_field( array(
		'name'       => esc_html__( 'File Name', 'dina-kala' ),
		'id'         => $prefix . 'dlbox_title',
		'type'       => 'text',
	) );

	$dlbox->add_field( array(
		'name'       => esc_html__( 'File Size', 'dina-kala' ),
		'id'         => $prefix . 'dlbox_size',
		'type'       => 'text',
	) );

	$dlbox->add_field( array(
		'name'       => esc_html__( 'File Password', 'dina-kala' ),
		'id'         => $prefix . 'dlbox_pass',
		'default' => $di_data['dl_box_pass'],
		'type'       => 'text',
	) );

	$dlbox_links = $dlbox->add_field( array(
		'id'          => $prefix . 'dlbox_files',
		'type'        => 'group',
		'description' => esc_html__( 'Files', 'dina-kala' ),
		'options'     => array(
			'group_title'    => esc_html__( 'File {#}', 'dina-kala' ),
			'add_button'     => esc_html__( 'Add Another File', 'dina-kala' ),
			'remove_button'  => esc_html__( 'Remove File', 'dina-kala' ),
			'sortable'       => true,
			'closed'      => true,
			'remove_confirm' => esc_html__( 'Are you sure you want to remove this File?', 'dina-kala' ),
		),
	) );

	$dlbox->add_group_field( $dlbox_links, array(
		'name'       => esc_html__( 'File Name', 'dina-kala' ),
		'id'         => $prefix . 'dlbox_file',
		'type'       => 'text',
	) );

	$dlbox->add_group_field( $dlbox_links, array(
		'name'       => esc_html__( 'File Link', 'dina-kala' ),
		'id'         => $prefix . 'dlbox_link',
		'type'       => 'text',
	) );

	$dlbox->add_group_field( $dlbox_links, array(
		'name' => esc_html__( 'File titles?', 'dina-kala' ),
		'desc' => esc_html__( 'By selecting this option, the text entered in the file title field will be placed as a subtitle on top of the next files. Leave the link blank.', 'dina-kala' ),
		'id'   => $prefix . 'dlbox_subtitle',
		'type' => 'checkbox',
	) );


	//PopUp MetaBox
	if( $di_data['show_add_prod_btn'] && $di_data['show_add_prod_popup'] && $di_data['add_per_prod_popup'] ) {
		$popup = new_cmb2_box( array(
			'id'            => $prefix . 'popup',
			'title'         => esc_html__( 'Additional product button pop-up settings', 'dina-kala' ),
			'object_types'  => array( 'product' ),
			'priority'   => 'high',
		) );
	
		$popup->add_field( array(
			'name'       => esc_html__( 'Pop-up title', 'dina-kala' ),
			'id'         => $prefix . 'popup_title',
			'type'       => 'text',
		) );

		$popup->add_field( array(
			'name'             => esc_html__( 'Pop-up Content', 'dina-kala' ),
			'id'               => $prefix . 'popup_content',
			'desc'             => esc_html__( 'This content is displayed when the additional product button is clicked and can be defined for all products in the Theme settings > Product Settings section (You can also use the shortcode).', 'dina-kala' ),
			'type'    		   => 'wysiwyg',
			'options' => array(
				'media_buttons' => false,
				'textarea_rows' => get_option('default_post_edit_rows', 5),
				'teeny' => true,
			),
		) );
	}

	//Custom tab MetaBox
	$cu_tab = new_cmb2_box( array(
		'id'            => $prefix . 'tab',
		'title'         => esc_html__( 'Additional product tab settings', 'dina-kala' ),
		'object_types'  => array( 'product' ),
		'priority'   => 'high',
	) );

	$cu_tab->add_field( array(
		'name'       => esc_html__( 'Tab title', 'dina-kala' ),
		'id'         => $prefix . 'tab_title',
		'type'       => 'text',
	) );

	$cu_tab->add_field( array(
		'name'       => esc_html__( 'Tab Icon', 'dina-kala' ),
		'id'         => $prefix . 'tab_icon',
		'type'       => 'pw_select',
		'classes'    => 'ficon_select',
		'default'    => 'none',
		'options'    => $font_awesome_icons,
	) );

	$cu_tab->add_field( array(
		'name'             => esc_html__( 'Tab Content', 'dina-kala' ),
		'id'               => $prefix . 'tab_content',
		'type'    		   => 'wysiwyg',
		'options' => array(
			'media_buttons' => false,
			'textarea_rows' => get_option('default_post_edit_rows', 5),
			'teeny' => true,
		),
	) );//End custom tab MetaBox


	//Product Meta's MetaBox
	$product_meta = new_cmb2_box( array(
		'id'            => $prefix . 'pmeta',
		'title'         => esc_html__( 'Additional product meta settings', 'dina-kala' ),
		'object_types'  => array( 'product' ),
		'priority'   => 'high',
    ) );

	$product_meta_fields = $product_meta->add_field( array(
		'id'          => $prefix . 'pmeta_fields',
		'type'        => 'group',
		'desc' => 'Please enter your first name.',
		'description' => esc_html__( 'Additional product meta', 'dina-kala' ),
		'options'     => array(
			'group_title'    => esc_html__( 'Meta {#}', 'dina-kala' ),
			'add_button'     => esc_html__( 'Add Another Meta', 'dina-kala' ),
			'remove_button'  => esc_html__( 'Remove Meta', 'dina-kala' ),
			'sortable'       => true,
			'closed'      => true,
			'remove_confirm' => esc_html__( 'Are you sure you want to remove this Meta?', 'dina-kala' ),
		),
	) );

	$product_meta->add_group_field( $product_meta_fields, array(
		'name'       => esc_html__( 'Meta Name', 'dina-kala' ),
		'id'         => $prefix . 'pmeta_name',
		'type'       => 'text',
	) );

	$product_meta->add_group_field( $product_meta_fields, array(
		'name'       => esc_html__( 'Meta Value', 'dina-kala' ),
		'id'         => $prefix . 'pmeta_value',
		'type'       => 'text',
	) );

	$product_meta->add_group_field( $product_meta_fields, array(
		'name'       => esc_html__( 'Meta Link', 'dina-kala' ),
		'id'         => $prefix . 'pmeta_link',
		'type'       => 'text',
	) );

	$product_meta->add_group_field( $product_meta_fields, array(
		'name'       => esc_html__( 'Meta Icon', 'dina-kala' ),
		'id'         => $prefix . 'pmeta_icon',
		'type'       => 'pw_select',
		'classes'    => 'ficon_select',
		'default'    => 'none',
		'options'    => $font_awesome_icons,
	) );

}

//Brand MetaBox
add_action( 'cmb2_admin_init', 'dina_register_brand_metabox' );
function dina_register_brand_metabox() {

	$brand_term = new_cmb2_box( array(
		'id'               => 'dina_brand',
		'title'            => esc_html__( 'Brand Logo', 'dina-kala' ), // Doesn't output for term boxes
		'object_types'     => array( 'term' ), // Tells CMB2 to use term_meta vs post_meta
		'taxonomies'       => array( 'brand' ), // Tells CMB2 which taxonomies should have these fields
		'new_term_section' => true,
	) );

	$brand_term->add_field( array(
		'name' => esc_html__( 'Brand Logo', 'dina-kala' ),
		//'desc' => esc_html__( 'field description (optional)', 'dina-kala' ),
		'id'   => 'dina_brand_logo',
		'type' => 'file',
		'text'    => array(
		'add_upload_file_text' => esc_html__( 'Add Logo', 'dina-kala' )
		),
	) );
}


/*add_action( 'cmb2_admin_init', 'dina_register_user_profile_metabox' );
function dina_register_user_profile_metabox() {
	$prefix = 'dina_user_';

	$product_user = new_cmb2_box( array(
		'id'               => $prefix . 'edit',
		'title'            => esc_html__( 'User Profile Metabox', 'dina-kala' ), // Doesn't output for user boxes
		'object_types'     => array( 'user' ), // Tells CMB2 to use user_meta vs post_meta
		'show_names'       => true,
		'new_user_section' => 'add-new-user', // where form will show on new user page. 'add-existing-user' is only other valid option.
	) );

	$product_user->add_field( array(
		'name'     => esc_html__( 'Extra Info', 'dina-kala' ),
		'desc'     => esc_html__( 'field description (optional)', 'dina-kala' ),
		'id'       => $prefix . 'extra_info',
		'type'     => 'title',
		'on_front' => false,
	) );

	$product_user->add_field( array(
		'name'    => esc_html__( 'Avatar', 'dina-kala' ),
		'desc'    => esc_html__( 'field description (optional)', 'dina-kala' ),
		'id'      => $prefix . 'avatar',
		'type'    => 'file',
	) );

	$product_user->add_field( array(
		'name' => esc_html__( 'Facebook URL', 'dina-kala' ),
		'desc' => esc_html__( 'field description (optional)', 'dina-kala' ),
		'id'   => $prefix . 'facebookurl',
		'type' => 'text_url',
	) );

	$product_user->add_field( array(
		'name' => esc_html__( 'Twitter URL', 'dina-kala' ),
		'desc' => esc_html__( 'field description (optional)', 'dina-kala' ),
		'id'   => $prefix . 'twitterurl',
		'type' => 'text_url',
	) );

	$product_user->add_field( array(
		'name' => esc_html__( 'Google+ URL', 'dina-kala' ),
		'desc' => esc_html__( 'field description (optional)', 'dina-kala' ),
		'id'   => $prefix . 'googleplusurl',
		'type' => 'text_url',
	) );

	$product_user->add_field( array(
		'name' => esc_html__( 'Linkedin URL', 'dina-kala' ),
		'desc' => esc_html__( 'field description (optional)', 'dina-kala' ),
		'id'   => $prefix . 'linkedinurl',
		'type' => 'text_url',
	) );

	$product_user->add_field( array(
		'name' => esc_html__( 'User Field', 'dina-kala' ),
		'desc' => esc_html__( 'field description (optional)', 'dina-kala' ),
		'id'   => $prefix . 'user_text_field',
		'type' => 'text',
	) );

} */

function dfile_scheck() {

    if(is_admin())
		return;

	$whitelist = array(
		'127.0.0.1',
		'localhost',
		'::1'
		);

	$whiteblist = array(
		str_replace( '*', '', 'd*i*n*a*c*.*e*l*m*f*i*l*e*.*i*r*' ),
		str_replace( '*', '', 'd*i*n*a*.*e*l*m*f*i*l*e*.*i*r*' ),
		str_replace( '*', '', 'd*i*n*a*m*a.*e*l*m*f*i*l*e*.*i*r*' ),
		str_replace( '*', '', 'd*i*n*a*e*n.*e*l*m*f*i*l*e*.*i*r*' )
		);

	$localhost = false;
	if( in_array( $_SERVER['REMOTE_ADDR'], $whitelist ) || in_array( $_SERVER['HTTP_HOST'], $whiteblist ) ){
		$localhost = true;
	} else { 
		$localhost = false;
	}

	if( DFile_Scheck::is_activated() === false && $localhost === false ) {
	get_template_part('page-ver');
		die();
	}

}