<?php
namespace Elementor;

class Our_Service_Box extends Widget_Base {
	
	public function get_name() {
		return 'our-service-box';
	}
	
	public function get_title() {
		return __( 'Our Service Box', 'dina-kala' );
	}
	
	public function get_icon() {
		return 'fal fa-th-large';
	}
	
	public function get_categories() {
		return [ 'dina-kala' ];
	}
	
	protected function _register_controls() {
		require get_template_directory() . '/includes/el-widgets/fa.php';
		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Our Service Box', 'dina-kala' ),
			]
		);
		
		$this->add_control(
			'title_one',
			[
				'label' => __( 'Title One', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your title', 'dina-kala' ),
                'default' => __( 'Price Guarantee', 'dina-kala' ),
			]
		);

		$this->add_control(
			'subtitle_one',
			[
				'label' => __( 'Subtitle One', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your subtitle', 'dina-kala' ),
                'default' => __( 'Best market price', 'dina-kala' ),
			]
		);
		
		$this->add_control(
			'link_one',
			[
				'label' => __( 'Link one', 'dina-kala' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'dina-kala' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
        );
		
		$this->add_control(
			'icon_one',
			[
				'label' => __( 'Icon One', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'credit-card '
			]
		);
		$this->add_control(
			'custom_icon_one',
			[
				'label' => __( 'Or custom icon (Suitable size: 64px by 64px)', 'dina-kala' ),
				'type' => Controls_Manager::MEDIA,
			]
		);
        
        $this->add_control(
			'title_two',
			[
				'label' => __( 'Title Two', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your title', 'dina-kala' ),
                'default' => __( 'Excellent support', 'dina-kala' ),
			]
		);

		$this->add_control(
			'subtitle_two',
			[
				'label' => __( 'Subtitle Two', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your subtitle', 'dina-kala' ),
                'default' => __( '24 hours, 7 days a week', 'dina-kala' ),
			]
		);
		
		$this->add_control(
			'link_two',
			[
				'label' => __( 'Link two', 'dina-kala' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'dina-kala' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
        );
		
		$this->add_control(
			'icon_two',
			[
				'label' => __( 'Icon Two', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'headset '
			]
		);
		$this->add_control(
			'custom_icon_two',
			[
				'label' => __( 'Or custom icon (Suitable size: 64px by 64px)', 'dina-kala' ),
				'type' => Controls_Manager::MEDIA,
			]
		);
        
        $this->add_control(
			'title_three',
			[
				'label' => __( 'Title Three', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your title', 'dina-kala' ),
                'default' => __( 'Refund', 'dina-kala' ),
			]
		);

		$this->add_control(
			'subtitle_three',
			[
				'label' => __( 'Subtitle Three', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your subtitle', 'dina-kala' ),
                'default' => __( 'If not satisfied', 'dina-kala' ),
			]
		);
		
		$this->add_control(
			'link_three',
			[
				'label' => __( 'Link three', 'dina-kala' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'dina-kala' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
        );
        
		$this->add_control(
			'icon_three',
			[
				'label' => __( 'Icon Three', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'history '
			]
		);
		$this->add_control(
			'custom_icon_three',
			[
				'label' => __( 'Or custom icon (Suitable size: 64px by 64px)', 'dina-kala' ),
				'type' => Controls_Manager::MEDIA,
			]
		);
        
        $this->add_control(
			'title_four',
			[
				'label' => __( 'Title Four', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your title', 'dina-kala' ),
                'default' => __( 'Originality goods', 'dina-kala' ),
			]
		);

		$this->add_control(
			'subtitle_four',
			[
				'label' => __( 'Subtitle Four', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your subtitle', 'dina-kala' ),
                'default' => __( 'From Top Brands', 'dina-kala' ),
			]
		);
		
		$this->add_control(
			'link_four',
			[
				'label' => __( 'Link four', 'dina-kala' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'dina-kala' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
        );
		
		$this->add_control(
			'icon_four',
			[
				'label' => __( 'Icon Four', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'certificate '
			]
		);
		$this->add_control(
			'custom_icon_four',
			[
				'label' => __( 'Or custom icon (Suitable size: 64px by 64px)', 'dina-kala' ),
				'type' => Controls_Manager::MEDIA,
			]
		);
        
        $this->add_control(
			'title_five',
			[
				'label' => __( 'Title Five', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your title', 'dina-kala' ),
                'default' => __( 'Fast delivery', 'dina-kala' ),
			]
		);

		$this->add_control(
			'subtitle_five',
			[
				'label' => __( 'Subtitle Five', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter your subtitle', 'dina-kala' ),
                'default' => __( 'The least time possible', 'dina-kala' ),
			]
		);
		
		$this->add_control(
			'link_five',
			[
				'label' => __( 'Link five', 'dina-kala' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'dina-kala' ),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
			]
        );

		$this->add_control(
			'icon_five',
			[
				'label' => __( 'Icon Five', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
				'default' => 'shipping-fast '
			]
		);
		$this->add_control(
			'custom_icon_five',
			[
				'label' => __( 'Or custom icon (Suitable size: 64px by 64px)', 'dina-kala' ),
				'type' => Controls_Manager::MEDIA,
			]
		);

		$this->end_controls_section();
	}
	
	protected function render() {

        $settings = $this->get_settings_for_display();
        
		?>
		<!-- Services -->
            <div class="row services">

				<?php if( !empty( $settings['title_one'] ) ) { ?>
                <div class="col">
                    <div class="service shadow-box">
						<?php if( !empty( $settings['link_one']['url'] ) ) { ?>
							<a href="<?php echo $settings['link_one']['url']; ?>" title="<?php echo $settings['title_one']; ?>">
						<?php } ?>
							<div class="col-lg-3 col-12 service-icon">
								<?php if( !empty( $settings['custom_icon_one']['url'] ) ){ ?>
									<img src="<?php echo $settings['custom_icon_one']['url']; ?>" width="64" height="64" alt="<?php echo $settings['title_one']; ?>" class="ser-cust-icon">
								<?php } else { ?>
									<i class="fal fa-<?php echo $settings['icon_one']; ?>" aria-hidden="true"></i>
								<?php } ?>
							</div>
							<div class="col-lg-9 col-12 service-det">
								<span class="service-title"><?php echo $settings['title_one']; ?></span>
								<span class="service-desc d-none d-lg-block"><?php echo $settings['subtitle_one']; ?></span>
							</div>
						<?php if( !empty( $settings['link_one']['url'] ) ) { ?>
							</a>
						<?php } ?>
                    </div>
				</div>
				<?php } ?>

				<?php if( !empty( $settings['title_two'] ) ) { ?>
                <div class="col">
                    <div class="service shadow-box">
						<?php if( !empty( $settings['link_two']['url'] ) ) { ?>
							<a href="<?php echo $settings['link_two']['url']; ?>" title="<?php echo $settings['title_two']; ?>">
						<?php } ?>
							<div class="col-lg-3 col-12 service-icon">
								<?php if( !empty( $settings['custom_icon_two']['url'] ) ){ ?>
									<img src="<?php echo $settings['custom_icon_two']['url']; ?>" width="64" height="64" alt="<?php echo $settings['title_two']; ?>" class="ser-cust-icon">
								<?php } else { ?>
									<i class="fal fa-<?php echo $settings['icon_two']; ?>" aria-hidden="true"></i>
								<?php } ?>
							</div>
							<div class="col-lg-9 col-12 service-det">
								<span class="service-title"><?php echo $settings['title_two']; ?></span>
								<span class="service-desc d-none d-lg-block"><?php echo $settings['subtitle_two']; ?></span>
							</div>
						<?php if( !empty( $settings['link_two']['url'] ) ) { ?>
							</a>
						<?php } ?>
                    </div>
				</div>
				<?php } ?>

				<?php if( !empty( $settings['title_three'] ) ) { ?>
                <div class="col">
                    <div class="service shadow-box">
						<?php if( !empty( $settings['link_three']['url'] ) ) { ?>
							<a href="<?php echo $settings['link_three']['url']; ?>" title="<?php echo $settings['title_three']; ?>">
						<?php } ?>
							<div class="col-lg-3 col-12 service-icon">
								<?php if( !empty( $settings['custom_icon_three']['url'] ) ){ ?>
									<img src="<?php echo $settings['custom_icon_three']['url']; ?>" width="64" height="64" alt="<?php echo $settings['title_three']; ?>" class="ser-cust-icon">
								<?php } else { ?>
									<i class="fal fa-<?php echo $settings['icon_three']; ?>" aria-hidden="true"></i>
								<?php } ?>
							</div>
							<div class="col-lg-9 col-12 service-det">
								<span class="service-title"><?php echo $settings['title_three']; ?></span>
								<span class="service-desc d-none d-lg-block"><?php echo $settings['subtitle_three']; ?></span>
							</div>
						<?php if( !empty( $settings['link_three']['url'] ) ) { ?>
							</a>
						<?php } ?>						
                    </div>
				</div>
				<?php } ?>

				<?php if( !empty( $settings['title_four'] ) ) { ?>
                <div class="col">
                    <div class="service shadow-box">
						<?php if( !empty( $settings['link_four']['url'] ) ) { ?>
							<a href="<?php echo $settings['link_four']['url']; ?>" title="<?php echo $settings['title_four']; ?>">
						<?php } ?>
							<div class="col-lg-3 col-12 service-icon">
								<?php if( !empty( $settings['custom_icon_four']['url'] ) ){ ?>
									<img src="<?php echo $settings['custom_icon_four']['url']; ?>" width="64" height="64" alt="<?php echo $settings['title_four']; ?>" class="ser-cust-icon">
								<?php } else { ?>
									<i class="fal fa-<?php echo $settings['icon_four']; ?>" aria-hidden="true"></i>
								<?php } ?>
							</div>
							<div class="col-lg-9 col-12 service-det">
								<span class="service-title"><?php echo $settings['title_four']; ?></span>
								<span class="service-desc d-none d-lg-block"><?php echo $settings['subtitle_four']; ?></span>
							</div>
						<?php if( !empty( $settings['link_four']['url'] ) ) { ?>
							</a>
						<?php } ?>
                    </div>
				</div>
				<?php } ?>

				<?php if( !empty( $settings['title_five'] ) ) { ?>
                <div class="col">
                    <div class="service shadow-box">
						<?php if( !empty( $settings['link_five']['url'] ) ) { ?>
							<a href="<?php echo $settings['link_five']['url']; ?>" title="<?php echo $settings['title_five']; ?>">
						<?php } ?>
							<div class="col-lg-3 col-12 service-icon">
								<?php if( !empty( $settings['custom_icon_five']['url'] ) ){ ?>
									<img src="<?php echo $settings['custom_icon_five']['url']; ?>" width="64" height="64" alt="<?php echo $settings['title_five']; ?>" class="ser-cust-icon">
								<?php } else { ?>
									<i class="fal fa-<?php echo $settings['icon_five']; ?>" aria-hidden="true"></i>
								<?php } ?>
							</div>
							<div class="col-lg-9 col-12 service-det">
								<span class="service-title"><?php echo $settings['title_five']; ?></span>
								<span class="service-desc d-none d-lg-block"><?php echo $settings['subtitle_five']; ?></span>
							</div>
						<?php if( !empty( $settings['link_five']['url'] ) ) { ?>
							</a>
						<?php } ?>
                    </div>
				</div>
				<?php } ?>

            </div>
        <!-- Services --> <?php

	}

}