<?php
namespace Elementor;

class Ads_Image extends Widget_Base {
	
	public function get_name() {
		return 'ads-image';
	}
	
	public function get_title() {
		return __( 'Ads image', 'dina-kala' );
	}
	
	public function get_icon() {
		return 'fal fa-image';
	}
	
	public function get_categories() {
		return [ 'dina-kala' ];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Ads image', 'dina-kala' ),
			]
		);
		
		$this->add_control(
			'img_title',
			[
				'label' => __( 'Image title', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => __( 'Enter image title', 'dina-kala' ),
                'default' => __( '#', 'dina-kala' ),
			]
        );
        
        $this->add_control(
			'img_link',
			[
				'label' => __( 'Image link', 'dina-kala' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'dina-kala' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => true,
					'nofollow' => true,
				],
			]
        );

		$this->add_control(
			'hover_effect',
			[
				'label' => __( 'Image hover effect', 'dina-kala' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'dina-brightness',
				'options' => [
					'none'  => __( 'None', 'dina-kala' ),
					'dina-brightness'  => __( 'Brightness', 'dina-kala' ),
					'dina-zoomin' => __( 'Zoom In', 'dina-kala' ),
					'dina-rotate' => __( 'Rotate', 'dina-kala' ),
					'dina-blur' => __( 'Blur', 'dina-kala' ),
					'dina-gray' => __( 'Gray Scale', 'dina-kala' ),
					'dina-opacity' => __( 'Opacity', 'dina-kala' ),
					'dina-flash' => __( 'Flashing', 'dina-kala' ),
					'dina-shine' => __( 'Shine', 'dina-kala' ),
					'dina-circle' => __( 'Circle', 'dina-kala' )
				],
			]
		);

		$this->add_control(
			'hover_title',
			[
				'label' => __( 'Show image title on mouse hover', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
        
        $this->add_control(
			'image',
			[
				'label' => __( 'Choose Image', 'dina-kala' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
        
		$this->end_controls_section();
	}
	
	protected function render() {
        $settings = $this->get_settings_for_display();
        $target = $settings['img_link']['is_external'] ? ' target="_blank"' : '';
		$nofollow = $settings['img_link']['nofollow'] ? ' rel="nofollow"' : '';
        $hover_effect = $settings['hover_effect'];
        $hover_title = $settings['hover_title'];
        $img_title = $settings['img_title'];
		?>
        <div class="bnr-image shadow-box <?php echo $hover_effect; ?>">
            <a href="<?php echo $settings['img_link']['url']; ?>" title="<?php echo $settings['img_title']; ?>"<?php if(!empty($target)) { echo $target;} ?> <?php if(!empty($nofollow)) { echo $nofollow;} ?>>

				<?php if($hover_title === 'yes') { ?>
					<span class="bnr-hover-title">
						<span>
							<?php echo $img_title; ?>
						</span>
					</span>
				<?php } ?>

				<?php $image_attributes = wp_get_attachment_image_src( $settings['image']['id'], 'full'); ?>
                <img src="<?php echo $settings['image']['url']; ?>" alt="<?php echo $img_title; ?>" width="<?php echo $image_attributes[1]; ?>" height="<?php echo $image_attributes[2]; ?>">

            </a>
        </div>
        <?php
	}
}