<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: Hosseinkhani.ir
*/
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}
global $di_data;
dfile_scheck();
if (!current_user_can('administrator'))
	{
	if ($di_data['maintenance'])
		{
		get_template_part('under-page');
		die();
		}
	}
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>

    <head>
        <link rel="shortcut icon" href="<?php echo $di_data['site_favicon']['url']; ?>" type="image/x-icon" />
        <meta http-equiv="Content-Type" content="text/html; charset=<?php bloginfo('charset'); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta http-equiv="X-UA-Compatible" content="ie=edge">
        <?php if(!$di_data['dis_mobile_color']) { ?>
        <meta name="theme-color" content="<?php echo $di_data['custom_color']; ?>" />
        <?php } ?>
        <meta name="fontiran.com:license" content="B3L8B">
        <?php if (is_singular()) { wp_enqueue_script('comment-reply'); } ?>
        <link rel="alternate" type="appliction/rss+xml" href="<?php bloginfo('rss2_url'); ?>" title="<?php printf(__('Latest Articles %s', 'dina-kala') , esc_html(get_bloginfo('name') , 1)); ?>" />
        <link rel="alternate" type="appliction/rss+xml" href="<?php bloginfo('comments_rss2_url'); ?>" title="<?php printf(__('Last comments %s', 'dina-kala') , esc_html(get_bloginfo('name') , 1)); ?>" />
        <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
        <?php wp_head(); ?>
    </head>
    
    <body <?php body_class(); ?> <?php if($di_data['site_schema']) {?>itemscope itemtype="https://schema.org/WebPage"
    <?php } ?>>

    <?php 
        if ( function_exists( 'wp_body_open' ) ) {
            wp_body_open();
        } else {
            do_action( 'wp_body_open' );
        }
    ?>

    <?php
    // Elementor header location
    if ( ! function_exists( 'elementor_theme_do_location' ) || ! elementor_theme_do_location( 'header' ) ) {
        get_template_part( 'template-parts/header' );
    }