<?php
/**
 *  Dashboard Widget Template
 *
 *  Dashboard Big Counter widget template
 *
 *  @since 2.4
 *
 *  @author weDevs <info@wedevs.com>
 *
 *  @package dokan
 */
?>
<div class="dashboard-widget big-counter">
    <ul class="list-inline">
         <li>
            <div class="key_wrapper">
                <div class="title"><?php esc_html_e( 'Sales', 'dokan-lite' ); ?></div>
                <div class="count"><?php echo wc_price( $earning ); ?></div>
                <span class="fal fa-dollar-sign" aria-hidden="true"></span>
            </div>
        </li>
        <li>
            <div class="key_wrapper">
                <div class="title"><?php esc_html_e( 'Earning', 'dokan-lite' ); ?></div>
                <div class="count"><?php echo dokan_get_seller_earnings( dokan_get_current_user_id() ); ?></div>
                <span class="fal fa-sack-dollar" aria-hidden="true"></span>
            </div>
        </li>
        <li>
            <div class="key_wrapper">
                <div class="title"><?php esc_html_e( 'Pageview', 'dokan-lite' ); ?></div>
                <div class="count"><?php echo dokan_number_format( esc_attr( $pageviews ) ); ?></div>
                <span class="fal fa-file-invoice" aria-hidden="true"></span>
            </div>
        </li>
        <li>
            <div class="key_wrapper">
                <div class="title"><?php esc_html_e( 'Order', 'dokan-lite' ); ?></div>
                <div class="count">
                    <?php
                    $status = dokan_withdraw_get_active_order_status();
                    $total = 0;
                    foreach ( $status as $order_status ){
                        $total += $orders_count->$order_status;
                    }
                    echo esc_html( number_format_i18n( $total, 0 ) );
                    ?>
                </div>
                <span class="fal fa-bags-shopping" aria-hidden="true"></span>
            </div>
        </li>

        <?php do_action( 'dokan_seller_dashboard_widget_counter' ); ?>
    </ul>
</div> <!-- .big-counter -->
