<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: Hosseinkhani.ir
*/
// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}
global $di_data;
get_header(); 
$pside = get_post_meta( get_the_ID(), 'dina_postside', true );
$content_sticky = ($di_data['side_sticky'] ? ' content-sticky' : '');
if($pside == '') {
    if($di_data['post_side']==0) {
        $row = '';
        $article = 'col-12'.$content_sticky;
    } elseif($di_data['post_side']==1) {
        $row = '';
        $article = 'col-lg-9 col-12'.$content_sticky;
    } elseif($di_data['post_side']==2){
        $row = ' right-side';
        $article = 'col-lg-9 col-12'.$content_sticky;
    }
} elseif($pside == 'lside') {
    $row = '';
    $article = 'col-lg-9 col-12'.$content_sticky;
} elseif($pside == 'rside') {
    $row = ' right-side';
    $article = 'col-lg-9 col-12'.$content_sticky;
} elseif ($pside == 'wside') {
    $row = '';
    $article = 'col-12'.$content_sticky;
}
?>

<div class="container main-con">

<?php if($di_data['show_bread']) { woocommerce_breadcrumb(); }  

if ($di_data['show_head_banner']) { dina_header_banner(); } ?>

<div class="row post-row<?php echo $row; ?>">
<?php if ( have_posts() ) : ?>
<article role="main" class="<?php echo $article; ?>" <?php if($di_data['site_schema'] ) {?>itemscope itemtype="https://schema.org/BlogPosting" <?php } ?>>
<?php while ( have_posts() ) : the_post(); ?>
    <?php if($di_data['site_schema']) {?>
        <link itemprop="mainEntityOfPage" href="<?php the_permalink(); ?>" />
        <meta itemprop="image" content="<?php the_post_thumbnail_url(); ?>">
        <span itemprop="publisher" itemscope itemtype="https://schema.org/Organization">
            <span itemprop="logo" itemscope itemtype="https://schema.org/ImageObject">
                <meta itemprop="url" content="<?php echo $di_data['site_logo']['url']; ?>">
                <meta itemprop="width" content="140">
                <meta itemprop="height" content="60">
            </span>
            <meta itemprop="name" content="<?php bloginfo('name'); ?>">
        </span>
    <?php } ?>

    <?php if ( $di_data['show_post_top_banner'] && !empty( $di_data['post_top_banner']['url'] ) ) { ?>

    <div class="post-top-banner-row<?php if (!$di_data['show_post_top_mobile']) { echo ' mobile-hidden'; }?>">
        <div class="col-12 bnr-image shadow-box">
            <a href="<?php echo $di_data['post_top_banner_link']; ?>" title="<?php echo $di_data['post_top_banner_title']; ?>" aria-label="<?php echo $di_data['post_top_banner_title']; ?>">
                <?php
                    $headb_width = (!empty($di_data['post_top_banner']['width'])) ? $di_data['post_top_banner']['width'] : '1260';
                    $headb_height = (!empty($di_data['post_top_banner']['height'])) ? $di_data['post_top_banner']['height'] : '142'; 
                ?>
                <img src="<?php echo $di_data['post_top_banner']['url']; ?>" alt="<?php echo $di_data['post_top_banner_title']; ?>" class="head-banner shadow-box" width="<?php echo $headb_width; ?>" height="<?php echo $headb_height; ?>" />
            </a>
        </div>
    </div>

    <?php } ?>

    <div <?php post_class('shadow-box post-con'); ?> id="post-<?php the_ID(); ?>">
        <h1 class="ptitle" <?php if($di_data['site_schema']) {?>itemprop="headline"<?php } ?>>
            <?php the_title(); ?>
        </h1>
        <div class="row post-det">

            <div class="col-md-4 col-12 post-aut">
                <a class="author-link" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>">
                    <?php 
                        $author = get_post_field( 'post_author', get_the_ID() );
                        echo get_avatar($author , 32, '' , get_the_author_meta('display_name',$author )); 
                        echo get_the_author_meta('display_name',$author );
                    ?>
                </a>
                <?php if($di_data['site_schema']) { echo '<meta itemprop="editor" content="'.get_the_author_meta('display_name',$author ).'">'; } ?>
            </div>

            <div class="col-md-5 col-12 post-date">
                <i class="fal fa-calendar-alt" aria-hidden="true"></i>
                <?php if($di_data['site_schema']) { ?>
                    <time datetime="<?php echo get_the_date('Y-m-d');?>" itemprop="datePublished">
                <?php } ?>
                <?php echo get_jdate_publish_time(); ?>
                <?php
                if( $di_data['show_post_up'] ) {
                    $modi_date = get_the_modified_time('j F Y');
                    printf( esc_html__( '(Update on: %s)', 'dina-kala' ), $modi_date );
                } ?>
                <?php if($di_data['site_schema']) { ?>
                    </time>
                <?php } ?>
                <?php if($di_data['site_schema']) { ?>
                    <meta content="<?php echo get_the_date('Y-m-d');?>" itemprop="dateModified">
                <?php } ?>
            </div>

            <?php setPostViews(get_the_ID()); ?>
            <?php if ($di_data['show_post_view']) { ?>
            <div class="col-md-3 col-12 post-views">
                <i class="fal fa-eye" aria-hidden="true"></i>
                <?php echo getPostViews(get_the_ID()); ?> <?php _e('View','dina-kala') ?>
            </div>
            <?php } ?>
            
        </div>
        <div class="post-content entry-content" <?php if($di_data['site_schema'] ) {?>itemprop="articleBody" <?php } ?>>
            <?php if($di_data['site_schema']) { echo '<meta itemprop="author" content="'.get_the_author_meta('display_name',$author ).'">'; } ?>
            <?php if ( has_post_thumbnail() && $di_data['show_post_thumb']) { ?>
                <div class="post-img">
                    <?php the_post_thumbnail('larg'); ?>
                </div>
            <?php } ?>
            <?php
            if($di_data['show_more_s']) { ?>
                <div class="post-sh dina-more-less" data-more="<?php _e('Show More','dina-kala'); ?>" data-less="<?php _e('Show Less','dina-kala'); ?>">
            <?php } ?>
            <?php the_content(); ?>

            <?php
            //Start Post Download Box
            $show_dlbox = get_post_meta( get_the_ID(), 'dina_show_dlbox', true );

            if($show_dlbox) {
                $dlbox_title = get_post_meta( get_the_ID(), 'dina_dlbox_title', true );
                $dlbox_size = get_post_meta( get_the_ID(), 'dina_dlbox_size', true );
                $dlbox_pass = get_post_meta( get_the_ID(), 'dina_dlbox_pass', true );
                $dlbox_files = get_post_meta( get_the_ID(), 'dina_dlbox_files', true ); ?>

                <div class="dlbox">
                    <div class="dltitle">
                        <i class="fal fa-cloud-download"></i><?php echo $dlbox_title; ?>
                    </div>

                    <div class="dlbox-links">
                        <?php 
                        if ( !empty( $dlbox_files ) ) {
                            foreach ( (array) $dlbox_files as $key => $file ) {
                                if (isset( $file['dina_dlbox_subtitle'] ) && $file['dina_dlbox_subtitle']) {
                                    $file_name = esc_html($file['dina_dlbox_file']);
                                    if(!empty($file_name)) {
                                        echo '<div class="plain">'.$file_name.'</div>';
                                    }
                                } else {
                                    $file_name = esc_html($file['dina_dlbox_file']);
                                    $file_link = esc_html($file['dina_dlbox_link']); 
                                    if(!empty($file_name) && !empty($file_link)) {
                                        echo '<a href="'.$file_link.'" title="'.$file_name.'" class="flink"><i class="fal fa-download"></i>'.$file_name.'</a>';
                                    }
                                }
                            }
                        } ?>
                    </div>

                    <div class="row fdet">

                        <?php if( !empty($dlbox_size) ) { ?>
                        <div class="col-md-4 sdet">
                            <i class="fal fa-save"></i>
                            <span aria-hidden="true">
                                <?php _e('File size:', 'dina-kala'); ?>
                                <?php echo $dlbox_size; ?>
                            </span>
                        </div>
                        <?php } ?>

                        <?php if( !empty($dlbox_pass) ) { ?>
                        <div class="col-md-4 sdet">
                            <i class="fal fa-lock"></i>
                            <span aria-hidden="true">
                            <?php _e('Password:', 'dina-kala'); ?>
                            <?php echo $dlbox_pass; ?>
                            </span>
                        </div>
                        <?php } ?>

                        <?php if( !empty($di_data['dl_guide_text']) ) { ?>
                        <div class="col-md-4 sdet">
                            <span class="dhelp" data-toggle="modal" data-target="#dhelp">
                                <i class="fal fa-question-circle"></i>
                                <span aria-hidden="true">
                                    <?php _e('Download guide', 'dina-kala'); ?>
                                </span>
                            </span>
                        </div>
                        <?php } ?>

                    </div>

                    <?php if( !empty($di_data['dl_guide_text']) ) { ?>
                    <!-- Dl-Box Help Modal -->
                    <div class="modal fade dhelp-modal" id="dhelp">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">
                                <i class="fal fa-question-circle"></i>
                                <?php echo $di_data['dl_guide_title']; ?>
                            </h4>
                            <button type="button" class="close" data-dismiss="modal">
                                <i class="fal fa-times" aria-hidden="true"></i>
                            </button>
                        </div>
                        <div class="modal-body">
                            <?php echo $di_data['dl_guide_text']; ?>
                        </div>
                        </div>
                    </div>
                    </div>
                    <!-- Dl-Box Help Modal -->
                    <?php } ?>

                </div>
            <?php } 
            //End Post Download Box
            ?>

            <?php 
            if($di_data['show_more_s']) {
                echo '</div>';
            } ?>
        </div>  
        <?php
        $defaults = array(
            'before'           => '<div class="text-center apage-break">',
            'after'            => '</div>',
            'link_before'      => '',
            'link_after'       => '',
            'next_or_number'   => 'text',
            'separator'        => ' ',
            'nextpagelink'     => '<span class="btn btn-outline-info">'.__('Next Page ', 'dina-kala').'<i aria-hidden="true" class="fal fa-angle-left"></i></span>',
            'previouspagelink' => '<span class="btn btn-outline-info"><i aria-hidden="true" class="fal fa-angle-right"></i>'.__(' Prev Page', 'dina-kala').'</span>',
            'pagelink'         => '%',
            'echo'             => 1
        );
        wp_link_pages($defaults); ?>
        <div class="row post-det">
            <?php if ($di_data['show_post_tags']) { ?>
            <div class="col-12 post-tags">
                <?php the_tags('<span class="fal fa-tags" aria-hidden="true"></span>'.__(' Tags ','dina-kala'), '&nbsp;', ''); ?>
            </div>
            <?php } ?>
            <?php if ($di_data['show_post_cats']) { ?>
            <div class="col-md-6 col-12 post-cats">
                <i class="fal fa-folder-open" aria-hidden="true"></i>
                <?php _e('Category','dina-kala') ?>
                <?php the_category( '&nbsp;' ); ?>
            </div>
            <?php } ?>
            <?php if ($di_data['share_post']) { ?>
            <div class="col-md-6 col-12 post-share">
                <span data-toggle="modal" data-target="#shareModal" class="pshare"">
                    <i aria-hidden="true" class="fal fa-share-alt"></i>
                    <?php _e('Share','dina-kala') ?>
                </span>
            </div>
            <?php } ?>
        </div>
    </div>

    <?php if ( $di_data['show_post_bottom_banner'] && !empty( $di_data['post_bottom_banner']['url'] ) ) { ?>

    <div class="post-bottom-banner-row<?php if (!$di_data['show_post_bottom_mobile']) { echo ' mobile-hidden'; }?>">
        <div class="col-12 bnr-image shadow-box">
            <a href="<?php echo $di_data['post_bottom_banner_link']; ?>" title="<?php echo $di_data['post_bottom_banner_title']; ?>" aria-label="<?php echo $di_data['post_bottom_banner_title']; ?>">
                <?php
                    $headb_width = (!empty($di_data['post_bottom_banner']['width'])) ? $di_data['post_bottom_banner']['width'] : '1260';
                    $headb_height = (!empty($di_data['post_bottom_banner']['height'])) ? $di_data['post_bottom_banner']['height'] : '142'; 
                ?>
                <img src="<?php echo $di_data['post_bottom_banner']['url']; ?>" alt="<?php echo $di_data['post_bottom_banner_title']; ?>" class="head-banner shadow-box" width="<?php echo $headb_width; ?>" height="<?php echo $headb_height; ?>" />
            </a>
        </div>
    </div>

    <?php } ?>

    <?php
    //Start Post Author Block
    if ($di_data['show_author_block']) { 
    $author = get_post_field( 'post_author', get_the_ID() ); ?>
    <div class="shadow-box author-con">
        <div class="row">
            <div class="col-md-2 col-12 uavatar">
                <a class="author-link" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>">
                    <?php echo get_avatar($author , 128, '',get_the_author_meta('display_name',$author )); ?>
                </a>
            </div>
            <div class="col-md-10 col-12">
                <div class="author-name">
                    <a class="author-link" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>">
                        <?php echo get_the_author_meta('display_name',$author); ?>
                    </a>
                </div>
                <div class="author-bio">
                    <?php echo get_the_author_meta('description',$author); ?>
                </div>
            </div>
        </div>
    </div>
    <?php } 
    //End Author Block
    ?>

<?php endwhile; ?>

    <?php 
    //Start Related Posts
    if ($di_data['show_related_post']) { ?>
    <?php
            $custom_taxterms = wp_get_object_terms( get_the_ID(), $di_data['related_post_by'], array('fields' => 'ids') );
            $args = array(
            'post_type' => 'post',
            'post_status' => 'publish',
            'posts_per_page' => $di_data['related_post_count'],
            'orderby' => 'rand',
            'fields'                    => 'ids',
            'no_found_rows'             => true,
            'update_post_term_cache'    => false,
            'tax_query' => array(
                array(
                    'taxonomy' => $di_data['related_post_by'],
                    'field' => 'id',
                    'terms' => $custom_taxterms
                )
            ),
            'post__not_in' => array (get_the_ID()),
            );
            $related_items = new WP_Query( $args ); ?>
			<?php
             if ($related_items->have_posts()) { 
				 ?>
			<div class="post-block<?php if($di_data['prod_navs'] == 'sttwo') { ?> nav-type-two<?php } ?> related block related-con">
                    <div class="block-title">
                        <h2>
                            <i class="fal fa-file-invoice" aria-hidden="true"></i>
                            <?php echo $di_data['related_post_title']; ?>
                        </h2>
                    </div>
                    <?php $mobile_col = ($di_data['mobile_single_col'] ? 1 : 2); ?>
                    <div class="owl-carousel" data-mcol="<?php echo $mobile_col; ?>" <?php if ( $di_data['show_post_arrows'] ) { echo 'data-itemnavs="true"'; } else { echo 'data-itemnavs="false"'; } ?> <?php if ( $di_data['post_loop'] ) { echo 'data-itemloop="true"'; } else { echo 'data-itemloop="false"'; } ?> <?php if ( $di_data['auto_post_play'] ) { echo 'data-itemplay="true"'; } else { echo 'data-itemplay="false"'; } ?> data-itemscount="<?php echo $di_data['postcount']; ?>" data-dir="<?php dina_rtl(); ?>">
                    <?php
                        while ( $related_items->have_posts() ) : $related_items->the_post(); 
                        $post_categories = get_post_primary_category(get_the_ID(), 'category'); 
		                $primary_category = $post_categories['primary_category'];?>
                        <div class="item">
                            <div class="shadow-box <?php echo $di_data['prod_hover']; ?> mini-post">
                                <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" class="post-link">
                                    <?php po_img() ?>
                                <span class="post-title">
                                    <?php the_title(); ?>
                                </span>
                                <?php if ($di_data['show_post_excerpt']) { ?>
                                <span class="post-exc">
                                    <?php echo strip_tags(get_the_excerpt()); ?>
                                </span>
                                <?php } ?>
                                <?php if($di_data['show_post_cat']) { ?>
                                    <span class="post-cat">
                                        <?php echo $primary_category->name; ?>
                                    </span>
                                <?php } ?>
                                </a>
                                <?php if($di_data['show_hover_btns']) { ?>
                                <a href="<?php the_permalink(); ?>" class="btn btn-success btn-buy<?php if( $di_data['show_hover_btns_fixed'] ) { echo ' btn-buy-fixed'; } ?>">
                                    <i class="fal fa-file-alt" aria-hidden="true"></i>
                                    <?php echo __( 'Read More...', 'dina-kala' ); ?>
                                </a>
                                <?php } ?>
                            </div>
                        </div>
                        <?php endwhile; ?>
                    </div>
                </div>
    <?php
}
wp_reset_postdata();
} 
//End Related Posts
?>

<?php
//Start Comments
if ( comments_open() ) : ?>
    <div class="shadow-box comments-list">
        <?php comments_template(); ?> 
    </div>
<?php endif;
//End Comments
?>

</article>

<?php endif;
//Post Sidebar
if ( $pside == '' && $di_data['post_side'] > 0 ) {
    get_sidebar();
} elseif ( $pside != 'wside' && $pside != '' ) {
    get_sidebar();
} ?>

</div>
</div>
<?php get_footer();