<!doctype html>
<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: Hosseinkhani.ir
*/
   // Exit if accessed directly
   if (!defined('ABSPATH')) {
    exit;
}
global $di_data;
?>
<html <?php language_attributes(); ?>>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=<?php bloginfo( 'charset' ); ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <meta name="theme-color" content="<?php echo $di_data['custom_color']; ?>" />
    <title>
        <?php bloginfo('name'); ?>
    </title>
    <link rel="shortcut icon" href="<?php echo $di_data['site_favicon']['url']; ?>" type="image/x-icon" />
    <link rel="stylesheet" media="screen" type="text/css" href="<?php echo DI_URI; ?>/css/bootstrap-rtl.min.css">
    <link rel="stylesheet" media="screen" type="text/css" href="<?php bloginfo('stylesheet_url'); ?>" />
    <link rel="stylesheet" media="screen" type="text/css" href="<?php echo esc_url( get_template_directory_uri() ); ?>/css/<?php echo $di_data['theme_font'];  ?>.css" />
</head>

<body style="background-color: <?php echo $di_data['custom_color']; ?>">
    <div class="container-fluid">
        <div class="row">
            <div class="container under">
                <h1>
                    <a href="<?php echo esc_url( home_url() ); ?>" title="<?php bloginfo( 'name' );?> | <?php bloginfo('description'); ?>" rel="home">
                    <?php 
                    $logo_width = (!empty($di_data['site_logo_retina']['width'])) ? $di_data['site_logo_retina']['width'] : '320';
                    $logo_height = (!empty($di_data['site_logo_retina']['height'])) ? $di_data['site_logo_retina']['height'] : '114'; ?>
                        <img class="skip-lazy" src="<?php echo $di_data['site_logo_retina']['url']; ?>" width="<?php echo $logo_width; ?>" height="<?php echo $logo_height; ?>" alt="<?php bloginfo( 'name' );?> | <?php bloginfo('description'); ?>" title="<?php bloginfo( 'name' );?> | <?php bloginfo('description'); ?>" />
                    </a>
                </h1>
                <h2>
                    <?php _e('Register version','dina-kala'); ?>
                </h2>
                <h3 style="font-size:18px;margin:20px auto;display:table">
                    <?php _e('Please activate theme with your license key to all features work.' , 'dina-kala') ?>
                    <a class="btn btn-info" style="margin:10px auto;display:table" href="<?php echo admin_url( 'themes.php?page=dina_guard_register', '' ); ?>"><?php _e('Register License' , 'dina-kala') ?></a>
                </h3>
            </div>
        </div>
    </div>
</body>

</html>