<?php
namespace Elementor;

class Dina_Woo_Products extends Widget_Base {

	public function get_name() {
		return 'dina-woo-products';
	}
	
	public function get_title() {
		return __( 'Dina Woo Products', 'dina-kala' );
	}
	
	public function get_icon() {
		return 'fal fa-shopping-cart';
	}
	
	public function get_categories() {
		return [ 'dina-kala' ];
	}
	
	protected function _register_controls() {
	global $di_data;
	require get_template_directory() . '/includes/widgets/fa.php';
		$prod_cata = array();
		$categories = get_terms("product_cat");
		if ( !empty( $categories ) && !is_wp_error( $categories ) ){
		foreach ( $categories as $category ) {
		$prod_cata[ $category->term_id ] = $category->name;
		}
		}

		$prod_taga = array();
		$tags = get_terms("product_tag");
		if ( !empty( $tags ) && !is_wp_error( $tags ) ){
		foreach ( $tags as $tag ) {
		$prod_taga[ $tag->term_id ] = $tag->name;
		}
		}

		if($di_data['product_brand']){
			$prod_brand = array();
			$brands = get_terms("brand");
			if ( !empty( $brands ) && !is_wp_error( $brands ) ){
			foreach ( $brands as $brand ) {
			$prod_brand[ $brand->term_id ] = $brand->name;
			}
			}
		}

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Dina Woo Products', 'dina-kala' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'Title', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your title', 'dina-kala' ),
			]
		);

		$this->add_control(
			'prod_sort',
			[
				'label' => __( 'Product sorting', 'dina-kala' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'latest',
				'options' => [
					'latest'  => __( 'Latest products', 'dina-kala' ),
					'random' => __( 'Random products', 'dina-kala' ),
					'viewed' => __( 'Most viewed products', 'dina-kala' ),
					'saled' => __( 'Best selling products', 'dina-kala' ),
					'coming_soon' => __( 'Coming soon products', 'dina-kala' ),
					'discounted' => __( 'Discounted products', 'dina-kala' ),
					'rand_discounted' => __( 'Random discounted products', 'dina-kala' ),
					'special' => __( 'Special products', 'dina-kala' ),
					'menu_order' => __( 'By title (Menu Order)', 'dina-kala' ),
				],
			]
		);

		if($di_data['product_brand']){
		$this->add_control(
			'prod_filter',
			[
				'label' => __( 'Product filtering', 'dina-kala' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'category',
				'options' => [
					'category'  => __( 'Products category', 'dina-kala' ),
					'tag' => __( 'Products tag', 'dina-kala' ),
					'brand' => __( 'Products brand', 'dina-kala' ),
				],
			]
		);
		} else {
			$this->add_control(
				'prod_filter',
				[
					'label' => __( 'Product filtering', 'dina-kala' ),
					'type' => Controls_Manager::SELECT,
					'default' => 'category',
					'options' => [
						'category'  => __( 'Products category', 'dina-kala' ),
						'tag' => __( 'Products tag', 'dina-kala' ),
					],
				]
			);
		}
		$this->add_control(
			'product_cat',
			[
				'label' => __( 'Product category', 'dina-kala' ),
				'description' => __( 'Empty categories (no product) are not displayed', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => $prod_cata,
			]
		);

		$this->add_control(
			'product_tag',
			[
				'label' => __( 'Product tag', 'dina-kala' ),
				'description' => __( 'Empty tags (no product) are not displayed', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => $prod_taga,
			]
		);

		if($di_data['product_brand']){
			$this->add_control(
				'product_brand',
				[
					'label' => __( 'Product brand', 'dina-kala' ),
					'description' => __( 'Empty brands (no product) are not displayed', 'dina-kala' ),
					'type' => Controls_Manager::SELECT2,
					'multiple' => true,
					'options' => $prod_brand,
				]
			);
		}

		$this->add_control(
			'out_prod',
			[
				'label' => __( 'Show in stock products', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'product_icon',
			[
				'label' => __( 'Icon', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
			]
		);

		$this->add_control(
			'custom_icon',
			[
				'label' => __( 'Or custom icon (Suitable size: 32px by 32px)', 'dina-kala' ),
				'type' => Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'white_title',
			[
				'label' => __( 'White title (Suitable for background mode)', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'white_box',
			[
				'label' => __( 'White box style', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'show_arrows',
			[
				'label' => __( 'Show Arrows', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'auto_play',
			[
				'label' => __( 'Auto play', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'time',
			[
				'label' => __( 'Auto play speed(ms)', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1000,
				'max' => 20000,
				'step' => 1000,
				'default' => 8000,
			]
		);

		$this->add_control(
			'pause_over',
			[
				'label' => __( 'Pause slider on mouse over', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'slide_by',
			[
				'label' => __( 'Items displayed when scrolling', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 40,
				'step' => 1,
				'default' => 1,
			]
		);

		$this->add_control(
			'prod_loop',
			[
				'label' => __( 'Product loop', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'ptotalcount',
			[
				'label' => __( 'Product total count', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 200,
				'step' => 1,
				'default' => 8,
			]
		);

		$this->add_control(
			'pcount',
			[
				'label' => __( 'Product columns count', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 6,
				'step' => 1,
				'default' => 5,
			]
		);

		$this->add_control(
			'view_all',
			[
				'label' => __( 'Display view all button (If category or tag selected)', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
		
		$this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings_for_display();
		global $di_data; ?>
		<?php $navclass = (empty($settings['title']) && $di_data['prod_navs'] == 'stone' ? ' nav-type-one' : ''); ?>
        <div class="product-block<?php echo $navclass; ?><?php if($di_data['prod_navs'] == 'sttwo') { ?> nav-type-two<?php } ?><?php if ( 'yes' === $settings['white_title'] ) { echo ' white-title'; } ?><?php if ( 'yes' === $settings['white_box'] ) { echo ' white-box'; } ?>">
		<?php
		$prod_sort = $settings['prod_sort'];
		$prod_filter = $settings['prod_filter'];
		$product_cat = $settings['product_cat'];
		$product_tag = $settings['product_tag'];
		if($di_data['product_brand']){
			$product_brand = $settings['product_brand'];
		} else {
			$product_brand = '';
		}
		$view_all_link = '';
			if($prod_sort != 'special'){
			switch ($prod_sort) {
				case 'latest':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'order' => 'DESC'  );
					break;
				case 'menu_order':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'orderby' => 'menu_order title',
					'order' => 'ASC'  );
					break;
				case 'saled':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'meta_key' => 'total_sales',
                    'orderby' => 'meta_value_num',
                    'order' => 'DESC'  );
					break;
				case 'discounted':
					$args = array(
						'posts_per_page'    => $settings['ptotalcount'],
						'post_status'       => 'publish',
						'order' => 'DESC',
						'post_type'         => 'product',
						'post__in'          => array_merge( array( 0 ), wc_get_product_ids_on_sale() )
					);
					break;
				case 'coming_soon':
					$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'product',
						'post_status' => 'publish',
						'meta_key' => 'dina_coming',
						'meta_value' => 'on',
						'order' => 'DESC'  );
					break;
				case 'rand_discounted':
					$args = array(
						'posts_per_page'    => $settings['ptotalcount'],
						'post_status'       => 'publish',
						'orderby'        	=> 'rand',
						'post_type'         => 'product',
						'post__in'          => array_merge( array( 0 ), wc_get_product_ids_on_sale() )
					);
					break;
				case 'viewed':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'meta_key' => 'post_views_count',
                    'orderby' => 'meta_value_num',
                    'order' => 'DESC'  );
					break;
				case 'random':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'orderby'        => 'rand'  );
					break;
				default:
				$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'order' => 'DESC'  );
				}
				if ( $prod_filter ) {
					if ( $prod_filter == 'category' && !empty($product_cat)) {
						$args['tax_query'] = array(
							array(
							'taxonomy' => 'product_cat',
							'field' => 'term_id',
							'terms' => $product_cat
							)
						);
						$view_all_link = dina_get_term_links('product_cat',$product_cat);
					} elseif ( $prod_filter == 'tag' && !empty($product_tag)) {
						$args['tax_query'] = array(
							array(
							'taxonomy' => 'product_tag',
							'field' => 'term_id',
							'terms' => $product_tag
							)
						);
						$view_all_link = dina_get_term_links('product_tag',$product_tag);
					} elseif ( $prod_filter == 'brand' && !empty($product_brand)) {
						$args['tax_query'] = array(
							array(
							'taxonomy' => 'brand',
							'field' => 'term_id',
							'terms' => $product_brand
							)
						);
						$view_all_link = dina_get_term_links('brand',$product_brand);
					}
				}
			}
			elseif ($prod_sort == 'special') {
				$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'product',
					'post_status' => 'publish',
					'order' => 'DESC'  );
					if ( !empty($prod_filter) && (!empty($product_cat) || !empty($product_tag) || !empty($product_brand)) ) {
					if ( $prod_filter == 'category' && !empty($product_cat)) {
						$args['tax_query'] = array(
						'relation' => 'AND',
						array(
							'taxonomy' => 'product_visibility',
							'field'    => 'name',
							'terms'    => 'featured',
						),
						array(
						'taxonomy' => 'product_cat',
						'field' => 'term_id',
						'terms' => $product_cat
						)
					);
					} elseif ( $prod_filter == 'tag' && !empty($product_tag)) { 
						$args['tax_query'] = array(
						'relation' => 'AND',
						array(
							'taxonomy' => 'product_visibility',
							'field'    => 'name',
							'terms'    => 'featured',
						),
						array(
						'taxonomy' => 'product_tag',
							'field' => 'term_id',
							'terms' => $product_tag
						)
					);
					} elseif ( $prod_filter == 'brand' && !empty($product_brand)) { 
						$args['tax_query'] = array(
						'relation' => 'AND',
						array(
							'taxonomy' => 'product_visibility',
							'field'    => 'name',
							'terms'    => 'featured',
						),
						array(
						'taxonomy' => 'brand',
							'field' => 'term_id',
							'terms' => $product_brand
						)
					);
					}
				} else {
					$args['tax_query'] = array(
						array(
							'taxonomy' => 'product_visibility',
							'field'    => 'name',
							'terms'    => 'featured',
						),
					);
				}
			}

			if('yes' === $settings['out_prod']){
				$args['meta_query'] = array(
						'relation' => 'AND',
						array(
							'key' => '_stock_status',
							'value' => 'instock'
						)
					);
			}

			$args[] = array(
				'fields'                    => 'ids',
				'no_found_rows'             => true,
				'update_post_term_cache'    => false
			);

			$productsquery = new \WP_Query( $args );
		?>
		
		<?php if ( $productsquery->have_posts() ) { ?>
		<?php if(!empty($settings['title'])) { ?>
		<div class="block-title">
			<h2>
				<?php if(!empty($settings['custom_icon']['url'])){ ?>
					<img src="<?php echo $settings['custom_icon']['url']; ?>" width="32" height="32" alt="<?php echo $settings['title']; ?>" class="cust-icon">
				<?php } else { ?>
					<i class="fal fa-<?php echo $settings['product_icon']; ?>" aria-hidden="true"></i>
				<?php } ?>
				<?php echo $settings['title']; ?>
			</h2>
			<?php if ( 'yes' === $settings['view_all'] && $view_all_link != '' ) { ?>
			<a href="<?php echo $view_all_link; ?>" class="pview-all">
				<?php _e( 'View All' , 'dina-kala' ); ?>
				<i class="fal fa-chevron-left" aria-hidden="true"></i>
			</a>
			<?php } ?>
		</div>
		<?php } ?>
		<?php $mobile_col = ($di_data['mobile_single_col'] ? 1 : 2); ?>
		<div class="owl-carousel" data-mcol="<?php echo $mobile_col; ?>" <?php if ( 'yes' === $settings['show_arrows'] ) { echo 'data-itemnavs="true"'; } else { echo 'data-itemnavs="false"'; } ?> <?php if ( 'yes' === $settings['prod_loop'] ) { echo 'data-itemloop="true"'; } else { echo 'data-itemloop="false"'; } ?> <?php if ( 'yes' === $settings['auto_play'] ) { echo 'data-itemplay="true"'; echo ' data-itemtime="'. $settings['time'] .'"'; } else { echo 'data-itemplay="false"'; } ?> <?php if ( 'yes' === $settings['pause_over'] ) { echo 'data-itemover="true"'; } else { echo 'data-itemover="false"'; } ?> data-itemscount="<?php echo $settings['pcount']; ?>" data-item-slideby="<?php echo $settings['slide_by']; ?>" data-dir="<?php dina_rtl(); ?>">
		<?php while ( $productsquery->have_posts() ) : $productsquery->the_post(); ?>
			<div class="item">
				<?php get_template_part('includes/content-product'); ?>
			</div>
        <?php endwhile; ?>
        </div>
		<?php 
		} else {		
		echo '<div class="col-12 not-msg">'.__( 'No product with the desired conditions was found.', 'dina-kala' ).'</div>';
		}
		wp_reset_postdata();
		?>
        </div>
        <?php
	}
}