<?php
namespace Elementor;

class Dina_Blog_Posts_Grid extends Widget_Base {
	
	public function get_name() {
		return 'dina-blog-posts-grid';
	}
	
	public function get_title() {
		return __( 'Dina blog posts grid', 'dina-kala' );
	}
	
	public function get_icon() {
		return 'fal fa-th';
	}
	
	public function get_categories() {
		return [ 'dina-kala' ];
	}
	
	protected function _register_controls() {
		require get_template_directory() . '/includes/widgets/fa.php';
		$post_cat = array();
		$categories = get_terms("category");
		if ( !empty( $categories ) && !is_wp_error( $categories ) ){
		foreach ( $categories as $category ) {
		$post_cat[ $category->term_id ] = $category->name;
		}
		}

		$post_taga = array();
		$tags = get_terms("post_tag");
		if ( !empty( $tags ) && !is_wp_error( $tags ) ){
		foreach ( $tags as $tag ) {
		$post_taga[ $tag->term_id ] = $tag->name;
		}
		}

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Dina blog posts grid', 'dina-kala' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'Title', 'dina-kala' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your title', 'dina-kala' ),
			]
		);

		$this->add_control(
			'post_sort',
			[
				'label' => __( 'Posts sorting', 'dina-kala' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'latest',
				'options' => [
					'latest'  => __( 'Latest posts', 'dina-kala' ),
					'random' => __( 'Random posts', 'dina-kala' ),
					'viewed' => __( 'Most viewed posts', 'dina-kala' ),
				],
			]
		);

		$this->add_control(
			'post_filter',
			[
				'label' => __( 'Post filtering', 'dina-kala' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'category',
				'options' => [
					'category'  => __( 'Post category', 'dina-kala' ),
					'tag' => __( 'Post tag', 'dina-kala' ),
				],
			]
		);

		$this->add_control(
			'post_cat',
			[
				'label' => __( 'Posts category', 'dina-kala' ),
				'description' => __( 'Empty categories (no post) are not displayed', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => $post_cat,
			]
		);

		$this->add_control(
			'post_tag',
			[
				'label' => __( 'Post tag', 'dina-kala' ),
				'description' => __( 'Empty tags (no post) are not displayed', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => $post_taga,
			]
		);

		$this->add_control(
			'post_icon',
			[
				'label' => __( 'Icon', 'dina-kala' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $icons_font_awesome,
			]
		);

		$this->add_control(
			'custom_icon',
			[
				'label' => __( 'Or custom icon (Suitable size: 32px by 32px)', 'dina-kala' ),
				'type' => Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'white_title',
			[
				'label' => __( 'White title (Suitable for background mode)', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'white_box',
			[
				'label' => __( 'White box style', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'ptotalcount',
			[
				'label' => __( 'Posts total count', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 200,
				'step' => 1,
				'default' => 10,
			]
		);

		$this->add_control(
			'pcount',
			[
				'label' => __( 'Posts columns count', 'dina-kala' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 6,
				'step' => 1,
				'default' => 5,
			]
		);

		$this->add_control(
			'view_all',
			[
				'label' => __( 'Display view all button (If category or tag selected)', 'dina-kala' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'dina-kala' ),
				'label_off' => __( 'Off', 'dina-kala' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings_for_display();
		global $di_data; ?>
        <div class="post-block-grid<?php if ( 'yes' === $settings['white_title'] ) { echo ' white-title'; } ?><?php if ( 'yes' === $settings['white_box'] ) { echo ' white-box'; } ?>">
		<?php
		$post_sort = $settings['post_sort'];
		$post_filter = $settings['post_filter'];
		$post_cat = $settings['post_cat'];
		$post_tag = $settings['post_tag'];
			switch ($post_sort) {
				case 'latest':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'post',
					'post_status' => 'publish',
					'order' => 'DESC'  );
					break;
				case 'viewed':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'post',
					'post_status' => 'publish',
					'meta_key' => 'post_views_count',
                    'orderby' => 'meta_value_num',
                    'order' => 'DESC'  );
					break;
				case 'random':
					$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'post',
					'post_status' => 'publish',
					'orderby'        => 'rand'  );
					break;
				default:
				$args = array(
					'posts_per_page' => $settings['ptotalcount'],
					'post_type' => 'post',
					'post_status' => 'publish',
					'order' => 'DESC'  );
				}
				if ( $post_filter ) {
					if ( $post_filter == 'category' && !empty($post_cat) ) {
						$args['tax_query'] = array(
							array(
							'taxonomy' => 'category',
							'field' => 'term_id',
							'terms' => $post_cat
							)
						);
						$view_all_link = dina_get_term_links('category',$post_cat);
					} elseif ( $post_filter == 'tag' && !empty($post_tag) ) {
						$args['tax_query'] = array(
							array(
							'taxonomy' => 'post_tag',
							'field' => 'term_id',
							'terms' => $post_tag
							)
						);
						$view_all_link = dina_get_term_links('post_tag',$post_tag);
					}
				}
				$args[] = array(
					'fields'                    => 'ids',
					'no_found_rows'             => true,
					'update_post_term_cache'    => false
				);
			$postsquery = new \WP_Query( $args );
		?>
		
		<?php if ( $postsquery->have_posts() ) { ?>
		<?php if(!empty($settings['title'])) { ?>
		<div class="block-title">
			<h2>
				<?php if(!empty($settings['custom_icon']['url'])){ ?>
					<img src="<?php echo $settings['custom_icon']['url']; ?>" width="32" height="32" alt="<?php echo $settings['title']; ?>" class="cust-icon">
				<?php } else { ?>
					<i class="fal fa-<?php echo $settings['post_icon']; ?>" aria-hidden="true"></i>
				<?php } ?>
				<?php echo $settings['title']; ?>
			</h2>
		</div>
		<?php } ?>
		<div class="row">
		<?php 
			if($settings['pcount'] == 2){
				$pclasses = 'col-6';
			}
			elseif($settings['pcount'] == 3){
				$pclasses = 'col-md-4 col-6';
			}
			elseif($settings['pcount'] == 4){
				$pclasses = 'col-md-3 col-6';
			}
			elseif($settings['pcount'] == 5){
				$pclasses = 'col-p-5 col-md-3 col-6';
			}
			if($di_data['mobile_single_col']) {
				$pclasses .= ' mobile-single-col';
			}
		?>
		<?php while ( $postsquery->have_posts() ) : $postsquery->the_post(); 
		$post_categories = get_post_primary_category(get_the_ID(), 'category'); 
		$primary_category = $post_categories['primary_category']; ?>
			<div class="<?php echo $pclasses; ?> mini-post-con">
			<div class="shadow-box <?php echo $di_data['prod_hover']; ?> mini-post">
					<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" class="post-link">
							<?php po_img() ?>
						<span class="post-title">
							<?php the_title(); ?>
						</span>
						<?php if ($di_data['show_post_excerpt']) { ?>
						<span class="post-exc">
							<?php echo strip_tags(get_the_excerpt()); ?>
						</span>
						<?php } ?>
						<?php if($di_data['show_post_cat']) { ?>
							<span class="post-cat">
								<?php echo $primary_category->name; ?>
							</span>
						<?php } ?>
					</a>
					<?php if($di_data['show_hover_btns']) { ?>
					<a href="<?php the_permalink(); ?>" class="btn btn-success btn-buy<?php if( $di_data['show_hover_btns_fixed'] ) { echo ' btn-buy-fixed'; } ?>">
						<i class="fal fa-file-alt" aria-hidden="true"></i>
						<?php echo __( 'Read More...', 'dina-kala' ); ?>
					</a>
					<?php } ?>
				</div>
			</div>
		<?php endwhile; ?>
        </div>
		<?php if ( 'yes' === $settings['view_all'] && $view_all_link != '' ) { ?>
			<a href="<?php echo $view_all_link; ?>" class="btn btn-outline-dina pgview-all">
				<?php _e( 'View All Posts' , 'dina-kala' ); ?>
				<i class="fal fa-chevron-left" aria-hidden="true"></i>
			</a>
		<?php } ?>
		<?php 
		} else {		
		echo '<div class="col-12 not-msg">'.__( 'No post with the desired conditions was found.', 'dina-kala' ).'</div>';}
		
		wp_reset_postdata();
		?>
        </div>
        <?php

	}

}