<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: Hosseinkhani.ir
*/
   // Exit if accessed directly
   if (!defined('ABSPATH')) {
    exit;
}

// Creating the widget
   class dina_onsale_stock_widget extends WP_Widget {
   
   function __construct() {
   
   parent::__construct(
   
   // Base ID of your widget
   
   'dina_onsale_stock_widget',
   
    
   
   // Widget name will appear in UI
   
   __('Filter Onsale / Stock Products (Dinakala)', 'dina-kala'),
   
    
   
   // Widget description
   
   array( 'description' => __('Filter Onsale / Stock products', 'dina-kala'), )
   
   );
   
   }
   
    
   
   // Creating widget front-end
   
   // This is where the action happens
   
   public function widget( $args, $instance ) {

   if (is_singular('product') && is_archive()) {
   
   $title = apply_filters( 'widget_title', $instance['title'] );
   
   // before and after widget arguments are defined by themes
   
   echo $args['before_widget'];
   
   if ( ! empty( $title ) )
   
   echo $args['before_title'] . $title . $args['after_title'];

   
   // This is where you run the code and display the output
   
   echo '';
   
   echo $args['after_widget'];
   
   }

   }
   
    
   
   // Widget Backend
   
   public function form( $instance ) {
   
   if ( isset( $instance[ 'title' ] ) ) {
   
   $title = $instance[ 'title' ];
   
   }
   
   else {
   
   $title = __('InStock / Onsale Status', 'dina-kala');
   
   }
   
   // Widget admin form
   
   ?>
<p>
   <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'dina-kala' ); ?></label>
   <input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
</p>
<?php
   }
   
    
   
   // Updating widget replacing old instances with new
   
   public function update( $new_instance, $old_instance ) {
   
   $instance = array();
   
   $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
   
   return $instance;
   
   }
   
   } // Class wpb_widget ends here
   
    
   
   // Register and load the widget
   
   function dina_onsale_stock_load_widget() {
   
   register_widget( 'dina_onsale_stock_widget' );
   
   }
   
   add_action( 'widgets_init', 'dina_onsale_stock_load_widget' );   