<?php
//Dina_woo_before_single_product_summary
add_action('woocommerce_before_single_product_summary', 'dina_woo_before_single_product_summary');
function dina_woo_before_single_product_summary() { ?>
    <div class="shadow-box product-con col-12">
    <ul class="prod-opts">
        <?php 
        global $di_data;
        $tpos = (is_rtl() ? 'left' : 'right');
        $rvideo = esc_html(get_post_meta( get_the_ID(), 'dina_rvideo', true ));
        $aparat = esc_html(get_post_meta( get_the_ID(), 'dina_aparat', true ));
        if(!empty($rvideo) || !empty($aparat) && is_singular('product')) { ?>
        <li data-toggle="modal" data-target="#reviewModal">
            <span data-toggle="tooltip" data-placement="<?php echo $tpos; ?>" title="<?php echo __('Product video', 'dina-kala'); ?>">
            <i aria-hidden="true" class="fal fa-play"></i>
            </span>
        </li>
        <?php } ?>
        <?php if ( $di_data['like_prod'] && class_exists( 'JVM_WooCommerce_Wishlist' ) ) { ?>
        <li>
            <span data-toggle="tooltip" data-placement="<?php echo $tpos; ?>" title="<?php echo __('Add to Wishlist', 'dina-kala'); ?>">
                <?php echo do_shortcode('[jvm_woocommerce_add_to_wishlist]'); ?>
            </span>
        </li>
        <?php } ?>
        <?php if ( $di_data['compare_prod'] && defined( 'WCCM_VERISON' ) ) { ?>
        <li>
            <?php 
            $product_id = get_the_ID();
            if ( in_array( $product_id, wccm_get_compare_list() ) ) {
                $compare_title= __('Remove From Compare', 'dina-kala');
                $compare_class = " in-compare";
            } else {
                $compare_title= __('Compare Product', 'dina-kala');
                $compare_class = "";
            }
            ?>
            <span data-dina-compare-id="<?php echo $product_id; ?>" class="compare-ajax-btn<?php echo $compare_class; ?>" data-toggle="tooltip" data-placement="<?php echo $tpos; ?>" title="<?php echo $compare_title; ?>">
                <i class="fal fa-random" aria-hidden="true"></i>
            </span>
        </li>
        <?php } ?>
        <?php if($di_data['share_prod']){ ?>
        <li data-toggle="modal" data-target="#shareModal">
            <span data-toggle="tooltip" data-placement="<?php echo $tpos; ?>" title="<?php echo __('Share', 'dina-kala'); ?>">
            <i aria-hidden="true" class="fal fa-share-alt"></i>
            </span>
        </li>
        <?php } ?>
        <li class="dina-gallery-trigger">
            <span data-toggle="tooltip" data-placement="<?php echo $tpos; ?>" title="<?php echo __('Zoom in', 'dina-kala'); ?>">
            <i aria-hidden="true" class="fal fa-search-plus fa-flip-horizontal"></i>
            </span>
        </li>
    </ul>
<?php } 

//Dina_woo_after_single_product_summary
add_action('woocommerce_after_single_product_summary', 'dina_woo_after_single_product_summary');
function dina_woo_after_single_product_summary() {
    setPostViews(get_the_ID());
    echo '</div>';
}

//Sale Flash
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10 );
remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );
add_action( 'woocommerce_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );
add_filter( 'woocommerce_sale_flash', 'dina_woo_sale_flash' );
function dina_woo_sale_flash( $example ) {
    global $post;
    global $di_data;
    $product = new WC_Product($post->ID);
    $in_stock = $product->is_in_stock();
    if($in_stock) {   
        if($di_data['display_spec']) {
            return '<span class="onsale dina-special">'.__( 'Special!', 'dina-kala' ).'</span>';
        } elseif(is_rtl()) {
            return '<span class="onsale">٪'.disw_price($post->ID).' '. __( 'Discount', 'dina-kala' ).'</span>';
        } else {
            return '<span class="onsale">'.disw_price($post->ID).'% '. __( 'Discount', 'dina-kala' ).'</span>';
        }
    }
}

//dina_customizing_simple_products Page
add_action('woocommerce_before_single_product', 'dina_customizing_simple_products');
function dina_customizing_simple_products(){
    global $product;
    global $di_data;
    $in_stock = $product->is_in_stock();
    remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 10);
    remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20);
    remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50);
    remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40);
    add_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 11); 
    if($in_stock || $di_data['show_price_out']) {
        add_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 27);
    }
}

//dina_add_prod_info
if($di_data['show_add_prod_info']) {
add_action('woocommerce_single_product_summary', 'dina_add_prod_info',32);
}

function dina_add_prod_info(){
   global $di_data;
   $prod_info_text = get_post_meta( get_the_ID(), 'dina_prod_info_text', true );
   if($prod_info_text != '') {
        echo '<div class="add_prod_info">'. do_shortcode($prod_info_text) .'</div>';
   } elseif($di_data['add_prod_info_title'] != '' || $di_data['add_prod_info_text'] != '') {
        echo '<div class="add_prod_info">';
        if($di_data['add_prod_info_title'] != '') {
            echo '<strong>'.$di_data['add_prod_info_title'].'</strong>';
        }
        if($di_data['add_prod_info_text'] != '') {
            echo do_shortcode($di_data['add_prod_info_text']);
        }
        echo '</div>';
   }
}

//dina_before_product_title
add_action('woocommerce_single_product_summary', 'dina_before_product_title', 4);
function dina_before_product_title() {
	echo '<div class="ptitle-con">';
}

//dina_after_product_title
add_action('woocommerce_single_product_summary', 'dina_after_product_title', 10); 
function dina_after_product_title() {
	echo '</div>';
}

//Add Product Sub-title
add_action('woocommerce_single_product_summary', 'dina_product_sub_title', 9); 
function dina_product_sub_title() {
    $undertitle = get_post_meta( get_the_ID(), 'dina_under_title', true );
	echo '<div class="psub_title">'.$undertitle.'</div>';
}

//Add Product Extra
add_action('woocommerce_single_product_summary', 'dina_product_extra', 25); 
function dina_product_extra() { 
    global $di_data;
    ?>
    <?php if($di_data['show_extra']) { ?>
    <div class="product_extra<?php if(!$di_data['show_extra_mobile']){echo ' mobile-hidden';}?>">
        <ul>
            <?php if($di_data['show_extra_one']) { ?>
            <li>
                <?php if(!empty($di_data['extra_one_link'])) { ?>
                    <a href="<?php echo $di_data['extra_one_link']; ?>" title="<?php echo $di_data['extra_one_title']; ?>">
                <?php } ?>
                        <i class="<?php echo $di_data['extra_one_icon']; ?>" aria-hidden="true"></i>
                        <span><?php echo $di_data['extra_one_title']; ?></span>
                <?php if(!empty($di_data['extra_one_link'])) { ?>
                    </a>
                <?php } ?>
            </li>
            <?php } ?>

            <?php if($di_data['show_extra_two']) { ?>
            <li>
                <?php if(!empty($di_data['extra_two_link'])) { ?>
                    <a href="<?php echo $di_data['extra_two_link']; ?>" title="<?php echo $di_data['extra_two_title']; ?>">
                <?php } ?>
                        <i class="<?php echo $di_data['extra_two_icon']; ?>" aria-hidden="true"></i>
                        <span><?php echo $di_data['extra_two_title']; ?></span>
                <?php if(!empty($di_data['extra_two_link'])) { ?>
                    </a>
                <?php } ?>
            </li>
            <?php } ?>

            <?php if($di_data['show_extra_three']) { ?>
            <li>
                <?php if(!empty($di_data['extra_three_link'])) { ?>
                    <a href="<?php echo $di_data['extra_three_link']; ?>" title="<?php echo $di_data['extra_three_title']; ?>">
                <?php } ?>
                    <i class="<?php echo $di_data['extra_three_icon']; ?>" aria-hidden="true"></i>
                    <span><?php echo $di_data['extra_three_title']; ?></span>
                <?php if(!empty($di_data['extra_three_link'])) { ?>
                    </a>
                <?php } ?>
            </li>
            <?php } ?>

            <?php if($di_data['show_extra_four']) { ?>
            <li>
                <?php if(!empty($di_data['extra_four_link'])) { ?>
                    <a href="<?php echo $di_data['extra_four_link']; ?>" title="<?php echo $di_data['extra_four_title']; ?>">
                <?php } ?>
                        <i class="<?php echo $di_data['extra_four_icon']; ?>" aria-hidden="true"></i>
                        <span><?php echo $di_data['extra_four_title']; ?></span>
                <?php if(!empty($di_data['extra_four_link'])) { ?>
                    </a>
                <?php } ?>
            </li>
            <?php } ?>

            <?php if($di_data['show_extra_five']) { ?>
            <li>
                <?php if(!empty($di_data['extra_five_link'])) { ?>
                    <a href="<?php echo $di_data['extra_five_link']; ?>" title="<?php echo $di_data['extra_five_title']; ?>">
                <?php } ?>
                        <i class="<?php echo $di_data['extra_five_icon']; ?>" aria-hidden="true"></i>
                        <span><?php echo $di_data['extra_five_title']; ?></span>
                <?php if(!empty($di_data['extra_five_link'])) { ?>
                    </a>
                <?php } ?>
            </li>
            <?php } ?>
        </ul>
    </div>
<?php } }

//Delete default related product and add theme's related product
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
add_action( 'woocommerce_before_single_product', 'dina_related_place', 5 );

//Dina related product's place
function dina_related_place() {
    global $product;
    global $di_data;
    if(!$product->is_in_stock() && $di_data['show_related_p_top']){
        add_action( 'woocommerce_before_single_product_summary', 'dina_related_product', 5 );
    } else {
        add_action( 'woocommerce_after_single_product_summary', 'dina_related_product', 20 );
    }
}

//Dina related product's
function dina_related_product() {
    global $di_data;
    global $product;
    if ($di_data['show_related_p']) { 
        
            if($di_data['related_p_by'] == 'product_cat' && $di_data['show_by_last_cat']) {
                $related_taxterms = dina_get_prod_deep_cats(get_the_ID());
            } elseif ($di_data['related_p_by'] == 'cat_and_brand') {
                $related_taxterms = wp_get_object_terms( get_the_ID(), 'product_cat', array('fields' => 'ids') );
                $related_taxterms_two = wp_get_object_terms( get_the_ID(), 'brand', array('fields' => 'ids') );
            } else {
                $related_taxterms = wp_get_object_terms( get_the_ID(), $di_data['related_p_by'], array('fields' => 'ids') );
            }

            if ($di_data['related_p_by'] == 'cat_and_brand') {
                $args = array(
                    'post_type' => 'product',
                    'post_status' => 'publish',
                    'posts_per_page' => $di_data['related_p_count'],
                    'orderby' => 'rand',
                    'tax_query' => array(
                        'relation' => 'OR',
                        array(
                            'taxonomy' => 'product_cat',
                            'field'    => 'id',
                            'terms'    => $related_taxterms,
                        ),
                        array(
                            'taxonomy' => 'brand',
                            'field'    => 'id',
                            'terms'    => $related_taxterms_two,
                        ),
                    ),
                    'post__not_in' => array (get_the_ID()),
                );
            } else {
                $args = array(
                    'post_type' => 'product',
                    'post_status' => 'publish',
                    'posts_per_page' => $di_data['related_p_count'],
                    'orderby' => 'rand',
                    'fields'                    => 'ids',
                    'no_found_rows'             => true,
                    'update_post_term_cache'    => false,
                    'tax_query' => array(
                        array(
                            'taxonomy' => $di_data['related_p_by'],
                            'field' => 'id',
                            'terms' => $related_taxterms
                        )
                    ),
                    'post__not_in' => array (get_the_ID()),
                );
            }

            if($di_data['show_out_prod']){
				$args['meta_query'] = array(
						'relation' => 'AND',
						array(
							'key' => '_stock_status',
							'value' => 'instock'
						)
					);
			}

            $related_items = new WP_Query( $args ); ?>
			<?php
             if ($related_items->have_posts()) {                  
				 ?>
			<div class="product-block<?php if($di_data['prod_navs'] == 'sttwo') { ?> nav-type-two<?php } ?> related block<?php if(!$product->is_in_stock() && $di_data['show_related_p_top']){echo ' related-not';} ?>">
                    <div class="block-title">
                        <h2>
                            <i class="fal fa-shopping-bag" aria-hidden="true"></i>
                            <?php echo $di_data['related_p_title']; ?>
                        </h2>
                    </div>
                    <?php $mobile_col = ($di_data['mobile_single_col'] ? 1 : 2); ?>
                    <div class="owl-carousel" data-mcol="<?php echo $mobile_col; ?>" <?php if ( $di_data['show_arrows'] ) { echo 'data-itemnavs="true"'; } else { echo 'data-itemnavs="false"'; } ?> <?php if ( $di_data['prod_loop'] ) { echo 'data-itemloop="true"'; } else { echo 'data-itemloop="false"'; } ?> <?php if ( $di_data['auto_play'] ) { echo 'data-itemplay="true"'; } else { echo 'data-itemplay="false"'; } ?> data-itemscount="<?php echo $di_data['pcount']; ?>" data-dir="<?php dina_rtl(); ?>">
                    <?php
                        while ( $related_items->have_posts() ) : $related_items->the_post(); ?>
                        <div class="item">
                            <?php get_template_part('includes/content-product'); ?>
                        </div>
                        <?php endwhile; ?>
                    </div>
                </div>
    <?php }} 
    wp_reset_postdata();
}

//Product Video Modal
add_action( 'wp_footer', 'dina_video_modal' );
function dina_video_modal() { 
    $rvideo = esc_html(get_post_meta( get_the_ID(), 'dina_rvideo', true ));
    $aparat = esc_html(get_post_meta( get_the_ID(), 'dina_aparat', true ));
    if(!empty($rvideo) || !empty($aparat) && is_singular('product')) {
    ?>
    <!-- The Video Review Modal -->
    <div class="modal fade<?php if(!empty($rvideo)){ echo ' vmodal';}else{ echo ' amodal';} ?>" id="reviewModal">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
            <!-- Video Review Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title"><i class="fal fa-play" aria-hidden="true"></i><?php the_title(); ?></h4>
                <button type="button" class="close" data-dismiss="modal">
                    <i class="fal fa-times" aria-hidden="true"></i>
                </button>
            </div>
            <!-- Video Review Modal body -->
            <div class="modal-body">
                <?php 
                if(!empty($rvideo)){
                echo '<video controls><source src="'.$rvideo.'" id="rVideo"></video>';
                } else {
                echo '<div id="15305363563383534"><script type="text/JavaScript" src="https://www.aparat.com/embed/'.$aparat.'?data[rnddiv]=15305363563383534&data[responsive]=yes"></script></div>';
                } ?>
            </div>

            </div>
        </div>
    </div>
<?php } }

//Product & Post Share Modal
add_action( 'wp_footer', 'dina_share_modal' );
function dina_share_modal() { 
    global $post;
    if(is_singular('product') || is_singular('post')) {
    ?>
    <!-- The Share Modal -->
    <div class="modal fade" id="shareModal">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
            <!-- Share Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title"><i class="fal fa-share-alt" aria-hidden="true"></i><?php _e('Share on social networks','dina-kala') ?></h4>
                <button type="button" class="close" data-dismiss="modal">
                    <i class="fal fa-times" aria-hidden="true"></i>
                </button>
            </div>
            <!-- Share Modal body -->
            <div class="modal-body">
                <ul class="social-box">
                <?php if(function_exists('affwp_is_affiliate') && affwp_is_affiliate(get_current_user_id())) {  ?>
                    <li class="social-face"><a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Facebook', 'dina-kala' ); ?>" href="http://www.facebook.com/sharer.php?u=<?php echo wp_get_shortlink(); ?>&ref=<?php echo get_current_user_id(); ?>" target="_blank"><i class="fab fa-facebook-f" aria-hidden="true"></i></a></li>
                    <li class="social-google"><a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Google+', 'dina-kala' ); ?>" href="https://plus.google.com/share?url=<?php echo wp_get_shortlink(); ?>&ref=<?php echo get_current_user_id(); ?>" target="_blank"><i class="fab fa-google-plus-g" aria-hidden="true"></i></a></li>
                    <li class="social-pin"><a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Pinterest', 'dina-kala' ); ?>" href="http://pinterest.com/pin/create/link/?url=<?php echo wp_get_shortlink(); ?>&ref=<?php echo get_current_user_id(); ?>" target="_blank"><i class="fab fa-pinterest-p" aria-hidden="true"></i></a></li>
                    <li class="social-twi"><a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Twitter', 'dina-kala' ); ?>" href="http://www.twitter.com/share?url=<?php echo wp_get_shortlink(); ?>&ref=<?php echo get_current_user_id(); ?>" target="_blank"><i class="fab fa-twitter" aria-hidden="true"></i></a></li>
                    <li class="social-link"><a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Linkedin', 'dina-kala' ); ?>" href="https://www.linkedin.com/sharing/share-offsite/?url=<?php echo get_permalink(); ?>&ref=<?php echo get_current_user_id(); ?>" target="_blank"><i class="fab fa-linkedin-in" aria-hidden="true"></i></a></li>
                    <li class="social-cloob"><a data-toggle="tooltip" data-placement="top" title="<?php _e('Cloob','dina-kala'); ?>" href="http://www.cloob.com/share/link/add?url=<?php echo wp_get_shortlink(); ?>&ref=<?php echo get_current_user_id(); ?>" target="_blank"><i class="ico-cloob" aria-hidden="true"></i></a></li>
                    <li class="social-tele"><a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Telegram', 'dina-kala' ); ?>" href="https://telegram.me/share/url?url=<?php echo wp_get_shortlink(); ?>&ref=<?php echo get_current_user_id(); ?>" target="_blank"><i class="fab fa-telegram-plane" aria-hidden="true"></i></a></li>
                    <li class="social-wts"><a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Whatsapp', 'dina-kala' ); ?>" href="https://wa.me/?text=<?php echo wp_get_shortlink(); ?>&ref=<?php echo get_current_user_id(); ?>" target="_blank"><i class="fab fa-whatsapp" aria-hidden="true"></i></a></li>
                    <li class="social-email"><a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Email', 'dina-kala' ); ?>" href="mailto:?subject=<?php the_title(); ?>&body=<?php echo wp_get_shortlink(); ?>&ref=<?php echo get_current_user_id(); ?>" target="_blank"><i class="fal fa-envelope" aria-hidden="true"></i></a></li>
                <?php } else { ?>
                    <li class="social-face"><a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Facebook', 'dina-kala' ); ?>" href="http://www.facebook.com/sharer.php?u=<?php echo wp_get_shortlink(); ?>" target="_blank"><i class="fab fa-facebook-f" aria-hidden="true"></i></a></li>
                    <li class="social-google"><a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Google+', 'dina-kala' ); ?>" href="https://plus.google.com/share?url=<?php echo wp_get_shortlink(); ?>" target="_blank"><i class="fab fa-google-plus-g" aria-hidden="true"></i></a></li>
                    <li class="social-pin"><a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Pinterest', 'dina-kala' ); ?>" href="http://pinterest.com/pin/create/link/?url=<?php echo wp_get_shortlink(); ?>" target="_blank"><i class="fab fa-pinterest-p" aria-hidden="true"></i></a></li>
                    <li class="social-twi"><a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Twitter', 'dina-kala' ); ?>" href="http://www.twitter.com/share?url=<?php echo wp_get_shortlink(); ?>" target="_blank"><i class="fab fa-twitter" aria-hidden="true"></i></a></li>
                    <li class="social-link"><a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Linkedin', 'dina-kala' ); ?>" href="https://www.linkedin.com/sharing/share-offsite/?url=<?php echo get_permalink(); ?>" target="_blank"><i class="fab fa-linkedin-in" aria-hidden="true"></i></a></li>
                    <li class="social-cloob"><a data-toggle="tooltip" data-placement="top" title="<?php _e('Cloob','dina-kala'); ?>" href="http://www.cloob.com/share/link/add?url=<?php echo wp_get_shortlink(); ?>" target="_blank"><i class="dico ico-cloob" aria-hidden="true"></i></a></li>
                    <li class="social-tele"><a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Telegram', 'dina-kala' ); ?>" href="https://telegram.me/share/url?url=<?php echo wp_get_shortlink(); ?>" target="_blank"><i class="fab fa-telegram-plane" aria-hidden="true"></i></a></li>
                    <li class="social-wts"><a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Whatsapp', 'dina-kala' ); ?>" href="https://wa.me/?text=<?php echo wp_get_shortlink(); ?>" target="_blank"><i class="fab fa-whatsapp" aria-hidden="true"></i></a></li>
                    <li class="social-email"><a data-toggle="tooltip" data-placement="top" title="<?php _e( 'Email', 'dina-kala' ); ?>" href="mailto:?subject=<?php the_title(); ?>&body=<?php echo wp_get_shortlink(); ?>" target="_blank"><i class="fal fa-envelope" aria-hidden="true"></i></a></li>
                <?php } ?>
                </ul>
                <div class="short-con">
                <?php if(function_exists('affwp_is_affiliate') && affwp_is_affiliate(get_current_user_id())) {  ?>
                    <span class="short-text"><?php _e('Marketing link:','dina-kala') ?></span>
                    <span class="short-link"><?php echo wp_get_shortlink() . '&ref=' . get_current_user_id(); ?></span>
                <?php } else { ?>
                    <span class="short-text"><?php _e('Shortlink:','dina-kala') ?></span>
                    <span class="short-link"><?php echo wp_get_shortlink(); ?></span>
                    <span data-toggle="tooltip" data-placement="top" title="<?php _e( 'Copy Link', 'dina-kala' ); ?>" class="short-btn" onclick="copyToClipboard('.short-link')"><i class="fal fa-copy" aria-hidden="true"></i></span>
                <?php } ?>
                </div>
                <div class="link-copy"><?php _e( 'Link copied!', 'dina-kala' ); ?></div>
            </div>

            </div>
        </div>
    </div>
<?php } }

//dina_woo_product_features
add_action('woocommerce_single_product_summary', 'dina_woo_product_features', 24);
function dina_woo_product_features() {
    global $di_data;
    global $post;
    echo '<div class="product-features">';
    if($di_data['replace_features_tab']) {
        echo dina_get_product_attributes( get_the_ID() );
    } elseif(!$di_data['replace_features']) {
        $features = get_post_meta( get_the_ID(), 'dina_product_features', true );
        if(!empty($features)) {
        if($di_data['show_prodf_title'] && !empty($di_data['prodf_title'])) { echo '<strong>'.$di_data['prodf_title'].'</strong>'; }
            echo '<ul>';
                foreach ( (array) $features as $key => $feature ) {
                    $ftitle = $fdesc = '';
                    if ( isset( $feature['ftitle'] ) ) {
                        $ftitle = esc_html( $feature['ftitle'] );
                    }
                    if ( isset( $feature['fdesc'] ) ) {
                        $fdesc = esc_html( $feature['fdesc'] );
                    }
                    if(!empty($ftitle) || !empty($fdesc)){
                        echo '<li>';
                            if(!empty($ftitle)){
                                echo '<span class="ftitle">'.$ftitle.'</span>';
                            }
                            if(!empty($fdesc) && ($fdesc!= '.')){
                                echo '<span class="fdesc">: '.$fdesc.'</span>';
                            }
                        echo '</li>';
                    }
                }    
            echo '</ul>';
        } 
    } elseif(!empty($post->post_excerpt)) {
        the_excerpt();
    }
    if($di_data['show_add_prod_btn']) {
        $product = wc_get_product( $post->id );
        if($di_data['show_add_prod_call']) { ?>
            <a class="btn btn-outline-dina add-prod-btn" href="<?php echo $di_data['add_prod_btn_link']; ?>" target="_blank" title="<?php echo $di_data['add_prod_btn_title']; ?>">
                <i aria-hidden="true" class="fal <?php echo $di_data['add_prod_btn_icon']; ?>"></i>
                <?php echo $di_data['add_prod_btn_title']; ?>
            </a>
        <?php 
        } else {
            if(dina_check_product_purchasable()){ ?>
                <a class="btn btn-outline-dina add-prod-btn" href="<?php echo $di_data['add_prod_btn_link']; ?>" target="_blank" title="<?php echo $di_data['add_prod_btn_title']; ?>">
                    <i aria-hidden="true" class="fal <?php echo $di_data['add_prod_btn_icon']; ?>"></i>
                    <?php echo $di_data['add_prod_btn_title']; ?>
                </a>
      <?php
            }
        } 
    }  
   echo '</div>';
}

//dina_before_price
add_action('woocommerce_single_product_summary', 'dina_before_price', 26);
function dina_before_price() {
    global $product;
    global $di_data;
    $variable_class = '';

    if($di_data['remove_dub_price_range'] && $product->is_type( 'variable' )) {
        $min_var_reg_price = $product->get_variation_regular_price( 'min', true );
        $min_var_sale_price = $product->get_variation_sale_price( 'min', true );
        $max_var_reg_price = $product->get_variation_regular_price( 'max', true );
        $max_var_sale_price = $product->get_variation_sale_price( 'max', true );
        if ( !($min_var_reg_price == $max_var_reg_price) || !($min_var_sale_price == $max_var_sale_price) ) {
            $variable_class = ' variable-price';
        }
    }
    
    echo '<div class="price-con'.$variable_class.'">';
}

//dina_after_price
add_action('woocommerce_single_product_summary', 'dina_after_price', 31);
function dina_after_price() {
    echo '</div>';
}

//dina single product offer counter
add_action( 'woocommerce_single_product_summary', 'dina_single_product_offer_counter', 25 );
function dina_single_product_offer_counter() {
    global $product;

    if ($product->is_type( 'variable' )) {
        $children_ids = $product->get_children();
        $children_id = $children_ids[0];
        $date = get_post_meta( $children_id, '_sale_price_dates_to', true );
    } else {
        $date = get_post_meta( $product->get_id(), '_sale_price_dates_to', true );
    }

    if (!empty($date) && $product->is_purchasable() && $product->is_in_stock()) {
        $date += 24*60*60;
        $sale_price_date = ( $date ) ? date( 'Y/m/d', $date ) : '';
        $date_diff = ( $date ) ? date( 'Y-m-d', $date ) : '';
        $now = time(); // or your date as well
        $your_date = strtotime($date_diff);
        $diff = $your_date - $now;
        $datediff = round($diff / (60 * 60 * 24));
        if($product->is_on_sale()) { ?>
            <div class="counter-con">
                <div class="prodcounter" data-datediff="<?php echo $datediff; ?>" data-countdown="<?php echo $sale_price_date; ?>" data-dir="<?php echo (is_rtl())?'rtl':'ltr';?>"></div>
            </div>
        <?php } 
    }
}

//dina_override_default_template for product quantity
add_filter('woocommerce_locate_template', 'dina_override_default_template', 9999, 3);
function dina_override_default_template( $template, $template_name, $template_path ) {		
    if ($template_name == 'global/quantity-input.php') {
        $template = DI_DIR . '/includes/quantity.php';;			
    }		
    return $template;
}

//Add WooCommerce Product Pros & Cons before the_content
add_filter('the_content', 'dina_before_woo_content_pros_cons',10);
function dina_before_woo_content_pros_cons($content) {
    global $post;
    global $di_data;
    
    $cons_pros = get_post_meta( get_the_ID(), 'dina_cons_pros', true );

    if(is_product() && $cons_pros)
    {
        $product_pros = get_post_meta( get_the_ID(), 'dina_product_pros', true );
        $product_cons = get_post_meta( get_the_ID(), 'dina_product_cons', true );

        $beforecontent = '';

        if(!empty($product_pros)) {
            $beforecontent .= '<div class="product-pros">';
            $beforecontent .= '<strong>'.__('Product Pros:', 'dina-kala').'</strong>';
                $beforecontent .= '<ul>';
                    foreach ( (array) $product_pros as $key => $pros ) {
                        $ptitle = '';
                        if ( isset( $pros['ptitle'] ) ) {
                            $ptitle = esc_html( $pros['ptitle'] );
                        }
                        if(!empty($ptitle)){
                        $beforecontent .= '<li>'.$ptitle.'</li>';
                        }
                    }
            $beforecontent .= '</ul></div>';
        } 

        if(!empty($product_cons)) {
            $beforecontent .= '<div class="product-cons">';
            $beforecontent .= '<strong>'.__('Product Cons:', 'dina-kala').'</strong>';
                $beforecontent .= '<ul>';
                    foreach ( (array) $product_cons as $key => $cons ) {
                        $ctitle = '';
                        if ( isset( $cons['ctitle'] ) ) {
                            $ctitle = esc_html( $cons['ctitle'] );
                        }
                        if(!empty($ctitle)){
                        $beforecontent .= '<li>'.$ctitle.'</li>';
                        }
                    }
            $beforecontent .= '</ul></div>';
        } 
        
        if ($di_data['show_pros_top']) {
            $content = $beforecontent . $content;
        } else {
            $content = $content . $beforecontent;
        }
        
        return $content;
    } else {
        return $content;
    }
}

//Add WooCommerce the_excerpt before the_content
add_filter('the_content', 'dina_before_woo_content',11);
function dina_before_woo_content($content) {
    global $di_data;
    global $post;
    if(is_product() && !empty($post->post_excerpt) && !$di_data['replace_features'])
    {
        $beforecontent = '<blockquote class="prod-excerpt blockquote">';
        $beforecontent .= '<i class="fal fa-pen-alt" aria-hidden="true"></i>';
        $beforecontent .= $post->post_excerpt;
        $beforecontent .= '</blockquote>';
        $content = $beforecontent . $content;
        return $content;
    } else {
        return $content;
    }
}

//Remove tabs heading
add_filter( 'woocommerce_product_additional_information_heading','dina_return_empty');
add_filter( 'woocommerce_product_description_heading','dina_return_empty');
function dina_return_empty() {
    return '';
}

//Add Show More Button before WooCommerce Product the_content
if($di_data['show_more']){
    add_filter('the_content', 'dina_before_woo_content_show_more',9);
    }
function dina_before_woo_content_show_more($content) {
    global $post;
    global $di_data;

    if(is_product())
    {
        $beforecontent = '<div class="post-sh dina-more-less" data-more="'.__('Show More','dina-kala').'" data-less="'.__('Show Less','dina-kala').'">';
        $afterecontent = '</div>';
        
        $content = $beforecontent . $content;
        $content = $content . $afterecontent;
        
        return $content;
    } else {
        return $content;
    }
}

//Change additional information tab title
add_filter( 'woocommerce_product_tabs', 'dina_rename_tabs', 98 );
function dina_rename_tabs( $tabs ) {
    global $product;
    global $di_data;
    if( $product->has_attributes() || $product->has_dimensions() || $product->has_weight() ) {
        $tabs['additional_information']['title'] = __( 'Product Features', 'dina-kala' );
    }
    // Additional information tab - shows attributes.
    if ( $product && ( !$product->has_attributes() && $di_data['remove_dimensions'] ) ) {
        unset($tabs['additional_information']);
    }
    return $tabs;
}

//Hide Price Range for WooCommerce Variable Products
if($di_data['remove_price_range']) {
    add_filter( 'woocommerce_variable_sale_price_html', 'dina_variable_product_price', 10, 2 );
    add_filter( 'woocommerce_variable_price_html', 'dina_variable_product_price', 10, 2 );
    
function dina_variable_product_price( $v_price, $v_product ) {
    global $di_data;
    // Product Price
    $prod_prices = array( $v_product->get_variation_price( 'min', true ), 
                                $v_product->get_variation_price( 'max', true ) );

    if($di_data['show_max_price']) {
        $prod_price = $prod_prices[0]!==$prod_prices[1] ? wc_price( $prod_prices[1] ) : wc_price( $prod_prices[1] );
    } else {
        $prod_price = $prod_prices[0]!==$prod_prices[1] ? wc_price( $prod_prices[0] ) : wc_price( $prod_prices[0] );
    }

    // Regular Price
    $regular_prices = array( $v_product->get_variation_regular_price( 'min', true ), 
                            $v_product->get_variation_regular_price( 'max', true ) );
    sort( $regular_prices );

    if($di_data['show_max_price']) {
        $regular_price = $regular_prices[0]!==$regular_prices[1] ? wc_price( $regular_prices[1] ) : wc_price( $regular_prices[1] );
    } else {
        $regular_price = $regular_prices[0]!==$regular_prices[1] ? wc_price( $regular_prices[0] ) : wc_price( $regular_prices[0] );
    }

    if ( $prod_price !== $regular_price ) {
    $prod_price = '<del>'.$regular_price.$v_product->get_price_suffix() . '</del> <ins>' . 
                        $prod_price . $v_product->get_price_suffix() . '</ins>';
    }
    return $prod_price;
    }
}

//Hides the product’s weight and dimension in the single product page.
if($di_data['remove_dimensions']){
    add_filter( 'wc_product_enable_dimensions_display', '__return_false' );
}

//remove product's attr link
function filter_woocommerce_attribute_value( $value ) { 
    return preg_replace( '#<a.*?>([^>]*)</a>#i', '$1', $value );
}
if($di_data['remove_attr_link']){
    add_filter( 'woocommerce_attribute', 'filter_woocommerce_attribute_value', 99 );
}

//Dina get product attributes
function dina_get_product_attributes( $id ) {

    global $product;
    global $di_data;

    $count = (int)$di_data['features_tab_count'];

    if ( ! is_a($product, 'WC_Product') ) {
        $product = wc_get_product( $id );
    }

    if ( is_a($product, 'WC_Product') ) {
        $html = []; // Initializing
        $i = 0;
        foreach ( $product->get_attributes() as $attribute => $values ) {
            if ($i == $count) { 
                break;
            }
            $attribute_name = wc_attribute_label($values->get_name());
            $attribute_data = $values->get_data();
            $is_taxonomy    = $attribute_data['is_taxonomy'];

            $option_values    = array(); // Initializing

            // For taxonomy product attribute values
            if( $is_taxonomy ) {
                $terms = $values->get_terms(); // Get attribute WP_Terms
                // Loop through attribute WP_Term(s)
                foreach ( $terms as $term ) {
                    $option_values[] = $term->name;
                }
            }
            // For "custom" product attributes values
            else {
                // Loop through attribute option values
                foreach ( $values->get_options() as $term_name ) {
                    $option_values[] = $term_name;
                }
            }

            $html[] = '<li><span class="ftitle">' . $attribute_name . '</span>: <span class="fdesc">' . implode(', ', $option_values). '</span></li>';
            $i++;
        }

        return '<ul>' . implode('', $html) . '<ul>';
    }
}

//dina_product_update_date
if($di_data['show_prod_up_date']) {
add_action('woocommerce_product_meta_end', 'dina_product_update_date', 13);
}

function dina_product_update_date() {
    global $product;
?>
<span class="update_date_wrapper"><?php echo __('Date Updated:','dina-kala') ?>
    <span class="product-update-date"><?php echo get_the_modified_time('j F Y');  ?></span>
</span>
<?php
}