<?php
/*
Theme Designed By: Meysam Hosseinkhani
Email: Meysam98@Gmail.com
Author Website: Hosseinkhani.ir
*/
   // Exit if accessed directly
   if (!defined('ABSPATH')) {
    exit;
}

class rc_sweet_custom_menu {
   	/*--------------------------------------------*
   	 * Constructor
   	 *--------------------------------------------*/
   	/**
   	 * Initializes the plugin by setting localization, filters, and administration functions.
   	 */
   	function __construct() {
   		// add custom menu fields to menu
   add_filter( 'wp_setup_nav_menu_item', array( $this, 'rc_scm_add_custom_nav_fields' ) );
   // save menu custom fields
   add_action( 'wp_update_nav_menu_item', array( $this, 'rc_scm_update_custom_nav_fields'), 10, 3 );
   // edit menu walker
   add_filter( 'wp_edit_nav_menu_walker', array( $this, 'rc_scm_edit_walker'), 10, 2 );
   add_action( 'admin_enqueue_scripts', 'admin_menu_icon_styles' );
   	} // end constructor
   
   /* All functions will be placed here */
   /**
    * Add custom fields to $item nav object
    * in order to be used in custom Walker
    *
    * @access      public
    * @since       1.0 
    * @return      void
   */
   function rc_scm_add_custom_nav_fields( $menu_item ) {
   
       $menu_item->icon = get_post_meta( $menu_item->ID, '_menu_item_icon', true );
       $menu_item->icon_image = get_post_meta( $menu_item->ID, '_menu_item_icon_image', true );
       $menu_item->image = get_post_meta( $menu_item->ID, '_menu_item_image', true );
       $menu_item->cimage = get_post_meta( $menu_item->ID, '_menu_item_cimage', true );
       $menu_item->cmega = get_post_meta( $menu_item->ID, '_menu_item_cmega', true );
       return $menu_item;
   
   }
   /**
    * Save menu custom fields
    *
    * @access      public
    * @since       1.0 
    * @return      void
   */
   function rc_scm_update_custom_nav_fields( $menu_id, $menu_item_db_id, $args ) {
   
       // Check if element is properly sent
       if ( is_array( $_REQUEST['menu-item-icon']) ) {
           $icon_value = $_REQUEST['menu-item-icon'][$menu_item_db_id];
           update_post_meta( $menu_item_db_id, '_menu_item_icon', $icon_value );
       }
       else {
            $icon_value = "";
           update_post_meta( $menu_item_db_id, '_menu_item_icon', $icon_value );
        }

        if ( isset( $_REQUEST['menu-item-icon-image'][$menu_item_db_id]) ) {
            $icon_image_value = $_REQUEST['menu-item-icon-image'][$menu_item_db_id];
            update_post_meta( $menu_item_db_id, '_menu_item_icon_image', $icon_image_value );
        }
        else {
            $icon_image_value = "";
            update_post_meta( $menu_item_db_id, '_menu_item_icon_image', $icon_image_value );
        }

       if ( isset( $_REQUEST['menu-item-image'][$menu_item_db_id]) ) {
           $image_value = $_REQUEST['menu-item-image'][$menu_item_db_id];
           update_post_meta( $menu_item_db_id, '_menu_item_image', $image_value );
       }
       else {
           $image_value = "";
           update_post_meta( $menu_item_db_id, '_menu_item_image', $image_value );
       }

       if ( isset( $_REQUEST['menu-item-cimage'][$menu_item_db_id]) ) {
           $cimage_value = $_REQUEST['menu-item-cimage'][$menu_item_db_id];
           update_post_meta( $menu_item_db_id, '_menu_item_cimage', $cimage_value );
       }
       else {
           $cimage_value = "";
           update_post_meta( $menu_item_db_id, '_menu_item_cimage', $cimage_value );
       }

       if ( isset($_REQUEST['menu-item-cmega'][$menu_item_db_id]) ) {           
           $cmega_value = $_REQUEST['menu-item-cmega'][$menu_item_db_id];
           update_post_meta( $menu_item_db_id, '_menu_item_cmega', $cmega_value );
       }
       else {
           $cmega_value = "";
           update_post_meta( $menu_item_db_id, '_menu_item_cmega', $cmega_value );
       }
   
   }
   /**
    * Define new Walker edit
    *
    * @access      public
    * @since       1.0 
    * @return      void
   */
   function rc_scm_edit_walker($walker,$menu_id) {
       return 'Walker_Nav_Menu_Edit_Custom';
   }
   }
   include_once( 'edit_custom_walker.php' );
   // instantiate plugin's class
   $GLOBALS['sweet_custom_menu'] = new rc_sweet_custom_menu();
      