<?php 

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

global $di_data;

//Dina Footer Codes

add_action( 'wp_footer', 'dina_footer_codes' );

if ($di_data['maintenance'] && !current_user_can('administrator'))
{
    remove_action( 'wp_footer', 'dina_footer_codes' );
}
function dina_footer_codes() {
global $di_data; ?>
<div class="overlay-blur"></div>

    <?php if($di_data['show_return_top'] && !$di_data['return_top_style_two']) { ?>
    <div id="back-top">
        <a href="#top">
            <i class="fal fa-chevron-up" aria-hidden="true"></i>
        </a>
    </div>
    <?php } ?>

    <?php if($di_data['show_social_btn']) {
        $social_side = ($di_data['social_btn_left']?' social-right':' social-left'); ?>
    <div class="di-socialbtn<?php if($di_data['social_btn_mobile']) {echo ' social-mobile';} echo $social_side;?>">

        <a aria-label="<?php echo $di_data['social_btn_title']; ?>" href="<?php echo $di_data['social_btn_link']; ?>" data-title="<?php echo $di_data['social_btn_title']; ?>" data-toggle="tooltip" data-placement="top" title="<?php echo $di_data['social_btn_title']; ?>">
            <span class="di-socialbtn-one <?php echo $di_data['social_btn_icon']; ?>" aria-hidden="true"></span>
        </a>
        <?php if($di_data['show_second_social_btn']) { ?>
        <a class="di-second-socialbtn" aria-label="<?php echo $di_data['second_social_btn_title']; ?>" href="<?php echo $di_data['second_social_btn_link']; ?>" data-title="<?php echo $di_data['second_social_btn_title']; ?>" data-toggle="tooltip" data-placement="top" title="<?php echo $di_data['second_social_btn_title']; ?>">
            <span class="di-socialbtn-two <?php echo $di_data['second_social_btn_icon']; ?>" aria-hidden="true"></span>
        </a>
        <?php } ?>
    </div>
    <?php } ?>
    
    <!-- side cart -->
    <div id="mySideCart" class="sidecart">
        <div class="side-head">
        <a href="javascript:void(0)" class="mclosebtn" aria-label="<?php echo __('Close', 'dina-kala'); ?>" data-title="<?php echo __('Close', 'dina-kala'); ?>" rel="nofollow" onclick="closeCart()">
            <i class="fal fa-times" aria-hidden="true"></i>
        </a>
        <div class="side-title">
             <i class="fal fa-shopping-bag" aria-hidden="true"></i> <?php echo __( 'Shopping Cart', 'dina-kala' ); ?>
        </div>
        </div>
        <div class="widget_shopping_cart_content">
            <?php woocommerce_mini_cart() ?>
        </div>
        <i class="fal fa-bags-shopping side-icon" aria-hidden="true"></i>
    </div>
    <div id="myCanvasCart" class="overlay3" onclick="closeCart()"></div>
    <!-- side cart -->

    <?php if($di_data['ch_login_link'] || !is_user_logged_in()) { ?>
    <!-- side login -->
    <div id="mySideLogin" class="sidelogin">
        <div class="side-head">
            <a href="javascript:void(0)" class="mclosebtn" aria-label="<?php echo __('Close', 'dina-kala'); ?>" data-title="<?php echo __('Close', 'dina-kala'); ?>" rel="nofollow" onclick="closeLogin()">
                <i class="fal fa-times" aria-hidden="true"></i>
            </a>
            <div class="side-title">
                <i class="fal fa-user-circle" aria-hidden="true"></i> <?php echo __( 'Login to the site', 'dina-kala' ); ?>
            </div>
        </div>
        <?php if (function_exists('digits_version') && $di_data['digits_mode']) { $digits_class = ' digits-login'; } else { $digits_class='';} ?>
        <form name="login_form" class="login_form <?php echo $digits_class; ?>" id="login_form" action="#" method="post">
            <div class="row">
                <div class="col-12">
                <div class="status"></div>
                <div class="form-group">
                    <div class="input-group">
                    <div class="input-group-prepend" id="basic-addon1">
                        <span class="input-group-text">
                        <i class="fal fa-user" aria-hidden="true"></i>
                        </span>
                    </div>
                    <input name="username" type="text" class="form-control" id="username" placeholder="<?php echo __('Username','dina-kala'); ?>" required="required" />
                    </div>
                </div>
                <div class="form-group">
                    <div class="input-group">
                    <div class="input-group-prepend" id="basic-addon2">
                        <span class="input-group-text">
                        <i class="fal fa-key" aria-hidden="true"></i>
                        </span>
                    </div>
                    <input name="password" type="password" class="form-control" id="password" placeholder="<?php echo __('Password','dina-kala'); ?>" required="required" />
                    </div>
                </div>
                <a href="<?php echo wp_lostpassword_url(); ?>" title="<?php echo __('Reset password','dina-kala'); ?>" class="lost-password"><?php echo __('Reset password','dina-kala'); ?></a>
                <a <?php if($di_data['ch_register_link']) {echo 'href="'.$di_data['register_link'].'"'; } else {echo 'href="' .esc_url(home_url()).'/my-account"';} ?> class="pregisterlink"><?php echo __('Create an account', 'dina-kala'); ?></a>
                <?php if($di_data['recapcha_login']) { ?>
                <div class="g-recaptcha" data-sitekey="<?php echo $di_data['site_key']; ?>"></div>
                <?php } ?>
                <?php wp_nonce_field( 'ajax-login-nonce', 'security' ); ?>
                <button class="btn btn-success plogin-btn" id="loginSubmit">
                    <i class="fal fa-user" aria-hidden="true"></i><?php echo __('  Login to the site','dina-kala'); ?>
                </button>
                </div>
            </div>
        </form>
        <i class="fal fa-user-circle side-icon" aria-hidden="true"></i>
    </div>
    <div id="myCanvasLogin" class="overlay3" onclick="closeLogin()"></div>
    <!-- side login -->
    <?php } ?>

    <?php if (is_user_logged_in()) { ?>
    <!-- side user-menu -->
    <div id="myUmenu" class="usermenu">
        <div class="side-head">
            <a href="javascript:void(0)" class="closebtn" aria-label="<?php echo __('Close', 'dina-kala'); ?>" data-title="<?php echo __('Close', 'dina-kala'); ?>" rel="nofollow" onclick="closeUmenu()">
                <i class="fal fa-times" aria-hidden="true"></i>
            </a>
            <?php 
                $user = wp_get_current_user(); 
                echo get_avatar(get_current_user_id() , 65,'' ,$user->display_name ); ?>
            <span class="side-uname">
                <?php echo $user->display_name; ?>
            </span>
            <?php
            if (class_exists( 'WooWallet' ))
            {       
                $wallet = woo_wallet()->wallet->get_wallet_balance( get_current_user_id() );
                echo '<span class="m-wallet">'.__('Wallet Inventory: ','dina-kala').$wallet.'</span>';
            }
            ?>
        </div>
        <?php if($di_data['replace_user_menu'] && has_nav_menu('user_menu')) { ?>
        <?php
            wp_nav_menu( array(
                'menu'              => 'user_menu',
                'theme_location'    => 'user_menu',
                'menu_class'        => 'usmenu',
                'depth'             => 1,
                'container'         => ''
                )
            );
        ?>
        <?php } else { ?>
            <ul class="usmenu">
                <?php get_template_part('includes/umenu'); ?>
            </ul>
        <?php } ?>
        
        <i class="fal fa-id-card side-icon" aria-hidden="true"></i>
    </div>
    <div id="myCanvasUser" class="overlay3" onclick="closeUmenu()"></div>
    <!-- side user-menu -->
    <?php } ?>

    <!-- mobile menu -->
    <div id="myNav" class="sidenav">
        <div class="side-head<?php if($di_data['mobile_search']) { echo ' nsearch'; } ?>">

            <a href="javascript:void(0)" class="mclosebtn" aria-label="<?php echo __('Close', 'dina-kala'); ?>" data-title="<?php echo __('Close', 'dina-kala'); ?>" rel="nofollow" onclick="closeNav()">
                <i class="fal fa-times" aria-hidden="true"></i>
            </a>

            <?php if($di_data['show_mobile_logo']) { ?>
                <a href="<?php echo esc_url(home_url()); ?>" title="<?php bloginfo('name'); ?> | <?php bloginfo('description'); ?>" rel="home">
                <?php 
                    $logo_width = (!empty($di_data['site_logo']['width'])) ? $di_data['site_logo']['width'] : '160';
                    $logo_height = (!empty($di_data['site_logo']['height'])) ? $di_data['site_logo']['height'] : '57'; ?>
                    <img <?php if($di_data['site_schema']) {?>itemprop="logo" <?php } ?> src="<?php echo $di_data['site_logo']['url']; ?>" srcset="<?php echo $di_data['site_logo_retina']['url']; ?> 2x" width="<?php echo $logo_width; ?>" height="<?php echo $logo_height; ?>" alt="<?php bloginfo('name'); ?> | <?php bloginfo('description'); ?>" title="<?php bloginfo('name'); ?> | <?php bloginfo('description'); ?>" class="mobile-menu-logo img-logo"/>
                </a>
            <?php } ?>

            <?php if(!$di_data['mobile_search']) { ?>
                <form class="msform" role="search" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                    <?php if(!$di_data['search_others']) { ?>
                        <input type="hidden" name="post_type" value="product" />
                    <?php } ?>
                    <div class="input-group search-form">
                        <?php 
                        if ( $di_data['search_cat'] ) {
                        $categories = get_terms("product_cat");
                        if ( !empty( $categories ) && !is_wp_error( $categories ) ) { ?>
                        <div class="input-group-before prod-cat">
                            <?php echo '<select name="product_cat" >';
                            echo '<option value="">'.__("Category",'dina-kala').'</option>';
                            foreach ( $categories as $category ) {
                            echo '<option value="'.$category->slug.'">'.$category->name.'</option>';
                            }
                            echo '</select>'; ?>
                        </div>
                        <?php } }?>
                        <input autocomplete="off" name="s" type="text" class="form-control search-input" placeholder="<?php echo __("Search", 'dina-kala'); ?>" aria-label="<?php _e("Search", 'dina-kala'); ?>" required>
                        <div class="input-group-append">
                            <button class="btn btn-search" type="submit" aria-label="<?php echo __("Search", 'dina-kala'); ?>">
                                <i class="fal fa-search" aria-hidden="true"></i>
                            </button>
                        </div>
                    </div>
                </form>
            <?php } ?>

        </div>
        <?php
        $dina_remove_parent_link = ($di_data['remove_parent_link'] ? ' dina-remove-parent-link' : '');
        ?>                            
        <nav id="cssmenu" class="dina-mobile-menu<?php echo $dina_remove_parent_link; ?>" <?php if($di_data['site_schema']) {?>itemscope itemtype="https://schema.org/SiteNavigationElement"<?php } ?>>
            <?php
            if($di_data['replace_mobile_menu']) {
                wp_nav_menu(array(
                    'menu'              => 'mobile_menu',
                    'theme_location'    => 'mobile_menu',
                    'container_id' => 'cssmenu',
                    'fallback_cb'       => 'CSS_Menu_Maker_fallback',
                    'walker' => new CSS_Menu_Maker_Walker()
                ));
            } else {
                wp_nav_menu(array(
                    'menu'              => 'mega_menu',
                    'theme_location'    => 'mega_menu',
                    'container_id' => 'cssmenu',
                    'fallback_cb'       => 'CSS_Menu_Maker_fallback',
                    'walker' => new CSS_Menu_Maker_Walker()
                ));
            }
            
            ?>
       </nav>

       <i class="fal fa-file-search side-icon" aria-hidden="true"></i>

    </div>

    <div id="myCanvasNav" class="overlay3" onclick="closeNav()"></div>
    <!-- mobile menu -->
<?php }

if(!empty($di_data['footer_codes'])) {
    add_action( 'wp_footer', 'dina_js_footer_codes' );
}

function dina_js_footer_codes() { 
    global $di_data;
    print_r($di_data['footer_codes']) . "\n";
}